/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: ovhd_rx.c
;
;   Functions for implementing VDSL embedded operations channel (EOC).
;
;***************************************************************************/
// ***********************************************************************************************************
// ovhd_rx.c
//
// History
//
// 07/05/2013 ChihWen: Segmenting the block-read-ack message once its length is more than buffer size.
//                  1. For NVLT-C CO, replacing multi-read-ack with block-read-ack message.
//                  2. Properly segmenting the block-read-ack message once its length is more than buffer size.
//            Grep for: XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1056: VDSL2 US ReTx Overhead message changes for US ReTx Receive"
//    reception of below things in  response  to  a  Single  Read  command  if US retransmission is enabled
//      -  ETR (RTX Receiver Expected Throughput)
//      - delay_act_RTX (RTX Receiver Actual Delay)
//       Modified the code so as to capture FE management counters in ReTx mode as below if US retransmission is enabled
//       - rtx-c(counter of corrected DTU)
//       - rtx-uc( counter of uncorrected DTU)
//       - Counter of ''leftr'' defect seconds
//       - Counter of error free bits
//       -   EFTR_min
//      grep for XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//       Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//      - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//      - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
// 30/08/2013 Ram: Counter 'rtx-tx' (count of no. of retransmitted DTUs) was missed while decoding Mgmt counter
//                 read command response from CO. This resulted in incorrect decoding of futher params like
//                 FEC-ES, ES, SES etc. Fixed the issue now.
//                 Grep for XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode
//
//  10/09/2013 Sooraj: Added Support of DS-SRA with ReTx
//                 Grep for XDSLRTFW-1031_OLR Type-5 request for DS-SRA in DS-ReTx mode
//
// 29/10/2013 Anantha Ramu: Modifications done to receive INP values( REIN & SHINE) used in the calculation of
//                          ATTNDR with attndr_method set to 1 or 2.
//                          Grep for: XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd
//
//  29/10/2013 Sooraj: Added Support of US-SRA with ReTx
//                 Grep for XDSLRTFW-1262_OLR Type-5 request for US-SRA in US-ReTx mode
//                          XDSLRTFW-1263_DTU_Stoppage_Handling
//
// 21/11/2013 Palaksha: Fix for "XDSLRTFW-1380 US ReTx + US SRA: UnCorrected DTUs observed during US SRA(DownShift and UpShift)
//               with REIN noise and SHINE"
//               It is observed that on some SRA transitions few uncorrected DTUs are observed with REIN and SHINE noise.
//            Root cause for the problem is
//                   (1) Starting of RRC evaluation after every SRA was not always right (ii) In DTU stoppage time calculation
//                    old new framing params used instead of Old ones.
//            Solution includes: (i) New implementaion done for RRC evaluation after every SRA
//                  (ii) In DTU stoppage time calculation use Old framing params
//            grep for XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine
//
// 26/05/2014  Varun : Added support for Scalar Read command(optional feature)
//
//                     Note that SNRM_ROC is not implemented as ROC implementation is not avalable and NACK will be sent if SNRM_ROC
//                     is requested through scalar read
//                     Grep for XDSLRTFW-1777
// 06/08/2014  Fuss : OHC stuck for segmented Rx testparameter Blk-Read (seen against NVLT-C) and
//                    code clean-up for function Rx_ovhd_msg_handler().
//                    Grep for XDSLRTFW-1929
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2341".
//
// 07/09/2017 Vinay: XDSLRTFW-3444: ERB vectoring control settings are not correct in showtime
//                    Analyse/decode all the ERB messages which are used to start the ERB transmission because
//                    - Stop messages do not include the right information (e.g. L_w may be 0 or F_block != 1)
//                    - the configuration may change in showtime
//                    Moved the ERB-Descriptor initialization to showtime configuration function
//                    Grep for "XDSLRTFW-3444"
//
// 10/10/2017 Abu Rahman
// XDSLRTFW-3071: US & DS ATP reporting is swapped
//     Variables contains the DS ActATP and US ActATP were wrongly (swapped) populated.
//     - Fixed the variable initialization.
//     - Fixed variables population for DS ActATP and US ActATP
//     - Fixed HDLC messages relating to these variables both for Showtime and diag mode
//     - Changed two structure names
//       1. old name: gt_G997_NeSignalAndMarginParams, new name: gt_LineStatusDS
//       2. old name: gt_G997_FeSignalAndMarginParams, new name: gt_LineStatusUS
//     Grep for XDSLRTFW-3071.
//
// 09/03/2018 Stefan Krause
// XDSLRTFW-3735 - US-Bitswap Timeout
//    Issue: US BAT on CO and CPE side get out of sync if
//           - processing of the US bitswaps gets delayed due to ongoing background tasks by more than 400ms and
//           - CO sends sends out the next bitswap request immediately after timing out the 1st one
//           In this case it:
//           - CO does not get any response within the max timout time of 400ms
//           - CO discards the bitswap and sends out immediately a new bitswap requests
//           - CPE receives the 2nd bitswap request and resets the timeout-timer
//           - CPE processes the 1st bitswap, but check the timeout by using the timeout-timer of the 2nd bitswap (bug)
//           - CPE uses BAT of 1st bitswap request, while CO expects the BAT of the 2nd one
//
// 20/12/2018 Abu Rahman
//            XDSLRTFW-4051 Fast downstream up shift SRA
//            This code supports Fast downstream up shift SRA
//            Maximum bits loaded/tone = 5
//            This feature is enabled by DTAG bit (CMV DSL 21 0 1) only against vectoring and BRCM based DSLAM.
//
//            Some other controls are done by CNFG 93 cmv
//            CNFG 93 0:
//             bit 0:
//                - value 0x8000: disable feature "Fast downstream up shift SRA"
//                - value 0x0000: enable  feature "Fast downstream up shift SRA" for BRCM CO and any  vector engine
//                - value 0x0001: enable  feature "Fast downstream up shift SRA" for BRCM CO and BRCM vector engine

//            CNFG 93 1:
//             - value 0xFFFF: do not disable feature "Fast downstream up shift SRA" in showtime
//             - value      X: disable feature "Fast downstream up shift SRA" after X sec of Showtime
//                             (supported range: 0-32767 sec, debug range 0-65534 sec)
//            CNFG 93 2:
//             - value 0xFFFF: Never disable DS-SRAs in Showtime
//             - value      Y: Disable DS SRAs if CPE receive 3 consecutive SRA rejections with rejection code SRA "not enabled"
//                             (0x3) after Y sec of Showtime (supported range: 0-32767 sec, debug range 0-65534 sec)
//            Example:
//            DSL 21[0] : 1 -DTAG bit enabled
//            CNFG 93[0]: 0 - meaning feature is enabled for all kind of VCE
//            CNFG 93[1]: 100 - Fast DS up shift SRA is enabled for 100 sec in Showtime
//            CNFG 93[2]: 200 - After 200 sec of Showtime if three consecutive SRA rejection come with SRA not enabled
//                              exception code (0x3) then DS SRA request will be disabled
//            Default CMV configuration: if DTAG bit is enabled
//            CNFG 93[0] = 0
//            CNFG 93[1] = 255
//            CNFG 93[2] = 255
//            Grep for XDSLRTFW-4005

// ************************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "eoc.h"
#include "dsp_op.h"
#include "fcs.h"
#include "show_test_iof.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "profile.h"
#include "ToneReorder.h"
#include "vdsl_xception.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "BitswapHandler.h"
#include "SharedFuncs.h"
#include "mul.h"
#include "show_iof.h"
#include "BitswapDecision_VDSL2.h"
#include "ShowtimeERBHandler.h"
#include "FormRErrorFeedbackMsg_VDSL2.h"

#define MAX_BS_NUM_TONES   128

uint16 gus_EocDbgDropResp=0;
extern uint8 guc_SRAState;
extern ReTX_ShowtimeParams_t gt_UsReTxShowtimeParams;

FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, int16* ps_retCode);
void Abandon_DS_OLRPM(void);
void Abandon_US_OLRPM(void);
//#ifdef MTK_VECTORING_SUPPORT
void Unpack12BitsPairST(int16 s_NumberOfPairs, uint8 *puca_ByteBuf, int16 *psa_LSBword, int16 *psa_MSBword);
// ANXQ_SUPPORT
void Unpack16BitsPairST(int16 *ps_PtrMsgIndex, int16 s_NumberOfPairs, uint8 *puca_ByteBuf, int16 *psa_LSBword, int16 *psa_MSBword);

//#endif
int16 ComputeLinearPSD(int16 s_Tone, PSDDescriptorTable_t *pt_PSDDesc);
FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, int16* ps_retCode);
FlagT SRA_ReTx_Parameters_Check(void);

extern void db_to_linear(int16 s_dB_input, int16 *ps_lin_mant, int16 *ps_lin_exp);

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : UsOvhdMsg_Timeout_Handler(uint8 uc_priority_index )
 *
 *  Description:  This subroutine handles the Rx EOC ovhd request timeout
 *
 *  Prototype:
 *      void  UsOvhdMsg_Timeout_Handler(uint8 uc_priority_index )
 *
 *  Input Arguments:
 *       uc_priority_index: the ovhd msg priority index
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void UsOvhdMsg_Timeout_Handler(int32 l_PriorityIndex)
{
   int32 l_EocSymCntDelta;

   // gl_RxSymbolCount and ptxEocControlInfo->lRxSymCnt are positive
   // but the difference could be negative if gl_RxSymbolCount wraps
   l_EocSymCntDelta = gl_RxSymbolCount -  gla_RxMessageTimer[l_PriorityIndex];
   if (l_EocSymCntDelta < 0) // account for wrap around
   {
      l_EocSymCntDelta += MAX_32;
   }

   // For priority 0 message, timeout after 400ms
   // For priority 1 message, timeout after 800ms
   // For priority 2 message, timeout after 1000ms
   switch(l_PriorityIndex)
   {
   case OVHD_HIGH_PRIORITY:
      // The standard specifies 400ms timeout period
      if (l_EocSymCntDelta < (gus_EocFramesPer100ms << 2)) // 400ms
      {
         return;   // no timeout
      }

      // XDSLRTFW-3735 - US-Bitswap Timeout
      // This point is reached if:
      // - US OLR times out (after 400ms)
      // - Processing of DS EOC message in the background has not yet been finished
      //   The message has not yet been decoded
      if (gt_TxOLRVars.uc_txOLRState == L0_STEADY_STATE)
      {
         // set marker "gus_OlrDiscardCnt" to ensure that message will be skipped
         gus_OlrDiscardCnt++;
         // Disable timeout check
         gft_UsOlrInProgress = FALSE;
      }
      break;

   case OVHD_NORMAL_PRIORITY:
      break;

   case OVHD_LOW_PRIORITY:
      break;
   } // switch
}



/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : void CheckUSEocTimeOut(void)
 *
 *  Description: This subroutine checks of there is a HLC message timeout
 *
 *  Prototype:
 *     void CheckRxUScTimeOut(void)
 *
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

void CheckUSEocTimeOut(void)
{
   int32 l_PriorityIndex;
   //TxEocControl_t *pt_TxEocControlInfo;

   for (l_PriorityIndex = 0; l_PriorityIndex < MAX_OVHD_PRIORITY; l_PriorityIndex++)
   {
      // @todo: we would need a timer start indication per prio!!
      if (gft_UsOlrInProgress == TRUE)
      {
         // For priority 0 message, timeout after 400ms
         // For priority 1 message, timeout after 800ms
         // For priority 2 message, timeout after 1s
         UsOvhdMsg_Timeout_Handler(l_PriorityIndex);
      }
   }
}



/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT IsTxBandLoaded(int16 s_Band)
*
*   This function determines if a given TX band is loaded or not.
*
*   Input Arguments:
*      s_Band: band index
*
*   Output Arguments:
*
*   Returns:
*      1 if loaded, 0 if unloaded
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

FlagT IsTxBandLoaded(int16 s_Band)
{
   int16 s_ch, s_TxBandLeftChannel, s_TxBandRightChannel;

   s_TxBandLeftChannel = gt_TxBandControl_Act.ut_BandRecord[s_Band].us_FirstTone;
   s_TxBandRightChannel = gt_TxBandControl_Act.ut_BandRecord[s_Band].us_LastTone;

   // check first if the band is disabled
   if ((s_TxBandLeftChannel == 0) && (s_TxBandRightChannel == 0))
   {
      return (FlagT)0;
   }

   for (s_ch=s_TxBandLeftChannel; s_ch<=s_TxBandRightChannel; s_ch++)
   {
      if (ghpuca_TxBat_Inactive[s_ch] == 0)
      {
         continue;
      }
      else
      {
         return (FlagT)1;   // this band is loaded!
      }
   }

   return (FlagT)0;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EocTrail
 *
 *  Description:
 *
 *  Prototype:
 *     void EocTrail(uint8 trailDelim, uint8 uc_message_designator, uint8 uc_message_type,
 *                    uint16 us_msg_length);
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *
 *  Notes:
 *------------------------------------------------------------------------
 *^^^
 */
void EocTrail(uint8 trailDelim, uint8 uc_message_designator, uint8 uc_message_type,
              uint16 us_msg_length)
{
#ifdef DEBUG_TRAIL
   // This code is needed for DCT tool analysis of EOC traffic. With Storing only the header a
   // nice statistic can be build up.
   if ((gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_EOC_ENABLE) ||
         (gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_EOC_HEADER_ENABLE))
   {
      int16 s_count;

      s_count = 5;
      if(gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_EOC_HEADER_ENABLE)
      {
         // The length should not be stored in the trail buffer. This is needed to get an easy wrap
         // around handling, i.e. since the trail buffer is 512bytes the blocks to be stored must be
         // multiple of each other.
         s_count = 4;
         // To avoid double storing of Tx messages
         if((trailDelim == EOC_TRAIL_TXDELIM) && (us_msg_length != 0))
         {
            return;
         }
      }

      DebugTrail1(s_count,DEBUG_TRAIL_EOC_ENABLE,0,
                  (uint16)DEBUG_TRAIL_SHOW_EVENTS_EOC | trailDelim,
                  (uint16)gl_RxSymbolCount,
                  (uint16)(gl_RxSymbolCount>>16),
                  (uint16)((uc_message_type<<8) | uc_message_designator),
                  (uint16)(us_msg_length));
   }
#endif // DEBUG_TRAIL
}

/*****************************************************************************
*   Subroutine Name: Rx_ovhd_msg_handler
*
*   Description:
*      This subroutine processes the received overhead message.
*
*   Prototype:
*       void Rx_ovhd_msg_handler(void)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*
******************************************************************************/
void Rx_ovhd_msg_handler(void)
{
   TxEocControl_t *pt_TxEocControlInfo;
   uint8 uc_PriorityField;
   uint8 uc_DesignatorField;

   // save the current msg length
   gus_eoc_msg_len = gus_rx_msg_index;

   // If we got valid overhead message, we will process it based on its content
   if (guca_rx_eoc_msg_buffer[0] < MAX_OVHD_PRIORITY)
   {
      // Evaluate/store "Address field"
      uc_PriorityField = guca_rx_eoc_msg_buffer[0] & 0x3;
      gt_RxEocMsg.message_priority = uc_PriorityField;
      pt_TxEocControlInfo = &gta_TxEocControlInfo[uc_PriorityField];

      // Check "Control field" of the received message
      // Bit0 Alternating bit -> not used for VDSL
      // Bit1 Command bit -> 0 = Cmd
      //                     1 = Resp
      {
         uint8 uc_ControlField;

         uc_ControlField = guca_rx_eoc_msg_buffer[1];
         uc_DesignatorField = guca_rx_eoc_msg_buffer[2];

         // Store "Control field"
         gt_RxEocMsg.cntrl_field = uc_ControlField;

         // Extract the alternating bit of the "Control field"
//         uc_new_or_old_bit = (uc_ControlField & 0x1);

         if (uc_ControlField & 0x2)
         {
            // response
            if (!pt_TxEocControlInfo->ft_ack_expected)
            {
               gus_EocAckExpErr++;
               return;
            }

            if (uc_DesignatorField != pt_TxEocControlInfo->uc_ExpectedDesignator)
            {
               gus_EocDesignatorErr++;
               return;
            }

            pt_TxEocControlInfo->s_TotalRespRecv++;
            pt_TxEocControlInfo->ft_ack_expected = FALSE;

            if (pt_TxEocControlInfo->uc_Source == ME_CMD_SOURCE)
            {
               // store the received response message length.
               if ((gus_eoc_msg_len - 4) < MAX_ME_EOC_MSG_SIZE)
               {
                  gt_ME_EocParams.s_ME_EocRxMsgLength = gus_eoc_msg_len - 4;
               }
               else
               {
                  gt_ME_EocParams.s_ME_EocRxMsgLength = MAX_ME_EOC_MSG_SIZE;
               }

#ifdef CLEAR_EOC
               // Copy the received buffer to Rx ME EOC buffer
               // 1st two bytes are address field and control field and the last two bytes are the FCS bytes
               // so skip the 1st two and the last two bytes
               memcpy(gt_INFO_CEocRxBuf.uca_MEMsg, &guca_rx_eoc_msg_buffer[2], gt_ME_EocParams.s_ME_EocRxMsgLength);
#endif
            }
         } // if response
         else
         {
            // Command
            pt_TxEocControlInfo->s_TotalCmdRecv++;
         }
      }

      if (gus_EocDbgDropResp) // for testing - drop the msg
      {
         return;
      }

      // Handling different priority queues!
      {
         TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;

         // Prepare Input for function TxEocSendRequest()!
         memset(&t_TxOvhdMsgInfoInput,0,sizeof(t_TxOvhdMsgInfoInput));
         t_TxOvhdMsgInfoInput.uc_message_designator = uc_DesignatorField;
         t_TxOvhdMsgInfoInput.uc_message_type = guca_rx_eoc_msg_buffer[3];
         t_TxOvhdMsgInfoInput.us_numbytes = gus_eoc_msg_len;

#ifdef OVHD_MSG_SEGMENTATION
         //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START)
         //if ((guca_rx_eoc_msg_buffer[2] != (SEGMENT_ACK_PRIOR0|uc_PriorityField))
         //   && (gsa_Tx_OvhdMsgSegIndx[uc_PriorityField]>= 1))
         //{
         //        gus_EocSegmentAck++;
         //   return; //don't process any msg other than segment ACK if we are expecting it
         //}
         //// segment ack recieved, process it
         //else if (guca_rx_eoc_msg_buffer[2] == (SEGMENT_ACK_PRIOR0|uc_PriorityField))
         //{
         //        gus_EocSegmentAck++;
         //   rx_segment_ack_handler(uc_PriorityField, guca_rx_eoc_msg_buffer, &t_TxOvhdMsgInfoInput);
         //}
         if (uc_DesignatorField == (SEGMENT_ACK_PRIOR2|uc_PriorityField))
         {
            gus_EocSegmentAck++;
            rx_segment_ack_handler(uc_PriorityField, guca_rx_eoc_msg_buffer, &t_TxOvhdMsgInfoInput);
         }
         //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (END)
         else
#endif
         {
            // Process overhead message based on its priority category
            switch(uc_PriorityField)
            {
            case OVHD_HIGH_PRIORITY:
               Rx_prior0_ovhd_msg_handler(guca_rx_eoc_msg_buffer, &t_TxOvhdMsgInfoInput);
               break;

            case OVHD_NORMAL_PRIORITY:
               Rx_prior1_ovhd_msg_handler(guca_rx_eoc_msg_buffer, &t_TxOvhdMsgInfoInput,
                                          pt_TxEocControlInfo);
               break;

            case OVHD_LOW_PRIORITY:
               Rx_prior2_ovhd_msg_handler(guca_rx_eoc_msg_buffer, &t_TxOvhdMsgInfoInput);
               break;
            }
         }
      }
   } // if (guca_rx_eoc_msg_buffer[0] < MAX_OVHD_PRIORITY)
   else
   {
      gus_EocBadPrioVal++;
   }
}

/*****************************************************************************
*   Subroutine Name: Rx_prior0_ovhd_msg_handler
*
*   Description:
*      This subroutine processes the received overhead message*

  *   Prototype:
  *       void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, &t_TxOvhdMsgInfoInput)
  *
  *   Input Arguments: Message Buffer
  *
  *   Output Arguments: none
  *
  *   Return: none
******************************************************************************/
void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
//#ifdef MTK_VECTORING_SUPPORT
   switch(puca_msg_buffer[2])
   {

   case RECONFIG_CMD_DESIG:
      rx_reconfig_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;

   case EOC_CMD_G9935_ERRORFB_DESIG:
      rx_eoc_ErrorFB_msg_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;
   }
//#endif
}

/*****************************************************************************
*   Subroutine Name: Rx_prior1_ovhd_msg_handler
*
*   Description:
*      This subroutine processes the received overhead message
*
*   Prototype:
*      void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void Rx_prior1_ovhd_msg_handler(uint8* puca_msg_buffer,
                                TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,
                                TxEocControl_t *pt_TxEocControlInfo)
{
   // Form message based on message designator
   switch(puca_msg_buffer[2])
   {

   case EOC_CMD_DESIG:
      rx_eoc_msg_handler(puca_msg_buffer, t_TxOvhdMsgInfoInput,
                         pt_TxEocControlInfo);
      break;

   case TIME_CMD_DESIG:
      rx_time_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;

   case INVENTORY_CMD_DESIG:
      rx_inventory_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;

      // XDSLRTFW-650 / XDSLRTFW-1384
   case POWER_MGMT_CMD_DESIG:
      rx_power_mgmt_rd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;
      // XDSLRTFW-650 / XDSLRTFW-1384

   case MGMT_CNTR_RD_CMD_DESIG:
      rx_mgmt_par_rd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;


   case CLEAR_EOC_CMD_DESIG:
      rx_clear_eoc_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;

   case NSF_FACILITY_CMD_DESIG:
      rx_nsf_facility_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      break;

//#ifdef MTK_VECTORING_SUPPORT
   case EOC_CMD_G9935_UPDATE_PILOTSEQ_DESIG:
      rx_eoc_G9935_PilotUpdate_msg_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      //DSM_Vectoring_Debug:
      //if (gs_PauseControl == 0x25)
      //Pause(gs_PauseControl);

      break;
//#endif
   }
}

/*****************************************************************************
*   Subroutine Name: Rx_prior2_ovhd_msg_handler
*
*   Description:
*      This subroutine processes the received overhead message
*
*   Prototype:
*      void Rx_prior2_ovhd_msg_handler(uint8* puca_msg_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void Rx_prior2_ovhd_msg_handler(uint8* puca_msg_buffer,
                                TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   if(puca_msg_buffer[2] == PMD_TEST_PAR_RD_CMD_DESIG)
   {
      rx_test_param_rd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
   }
   else if( puca_msg_buffer[2] == NSF_FACILITY_LOW_CMD_DESIG)
   {
      rx_nsf_facility_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
   }
}

/*****************************************************************************
*   Subroutine Name: rx_time_cmd_handler
*
*   Description:
*      This subroutine processes the received overhead message
*
*   Prototype:
*      void rx_time_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_time_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 i, j;
   int32 l_Action;      // 1 - send message; 0 - do nothing

   uint16 total;

   TxEocControl_t *ptxEocControlInfo;

   uc_msg_type = puca_buffer[0];

   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if (uc_msg_type == SET_TIME || TIME_READ_ACK == uc_msg_type)
   {
      i = 1;
      for (j = 0; j < 3; j++)
      {
         // The international standard notation for the time of day is hh:mm:ss
         // where hh is the number of complete hours that have passed since
         // midnight (00-23), mm is the number of complete minutes that have
         // passed since the start of the hour (00-59), and ss is the number of
         // complete seconds since the start of the minute (00-59).
         total = 0;
         total = 10 * total + (puca_buffer[i++] - '0');
         total = 10 * total + (puca_buffer[i++] - '0');


         // The CPE received a SET_TIME command from the CO-- so sync the time
         if (0==j)
         {
            gt_TimeStat.us_FETime_HH = gt_TimeStat.us_RunningTime_HH = (uint8)total;
         }
         else if (1==j)
         {
            gt_TimeStat.us_FETime_MM = gt_TimeStat.us_RunningTime_MM = (uint8)total;
         }
         else if (2==j)
         {
            gt_TimeStat.us_FETime_SS = gt_TimeStat.us_RunningTime_SS = (uint8)total;
         }


         //next byte is (:) character
         i++;
      } // for

      if (uc_msg_type == SET_TIME)
      {
         t_TxOvhdMsgInfoInput->uc_message_type = TIME_ACK;
      }
      else
      {
         ptxEocControlInfo = &gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY];
         CheckMsgPendingFlags(ptxEocControlInfo->uc_ExpectedDesignator,
                              uc_msg_type, ptxEocControlInfo->ft_MECmd, 0);

         l_Action = 0;
      }

      // Copy Current Counters to Previous and Reset TR1 clock
      //gt_G997_Cntrl.s_Cntr_Reset_Control = 5;
   } // if (uc_msg_type == SET_TIME || TIME_READ_ACK == uc_msg_type)
   else if (uc_msg_type == TIME_READ)
   {
      t_TxOvhdMsgInfoInput->uc_message_type = TIME_READ_ACK;
   }
   else if (uc_msg_type == TIME_ACK)
   {
      ptxEocControlInfo = &gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY];
      CheckMsgPendingFlags(ptxEocControlInfo->uc_ExpectedDesignator,
                           uc_msg_type, ptxEocControlInfo->ft_MECmd, 0);

      l_Action = 0;
   }

   if (l_Action)
   {
      TxEocSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
}

/*****************************************************************************
*   Subroutine Name: sendTxOLRResponse
*
*   Description:
*      This subroutine sends the OLR response
*
*   Prototype:
*       void sendTxOLRResponse(uint8 uc_msg_type, uint8 uc_defer_reason_code,uint8 uc_internal_error_code, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/
void sendTxOLRResponse(uint8 uc_msg_type, uint8 uc_defer_reason_code,uint8 uc_internal_error_code, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_temp;

   t_TxOvhdMsgInfoInput->uc_defer_reason_code = uc_defer_reason_code;

   // XDSLRTFW-1262_OLR Type-5 request for US-SRA in US-ReTx mode (START)
   // Response message for OLR. When Bit 2 or 3 sets, prepare the Response message
   // with the appropriate message format
   uc_temp = (uc_msg_type & 0xC)?(uc_msg_type-3):uc_msg_type;
   // XDSLRTFW-1262_OLR Type-5 request for US-SRA in US-ReTx mode (END)

   t_TxOvhdMsgInfoInput->uc_message_type = uc_temp | 0x80;

   if (uc_msg_type == SRA_RETX_REQ)
   {
      // Update the SRA reject count as per the location in gt_UsOLRPMCnt
      uc_msg_type = SRA_REQ;
   }

   Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg_type, UTC_RESP_CNT);

   TxEocSendRequest(0 /* priority */, *t_TxOvhdMsgInfoInput);

}

/*****************************************************************************
*   Subroutine Name: rx_reconfig_cmd_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received OLR message
*
*   Prototype:
*       void rx_reconfig_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/

void rx_reconfig_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type, uc_msg, uc_msg_reject_code;
   int16 s_retCode, s_Nf, s_temp;
   FlagT ft_BiGi_changed,ft_reject=0;
   int8 s_lp,s_bc;
   FlagT s_Flag;
   VDSL2Config_t *pt_Config;
   //XDSLRTFW-2341 (Start - End)
   FlagT ft_non_IDILV;
   pt_Config = &gt_tx_config_v2;
   // clear Respone Retransmit Count
   gt_TxOLRVars.s_ResponseReXmitCnt = 0;

   // Get the OLR message type
   uc_msg_type = *puca_buffer++;

   s_retCode = 0;
   s_Nf = 0;
   ft_BiGi_changed = FALSE;

   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {

   case DRR_REQ:
      break;

   case SRA_REQ:
   case SRA_RETX_REQ:
   case BITSWAP_REQ:

      uc_msg = uc_msg_type;
      if (uc_msg_type == SRA_RETX_REQ)
      {
         // Update the SRA reject count as per the location in gt_UsOLRPMCnt
         uc_msg = SRA_REQ;
      }

      // UPdate the count for corresponding message type
      Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, SIMPLE_REQ_CNT);

      // XDSLRTFW-3735 - US-Bitswap Timeout
      // If FW detects that an US OLR requests cannot be processed on time the "Discarded counter" is increased (gus_OlrDiscardCnt>0).
      // As we can't delete an EOC message easily from the message queue we check here whether the current OLR message has already been
      // timed out.
      // In this case we do not process this OLR request anymore.
      // Instead FW
      // 1. decreases OlrDiscardCnt counter to show that the the discarded OLR request has been rejected in a proper way
      // 2. increases OLR counter (OLR NOT due due because of timeout)
      // 3. skips OLR processing for this OLR request
      if (gus_OlrDiscardCnt > 0)
      {
         gus_OlrDiscardCnt--;
         Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, TIMEOUT_CNT);
         DSH_SendEvent(DSH_EVT_ABANDON_OLR,sizeof(uint8),(void *)&uc_msg);
         break;
      }

      // Once receive request, set OLR Status CMV and clear OLR Error CMV
      // uc_msg_type: Bitswap/DRR/SRA/Plus_Bitswap request
      //STATArray[STAT_OLRStatus_US] = (uc_msg_type<<4);
      //STATArray[STAT_OLRError_US] = 0;

      // Check if in L0 State
      if (gt_TxOLRVars.uc_txOLRState != L0_STEADY_STATE)
      {
         sendTxOLRResponse(uc_msg_type, RESP_BUSY, REQ_NOT_IN_L0_STATE, t_TxOvhdMsgInfoInput);
         Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, UNEXPECTED_OLR_ERROR_CNT);
         gft_UsOlrInProgress = FALSE;
         break;
      }

      if ((uc_msg_type == BITSWAP_REQ) && (gft_EnableTxBitSwap == FALSE))
      {
         sendTxOLRResponse(uc_msg_type, RESP_BUSY, REQ_ACTION_DISABLED, t_TxOvhdMsgInfoInput);
         Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, UTC_RESP_CNT);
         gft_UsOlrInProgress = FALSE;
         break;
      }


      // XDSLRTFW-1262_OLR Type-5 request for US-SRA in US-ReTx mode (START END)
      if (((uc_msg_type == SRA_REQ) || (uc_msg_type == SRA_RETX_REQ)) && (gft_EnableTxSRA == FALSE))
      {
         sendTxOLRResponse(uc_msg_type, RESP_BUSY, REQ_ACTION_DISABLED, t_TxOvhdMsgInfoInput);
         Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, UTC_RESP_CNT);
         gft_UsOlrInProgress = FALSE;
         break;
      }

      // Extract Lp value for SRA request
      // Update the new Lp/Bp/Tp/Gp/Dp values for active latency path: LP0
      if (uc_msg_type == SRA_REQ)
      {
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
         for ( s_lp = 0; s_lp < pt_Config->s_Nlp; s_lp++)
         {
            /* Lp value */
            {
               uint32 ul_temp;

               ul_temp = 0;
               // ANXQ_SUPPORT
               if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
               {
                  ul_temp = (*puca_buffer++ << 16);
               }
               ul_temp |= (*puca_buffer++ << 8);               // "OR" can be done always, because the variable
               ul_temp |= (*puca_buffer++);                    // "ul_temp" gets be cleared at the begin.
               pt_Config->ul_Reconfig_Lp[s_lp] = ul_temp;
            }

            /* Dp value */
            s_temp = (int16)(*puca_buffer++ << 8);
            s_temp |= (int16)(*puca_buffer++);
            if (pt_Config->s_Dp[s_lp] != s_temp)
            {
               ft_reject = TRUE;
            }
            else
            {
               pt_Config->s_Reconfig_Dp[s_lp] = s_temp;
            }

            /* Tp octet */
            s_temp = (int16)(*puca_buffer++);

            if (pt_Config->s_Tp[s_lp] != s_temp)
            {
               ft_reject = TRUE;
            }
            else
            {
               pt_Config->s_Reconfig_Tp[s_lp] = s_temp;
            }

            /* Gp octet */
            s_temp = (int16)(*puca_buffer++);

            if (pt_Config->s_Gp[s_lp] != s_temp)
            {
               ft_reject = TRUE;
            }
            else
            {
               pt_Config->s_Reconfig_Gp[s_lp] = s_temp;
            }

            /* Bpn value */
            s_temp = (int16)(*puca_buffer++);
            s_bc = gt_tx_TPS_Map.s_LPtoABC[s_lp];

            if (pt_Config->sa_Bpn[s_lp][s_bc] != s_temp)
            {
               ft_reject = TRUE;
            }
            else
            {
               pt_Config->sa_Reconfig_Bpn[s_lp][s_bc] = s_temp;
            }
         }
      }
      // XDSLRTFW-1262_OLR Type-5 request for US-SRA in US-ReTx mode (START)
      else if (uc_msg_type == SRA_RETX_REQ)
      {
         /* Lp value */
         {
            uint32 ul_temp;

            ul_temp = 0;
            // ANXQ_SUPPORT
            if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
            {
               ul_temp = (*puca_buffer++ << 16);
            }
            ul_temp |= (*puca_buffer++ << 8);                  // "OR" can be done always, because the variable
            ul_temp |= (*puca_buffer++);                       // "ul_temp" gets be cleared at the begin.
            pt_Config->ul_Reconfig_Lp[LP1] = ul_temp;
         }

         /* B10 value */
         pt_Config->sa_Reconfig_Bpn[LP1][ABC0] = (int16)(*puca_buffer++);

         /* M1 value */
         gt_UsReTxShowtimeParams.s_Reconfig_Mp = (int16)(*puca_buffer++);

         /* R1 value */
         gt_UsReTxShowtimeParams.s_Reconfig_Rp = (int16)(*puca_buffer++);

         /* RS CW per DTU */
         gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q = (*puca_buffer++);
         //XDSLRTFW-2341 (Start)
         ft_non_IDILV = TRUE;
         if(gft_US_IDILV_ucode == TRUE)
         {
            if(gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q & 0x80)
            {
               ft_non_IDILV = FALSE;
            }
            gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q &= 0x7F;
            if(gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q == 1)
            {
               ft_non_IDILV = FALSE;
            }
         }
         //XDSLRTFW-2341 (End)
         /* padding octets per DTU */
         gt_UsReTxShowtimeParams.uc_DtuPaddingSize_V = (*puca_buffer++);

         /* Delay in DTU between two consecutive transmissions of a DTU */
         gt_UsReTxShowtimeParams.uc_RPMS_Qtx = (*puca_buffer++);

         /* Look-back value used to calculate the values communicated in the RRC */
         gt_UsReTxShowtimeParams.uc_RPMS_DsLookBackValue = (*puca_buffer++);

         ft_reject = SRA_ReTx_Parameters_Check();
         //XDSLRTFW-2341 (Start)
         if((gft_US_IDILV_ucode == TRUE) && (ft_non_IDILV == TRUE))
         {
            ft_reject = TRUE;
         }
         if(ft_reject == FALSE)
         {
            if(gft_US_IDILV_ucode == TRUE)
            {
               gft_IDILV_US_SRA_event = TRUE;
            }
         }
         //XDSLRTFW-2341 (End)
      }
      // XDSLRTFW-1262_OLR Type-5 request for US-SRA in US-ReTx mode (END)
      else
      {
         gt_tx_config_v2.ul_Reconfig_Lp[LP0] = gt_tx_config_v2.ul_Lp[LP0] ;
      }
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
      // Extract the Nf parameter
      // s_Nf high octet
      s_Nf = (int16)(*puca_buffer++ << 8);
      // s_Nf low octet
      s_Nf |= (int16)(*puca_buffer++);   // Number of subcarriers
      s_Flag = ExtractBinsInfo(puca_buffer, s_Nf, &s_retCode);

      // Check if any bins changed and valid request
      if ((s_Flag == FALSE) && (ft_reject == FALSE))
      {
         // we got valid OLR parameters
         //STATArray[STAT_OLRStatus_US] |= STAT_OLRPM_IN_PROGRESS;

         // Perform the tone reordering
         gft_ToneOrderOK = ReorderTRT_Tx();

         // Set the new BAT table and FineGain table
         if (gft_ToneOrderOK == TRUE)
         {
            ft_BiGi_changed = TRUE;
         }
      }

      // One of these flags will be set only if we have a valid US OLR request
      if (ft_BiGi_changed )
      {
         gt_TxOLRVars.uc_txOLRState = OLR_SEND_SYNC_INDICATOR;

         if (uc_msg_type == BITSWAP_REQ)
         {
            gt_TxOLRVars.s_ReconfigSymCnt = BITSWAP_RECONFIG_SYMBOL;
         }
         else if (uc_msg_type == SRA_REQ)
         {
            gt_TxOLRVars.s_ReconfigSymCnt = SRA_RECONFIG_SYMBOL;
            // Flag to change Lp value for SRA request
            gt_TxOLRVars.s_txOLRPMEvent = RECONFIG_Lp;
         }
         // XDSLRTFW-1263_DTU_Stoppage_Handling (START)
         else if (uc_msg_type == SRA_RETX_REQ)
         {
            // Update the SRA reject count as per the location in gt_UsOLRPMCnt
            gt_TxOLRVars.s_ReconfigSymCnt = (int16)Calc_TDTU_stoppage();
            gt_TxOLRVars.s_ReTxSymCnt = -1;//initial state
            gt_TxOLRVars.uc_txOLRState = OLR_SEND_RTX_SYNC_INDICATOR;
            // Flag to change Lp value for SRA request
            gt_TxOLRVars.s_txOLRPMEvent = RECONFIG_Lp;
         }
         // XDSLRTFW-1263_DTU_Stoppage_Handling (END)
         Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, PERFORM_CNT);
      }
      // else US OLR request has invalid parameters -- send appropriate response
      else
      {
         Abandon_US_OLRPM();
         Update_OLRPMCnt(&gt_UsOLRPMCnt, uc_msg, TIMEOUT_CNT);
         sendTxOLRResponse(uc_msg_type, RESP_INVALID_PARAMETERS, (uint8)s_retCode, t_TxOvhdMsgInfoInput);
      }

      gt_TxOLRVars.s_ResponseReXmitCnt++;
      //STATArray[STAT_OLRStatus_US] |= (gt_TxOLRVars.s_ResponseReXmitCnt<<8);

      // XDSLRTFW-3735 - US-Bitswap Timeout
      // If BG task was interrupted between start and end of there a message has been discarded due to timeout
      // In this case we will process the OLR message
      if (gus_OlrDiscardCnt > 0)
      {
         gus_OlrDiscardCnt--;
      }
      break;

   case DEFER_BITSWAP:
   case DRR_REJECT:
   case SRA_REJECT:
      // XDSLRTFW-1031_OLR Type-5 request for DS-SRA in DS-ReTx mode (START)
      // When SRA and retransmission are simultaneously enabled, the modems use OLR response Type 5 to reject SRA request.
   case SRA_RETX_REJECT:
      uc_msg = uc_msg_type;
      uc_msg_reject_code = *puca_buffer++;

      if (uc_msg_type == SRA_RETX_REJECT)
      {
         // Update the SRA reject count as per the location in gt_UsOLRPMCnt
         uc_msg = SRA_REJECT;
      }
      // XDSLRTFW-1031_OLR Type-5 request for DS-SRA in DS-ReTx mode (END)
      Update_OLRPMCnt(&gt_DsOLRPMCnt, (int16)(uc_msg & 0x3), (int16)UTC_RESP_CNT);

      // XDSLRTFW-3367 (Start)
      // Update the counters
      if ((uc_msg_type == SRA_RETX_REJECT) || (uc_msg_type == SRA_REJECT))
      {
         if (uc_msg_reject_code == 0x1)
         {
            gt_DS_OLR_Reject_t.t_SRA.us_Busy++;
            gs_SraNotEnableRejectionCnt = 0;  // reset continuous SRA not enabled (0x3) rejection code counter
         }
         else if (uc_msg_reject_code == 0x2)
         {
            gt_DS_OLR_Reject_t.t_SRA.us_Invalid_Parameters++;
            gs_SraNotEnableRejectionCnt = 0;  // reset continuous SRA not enabled (0x3) rejection code counter
         }
         else if (uc_msg_reject_code == 0x3)
         {
            gt_DS_OLR_Reject_t.t_SRA.us_Not_Enabled++;
            if (gt_FastDsSraConfig.us_TimeAfterShowtimeToCheckForRejection_3 == 0)
               gs_SraNotEnableRejectionCnt++;  // XDSLRTFW-4051 count continuous SRA not enabled (0x3) rejection code
         }
         else if (uc_msg_reject_code == 0x4)
         {
            gt_DS_OLR_Reject_t.t_SRA.us_Not_Supported++;
            gs_SraNotEnableRejectionCnt = 0;  // reset continuous SRA not enabled (0x3) rejection code counter
         }
      }
      else if (uc_msg_type == DEFER_BITSWAP)
      {
         if (uc_msg_reject_code == 0x1)
         {
            gt_DS_OLR_Reject_t.t_Bitswap.us_Busy++;
         }
         else if (uc_msg_reject_code == 0x2)
         {
            gt_DS_OLR_Reject_t.t_Bitswap.us_Invalid_Parameters++;
         }
         else if (uc_msg_reject_code == 0x3)
         {
            gt_DS_OLR_Reject_t.t_Bitswap.us_Not_Enabled++;
         }
         else if (uc_msg_reject_code == 0x4)
         {
            gt_DS_OLR_Reject_t.t_Bitswap.us_Not_Supported++;
         }
      }
      // XDSLRTFW-3367 (End)

      // @mahesh:  For UNH adding a test feature to disable/skip SRA so that other functions using
      // overhead channel get a chance to run
      if(TESTArray[TEST_ReconfigControl] & TEST_AbandonSRA )
      {
         guc_SraReject++;
         if (guc_SraReject > 3)
         {
            gft_BlockSRA=TRUE;
            //XDSLRTFW-1379
            guc_SRAState = SRA_DONE;
            gft_USRAInitiate = FALSE;
            gs_UTIME_Count=0;//set number of seconds up shift condition to zero
            gft_DSRAInitiate = FALSE;
            gs_DTIME_Count=0;//set number of seconds down shift condition to zero
            guc_SraReject =0;
         }
      }
      // record error status and error code in OLR cmv
      // According to EOC msg format, the second byte following reject msg type will
      // be the error code
      //STATArray[STAT_OLRError_DS] = *puca_buffer++;
      //STATArray[STAT_OLRStatus_DS] &= ~STAT_OLRPM_IN_PROGRESS;
      //STATArray[STAT_OLRStatus_DS] |= STAT_OLRPM_ABORTED|STAT_OLRPM_RESPONSE;

      // XDSLRTFW-4051 Fast downstream up shift SRA(start)
      // Disable Downstream SRA request if CO sends SRA rejection with SRA not enabled rejection code(0x3) for more
      // than three consecutive times in case of Fast downstream up shift SRA is enabled.
      if ((gus_FastDsSraControl & FAST_DS_SRA_USED_IN_PRESENT_LINK) && (gs_SraNotEnableRejectionCnt > 3))
      {
         guc_SRAState = SRA_DONE;

         gft_EnableRxAutoSRA = FALSE; // Disable Auto SRA
         gl_SRATotalLp_Delta = 0; // reseted desired Lp change for the current SRA task
         gl_SRATotalLp_DeltaCnt = 0;  //reseted running count of the Lp bits changes in the current SRA task

         gft_USRAInitiate = FALSE;
         gs_UTIME_Count=0;//set number of seconds up shift condition to zero

         gft_DSRAInitiate = FALSE;
         gs_DTIME_Count=0;//set number of seconds down shift condition to zero

         gus_FastDsSraControl = 0;

      }
      //XDSLRTFW-4051 Fast downstream up shift SRA(End)
      // If a defer OLR message received, don't wait for sync indicator anymore

      // Currently, we simply restore the original configuration
      // An alternative would be to resend the message
      Abandon_DS_OLRPM();

      break;

   default:
      break;
   }

}

//#ifdef MTK_VECTORING_SUPPORT
/*****************************************************************************
*   Subroutine Name: rx_eoc_ErrorFB_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Description:
*      This subroutine processes the received Vectoring EOC CMD message
*
*   Prototype:
*       void rx_eoc_ErrorFB_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/

void rx_eoc_ErrorFB_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   int16 i;
   int16 s_idx = 0, s_NumOfVecRxBands;
   uint16 us_temp, us_SegmentIdx;
   uint8 uc_Temp;
   uint8 uc_msg_type;
   uint8 uc_SendNack = 0;
   uint32 ul_NumOfBits_Segment = 0;
   FlagT ft_ERB_Params_Changed;
   uint8 uc_G9935_mParams = 0;
   int16 sa_RxVecBandLeftChannel[ MAX_NUM_RX_VEC_BANDS];
   int16 sa_RxVecBandRightChannel[MAX_NUM_RX_VEC_BANDS];
   uint16 usa_Header_Length[MAX_NUM_ERB_SEGMENTS];
   uint16 usa_NumTones[MAX_NUM_RX_VEC_BANDS];
   uint16 usa_erb_size[MAX_NUM_RX_VEC_BANDS];
   uint16 usa_Lw[MAX_NUM_RX_VEC_BANDS];
   uint16 usa_Fsub[MAX_NUM_RX_VEC_BANDS];
   int16 us_last_segment = 0;    // This variable is used as loop counter
   int us_remaining_tone;     // This variable is used to find the tones that was present before the loop counter exited
   // XDSLRTFW-3752 (Start)
   // This variable is used to store the sampling rate
   // 0 --> Legacy or 35B profile
   // 1 --> 30A profile
   uint8 uc_fdmt = 0;

   uint32 ul_N_ERB = 0;    // This gives the total size of ERB of all the segments (including header, payload data and CRC)
   uint32 ul_ERB_BDR = 0;  // This is BDR computed. This needs to be attached to a CMV
   // XDSLRTFW-3752 (End)

   gt_ShowtimeErbParams.ul_RxSymbolCount_StartERBCalc = gl_RxSymbolCount;
   gt_ShowtimeErbParams.us_RxFrmCount_StartERBCalc    = gs_RxPMDFrameCount;
   uc_msg_type =  puca_buffer[s_idx++];     // Table8-3/G993.5 Octet 2 ( value 0x1)

   switch(uc_msg_type)
   {

   case CMD_TYPE_ERROR_FB_REQUEST:
      // States in showtime
      // EOC_ERB_TRANSMISSION_STATE
      //    0: ST_ERBS_OFF                      : ERB are turned off
      //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
      //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
      guc_EOC_ERB_TRANSMISSION_STATE = GET_NEW_ST_ERB_CONFIGURATION;

      gt_ShowtimeErbParams.us_Msg_Type                   = uc_msg_type;

      // Initialize new ERB structure
      for(i = 0; i< MAX_NUM_RX_VEC_BANDS; i++) // MAX_NUM_RX_BANDS = 9
      {
         sa_RxVecBandLeftChannel[ i] =  0;
         sa_RxVecBandRightChannel[i] =  0;
      }

      // Table 8-3 Error Feedback command transmitted by the VTU-O / G993.5
      // Octet 3 & 4 : First SSC
      us_temp  = (uint16) puca_buffer[s_idx++]<<8;
      us_temp |= (uint16) puca_buffer[s_idx++];

      // gt_ShowtimeErbParams.us_First_SSC: Special value 0xFFFF indicates that this is the 1st ERROR-FB request
      if (gt_ShowtimeErbParams.us_First_SSC == 65535)
      {
         gt_ShowtimeErbParams.us_First_SSC        = us_temp;

         // SSC: Sync Symbol Counter
         // The VTU-O shall keep a downstream sync symbol counter (SSC) (MODULO N_SSC), counting
         // continuously during Showtime. The value N_SSC shall be selected by the VCE and transmitted during
         // initialization to the VTU-R in O-SIGNATURE (see clause 10.3.2.1). The counter value of the first
         // downstream sync symbol transmitted after entering Showtime shall be set by the VCE and transmitted
         // to VTU-R in the field First SSC of the Error Feedback command
         gs_RxSuperFrmCnt = gs_RxSuperFrmCnt_in_Showtime + us_temp;
         gs_RxSuperFrmCnt &= 0x3FF; // MODULO 1024 (//gs_DSVec_N_SSC)
      }
      else
      {
         gt_ShowtimeErbParams.us_First_SSC        = us_temp;      // for debugging
      }

      // increment counter for this type of EOC message
      // this is for debugging purpose in order to match the request count on CO and CPE side
      // other wise we only needed a flag to indicate first time message receive.
      gul_EOC_ErrorFB_CMD_count++;
      gt_ShowtimeErbParams.us_EOC_ErrorFB_CMD_count++;            // for debugging

      // Table 8-3 Error Feedback command transmitted by the VTU-O / G993.5
      // Octet 5 : Error sample update period (m)
      //           The error sample update period (m) shall be represented as an unsigned integer
      uc_G9935_mParams = puca_buffer[s_idx++];
      gt_ShowtimeErbParams.us_ErrorSampleUpdatePeriod_m = uc_G9935_mParams;

      // Table 8-3 Error Feedback command transmitted by the VTU-O / G993.5
      // Octet 6 & 7 : Error sample shift period (z)
      //               The error sample shift period (z) shall be represented as an unsigned integer
      us_temp  = (uint16) puca_buffer[s_idx++]<<8;
      us_temp |= (uint16) puca_buffer[s_idx++];
      gt_ShowtimeErbParams.us_ErrorSampleShiftPeriod_z = us_temp;

      // XDSLRTFW-3444: VRx518: ERB handling against Huawei CO not as expected in ST vectoring
      //Analyze/decode all the ERB messages which are used to start the ERB transmission because
      // - Stop messages do not include the right information (e.g. L_w may be 0 or F_block != 1)
      // - the configuration may change in showtime
      if (uc_G9935_mParams)
      {
         // Table 8-3 Error Feedback command transmitted by the VTU-O / G993.5
         // Octet: 8 to 8 + 3 * N_band :  Vectored bands descriptor

         // Table 12-18 or 12-22/G993.2  Bands descriptor
         // Decode and Store Vectored Band Descriptor  Table 12-18/G993.2  octet 8 to 8+3*gs_NumOfVecRxBands
         // Get the used DS bands

         // -----------------------------------------------------------------------------
         // Table 12-18 or 12-22/G993.2  Bands descriptor
         // Table 12-22 / G993.2_AnxQ    Bands descriptor
         // -----------------------------------------------------------------------------
         // Octet Content of field: 17MHz mode
         //     1 Number of bands to be described
         //   2-4 Bits  0-11: Index of the first subcarrier in band 1
         //       Bits 12-23: Index of the last  subcarrier in band 1
         //   5-7 Bits  0-11: Index of the first subcarrier in band 2 (if applicable)
         //       Bits 12-23: Index of the last  subcarrier in band 2 (if applicable)
         // -----------------------------------------------------------------------------
         // Octet Content of field: 35MHz mode
         //     1 Number of bands to be described
         //   2-5 Bits  0-15: Index of the first subcarrier in band 1
         //       Bits 16-31: Index of the last  subcarrier in band 1
         //   6-9 Bits  0-15: Index of the first subcarrier in band 2 (if applicable)
         //       Bits 16-31: Index of the last  subcarrier in band 2 (if applicable)
         // -----------------------------------------------------------------------------
         s_NumOfVecRxBands = (int16) puca_buffer[s_idx++];
         gt_ShowtimeErbParams.us_Nband_BandConfig =  s_NumOfVecRxBands;
         // INPUT-DATA VALIDATION
         // Number of vectoring bands
         // Stop analysis and send NACK message to CO is number of bands is not in the valid range
         if ((s_NumOfVecRxBands < 1) || (s_NumOfVecRxBands > 8))   // number of band are beyound the standard
         {
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = EOC_G9935_INVALID_PARAMS;
            gt_ShowtimeErbParams.us_EOC_ErrorFB_Parameter_Mismatch_count++;
            uc_SendNack = 1;
            break;
         }

         // ANXQ_SUPPORT
         // REVIEW_STEFAN: Why do we have different approaches/functions for unpacking the ERB subcarriers
         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
         {
            Unpack16BitsPairST(&s_idx, s_NumOfVecRxBands, puca_buffer, sa_RxVecBandLeftChannel, sa_RxVecBandRightChannel);
         }
         else
         {
            Unpack12BitsPairST(s_NumOfVecRxBands, &(puca_buffer[s_idx]), sa_RxVecBandLeftChannel, sa_RxVecBandRightChannel);
            s_idx += s_NumOfVecRxBands*3;
         }

         for(i = 0; i< MAX_NUM_RX_VEC_BANDS; i++)
         {
            gt_ShowtimeErbParams.usa_RxVecBandLeftChannel[ i] =  sa_RxVecBandLeftChannel[ i];
            gt_ShowtimeErbParams.usa_RxVecBandRightChannel[i] =  sa_RxVecBandRightChannel[i];
            gt_ShowtimeErbParams.usa_VectoredBandParams[i] = 0;
         }

         // Table 8-3  Error Feedback command transmitted by the VTU-O / G993.5
         // 9 + 3 * N_band to 9 + 5 * N_band : Error report configuration descriptor
         //Decode and Store Error report configuration Descriptor  Table 8-4/G993.5 (octet 0)

         //  Error report configuration descriptor
         // Parameter | Bits  | Octet number | Description
         // N_band    | [7:4] |            0 | The number of configured vectored bands in the range from 1 to 8 represented as an unsigned integer
         // padding   |    3  |              | As defined in clause 7.2.2
         // reserved  |    2  |              | Shall be set to 0
         // F_block   | [1:0] |              | Blocksize: 0: F_block = ceil(N_carrier/F_sub)
         //                                               1: F_block =  1
         //                                               2: F_block = 32
         //                                               3: F_block = Reserved by ITU
         // Parameter |       |          1-2 |
         // VecBand 1 |
         // Parameter |       |          1-2 |
         // VecBand n |       | 2*n-1 to 2*n |
         uc_Temp = puca_buffer[s_idx++];
         gt_ShowtimeErbParams.us_Nband_ERBConfig = (uc_Temp >> 4);
         gt_ShowtimeErbParams.uc_Padding         = (uc_Temp >> 3) & 0x1;
         gt_ShowtimeErbParams.uc_Fblock          = (uc_Temp & 0x3);

         // We support only "F_block = 1" and all other values are not being supported.
         if ( (s_NumOfVecRxBands != gt_ShowtimeErbParams.us_Nband_ERBConfig) // number of band and band configuration descriptors do not match
               || (gt_ShowtimeErbParams.uc_Fblock == 0x3)   // invalid Fblock configuration
               || (gt_ShowtimeErbParams.uc_Fblock == 0x2)   // F_block = 32 not supported
               || (gt_ShowtimeErbParams.uc_Fblock == 0x0) ) // F_block = ceil(N_carrier/F_sub) not supported
         {
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = EOC_G9935_INVALID_PARAMS;
            gt_ShowtimeErbParams.us_EOC_ErrorFB_Parameter_Mismatch_count++;
            uc_SendNack = 1;
            break;
         }

         // important : need some more check about the error feedback control parameter
         //XDSLRTFW-3507 (Start)
         //Reset the ERB_Params_Changed parameter, if any of the ERB Params has changed compared to previous message, this will be set to TRUE
         ft_ERB_Params_Changed = FALSE;
         for(i = 0; i < s_NumOfVecRxBands; i++)
         {
            // Store Control parameters for Vectored bands Table 8-4/G993.5
            // Table 8-5 / G993.5  Vectored band control parameters
            // Parameter | Bits  | Octet number | Description
            // F_sub     | [7:4] |            0 | Sub-sampling rate F_sub with with log2(F_sub) represented as unsigned integer.
            // L_w       | [3:0] |            0 | Length of the clipped error sample in compressed representation with L_w represented as an unsigned integer.
            // B_min     | [7:4] |            1 | Parameter B_min with B_min represented as an unsigned integer
            // B_max     | [3:0] |            1 | Parameter B_max with B_max represented as an unsigned integer

            // VB Control Parameter Formatting
            // Value       Bits
            // --------------------
            // F_sub      [15:12]
            // L_w        [11:8]
            // B_min      [7:4]
            // B_max      [3:0]
            us_temp = ((uint16)puca_buffer[s_idx++]) << 8;
            us_temp += (uint16)puca_buffer[s_idx++];

            gt_ShowtimeErbParams.usa_VectoredBandParams[i] = us_temp;

            gt_ShowtimeErbParams.usa_Fsub[ i] =  1 << ((us_temp >>12)& 0x000F);
            gt_ShowtimeErbParams.usa_Lw[   i] =        (us_temp >> 8)& 0x000F;
            gt_ShowtimeErbParams.usa_Bmin[ i] =        (us_temp >> 4)& 0x000F;
            gt_ShowtimeErbParams.usa_Bmax[ i] =        (us_temp     )& 0x000F;

            // Compare ERB parameters from previous ERB request with current one (only enable message are considered)
            // This is done to choose if ERB length needs to be re-calculated or not
            // After showtime entry the gt_PrevErbParams parameters are initialized to 0, so the first check should be alyays gft_ERB_Params_Changed = TRUE
            // Further checks should show no parameter change
            if (gt_ShowtimeErbParams.usa_VectoredBandParams[i] != gt_PrevErbParams.usa_VectoredBandParams[i])
            {
               ft_ERB_Params_Changed = TRUE;
               gt_ShowtimeErbParams.us_Msg_Type |= 0x8000; // set MSBit to indicate that ERB format has changed (compared to previous msg)
               gt_PrevErbParams.usa_VectoredBandParams[i] = gt_ShowtimeErbParams.usa_VectoredBandParams[i];
               gt_PrevErbParams.usa_Bmax[i] = gt_ShowtimeErbParams.usa_Bmax[i];
               gt_PrevErbParams.usa_Bmin[i] = gt_ShowtimeErbParams.usa_Bmin[i];
               gt_PrevErbParams.usa_Lw[  i] = gt_ShowtimeErbParams.usa_Lw[  i];
               gt_PrevErbParams.usa_Fsub[i] = gt_ShowtimeErbParams.usa_Fsub[i];
               usa_Fsub[i] = gt_PrevErbParams.usa_Fsub[i];
               usa_Lw[i] = gt_PrevErbParams.usa_Lw[i];
            }

            // reject invalid message
            // REVIEW_STEFAN: it needs to be verified whether this implementation is according to standard
            //                 e.g. is is possible that Lw is zero for one band, while the other bands use Lw>0?
            //
            // Definition of L_w according to standard
            // Maximum number of bits for reporting of a clipped error sample component.
            // Configured by the VCE for each vectored downstream band separately.
            // If L_w is set to 0 for a particular vectored downstream band, then that band shall not
            // be reported. L_w shall be set to a non-zero value for at least one vectored
            // downstream band.
            if (gt_ShowtimeErbParams.usa_Lw[i] == 0)
            {
               t_TxOvhdMsgInfoInput->uc_defer_reason_code = EOC_G9935_INVALID_PARAMS;
               gt_ShowtimeErbParams.us_EOC_ErrorFB_Parameter_Mismatch_count++;
               uc_SendNack = 1;
               break;                 // this break stops only the for loop
            }
         }  // for(i = 0; i < (int16) guc_G9935_NumBands; i++)

         if (uc_SendNack == 1)      // exit in case of error in message
            break;            // this break exits the switch-case

         // set parameters of all unused bands to reset value '0'
         for(i = s_NumOfVecRxBands; i< MAX_NUM_RX_VEC_BANDS; i++)
         {
            gt_ShowtimeErbParams.usa_Fsub[ i] =  0;
            gt_ShowtimeErbParams.usa_Lw[   i] =  0;
            gt_ShowtimeErbParams.usa_Bmin[ i] =  0;
            gt_ShowtimeErbParams.usa_Bmax[ i] =  0;
         }

         //Only recalculate the ERB length at the beginning of showtime and if ERB parameters have changed
         if (ft_ERB_Params_Changed)
         {
            gt_ShowtimeErbParams.us_EOC_ErrorFB_StartMsg_WithParameterChange_count++;
            gus_ERB_Params_Changed++;

            // XDSLRTFW-3579 (Start)
            // Initialize all parameters which are modified in this section
            for (i = 0; i < MAX_NUM_ERB_SEGMENTS; i++)
            {
               usa_Header_Length[i] = 0;
            }

            // Compute the number of tones and ERB size (in bits) for each vectored band
            for (i = 0; i < s_NumOfVecRxBands; i++)
            {
               usa_NumTones[i] = (int)((sa_RxVecBandRightChannel[i] - sa_RxVecBandLeftChannel[i]) / (usa_Fsub[i])) + 1;
               usa_erb_size[i] = (4 + (usa_Lw[i] << 1)); // Size of ERB per band in bits
            }

            // Initialize the index of ERB segment
            us_SegmentIdx = 0;

            // Increase the header size by 1 byte (8 bits) to include ERB ID
            // The ERB ID is of size 1 byte
            usa_Header_Length[us_SegmentIdx] += 8;  // ERB_ID

            // Computation of ERB Header size/length
            for (i =0; i < s_NumOfVecRxBands; i++)
            {
               // Increase the header size by 1 byte (8 bits)  to include VBB ID
               // The VBB ID is of size 1 byte
               usa_Header_Length[us_SegmentIdx] += 8;    // VBB_ID

               // If the all tones can be accomadated in the same ERB segment, add it.
               // The maximum payload size if 1024 bytes. But in 1024, we need to account 5 bytes for
               // Line ID, sync symbol count and segment code.
               if (((usa_Header_Length[us_SegmentIdx]) + (usa_NumTones[i] * usa_erb_size[i])) <= ((MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE-5) << 3))
               {
                  usa_Header_Length[us_SegmentIdx] += (usa_NumTones[i] * usa_erb_size[i]);
                  // If the VBB has ended and if it has not occupied integer number of bytes, append with 2 or 4 or 6bits
                  // and make it an integer number.
                  if ((usa_Header_Length[us_SegmentIdx] % 8) != 0)
                  {
                     usa_Header_Length[us_SegmentIdx] = (((usa_Header_Length[us_SegmentIdx] + 7) >> 3) << 3);
                  }
               }
               else
               {
                  // When all the tones of the band cannot be put in the same segment
                  // The maximum payload size if 1024 bytes. But in 1024, we need to account 5 bytes for
                  // Line ID, sync symbol count and segment code.
                  us_remaining_tone = (((MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE-5) << 3) - usa_Header_Length[us_SegmentIdx])/usa_erb_size[i];
                  usa_Header_Length[us_SegmentIdx] += us_remaining_tone * usa_erb_size[i];
                  // If the VBB has ended and if it has not occupied integer number of bytes, append with 2 or 4 or 6bits
                  // and make it an integer number.
                  if ((usa_Header_Length[us_SegmentIdx] % 8) != 0)
                  {
                     usa_Header_Length[us_SegmentIdx] = (((usa_Header_Length[us_SegmentIdx] + 7) >> 3) << 3);
                  }
                  us_SegmentIdx++;
                  us_remaining_tone = usa_NumTones[i] - us_remaining_tone;

                  // Fill up the segments until all the tones are accomadated
                  while (us_remaining_tone > 0)
                  {
                     us_last_segment = us_remaining_tone;
                     // The maximum payload size if 1024 bytes. But in 1024, we need to account 5 bytes for
                     // Line ID, sync symbol count and segment code.
                     us_remaining_tone -= (int)(((MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE-5) << 3)/usa_erb_size[i]);
                     usa_Header_Length[us_SegmentIdx] = (int)((((MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE-5) << 3)/usa_erb_size[i])) * (usa_erb_size[i]);
                     // If the VBB has ended and if it has not occupied integer number of bytes, append with 2 or 4 or 6bits
                     // and make it an integer number.
                     if ((usa_Header_Length[us_SegmentIdx] % 8) != 0)
                     {
                        usa_Header_Length[us_SegmentIdx] = (((usa_Header_Length[us_SegmentIdx] + 7) >> 3) << 3);
                     }
                     us_SegmentIdx++;
                  }
                  us_SegmentIdx--;
                  usa_Header_Length[us_SegmentIdx] = us_last_segment * usa_erb_size[i-1];
                  // If the VBB has ended and if it has not occupied integer number of bytes, append with 2 or 4 or 6bits
                  // and make it an integer number.
                  if ((usa_Header_Length[us_SegmentIdx] % 8) != 0)
                  {
                     usa_Header_Length[us_SegmentIdx] = (((usa_Header_Length[us_SegmentIdx] + 7) >> 3) << 3);
                  }
               }
            }

            // As per the IEEE standard, the minimum protocol payload data size is 46 bytes. Incase the
            // payload is less than 46 bytes, increase the payload size by padding.
            // This needs to be done only at the end of the last vectored band and not for each vectored band.
            // The maximum payload size if 1024 bytes. But in 1024, we need to account 5 bytes for
            // Line ID, sync symbol count and segment code.
            if (usa_Header_Length[us_SegmentIdx] < ((MIN_PPD_PROTOCOL_PAYLOAD_DATA_SIZE - 5)<<3))
            {
               usa_Header_Length[us_SegmentIdx] = ((MIN_PPD_PROTOCOL_PAYLOAD_DATA_SIZE - 5)<<3);
            }

            // Store the number of ERB segments in a global structure
            gt_ShowtimeErbParams.uc_NumOfSegments = us_SegmentIdx+1;

            // Updatet the ERB header length in global structure
            for (i = 0; i <= us_SegmentIdx; i++)
            {
               gt_ShowtimeErbParams.usa_Header_Length[i] = (usa_Header_Length[i] >> 3) + 13;
            }
            // XDSLRTFW-3579 (End)

            // XDSLRTFW-3752 (Start)
            // N_ERB is the Sum of size of ERB of all segments
            // This variable (ul_N_ERB) consists of size of the ERB packet (including header, payload data and CRC)
            for (i = 0; i < gt_ShowtimeErbParams.uc_NumOfSegments; i++)
            {
               // Increase the size of Header length by 18 bytes to include
               // CO MAC address, CPE MAC address , length field and FCS (32-bit CRC)
               ul_N_ERB += (gt_ShowtimeErbParams.usa_Header_Length[i] + 18);
            }

            // In 30A profile, the sampling factor is double that of legacy or 35B profile.
            if (gs_frame_rate_is_8khz)
            {
               uc_fdmt = 1;
            }

            // BDR = 8 * N_ERB * (fdmt/257) in terms of bit per second
            // For legacy or 35B profile,
            // BDR = 8 * N_ERB * 4000 / 257   --> In terms of bit per second
            // To get the rate in terms of kbps, we need to divide by 1000
            // Instead of multiplying by 4000 and dividing by 1000, we can simplify the operation by multiplying with 4.
            // BDR = 8 * N_ERB * 4 / 257       -> In terms of kbps
            // BDR = (N_ERB << 5)/257
            ul_ERB_BDR = (ul_N_ERB << (5 + uc_fdmt));
            // We are ceiling the data rate so as not to lose any bandwidth for the voice/audio during VoLTE
            ul_ERB_BDR = ceil32(ul_ERB_BDR,257);

            // The temprary variable "ul_ERB_BDR" is needed because by doing left shift operation by 5,
            // we can lose the data (if we are storing directly in uint16 format). Hence, the data is computed
            // in 32-bit value and then stored to the CMV.
            gt_LineStatusUS.us_BDR = ul_ERB_BDR;
            // XDSLRTFW-3752 (End)
            // REVIEW_STEFAN: check missing for us_SegmentIdx
            // if (us_SegmentIdx > 8)
            //    break;
         } // if (ft_ERB_Params_Changed)
         else
         {
            gt_ShowtimeErbParams.us_EOC_ErrorFB_StartMsg_WithoutParameterChange_count++;
         }
         //XDSLRTFW-3507 (End)
         // REVIEW_STEFAN: REMOVE initialization of guc_G9935_CurrentVectorredBand and gus_ErbByteCounter and gs_G9935ErrorFeedbackState
         // guc_G9935_CurrentVectorredBand = 0; // first DS vectorred band
         // gus_ErbByteCounter = 0;          // reset this counter value to zero
         // gs_G9935ErrorFeedbackState = G9935_ERRORFB_ENABLE;
      }
      else    //if m = 0 then send NACK and disable Error Feedback
      {
         gt_ShowtimeErbParams.us_EOC_ErrorFB_StopMsg_count++;
         // prepare to send NACK and disable Error Vector Transmission
         t_TxOvhdMsgInfoInput->uc_defer_reason_code = EOC_G9935_STOP_ERRORFB;
         uc_SendNack = 1;
         break;
      }
      if (uc_SendNack == 1)
         break;

      break;   // case CMD_TYPE_ERROR_FB_REQUEST

   default:     // invalid code
      t_TxOvhdMsgInfoInput->uc_defer_reason_code = EOC_G9935_INVALID_PARAMS;
      uc_G9935_mParams = 0;
      uc_SendNack = 1;
      break;

   }  //switch(uc_msg_type)

   if(uc_SendNack)   // NACK response is same for both for EOC and L2 back channels
   {
      // no ERBs have been requested by CO - or request was not understood
      // or CO has requested to STOP ERBs
      // States in showtime
      // EOC_ERB_TRANSMISSION_STATE
      //    0: ST_ERBS_OFF                      : ERB are turned off
      //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
      //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
      guc_EOC_ERB_TRANSMISSION_STATE = ST_ERBS_OFF;         // send NACK
      // gs_G9935ErrorFeedbackState = G9935_ERRORFB_DISABLE;

      // prepare to send NACK and disable Error Vector Transmission
      t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
      t_TxOvhdMsgInfoInput->uc_message_type = EOC_G9935_NACK;   // Table8-6 & 7/G993.5    (Octet 2)
      t_TxOvhdMsgInfoInput->uc_message_designator = EOC_CMD_G9935_ERRORFB_DESIG;

      TxEocSendRequest(0 /* priority */, *t_TxOvhdMsgInfoInput);
   }
   else // if (gt_DecMsg_O_PMS_G9935.uc_ShowtimeBackChannelEncapsulation == 1) // L2 back channel and ACK via EOC channel
   {
      // uc_G9935_mParams is used as a indication for requested ERBs

      // States in showtime
      // EOC_ERB_TRANSMISSION_STATE
      //    0: ST_ERBS_OFF                      : ERB are turned off
      //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
      //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
      if (uc_G9935_mParams == 0)
      {
         guc_EOC_ERB_TRANSMISSION_STATE = ST_ERBS_OFF;          // send ACK / m=0  is used according to standard to stop ERB transmission
      }
      else
      {
         guc_EOC_ERB_TRANSMISSION_STATE = ST_ERBS_ON;           // send ACK / m!=0 is used according to standard to request ERBs
      }

      // prepare to send ACK for L2 Backchannel  Table 8-7/G993.5
      t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
      t_TxOvhdMsgInfoInput->uc_message_type = EOC_G9935_ACK;     // Table8-7 /G993.5    (Octet 2)
      t_TxOvhdMsgInfoInput->uc_message_designator = EOC_CMD_G9935_ERRORFB_DESIG;

      TxEocSendRequest(0 /* priority */, *t_TxOvhdMsgInfoInput);
   }
   gt_ShowtimeErbParams.us_RxFrmCount_EndERBCalc    = gs_RxPMDFrameCount;
   gt_ShowtimeErbParams.ul_RxSymbolCount_EndERBCalc = gl_RxSymbolCount;

   // REVIEW_STEFAN: TBD: Why do we need to disable ERBs for Vector Friendly mode?
   //                     Why do we calculate the ERB parameters at all in this case?
   if (gus_VectoringOptionsEnabled & VEC_OPTIONS_FULL_FRIENDLY_MASK)
   {
      // States in showtime
      // EOC_ERB_TRANSMISSION_STATE
      //    0: ST_ERBS_OFF                      : ERB are turned off
      //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
      //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
      guc_EOC_ERB_TRANSMISSION_STATE = ST_ERBS_OFF;       // Vector friendly mode: do NOT send out ERBs
      gs_G9935ErrorFeedbackState = G9935_ERRORFB_DISABLE;         // VECTOR_FRIENDLY ONLY
   }



   if ( gs_PauseControl == 0x39)
   {
      Pause(gs_PauseControl);
   }



}

/*****************************************************************************
*   Subroutine Name:rx_eoc_G9935_PilotUpdate_msg_handler(uint8* puca_buffer,
*                                    TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*
*   Description:
*      This subroutine processes the received Pilot sequence Update CMD message
*
*      Ping pong buffers are introduced to maintain the US pilot sequence.
*     Tx Sync symbol in vectoring mode is always modulated from the
*     Active buffer (gpuca_UsPsActive) of the ping-pong buffers.
*
*     In training US Pilot sequence from the O-Signature is stored in Active buffer.
*
*     In showtime, if USPS change request comes with ?interruption of current USPS is allowed?
*     command according to Table 8-9/G993.5 then the new USPS is directly stored in Active buffer.
*
*     If USPS change request comes with ?interruption of current USPS is not allowed? command then
*     the new USPS is stored in in-active buffer (gpuca_UsPsInActive) and swap the Active-InActive
*     buffers in proper time according to Section 8.2/G993.5.
*
*
*   Prototype:
*       void rx_eoc_G9935_PilotUpdate_msg_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/

void rx_eoc_G9935_PilotUpdate_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   int16 s_idx = 0;
   uint8 uc_PS_Interruption;
   int16 i;
   uint8 uc_msg_type;
   uint8 uc_SendAckNack;   // 1 : NAck, 0: Ack
   uint8 *puca_temp;

   uc_SendAckNack = 1;
   uc_msg_type =  puca_buffer[s_idx++];      // Table 8-9/G993.5 Octet 2 (value = 0x1)

   gus_PSChangeReq++;  // indicates no of times CO wants to change PS

   switch(uc_msg_type)
   {
   case CMD_TYPE_CHANGE_PILOT_SEQ:
      // Check if Pilot sequence interruption allowed or not
      uc_PS_Interruption =  puca_buffer[s_idx++];      //Table 8-9/G993.5 Octet 3 (value = 0x1 or 0x2)
      switch(uc_PS_Interruption)
      {
         // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start)
      case PILOTSEQ_INTERRUPTION_NOTALLOWED:
         //Update Pilot Sequence
         for (i=0; i< (gs_VecNPilotLength_US>>3); i++)  //Rsh by 3 because sequence length is bits
         {
            gpuca_FDPSInActive[i] = puca_buffer[s_idx++]; // XDSLRTFW-1696
         }

         uc_SendAckNack = 0;  // 1 : NAck, 0: Ack

         // (Corner case) if the decoding of the EOC message is done in the Tx super frame where
         // US pilot sequence index number is zero
         if(gs_VecIndx_PilotSeq ==0)
         {
            // Swap USPS active and inactive pointers
            puca_temp = gpuca_FDPSActive;
            gpuca_FDPSActive = gpuca_FDPSInActive;
            gpuca_FDPSInActive = puca_temp;

            gft_PilotseqInterruptionNotAllowed = 0;
         }
         else
         {
            gft_PilotseqInterruptionNotAllowed = 1; // used in TxForeGround() at states.c function
         }


         //gsa_DebugCB[1]++; //// indicates no of times CO wants to change PS without current PS interruption
         break;

      case PILOTSEQ_INTERRUPTION_ALLOWED:
         //Update Pilot Sequence
         for (i=0; i< (gs_VecNPilotLength_US>>3); i++)  //Rsh by 3 because sequence length is bits
         {
            gpuca_FDPSActive[i] = puca_buffer[s_idx++]; // XDSLRTFW-1696
         }

         uc_SendAckNack = 0;  // 1 : NAck, 0: Ack
         gft_PilotseqInterruptionNotAllowed = 0;
         //gsa_DebugCB[2]++; //// indicates no of times CO wants to change PS without current PS with interruption
         break;
         // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (end)
      default: // invalid parameter
         uc_SendAckNack = 1;  // 1 : NAck, 0: Ack
         //gsa_DebugCB[3]++; //// indicates no of times CO wants to change PS with invalid parameters

         break;
      } //switch(uc_PS_Interruption)
      break;

      // XDSLRTFW-1696 (Start)
   case CMD_TYPE_CHANGE_US_FDPS_SEQ:
      // Check if Pilot sequence interruption allowed or not
      uc_PS_Interruption =  puca_buffer[s_idx++];      //Table 8-9/G993.5 Octet 3 (value = 0x1 or 0x2)

      //Update Pilot Sequence
      for (i=0; i< (gs_VecNPilotLength_US>>3); i++)  //Rsh by 3 because sequence length is bits
      {
         //gpuca_UsPsInActive[i] = puca_buffer[s_idx++];
         gpuca_FDPSInActive[i] = puca_buffer[s_idx++];; // this line will be universal in future
      }

      // Field 1 Table 10-1b/ B993.5 Amd2: Unpack the index of the associated independent pilot sequence
      Unpack3Bits8Data(&(puca_buffer[s_idx]), &(guca_IndexIndependentPSInActive[0]));
      s_idx += 3;

      // Field 2 Table 10-1b/ B993.5 Amd2: Sign of the sequence relatively to the associated independent sequence
      guc_SignOfSeqInActive = puca_buffer[s_idx++];

      // Field 3 Table 10-1b/ B993.5 Amd2: Cyclical shift of the sequence relative to the associated independent sequence
      Unpack3Bits8Data(&(puca_buffer[s_idx]), &(guca_CyclicalShiftOfSeqInActive[0]));
      s_idx += 3;

      // Field 4 Table 10-1b/ B993.5 Amd2: Number of additional independent pilot sequence
      guc_NoOfAdditionalIPSInActive = puca_buffer[s_idx++];

      // Field 5 Table 10-1b/ B993.5 Amd2: bits of independent pilot sequence
      for (i = 1 ; i <= guc_NoOfAdditionalIPSInActive; i++ )
      {
         for (int16 j =0; j < (gs_VecNPilotLength_US>>3); j++)  //Div by 8, because sequence length is bits
         {
            gpuca_FDPSInActive[i*64 + j] = puca_buffer[s_idx++];  // use pointer
         }
      }

      switch(uc_PS_Interruption)
      {
         // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start)
      case PILOTSEQ_INTERRUPTION_NOTALLOWED:
         uc_SendAckNack = 0;  // 1 : NAck, 0: Ack

         // (Corner case) if the decoding of the EOC message is done in the Tx super frame where
         // US pilot sequence index number is zero
         if(gs_VecIndx_PilotSeq ==0)
         {
            // Swap USPS active and inactive pointers, arrais and variables
            puca_temp = gpuca_FDPSActive;
            gpuca_FDPSActive = gpuca_FDPSInActive;
            gpuca_FDPSInActive = puca_temp;

            for (i = 0; i < 8; i++)
            {
               guca_IndexIndependentPSActive[i] = guca_IndexIndependentPSInActive[i];
               guca_CyclicalShiftOfSeqActive[i] = guca_CyclicalShiftOfSeqInActive[i];
            }
            guc_SignOfSeqActive = guc_SignOfSeqInActive;
            guc_NoOfAdditionalIPSActive = guc_NoOfAdditionalIPSInActive;

            gft_PilotseqInterruptionNotAllowed = 0;
         }
         else
         {
            gft_PilotseqInterruptionNotAllowed = 1; // used in TxForeGround() at states.c function
         }


         //gsa_DebugCB[1]++; //// indicates no of times CO wants to change PS without current PS interruption
         break;


      case PILOTSEQ_INTERRUPTION_ALLOWED:

         // Swap USPS active and inactive pointers, arrais and variables
         puca_temp = gpuca_FDPSActive;
         gpuca_FDPSActive = gpuca_FDPSInActive;
         gpuca_FDPSInActive = puca_temp;
         for (i = 0; i < 8; i++)
         {
            guca_IndexIndependentPSActive[i] = guca_IndexIndependentPSInActive[i];
            guca_CyclicalShiftOfSeqActive[i] = guca_CyclicalShiftOfSeqInActive[i];
         }
         guc_SignOfSeqActive = guc_SignOfSeqInActive;
         guc_NoOfAdditionalIPSActive = guc_NoOfAdditionalIPSInActive;

         uc_SendAckNack = 0;  // 1 : NAck, 0: Ack
         gft_PilotseqInterruptionNotAllowed = 0;
         //gsa_DebugCB[2]++; //// indicates no of times CO wants to change PS without current PS with interruption
         break;
         // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (end)
      } //switch(uc_PS_Interruption)

      break;
      // XDSLRTFW-1696 (end)
   default:     // invalid code
      uc_SendAckNack = 1;  // 1 : NAck, 0: Ack
      //gsa_DebugCB[4]++; //// indicates no of times CO wants to change PS with invalid code
      break;

   }//switch(uc_msg_type)

   if( uc_SendAckNack ==0) // Ack
   {
      // prepare to send ACK
      t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
      t_TxOvhdMsgInfoInput->uc_message_type = EOC_G9935_ACK;
      t_TxOvhdMsgInfoInput->uc_message_designator = EOC_CMD_G9935_UPDATE_PILOTSEQ_DESIG;

      gus_PSChangePerf++; // Pilot sequence modification performed

   }
   else if ( uc_SendAckNack ==1) // NAck
   {
      // prepare to send NACK and disable Error Vector Transmission
      t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
      t_TxOvhdMsgInfoInput->uc_message_type = EOC_G9935_NACK;
      t_TxOvhdMsgInfoInput->uc_message_designator = EOC_CMD_G9935_UPDATE_PILOTSEQ_DESIG;
      t_TxOvhdMsgInfoInput->uc_defer_reason_code = EOC_G9935_INVALID_PARAMS;
   }
   // send the response
   TxEocSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);

}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Unpack12BitsPairST
 *
 *  Description:  Unpack an array of 3 bytes (24 bits), where each 3 bytes
 *   produce two 12-bits numbers: LSBWord = bits 0-11, MSBWord = bits 12-23.
 *
 *  Prototype:
 *           void Unpack12BitsPairST(int16 s_NumberOfPairs, uint8 *puca_ByteBuf, int16 *psa_LSBword, int16 *psa_MSBword)
 *
 *  Input Arguments:
 *      s_NumberOfPairs -- no. of 12-bit pairs to be unpacked
 *      puca_ByteBuf -- pointer to the input byte array
 *
 *  Output Arguments:
 *       psa_LSBword -- pointer to the 12-bit array storing the Least Significant words
 *       psa_MSBword -- pointer to the 12-bit array storing the Most Significant words
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Unpack12BitsPairST(int16 s_NumberOfPairs, uint8 *puca_ByteBuf, int16 *psa_LSBword, int16 *psa_MSBword)
{
   int16 i, i3;
   uint16 us_word;

   for(i=0; i<s_NumberOfPairs; i++)
   {
      i3 = i*3;

      //Get next 3 bytes
      us_word = puca_ByteBuf[i3];
      us_word <<= 8;
      us_word += puca_ByteBuf[i3+1];
      psa_MSBword[i] = (us_word>>4)&0x0FFF;
      us_word <<= 8;
      us_word += puca_ByteBuf[i3+2];
      psa_LSBword[i] = us_word&0x0FFF;
   }
}
// ANXQ_SUPPORT
void Unpack16BitsPairST(int16 *ps_PtrMsgIndex, int16 s_NumberOfPairs, uint8 *puca_ByteBuf, int16 *psa_LSBword, int16 *psa_MSBword)
{
   unsigned int i;
   uint16 us_word;

   for(i=0; i<s_NumberOfPairs; i++)
   {
      //Get next 4 bytes
      us_word  = (puca_ByteBuf[(*ps_PtrMsgIndex)++] << 8);  // byte 1
      us_word |= puca_ByteBuf[(*ps_PtrMsgIndex)++];         // byte 2
      psa_MSBword[i] = us_word;
      us_word  = (puca_ByteBuf[(*ps_PtrMsgIndex)++] << 8);  // byte 3
      us_word |= puca_ByteBuf[(*ps_PtrMsgIndex)++];         // byte 4
      psa_LSBword[i] = us_word;
   }
}
//#endif    // #ifdef MTK_VECTORING_SUPPORT

/*****************************************************************************
;   Subroutine Name: FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, int16* ps_retCode)
;
;   This subroutine extracts the bitswap bins information from the OLR messafde
; received
;
;   Prototype:
;      FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, int16* ps_retCode)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;******************************************************************************/
FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, int16* ps_retCode)
{
   uint8 uc_TxBat;
   uint8 uc_CarrierMaskHigh;
   uint16 us_TxFineGain;
   int16 i, k, s_carrier_index, s_linearPSD;
   int32 l_temp;
   PSDDescriptorTable_t *pt_PSDDesc;

   if (gs_interp_psd_with_tssi==1)
   {
      pt_PSDDesc = (PSDDescriptorTable_t *)(void *)&gt_UsTSSIPSDDescriptorTable;
   }
   else
   {
      pt_PSDDesc = (PSDDescriptorTable_t *)(void *)&gt_UsREFPSDDescriptorTable;
   }
   if ((!s_Nf) || (s_Nf > MAX_BS_NUM_TONES))
   {
      return (TRUE);
   }

   // The sub-carrier index i shall be coded in the four LSBs (five for 35B) of the first
   // octet and the entire second octet of the sub-carrier field. The LSBs of
   // the sub-carrier index i shall be contained in the second octet.
   // Note: 4 octets formatted as [000i iiii iiii iiii gggg gggg gggg bbbb], with
   //       gi (12 bits) and the bi (4 bits) values of the subcarrier index i (12 or 13 (35b) bits).
   uc_CarrierMaskHigh = 0xF;
   // ANXQ_SUPPORT
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      uc_CarrierMaskHigh = 0x1F;
   }

   /* Extract the bins information */
   for (i = 0, k = 0; k < s_Nf; i = i+3, k++)
   {

      s_carrier_index = ( puca_buffer[i++] & uc_CarrierMaskHigh) << 8;
      s_carrier_index |= puca_buffer[i];

      // The gi shall be contained in the third octet and the four MSBs of the
      // fourth octet. The LSBs of gi shall be contained in the fourth octet.
      us_TxFineGain = (uint16)((puca_buffer[i+1] <<8)| (puca_buffer[i+2] & 0xF0));

      // The bi shall be contained in the four LSBs of the fourth octet.
      uc_TxBat = (puca_buffer[i+2] & 0xF);

      // Check the parameters and reject the bitswap if not valid.
      if (uc_TxBat > RX_MAX_BITS_PER_TONE)
      {
         *ps_retCode = REQ_INVALID_BiGi;
         return (TRUE);
      }

      s_linearPSD = ComputeLinearPSD(s_carrier_index, pt_PSDDesc);

      //multiply current TxFineGains settings, which define the PSD shaping,
      //with the Fine Gains received from the far end.
      //both are in 3.13 format at this point, so the result is 6.26

      MULS32xU16(l_temp, s_linearPSD, us_TxFineGain);

      // add 1 bit for rounding purposes
      l_temp = (l_temp + (1 << 12));

      // shift to get 19.13 format purposes
      l_temp = (l_temp >> 13);

      // Change the inactive table values as per the bitswap request

      // use the lower 16 bits, now in 3.13 format
      ghpsa_TxFineGains_Inactive[s_carrier_index] = (int16)l_temp;
      ghpuca_TxBat_Inactive[s_carrier_index] = uc_TxBat;
   }


   return(FALSE);
}

/*****************************************************************************
;   Subroutine Name: Abandon_DS_OLRPM(void)
;
;   This subroutine abandon Rx OLR/PM reconfiguration and restore the original setting
;
;   Prototype:
;      Abandon_DS_OLRPM(void)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;******************************************************************************/
void Abandon_DS_OLRPM(void)
{
   int16 s_lp;

   // restore the s/w copy of BAT table from the h/w tables.

   gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
   gt_RxOLRPMVars.s_rxOLRPMEvent = 0;

   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      gt_rx_config_v2.ul_Reconfig_Lp[s_lp] = gt_rx_config_v2.ul_Lp[s_lp];
   }

   gus_RxBitSwapStatus |= RX_BITSWAP_BGT_MISMATCH;

   //XDSLRTFW-1393 (Start)
   //Either CPE's SRA_RETX_REQ got rejected by CO or Timed out.
   if (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ)
   {
      gft_SRAInvSync_Detected = FALSE;
      gft_DTU_Stoppage_Detected = FALSE;
      gft_Start_DTU_Stoppage_Detection = FALSE;
      guc_DTU_Stoppage_Detect_Cntr = 0;
      guc_DTU_Status_Arr_Indx = 0;
      memset(gt_DTU_Status_Arr, 0, sizeof(DTU_Status_t)*(63+1));//Max QTx => 63 (Table A.6 of G.998.4 (G.Inp) standard)
   }
   //XDSLRTFW-1393 (End)
}

/*****************************************************************************
;   Subroutine Name: Abandon_US_OLRPM(void)
;
;   This subroutine abandon Tx OLR/PM reconfiguration and restore the original setting
;
;   Prototype:
;      Abandon_US_OLRPM(void)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;******************************************************************************/
void Abandon_US_OLRPM(void)
{
   int16 s_lp;

   // restore the s/w copy of BAT table from the h/w tables.
   AddFunctionToFifo(gp_TxLoadingFunctionFifo, CopyTxBGT_ActiveToInactive);

   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      gt_tx_config_v2.ul_Reconfig_Lp[s_lp] = gt_tx_config_v2.ul_Lp[s_lp];
   }

   gft_UsOlrInProgress = FALSE;
   gt_TxOLRVars.uc_txOLRState = L0_STEADY_STATE;

}



/*****************************************************************************
;   Subroutine Name: void process_eoc_cmd(uint8 uc_msg_type, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
;
;   Prototype:
;      void process_eoc_cmd(uint8 uc_msg_type, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;******************************************************************************/
void process_eoc_cmd(uint8 uc_msg_type, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   switch(uc_msg_type)
   {
   case PERFORM_SELF_TEST:
      Perform_Self_test();

      t_TxOvhdMsgInfoInput->uc_message_type = SELF_TEST_ACK;

      // later should check for return code
      TxEocSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);

      break;

   case UPDT_TEST_PARAMETER:
      //turn on the Update Test Paramter flag
      gft_UpdateTestPar = TRUE;

      break;

   case START_TX_CORR_CRC:
      EnableCorruptCRC();

      break;

   case END_TX_CORR_CRC:

      DisableCorruptCRC();

      break;

   case START_RX_CORR_CRC:

      EnableCorruptCRC();

      break;

   case END_RX_CORR_CRC:

      DisableCorruptCRC();

      break;
      //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
   case ENTER_RTX_TESTMODE:
      gft_DsUsReTxDiagEnter = TRUE; //XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (Start_End)
      break;
      //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)

   default:
      break;
   } // switch
}


/*****************************************************************************
*   Subroutine Name: rx_eoc_msg_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received EOC overhead message
*
*   Prototype:
*     void rx_eoc_msg_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_eoc_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,
                        TxEocControl_t *pt_TxEocControlInfo)
{
   uint8 uc_msg_type, uc_comm_or_resp_bit;
   int32 l_Action;   // 0 - no action; 1 - send EOC_ACK; 2 - delete expected msg

   uint8 uc_SelfTestWaitTime; // The min time the VTU-O shall wait before requesting
   // the self test result

   TxEocControl_t *ptxEocControlInfo;


   uc_comm_or_resp_bit = (puca_buffer[1] >> 1) & 0x1;
   uc_msg_type = puca_buffer[3];
   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
   case START_TX_CORR_CRC:
   case END_TX_CORR_CRC:
      break;

   case START_RX_CORR_CRC:
   case END_RX_CORR_CRC:
      CheckMsgPendingFlags(EOC_CMD_DESIG, uc_msg_type, 0, 0);
      break;

   case UPDT_TEST_PARAMETER:
      break;

      // Octet #2 (0ffset 1) is 0x01 for -both- the request and the response for the
      //     Perform-Self-Test command -- see tables 11-8 and 11-10 in 993.2
   case 0x01:
      //case PERFORM_SELF_TEST: 0x01
      //case SELF_TEST_ACK:     0x01
      if (1==uc_comm_or_resp_bit) // a response, so this is SELF_TEST_ACK
      {
         uc_SelfTestWaitTime = puca_buffer[4];
      }
      else
      {
         // a command, so this is PERFORM_SELF_TEST
         process_eoc_cmd(PERFORM_SELF_TEST, t_TxOvhdMsgInfoInput);
      }
      l_Action = 0;
      break;
      //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
      //Retransmission test mode
      //Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
      //ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
      //enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
      //enabled in upstream.
   case ENTER_RTX_TESTMODE:
      break;

      //Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume  the  normal
      //behaviour of retransmission in the direction where it is enabled
      //VTU-R will not send any ACK response???
   case LEAVE_RTX_TESTMODE:
      gft_DsUsReTxDiagEnter = FALSE;//XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (Start_End)
      l_Action = 0;
      break;
      //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)
   case EOC_ACK: // CO
      l_Action = 2;
      // more stuff here
      // there might be a need for an element that records the expected message_type
      // similarly to uc_ExpectedDesignator.

      switch(pt_TxEocControlInfo->uc_ExpectedMsgType)
      {
      case   START_RX_CORR_CRC: // CPE is getting corrupt CRC's
      case   END_RX_CORR_CRC:
         process_eoc_cmd(pt_TxEocControlInfo->uc_ExpectedMsgType, t_TxOvhdMsgInfoInput);
         break;
      } // switch

      ptxEocControlInfo = &gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY];
      CheckMsgPendingFlags(pt_TxEocControlInfo->uc_ExpectedDesignator,
                           uc_msg_type, pt_TxEocControlInfo->ft_MECmd, 0);

      break;

   default:
      l_Action = 0;
      break;
   } // switch

   if (l_Action == 1)
   {
      t_TxOvhdMsgInfoInput->uc_message_type = EOC_ACK;

      // check for return code
      if (EOC_QUEUE_ADDED == TxEocSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput))
      {
         switch(uc_msg_type)
         {
         case   START_TX_CORR_CRC:
         case   END_TX_CORR_CRC:
         case ENTER_RTX_TESTMODE: //   //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start_End)
            process_eoc_cmd(uc_msg_type, t_TxOvhdMsgInfoInput);
            CheckMsgPendingFlags(EOC_CMD_DESIG, uc_msg_type, 0, 0);
            break;
         } // switch
      }
   }
}

/*****************************************************************************
*   Subroutine Name: rx_inventory_cmd_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received Inventory message
*
*   Prototype:
*     void rx_inventory_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_inventory_cmd_handler(uint8* puca_buffer,
                              TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 l_Action;      // 0 - do nothing; 1 - request EOC send; 2 - delete acked cmd

   TxEocControl_t *ptxEocControlInfo;


   uc_msg_type = puca_buffer[0];

   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
   case IDENT_READ:
   case AUX_IDENT_READ:
   case SELF_TEST_RES_READ:
      //case PMD_CAP_READ:
      //case PMS_TC_CAP_READ:
      //case TPS_TC_CAP_READ:
      t_TxOvhdMsgInfoInput->uc_message_type = uc_msg_type | 0x80;
      break;


   case IDENT_READ_ACK:
      l_Action = 2;

      // Set Rx EOC message indicator
      gul_RxEocMsgIndicator |= INVENTORY_IDENT_READ_MSG;

      {
         int16 i;

         // Get 8 octets of vendor id
         for(i = 0; i< VENDOR_ID_LENGTH; i++)
         {
            guca_fe_SystemVendorID[i] = puca_buffer[i + 1];
         }

         // Get 16 octets of version number
         for(i = 0; i< VERSION_NUM_LENGTH; i++)
         {
            guca_fe_SystemVersionNum[i] = puca_buffer[VENDOR_ID_LENGTH + 1 + i];
         }


         // Get 32 octets of serial number
         for(i = 0; i< SERIAL_NUM_LENGTH; i++)
         {
            guca_fe_SystemSerialNum[i] = puca_buffer[VENDOR_ID_LENGTH+VERSION_NUM_LENGTH + 1 + i];
         }
      }

      ptxEocControlInfo = &gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY];
      CheckMsgPendingFlags(ptxEocControlInfo->uc_ExpectedDesignator,
                           uc_msg_type, ptxEocControlInfo->ft_MECmd, 0);
      break;

   case AUX_IDENT_READ_ACK:
      l_Action = 2;

      // Set Rx EOC message indicator
      gul_RxEocMsgIndicator |= INVENTORY_AUX_IDENT_READ_MSG;

      {
         int16 i,j;
         for (i=0; i < VENDOR_ID_LENGTH; i++)
         {
            guca_fe_SystemVendorID[i] = puca_buffer[i + 1];
         }

         for (j=0; j < MAX_AUX_INFO_BYTES; j++)
         {
            guca_fe_AuxInvInfo[j] = puca_buffer[++i];
         }
      }

      ptxEocControlInfo = &gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY];
      CheckMsgPendingFlags(ptxEocControlInfo->uc_ExpectedDesignator,
                           uc_msg_type, ptxEocControlInfo->ft_MECmd, 0);

      break;

   default:
      l_Action = 0;
      break;
   }

   if (l_Action == 1)
   {
      TxEocSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
}

/*****************************************************************************
;   Subroutine Name: void Perform_Self_test(void)
;
;   This subroutine performs the self test and updates the self_test_result
;
;   Prototype:
;      void Perform_Self_test(void)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;******************************************************************************/

void Perform_Self_test(void)
{
   // Clear the result
   gl_self_test_result =0;
}

/*****************************************************************************
*   Subroutine Name: rx_nsf_facility_cmd_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received nsf command
*
*   Prototype:
*     void rx_nsf_facility_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
uint8 guca_RxNSF_Msg[MAX_NSF_MSG_LEN];

void rx_nsf_facility_cmd_handler(uint8* puca_buffer,
                                 TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int16 s_NSF_msg_len = gus_rx_msg_index - 6;
   int16 i, k =0;

   uc_msg_type = puca_buffer[0];
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if(uc_msg_type == NSF)
   {
      if(gt_RxEocMsg.message_priority  != 0)
      {
         for (i = 1; i <= s_NSF_msg_len; i++)
         {
            // Prevent overflow
            if ( k < MAX_NSF_MSG_LEN)
            {
               guca_RxNSF_Msg[k++] = puca_buffer[i];
            }
         }
         t_TxOvhdMsgInfoInput->uc_message_type = NSF_ACK;
         TxEocSendRequest(gt_RxEocMsg.message_priority, *t_TxOvhdMsgInfoInput);
      }
   }
}

// XDSLRTFW-650 / XDSLRTFW-1384
#if 1
/*****************************************************************************
*   Subroutine Name: rx_power_mgmt_rd_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received power management command
*
*   Prototype:
*      void rx_power_mgmt_rd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/
void rx_power_mgmt_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput )
{

   uint8 uc_msg_type;
   int16 s_ErrCode;   /* Initialize to zero */
   uint8 uc_proposed_link_state = 0;
   int32 l_Action, idx=0;

   s_ErrCode = 0;

   /* Extract the received message type */
   uc_msg_type = puca_buffer[idx++];
   l_Action = 0;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {

   case STATE_TRANS_REQ:
      /* Extract the proposed link state*/
      uc_proposed_link_state = puca_buffer[idx++];

      switch(uc_proposed_link_state)
      {
      case L3_STATE:
         l_Action = 1;

         STATArray[STAT_FE_L3_ReqStatus] = STAT_CO_L3_REQ;

         /* Check if in L0 State */
         if ((TESTArray[TEST_Control3] & TEST_DisableL3Mode))
         {
            t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_REJECT;
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_STATE_NOT_DESIRED;
         }
         else if(gt_RxOLRPMVars.uc_rxOLRPMState != L0_STEADY_STATE)
         {
            t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_REJECT;
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_STATE_NOT_DESIRED;

         }
         else
         {

            t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_GRANT;
            STATArray[STAT_FE_L3_ReqStatus] = (int16)STAT_CO_L3_REQ_GRANTED;
            gsa_IndirectStat0[1] = (int16) STAT_PM_L3;
         }
         break;

      default:
         break;

      }
      break;

   case STATE_TRANS_GRANT:
      l_Action = 2;
      guc_PM_L3_Response = PM_L3_GRANT_RECEIVED;   //honored only if(guc_PM_L3_InternalState == WAITING_FOR_L3_RESPONSE)
      break;

   case STATE_TRANS_REJECT:
      l_Action = 2;

      // record error code in PM cmv.
      STATArray[STAT_ME_PMREQ_ERROR] = puca_buffer[idx++];
      guc_PM_L3_Response = PM_L3_REJECT_RECEIVED; //honored only if(guc_PM_L3_InternalState == WAITING_FOR_L3_RESPONSE)
      break;

   default:
      break;

   }

   if (l_Action == 1)
   {
      TxEocSendRequest(OVHD_NORMAL_PRIORITY /* priority */, *t_TxOvhdMsgInfoInput);
   }

   // L3 processing
   if(l_Action == 2)
   {
      PM_L3_State_Machine();
   }

}
#endif
// XDSLRTFW-650 / XDSLRTFW-1384
/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: formCntr
 *
 *  Description: Forms a 32-bit counter from the buffer
 *
 *  Prototype: uint32 formCntr(const unsigned char* const pbuf, uint16* const pidx)
 *
 *  Input Arguments: pbuf (pointer to the buffer holding the counter)
 *                   pidx (the buffer index)
 *
 *  Output Arguments: returns a 32-bit counter
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint32 formCntr(const unsigned char* const pbuf, uint16* const pidx)
{
   uint32 ul_cntr;

   ul_cntr = (pbuf[0] << 24) |
             (pbuf[1] << 16) |
             (pbuf[2] << 8)  |
             pbuf[3];

   (*pidx) += 4;

   return ul_cntr;
}

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: getTpsTcCntrs
 *
 *  Description: Populates the ATM counters from the buffer
 *
 *  Prototype: void getTpsTcCntrs(const unsigned char ul_latpath, uint8* const pbuf, uint16* const pidx)
 *
 *  Input Arguments: uc_latpath (the latency path number)
 *                   pbuf (pointer to the buffer holding the counter)
 *                   pidx (the buffer index)
 *
 *  Output Arguments: n/a
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void getTpsTcCntrs(const unsigned char uc_latpath, uint8* const pbuf, uint16* const pidx)
{
   int16 s_dpModeDS, s_dpModeUS;
   uint32 ul_HEC_PFE_count, ul_CU_PFE_count, ul_CD_PFE_count, ul_IBE_PFE_count;

   s_dpModeDS = gta_DsBearerChanAct[uc_latpath].s_TypeEnabled;
   s_dpModeUS = gta_UsBearerChanAct[uc_latpath].s_TypeEnabled;


   if ((s_dpModeDS == s_dpModeUS) && (TPS_TC_TYPE_ATM == s_dpModeDS))
   {
      // get ATM counters

      // HEC anomalies
      ul_HEC_PFE_count = formCntr(pbuf+(*pidx),pidx);

      // Total cells
      ul_CU_PFE_count = formCntr(pbuf+(*pidx),pidx);

      // Total cells passed through ATM function
      ul_CD_PFE_count = formCntr(pbuf+(*pidx),pidx);

      // Total bit errors
      ul_IBE_PFE_count = formCntr(pbuf+(*pidx),pidx);


      // HEC anomalies
      gt_g997_AtmPerf_HEC_Running_FE.la_HEC_PFE_count[uc_latpath] = ul_HEC_PFE_count;

      // Total cells
      gt_g997_AtmPerf_CU_Running_FE.la_CU_PFE_count[uc_latpath] = ul_CU_PFE_count;

      // Total cells passed through ATM function
      gt_g997_AtmPerf_CD_Running_FE.la_CD_PFE_count[uc_latpath] = ul_CD_PFE_count;

      // Total bit errors
      gt_g997_AtmPerf_IBE_Running_FE.la_IBE_PFE_count[uc_latpath] = ul_IBE_PFE_count;

      //Write to CNTR[CNTR_FE_ATM_BC0], CNTR[CNTR_FE_ATM_BC1]
      gt_g997_AtmPerf_FE[uc_latpath].ul_HEC_P_count = ul_HEC_PFE_count; //far end HEC error count
      gt_g997_AtmPerf_FE[uc_latpath].ul_CD_P_count = ul_CD_PFE_count;   //far end CD_P count
      gt_g997_AtmPerf_FE[uc_latpath].ul_CU_P_count =  ul_CU_PFE_count ;  //far end CU_P count
      gt_g997_AtmPerf_FE[uc_latpath].ul_IBE_P_count = ul_IBE_PFE_count;  //far end idle cell w/ bit error count
   }
   else
   {
      // In G.993.2 section K.3.9.3.3 and K.1.9.3.3 ...

      // "The block of counter values corresponding to the PTM-TC function returned in
      // the message described in Table 11-17 shall have zero length"
   }
}

/*****************************************************************************
*   Subroutine Name: void rx_mgmt_par_rd_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Description:
*      This subroutine processes the received management counters
*
*   Prototype:
*     void rx_mgmt_par_rd_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/

void rx_mgmt_par_rd_handler(uint8* puca_buffer,
                            TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   uint16 idx = 1;
   uint32 received_count, delta = 0;

   uc_msg_type = puca_buffer[0];
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if(uc_msg_type == MGMT_CNTR_READ)
   {
      t_TxOvhdMsgInfoInput->uc_message_type = MGMT_CNTR_READ_ACK;
      t_TxOvhdMsgInfoInput->uc_message_designator = MGMT_CNTR_RD_CMD_DESIG;
      TxEocSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);

      //DSM_Vectoring_Debug:
      //if( gs_PauseControl == 0x26)
      //Pause(gs_PauseControl);

   }
   else if (uc_msg_type == MGMT_CNTR_READ_ACK)
   {
      /* Update the far end error information based on */
      /* the received error counter values */

      /* Check for active latency paths */

      // FEC-0
      if ((gt_tx_TPS_Map.s_BCtoLP[BC0] == LP0) || (gt_tx_TPS_Map.s_BCtoLP[BC1] == LP0) || (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
      {
         received_count = formCntr(puca_buffer+idx,&idx);

         if (gft_Compute_delta)
         {
            delta = received_count - gt_g997_ChPerf_FEC_Running_FE.la_FEC_CFE_count[0];
         }

         gt_g997_ChPerf_FEC_Running_FE.la_FEC_CFE_count[0] = received_count;
         gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Current.la_FEC_CFE_count[0] += delta;
      }

      // FEC-1
      if ((gt_tx_TPS_Map.s_BCtoLP[BC0] == LP1) || (gt_tx_TPS_Map.s_BCtoLP[BC1] == LP1))
      {
         received_count = formCntr(puca_buffer+idx,&idx);

         if (gft_Compute_delta)
         {
            delta = received_count - gt_g997_ChPerf_FEC_Running_FE.la_FEC_CFE_count[1];
         }

         gt_g997_ChPerf_FEC_Running_FE.la_FEC_CFE_count[1] = received_count;
         gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Current.la_FEC_CFE_count[1] += delta;
      }

      // CRC-0
      if ((gt_tx_TPS_Map.s_BCtoLP[BC0] == LP0) || (gt_tx_TPS_Map.s_BCtoLP[BC1] == LP0)|| (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
      {
         received_count = formCntr(puca_buffer+idx,&idx);

         if (gft_Compute_delta)
         {
            delta = received_count - gt_g997_ChPerf_CRC_Running_FE.la_CV_CFE_count[0];
         }

         gt_g997_ChPerf_CRC_Running_FE.la_CV_CFE_count[0] = received_count;
         gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Current.la_CV_CFE_count[0] += delta;
      }

      // CRC-1
      if ((gt_tx_TPS_Map.s_BCtoLP[BC0] == LP1) || (gt_tx_TPS_Map.s_BCtoLP[BC1] == LP1))
      {
         received_count = formCntr(puca_buffer+idx,&idx);
         if (gft_Compute_delta)
         {
            delta = received_count - gt_g997_ChPerf_CRC_Running_FE.la_CV_CFE_count[1];
         }
         gt_g997_ChPerf_CRC_Running_FE.la_CV_CFE_count[1] = received_count;
         gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Current.la_CV_CFE_count[1] += delta;
      }
      //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (Start)
      //XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode (Start)
      if((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
      {
         //rtx-tx (Count of 'Number of Retransmitted DTUs' maintained by the CO)
         received_count = formCntr(puca_buffer+idx,&idx);

         gt_ReTXStats.ul_RetransmittedDtuCntFE = received_count;
      }
      //XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode (End)

      if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         //rtx-c(counter of corrected DTU)
         received_count = formCntr(puca_buffer+idx,&idx);
         gt_g997_ReTx_FE_MgmtCnt.ul_Corrected_Dtu_cnt = received_count;

         //rtx-uc( counter of uncorrected DTU)
         received_count = formCntr(puca_buffer+idx,&idx);
         gt_g997_ReTx_FE_MgmtCnt.ul_Uncorrected_Dtu_cnt=received_count;

      }
      //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (End)
      // FEC errored seconds
      received_count = formCntr(puca_buffer+idx,&idx);
      if (gft_Compute_delta)
      {
         delta = received_count - gt_g997_LinePerf_Running_FE.l_FECS_LFE_count;
      }
      gt_g997_LinePerf_Running_FE.l_FECS_LFE_count = received_count;
      gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current.l_FECS_LFE_count += delta;

      // Errored seconds
      received_count = formCntr(puca_buffer+idx,&idx);
      if (gft_Compute_delta)
      {
         delta = received_count - gt_g997_LinePerf_Running_FE.l_ES_LFE_count;
      }
      gt_g997_LinePerf_Running_FE.l_ES_LFE_count = received_count;
      gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current.l_ES_LFE_count += delta;

      // Severely errored seconds
      received_count = formCntr(puca_buffer+idx,&idx);
      if (gft_Compute_delta)
      {
         delta = received_count - gt_g997_LinePerf_Running_FE.l_SES_LFE_count;
      }
      gt_g997_LinePerf_Running_FE.l_SES_LFE_count = received_count;
      gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current.l_SES_LFE_count += delta;

      // LOS errored seconds
      received_count = formCntr(puca_buffer+idx,&idx);
      if (gft_Compute_delta)
      {
         delta = received_count - gt_g997_LinePerf_Running_FE.l_LOSS_LFE_count;
      }
      gt_g997_LinePerf_Running_FE.l_LOSS_LFE_count = received_count;
      gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current.l_LOSS_LFE_count += delta;

      // UAS errored seconds
      received_count = formCntr(puca_buffer+idx,&idx);
      if (gft_Compute_delta)
      {
         delta = received_count - gt_g997_LinePerf_Running_FE.l_UAS_LFE_count;
      }
      gt_g997_LinePerf_Running_FE.l_UAS_LFE_count = received_count;
      gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current.l_UAS_LFE_count += delta;

      //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (Start)
      if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         //Counter of ''leftr'' defect seconds
         received_count = formCntr(puca_buffer+idx,&idx);
         gt_g997_ReTx_FE_MgmtCnt.ul_Leftr_DefectSeconds_cnt = received_count;

         //Counter of error free bitsrtx-uc( counter of uncorrected DTU)
         received_count = formCntr(puca_buffer+idx,&idx);
         gt_g997_ReTx_FE_MgmtCnt.ul_Error_Freebits_cnt=received_count;

         //EFTR_min
         received_count = formCntr(puca_buffer+idx,&idx);
         gt_g997_ReTx_FE_MgmtCnt.ul_Eftr_min=(received_count*1000); //EFTR_min received as a multiple of 1K bits/s

      }
      //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (End)
      // Counters for TPS-TC-0
      if (gt_tx_TPS_Map.s_BCtoTPS[BC0] != MAP2NONE)
      {
         getTpsTcCntrs(BC0, puca_buffer, &idx);
      }

      // Counters for TPS-TC-1
      if (gt_tx_TPS_Map.s_BCtoTPS[BC1] != MAP2NONE)
      {
         getTpsTcCntrs(BC1, puca_buffer, &idx);
      }

      // Set thjis flag on the reception of first ack
      if (!gft_Compute_delta)
      {
         gft_Compute_delta = TRUE;
      }

   } // MGMT_CNTR_READ_ACK

}



/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: CheckMsgPendingFlags
 *
 *  Description: Checks and sets flags that indicate an Eoc msg is pending
 *
 *  Prototype: void CheckMsgPendingFlags(const uint8 uc_designator, const uint8 uc_msgtype,
 *                                       const FLagT ft_MECmd, const FlagT ft_timedout)
 *
 *  Input Arguments: uc_designator - the eoc message designator
 *                   uc_msgtype - the message type
 *                   ft_MECmd - flag to indicate whether the current cmd is an ME cmd
 *                   ft_timedout - flag to indicate whether the sent msg timed-out
 *
 *  Output Arguments: n/a
 *
 *  Global Variables Used: gft_EocFEBlockReadPending, gt_MONI_FEReadTrigger, gft_SendFEDataFlag,
 *                         gt_MONI_CEocAutoMsgCtrl, gt_MONI_CEocTrigger, gt_MONI_CEocStat,
 *                         gft_SendCEocStatFlag, gft_SendCEocMsgFlag, gus_EocInvMsgResp,
 *                         gt_CorruptCRCStatus, gt_MONI_TimeSyncCtrl
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
extern FlagT gft_EocNack;
void CheckMsgPendingFlags(const uint8 uc_designator, const uint8 uc_msgtype,
                          const FlagT ft_MECmd, const FlagT ft_timedout)
{
   // clear flags that indicate a msg is pending
   switch(uc_designator)
   {
   case INVENTORY_CMD_DESIG:
      switch(uc_msgtype)
      {
      case IDENT_READ_ACK:
         if (!ft_MECmd)
         {
            gus_EocInvMsgResp = 1;
         }
         break;

      case AUX_IDENT_READ_ACK:
         break;
      }
      break;

   case PMD_TEST_PAR_RD_CMD_DESIG:
      switch(uc_msgtype)
      {
      case PMD_TEST_PAR_READ_NACK:
         if (ft_MECmd)
         {
            gft_EocME_FEBlockReadPending = 0;
            gft_EocNack++;
         }
         break;

      case BLOCK_READ_ACK:
         if (ft_MECmd)
         {
            gft_EocME_FEBlockReadPending = 0;

            gft_SendFEDataFlag = 1; // schedule the auto msg
         }
         break;
         //XDSLRTFW-2184: Vector Block read
      case VECTOR_BLOCK_READ_ACK:
         {
            if (ft_MECmd)
            {
               gft_EocNack = 0;
               gft_EocME_FEBlockReadPending = 0;

               gft_SendFEDataFlag = 1; // schedule the auto msg
            }
         }
         break;

      default:
         if (uc_msgtype == guc_BLOCK_READ)
         {
            if (ft_timedout) // the send timed-out
            {
               gft_EocME_FEBlockReadPending = 0;
            }
         }
         break;

      } // switch
      break;

   case CLEAR_EOC_CMD_DESIG:

      // Check if timeout occurs while waiting for Ack for a clear eoc message
      if ((uc_msgtype == CLEAR_EOC_MSG ) && (ft_timedout == TRUE))
      {
         // Update the status
         gt_MONI_CEocTrigger.b_TxTrigger = 0;
         gt_MONI_CEocStat.us_TxStatus = EOC_CEOC_TXSTAT_TXERROR; // Tx error

         if (gt_MONI_CEocAutoMsgCtrl.b_TxAutoStatusMsgEn)
         {
            gft_SendCEocStatFlag = 1; // schedule the auto msg
         }
      }

      break;

   case EOC_CMD_DESIG:
      // the cmds are sent by CO only
      switch(uc_msgtype)
      {
      case START_TX_CORR_CRC:
      case END_TX_CORR_CRC:
         if (ft_timedout)
         {
            gt_MONI_CrptCRCStat.b_EocCpeTxMsgPending = 0;
            gt_MONI_CrptCRCStat.b_CpeTx = EOC_TXRXCORRUPTCRC_ERROR;
         }
         else
         {
            gt_MONI_CrptCRCStat.b_CpeTx = START_TX_CORR_CRC==uc_msgtype ? 1 : 0;
         }
         break;

      case START_RX_CORR_CRC:
      case END_RX_CORR_CRC:
         if (ft_timedout)
         {
            gt_MONI_CrptCRCStat.b_EocCpeRxMsgPending = 0;
            gt_MONI_CrptCRCStat.b_CpeRx = EOC_TXRXCORRUPTCRC_ERROR;
         }
         else
         {
            gt_MONI_CrptCRCStat.b_CpeRx = START_RX_CORR_CRC==uc_msgtype ? 1 : 0;
         }
         break;

      case EOC_ACK:
         if (ft_MECmd)
         {
            if (gt_MONI_CrptCRCStat.b_EocCpeTxMsgPending)
            {
               gt_MONI_CrptCRCStat.b_EocCpeTxMsgPending = 0;
               gt_MONI_CrptCRCStat.b_CpeTx = gt_MONI_CrptCRCCtrl.b_CpeTx;
            }

            if (gt_MONI_CrptCRCStat.b_EocCpeRxMsgPending)
            {
               gt_MONI_CrptCRCStat.b_EocCpeRxMsgPending = 0;
               gt_MONI_CrptCRCStat.b_CpeRx = gt_MONI_CrptCRCCtrl.b_CpeRx;
            }
         }
         break;
      } // switch
      break;

   case TIME_CMD_DESIG:
      // the cmds are sent by CO only
      switch(uc_msgtype)
      {
      case SET_TIME: // sent by CO only
      case TIME_READ: // sent by CO only
         if (ft_timedout)
         {
            gt_TimeStat.us_EocStatus = EOC_TIMECMD_TXERROR;
            gt_MONI_TimeSyncCtrl.us_EocCmd = 0;
         }
         break;

      case TIME_READ_ACK:
      case TIME_ACK:
         if (ft_MECmd)
         {
            gt_TimeStat.us_EocStatus = 0;
            gt_MONI_TimeSyncCtrl.us_EocCmd = 0;

            if (gt_MONI_TimeSyncCtrl.b_AutoMsgEn)
            {
               gft_SendTimeSyncMsgFlag = 1; // schedule the auto msg
            }
         }
         break;
      } // switch
      break;

      // XDSLRTFW-1929 (Start_End)
   case SEGMENT_ACK_PRIOR2:
      //reset the ovhd segment info for the new msg
      gsa_Tx_OvhdMsgSegIndx[OVHD_LOW_PRIORITY] = -1;
      gsa_Rx_OvhdMsgSegIndx[OVHD_LOW_PRIORITY] = -1;
      gfta_FirstOvhdMsgSeg[OVHD_LOW_PRIORITY] = FALSE;
      break;

   } // switch
}

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: CopyFeHlog
 *
 *  Description: copies the FE Hlog value to FE Data memory
 *
 *  Prototype: void CopyFeHlog(const uint16 us_CarrierGroup, const uint16 us_MeasureTime,
 *                             const uint16 us_Hlog)
 *
 *  Input Arguments: us_CarrierGroup index in the range of 0..511,
 *                   us_MeasureTime (Hlog measurement time),
 *                   us_Hlog in the range of 0..1023
 *
 *  Output Arguments: n/a
 *
 *  Global Variables Used: gt_FEData
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void CopyFeHlog(const uint16 us_CarrierGroup, const uint16 us_MeasureTime, const uint16 us_Hlog)
{
   static uint8 uc_ix = 0;

   /* int16 s_Hlog =  (us_Hlog/10) - 96; // convert from -96..6 to 0..1023 */

   if (us_CarrierGroup == gt_FEData.us_StartIndex)
   {
      gt_ChannelMeasurement_FE.us_HlogMT = us_MeasureTime;  // XDSLRTFW-3606 (Start_End)
      uc_ix = 0;
   }

   if (uc_ix < EOC_NUM_SCGs_FEDATA)
   {
      gt_FEData.pmdTestParams[uc_ix++].us_Hlog = us_Hlog;
   }
}

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: CopyFeQln
 *
 *  Description: copies the FE Qln value to FE Data memory
 *
 *  Prototype: void CopyFeQln(const uint16 us_CarrierGroup, const uint16 us_MeasureTime,
 *                            const uint16 us_Qln)
 *
 *  Input Arguments: us_CarrierGroup index in the range of 0..511,
 *                   us_MeasureTime (Qln measurement time),
 *                   us_Qln in the range of 0..255
 *
 *  Output Arguments: n/a
 *
 *  Global Variables Used: gt_FEData
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void CopyFeQln(const uint16 us_CarrierGroup, const uint16 us_MeasureTime, const uint8 uc_Qln)
{
   static uint8 uc_ix = 0;

   /* int8 c_Qln = (uc_Qln/2) - 150; // convert from -150..-23 to 0..254 */

   if (us_CarrierGroup == gt_FEData.us_StartIndex)
   {
      gt_ChannelMeasurement_FE.us_QlnMT = us_MeasureTime;   // XDSLRTFW-3606 (Start_End)
      uc_ix = 0;
   }

   if (uc_ix < EOC_NUM_SCGs_FEDATA)
   {
      gt_FEData.pmdTestParams[uc_ix++].uc_Qln = uc_Qln;
   }
}

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: CopyFeSnr
 *
 *  Description: copies the FE Snr value to FE Data memory
 *
 *  Prototype: void CopyFeSnr(const uint16 us_CarrierGroup, const uint16 us_MeasureTime,
 *                            const uint16 us_Snr)
 *
 *  Input Arguments: us_CarrierGroup index in the range of 0..511,
 *                   us_MeasureTime (Snr measurement time),
 *                   us_Snr in the range of 0..255
 *
 *  Output Arguments: n/a
 *
 *  Global Variables Used: gt_FEData
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void CopyFeSnr(const uint16 us_CarrierGroup, const uint16 us_MeasureTime, const uint8 uc_Snr)
{
   static uint8 uc_ix = 0;

   /* int8 c_Snr = (uc_Snr/2) - 32; // convert from 0..254 to -32..95 */

   if (us_CarrierGroup == gt_FEData.us_StartIndex)
   {
      gt_ChannelMeasurement_FE.us_SnrMT = us_MeasureTime;   // XDSLRTFW-3606 (Start_End)
      uc_ix = 0;
   }

   if (uc_ix < EOC_NUM_SCGs_FEDATA)
   {
      gt_FEData.pmdTestParams[uc_ix++].uc_Snr = uc_Snr;
   }
}

/******************************************************************************
*   Subroutine Name: rx_test_param_rd_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received test parameter read command
*
*   Prototype:
*     void rx_test_param_rd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/

//extern int32 gl_x1, gl_x2, gl_x3, gl_x4;
extern int16 gs_EocMsgRcv; //Debug
void rx_test_param_rd_handler(uint8* puca_buffer,
                              TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 l_Action, k=0, avgfactor=0;
   int16 j, s_temp;
   uint32 ul_temp = 0;

   TxEocControl_t *pt_TxEocControlInfo;

   int16 s_ActualAggregateXmtPwr,s_Actual_INP_IFEC; // temp

   uint16 i;
   uint16 us_startIx = 0;
   uint16 us_endIx = 0;
   uint16 us_Temp1,us_Temp2;

   uint16 us_Hlogf_measurement_period_FE = 0;
   uint16 us_QLN_measurement_period_FE = 0;
   uint16 us_snr_measurement_period_FE = 0;

   // local vars
   uint16 us_US_Hlogf_FE = 0;
   uint32 ul_US_Hlogf_FE = 0;
   uint32 ul_US_QlnSnr_FE = 0;

   uint16 us_numBytesforHlog;
   uint16 us_numBytesforQln;
   uint16 us_numBytesforSnr;
   uint16 us_numBytes;

   uc_msg_type = puca_buffer[k++];

   l_Action = 0;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
   case SINGLE_READ:
      l_Action = 1;
      t_TxOvhdMsgInfoInput->uc_message_type = SINGLE_READ_ACK;
      break;

   case NEXT_MULT_READ:
      l_Action = 1;

      // Increment the saved sub carrier index to transmit info about this
      // sub carrier in the next mult read
      t_TxOvhdMsgInfoInput->us_param_rd_carrier_index = ++gus_param_rd_carrier_index_Rx;

      if(t_TxOvhdMsgInfoInput->us_param_rd_carrier_index < EOC_MAX_SCG)
      {
         t_TxOvhdMsgInfoInput->uc_message_type = MULT_READ_ACK;
      }
      else
      {
         // If sub carrier index goes out of range, send a NACK
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;
      }

      break;
      //XDSLRTFW-1777(START)
   case SCALAR_READ:

      l_Action = 1;//scalar read request, set to 1 so to send the response
      t_TxOvhdMsgInfoInput->uc_message_type = SCALAR_READ_ACK;
      t_TxOvhdMsgInfoInput->uc_TestParameterId = puca_buffer[1];
      if(t_TxOvhdMsgInfoInput->uc_TestParameterId==FE_ACTUAL_SNRM_ROC)
      {
         // If test parameter requested is SNRM ROC, send a NACK as ROC SNRM is not implemented
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;
      }

      break;
      //XDSLRTFW-1777(END)
   case MULT_READ_ACK:
   case BLOCK_READ_ACK:
   case VECTOR_BLOCK_READ_ACK:

      // Get the pointer to the last transmitted priority 2 message
      // awaiting response from the other end
      pt_TxEocControlInfo = &gta_TxEocControlInfo[OVHD_LOW_PRIORITY];
      l_Action = 2;

      if (uc_msg_type == MULT_READ_ACK)
      {
         us_startIx = pt_TxEocControlInfo->us_param_rd_carrier_index;
         us_endIx = pt_TxEocControlInfo->us_param_rd_carrier_index;
      }
      // Block Read Ack
      //XDSLRTFW-2184: Vector Block read
      else if (uc_msg_type == BLOCK_READ_ACK)
      {
         us_startIx = pt_TxEocControlInfo->us_param_rd_start_carrier_index;
         us_endIx = pt_TxEocControlInfo->us_param_rd_stop_carrier_index;
      }
      else if (uc_msg_type == VECTOR_BLOCK_READ_ACK)
      {
         us_startIx = pt_TxEocControlInfo->us_param_rd_start_carrier_index;
         us_endIx = pt_TxEocControlInfo->us_param_rd_stop_carrier_index;
      }

      if((us_startIx >= EOC_MAX_SCG) || (us_endIx >= EOC_MAX_SCG) || (us_endIx < us_startIx))
      {
         // If sub carrier index goes out of range, send a NACK
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;
         break;
      }
      //XDSLRTFW-2184: Vector Block read
      if (uc_msg_type == VECTOR_BLOCK_READ_ACK)
      {
         switch(pt_TxEocControlInfo->uc_ExpectedTestParamId)
         {
         case TEST_PARAM_HLOG_ID:
            gs_EocMsgRcv |= 0x1;
            // measurement period
            us_Hlogf_measurement_period_FE = (uint16)(puca_buffer[k++]<<8);
            us_Hlogf_measurement_period_FE |= (uint16)puca_buffer[k++];

            // Hlogf m
            // XDSLRTFW-2774 (Start)
            gt_ChannelMeasurement_FE.us_HlogMT = us_Hlogf_measurement_period_FE;    // XDSLRTFW-3606 (Start_End)
            for (i = us_startIx; i <= us_endIx; i++)
            {
               //Change in Format is due to CMV Read : INFO 75
               us_US_Hlogf_FE = (uint16)(puca_buffer[k++]<<8);
               us_US_Hlogf_FE |= (uint16)(puca_buffer[k++]);

               gt_FEParams.us_Hlog[i] = us_US_Hlogf_FE;
            }
            // XDSLRTFW-2774 (End)
            break;
         case TEST_PARAM_QLN_ID:
            gs_EocMsgRcv |= 0x2;
            // measurement period
            us_QLN_measurement_period_FE = (uint16)(puca_buffer[k++]<<8);
            us_QLN_measurement_period_FE |= (uint16)puca_buffer[k++];

            // XDSLRTFW-2774 (Start)
            gt_ChannelMeasurement_FE.us_QlnMT = us_QLN_measurement_period_FE;  // XDSLRTFW-3606 (Start_End)
            for (i = us_startIx; i <= us_endIx; i++)
            {
               gt_FEParams.uc_Qln[i] = puca_buffer[k++];
            }
            // XDSLRTFW-2774 (End)

            break;
         case TEST_PARAM_SNR_ID:
            gs_EocMsgRcv |= 0x4;
            // measurement period
            us_snr_measurement_period_FE = (uint16)(puca_buffer[k++]<<8);
            us_snr_measurement_period_FE |= (uint16)puca_buffer[k++];

            // XDSLRTFW-2774 (Start)
            gt_ChannelMeasurement_FE.us_SnrMT = us_snr_measurement_period_FE;    // XDSLRTFW-3606 (Start_End)
            for (i = us_startIx; i <= us_endIx; i++)
            {
               gt_FEParams.uc_Snr[i] = puca_buffer[k++];
            }
            // XDSLRTFW-2774 (End)

            break;
         } //Switch

         if (pt_TxEocControlInfo->ft_MECmd)
         {
            gft_EocNack = 0;
            gft_EocME_FEBlockReadPending = 0;
         }
      }
      else //Block Read Only
      {
         //pus_msg_length = 2 + (2 * TX_NUM_TONES);
         // measurement period
         us_Hlogf_measurement_period_FE = (uint16)(puca_buffer[k++]<<8);
         us_Hlogf_measurement_period_FE |= (uint16)puca_buffer[k++];

         // Hlogf m
         // XDSLRTFW-2774 (Start)
         gt_ChannelMeasurement_FE.us_HlogMT  = us_Hlogf_measurement_period_FE;   // XDSLRTFW-3606 (Start_End)
         for (i = us_startIx; i <= us_endIx; i++)
         {
            us_US_Hlogf_FE = 0;

            us_US_Hlogf_FE = (uint16)(puca_buffer[k++]<<8);
            us_US_Hlogf_FE |= (uint16)puca_buffer[k++];
            gt_FEParams.us_Hlog[i] = us_US_Hlogf_FE;
         }
         // XDSLRTFW-2774 (End)


         // measurement period
         us_QLN_measurement_period_FE = (uint16)(puca_buffer[k++]<<8);
         us_QLN_measurement_period_FE |= (uint16)puca_buffer[k++];

         // QLN
         // XDSLRTFW-2774 (Start)
         gt_ChannelMeasurement_FE.us_QlnMT = us_QLN_measurement_period_FE;    // XDSLRTFW-3606 (Start_End)
         for (i = us_startIx; i <= us_endIx; i++)
         {
            gt_FEParams.uc_Qln[i] = puca_buffer[k++];
         }
         // XDSLRTFW-2774 (End)


         // measurement period
         us_snr_measurement_period_FE = (uint16)(puca_buffer[k++]<<8);
         us_snr_measurement_period_FE |= (uint16)puca_buffer[k++];

         // SNR
         // XDSLRTFW-2774 (Start)
         gt_ChannelMeasurement_FE.us_SnrMT = us_snr_measurement_period_FE;    // XDSLRTFW-3606 (Start_End)
         for (i = us_startIx; i <= us_endIx; i++)
         {
            gt_FEParams.uc_Snr[i] = puca_buffer[k++];
         }
         // XDSLRTFW-2774 (End)


         if (pt_TxEocControlInfo->ft_MECmd)
         {
            gft_EocNack = 0;
            gft_EocME_FEBlockReadPending = 0;
         }
      }

      break;

   case SINGLE_READ_ACK:
      //interpret the single read response from CO
      rx_single_rd_param_handler(puca_buffer,t_TxOvhdMsgInfoInput,uc_msg_type,k);
      break;

      //XDSLRTFW-1777(START)
   case SCALAR_READ_ACK:
      //response from CO
      switch(gt_OlrPm_RxOvhdMsgInfoInput.uc_TestParameterId)
      {
      case LINE_ATTENUATION:
         //XDSLRTFW-1387 (Start)
         for(j=0; j < 5; j++)
         {
            s_temp = (int16)(puca_buffer[k++]<<8);
            s_temp |= (int16)puca_buffer[k++];

            // if received value is 0 and corresponding band is not loaded
            if ((s_temp == 0) && (!IsTxBandLoaded(j)))
            {
               s_temp = OUT_OF_RANGE_LATN;
            }
            gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_LATN = s_temp;
            if(s_temp != OUT_OF_RANGE_LATN)
            {
               ul_temp += s_temp;
               avgfactor++;
            }
         }
         ul_temp = ul_temp/avgfactor; //31.1 format
         gt_LineStatusUS.us_LoopAttenuation = (uint16)ul_temp;
         //XDSLRTFW-1387 (End)

         break;

      case SIGNAL_ATTENUATION:
         //XDSLRTFW-1387 (End)
         ul_temp = 0;
         avgfactor = 0;
         for(j=0; j < 5; j++)
         {
            s_temp = (int16)(puca_buffer[k++]<<8);
            s_temp |= (int16)puca_buffer[k++];
            // if received value is 0 and corresponding band is not loaded
            if ((s_temp == 0) && (!IsTxBandLoaded(j)))
            {
               s_temp = OUT_OF_RANGE_SATN;
            }
            gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SATN = s_temp;
            if(s_temp != OUT_OF_RANGE_LATN)
            {
               ul_temp += s_temp;
               avgfactor++;
            }
         }
         ul_temp = ul_temp/avgfactor; //31.1 format
         gt_LineStatusUS.us_SignalAttenuation = (uint16)ul_temp;
         //XDSLRTFW-1387 (End)

         break;

      case SIGNAL_TO_NOISE_MARGIN:

         gt_LineStatusUS.s_SnrMargin = (uint16)(puca_buffer[k++]<<8);
         gt_LineStatusUS.s_SnrMargin |= (uint16)puca_buffer[k++];

         for(j=0; j < 5; j++)
         {
            s_temp = (int16)(puca_buffer[k++]<<8);
            s_temp |= (int16)puca_buffer[k++];
            // if received value is 0 and corresponding band is not loaded
            if ((s_temp == 0) && (!IsTxBandLoaded(j)))
            {
               s_temp = OUT_OF_RANGE_SNRM;
            }
            gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SNRM = s_temp;
         }

         // calculate the lom failure here, comparing the updated average updated snrm
         // with the negotiated one. Comparisons are done in the 0.1 dB format so
         // the received SNRMargin is converted to the 0.1 dB format by
         // x_in_0.1dB = (x_in_q8.8 * 10) >> 8

         //               if (gt_LineStatusUS.s_SnrMargin < gt_SnrMgnConfig.s_MINSNRMus)
         //                     gt_RxIbData.uc_lom_fail = PRESENT;
         //               else
         //                     gt_RxIbData.uc_lom_fail = TERMINATED;
         break;


      case ATTAIN_NET_DATA_RATE:
         gt_LineStatusUS.ul_AttainableDataRate = (uint32)(puca_buffer[k++]<<24);
         gt_LineStatusUS.ul_AttainableDataRate |= (uint32)(puca_buffer[k++]<<16);
         gt_LineStatusUS.ul_AttainableDataRate |= (uint32)(puca_buffer[k++]<<8);
         gt_LineStatusUS.ul_AttainableDataRate |= (uint32)puca_buffer[k++];
         //XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(Start)
         if((guc_attndr_method!= ATTNDR_METHOD_0) && (guc_attndr_method_from_co != ATTNDR_METHOD_0))
         {
            if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
            {
               gus_attndr_SHINE_INP_FE = (int16)(puca_buffer[k++]<<8);
               gus_attndr_SHINE_INP_FE |=(int16)puca_buffer[k++];
               gus_attndr_REIN_INP_FE = (int16)puca_buffer[k++];
               gus_attndr_delay_FE = (int16)puca_buffer[k++];
            }
            else
            {
               // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
               k++;              // Modified to supresss warning
               guc_ATTNDR_INP_Act_FE = puca_buffer[k++];
               k++;              // Modified to supresss warning
               guc_ATTNDR_Delay_Act_FE = puca_buffer[k++];
               // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

            }
         }
         //XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(Start)
         break;
// XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)

      case NE_ACTUAL_TRANSMIT_POWER:
         // gt_LineStatusDS structure contains DS information.
         // gt_LineStatusDS.s_ActualAggregateXmtPwr contains DS ACT ATP. This info is
         // transmitted by CO as it's NE parameter

         gt_LineStatusDS.s_ActualAggregateXmtPwr = (int16)(puca_buffer[k++]<<8);
         gt_LineStatusDS.s_ActualAggregateXmtPwr |= (int16)puca_buffer[k++];
         break;

      case FE_ACTUAL_TRANSMIT_POWER:
         // This is US ACT ATP transmitted by CO as it's FE parameter.
         // Since it is calculated by CPE and stored in gt_LineStatusUS.s_ActualAggregateXmtPwr,
         // CO transmitted US ACT ATP is not stored.
         s_ActualAggregateXmtPwr = (int16)(puca_buffer[k++]<<8);
         s_ActualAggregateXmtPwr |= (int16)puca_buffer[k++];
         break;
// XDSLRTFW-3071 US & DS ATP reporting is swapped (End)

      case FE_ACTUAL_INP_IFEC:
         us_Temp1 = (int16)(puca_buffer[k++]);//BCO INP
         us_Temp2 = (int16)puca_buffer[k++];//BC1 INP
         s_Actual_INP_IFEC  = us_Temp1;
         break;

      case FE_ACTUAL_SNRM_ROC:
         //ROC not implemented
         //us_SNRM_ROC = puca_buffer[k++];
         break;
         //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (start)


      } /* end of switch(t_TxOvhdMsgInfoInput->uc_TestParameterId) */
      //XDSLRTFW-1777(END)

      break;

   case PMD_TEST_PAR_READ_NACK:
      pt_TxEocControlInfo = &gta_TxEocControlInfo[OVHD_LOW_PRIORITY];
      l_Action = 2;

      // clear any flags that indicate a msg is pending
      CheckMsgPendingFlags(pt_TxEocControlInfo->uc_ExpectedDesignator,
                           uc_msg_type, pt_TxEocControlInfo->ft_MECmd, 0);

      break;

   default:

      if ((uc_msg_type == guc_MULT_READ) ||
            (uc_msg_type == guc_BLOCK_READ)||
            (uc_msg_type == VECTOR_BLOCK_READ))
      {

         //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START)
         if ((gul_fe_G994VendorID == IKNS_VENDOR_ID) && (uc_msg_type == guc_MULT_READ))
         {
            uc_msg_type = guc_BLOCK_READ;
         }
         //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (END)

         //Mei test code: log mult_read, block_read and vector_block_read commands
         //#define EOC_DEBUG_DATA
#ifdef EOC_DEBUG_DATA
         extern void LogEocMsg(uint8 uc_msg_type, uint8 *puca_buffer);
         LogEocMsg(uc_msg_type, puca_buffer);
#endif //#ifdef EOC_DEBUG_DATA

         l_Action = 1;

         // If sub carrier index goes out of range, send a NACK
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;

         // Multiple Read
         if (uc_msg_type == guc_MULT_READ)
         {
            // Get the sub carrier index
            t_TxOvhdMsgInfoInput->us_param_rd_carrier_index = (puca_buffer[1]<<8)  | puca_buffer[2];

            // Verify the sub carrier index
            if (t_TxOvhdMsgInfoInput->us_param_rd_carrier_index < EOC_MAX_SCG)
            {
               // keep track of the index for NEXT_MULT_READ usage.
               gus_param_rd_carrier_index_Rx = t_TxOvhdMsgInfoInput->us_param_rd_carrier_index;
               t_TxOvhdMsgInfoInput->uc_message_type = MULT_READ_ACK;
            }
         }
         // Block Read
         else if((uc_msg_type == guc_BLOCK_READ) || (uc_msg_type == VECTOR_BLOCK_READ))
         {
            uint16 us_start_idx, us_stop_idx, i;

            if(uc_msg_type == VECTOR_BLOCK_READ)
            {
               t_TxOvhdMsgInfoInput->uc_TestParameterId = puca_buffer[1];
               i = 2;
            }
            else
            {
               i= 1;
            }

            us_start_idx = (puca_buffer[i]<<8)  | puca_buffer[i+1];
            us_stop_idx = (puca_buffer[i+2]<<8)  | puca_buffer[i+3];

            // Verify the # of tones <= 160(gs_MaxTonePerOvhdMsg). Protect against block read responses that are too large.
            // For Block read, the total length is: (Hlog) 2+2*(stopTone - startTone+1)
            //                               (QLN) +2+(stopTone - startTone+1)
            //                              (SNR) +2+(stopTone - startTone+1)

            // Verify the sub carrier index
            if((us_start_idx < EOC_MAX_SCG) && (us_stop_idx < EOC_MAX_SCG) && (us_stop_idx >= us_start_idx))
            {
               // G.993.2 length calculation (octets)
               us_numBytes = (us_stop_idx - us_start_idx + 1);
               us_numBytesforHlog = 2 + (us_numBytes * 2);
               us_numBytesforQln = us_numBytesforSnr = (2 + us_numBytes);

               if(uc_msg_type == guc_BLOCK_READ)
               {
                  us_numBytes = us_numBytesforHlog + us_numBytesforQln + us_numBytesforSnr;
               }
               else
               {
                  switch(t_TxOvhdMsgInfoInput->uc_TestParameterId)
                  {
                  case TEST_PARAM_HLOG_ID:
                     us_numBytes = us_numBytesforHlog;
                     break;
                  case TEST_PARAM_QLN_ID:
                     us_numBytes = us_numBytesforQln;
                     break;
                  case TEST_PARAM_SNR_ID:
                     us_numBytes = us_numBytesforSnr;
                     break;
                  default:
                     //for unknow id, set this number very high so it will fail
                     us_numBytes = 0x7FFF;
                     break;
                  }
               }

               /* when we xmit the response we dont want to overrun the buffer */
               //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START_END)
               //if ((us_numBytes <= MAX_OVHD_MESSAGE_LEN) && (us_numBytes <= MAX_TX_EOC_BUFFER_SIZE))
               {
                  t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index = us_start_idx;
                  t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index = us_stop_idx;

                  if(uc_msg_type == VECTOR_BLOCK_READ)
                  {
                     t_TxOvhdMsgInfoInput->uc_message_type = VECTOR_BLOCK_READ_ACK;
                  }
                  else
                  {
                     t_TxOvhdMsgInfoInput->uc_message_type = BLOCK_READ_ACK;
                  }
               }
            } //if(us_start_idx < EOC_MAX_SCG) && (us_stop_idx < EOC_MAX_SCG) && (us_stop_idx >= us_start_idx)
         } //else if((uc_msg_type == guc_BLOCK_READ) || (uc_msg_type == VECTOR_BLOCK_READ))
      }
      else
      {
         l_Action = 1;

         //for all other commands/response, send a NACK
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;
      }

      break;

   } // switch

   if (l_Action == 1)
   {
      TxEocSendRequest(2, *t_TxOvhdMsgInfoInput);
   }

   //DSM_Vectoring_Debug:
   //if (gs_PauseControl == 0x23)
   //Pause(gs_PauseControl);


}
/*****************************************************************************
*   Subroutine Name: rx_single_rd_param_handler
*
*   Description:
*      This subroutine processes the received single read overhead message
*
*   Prototype:
*      void rx_single_rd_param_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,uint8 uc_msg_type,int32 k)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_single_rd_param_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,uint8 uc_msg_type,int32 k)
{

   int32 l_Action=0, avgfactor=0;
   int16 j, s_temp;
   uint32 ul_temp = 0;
   uint16 us_Temp;
   int16 s_ActualAggregateXmtPwr; // temp

   //LINE_ATTENUATION:
   //XDSLRTFW-1387 (Start)
   for(j=0; j < 5; j++)
   {
      s_temp = (int16)(puca_buffer[k++]<<8);
      s_temp |= (int16)puca_buffer[k++];

      // if received value is 0 and corresponding band is not loaded
      if ((s_temp == 0) && (!IsTxBandLoaded(j)))
      {
         s_temp = OUT_OF_RANGE_LATN;
      }
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_LATN = s_temp;
      if(s_temp != OUT_OF_RANGE_LATN)
      {
         ul_temp += s_temp;
         avgfactor++;
      }
   }
   ul_temp = ul_temp/avgfactor; //31.1 format
   gt_LineStatusUS.us_LoopAttenuation = (uint16)ul_temp;
   //XDSLRTFW-1387 (End)

   //SIGNAL_ATTENUATION:
   //XDSLRTFW-1387 (End)
   ul_temp = 0;
   avgfactor = 0;
   for(j=0; j < 5; j++)
   {
      s_temp = (int16)(puca_buffer[k++]<<8);
      s_temp |= (int16)puca_buffer[k++];
      // if received value is 0 and corresponding band is not loaded
      if ((s_temp == 0) && (!IsTxBandLoaded(j)))
      {
         s_temp = OUT_OF_RANGE_SATN;
      }
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SATN = s_temp;
      if(s_temp != OUT_OF_RANGE_LATN)
      {
         ul_temp += s_temp;
         avgfactor++;
      }
   }
   ul_temp = ul_temp/avgfactor; //31.1 format
   gt_LineStatusUS.us_SignalAttenuation = (uint16)ul_temp;
   //XDSLRTFW-1387 (End)

   //SIGNAL_TO_NOISE_MARGIN
   gt_LineStatusUS.s_SnrMargin = (uint16)(puca_buffer[k++]<<8);
   gt_LineStatusUS.s_SnrMargin |= (uint16)puca_buffer[k++];

   for(j=0; j < 5; j++)
   {
      s_temp = (int16)(puca_buffer[k++]<<8);
      s_temp |= (int16)puca_buffer[k++];
      // if received value is 0 and corresponding band is not loaded
      if ((s_temp == 0) && (!IsTxBandLoaded(j)))
      {
         s_temp = OUT_OF_RANGE_SNRM;
      }
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SNRM = s_temp;
   }

   // calculate the lom failure here, comparing the updated average updated snrm
   // with the negotiated one. Comparisons are done in the 0.1 dB format so
   // the received SNRMargin is converted to the 0.1 dB format by
   // x_in_0.1dB = (x_in_q8.8 * 10) >> 8

   //               if (gt_LineStatusUS.s_SnrMargin < gt_SnrMgnConfig.s_MINSNRMus)
   //                     gt_RxIbData.uc_lom_fail = PRESENT;
   //               else
   //                     gt_RxIbData.uc_lom_fail = TERMINATED;



   //ATTAIN_NET_DATA_RATE
   gt_LineStatusUS.ul_AttainableDataRate = (uint32)(puca_buffer[k++]<<24);
   gt_LineStatusUS.ul_AttainableDataRate |= (uint32)(puca_buffer[k++]<<16);
   gt_LineStatusUS.ul_AttainableDataRate |= (uint32)(puca_buffer[k++]<<8);
   gt_LineStatusUS.ul_AttainableDataRate |= (uint32)puca_buffer[k++];
   //XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(Start)
   if((guc_attndr_method!=0) && (guc_attndr_method_from_co != ATTNDR_METHOD_0))
   {
      if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         gus_attndr_SHINE_INP_FE = (int16)(puca_buffer[k++]<<8);
         gus_attndr_SHINE_INP_FE |=(int16)puca_buffer[k++];
         gus_attndr_REIN_INP_FE = (int16)puca_buffer[k++];
         gus_attndr_delay_FE = (int16)puca_buffer[k++];
      }
      else
      {
         // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
         k++;              // Modified to supresss warning
         guc_ATTNDR_INP_Act_FE = puca_buffer[k++];
         k++;              // Modified to supresss warning
         guc_ATTNDR_Delay_Act_FE = puca_buffer[k++];
         // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)
      }

   }
   //XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(Start)

// XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)
   //NE_ACTUAL_TRANSMIT_POWER (0x25)
   // gt_LineStatusDS structure contains DS information.
   // gt_LineStatusDS.s_ActualAggregateXmtPwr contains DS ACT ATP. This info is
   // transmitted by CO as it's NE parameter

   gt_LineStatusDS.s_ActualAggregateXmtPwr = (int16)(puca_buffer[k++]<<8);
   gt_LineStatusDS.s_ActualAggregateXmtPwr |= (int16)puca_buffer[k++];

   //FE_ACTUAL_TRANSMIT_POWER (0x26)
   // This is US ACT ATP transmitted by CO as it's FE parameter.
   // Since it is calculated by CPE and stored in gt_LineStatusUS.s_ActualAggregateXmtPwr,
   s_ActualAggregateXmtPwr = (int16)(puca_buffer[k++]<<8);
   s_ActualAggregateXmtPwr |= (int16)puca_buffer[k++];
// XDSLRTFW-3071 US & DS ATP reporting is swapped (End)


   //FE_INP_act_SHINE
   us_Temp = (int16)(puca_buffer[k++]<<8);
   us_Temp |= (int16)puca_buffer[k++];
   gt_ReTXStats.us_FE_InpActShine = us_Temp;

   //FE_INP_act_RINE:
   gt_ReTXStats.us_FE_InpActRine = puca_buffer[k++];

   //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (start)
   //XDSLRTFW-1546(START_END)
   if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      //USRETX_RECEIVER_ETR
      gt_ReTXStats.ul_UsReTX_ReceiverETR  = (uint32)(puca_buffer[k++]<<24);
      gt_ReTXStats.ul_UsReTX_ReceiverETR |= (uint32)(puca_buffer[k++]<<16);
      gt_ReTXStats.ul_UsReTX_ReceiverETR |= (uint32)(puca_buffer[k++]<<8);
      gt_ReTXStats.ul_UsReTX_ReceiverETR |= (uint32) puca_buffer[k++];
      //break;

      //USRETX_RECEIVER_ACTUAL_DELAY
      gt_ReTXStats.us_UsReTX_ReceiverActualDelay = (uint16) ( puca_buffer[k++] *100);
   }
   //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt(End)


}


#ifdef OVHD_MSG_SEGMENTATION

/*****************************************************************************
*   Subroutine Name: rx_segment_ack_handler
*
*   Description:
*      This subroutine processes the received overhead message
*
*   Prototype:
*      void rx_segment_ack_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_segment_ack_handler(uint8 uc_message_priority, uint8* puca_msg_buffer,
                            TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   //double check whether the message type is right
   if (puca_msg_buffer[3] == SEGMENT_ACK_TYPE)
   {
      //save what is the segmented msg index CO requested
      gsa_Rx_OvhdMsgSegIndx[uc_message_priority] = puca_msg_buffer[4];

      //Check the validity of gs_COReq_OvhdMsgSegIndx
      if ((gsa_Rx_OvhdMsgSegIndx[uc_message_priority] >= 1) && (gsa_Rx_OvhdMsgSegIndx[uc_message_priority] <= 7)
            && (gsa_Rx_OvhdMsgSegIndx[uc_message_priority] == gsa_Tx_OvhdMsgSegIndx[uc_message_priority]))
      {
         // we got the correct ACK
         //overwrite the message designator, message type from ACK

         //clear ACK expect flag
         gta_TxEocControlInfo[uc_message_priority].ft_ack_expected = FALSE;

         // request sending of next segment
         t_TxOvhdMsgInfoInput->uc_message_designator = puca_msg_buffer[5];
         t_TxOvhdMsgInfoInput->uc_message_type = puca_msg_buffer[6];
         t_TxOvhdMsgInfoInput->uc_Segmented = TRUE;

         if (uc_message_priority == 0)
         {
            // must be SRA commands
            t_TxOvhdMsgInfoInput->uc_Source = AUTO_CMD_SOURCE;
         }
         else
         {
            // probably either Hlog or PM
            t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
         }

         TxEocSendRequest(uc_message_priority, *t_TxOvhdMsgInfoInput);
      }
      //else
      //{
      // Options to deal with invalid ACK
      // 1. Ignore, continue waiting for ACK until timeout
      // 2. Reset everything, abort current xmit session, start from very beginning and
      // ready for the next new ovhd msg
      //
      // Option 1 seems more flexible
      //}
   }
}

#endif

/*****************************************************************************
*   Subroutine Name: rx_clear_eoc_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received clear eoc command
*
*   Prototype:
*     void rx_clear_eoc_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_clear_eoc_handler(uint8* puca_buffer,
                          TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int16 k=0;
   TxEocControl_t *pt_TxEocControlInfo;

   uc_msg_type = puca_buffer[k++];

   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if(uc_msg_type == CLEAR_EOC_MSG)
   {
#ifdef CLEAR_EOC
      int16 i=0;
      gt_MONI_CEocStat.us_RxStatus = EOC_CEOC_RXSTAT_RXINPROGRESS; // msg retrieval started

      gt_INFO_CEocRxBuf.us_NumBytes = gus_eoc_msg_len - 6;

      // if the received message index is over the limit
      if (gt_INFO_CEocRxBuf.us_NumBytes > MAX_ME_EOC_MSG_SIZE)
      {
         gt_MONI_CEocStat.us_RxStatus = EOC_CEOC_RXSTAT_RXERROR; // RX error

         if (gt_MONI_CEocAutoMsgCtrl.b_RxAutoStatusMsgEn)
         {
            gft_SendCEocStatFlag = 1; // schedule the auto msg
         }

         // set the flag to indicate that a clear EOC NACK needs to be sent
         guc_ClearEOCAckType = CLEAR_EOC_NACK;

         return;
      }

      for (i = 0; (i < MAX_ME_EOC_MSG_SIZE) && (i < gt_INFO_CEocRxBuf.us_NumBytes); i++ )
      {
         gt_INFO_CEocRxBuf.uca_MEMsg[i] = puca_buffer[k++];
      }

      // Set the flag to indicate that a clear EOC Ack needs to be sent
      // once the data received is read by the host
      guc_ClearEOCAckType = CLEAR_EOC_ACK;

      // received a CLEAR_EOC_MSG
      gt_MONI_CEocStat.us_RxStatus = EOC_CEOC_RXSTAT_DATAAVAILABLE; // msg available
      // odd number of bytes will be rounded up and 1 word for length information is added
      gs_EocCEocMsgLen = ((gt_INFO_CEocRxBuf.us_NumBytes+1) >> 1) + 1; // len in words

      if (gt_MONI_CEocAutoMsgCtrl.b_RxAutoStatusMsgEn)
      {
         gft_SendCEocStatFlag = 1; // schedule the auto msg
      }

      if (gt_MONI_CEocAutoMsgCtrl.b_AutoDataMsgEn)
      {
         gft_SendCEocMsgFlag = 1; // schedule the auto msg
         gus_EocCEocMsg_AutoMsgIx = 0; // clear message index for the new Clear EOC message
      }
#endif // CLEAR_EOC
   }
   else if ((uc_msg_type == CLEAR_EOC_ACK) || (uc_msg_type == CLEAR_EOC_NACK))
   {
      pt_TxEocControlInfo = &gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY];

      // Check if clear EOC acknowledge was pending
      if (pt_TxEocControlInfo->ft_MECmd)
      {
         gt_MONI_CEocTrigger.b_TxTrigger = 0;

         if (uc_msg_type == CLEAR_EOC_ACK)
         {
            if (gt_MONI_CEocAutoMsgCtrl.b_TxAutoStatusMsgEn)
            {
               gt_MONI_CEocStat.us_TxStatus = EOC_CEOC_TXSTAT_TXCOMPLETE;
            }
            else
            {
               gt_MONI_CEocStat.us_TxStatus = EOC_CEOC_TXSTAT_TXIDLE;
            }
         }
         else
         {
            gt_MONI_CEocStat.us_TxStatus = EOC_CEOC_TXSTAT_TXERROR;
         }

         if (gt_MONI_CEocAutoMsgCtrl.b_TxAutoStatusMsgEn)
         {
            gft_SendCEocStatFlag = 1; // schedule the auto msg
         }
      }

   }
}

// XDSLRTFW-1263_DTU_Stoppage_Handling (START)
/**Calculate T_DTU_Stoppage**/
uint32 Calc_TDTU_stoppage()
{
   uint32 Tdmt_nom, fdmt;
   uint32 Tdtu_nom, Tdtu_den;
   uint32 Qtx, INP_min, Nret_min;
   uint32 INP_min_rein, MinStopInDmtDataSymbols, MinStopDueToMinDelay;
   uint32 Tdtu_stop;
   uint32 CorrectionTime=0, CorrectionTime_Rein=0, DtuCorrection_Time=0;

   Tdmt_nom = 1;
   // Valid for all profiles except 30a(In case of 30a profile => fdmt = 8)
   fdmt = 4; /*0.25*/
   if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
   {
      fdmt = 8; /*0.125*/
   }

   INP_min_rein = (uint32)(gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min_REIN & 0x1F);
   INP_min = (uint32)(gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min & 0x1F);

   //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine(Start)
   Qtx = gt_ReTXParams.us_OPMS_UsQtx;
   /*Tdtu= 8*Q*Nfec/L1*/
   Tdtu_nom = 8 * (uint32)gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q * (uint32)(gt_tx_config_v2.sa_Bpn[LP1][ABC0] + 1 + gt_tx_config_v2.s_Rp[LP1]);
   Tdtu_den = gt_tx_config_v2.ul_Lp[LP1];
   //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine(End)
   Nret_min = 1;

   // XDSLRTFW-1344 (START)
   // Nret_min = ceil((ceil(INP_min/Tdtu)+1)/Qtx);
   if (INP_min)
   {
      Nret_min = INP_min;
      Nret_min = Nret_min * Tdtu_den;
      Nret_min = (Nret_min + Tdtu_nom - 1)/Tdtu_nom; //ceil(A/Tdtu)
      CorrectionTime = Nret_min + 1;
      Nret_min = (Nret_min + 1 + Qtx - 1)/Qtx;                                //ceil(((A)+1)/Qtx)
   }
   // ceil(INP_min_rein/Tdtu)+1
   if (INP_min_rein)
   {
      CorrectionTime_Rein = INP_min_rein;
      CorrectionTime_Rein = CorrectionTime_Rein * Tdtu_den;
      CorrectionTime_Rein = (CorrectionTime_Rein + Tdtu_nom - 1)/Tdtu_nom; //ceil(A/Tdtu)
      CorrectionTime_Rein = CorrectionTime_Rein + 1;
   }

   if ((INP_min_rein > 0) && (INP_min > 0))
   {
      Nret_min += 1;
      DtuCorrection_Time = CorrectionTime - (Qtx *(Nret_min - 2)) + CorrectionTime_Rein;
   }
   else if ((INP_min_rein > 0) && (INP_min == 0))
   {
      Nret_min = 1;
      DtuCorrection_Time = CorrectionTime_Rein;
   }
   else if ((INP_min_rein == 0) && (INP_min > 0))
   {
      DtuCorrection_Time = CorrectionTime - (Qtx*(Nret_min - 1));
   }
   else if ((INP_min_rein == 0) && (INP_min == 0))
   {
      Nret_min = 1;
      DtuCorrection_Time = 0;
   }

   //MinStopInDmtDataSymbols = ceil((Nret_min*Qtx+DtuCorrection_Time)*Tdtu)+1;
   MinStopInDmtDataSymbols = Nret_min * Qtx;
   MinStopInDmtDataSymbols += DtuCorrection_Time;
   MinStopInDmtDataSymbols = ((MinStopInDmtDataSymbols * Tdtu_nom + Tdtu_den - 1)/Tdtu_den) + 1;
   // XDSLRTFW-1344 (END)

   //MinStopDueToMinDelay = ceil(delay_min/Tdmt);
   MinStopDueToMinDelay = (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_DelayMin * fdmt + Tdmt_nom - 1)/Tdmt_nom;

   /*Tdtu_stoppage = MAX(minStopInDmtDataSymbols,minStopDueToMinDelay,TDTU_STOP_MIN);*/

   Tdtu_stop = MAX(MinStopInDmtDataSymbols + 1,MinStopDueToMinDelay);
   Tdtu_stop = MAX(TDTU_STOP_MIN,Tdtu_stop);

   return Tdtu_stop;
}
/**this function checks framing parameters carried by OLR request
   Return code:
     0 - OK
     1 - error has been detected
**/
FlagT SRA_ReTx_Parameters_Check()
{
   uint32 Nom, Den;
   uint16 H1, R1;
   uint8 Q, V, Qtx;
   FlagT  ft_pass = 1;
   int16 s_DTU_Size_bytes;

   /**check that all parameters are within allowed range**/
   /*usual framing parameters*/
   H1 = (uint16)(gt_tx_config_v2.sa_Reconfig_Bpn[LP1][ABC0] + 1); /*1 <= H1=B10[BC0,LP1]+1 <= 255*/

   if ((H1 < 1)||(H1 > 255))
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Hp_stats++;
   }

   if (gt_UsReTxShowtimeParams.s_Reconfig_Mp != 1)
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Mp_stats++;
   }

   R1 = (uint16)gt_UsReTxShowtimeParams.s_Reconfig_Rp;      /*R1 can be any even <=16 except 6*/

   if ((R1 & 1)||(R1 > 16))
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Rp_stats++;
   }

   /*ReTx specific parameters*/
   Q = gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q;
   //XDSLRTFW-2341 (Start)
   if(guc_ReTx_US_D > 1)
   {
      Q &= 0x7f;
   }
   //XDSLRTFW-2341 (End)
   if ((Q < 1)||(Q > 64))
   {
      ft_pass = 0;                    /*VDSL: 1<= Q=CWs per DTU <= 63*/
      gt_US_SRA_Stats.Q_stats++;
   }

   V = gt_UsReTxShowtimeParams.uc_DtuPaddingSize_V;                    /*0<= V=padding bytes per DTU<=15*/

   if (V > 15)
   {
      ft_pass = 0;
      gt_US_SRA_Stats.V_stats++;
   }

   Qtx = gt_UsReTxShowtimeParams.uc_RPMS_Qtx;                /*1<= Qtx=retransmit queue <= 63*/

   if ((Qtx < 1)||(Qtx > 63))
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Qtx_stats++;
   }

   if (gt_UsReTxShowtimeParams.uc_RPMS_DsLookBackValue > MIN(31, Qtx))    /*lb= look back value <= MIN(31, Qtx)*/
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Loopback_Stats++;
   }

   if (!ft_pass)
   {
      return 1;
   }

   /**check combinations of parameters**/

   /*1 <= Nfec <= 255*/
   Nom = (uint32)(H1 + R1);

   //XDSLRTFW-1415(START)
   s_DTU_Size_bytes=Nom*Q;
   //XDSLRTFW-2341 (Start - End)
   //US ReTx Memory check without Intra DTU interleaving.
   if(((Qtx * s_DTU_Size_bytes) > gul_HW_ILV_MEM_SIZE[LP1]) && (!gft_US_IDILV_ucode))
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Memory_stats++;
   }
   //XDSLRTFW-1415(END)

   //XDSLRTFW-3005 (Start)
   //US ReTx Memory check with Intra DTU interleaving.
   if(((Qtx * s_DTU_Size_bytes) > (gula_rxILVBaseAddr[LP0] - gt_ReTXParams.ul_US_ReTXQueue_BaseAddress)) && (gft_US_IDILV_ucode))
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Memory_stats++;
   }
   //XDSLRTFW-3005 (End)

   /*1 <= Nfec <= 255*/
   if ((Nom < 1)||(Nom > 255))
   {
      ft_pass = 0;
      gt_US_SRA_Stats.Np_stats++;
   }

   /*0.5 <= Tdtu <= 4, Tdtu=S1*Q=8*Nfec*Q/L1, i.e.  0.5*L1 <= 8*Nfec*Q <= 4*L1*/
   Nom = (uint32)(8 * s_DTU_Size_bytes);
   Den = gt_tx_config_v2.ul_Reconfig_Lp[LP1];

   if ( (Nom < (Den >> 1))||(Nom >(Den << 2)) )
   {
      ft_pass = 0;
      gt_US_SRA_Stats.DTU_stats++;
   }

   return ft_pass ^ 1;
}
// XDSLRTFW-1263_DTU_Stoppage_Handling (END)

//Mei test code: log mult_read, block_read and vector_block_read commands
#ifdef EOC_DEBUG_DATA

int16 gs_EocBufCnt = 0;
uint8 guc_EocMsgLog = 0x07;
void LogEocMsg(uint8 uc_msg_type, uint8 *puca_buffer)
{
#define LOG_MULT_READ   (1)
#define LOG_BLOCK_READ   (2)
#define LOG_VECTOR_READ   (4)
#define EOC_DEBUG_BUF_SIZE   (100)
   extern uint8 guca_EocDebugBuf[EOC_DEBUG_BUF_SIZE];

   int16 s_size, i;
   uint8 uc_MsgID;

   uc_MsgID = 0;
   if(uc_msg_type == VECTOR_BLOCK_READ)
   {
      s_size = 6;
      uc_MsgID = LOG_VECTOR_READ;
   }
   else if(uc_msg_type = guc_BLOCK_READ)
   {
      s_size = 5;
      uc_MsgID = LOG_BLOCK_READ;
   }
   else
   {
      s_size = 3;
      uc_MsgID = LOG_VECTOR_READ;
   }

   if((gs_EocBufCnt < (EOC_DEBUG_BUF_SIZE - s_size)) && (uc_MsgID & guc_EocMsgLog))
   {
      for(i=0; i<s_size; i++)
      {
         guca_EocDebugBuf[gs_EocBufCnt++] = puca_buffer[i];
      }
   }

} //void LogEocMsg()
#endif //#ifdef EOC_DEBUG_DATA


