/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: eoc_rx.c
;
;   Functions for implementing VDSL embedded operations channel (EOC).
;
;***************************************************************************/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "eoc.h"
#include "fcs.h"
#include "show_test_iof.h"



/*****************************************************************************
*   Subroutine Name: RxOvhdProcessor
*
*   Description:
*
*   This function reads the data in gt_RxEocMsgFifo then processes EOC messages.
*
*   Prototype:
*       void RxOvhdProcessor(void)
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   Global Variables:
*
*
*******************************************************************************/

void RxOvhdProcessor(void)
{
   static FlagT ft_rxOvdhMsgHandlerInProcess=FALSE;
   uint8 uc_RxEocByte;
   uint32 ul_first_OHC_bytes;


   ////////////////////////////////////////////////
   // EMPTY OUT THE FIFO AND PROCESS RX BYTE
   ////////////////////////////////////////////////

   // Rx Overhead Msg Handler is in process - postpone Rx ovhd fifo processing
   while (!ft_rxOvdhMsgHandlerInProcess)
   {
      // Check if any new message byte available in the FIFO
      if (!RemoveMessageFromOvhdFifo(&gt_RxEocMsgFifo, &uc_RxEocByte))
         // No message to process, hence return
      {
         return;
      }

      // Initialize FCS at the beginning of getting EOC message
      if (!gus_rx_msg_index)
      {
         gt_RxEocMsg.gus_FCS = 0xFFFF;
         gft_TransferClearEocData = FALSE;
      }

      // Start getting message
      if (uc_RxEocByte != HDLC_FLAG)
      {
         ////////////////////////////////////
         // Handle octet transparency
         ////////////////////////////////////

         if(gft_escape_octet_received == TRUE)
         {
            if((uc_RxEocByte == 0x5E) || (uc_RxEocByte == 0x5D))
            {
               uc_RxEocByte = uc_RxEocByte ^ 0x20;
               gft_escape_octet_received = FALSE;
            }
            else
            {
               /////////////////////////////////////////////////////////
               // Invalid message (according to G997.1 $6.3.5)
               // Message that contains control escape sequences other
               // than 0x7D, 0x5E and 0x7D, 0x5D are invalid
               /////////////////////////////////////////////////////////
               gft_escape_octet_received = FALSE;
               gus_rx_msg_index = 0;
               gus_EocEscRcvd++;
               return;
            }
         }
         else if (uc_RxEocByte == 0x7D)
         {
            gft_escape_octet_received = TRUE;

            // This is an escape octet, don't add to message buffer, continue
            continue;
         }

         if (!gft_TransferClearEocData)
         {
            // Check invalid Frames:
            // Message is longer than guca_rx_eoc_msg_buffer can hold
            if (gus_rx_msg_index == (MAX_RX_EOC_MSG_SIZE - 6))
            {
               // Clear the flag to check for escape octet as message ended
               gft_escape_octet_received = FALSE;
               gus_rx_msg_index = 0;
               gus_EocLenTooBig++;
               return;
            }
            else
            {
               // Copy the message in the corresponding buffer
               guca_rx_eoc_msg_buffer[gus_rx_msg_index++] = uc_RxEocByte;
            }
         }

         gt_RxEocMsg.gus_FCS = calcCrc16(gt_RxEocMsg.gus_FCS, uc_RxEocByte);
      } // if (uca_rx_ovhd_byte[i] != HDLC_FLAG)
      else
      {
         // CLOSING FLAG received indicates end of message
         gus_EocRxIndex++;

         // Check the invalid message (according to G997.1 $6.3.5)
         if ( gft_escape_octet_received       // Abort message: a Control Escape octet followed immediately by a Flag, i.e., 0x7D, 0x7E
               || (gus_rx_msg_index < MIN_OVHD_MESSAGE_LEN) // Message is too short: less than 4 octets in between flags not including transparency octets
               || (gt_RxEocMsg.gus_FCS != MAGIC_FCS_CHECK))    // discard the message with invalid FCS and return
         {
            if (gft_escape_octet_received)
            {
               gus_EocEscRcvd++;
            }

            if (gus_rx_msg_index < MIN_OVHD_MESSAGE_LEN)
            {
               gus_EocLenTooSmall++;
            }

            if (gt_RxEocMsg.gus_FCS != MAGIC_FCS_CHECK)
            {
               gus_EocBadFCS++;
            }

            // Clear the flag to check for escape octet as message ended
            gft_escape_octet_received = FALSE;
            gus_rx_msg_index = 0;

            // XDSLRTFW-3765
            // In case of a corrupted/invalid OLR message (message starts with 0x00000001),
            // handle linked variables gft_UsOlrInProgress and gus_OlrDiscardCnt correctly
            ul_first_OHC_bytes = (guca_rx_eoc_msg_buffer[2]) | (guca_rx_eoc_msg_buffer[1] << 8) |(guca_rx_eoc_msg_buffer[0] << 16);

            if (ul_first_OHC_bytes == 0x00000001)
            {
               // A corrupted OLR message will not be passed to message handler, hence disable gft_UsOlrInProgress
               gft_UsOlrInProgress = FALSE;

               if (gus_OlrDiscardCnt > 0)
               {
                  // If a timeout of the OLR message occured, until it was detected that it was a corrupted message, we need to also handle
                  // gus_OlrDiscardCnt (it was incremented in UsOvhdMsg_Timeout_Handler() in foreground)
                  gus_OlrDiscardCnt--;
               }
               // Update OLR statistic and send notification
               // byte position 3 in guca_rx_eoc_msg_buffer holds the OLR message type
               Update_OLRPMCnt(&gt_UsOLRPMCnt, guca_rx_eoc_msg_buffer[3], UTC_RESP_CNT);
               DSH_SendEvent(DSH_EVT_ABANDON_OLR,sizeof(uint8),(void *)&guca_rx_eoc_msg_buffer[3]);
            }
            return;
         }

         // Clear the flags
         gft_escape_octet_received = FALSE;

         // Indicate Rx Overhead Msg Handler is in Process
         ft_rxOvdhMsgHandlerInProcess = TRUE;

      } // if (uca_rx_ovhd_byte[i] != HDLC_FLAG)

   } // while (!ft_rxOvdhMsgHandlerInProcess)

   ////////////////////////////////////////////////
   // PROCESS THE COMPLETE RX MESSAGE
   ////////////////////////////////////////////////

   // Rx Overhead Msg Handler - after SHOW2 page is brought in
   if (ft_rxOvdhMsgHandlerInProcess &&
         (gus_ShowtimeControl & MASK_SHOW_2_PAGE_LOADED))
   {
      // process received overhead message
      if (gus_rx_msg_index>0)
      {
         //Note gus_rx_msg_index includes the address byte, control byte and 2 FCS bytes
         EocTrail(EOC_TRAIL_RXDELIM,guca_rx_eoc_msg_buffer[2],guca_rx_eoc_msg_buffer[3],(uint16)(gus_rx_msg_index-4));

         // +1 to skip 7E
         //DSH_SendEvent(DSH_OCH_RX_MESSAGES,gus_rx_msg_index ,(void *)(gt_RxEocMsgFifo.MessageBuffer+(gt_RxEocMsgFifo.IndexOfOldest - (gus_rx_msg_index+1))));
         //DSH_SendStream(DSH_OCH_RX_MESSAGES,gus_rx_msg_index ,(void *)(gt_RxEocMsgFifo.MessageBuffer+(gt_RxEocMsgFifo.IndexOfOldest - (gus_rx_msg_index+1))));
         //XDSLRTFW-2742: we use guca_rx_eoc_msg_buffer instead, since this is not a circular buffer. Circular buffers are not supported for debug streaming as of now
         //DSH_SendEvent(0x08,gus_rx_msg_index-2 ,(void *)(guca_rx_eoc_msg_buffer));
         DSH_SendStream(DSH_OCH_RX_MESSAGES,gus_rx_msg_index-2 ,(void *)(guca_rx_eoc_msg_buffer));
         Rx_ovhd_msg_handler();
      }

      // reset global msg buffer
      gus_rx_msg_index = 0;
      //(BEGIN END) XDSLRTFW-2742: In order to be able to stream guca_rx_eoc_msg_buffer we need to avoid resetting it after every usage
      //setting it to 0 is not needed and would lead to every debug stream content being 0
      //memset(guca_rx_eoc_msg_buffer, 0, (MAX_RX_EOC_MSG_SIZE - 6));

      // Indicate Rx Overhead Msg Handler Done
      ft_rxOvdhMsgHandlerInProcess = FALSE;
   }
}

