/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: tx_ib.c
*
*   This file contains functions that performs TX IB processing.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "g997.h"
#include "cmv_Data.h"
#include "cmv.h"
#include "CustomerTasks.h"
#include "vdsl_const.h"
#include "ShowtimeERBHandler.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DefectGeneration(uint16 defect)
*
*   This function parses the global gs_DefectTesting to figure out the defect(s)
*   that are being faked.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:   Sets up the appropriate defect.
*
*   Global Variables:
*      gs_DefectTesting;
*
*-------------------------------------------------------------------------------
*/


void DefectGeneration(uint16 defect)
{

#ifdef DEBUG_LINE_FAILURES
   if (gs_DefectCount >= 0)
   {
      if ((gs_DefectCount > 0) && defect & LOS_FAILURE_BIT)
      {
         gt_TxIbData.uc_los_def = PRESENT;
      }
      else
//         if(gs_DefectCount == 0 && defect & LOS_FAILURE_BIT)
      {
         gt_TxIbData.uc_los_def = TERMINATED;
      }

      if ((gs_DefectCount > 0) && defect & LPR_FAILURE_BIT)
      {
         gt_TxIbData.uc_lpr_def = PRESENT;
      }
      else
//         if(gs_DefectCount == 0 && defect & LPR_FAILURE_BIT)
      {
         gt_TxIbData.uc_lpr_def = TERMINATED;
      }

      if ((gs_DefectCount > 0) && defect & LOF_FAILURE_BIT)
      {
         gt_TxIbData.uc_sef_def = PRESENT;
      }
      else
//         if(gs_DefectCount == 0 && defect & LOF_FAILURE_BIT)
      {
         gt_TxIbData.uc_sef_def = TERMINATED;
      }

      if ((gs_DefectCount > 0) && defect & LOM_FAILURE_BIT)
      {
         gt_TxIbData.uc_lom_fail = PRESENT;
      }
      else
//         if(gs_DefectCount == 0 && defect & LOM_FAILURE_BIT)
      {
         gt_TxIbData.uc_lom_fail = TERMINATED;
      }

      if ((gs_DefectCount > 0) && defect & LOL_FAILURE_BIT)
      {
         gt_TxIbData.uc_lol_fail = PRESENT;
      }
      else
//         if(gs_DefectCount == 0 && defect & LOL_FAILURE_BIT)
      {
         gt_TxIbData.uc_lol_fail = TERMINATED;
      }

      if ((gs_DefectCount > 0) && defect & PRO_FPO_FAILURE_BIT)
      {
         gt_TxIbData.uc_pro_fail = PRESENT;
      }
      else
//         if(gs_DefectCount == 0 && defect & PRO_FPO_FAILURE_BIT)
      {
         gt_TxIbData.uc_pro_fail = TERMINATED;
      }

      if ((gs_DefectCount > 0) && defect & ESE_FAILURE_BIT)
      {
         gt_TxIbData.uc_ese_def = PRESENT;
      }
      else // extra check below as ese can be set by some of the
         // overriden flags above like los, lof, lpr, so
         // sometimes we want to override only those flags
         // without overriding the ese flag
         if(gs_DefectCount == 0 && defect & ESE_FAILURE_BIT)
         {
            gt_TxIbData.uc_ese_def = TERMINATED;
         }
   }

#endif // DEBUG_LINE_FAILURES

}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UpdateAtmPrimitive_NE(int16 s_lp, int16 s_abc)
*
*   This function updates Near-end ATM primitives.
*
*   Input Arguments:
*      s_lp: 0 = INLV/LP0, 1 = FAST/LP1
*      s_abc: ATM BC #, 0 = ABC0, 1 = ABC1
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      guca_TxIbMsgBuf[MAX_IB_BYTES_PER_SFRAME]: 3 IB bytes to be transmitted
*
*-------------------------------------------------------------------------------
*/
void UpdateAtmPrimitive_NE(int16 s_lp, int16 s_abc)
{
   //Cell Delineation State Machine. NCD is optional and OCD is supported. For the
   //Near end, the Alphaeous Register AR_TX_ATM_STAT_BCx bit 1 is used to detect
   //Cell Delineation (CD) state. If CD is false, then we move from SYNC state
   //to the NCD_OCD state. When 4 superframes with no CD are detected, we move from
   //NCD_OCD state to the LCD state. When CD is true and 4 superframes have gone by,
   //then we go back to SYNC state. Transitions listed below are shown in State Machine
   //diagram in document Hercules G997 I/F.


   //Start by updating if the anomaly is present or not so the far end can be informed.
   if (gt_TxIbData.uc_cd_flag[s_lp] == FALSE) // Lost cell delineation
   {
      gt_TxIbData.uc_ocd_anom[s_lp] = PRESENT;
      gt_TxIbData.uc_ncd_anom[s_lp] = PRESENT;
   }
   else
   {
      gt_TxIbData.uc_ocd_anom[s_lp] = TERMINATED;
      gt_TxIbData.uc_ncd_anom[s_lp] = TERMINATED;
   }

   //Now update the Near end anomaly/ defect states.
   switch(gt_TxIbData.uc_atm_state[s_lp])
   {
   case SYNC:
      if (gt_TxIbData.uc_cd_flag[s_lp] == FALSE) // Lost cell delineation
      {
         gt_TxIbData.uc_ocd_anom[s_lp] = PRESENT;
         gt_TxIbData.uc_ncd_anom[s_lp] = PRESENT;
         gt_TxIbData.s_ocd_cnt[s_lp] = 1;
         gt_TxIbData.uc_atm_state[s_lp] = OCD;   //Transition 1
      }
      else
      {
         //State Transition 7. Cell Delineation is OK
         gt_TxIbData.s_ocd_cnt[s_lp] = 0;
         gt_TxIbData.uc_atm_state[s_lp] = SYNC;   //Transition 7
         gt_TxIbData.uc_ncd_anom[s_lp] = TERMINATED;
         gt_TxIbData.uc_ocd_anom[s_lp] = TERMINATED;
         gt_TxIbData.uc_lcd_def[s_lp] = TERMINATED;
      }
      break;

   case OCD:

      if (gt_TxIbData.uc_cd_flag[s_lp] == FALSE)   //Transition 2
      {
         gt_TxIbData.s_ocd_cnt[s_lp]++;
      }
      else
      {
         if (gt_TxIbData.s_ocd_cnt[s_lp] < LCD_SUPERFRAMES)
         {
            gt_TxIbData.s_ocd_cnt[s_lp] = 0;
            gt_TxIbData.uc_ocd_anom[s_lp] = TERMINATED;   //Transition 8
            gt_TxIbData.uc_ncd_anom[s_lp] = TERMINATED;
            gt_TxIbData.uc_atm_state[s_lp] = SYNC;
         }
      }

      if (gt_TxIbData.s_ocd_cnt[s_lp] >= LCD_SUPERFRAMES)
      {
         // Cap the s_ocd_cnt at LCD_SUPERFRAMES
         gt_TxIbData.s_ocd_cnt[s_lp] = LCD_SUPERFRAMES;

         if (gt_TxIbData.uc_sef_def == TERMINATED)
         {
            gt_TxIbData.uc_ocd_anom[s_lp] = TERMINATED;   //Transition 3
            gt_TxIbData.uc_ncd_anom[s_lp] = TERMINATED;
            gt_TxIbData.uc_lcd_def[s_lp] = PRESENT;  //G993.1 Section 10.5.2.1.3
            gt_TxIbData.uc_atm_state[s_lp] = LCD;
         }
         else
         {
            gt_TxIbData.uc_ocd_anom[s_lp] = PRESENT;   //Transition 9
            gt_TxIbData.uc_ncd_anom[s_lp] = PRESENT;
            gt_TxIbData.uc_atm_state[s_lp] = OCD;
         }
      }
      break;

   case LCD:
      if (gt_TxIbData.uc_cd_flag[s_lp] == TRUE)
      {
         if (gt_TxIbData.s_ocd_cnt[s_lp] >0)
         {
            gt_TxIbData.s_ocd_cnt[s_lp]--;
         }
         if (gt_TxIbData.s_ocd_cnt[s_lp] == 0)      //Transition 6
         {
            gt_TxIbData.uc_lcd_def[s_lp] = TERMINATED;
            gt_TxIbData.uc_atm_state[s_lp] = SYNC; //G993.1 Section 10.5.2.1.3
         }
         else
         {
            //Transition 4
         }
      }
      else
      {
         gt_TxIbData.uc_ocd_anom[s_lp] = TERMINATED;
         gt_TxIbData.uc_ncd_anom[s_lp] = TERMINATED;

         gt_TxIbData.s_ocd_cnt[s_lp]++;      //Transition 5
         if (gt_TxIbData.s_ocd_cnt[s_lp] >= LCD_SUPERFRAMES)
         {
            gt_TxIbData.s_ocd_cnt[s_lp] = LCD_SUPERFRAMES;
         }
      }
      break;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UpdateLineFailurePrimitive_NE(void)
*
*   This function updates Near-end Line primitives.
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void UpdateLineFailurePrimitive_NE(void)
{

   /*************************************************************************************/
   // Update G997 counters
   /*************************************************************************************/
   if (gt_TxIbData.uc_los_def)
   {
      gt_g997_LinePerf_Sec_NE.l_LOSS_L_count++;   //G997.1 Section 7.2.1.1.4
      gt_g997_LinePerf_Sec_NE.l_ES_L_count++;      //G997.1 Section 7.2.1.1.2
      gt_g997_LinePerf_Sec_NE.l_SES_L_count++;   //G997.1 Section 7.2.1.1.3
   }

   if (gt_TxIbData.uc_sef_def)
   {
      gt_g997_LinePerf_Sec_NE.l_ES_L_count++;      //G997.1 Section 7.2.1.1.2
      gt_g997_LinePerf_Sec_NE.l_SES_L_count++;   //G997.1 Section 7.2.1.1.3
   }

   if (gt_TxIbData.uc_lpr_def)
   {
      gt_g997_LinePerf_Sec_NE.l_ES_L_count++;      //G997.1 Section 7.2.1.1.2
      gt_g997_LinePerf_Sec_NE.l_SES_L_count++;   //G997.1 Section 7.2.1.1.3
   }

   // Some additional compound failures at the Near End are as follows. Normal failures are
   // updated via State Machine run in ProcessFailureState():

   /*************************************************************************************/
   // LOS processing
   /*************************************************************************************/
   //G993.1  Section 10.5.1.5
   if ((gt_TxIbData.uc_los_def == PRESENT) && (gt_g997_FailureState_NE.t_LOF.us_NextState == FAILED_STATE))      //LOF Failure has been declared
   {
      gt_g997_FailureState_NE.t_LOS.us_NextState = FAILED_STATE;
      //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
      gsa_g997_Failure_Flag_NE[0] |= (gt_g997_FailureState_NE.t_LOS.us_FailureBitNumber);
   }

   /*************************************************************************************/
   // LOF processing
   /*************************************************************************************/

   //G997.1  Section 7.1.1.1.2 and also G993.1 Section 10.5.1.5
   if ((gt_g997_FailureState_NE.t_LOF.us_NextState == FAILED_STATE)
         && (gt_g997_FailureState_NE.t_LOS.us_NextState == FAILED_STATE))
   {
      gt_g997_FailureState_NE.t_LOF.us_NextState = STEADY_STATE;
      //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
      gsa_g997_Failure_Flag_NE[0] &= ~(gt_g997_FailureState_NE.t_LOF.us_FailureBitNumber);
   }
   /*************************************************************************************/
   // LOL processing
   /*************************************************************************************/
   // IETF RFC 2662 requires the following LOL Processing. Valid for CO only.
   // No DGASP and LOS-Defect present triggers an LOL condition.
   /*************************************************************************************/
   // FPO Anomaly set up
   // Why is gt_TxIbData.uc_fpo_def being set/reset if it is not being sent ?
   // Also it seems contrary to the standard. The PRO is a near end defect at
   // the CO and the FPO is a far end defect at the CPE.
   /*************************************************************************************/

   /*************************************************************************************/
   //If a PRO defect occurs in the CPE, then we need to set up the FPO indicator bit
   //(Bit 6 in Tx IB byte 2) at the CPE to signal to CO that CPE is going to become
   //inoperational in three superframe periods.
   if (gt_TxIbData.uc_pro_fail == PRESENT)
   {
      gt_TxIbData.uc_fpo_def = PRESENT;
   }
   else
   {
      gt_TxIbData.uc_fpo_def = TERMINATED;
   }
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UpdateTCSyncState(uint8 uc_TCSync)
*
*   This function updates the showtime status to/from TCSync/NoTCSync in showtime.
*   Also updates the corresponding autonomous message state transistion.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*-------------------------------------------------------------------------------
*/
void UpdateTCSyncState(uint8 uc_TCSync)
{

   if (gus_ShowtimeControl & MASK_TX_RX_SHOWTIME)
   {
      if (uc_TCSync == TRUE)
      {
         // TC Synch.
         if (gsa_IndirectStat0[0] != STAT_ShowTimeTCSyncState)
         {
            gsa_IndirectStat0[0] = STAT_ShowTimeTCSyncState;
            //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
            gsa_IndirectStat0[4]= VDSL2_SHOWTIME_TX_WITH_TC_SYNC;
            // bit MONI_STAT_SHOW_TCSYNC_FIRSTTIME is always on
            // after the TC layer has synched up for the firt time.
            // It will be off only when showtime is exited.
            gusa_MONI_ModemStat_Status[0] = (MONI_STAT_SHOW_TCSYNC | MONI_STAT_SHOW_TCSYNC_FIRSTTIME);
         }
      }
      else
      {
         // No TC Sync.
         // Send autonomous msg if there was sync before but now sync is lost.
         if (gsa_IndirectStat0[0] != STAT_ShowTimeState)
         {
            gsa_IndirectStat0[0] = STAT_ShowTimeState;
            //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
            gsa_IndirectStat0[4]= VDSL2_SHOWTIME_TX_NO_TC_SYNC;
            // Remove bit MONI_STAT_SHOW_TCSYNC, add in bit MONI_STAT_SHOW
            // but leave bit MONI_STAT_SHOW_TCSYNC_FIRSTTIME alone.
            gusa_MONI_ModemStat_Status[0] &= ~MONI_STAT_SHOW_TCSYNC;
            gusa_MONI_ModemStat_Status[0] |= MONI_STAT_SHOW_TC_NOSYNC;
         }
      }
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void TxIbHandler(void)
*
*   This function prepares 3 octets of indicator bits (IB) to be transmitted
*   during the next superframe.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      guca_TxIbMsgBuf[MAX_IB_BYTES_PER_SFRAME]: 3 IB bytes to be transmitted
*
*-------------------------------------------------------------------------------
*/

void TxIbHandler(void)
{
   int16 s_lp, s_abc;


   //Update the G997 ATM counters, primitives, anomalies and defects
   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      //XDSLRTFW-1607(START_END), Coding bug fix, replaced gt_tx_TPS with gt_rx_TPS,
      //First find out what bearer channel to use
      s_abc = gt_rx_TPS_Map.s_LPtoABC[s_lp];
      //Now update the primitives, anomalies and defects
      if (s_abc != DISABLED_ABC)
      {


         // for retx, LP1 link status will be reported instead of LP0
         // this block of code will have to be revisited when true dual latency is implemented
         if ((s_lp == 0) && (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
         {
            UpdateTCSyncState(gt_TxIbData.uc_cd_flag[LP1]);
         }
         else
         {
            UpdateTCSyncState(gt_TxIbData.uc_cd_flag[s_lp]);
         }


         UpdateAtmPrimitive_NE(s_lp, s_abc);

      } //if (s_abc != DISABLED_ABC) {
   } //for (s_lp=0;s_lp<NUM_DATA_PATHS;s_lp++)

   // Prepare indicator bits for VDSL2
   guca_TxIbMsgBuf[0] = (0x1F
                         | ((1-gt_TxIbData.uc_los_def) << 7)         // LOS
                         | ((1-gt_TxIbData.uc_sef_def) << 6)         // RDI
                         | ((1-gt_TxIbData.uc_lpr_def) << 5));      // LPR

   guca_TxIbMsgBuf[1] = (uint8)~NO_INDICATIONS;
   guca_TxIbMsgBuf[2] = ~NO_INDICATIONS & 0x7f & 0xf7;
   guca_TxIbMsgBuf[2] = guca_TxIbMsgBuf[2] | ((1-gt_TxIbData.uc_ncd_anom[LP0]) << 7) | ((1-gt_TxIbData.uc_ncd_anom[LP1]) << 3);


   //Update the G997 Line counters, primitives and anomalies.
   //CAUTION: Some compound conditions change the behavior of failure states so
   //process these rules before the State is updated.
   UpdateLineFailurePrimitive_NE();

   //Now update the Line and ATM Failure state machine
   G997_CheckTxFailure();

   // clear flag to initiate TX IB processing
   gus_ShowtimeControl &= ~MASK_PROCESS_TX_IB;
}
