/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: g997.c
*
*   This file contains functions that implement G997 functionality.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "g997.h"
#include "eoc.h"
#include "cmv_Data.h"
#include "CustomerTasks.h"
#include "cmv.h"
#include "fifo.h"
#include "vdsl_xception.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_SymbolBased_Task(void)
*
*   This function is called every frame from RxForeground().
*   It generates the 100ms timebase and the TR1 indication.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void G997_SymbolBased_Task(void)
{
   int16 s_count;
   int16 s_Interval_Adjust;

   // Count down to 0 in order to produce 100ms event.
   gt_G997_Cntrl.s_HighSymCount--;

   switch(gt_G997_Cntrl.s_HighSymCount)
   {

      // Each of the following case statements is executed once every 100ms.
      // The different offsets are only used to spread the individual tasks
      // over several symbols in order to avoid FG MIPS peaks
   case 30: // free a few frames to next case to allow execution of the background task

      // update interval counter every 100ms
      gt_G997_Cntrl.s_Interval_Count++;

      // 1 second (=10*100ms) based task
      if (gt_G997_Cntrl.s_1SecSym_Count > 0)
      {
         gt_G997_Cntrl.s_1SecSym_Count--;
      }

      if (gt_G997_Cntrl.s_1SecSym_Count == 0)
      {
         // G997 1 sec tasks - after both Tx and Rx are in showtime
         // If G997 processing needs to be done in training too, then we
         // need to put it into a separate function/file for codeswap reasons
         if (gus_ShowtimeControl & MASK_TX_RX_SHOWTIME)
         {
            if (gs_G997_1sec_Task_Done_Flag == TRAINING_DONE)
            {
               gs_G997_1sec_Task_Done_Flag = TRAINING_IN_PROGRESS;

               AddFunctionToBkgdFifo((PtrToFunc)G997_1sec_Task_VDSL2);
            }
            else
            {
               EnterFailStates(E_CODE_G997_1SEC_TASK_FAIL);

            }
         }
         else
         {
            // Update line un-available seconds during training
            if (gt_g997_LinePerf_help.s_UAS_L_State == UAS_STATE_LINE_UNAVAIL)
            {
               // Increment the line unavailable seconds while the line is declared
               // as unavailable
               gt_g997_LinePerf_Current_Previous_TR1_NE.t_Current.l_UAS_L_count++;
               gt_g997_LinePerf_Running_NE.l_UAS_L_count++;
               // Increment also FE-UAS TR1 during line idle/training (like is done in Geminax).
               // Otherwise, since FE TR1 counters are updated by accumulating the deltas,
               // the FE-UAS TR1 counter will never count the seconds during line idle/training.
               // For the FE-UAS running counter this is not needed since the value reported is directly what the FE modem sends over EOC.
               gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current.l_UAS_LFE_count++;
            }
         }

         gt_G997_Cntrl.s_1SecSym_Count = 10;
      }
      break;

   case 25: // as the TR1 state machine has 16 substates the next task needs to be
      // shifted by at least 17 frames

      // check if TR1 monitoring enabled
      if (gt_G997_Cntrl.s_TR1_enabled & (CNTR_TR1_Enable | CNTR_TR1_AutoMsg_Enable))
      {
         // adjust the TR1 interval using s_Interval_Adjust.
         // Reset_Control == 4 indicates shortening value is valid.
         if (gt_G997_Cntrl.s_Cntr_Reset_Control == 4)
         {
            s_Interval_Adjust = gt_G997_Cntrl.s_Interval_Adjust;
         }
         else
         {
            s_Interval_Adjust = 0;
         }

         // make sure adjustment is in range
         if (s_Interval_Adjust >= gt_G997_Cntrl.s_MaxInterval_Count)
         {
            s_Interval_Adjust = 0;
            gt_G997_Cntrl.s_Cntr_Reset_Control = 0;
         }

         // check for rollover, including effect of interval shortening.
         s_count = gt_G997_Cntrl.s_Interval_Count + s_Interval_Adjust - gt_G997_Cntrl.s_MaxInterval_Count;
         if (s_count >= 0)
         {
            gt_G997_Cntrl.s_Interval_Count = s_count;
            // turn off Tr1 interval shortening if enabled
            if (gt_G997_Cntrl.s_Cntr_Reset_Control == 4)
            {
               gt_G997_Cntrl.s_Cntr_Reset_Control = 0;
            }
            gft_Tr1RolloverFlag = 1;
            G997_TR1_Task();
            // do not directly start TR1 task here, just set tigger for it's state machine
            //gt_G997_Cntrl.s_TR1_State = 1;
         }
      }
      else
      {
         // check if TR1 Failure update to be done
         gt_g997_LinePerfThresholdControl.s_CurUpdate++;
         if (gt_g997_LinePerfThresholdControl.s_CurUpdate >= gt_g997_LinePerfThresholdControl.s_MaxUpdate)
         {
            gt_g997_LinePerfThresholdControl.s_CurUpdate = 0;
         }

         // check if Line/ATM Failure update to be done
         gt_G997_Cntrl.s_Failure_Update_Count++;

         if (gt_G997_Cntrl.s_Failure_Update_Count>= gt_G997_Cntrl.s_Failure_MaxUpdate_Count)
         {
            gt_G997_Cntrl.s_Failure_Update_Count = 0;
         }
      }
      break;

   case 7:   // Next task can follow direcly in subsequent symbol (no state machine)

      // Tx Autonomous Overhead Messages - after SHOW2 page is brought in
      if ((gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2) &&
            (gus_ShowtimeControl & MASK_SHOW_2_PAGE_LOADED))
      {
         // eoc autonomous msg
         guc_EocTimerCount++;
         if (guc_EocTimerCount >= gus_EocTimerInterval)
         {
            if( OPTNArray[OPTN_FeParamControl] & OPTN_FePMCountersEnable)
            {
               EOC_AutoMsg_Task();
            }
            guc_EocTimerCount = 0;
         }
      }
      break;

   case 6:   // as the AutoMsg_Task_100ms state machine has 4 substates the next task needs to be
      // shifted by at least 5 frames

      // Tx Autonomous Overhead Messages - after SHOW2 page is brought in
      if ((gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2) &&
            (gus_ShowtimeControl & MASK_SHOW_2_PAGE_LOADED))
      {
         // eoc autonomous msg
         // EOC_AutoMsg_Task_100ms();
         gt_G997_Cntrl.s_EOC_AutoMsg_100ms_State = 1;
      }
      break;

   case 0:
      // reset symbol counter for next countdown
      if ((gsa_IndirectStat0[0] == STAT_ReadyState) || (gsa_IndirectStat0[0] == STAT_GhsState))
      {
         // HW runs at 4.3125kHz/8.625kHz frame rate
         // Note: we don't cover the case when we remain in FAIL state after GHS. In this case the HW still runs
         // at 4.3125kHz, but we increment the time base at 4kHz frame rate.
         gs_100msecIntervalCount++;
         {
            gt_G997_Cntrl.s_HighSymCount += VDSL1_4P3KHZ_FRAMES_PER_100MS;
            // Add 1 frame every 400msec to compensate for the fractional frame count within 100msec period
            if (gs_100msecIntervalCount >= 4)
            {
               gs_100msecIntervalCount = 0;
               gt_G997_Cntrl.s_HighSymCount++;
            }
         }
      }
      else
      {
         if (gs_frame_rate_is_8khz)
         {
            gt_G997_Cntrl.s_HighSymCount += VDSL1_8KHZ_FRAMES_PER_100MS;
         }
         else
         {
            gt_G997_Cntrl.s_HighSymCount += VDSL1_4KHZ_FRAMES_PER_100MS;
         }
      }
      break;

   default:
      // Run state machines for periodic tasks.
      // The state machines are intentionally run only in the default case
      // in order move the cycles for the trigger checking and the state machines
      // themselves also to different symbols
      if (gt_G997_Cntrl.s_EOC_AutoMsg_100ms_State)
      {
         EOC_AutoMsg_Task_100ms();
      }
      //else if(gt_G997_Cntrl.s_TR1_State)
      //G997_TR1_Task();
      break;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_Clear_TR1_Counters(void)
*
*   This function is called to clear the TR1 current counters.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_Clear_TR1_Counters(void)
{
   //-----------------------------------
   // clear NE current counters
   //-----------------------------------

   memset(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE.t_Current, 0, sizeof(G997_NE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE.t_Current, 0, sizeof(G997_NE_ChMonFEC_t));
   memset(&gt_g997_LinePerf_Current_Previous_TR1_NE.t_Current, 0, sizeof(G997_NE_LinePerf_t));
   memset(&gt_g997_LineInitPerf_Current_Previous_TR1.t_Current, 0, sizeof(G997_LineInitPerf_t));
   memset(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_IBE_t));

#ifdef PPE_ENGINE
//   memset(&gt_g997_PtmPerf_Cur_Prev_NE, 0, sizeof(G997_PtmPerf_Cur_Prev_t));
#endif //PPE_ENGINE

   memset(&gt_g997_AtmPerf, 0, sizeof(G997_AtmPerf_t));

   //clear sef defect counter
   gul_NeSefDefectCounter = 0;

   //-----------------------------------
   // clear FE current counters
   //-----------------------------------

   memset(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Current, 0, sizeof(G997_FE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Current, 0, sizeof(G997_FE_ChMonFEC_t));
   memset(&gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current, 0, sizeof(G997_FE_LinePerf_t));
   memset(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_IBE_t));

   //clear sef defect counter
   gul_FeSefDefectCounter = 0;

   //-----------------------------------
   // Clear Customer performance counters
   //-----------------------------------
   CustomerClearTR1Counters();

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_Copy_TR1_Counters(void)
*
*   The function copies the current counts to the previous counts the current count.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_Copy_TR1_Counters(void)
{
   //-----------------------------------
   // copy NE current counters
   //-----------------------------------
   memcpy(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE.t_Previous, &gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE.t_Current, sizeof(G997_NE_ChMonCRC_t));
   memcpy(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE.t_Previous, &gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE.t_Current, sizeof(G997_NE_ChMonFEC_t));
   memcpy(&gt_g997_LineInitPerf_Current_Previous_TR1.t_Previous, &gt_g997_LineInitPerf_Current_Previous_TR1.t_Current, sizeof(G997_LineInitPerf_t));
   memcpy(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Previous, &gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Current, sizeof(G997_NE_AtmPerf_HEC_t));
   memcpy(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Previous, &gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Current, sizeof(G997_NE_AtmPerf_CD_t));
   memcpy(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Previous, &gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Current, sizeof(G997_NE_AtmPerf_CU_t));
   memcpy(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Previous, &gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Current, sizeof(G997_NE_AtmPerf_IBE_t));
   memcpy(&gt_g997_LinePerf_Current_Previous_TR1_NE.t_Previous, &gt_g997_LinePerf_Current_Previous_TR1_NE.t_Current, sizeof(G997_NE_LinePerf_t));

#ifdef PPE_ENGINE
//   memcpy(&gt_g997_PtmPerf_Cur_Prev_NE.t_Previous, &gt_g997_PtmPerf_Cur_Prev_NE.t_Current,sizeof(G997_PtmPerfCnts_t));
#endif //PPE_ENGINE

   //-----------------------------------
   // copy FE current counters
   //-----------------------------------
   memcpy(&gt_g997_LinePerf_Current_Previous_TR1_FE.t_Previous, &gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current, sizeof(G997_FE_LinePerf_t));
   memcpy(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Previous, &gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Current, sizeof(G997_FE_ChMonCRC_t));
   memcpy(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Previous, &gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Current, sizeof(G997_FE_ChMonFEC_t));
   memcpy(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE.t_Previous, &gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE.t_Current, sizeof(G997_FE_AtmPerf_HEC_t));
   memcpy(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE.t_Previous, &gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE.t_Current, sizeof(G997_FE_AtmPerf_CD_t));
   memcpy(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE.t_Previous, &gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE.t_Current, sizeof(G997_FE_AtmPerf_CU_t));
   memcpy(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE.t_Previous, &gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE.t_Current, sizeof(G997_FE_AtmPerf_IBE_t));

   //-----------------------------------
   // Clear Customer performance counters
   //-----------------------------------
   CustomerCopyTR1Counters();

}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_TR1_Task(void)
*
*   This function is called whenever a TR1 interval is done.
*   The function copies the current counts to the previous counts, and
*   clears the current count. A message indication is sent to the host.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_TR1_Task(void)
{

   //-----------------------------------
   // copy current counters to previous counters
   //-----------------------------------
   G997_Copy_TR1_Counters();

   //-----------------------------------
   // clear the current counters
   //-----------------------------------
   G997_Clear_TR1_Counters();

   //-----------------------------------
   // clear the previous alarm counters
   //-----------------------------------

   gt_G997_TR1AlarmIndicators.us_NEAlarmIndicators_Previous = 0;
   gt_G997_TR1AlarmIndicators.us_FEAlarmIndicators_Previous = 0;

}



/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_CheckTR1FailureChange(void)
*
*   This function
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_CheckTR1FailureChange(void)
{
   int16 s_temp;

   s_temp = (gt_G997_TR1AlarmIndicators.us_NEAlarmIndicators ^ gt_G997_TR1AlarmIndicators.us_NEAlarmIndicators_Previous) &
            gt_G997_MONI_TR1AlarmEnable.us_TR1AlarmMessageEnable_NE;
   gt_G997_TR1AlarmIndicators.us_NEAlarmIndicators_Previous = gt_G997_TR1AlarmIndicators.us_NEAlarmIndicators;

   s_temp = s_temp | (gt_G997_TR1AlarmIndicators.us_FEAlarmIndicators ^ gt_G997_TR1AlarmIndicators.us_FEAlarmIndicators_Previous) &
            gt_G997_MONI_TR1AlarmEnable.us_TR1AlarmMessageEnable_FE;
   gt_G997_TR1AlarmIndicators.us_FEAlarmIndicators_Previous = gt_G997_TR1AlarmIndicators.us_FEAlarmIndicators;

   // Time stamp and send new larm only if previous alarm has been sent
   if ((s_temp != 0) && (gft_SendTr1AlarmFlag == 0 ))
   {
      gft_SendTr1AlarmFlag = 1;  //set SendTrqAlarmFlag to notify Modem Monitor to send Auto Msg

      gt_G997_TR1AlarmIndicators.us_AlarmTimeStamps = gt_G997_Cntrl.s_Interval_Count;
   }

   return;

   // YAN: TBD: Send TR1 indication to the host
}

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void MonitorRatesForSRA(void)
*
*   This function monitors the RATE CMV in 1 sec intervals and sets the flag to send
*   an autonomous message to the host in case of a rate change ( upstream / downstream)
*   due to any SRA event
*
*   Input Arguments: None
*
*   Output Arguments: None
*
*   Returns: None
*
*-------------------------------------------------------------------------------
*/

void MonitorRatesForSRA(void)
{
   // Set the flag to send the autonomous message in case of Lp change
   if (gul_rx_current_Lp[LP0] != gt_rx_config_v2.ul_Lp[LP0])
   {

      gft_SendDSShowEventsFlag = TRUE;
      // Update the current value
      gul_rx_current_Lp[LP0] = gt_rx_config_v2.ul_Lp[LP0];

   }

   if (gul_tx_current_Lp[LP0] != gt_tx_config_v2.ul_Lp[LP0])
   {

      gft_SendUSShowEventsFlag = TRUE;

      // Update the current value
      gul_tx_current_Lp[LP0] = gt_tx_config_v2.ul_Lp[LP0];
   }
}
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]


