/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: g997_init.c
*
*   This file contains functions that performs G997 initialization.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "g997.h"
#include "cmv.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_InitHandler_PowerUp(void)
*
*   This function initializes G997 variables/counters - called on system reset.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_InitHandler_PowerUp(void)
{
   // reset the TR1 Line Initialization Performance counters
   memset(&gt_g997_LineInitPerf_Current_Previous_TR1.t_Current, 0, sizeof(G997_LineInitPerf_t));
   memset(&gt_g997_LineInitPerf_Current_Previous_TR1.t_Previous, 0, sizeof(G997_LineInitPerf_t));

   // reset the Free Running Line Initialization counters
   memset(&gt_g997_LineInitPerf_Running, 0, sizeof(G997_LineInitPerf_t));

   // clear counters and structures.
   memset(&gt_G997_Cntrl, 0, sizeof(G997_Cntrl_t));

   memset(&gt_g997_LinePerf_help, 0, sizeof(G997_LinePerf_help_t));

   // set Cntr Reset Control for no clear on reset
   gt_G997_Cntrl.s_Cntr_Reset_Control = 0;
   // enable TR1 current/previous counters
   gt_G997_Cntrl.s_TR1_enabled = 1;

   // enable performance counters inhibition by default
   gt_G997_Cntrl.s_TR1_enabled |= CNTR_TR1_CntrInhibit_Enable;

   // default TR1 duration to 15 minutes
   gt_G997_Cntrl.s_MaxInterval_Count = NUM_OF_100MS_PER_15MIN;

   InitSystemPerfThresholdStruct(&gt_g997_LinePerfThresholdControl);
   InitAlarmAutoMessageEnableStruct(&gt_G997_MONI_TR1AlarmEnable);

   G997_InitStructureHandler();
   G997_InitCounterHandler();

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_InitHandler(void)
*
*   This function initializes G997 variables/counters - called on link start.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_InitStructureHandler(void)
{


   //Reset the Alarm threshold indicators
   InitAlarmIndicatorStruct(&gt_G997_TR1AlarmIndicators);

   // initialize G997 Control structure
   InitCntrlStruct(&gt_G997_Cntrl);

   //Initialize Failure structures for Line and ATM Failures
   InitLineFailureStruct(&gt_g997_FailureState_NE);
   InitLineFailureStruct(&gt_g997_FailureState_FE);
   InitAtmFailureStruct(&gt_g997_AtmFailure_NE);
   InitAtmFailureStruct(&gt_g997_AtmFailure_FE);

   //Initialize the ATM Defects/ anomalies initially
   G997_SetFailuresActive();
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_InitCounterHandler(void)
*
*   This function initializes G997 counters.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_InitCounterHandler(void)
{


   //Reset the TR1 ATM Performance counters
   memset(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Previous, 0, sizeof(G997_NE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE.t_Previous, 0, sizeof(G997_FE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Previous, 0, sizeof(G997_NE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE.t_Previous, 0, sizeof(G997_FE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Previous, 0, sizeof(G997_NE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE.t_Previous, 0, sizeof(G997_FE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Previous, 0, sizeof(G997_NE_AtmPerf_IBE_t));
   memset(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Current, 0, sizeof(G997_NE_AtmPerf_IBE_t));
   memset(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE.t_Previous, 0, sizeof(G997_FE_AtmPerf_IBE_t));
   memset(&gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE.t_Current, 0, sizeof(G997_FE_AtmPerf_IBE_t));
   memset(&gt_g997_AtmPerf, 0, sizeof(G997_AtmPerf_t));

   //Reset the Free running ATM Performance counters
   memset(&gt_g997_AtmPerf_HEC_Running_NE, 0, sizeof(G997_NE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_CD_Running_NE, 0, sizeof(G997_NE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CU_Running_NE, 0, sizeof(G997_NE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_IBE_Running_NE, 0, sizeof(G997_NE_AtmPerf_IBE_t));
   memset(&gt_g997_AtmPerf_HEC_Running_FE, 0, sizeof(G997_FE_AtmPerf_HEC_t));
   memset(&gt_g997_AtmPerf_CD_Running_FE, 0, sizeof(G997_FE_AtmPerf_CD_t));
   memset(&gt_g997_AtmPerf_CU_Running_FE, 0, sizeof(G997_FE_AtmPerf_CU_t));
   memset(&gt_g997_AtmPerf_IBE_Running_FE, 0, sizeof(G997_FE_AtmPerf_IBE_t));
   memset(&gt_g997_AtmPerf_ICELL_Running_NE, 0, sizeof(G997_NE_AtmPerf_ICELL_t));
   memset(&gt_g997_AtmPerf_UCELL_Running_NE, 0, sizeof(G997_NE_AtmPerf_UCELL_t));

#ifdef PPE_ENGINE
//   memset(&gt_g997_PtmPerf_Running_NE, 0, sizeof(G997_PtmPerfCnts_t));
//   memset(&gt_g997_PtmPerf_Running_FE, 0, sizeof(G997_PtmPerfCnts_t));
#endif //PPE_ENGINE

   // Reset the TR1 Line Performance counters
   memset(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE.t_Current, 0, sizeof(G997_NE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE.t_Previous, 0, sizeof(G997_NE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Current, 0, sizeof(G997_FE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Previous, 0, sizeof(G997_FE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE.t_Current, 0, sizeof(G997_NE_ChMonFEC_t));
   memset(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE.t_Previous, 0, sizeof(G997_NE_ChMonFEC_t));
   memset(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Current, 0, sizeof(G997_FE_ChMonFEC_t));
   memset(&gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Previous, 0, sizeof(G997_FE_ChMonFEC_t));
   memset(&gt_g997_LinePerf_Current_Previous_TR1_NE.t_Current, 0, sizeof(G997_NE_LinePerf_t));
   memset(&gt_g997_LinePerf_Current_Previous_TR1_NE.t_Previous, 0, sizeof(G997_NE_LinePerf_t));
   memset(&gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current, 0, sizeof(G997_FE_LinePerf_t));
   memset(&gt_g997_LinePerf_Current_Previous_TR1_FE.t_Previous, 0, sizeof(G997_FE_LinePerf_t));

#ifdef PPE_ENGINE
//   memset(&gt_g997_PtmPerf_Cur_Prev_NE, 0, sizeof(G997_PtmPerf_Cur_Prev_t));
//   memset(&gt_g997_PtmPerf_Cur_Prev_FE, 0, sizeof(G997_PtmPerf_Cur_Prev_t));
#endif //PPE_ENGINE

   //Reset the per Second counters
   memset(&gt_g997_LinePerf_Sec_FE, 0, sizeof(G997_FE_LinePerf_t));
   memset(&gt_g997_LinePerf_Sec_NE, 0, sizeof(G997_NE_LinePerf_t));

   //Reset the Free Running Line Perrformance counters
   memset(&gt_g997_ChPerf_CRC_Running_NE, 0, sizeof(G997_NE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_CRC_Running_FE, 0, sizeof(G997_FE_ChMonCRC_t));
   memset(&gt_g997_ChPerf_FEC_Running_NE, 0, sizeof(G997_NE_ChMonFEC_t));
   memset(&gt_g997_ChPerf_FEC_Running_FE, 0, sizeof(G997_FE_ChMonFEC_t));
   memset(&gt_g997_LinePerf_Running_NE, 0, sizeof(G997_NE_LinePerf_t));
   memset(&gt_g997_LinePerf_Running_FE, 0, sizeof(G997_FE_LinePerf_t));

   //G997 DS/US Attenuation, Margin, etc. - Section 7.5.1.4-17 of the G997 Spec.
   memset(&gt_LineStatusDS, 0, sizeof(gt_LineStatusDS));
   memset(&gt_LineStatusUS, 0, sizeof(gt_LineStatusUS));

   memset(&gt_g997_AtmPerf_TX_UICELL, 0, (uint16)NUM_BEARER_CHANNELS*sizeof(G997_NE_AtmPerf_TX_UICELL_t));
   memset(&gt_g997_AtmPerf_NE, 0, (uint16)NUM_BEARER_CHANNELS*sizeof(G997_NE_FE_AtmPerf_t));
   memset(&gt_g997_AtmPerf_FE, 0, (uint16)NUM_BEARER_CHANNELS*sizeof(G997_NE_FE_AtmPerf_t));
   memset(&gt_g997_PtmPerf_NE, 0, (uint16)NUM_BEARER_CHANNELS*sizeof(G997_NE_FE_PtmPerf_t));
   //Reset sef Defect Counter
   gul_NeSefDefectCounter = 0;
   gul_FeSefDefectCounter = 0;

//=======================================================
// reset intermediate counters
//=======================================================
   gs_SES_Delay_Buf=0;
   gs_ES_Delay_Buf=0;

   memset(&gt_CRC_Curr_Reading,0, sizeof(G997_NE_ChMonCRC_t));
   memset(&gt_CRC_Last_10_Sec,0 , sizeof(G997_NE_ChMonCRC_t));

   gul_FEC_Curr_Reading[0]=0;
   gul_FEC_Curr_Reading[1]=0;

   gul_FEC_Last_10_Sec[0]=0;
   gul_FEC_Last_10_Sec[1]=0;

   gul_FEC_Uncorr_Curr_Reading[0]=0;
   gul_FEC_Uncorr_Curr_Reading[1]=0;

   gul_FEC_Uncorr_Last_10_Sec[0]=0;
   gul_FEC_Uncorr_Last_10_Sec[1]=0;

   gul_RS_CW_Curr_Reading[0]=0;
   gul_RS_CW_Curr_Reading[1]=0;

   gul_RS_CW_Last_10_Sec[0]=0;
   gul_RS_CW_Last_10_Sec[1]=0;

   gul_FECS_Curr_Reading=0;
   gul_FECS_Last_10_Sec=0;

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_SetFailuresActive(void)
*
*   This function
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_SetFailuresActive(void)
{
   int16 s_lp;

   //Check to see if Link is unavailable or simply just came up
   if (gt_G997_Cntrl.s_LinkState == G997_LINK_IDLE)
   {
      InitLineFailureStruct(&gt_g997_FailureState_NE);
      InitLineFailureStruct(&gt_g997_FailureState_FE);

      InitAtmFailureStruct(&gt_g997_AtmFailure_NE);
      InitAtmFailureStruct(&gt_g997_AtmFailure_FE);

      for (s_lp = 0; s_lp<NUM_DATA_PATHS; s_lp++)
      {
         gt_TxIbData.uc_atm_state[s_lp] = OCD;
         gt_RxIbData.uc_atm_state[s_lp] = OCD;
      }
   }
   else // Link is in G997_LINK_UNAVAIL condition
   {
      //Link is down. RxIbHandler() and TxIbHandler()   take respective actions.
   }


}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitSystemPerfThresholdStruct(G997_LinePerfThreshold_t *pt_SPT)
*
*   This function initializes G997_System Thresholds.
*
*   Input Arguments:
*      pt_SPT: pointer to structure
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitSystemPerfThresholdStruct(G997_LinePerfThreshold_t *pt_SPT)
{
   memset(pt_SPT, 0, sizeof(G997_LinePerfThreshold_t));
   pt_SPT->s_MaxUpdate = 10;
   pt_SPT->s_Mask_TR1_failure = 0x03ff;
   pt_SPT->t_NE_Alarm.l_FECS_L_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_NE_Alarm.l_ES_L_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_NE_Alarm.l_SES_L_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_NE_Alarm.l_LOSS_L_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_NE_Alarm.l_UAS_L_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_NE_Alarm.l_CRC_L_count = 0x7fffffff;
   pt_SPT->t_NE_Alarm.l_FEC_L_count = 0x7fffffff;
   pt_SPT->t_FE_Alarm.l_FECS_LFE_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_FE_Alarm.l_ES_LFE_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_FE_Alarm.l_SES_LFE_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_FE_Alarm.l_LOSS_LFE_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_FE_Alarm.l_UAS_LFE_count = DEFAULT_PERFORMANCE_THRESHOLD;
   pt_SPT->t_FE_Alarm.l_CRC_LFE_count = 0x7fffffff;
   pt_SPT->t_FE_Alarm.l_FEC_LFE_count = 0x7fffffff;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitAlarmIndicatorStruct(G997_TR1AlarmIndicators_t *pt_SPT)
*
*   This function initializes G997 Alarm Indicators
*
*   Input Arguments:
*      pt_SPT: pointer to structure
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitAlarmIndicatorStruct(G997_TR1AlarmIndicators_t *pt_SPT)
{
   memset(pt_SPT, 0, sizeof(G997_TR1AlarmIndicators_t));
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitAlarmAutoMessageEnableStruct(G997_MONI_TR1AlarmEnable_t *pt_SPT)
*
*   This function initializes G997 Alarm Autonomuous Messgage Enable
*
*   Input Arguments:
*      pt_SPT: pointer to structure
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitAlarmAutoMessageEnableStruct(G997_MONI_TR1AlarmEnable_t *pt_SPT)
{
   memset(pt_SPT, 0, sizeof(G997_MONI_TR1AlarmEnable_t));
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitCntrlStruct(G997_Cntrl_t *pt_Ct)
*
*   This function initializes G997_Cntrl_t structure.
*
*   Input Arguments:
*      pt_Ct: pointer to structure
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitCntrlStruct(G997_Cntrl_t *pt_Ct)
{
   if (gs_frame_rate_is_8khz)
   {
      pt_Ct->s_HighSymCount = VDSL1_8KHZ_FRAMES_PER_100MS;
   }
   else
   {
      pt_Ct->s_HighSymCount = VDSL1_4KHZ_FRAMES_PER_100MS;
   }

   pt_Ct->s_1SecSym_Count = 10;
   pt_Ct->s_Failure_MaxUpdate_Count = 5;
   pt_Ct->s_LinkState = G997_LINK_IDLE;
   pt_Ct->s_TrainState = G997_TRAIN_IDLE;
   pt_Ct->s_FE_FPO_indication = 0; //No DGASP received from CPE at the beginning.
   pt_Ct->s_EOC_AutoMsg_100ms_State = 0;
   pt_Ct->s_TR1_State = 0;
}
