/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: g997_init.c
*
*   This file contains functions that performs G997 initialization.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "g997.h"
#include "cmv.h"


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitLineFailureStruct(G997_LineFailure_t *pt_LF)
*
*   This function initializes G997_LineFailure_t structure.
*
*   Input Arguments:
*      pt_LF: pointer to structure
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitLineFailureStruct(G997_LineFailure_t *pt_LF)
{
   uint16 us_PmdFramesPer1Sec;
   uint32 ul_PmdFramesPer2_5Sec;
   uint32 ul_PmdFramesPer10Sec;

   if (gs_frame_rate_is_8khz)
   {
      us_PmdFramesPer1Sec   = VDSL1_8KHZ_PMDFRAMES_PER_1_SEC;
      ul_PmdFramesPer2_5Sec = VDSL1_8KHZ_PMDFRAMES_PER_2_5SEC;
      ul_PmdFramesPer10Sec  = VDSL1_8KHZ_PMDFRAMES_PER_10_SEC;
   }
   else
   {
      us_PmdFramesPer1Sec   = VDSL1_4KHZ_PMDFRAMES_PER_1_SEC;
      ul_PmdFramesPer2_5Sec = VDSL1_4KHZ_PMDFRAMES_PER_2_5SEC;
      ul_PmdFramesPer10Sec  = VDSL1_4KHZ_PMDFRAMES_PER_10_SEC;
   }

   memset(pt_LF, 0, sizeof(G997_LineFailure_t));
   //Need to set up the number of Superframes for which defect must be present/ terminated
   //for the failure condition to be set/ cleared. Also need to associate the failure with
   //a Bit Number in the overall Global structure.

   //ESE Failure - No duration tied to this failure. Trigger at the first occurrence
   //and cleared on the first absence of defect
   pt_LF->t_ESE.ul_FailureSetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_ESE.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_ESE.us_FailureBitNumber = ESE_FAILURE_BIT;
   pt_LF->t_ESE.ul_Duration = 0;
   pt_LF->t_ESE.ul_Duration_reset = 0;
   pt_LF->t_ESE.us_NextState = STEADY_STATE;
   pt_LF->t_ESE.us_PrevState = STEADY_STATE;
   pt_LF->t_ESE.ul_ReInitPeriod = pt_LF->t_ESE.ul_FailureSetPeriod;

   //LOF Failure
   pt_LF->t_LOF.ul_FailureSetPeriod = ul_PmdFramesPer2_5Sec;
   pt_LF->t_LOF.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_LOF.us_FailureBitNumber = LOF_FAILURE_BIT;
   pt_LF->t_LOF.ul_Duration = 0;
   pt_LF->t_LOF.ul_Duration_reset = 0;
   pt_LF->t_LOF.us_NextState = STEADY_STATE;
   pt_LF->t_LOF.us_PrevState = STEADY_STATE;
   pt_LF->t_LOF.ul_ReInitPeriod = pt_LF->t_LOF.ul_FailureSetPeriod;

   //LOL Failure - Triggered by a FPO Failure condition. When FPO Failure (DGASP) is
   //indicated by the CPE, and there is an LOS associated with it, CO thinks it is an LOL
   pt_LF->t_LOL.ul_FailureSetPeriod = 1;
   pt_LF->t_LOL.ul_FailureResetPeriod = 1;
   pt_LF->t_LOL.us_FailureBitNumber = LOL_FAILURE_BIT;
   pt_LF->t_LOL.ul_Duration = 0;
   pt_LF->t_LOL.ul_Duration_reset = 0;
   pt_LF->t_LOL.us_NextState = STEADY_STATE;
   pt_LF->t_LOL.us_PrevState = STEADY_STATE;
   pt_LF->t_LOL.ul_ReInitPeriod = pt_LF->t_LOL.ul_FailureSetPeriod;

//XDSLRTFW-957 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   //LOM Failure
   //Programmable from s_LOM_ReInit_Threshold DSL 30 0 //snv
   if(gt_ReInit_Threshold.s_LOM_ReInit_Threshold == 0)
   {
      gt_ReInit_Threshold.s_LOM_ReInit_Threshold = 60;
   }

   pt_LF->t_LOM.ul_ReInitPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_1_SEC * gt_ReInit_Threshold.s_LOM_ReInit_Threshold);//snv
   //pt_LF->t_LOM.ul_FailureSetPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_1_SEC * gt_ReInit_Threshold.s_LOM_ReInit_Threshold);//snv
   if (gs_frame_rate_is_8khz)
      //pt_LF->t_LOM.ul_FailureSetPeriod <<= 1;
   {
      pt_LF->t_LOM.ul_ReInitPeriod <<= 1;   //snv
   }

//XDSLRTFW-957 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   pt_LF->t_LOM.ul_FailureSetPeriod = 2*ul_PmdFramesPer10Sec; // 20 seconds of defect == failure
   pt_LF->t_LOM.ul_FailureResetPeriod = ul_PmdFramesPer10Sec; // 10 seconds after defect is gone
   pt_LF->t_LOM.us_FailureBitNumber = LOM_FAILURE_BIT;
   pt_LF->t_LOM.ul_Duration = 0;
   pt_LF->t_LOM.ul_Duration_reset = 0;
   pt_LF->t_LOM.us_NextState = STEADY_STATE;
   pt_LF->t_LOM.us_PrevState = STEADY_STATE;

   //LOS Failure
   pt_LF->t_LOS.ul_FailureSetPeriod = ul_PmdFramesPer2_5Sec;
   pt_LF->t_LOS.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_LOS.us_FailureBitNumber = LOS_FAILURE_BIT;
   pt_LF->t_LOS.ul_Duration = 0;
   pt_LF->t_LOS.ul_Duration_reset = 0;
   pt_LF->t_LOS.us_NextState = STEADY_STATE;
   pt_LF->t_LOS.us_PrevState = STEADY_STATE;
   pt_LF->t_LOS.ul_ReInitPeriod = pt_LF->t_LOS.ul_FailureSetPeriod;

   //LPR Failure
   pt_LF->t_LPR.ul_FailureSetPeriod = ul_PmdFramesPer2_5Sec;
   pt_LF->t_LPR.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_LPR.us_FailureBitNumber = LPR_FAILURE_BIT;
   pt_LF->t_LPR.ul_Duration = 0;
   pt_LF->t_LPR.ul_Duration_reset = 0;
   pt_LF->t_LPR.us_NextState = STEADY_STATE;
   pt_LF->t_LPR.us_PrevState = STEADY_STATE;
   pt_LF->t_LPR.ul_ReInitPeriod = pt_LF->t_LPR.ul_FailureSetPeriod;

   //PRO Failure - No duration tied to this failure. Trigger at the first occurrence
   //and cleared on the first absence of defect
   pt_LF->t_PRO.ul_FailureSetPeriod = 1;
   pt_LF->t_PRO.ul_FailureResetPeriod = 1;
   pt_LF->t_PRO.us_FailureBitNumber = PRO_FPO_FAILURE_BIT;
   pt_LF->t_PRO.ul_Duration = 0;
   pt_LF->t_PRO.ul_Duration_reset = 0;
   pt_LF->t_PRO.us_NextState = STEADY_STATE;
   pt_LF->t_PRO.us_PrevState = STEADY_STATE;
   pt_LF->t_PRO.ul_ReInitPeriod = pt_LF->t_PRO.ul_FailureSetPeriod;

//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   //Programmable from s_ESx_ReInit_Threshold DSL 30 0 //snv
   if( gt_ReInit_Threshold.s_ESx_ReInit_Threshold == 0 )
   {
      gt_ReInit_Threshold.s_ESx_ReInit_Threshold = 90;
   }

   pt_LF->t_ESx.ul_FailureSetPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_1_SEC * gt_ReInit_Threshold.s_ESx_ReInit_Threshold);//snv
   if (gs_frame_rate_is_8khz)
   {
      pt_LF->t_ESx.ul_FailureSetPeriod <<= 1;
   }

   pt_LF->t_ESx.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_ESx.us_FailureBitNumber = ESX_FAILURE_BIT;
   pt_LF->t_ESx.ul_Duration = 0;
   pt_LF->t_ESx.us_NextState = STEADY_STATE;
   pt_LF->t_ESx.us_PrevState = STEADY_STATE;
   pt_LF->t_ESx.ul_ReInitPeriod = pt_LF->t_ESx.ul_FailureSetPeriod;

   //Programmable from s_SESx_ReInit_Threshold DSL 30 0 //snv
   if( gt_ReInit_Threshold.s_SESx_ReInit_Threshold == 0 )
   {
      gt_ReInit_Threshold.s_SESx_ReInit_Threshold = 30;
   }

   pt_LF->t_SESx.ul_FailureSetPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_1_SEC * gt_ReInit_Threshold.s_SESx_ReInit_Threshold);//snv
   if (gs_frame_rate_is_8khz)
   {
      pt_LF->t_SESx.ul_FailureSetPeriod <<= 1;
   }

   pt_LF->t_SESx.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_SESx.us_FailureBitNumber = SESX_FAILURE_BIT;
   pt_LF->t_SESx.ul_Duration = 0;
   pt_LF->t_SESx.us_NextState = STEADY_STATE;
   pt_LF->t_SESx.us_PrevState = STEADY_STATE;
   pt_LF->t_SESx.ul_ReInitPeriod = pt_LF->t_SESx.ul_FailureSetPeriod;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   //XDSLRTFW-2094/2050
   //OOS Failure
   pt_LF->t_OOS.ul_FailureSetPeriod = ul_PmdFramesPer2_5Sec;
   pt_LF->t_OOS.ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
   pt_LF->t_OOS.us_FailureBitNumber = LCD_BC0_FAILURE_BIT;
   pt_LF->t_OOS.ul_Duration = 0;
   pt_LF->t_OOS.ul_Duration_reset = 0;
   pt_LF->t_OOS.us_NextState = STEADY_STATE;
   pt_LF->t_OOS.us_PrevState = STEADY_STATE;
   pt_LF->t_OOS.ul_ReInitPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_15_SEC);

   //FPO Failure - is only at CO.
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   //Initialize the globals associated with the State Flags that are tied to CMV
   gsa_g997_Failure_Flag_NE[0] = 0;
   gsa_g997_Failure_Flag_NE[1] = 0;
   gsa_g997_Failure_Flag_NE_latched[0] = 0;
   gsa_g997_Failure_Flag_NE_latched[1] = 0;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   gs_g997_Failure_Flag_FE = 0;
   gs_g997_Failure_Flag_FE_latched = 0;
}



/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitAtmFailureStruct(G997_AtmFailure_t *pt_AF)
*
*   This function initializes G997_AtmFailure_t structure.
*
*   Input Arguments:
*      pt_AF: pointer to structure
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitAtmFailureStruct(G997_AtmFailure_t *pt_AF)
{
   uint16 i;
   uint16 us_PmdFramesPer1Sec;
   uint32 ul_PmdFramesPer2_5Sec;
   uint32 ul_PmdFramesPer10Sec;

   if (gs_frame_rate_is_8khz)
   {
      us_PmdFramesPer1Sec   = VDSL1_8KHZ_PMDFRAMES_PER_1_SEC;
      ul_PmdFramesPer2_5Sec = VDSL1_8KHZ_PMDFRAMES_PER_2_5SEC;
      ul_PmdFramesPer10Sec  = VDSL1_8KHZ_PMDFRAMES_PER_10_SEC;

   }
   else
   {
      us_PmdFramesPer1Sec   = VDSL1_4KHZ_PMDFRAMES_PER_1_SEC;
      ul_PmdFramesPer2_5Sec = VDSL1_4KHZ_PMDFRAMES_PER_2_5SEC;
      ul_PmdFramesPer10Sec  = VDSL1_4KHZ_PMDFRAMES_PER_10_SEC;
   }

   memset(pt_AF, 0, sizeof(G997_AtmFailure_t));
   for (i=0; i<NUM_DATA_PATHS; i++)
   {
      pt_AF->t_LCD[i].ul_FailureSetPeriod = ul_PmdFramesPer2_5Sec;
      pt_AF->t_LCD[i].ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
      pt_AF->t_LCD[i].ul_ReInitPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_15_SEC);
      if (i==0) //Latency Path LP0
      {
         pt_AF->t_LCD[i].us_FailureBitNumber = LCD_LP0_FAILURE_BIT;
      }
      else
      {
         pt_AF->t_LCD[i].us_FailureBitNumber = LCD_LP1_FAILURE_BIT;
      }
      pt_AF->t_LCD[i].ul_Duration = 0;
      pt_AF->t_LCD[i].us_NextState = STEADY_STATE;
      pt_AF->t_LCD[i].us_PrevState = STEADY_STATE;

      pt_AF->t_NCD[i].ul_FailureSetPeriod = ul_PmdFramesPer2_5Sec;
      pt_AF->t_NCD[i].ul_FailureResetPeriod = ul_PmdFramesPer10Sec;
      pt_AF->t_NCD[i].ul_ReInitPeriod = (VDSL1_4KHZ_PMDFRAMES_PER_15_SEC);
      if (i==0) //Latency Path LP0
      {
         pt_AF->t_NCD[i].us_FailureBitNumber = NCD_LP0_FAILURE_BIT;
      }
      else
      {
         pt_AF->t_NCD[i].us_FailureBitNumber = NCD_LP1_FAILURE_BIT;
      }
      pt_AF->t_NCD[i].ul_Duration = 0;
      pt_AF->t_NCD[i].us_NextState = STEADY_STATE;
      pt_AF->t_NCD[i].us_PrevState = STEADY_STATE;
   }
}


