/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: g997_showinit.c
*
*   This file contains function used to reset G997 counters during showtime
*   initialization.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "g997.h"
#include "cmv_data.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void G997_RestartHandler(void)
*
*   This function initialized G997 counters - called on entering showtime.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void G997_RestartHandler(void)
{
   int16 i;

   gt_G997_Cntrl.s_TxSymb_Count = 0;
   gt_G997_Cntrl.s_US_Margin_Underflow_Count = 0;

   gs_G997_1sec_Task_Done_Flag = TRAINING_DONE;

   if (gus_PhysicalTransportMode & (RX_ATM0_MASK | RX_ATM1_MASK))
   {
      // clear ATM cell counters
      for (i=0; i<ATM_NUM_BC; i++)
      {
         gt_g997_AtmPerf_HEC_Running_NE.la_HEC_P_count[i] = 0;
         gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Current.la_HEC_P_count[i] = 0;
         gt_g997_AtmPerf_CD_Running_NE.la_CD_P_count[i] = 0;
         gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Current.la_CD_P_count[i] = 0;
         gt_g997_AtmPerf_CU_Running_NE.la_CU_P_count[i] = 0;
         gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Current.la_CU_P_count[i] = 0;
         gt_g997_AtmPerf_IBE_Running_NE.la_IBE_P_count[i] = 0;
         gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Current.la_IBE_P_count[i] = 0;
         gt_g997_AtmPerf_ICELL_Running_NE.la_ICELL_P_count[i] = 0;
         gt_g997_AtmPerf_UCELL_Running_NE.la_UCELL_P_count[i] = 0;
         gt_g997_AtmPerf.la_DCELL_count[i] = 0;
         gt_g997_AtmPerf.la_ICELL_count[i] = 0;
      }
   }

#ifdef PPE_ENGINE
//   memset(&gt_g997_PtmPerf_Running_NE, 0, sizeof(G997_PtmPerfCnts_t));
//   memset(&gt_g997_PtmPerf_Cur_Prev_NE, 0, sizeof(G997_PtmPerf_Cur_Prev_t));
#endif //#ifdef PPE_ENGINE


   gt_G997_Cntrl.s_InitialCrc_HoldOff = 15;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   gsa_prev_g997_Failure_Flag_NE[0] = 0; // previous copy of gs_g997_Failure_Flag_NE
   gsa_prev_g997_Failure_Flag_NE[1] = 0; // previous copy of gs_g997_Failure_Flag_NE
   gs_prev_g997_Failure_Flag_FE = 0; // previous copy of gs_g997_Failure_Flag_FE
}

