/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: AddPsdBrkpt.c
*
*   This file contains a function to add PSD breakpoints.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "states.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Adds a PSD breakpoint. If number of breakpoints added exceeds
 *   max firmware limit, then sets next state as FAIL state and returns FALSE
 *
 *
 *  Prototype:
 *      FlagT AddPsdBrkpt(int16 s_toneIdx, int16 s_attenLevel, PSDDescriptorTable_t *pt_PSDDescOut, int16 s_MaxPsdPoints)
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *   Return:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
// ***********************************************************************************************************
// AddPsdBrkpt.c
//
// History
//
// 09/04/2019 Stefan Krause
// XDSLRTFW-4150 RubyTech Issue
// if (pt_PSDDescOut->us_NumberOfTones == s_MaxPsdPoints) all elements of the structure are already in use.
// In this case it is not possible to add one more element
// (XDSLRTFW-3728 code may result in a memory-violation!)
// Search for XDSLRTFW-4150
//
// ***********************************************************************************************************

FlagT AddPsdBrkpt(int16 s_toneIdx, int16 s_attenLevel, PSDDescriptorTable_t *pt_PSDDescOut, int16 s_MaxPsdPoints)
{
   // XDSLRTFW-4150 RubyTech Issue
   // (remove: XDSLRTFW-3728)
   // if (pt_PSDDescOut->us_NumberOfTones == s_MaxPsdPoints) all elements of the structure are already in use.
   // In this case it is not possible to add one more element
   // (XDSLRTFW-3728 code may result in a memory-violation!)
   if (pt_PSDDescOut->us_NumberOfTones >= s_MaxPsdPoints)
   {
      EnterFailStates(E_CODE_ADD_PSD_BRKPT_FAIL);
      return(FALSE);
   }

   pt_PSDDescOut->ut_PSDRecord[pt_PSDDescOut->us_NumberOfTones].us_IndexOfTone = s_toneIdx;
   pt_PSDDescOut->ut_PSDRecord[pt_PSDDescOut->us_NumberOfTones].s_PSDLevelOfTone = s_attenLevel;
   pt_PSDDescOut->us_NumberOfTones++;

   return(TRUE);
}
