/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: AllocateDataBuffers.c
*
*   This file contains functions to allocate data buffers within shared memory.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"

//Need to overlay Task Layer variables onto buffer used
//for filter coefficients (initialized in HW Engine Layer)
extern uint32 gula_PackedSRCCoeffs[];

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void AllocateDataBuffers(void)
*
*   This function allocates data buffers within shared memory.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void AllocateDataBuffers(void)
{
   //==========================================================================
   // X block partition defined for the entire duration of GHS and training and showtime
   //==========================================================================
   gpla_RxAccumBuf = (int32*)&gla_SharedBuffer_X[RX_ACCUM_BUF0_OFFSET_LW]; // also used in showtime
   gpla_SnrAccuBuf = &gla_SnrAccuBuf[0];
   gpsa_RxRepBuf = (int16*)(void *)&gla_SharedBuffer_X[RX_REP_BUF_OFFSET_LW]; // shared with RxAccumBuf

   //==========================================================================
   // Y block partition defined for the entire duration of GHS and training and showtime
   //==========================================================================
   // arrays to hold logical tone indices for MFDQ and feedback tones (ready to load HW)
   // this array is put here since it is used during MFDQ training and showtime initialization
   gt_MfdqConfig.pla_ToneTable = (int32*)&gla_SharedBuffer_Y[MFDQ_TONE_TABLE_OFFSET_LW];

   gpsa_RxToneBuf = (int16*)(void *)&gla_SharedBuffer_Y[RX_TONE_BUF_OFFSET_LW];
   //gsa_RxHlog = (int16*)(void *)&gla_SharedBuffer_Y[HLOG_BUF_OFFSET_LW];         //place this after gpsa_RxToneBuf

   gpsa_RxTDSampleBuf = gpsa_RxToneBuf;

   //==========================================================================
   // X block partition during showtime - DD FDQ SNR (X_BLOCK_1)
   // defined for the entire duration of showtime
   //==========================================================================
#ifndef HW_SNR_FDQ
   gpsa_FftOutputBuf  = (int16*)&gla_SharedBuffer_X[ERR_OUTPUT_BUF_OFFSET_LW];
   gpsa_FftErrCorrBuf = (int16*)&gla_SharedBuffer_X[FFT_ERR_CORR_BUF_OFFSET_LW];
   gpsa_ScratchPad_X = (int16*)&gla_SharedBuffer_X[X_SCRATCH_PAD_OFFSET_LW];
#endif //#ifndef HW_SNR_FDQ

   //==========================================================================
   // Y block partition during showtime - DD FDQ SNR (Y_BLOCK_1) and Rx synch frame
   // defined for the entire duration of showtime
   //==========================================================================
#ifndef HW_SNR_FDQ
   gpsa_ErrOutputBuf = (int16*)&gla_SharedBuffer_Y[FFT_OUTPUT_BUF_OFFSET_LW];
   gpsa_ScratchPad_Y = (int16*)&gla_SharedBuffer_Y[Y_SCRATCH_PAD_OFFSET_LW];
#endif //#ifndef HW_SNR_FDQ

   gpsa_RxSynchFrame = (int16*)(void *)&gla_SharedBuffer_Y[RX_SYNC_FRAME_OFFSET_LW];

   //==========================================================================
   // X block partition during MFDQ training (X_BLOCK_2)
   // defined only for the duration of MFDQ training
   // make sure none of X_BLOCK_0 is used when these buffers are active
   //==========================================================================
   // data ouput read from RTV buffers
   gt_MfdqConfig.psa_FdqOutput = (int16*)(void *)&gla_SharedBuffer_X[MFDQ_FDQOUT_BUF_OFFSET_LW];
   gt_MfdqConfig.psa_DecOutput = (int16*)(void *)&gla_SharedBuffer_X[MFDQ_DECOUT_BUF_OFFSET_LW];
   // data buffers to accumulate covariance matrix
   gt_MfdqConfig.pla_CovMatrix = (int32*)&gla_SharedBuffer_X[MFDQ_COV_MATRIX_OFFSET_LW];
   gt_MfdqConfig.pla_CorVector = (int32*)&gla_SharedBuffer_X[MFDQ_COR_VECTOR_OFFSET_LW];

   // MFDQ coefficients
   // these buffers are overlaid on top of FDQ coefficients, not shared X/Y buffers
   gt_MfdqConfig.psa_sf_coef = (int16*)&gsa_pre_FDQ_coef[MFDQ_SF_COEF_BUF_OFFSET_SW];
   gt_MfdqConfig.puca_sf_exp = (uint8*)&guca_pre_FDQ_exp[MFDQ_SF_EXP_BUF_OFFSET_B];
   gt_MfdqConfig.psa_ff_coef = (int16*)&gsa_pre_FDQ_coef[MFDQ_FF_COEF_BUF_OFFSET_SW];
   gt_MfdqConfig.puca_ff_exp = (uint8*)&guca_pre_FDQ_exp[MFDQ_FF_EXP_BUF_OFFSET_B];
   gt_MfdqConfig.psa_fb_coef = (int16*)&gsa_pre_FDQ_coef[MFDQ_FB_COEF_BUF_OFFSET_SW];
   gt_MfdqConfig.puca_fb_exp = (uint8*)&guca_pre_FDQ_exp[MFDQ_FB_EXP_BUF_OFFSET_B];

   // original SFDQ coefficients
   // these buffers are overlaid on top of FDQ coefficients, not shared X/Y buffers
   gt_MfdqConfig.psa_SfdqCoef = (int16*)&gsa_pre_FDQ_coef[MFDQ_SFDQCOEF_BUF_OFFSET_SW];
   gt_MfdqConfig.puca_SfdqExp = (uint8*)&guca_pre_FDQ_exp[MFDQ_SFDQEXP_BUF_OFFSET_B];

   gpsa_BitSwapGain = (int16 *)(void *)guca_pre_FDQ_exp;       //buffer to store the gains affected by bitswap
   //use 128 16-bit words
   gpuca_BitSwapBat = (uint8 *)&guca_pre_FDQ_exp[128*2];   //buffer to store the bits affected by bitswap

   //==========================================================================
   // initialize DILVB SharedMemory pointers
   //==========================================================================
   gpsa_DILVB_SharedMemory = (int16*)(void *)   &gula_PackedSRCCoeffs[0];

   // Used only in Medley for temporary FDQs
   gpsa_MedleyTempFDQCoeffs = gpsa_DILVB_SharedMemory;                                                 //use MAX_NUM_CHANNELS_PER_GROUP = NUM_CHANNELS_PER_GROUP_1024, i.e. 1024*2 16-bit words
   gpuca_MedleyTempFDQExps = (uint8*)(void *)&gpsa_DILVB_SharedMemory[MAX_NUM_CHANNELS_PER_GROUP<<1];  //use MAX_NUM_CHANNELS_PER_GROUP byte

   // Used following MEDLEY final SNR calculation
   gpusa_HlinBuf_FE = (uint16*)(void *)gpsa_DILVB_SharedMemory;         //pointer to the buffer storing far end Hlin (512*3) words
   gpusa_HlinBuf_NE = (uint16*)(void *)&gpsa_DILVB_SharedMemory[512*3]; //pointer to the buffer storing far end Hlin (512*3) words

   //==========================================================================
   // initialize TDQ pointers
   //==========================================================================

   //==========================================================================
   // Y block partition during the DEC training (Y_BLOCK_0)
   // defined for the duration of receiving R-P-QUIET3
   //==========================================================================

   //==========================================================================
   // initialize all other pointers (including permanent pointers)
   //==========================================================================
   // arrays to hold physical tone indices for MFDQ and feedback tones
   gt_MfdqConfig.psa_MfdqTones = gsa_MfdqTones;
   gt_MfdqConfig.psa_FbckTones = gsa_FbckTones;

   // buffer to hold loopback data for showtime loopback test
   gpsa_LpbkBuf = (int16*)(void *)&gula_PackedSRCCoeffs[0];
}
