/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: BgReconfigBandPlan.c
*
*   This file contains a function to reconfigure bandplan.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "ghs.h"      //XDSLRTFW-1318


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ClearGhsTonesInSupportedSet
 *
 *  Description:  Clears handshake tone set tones in array "guca_RxSupportedToneSet".
 *
 *  Prototype:
 *           void ClearGhsTonesInSupportedSet(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      guca_RxSupportedToneSet[]-- (I/O) the RX supported tone set
 *      gul_fe_G994VendorID      -- (I)
 *      gs_GhsCarSetCfgInternal  -- (I)
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ClearGhsTonesInSupportedSet(void)
{
   if(gs_GhsCarSetCfgInternal & (CNFG_GHS_CAR_SET_B43 | CNFG_GHS_CAR_SET_B43C))
   {
      // Disable Over ISDN Tone set
      CLEARTONEFLAG(guca_RxSupportedToneSet, 72);    // G.hs B43
      CLEARTONEFLAG(guca_RxSupportedToneSet, 88);    // G.hs B43
      if(gul_fe_G994VendorID != IFX_VENDOR_ID)
      {
         CLEARTONEFLAG(guca_RxSupportedToneSet, 96);    // G.hs B43
      }
   }
   else
   {
      // Disable Over POTS Tone set
      CLEARTONEFLAG(guca_RxSupportedToneSet, 40);    // G.hs A43
      CLEARTONEFLAG(guca_RxSupportedToneSet, 56);    // G.hs A43
      if(gul_fe_G994VendorID != IFX_VENDOR_ID)
      {
         CLEARTONEFLAG(guca_RxSupportedToneSet, 64);    // G.hs A43
      }
   }

   // Disable common cabinet and VDSL tone set tones, i.e.  A43c/B43c and VDSL tone set
   CLEARTONEFLAG(guca_RxSupportedToneSet, 257); // G.hs A43c & B43c
   CLEARTONEFLAG(guca_RxSupportedToneSet, 293); // G.hs A43c & B43c
   CLEARTONEFLAG(guca_RxSupportedToneSet, 337); // G.hs A43c, B43c & V43
   CLEARTONEFLAG(guca_RxSupportedToneSet, 383); // G.hs V43
   CLEARTONEFLAG(guca_RxSupportedToneSet, 511); // G.hs V43

}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ClearSetPilotTonesInSupportedSet
 *
 *  Description:  Clears or sets pilot tone in array "guca_RxSupportedToneSet".
 *
 *  Prototype:
 *           void ClearSetPilotTonesInSupportedSet(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      guca_RxSupportedToneSet[]-- (I/O) the RX supported tone set
 *      gt_PilotConfig           -- (I)
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
void ClearSetPilotTonesInSupportedSet(int16 s_Selection)
{
   int16 i;

   if (s_Selection == CLEAR_TONES_SUPPORTED_SET)
   {
      // Clear the pilot tones without data-on-pilot enabled from supported set to avoid bit-loading
      for (i=PT_ARRAY_IDX_0;i<=PT_ARRAY_IDX_2;i++)
      {
         // exclude the new pilot tones from the supported set
         // XDSLRTFW-3616 Start/End Sync loss observed in SRA and Bitswap test in 35B mode
         // We need to clear all pilot tones (including data-on-pilot) pilot tone here from supported set to avoid
         // other functions to add or remove any bits
         // XDSLRTFW-3918 Start/End sync loss observed in SRA tests in which a complete DS band needs to be evacuated
         // Added back data-on-pilot enabled pilot tone. Otherwise we do never off-load the bits on the data-on-pilot enabled pilot tone
         // Instead of excluding it from supported set, we need to handle this in bitswap handler, i.e. ensure that we have always <=2 bits on this pilot tone
         if( (gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx != 0) && (gt_PilotConfig.ta_PilotTones[i].ft_DeRotatePilot == FALSE) )
         {
            CLEARTONEFLAG(guca_RxSupportedToneSet, gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx);
         }
      }
   }
   else
   {
      // add back the old pilot tone indexes
      for (i=PT_ARRAY_IDX_0;i<=PT_ARRAY_IDX_2;i++)
      {
         if (gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx != 0)
         {
            SETTONEFLAG(guca_RxSupportedToneSet, gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx);
         }
      }
   }
}
// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ReconfigBandPlan
 *
 *  Description:  Reconfigures bandplan.
 *
 *  Prototype:
 *           void ReconfigBandPlan(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      gs_NumOfTxBands          -- (I) the number of TX bands
 *      gsa_TxBandLeftChannel[]  -- (I) the TX band left edges
 *       gsa_TxBandLeftChannel[]  -- (I) the TX band right edges
 *      gs_NumOfRxBands          -- (I) the number of RX bands
 *      gsa_RxBandLeftChannel[]  -- (I) the RX band left edges
 *       gsa_RxBandLeftChannel[]  -- (I) the RX band right edges
 *      gs_NumOfRFIBands         -- (I) the number of RFI bands
 *      gsa_RFIBandLeftChannel[] -- (I) the RFI band left edges
 *       gsa_RFIBandLeftChannel[] -- (I) the RFI band right edges
 *      gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx          -- (I) the Pilot tone index
 *      gs_TxNumTonesUsed        -- (O) the number of TX tones used
 *      gs_RxNumTonesUsed        -- (O) the number of RX tones used
 *      gsa_BitloadLeftChannel[] -- (O) the bitloading band left edges
 *      gsa_BitloadRightChannel[]-- (O) the bitloading band right edges
 *      guca_RxSupportedToneSet[]-- (O) the RX supported tone set
 *      ghpuca_RxExtGains_Inactive -- (O) the inactive EGT table
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ReconfigBandPlan(void)
{
   int16 i, j;

   gs_TxNumTonesUsed = 0;
   for(i=0; i<gs_NumOfTxBands; i++)
   {
      gs_TxNumTonesUsed += gsa_TxBandRightChannel[i] - gsa_TxBandLeftChannel[i] + 1;
   }

   gs_RxNumTonesUsed = 0;
   for(i=0; i<gs_NumOfRxBands; i++)
   {
      gsa_BitloadLeftChannel[i]  = gsa_RxBandLeftChannel[i];
      gsa_BitloadRightChannel[i] = gsa_RxBandRightChannel[i];
      gs_RxNumTonesUsed += gsa_RxBandRightChannel[i] - gsa_RxBandLeftChannel[i] + 1;
   }

   // Clear the RX supported tone set to re-initialize it below
   memset(guca_RxSupportedToneSet, 0, sizeof(RxToneFlags));

   // Initialize the RxSupportedToneSet with tones transmitted by far end
   // Also, set the direction bits for RX only here.
   // The TX direction bits will be set later in SetTransmitGains().
   for (i=0; i<gs_NumOfRxBands; i++)
   {
      for (j = gsa_RxBandLeftChannel[i]; j <= gsa_RxBandRightChannel[i]; j++)
      {
         // Indicates tone that is transmitted by far end
         SETTONEFLAG(guca_RxSupportedToneSet, j);
         // Set EGT direction bit to Rx
         *(ghpuca_RxExtGains_Inactive+j) &= ~0x10;
      }
   }

   // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START_END)
   memcpy(guca_RxSupportedToneSet_Aelem, guca_RxSupportedToneSet, sizeof(RxToneFlags));

   // Clear RFI tones from supported set
   for(i=0; i<gs_NumOfRFIBands; i++)
   {
      for (j = gsa_RFIBandLeftChannel[i]; j <= gsa_RFIBandRightChannel[i]; j++)
      {
         //XDSLRTFW-1113 : BUG_DS_ALL_ALL_RFI_BAND_MEMORY_CORRUPTION
         if(j < RX_MAX_NUM_TONES)
         {
            CLEARTONEFLAG(guca_RxSupportedToneSet, j);
         }
      }
   }

   // Clear Blackout tones from supported set
   for (i=0; i<gs_NumOfDsBlackoutBands; i++)
   {
      for (j=gsa_DsBlackoutBandLeftChannel[i]; j<=gsa_DsBlackoutBandRightChannel[i]; j++)
      {
         CLEARTONEFLAG(guca_RxSupportedToneSet, j);
      }
   }

   // XDSLRTFW-3751 (Start_End)
   // Generated from guca_RxSupportedToneSet, excluding tones with SNR lower than 10dB (BgIdentifyTonesForKL0_VDSL2()).
   // Note: It is used for kl0 estimate.
   //       It should include Pilot tones and Ghs tones, i.e. these tones should not be cleared!
//   memcpy(guca_RxSupportedToneSet_temp, guca_RxSupportedToneSet, sizeof(RxToneFlags));


   // XDSLRTFW-1318 : GHS Tones RFI and link drop
   // Details:
   //    We have seen that in showtime X-talk from G.hs tone set initiated some abnormal ReTx and CPE never gets any corrected DCT.
   //    To avoid this situation we have disabled these toneset for Bitloading. It is a temporary workaround. After understanding the
   //    root cause of the issue we will remove this code section.

   // TEST CMV 28 is used to enable the Mask out feature of GHS Tone for Vectoring
   // CMV TEST 28 0 0x0400
   //    0 = black out fix is disabled (default)
   //    1 = black out fix is enabled
   if ((gft_DSVectoringEnabled == TRUE) &&
         ((gus_VectoringOptionsEnabled & VEC_OPTIONS_FULL_FRIENDLY_MASK) == 0) &&
         (TESTArray[TEST_Control3] & TEST_EnableGHSToneMaskOutVectoring) )
   {
      ClearGhsTonesInSupportedSet();
   }

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : BgReconfigBandPlan
 *
 *  Description:  Background function calling ReconfigBandPlan().
 *
 *  Prototype:
 *           void BgReconfigBandPlan(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      NONE
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgReconfigBandPlan(void)
{
   ReconfigBandPlan();

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: VDSL2_BandControlGet
 *
 *  Abstract:
 *
 *  This function saves VDSL2 specific band control information for status CMVs!
 *
 *
 *  Parameters:
 *
 *   Return: None
 *
 *  Global Variables Used: None
 *
 *  Notes: CMD_RFI_BandControlGet
 *         Message Identifier: 0xCA03
 *         CMV:                INFO 202
 *         Note: The reported RFI band transmit PSD reduction configuration reflects the
 *               operator-specified frequency bands (in which the PSD transmitted by a VTU
 *               is to be no higher than -80 dBm/Hz) as defined the VTU-O CL message.
 *               A single set of RFI bands is specified, which applies to both downstream and upstream transmission.
 *
 *         CMD_BandControl_DS_Get
 *         Message Identifier: 0xC803
 *         CMV:                INFO 200
 *         Note: The reported used DS band configuration reflects the MEDLEYds set as defined in
 *               the O-PRM message of the channel discovery phase according to G.993.2.
 *
 *         CMD_BandControl_US_Get
 *         Message Identifier: 0xC903
 *         CMV:                INFO 201
 *         Note: The reported used US band configuration reflects the MEDLEYus set as defined in
 *               the R-PRM message of the channel discovery phase in G.993.2.
 *
 *         INFO2Map[INFO2_RFI_Band_Ctrl]
 *         INFO2Map[INFO2_DS_Band_Ctrl]
 *         INFO2Map[INFO2_US_Band_Ctrl]
 *
 *-------------------------------------------------------------------
 *^^^
 */
void VDSL2_BandControlGet(uint8 uc_UpdateSelect)
{
   signed int i;

   if(uc_UpdateSelect & BAND_CONTROL_UPDATE_US)
   {
      memset(&gt_TxBandControl_Act, 0, sizeof(BandDescriptorTable_t));

      gt_TxBandControl_Act.us_NumberOfBands = gs_NumOfTxBands;
      for(i=0; i<gs_NumOfTxBands; i++)
      {
         gt_TxBandControl_Act.ut_BandRecord[i].us_FirstTone = gsa_TxBandLeftChannel[i];
         gt_TxBandControl_Act.ut_BandRecord[i].us_LastTone = gsa_TxBandRightChannel[i];
      }
   }

   if(uc_UpdateSelect & BAND_CONTROL_UPDATE_DS)
   {
      memset(&gt_RxBandControl_Act, 0, sizeof(BandDescriptorTable_t));

      gt_RxBandControl_Act.us_NumberOfBands = gs_NumOfRxBands;
      for(i=0; i<gs_NumOfRxBands; i++)
      {
         gt_RxBandControl_Act.ut_BandRecord[i].us_FirstTone = gsa_RxBandLeftChannel[i];
         gt_RxBandControl_Act.ut_BandRecord[i].us_LastTone = gsa_RxBandRightChannel[i];
      }
   }

   if(uc_UpdateSelect & BAND_CONTROL_UPDATE_RFI)
   {
      memset(&gt_RFIBandControl_Act, 0, sizeof(RFIBandDescriptorTable_t));

      gt_RFIBandControl_Act.us_NumberOfBands = gs_NumOfRFIBands;
      for(i=0; i<gs_NumOfRFIBands; i++)
      {
         gt_RFIBandControl_Act.ut_BandRecord[i].us_FirstTone = gsa_RFIBandLeftChannel[i];
         gt_RFIBandControl_Act.ut_BandRecord[i].us_LastTone = gsa_RFIBandRightChannel[i];
      }
   }
}
