/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             CalcCarrierGroupSize.c
 * DESCRIPTION:      Functions to get the QLN or HLOG for subcarrier group.
 *
 **********************************************************************/

#include "common.h"

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: CalcCarrierGroupSize
 *
 *  Description: compute the subcarrier group size, G.
 *
 *  Prototype:
 *  void CalcCarrierGroupSize(int16 s_HighestToneIdx)
 *
 *  Input Arguments:
 *      s_HighestToneIdx -- the highest tone index
 *
 *  Output Arguments:
 *
 *   return:
 *      log2(G)
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 CalcCarrierGroupSize(int16 s_HighestToneIdx)
{
   int16 j;

   if(s_HighestToneIdx <= 512)
   {
      j = SUBCAR_GROUP_SIZE_LOG2_1;
   }
   else if(s_HighestToneIdx <= 1024)
   {
      j = SUBCAR_GROUP_SIZE_LOG2_2;
   }
   else if(s_HighestToneIdx <= 2048)
   {
      j = SUBCAR_GROUP_SIZE_LOG2_4;
   }
   else if(s_HighestToneIdx <= 4096)
   {
      j = SUBCAR_GROUP_SIZE_LOG2_8;
   }
   else
   {
      j = SUBCAR_GROUP_SIZE_LOG2_16;
   }

   return(j);
}
