/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CheckForBandOverlap.c
*
*   This file contains a function to check for band overlap.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CheckForBandOverlap
 *
 *  Description:  Checks to make sure TX and RX bands don't overlap
 *
 *  Prototype:
 *           FlagT CheckForBandOverlap(void)
 *
 *------------------------------------------------------------------------
 *^^^
 */
FlagT CheckForBandOverlap(void)
{
   int16 i, j, i2;

   // Check that the TX and RX bands don't overlap, i.e. no TX tone lies
   // inside an RX band.
   for (i=0; i<gs_NumOfTxBands; i++)
   {
      for (j = gsa_TxBandLeftChannel[i]; j <= gsa_TxBandRightChannel[i]; j++)
      {
         // j = current tx tone index
         for (i2=0; i2<gs_NumOfRxBands; i2++)
         {
            if ((j >= gsa_RxBandLeftChannel[i2]) && (j <= gsa_RxBandRightChannel[i2]))
            {
               return(FALSE);
            }
         }
      }
   }
   return(TRUE);
}
