/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CheckForUS0Enable.c
*
*   This file contains a function to check if US0 is enabled.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT CheckForUS0Enable(void)
*
*   This function checks if US0 is enabled.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      1: US0 is enabled
*      0: US0 is disabled
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

FlagT CheckForUS0Enable(void)
{
   if (gsa_TxBandLeftChannel[0] < US0_ISDNDOUBLE_POTSQUAD_MAX_TONE)
   {
      return (FlagT)1;
   }
   else
   {
      return (FlagT)0;
   }
}
