/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             DebugBuffer.c
 *
 * DESCRIPTION:      All functions for Debug Buffer Operation.
 *
 **********************************************************************/


#include <stdarg.h>
#include "gdata.h"
#include "stdio.h"
#include "cmv.h"
#include "states.h"
#include "eoc.h"
#include "string.h"
#ifdef DEBUG_TRACES
#include "DebugBuffer.h"
#include "FormRErrorFeedbackMsg_VDSL2.h"

/*
 *-------------------------------------------------------------------------------
 *  DebugBuffer.c
 *
 *  History :
 *
 *   28/05/2013 Varun - modified code so as avoid conflict between DMA of L2 back Channel and DMA of Debug Buffer
 *
 *  Search for "XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer"
 *
 *
 * 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
 *                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
 *
//
//06/09/2013 Palaksha/Kannan: To accomodate US RETX feature PM/DM changes
// - Increased LOCAL_LD_ST_RAM from 8K - SIZEOF(STACK_RAM) to 2*8K - SIZEOF(STACK_RAM)
// - Increased TX_UCODE_BUFFER to (500+256) from 500
// - reduced ONE_PORT_TRAIN_IRAM  to 5K-2K from 5K and Increased ONE_PORT_SHOW_IRAM  to 5K+2K from 5K
// - Moved function LogMessages from DebugBuffer.c to UsRTX_io.c
// - allocated all US RETX showtime/Pre showtime code to ONE_PORT_SHOW_IRAM section
//      Grep for XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx
//
 *-------------------------------------------------------------------------------
 */

//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx (START)
//#if 0
/*
 *-------------------------------------------------------------------------------
 *
 * Prototype: int32 LogMessages(int16 s_count, ... )
 *
 * This function accepts variable number of arguments in a particular order and copies the Tx/Rx Message data (GHS+Channel Discovery +Training +Channel Analysis + Exchange) to internal buffer . DMA of this buffer is done at the end of GHS once and At the end of Exchange once)
 *
 * Input Arguments:
 *    s_count => number of arguments to be copied
 *
 *    order of arguments type is fixed ---
 *    Example ---
 *    case 1 : If number of arguments passing are more than 2
 *    1st argument - s_count
 *    2nd argumnet - 16 bit
 *    3rd argument - 16 bit(length of message to be copied)
 *    4th argument - address(Message source address )
 *    5th argument - 32 bit(ideally -- Delimiter)
 *
 *    Case 2 : If number of arguments passing are equal to 2
 *    1st argument - s_count
 *    2nd argumnet - 32 bit(ideally -- Delimiter)
 *
 *    Any addition of arguments can be safely done by passing the arguments at beginning and modifying the corresponding case statement
 *
 *
 *
 *   Returns: 1) NO_SPACE_INTERNAL_BUFFER if no space available in the internal buffer
 *
 *       2) Nothing if Space available
 *
 *
 * Global Variables:
 *
 *-------------------------------------------------------------------------------
 */
int32 LogMessages(int16 s_count, ... )
{
   /*
      int32 l_RxTimer1, l_RxTimer2;
      int32 s_MIPS;

      //Read RX timer value
      ReadRxTimer(&l_RxTimer1);
   */

   // if bit is set (i.e. disabled) then stop logging data
   if(((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData)& GHS_TRAINING_CAPTURE_DISABLE_MASK) == 0)
   {
      va_list argp;
      uint16 us_msg_length=0,us_msg_length_pad=0;
      uint16 us_total_buff_size=(DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES>>2); //as only 2000 bytes allocated for data till training
      uint16 us_msg_type=0;

      uint8* msg_data;
      int32 l_temp_msg=0;

      //maximum of 4 arguments can be sent with the current implementation and can be added if needed by
      //changing the the correponding case statement
      if(s_count>=5)
      {
         return(EXCEEDS_MAX_ARGUMENTS);
      }

      va_start( argp, s_count );

      while(s_count-- > 0)
      {
         switch(s_count)
         {
            case 0: //delimiter
               *((uint32 *)(void *)(gpusa_debugBuff + gt_debugBufStatus.s_debugBufIndex))= va_arg( argp, uint32 );
               gt_debugBufStatus.s_debugBufIndex+=2;

               return(NO_DEBUG_BUFFER_ERROR);
// Avoid compile warning!
//              break;

            case 1 : msg_data = va_arg( argp, uint8* );

                     memcpy(&gpusa_debugBuff[gt_debugBufStatus.s_debugBufIndex],msg_data,us_msg_length); //memcpy(destination , source , length)

                     memcpy(gpusa_debugBuff+(gt_debugBufStatus.s_debugBufIndex<<1)+us_msg_length,&l_temp_msg,us_msg_length_pad);

                     gt_debugBufStatus.s_debugBufIndex+= ((us_msg_length+ us_msg_length_pad)>>1);
                     break;
            case 2 ://message length
                     us_msg_length = va_arg( argp, uint16 );
                     us_msg_length_pad = ((4-(us_msg_length&3))&3);
                     // copy only if buffer space is available .. value 4 indicates 2 bytes of message length and message type in the following line
                     if((us_total_buff_size-gt_debugBufStatus.s_debugBufIndex) > (((us_msg_length+us_msg_length_pad)>>1)+4))
                     {
                        *(gpusa_debugBuff+gt_debugBufStatus.s_debugBufIndex) =us_msg_type ;
                        *(gpusa_debugBuff + gt_debugBufStatus.s_debugBufIndex+1)= us_msg_length;
                        gt_debugBufStatus.s_debugBufIndex+=2;
                     }
                     else
                     {
                        return(NO_SPACE_INTERNAL_BUFFER);
                     }

                     break;

            case 4 :
            case 3 :     //message type
                     us_msg_type = va_arg( argp, uint16 );
                     break;
         }
      }

      va_end( argp );


      /*
      // Read RX timer value
      ReadRxTimer(&l_RxTimer2);

      //Compute the MIPS for this task
      s_MIPS = (l_RxTimer2 - l_RxTimer1);

      if (s_MIPS < 0)
      {
         s_MIPS = (s_MIPS + gl_MaxRxTimerCnt);
      }

      if(s_MIPS > gl_mipsdebug1)
      {
         gl_mipsdebug1=s_MIPS;
      }
      */
   }

   return(0);
}
//#endif
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx (END)

/*
 *-------------------------------------------------------------------------------
 *
 * Prototype: void ShowtimeDebugBuffSymbolUpdate(void)
 *
 * This function updates the Debug structure which collects data for every symbol and eventually calls the function
 * LogShowtimeData(), which copies this structure to internal buffer
 *
 * Input Arguments: void
 *
 * Returns: Void
 *
 *
 * Global Variables:
 *
 *-------------------------------------------------------------------------------
 */
void ShowtimeDebugBuffSymbolUpdate(void)
{
   /*
   int32 l_RxTimer1, l_RxTimer2;
   int32 s_MIPS;

   // Read TX timer value
   ReadRxTimer((void *)&l_RxTimer1);
   */

   // copy real and imaginary part of pilottone to structure
   //memcpy(&gt_DebugBuffSymbol.s_rx_PilotToneReal,gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re,4);   //@todo: AH, do we want to log the complete array? instead of 4 8?
   gt_DebugBuffSymbol.s_rx_PilotToneReal = gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re;
   gt_DebugBuffSymbol.s_rx_PilotToneImaginary = gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Im;

   LogShowtimeData((uint8 *)(void *)&gt_DebugBuffSymbol,gt_DebugBufferStatus.s_debugBuffer_Size_of_Per_Symbol_structure_Bytes);

   /*
   ReadRxTimer(&l_RxTimer2);

   //Compute the MIPS for this task
   s_MIPS = (l_RxTimer2 - l_RxTimer1);

   if (s_MIPS < 0)
   {
      s_MIPS = (s_MIPS + gl_MaxRxTimerCnt);
   }

   if(s_MIPS>gl_mipsdebug2)
   {
      gl_mipsdebug2=s_MIPS;
   }
   gl_mipsdebug1= s_MIPS;
   */
}

/*
 *-------------------------------------------------------------------------------
 *
 * Prototype: void ShowtimeDebugBuffSuperframeUpdate(void)
 *
 * This function updates the Debug structure which collects data for every Sync symbol and calls the function
 * LogShowtimeData(), which copies this structure to internal buffer
 *
 * Input Arguments: void
 *
 * Returns: Void
 *
 *
 * Global Variables:
 *
 *-------------------------------------------------------------------------------
 */

// XDSLRTFW-3033  gus_L2ErbTransmissionCnt is NOT working anymore
// XDSLRTFW-3035  Update Showtime debug buffer / add version for ST DBG buffer
void ShowtimeDebugBuffSuperframeUpdate(void)
{
   /*
    int32 l_RxTimer1, l_RxTimer2;
    int32 s_MIPS;

    //Read TX timer value
    ReadRxTimer(&l_RxTimer1);
   */

   gt_DebugBuffSuperframe.l_SymbolCount = gl_RxSymbolCount;

   // Received Pilot Tone (real, imag)
   // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
   // XDSLRTFW-3034 (Start)
   gt_DebugBuffSuperframe.sa_RxPilotToneAtSyncSymbol[0] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneAtSyncSymb_Re;
   gt_DebugBuffSuperframe.sa_RxPilotToneAtSyncSymbol[1] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneAtSyncSymb_Im;
   // XDSLRTFW-3034 (End)

   gt_DebugBuffSuperframe.sa_RxPilotTone2[0] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Re;
   gt_DebugBuffSuperframe.sa_RxPilotTone2[1] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Im;
   // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

   // Eoc members
   memcpy(gt_DebugBuffSuperframe.usa_EocNumTimeouts, gusa_EocNumTimeouts, sizeof(uint16)*MAX_OVHD_PRIORITY);

   // OLR counter
   // US OLR
   gt_DebugBuffSuperframe.OLR_PM_COUNT_US.us_SimpleOLRPMReq_Cnt     = gt_UsOLRPMCnt.t_BitswapCnt.us_SimpleOLRPMReq_Cnt;
   gt_DebugBuffSuperframe.OLR_PM_COUNT_US.us_OLRPMUTCResp_Cnt       = gt_UsOLRPMCnt.t_BitswapCnt.us_OLRPMUTCResp_Cnt;
   gt_DebugBuffSuperframe.OLR_PM_COUNT_US.us_ActualOLRPMPerform_Cnt = gt_UsOLRPMCnt.t_BitswapCnt.us_ActualOLRPMPerform_Cnt;
   // DS OLR
   gt_DebugBuffSuperframe.OLR_PM_COUNT_DS.us_SimpleOLRPMReq_Cnt     = gt_DsOLRPMCnt.t_BitswapCnt.us_SimpleOLRPMReq_Cnt;
   gt_DebugBuffSuperframe.OLR_PM_COUNT_DS.us_OLRPMUTCResp_Cnt       = gt_DsOLRPMCnt.t_BitswapCnt.us_OLRPMUTCResp_Cnt;
   gt_DebugBuffSuperframe.OLR_PM_COUNT_DS.us_ActualOLRPMPerform_Cnt = gt_DsOLRPMCnt.t_BitswapCnt.us_ActualOLRPMPerform_Cnt;
   gt_DebugBuffSuperframe.OLR_PM_COUNT_DS.us_RespTimeOut_Cnt        = gt_DsOLRPMCnt.t_BitswapCnt.us_RespTimeOut_Cnt;

   // Margin values
   gt_DebugBuffSuperframe.s_SnrMargin       = gt_LineStatusDS.s_SnrMargin;
   gt_DebugBuffSuperframe.s_RxMinMargin     = gs_RxMinMargin;
   gt_DebugBuffSuperframe.s_RxMinMarginTone = gs_RxMinMarginTone;

   // DS CRC noninhibit counter (LP0, LP1)
   memcpy(&gt_DebugBuffSuperframe.usa_NonInhibit_CRC_Cntr_NE[0], gusa_NonInhibit_CRC_Cntr_NE, sizeof(uint16)*NUM_DATA_PATHS);

   //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   // copy Failure flag NE and FE
   memcpy(&gt_DebugBuffSuperframe.usa_g997_Failure_Flag_NE[0], &gsa_g997_Failure_Flag_NE[0], sizeof(uint16)*3);

   gt_DebugBuffSuperframe.us_NeSefDefectCounter = (uint16)gul_NeSefDefectCounter;

   //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
   //XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode (Start_End)
   gt_DebugBuffSuperframe.ReTx_Status.us_RetransmittedDtuCnt = (uint16)gt_ReTXStats.ul_RetransmittedDtuCntFE;
   gt_DebugBuffSuperframe.ReTx_Status.us_CorrectedDtuCnt     = (uint16)gt_ReTXStats.ul_CorrectedDtuCnt;
   gt_DebugBuffSuperframe.ReTx_Status.us_UncorrectedDtuCnt   = (uint16)gt_ReTXStats.ul_UncorrectedDtuCnt;
   gt_DebugBuffSuperframe.ReTx_Status.us_TotalDtuCnt         = (uint16)gt_ReTXStats.ul_TotalDtuCnt;
   gt_DebugBuffSuperframe.ReTx_Status.us_UnexpectedDtuCnt    = (uint16)gt_ReTXStats.ul_UnexpectedDtuCnt;

   // #ifdef VRX518_SINGAPORE_BRINGUP
   // gt_DebugBuffSuperframe.Debug1 = (uint16)gul_retransmitted_delta;
   // gt_DebugBuffSuperframe.Debug2 = (uint16)gt_RrcStat.ul_PrevRrc;  //<15:0>
   // gt_DebugBuffSuperframe.Debug3 = (uint16)(gt_RrcStat.ul_PrevRrc >> 16); //<16:31>
   // gt_DebugBuffSuperframe.Debug4 = (uint16)gul_RRC_data;
   // gt_DebugBuffSuperframe.Debug5 = (uint16)(gul_RRC_data >> 16);
   // gt_DebugBuffSuperframe.Debug6 = (uint16)gus_RRC_BadCW; //XDSLRTFW-3101 (Start_End)
   // #endif

   // XDSLRTFW-3033 (Start)
   gt_DebugBuffSuperframe.us_EOC_ErrorFB_CMD_count  = (uint16)gul_EOC_ErrorFB_CMD_count;
   gt_DebugBuffSuperframe.us_ErrVectDiscard         = (uint16)gt_DsmStats.ul_ErrVectDiscard;
   gt_DebugBuffSuperframe.us_ErrVecTransmitted      = (uint16)gt_DsmStats.ul_ErrVecTransmitted;
   gt_DebugBuffSuperframe.us_ErrVecRequested        = (uint16)gt_DsmStats.ul_ErrVecRequested;
   // XDSLRTFW-3033 (End)

   //copy the entire structure formed to internal buffer
   LogShowtimeData((uint8 *)(void *)&gt_DebugBuffSuperframe,gt_DebugBufferStatus.s_debugBuffer_Size_of_Super_Frame_structure_Bytes);

   /*
   ReadRxTimer(&l_RxTimer2);

   //Compute the MIPS for this task
   s_MIPS = (l_RxTimer2 - l_RxTimer1);

   if (s_MIPS < 0)
   {
      s_MIPS = (s_MIPS + gl_MaxRxTimerCnt);
   }

   if(gl_mipsdebug3<s_MIPS+gl_mipsdebug1)
   {
      gl_mipsdebug3=s_MIPS+gl_mipsdebug1;
   }
   if(gl_mipsdebug4<s_MIPS)
   {
      gl_mipsdebug4=s_MIPS;
   }
   gl_mipsdebug6=s_MIPS;
   gl_mipsdebug1=1;
   */

}


void ShowtimeDebugBuffUpdate(void)
{
   // Buffer control Bit1 controls the showtime debug feature!
   // - disabled (Bit1 = 1)
   // - enabled  (Bit1 = 0)
   if((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData & SHOW_TIME_CAPTURE_DISABLE_MASK) == 0)
   {
      // Update the debug buff for every 'Xth' symbol
      // Note: One is added to TxPMDFrameCnt to make sure that log Per 'X' is not always true at gs_TxPMDFrameCnt=0
      if(((gs_TxPMDFrameCount+1) % gt_DebugBuffControl.s_debugBuffer_STCaptureXSymbol)==0)
      {
         ShowtimeDebugBuffSymbolUpdate();
      }

      // Log debug data once per superframe
      if (gs_TxPMDFrameCount > TX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         ShowtimeDebugBuffSuperframeUpdate();
      }
   }
}


/*
 *-------------------------------------------------------------------------------
 *
 * Prototype: int32 LogShowtimeData(void *puc_base_addr , uint16 us_num_bytes)
 *
 * This function updates the internal Buffer(guca_DebugBuf) with the showtime debug data colleted . Internal Buffer(size=4000 bytes) is divided into Ping(2000 bytes) and Pong(2000 bytes) buffers . Keep filling ping untill it is full and then switch the buffer start filling the pong , parallelly initiate the DMA of ping ... Similarly once Pong is full , DMA the pong and start filling the ping ... If initiated DMA(of ping or pong) not completed by the time we want to DMA the other buffer it returns "Buffer FULL condition error" and waits untill DMA becomes free.
 *
 * Input Arguments:
 *
 *   puc_base_addr => source address of structure to be copied
 *   us_num_bytes => Number of Bytes to be copied
 *
 *   Returns: 0 if no error
 *        1 if Buffer full condition
 *
 *
 * Global Variables:
 *
 *
      +-------------+ ^ ^
      |             | | |
      |  Ping Buf   | | | DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES
      |             | | |
      +-------------+ | -
      |             | |
      |  Pong Buf   | | DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES
      |             | |
      +-------------+ -

 *
 * Note: Initially the first parameter was of type uint8 but to suppress/remove
 *       warning it is changed to type void. Suitable correction are made in the
 *       function and wherever it is used.
 *-------------------------------------------------------------------------------
 */

int32 LogShowtimeData(uint8 *puc_base_addr , uint16 us_num_bytes)
{
   static int32 l_Ping_DMA_once=0; //Flag which enables dma of Ping buffer to be done only once before DMA of        pong buffer is done


   //calculate the Total available length in the internal buffer
   int16 s_avail_length=(DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES-gus_LenDebugBuff);

   //available length in ping buffer
   int16 s_avail_length_ping=(DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES-gus_LenDebugBuff);

   //if available length in internal buffer is more than the number of bytes to be written
   if(s_avail_length >= us_num_bytes)
   {
      //Available length in Ping is less than number of bytes to be written and [L2 backchannel DMA started or  DMA of Pong is not yet over] => error
      // XDSLRTFW-3454 (Start_End)
      // Modified the Flag (guc_EVB_DebugBuff_flag) check to accomadate the different values
      if((!l_Ping_DMA_once) && (s_avail_length_ping <= us_num_bytes) &&
            ((guc_EVB_DebugBuff_flag != 0)||(!(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE))))
      {
         //increment the error count only if it is not due to L2 back channel DMA
         if(guc_EVB_DebugBuff_flag == 0)
         {
            gul_DMA_Busy_Error++; //increment the error count
         }

         return(INTERNAL_BUFFER_FULL);
      }

      //copy the bytes to be written to internal buffer
      memcpy(&gpuca_DebugBuff_PingPong[gus_LenDebugBuff],puc_base_addr,us_num_bytes);
      //increment the index to next index to be written
      gus_LenDebugBuff+=us_num_bytes;

      //if ping buffer is full then initiate the DMA
      if(!l_Ping_DMA_once && (gus_LenDebugBuff>=DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES))
      {
         // set the flag => DMA of ping is initiated once
         l_Ping_DMA_once=1;

         //is DMA of Pong completed and if yes then start the DMA of ping
         DMAtoSDRAM((int32 *)(void *)gpusa_debugBuff,DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES);
      }
      return(NO_DEBUG_BUFFER_ERROR);
   }
   else
   {
      //L2 back channel DMA over(if triggered) and DMA of ping completed
      if((guc_EVB_DebugBuff_flag==0)&& PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
      {
         //copy available length data to pong buffer. Pong would be full after this memcpy
         memcpy(&gpuca_DebugBuff_PingPong[gus_LenDebugBuff],puc_base_addr,s_avail_length);

         //set the flag to zero so to write the ping now.
         l_Ping_DMA_once=0;

         //set the pointer length to zero
         gus_LenDebugBuff=0;

         //DMA the pong buffer
         DMAtoSDRAM((int32 *)(void *)&gpusa_debugBuff[(DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES>>1)],DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES);

         //copy the remaining bytes to be written to ping buffer
         memcpy(&gpuca_DebugBuff_PingPong[gus_LenDebugBuff],&puc_base_addr[s_avail_length],(us_num_bytes-s_avail_length));

         //increment the bufer index to point the next index to be written
         gus_LenDebugBuff+=(us_num_bytes-s_avail_length);

         return(NO_DEBUG_BUFFER_ERROR);
      }
      else
      {
         //XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
         //increment the error count only if it is not due to L2 back channel DMA
         //Available length in Ping is less than number of bytes to be written and [L2 backchannel DMA started or  DMA of Pong is not yet over] => error
         // XDSLRTFW-3454 (Start_End)
         if(guc_EVB_DebugBuff_flag == 0)
         {
            gul_DMA_Busy_Error++; //increment the error count
         }
         return(INTERNAL_BUFFER_FULL);
      }
   }
}


/*
 *-------------------------------------------------------------------------------
 *
 * Prototype: DMAtoSDRAM(void *pl_addr_source ,int16 s_size_bytes)
 *
 * This function will initiate the DMA of internal buffer(guca_DebugBuf) to guc_offChipDebugBuff(BAR 15 of SDRAM).
 *
 *   Input Arguments: pl_addr_source => source address of buffer to copied
 *              s_size_bytes => number of bytes to be copied
 *
 * Global Variables:
 *
 *  Notes: Initially the first parameter was of type int32 but to suppress/remove a warning
 *         it has been changed to type void. And suitable changes are made in the function
 *         and wherever it is being employed.
 *-------------------------------------------------------------------------------
 */


void DMAtoSDRAM(int32 *pl_addr_source ,int16 s_size_bytes)
{
   gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_SOURCE_INDEX] = (int32)pl_addr_source; // update source address
   gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_DEST_INDEX] = (int32)&gpuca_offChipBuffShowtime[gul_LenoffChipBuffShowtime]; // destination;
   gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_LENGTH_INDEX] = s_size_bytes;    // size in bytes; make sure length is multiple of 4-bytes

   gul_LenoffChipBuffShowtime+=s_size_bytes; //increment the length so to point to the next location to be written


   if(gul_LenoffChipBuffShowtime >= (RAW_DUMP_MAX_SDRAM_SIZE_BYTES-SDRAM_RAW_DUMP_SHOWTIME_START_INDEX))
   {
      gul_LenoffChipBuffShowtime=0; //reset the length to zero if it exceeds the max value bytes to be written
      gt_DebugBufferStatus.s_debugBuffer_Showtime_length=(RAW_DUMP_MAX_SDRAM_SIZE_BYTES-SDRAM_RAW_DUMP_SHOWTIME_START_INDEX)>>1;
      guc_StLengthFlag=1;
   }

   if(guc_StLengthFlag==0)
   {
      gt_DebugBufferStatus.s_debugBuffer_Showtime_length=(gul_LenoffChipBuffShowtime>>1);
   }
   else
   {
      gt_DebugBufferStatus.s_debugBuffer_Showtime_Oldested_data_Start=(gul_LenoffChipBuffShowtime>>1);
   }

   // Free handle for PSD offchip request
   FreeSwapHandle(&guc_OffChipRequestHandle);
   guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DEBUG_BUF);
}


//void DebugBuffWriteEv(uint8 EventID, uint8 PayloadLen, uint8 *pPayloadData)
void DebugBuffWriteEv(uint8 EventID, uint8 PayloadLen, void *pPayloadData)
{
   // Buffer control Bit3 controls the showtime event debug feature!
   // - disabled (Bit3 = 1)
   // - enabled  (Bit3 = 0)
   if((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData & SHOW_TIME_EVENT_DISABLE_MASK) == 0)
   {
//       uint32 IrqStatus;
      int16 CurIdx;
      T_DebugBuffEvt *pEvtTraceBuf;

// The pragma is ARC only!
#pragma Off(Behaved)
      pEvtTraceBuf = &gt_DebugBuff.tDebugBuffEvt;
#pragma Pop(Behaved)
      // Disable interrupt to prevent any race conditions between BG & FG
//       MTK_DisableIrqs(&IrqStatus);

      // Limit the number of payload bytes to max value that can be stored
      // in an Event element.
      if(PayloadLen > DEBUG_BUFF_EVT_MAXPAYLOAD)
      {
         PayloadLen = DEBUG_BUFF_EVT_MAXPAYLOAD;
      }

      // Incement the number of occured Events
      pEvtTraceBuf->EvtTraceBufCnt++;

      // Index of the Event element to be written
      CurIdx = pEvtTraceBuf->EvtTraceBufIndex;
      // Wrap-around handling of debug buffer Event elements
      if((CurIdx >= DEBUG_BUFF_EVT_ELEMENT_MAX) || (CurIdx < 0))
      {
         CurIdx = 0;
      }

      // Store info to the Event element
      pEvtTraceBuf->aEvtTraceBuf[CurIdx].RxSymbolCount = gl_RxSymbolCount;
      pEvtTraceBuf->aEvtTraceBuf[CurIdx].EventID = (uint16) EventID;

      // Clear Event element payload bytes before writing!
      // Note: This is needed since the payload can have a different length!
      memset(&pEvtTraceBuf->aEvtTraceBuf[CurIdx].aPayload[0], 0, (sizeof(uint8)*DEBUG_BUFF_EVT_MAXPAYLOAD));
      if(pPayloadData != NULL)
      {
         memcpy(&pEvtTraceBuf->aEvtTraceBuf[CurIdx].aPayload[0], pPayloadData, PayloadLen);
      }

      pEvtTraceBuf->EvtTraceBufIndex = (int16) (CurIdx + 1);

//      MTK_RestoreIrqs(IrqStatus);
   }
}

#endif // #ifdef DEBUG_TRACES

