/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             GetSnrForCarrierGroup.c
 * DESCRIPTION:      Functions to get the SNR for subcarrier group.
 *
 **********************************************************************/

// ***********************************************************************************************************
// GetSnrForCarrierGroup.c
//
// History
//
// 10/07/2012 Vinjam: Added code to send actual Show time SNR with out virtual noise
//                     Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 25/07/2012 Vinjam: Added code to send SNR with out virtual noise in loop diagnostics mode
//                     Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 08/08/2012 Vinjam: Added a seprate buffer to hold SNR with out virtual noise for DELT mode
//                    It is valid for single port mode only (unbonded - 8a,12a,17a & 30a profiles)
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 10/08/2012 Vinjam: Commeented out checking finegains while computing SNRpergroup. As per standard
//                    all tones with Bi>0 to be considered for SNRpergroup. So added check for Bi==0
//                    while computing SNRpergroup.
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 03/12/2012 Vinjam: To save data memory in "Port-1", "gsa_RxWithOutVnSnrBuf[4096]" is converted
//                    to "gca_DELT_RxWithOutVnSnrBuf[2048]"
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 15/02/2013 Vinjam : Memory Optimization. Re-used gsa_RxPathAtten_Tmp[] to store SNR with out virtual noise during LDM in channel Ananlysis phase.
//                  gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(&gsa_RxPathAtten_Tmp[0]);
//                     Grep for XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name: GetSnrForCarrierGroup
 *
 *  Description: determines Snr for sub carrier group
 *
 *  Prototype: GetSnrForCarrierGroup(const uint16 CarrierGroup)
 *
 *
 *  Input Arguments: us_CarrierGroup index in the range of 0..511
 *
 *  Output Arguments: returns Snr for sub-carrier group
 *
 *
 *  Notes: Snr-ps is calculated from gsa_SnrBuf there is no array maintained for
 *         Snr-ps
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define LOWEST_SNR_VALUE    ((-32) << 8)
#define HIGHEST_SNR_VALUE   (95 << 8)

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
//Added a buffer to store SNR with out virtual noise in DELT mode
//SNR in 8.8 format is converted to 7.1 format to same physical memory
//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start_End)
extern int8 *gpca_DELT_RxWithOutVnSnrBuf;

uint8 GetSnrForCarrierGroup(const uint16 us_CarrierGroup)
{
   uint8 uc_SNRVal;
   uint16 us_toneIdx, us_startToneIdx, us_endToneIdx;
   FlagT ft_InbandTone = 0;
   int32 l_AvgSnr = 0;
   int16 s_SnrValue;
   int16 s_do_nothing;     /* XDSLRTFW-2302 */

   // compute the start and end tone index of this subcarrier group
   us_startToneIdx = us_CarrierGroup << gs_Log2CarrierGroupSizeRx_Medley;
   us_endToneIdx = us_startToneIdx + gs_CarrierGroupSizeRx_Medley;


   for (us_toneIdx = us_startToneIdx; us_toneIdx < us_endToneIdx; us_toneIdx++)
   {

      //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
      if((gsa_IndirectStat0[0] == STAT_ShowTimeTCSyncState) && (gft_DSVirtualNoiseStatus))
      {
         //Converted SNR(with out virtual noise) from 7.1 to 8.8 format.
         s_SnrValue = (int)(gca_SnrBuf_WithOutVN[us_toneIdx] << 7);
      }
      else
      {
         if((gsa_IndirectStat0[0] == STAT_LoopDiagMode) && (gft_DSVirtualNoiseStatus) && (guc_PortMode == 0))
         {
            //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
            //SNR with out virtual noise for Loop diagnostics mode
            //Valid for single port mode only (12a, 17a & 30a Profiles only - in unbonded mode)
            //Valid for 8a profile in "unbonded" mode
            //SNR is converted from 7.1 format to to 8.8 format
            //XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start_End)
            s_SnrValue = (int)(gpca_DELT_RxWithOutVnSnrBuf[us_toneIdx] << 7);
         }
         else
         {
            //Normal Initialization Mode
            s_SnrValue = gsa_SnrBuf[us_toneIdx];
         }
      }

      // gsa_SnrBuf is in range of -32 and 95 dB
      if ((s_SnrValue < LOWEST_SNR_VALUE) || (s_SnrValue > HIGHEST_SNR_VALUE))
      {
         return OUT_OF_RANGE_SNR;
      }

      // make sure the band is active
      if (IS_TONEFLAGSET(guca_RxSupportedToneSet, us_toneIdx) == 0)
      {
         //@todo AH: check if we need special handling for all pilot tones
         // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
         if ((us_toneIdx ==gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx) || (us_toneIdx ==gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx) || (us_toneIdx == gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx)) //XDSLRTFW-2302
            s_do_nothing =1;
         else
            return OUT_OF_RANGE_SNR;
      }

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
      //Not clear why fainegains are checked while computing SNR per group? Vinjam
      //if(ghpsa_RxFineGains_Inactive[us_toneIdx] == 0)
      //return OUT_OF_RANGE_SNR;
      //As per standard, Bi > 0 neeed to be considered while computing SNR per group
      if(ghpuca_RxBat_Inactive[us_toneIdx] == 0)
      {
         return OUT_OF_RANGE_SNR;
      }
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

      l_AvgSnr += s_SnrValue;
      //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

   } // for

   // Compute the average over G tones
   l_AvgSnr >>= gs_Log2CarrierGroupSizeRx_Medley;

   // convert to proper format
   // snr(k) = ( SNR(kG) + 32)*2
   uc_SNRVal = (uint8)(((l_AvgSnr + (32<<8)) + (1<<6)) >> 7) & 0xFF;

   return (uc_SNRVal);
}

#undef LOWEST_SNR_VALUE
#undef HIGHEST_SNR_VALUE
