/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/******************************************************************************
******************************************************************************/

// ************************************************************************************************************************
// Vr9_1port_debug_data.c
// this contains all debug variables in 1-port mode
//
// History
//
// 08/08/2012 Vinjam: Added a seprate buffer to hold SNR with out virtual noise for DELT mode
//                    It is valid for single port mode only (unbonded - 8a,12a,17a & 30a profiles)
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 03/12/2012 Vinjam: To save data memory in "Port-1", "gsa_RxWithOutVnSnrBuf[4096]" is converted
//                    to "gca_DELT_RxWithOutVnSnrBuf[2048]"
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 14/02/2013 Vinjam : Resolved memory corruption by relocating the guca_SNRBuf_NE[ ] to "ONE_PORT_SHOW_ONLY_DATA" section.
//                     Grep for XDSLRTFW-726 Bug_All_VDSL2_All_MemoryCorruption
//
// 15/02/2013 Vinjam : Memory Optimization. Re-used gsa_RxPathAtten_Tmp[] to store SNR with out virtual noise during LDM in channel Ananlysis phase.
//                gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(&gsa_RxPathAtten_Tmp[0]);
//                     Grep for XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization
//
// 06/05/2013 Varun : Added variables and buffers for the Debug buffer operation
//               Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and
//                  Grep for "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 22/07/2013 Varun : Added variables and buffers to be used only in showtime in ReTx mode(defined in the section : DATA_ONE_PORT_SHOW_DATA_BEGIN)
//                    Grep for: XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC
//
//21/10/2013 Varun : Memory optimization as a part of Amend2. Added TRAIN_ILV_DILV_TRAINING_ONLY data ovelay section
//                   Grep for XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt
//
// 30/10/2013 Anantha Ramu: Added variables for attndr calculations with new methods.
//                          Grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
// 23/09/2014 Kannan: Moved 16 & 32 bit variables from "ONE_PORT_SHOW_ONLY" to DM page
//                    "VCPE_DEC_MEM_16BIT_FADX_DM"  to reduce DM size,
//                    this is required to increase PM size in "VCPE_ONE_PORT_SHOW_FADX_PM_BT"
//
//            1. Transmitter should offer an RRC codeword capture feature for up to 256 RRC CWs and capturing is started with the
//               first RRC CW where Nack[1:0] is unequal 0b00. (256 * 24bits to be stored).
//               Capture can be enabled by setting gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0. Once set to zero,
//               capture will start from first bad dtu and gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt will be incremented upto 255.
//               To re-capture again set gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0.
//            2. Transmitter should offer the possibility to measure the actual roundtrip in number of DTUs per DTU from DTU TX insertion
//               until getting the first ACK info and should report the max./min. value captured during operation. (This already exist)
//               Reseting the measurement during operation is suppoterd now.
//            3. The structure RtxDbgCapture_t has been mapped to a new CMV INFO 241.
//    Grep for XDSLRTFW-1622
//
// ****************************************************************************************************************
#include "common.h"
#include "hmp.h"
#include "DebugBuffer.h"
#include "data_alloc.h"
#include "Us_Rtx.h"
#include "DshInterface.h"

#ifdef LOG_HMP_CMV_WRITES
int16 gs_HmpLogIndex, gsa_HmpLogBuf[HMP_LOG_BUF_SIZE];
#endif

#ifdef VR9_DBG_HYB
int16 gsa_dbg_hyb[32]; // save PGA per hybrid
int16 gs_dbgTestIndex;
#endif

#ifdef EOC_DEBUG_DATA
uint8 guca_EocDebugBuf[100];
#endif

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
//Added a buffer to store SNR with out virtual noise in DELT mode
//Valid for single port mode only (12a, 17a & 30a Profiles only - in unbonded mode)
//Valid for 8a profile in "unbonded" mode
//SNR in 8.8 format is converted to 7.1 format to same physical memory
//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start_End)
int8 *gpca_DELT_RxWithOutVnSnrBuf;

//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryCorruption (Start_End)
uint8 guca_SNRBuf_NE[512];    //the buffer storing near end SNR per subcarrier group

// XDSLRTFW-1063: SRAds_Support_with_DS_ReTx
ReTX_ShowtimeParams_t gt_ReTxShowtimeParams;
ReTX_ShowtimeParams_t gt_UsReTxShowtimeParams;

DSH_Statics_t gt_DshStatics;

#ifdef DEBUG_TRACES
//XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
DebugShowTimeBuffSymbol_t gt_DebugBuffSymbol;
DebugShowTimeBuffSuperframe_t gt_DebugBuffSuperframe;
DebugShowTimeBuffUsReTxOnly_t gt_DebugShowTimeBuffUsReTxOnly;

DebugBufferControl_t gt_DebugBuffControl;
DebugBufferStatus_t gt_DebugBufferStatus; //Debug buffer status CMV updating
DebugBufStatus_t gt_debugBufStatus; // structure which is used for index and length controlling while writing to gusa_DebugBuf[]

uint16 *gpusa_debugBuff ;//pointer to internal buffer gusa_DebugBuf till training
uint8 *gpuca_offChipBuff;

uint8 guc_StLengthFlag;

//snv
//variabels used for mips calculation in Debug buffer
#ifdef MIPS_PROFILE_USRETX
int32 gl_mipsdebug1 ,gl_mipsdebug2,gl_mipsdebug3,gl_mipsdebug4,gl_mipsdebug5,gl_mipsdebug6;
#endif

uint8 *gpuca_DebugBuff_PingPong; //pointer to ping/pong buffer of size 2000 bytes

uint8 *gpuca_offChipBuffShowtime; //pointer to SDRAM in showtime buffer
uint32 gul_LenoffChipBuffShowtime; //Length of Data written in SDRAM in showtime
uint8 guc_ShowtimeEnter;
uint32 gul_DMA_Busy_Error;
uint16 gus_LenDebugBuff; // length of bytes written in ping+pong buffer
#endif //#ifdef DEBUG_TRACES
uint8 guc_EVB_DebugBuff_flag; // 0 = DebugBuffer; 1 = ERB via L2; 2 = Mailbox SDRAM access ; flag which will be set when DMA is triggered in L2 Back channel
//XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
//Memory Overlay: Re-used this bufer to store SNR with out virtual noise during LDM in channel Ananlysis phase. XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization
//int16 gsa_ELE_Tmp[RX_MAX_NUM_TONES];
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
ConfigVar_USReTx_t gt_UsReTx_ConfigVar;
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
//XDSLRTFW-1422(START_END) delay in DTUs(Min and Max)
UsReTxDelay_DTU_t gt_UsReTx_DelayDTUs;

//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)
//XDSLRTFW-1707_30a_RTX_DsUs (Start)
DATA_LOCAL_LD_ST_BEGIN

int16 gs_HQV_MaxIdx;
int16 gs_HQV_MinIdx=0;
int16 gs_rxILVBaseAddrOffset;

//Debug
#ifdef ENABLE_RETX_US_DEBUG
int32 gpla_UsReTxBufWrAddrDebug[3];
int16 gsa_UsReTxBufWrSize[3];
int16 gs_UsretxDebug1;
#endif

DATA_MAP_END;
//XDSLRTFW-1707_30a_RTX_DsUs (End)
int16 gs_DTUSizeDS, gs_DTUPayloadSizeDS, gs_QTx;
uint16 gus_DebugVar1;
//XDSLRTFW-1417 (Start)
#ifdef ENABLE_RETX_US_DEBUG1
uint16 gusa_ReTxDebugBuf[5];
uint32 gula_PalakDebug[5];
#endif
//XDSLRTFW-1417 (End)
//XDSLRTFW-1830 (START)
uint8 guc_StNewDtuTc = 0;
uint8 guc_StPartialDtuTc = 0;
uint8 guc_num_Dtu_EndBoundary = 0;
long long int gl_RrcValid; // 64 bit variable
//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory
int16 gs_DsQRx, gs_DsQTx;
int16 gs_DTUtc_Size, gs_RTXusR_Size, gs_DTUi_SizeInr;
//XDSLRTFW-1830 (END)
uint16 gs_num_RndTrip_Errors;
int16 gs_RRCToneOffset; // keeps track of how many tones are used to bitload RRC bits.
int16 gs_RRCOffset;
int16 gs_DTU_size;
int16 gs_running_DTUSize;
int16 gs_running_PMSSize;
int16 gs_DtuSizeIncr;
int16 gs_DTU_id;
uint16 gs_num_discarded_DTUs;
uint16 gusa_RdDataSize[2];
int16 gsa_size_num_bytes_transfer[3];
uint16 gusa_ReTxTable[SIZETT];
int16 gs_ReTxTable_wr_pointer;
int16 gs_Delta_DTU_TX;
int32 gl_UsReTxBufWrRunningAddr;
int32 gl_UsReTxBufEndAddr;
int32 gpla_ReTxWrPtrTable[3];
uint32 gul_retransmitted_delta;
int32 gl_TxAbsoluteDTUCount;
uint32 gul_RRC_data;
//XDSLRTFW-3101 (Start_End)
uint16 gus_RRC_BadCW; //Counter for bad DS RRC code word

FlagT gft_RetransmitReq;
uint8 guca_DTU_Status[3];
uint8 guc_TS_Discard_Th;
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)

//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC(START)
uint8 guc_PrevAbsoluteDtuCountLsbs;
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC(End)
FlagT gft_StopNewDtu;
FlagT gft_UsReTxSraStopRrcEval; //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start_End)
FlagT gft_UsReTxSraTRansDetect;
uint8 guc_FirstQtxSymCnt;
uint8 guc_MaxDtuPerSymb;

//Moved from gdata.c to make space in MAIN_BULK memory section
#ifdef VECTORING_MEM_LYT
//DsPSDDescriptorTable_t gt_MaxDsPSDDescriptorTableCMV;
//UsPSDDescriptorTable_t gt_MaxUsPSDDescriptorTableCMV;
//UsPSDDescriptorTable_t gt_RefUsPSDDescriptorTableCMV;
//UPBOPSDDescriptorTable_t gt_UPBOPSDDescriptorTable;

DsRefPSDDescriptorTable_t gt_DsREFPSDDescriptorTable;
UsPSDDescriptorTable_t    gt_UsREFPSDDescriptorTable;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
DsVnPSDDescriptorTable_t    gt_DS_RefVirtNoiseLevel_VDSL2; // Field16 of O-SIG
UsVnPSDDescriptorTable_t    gt_US_RefVirtNoiseLevel_VDSL2; // Field18 of O-SIG

uint16 gus_RxToneTobeCranched; // current tone to be crunched to calculate showtime ERB
uint16 gus_ErbByteCounter; // Octet counter in final ERB data used for maintaining gpuca_StErbBuffer

int8 gc_FormErbInShowtimeState; // state variable used in ShowtimeErbHandler() FG function
uint8 guc_G9935_CurrentVectorredBand; //current vectord band crunched by ShowtimeErbHandler()
uint8 guc_CurrentBitPositionInByte; // current bit position in byte used for populating gpuca_StErbBuffer

uint8 guc_G9935_NumBands;  // number of Vectored band
uint8 guc_Padding; // ERB padding
uint8 guc_FBlock; // ERB F_block
volatile uint8 guc_EOC_ERB_TRANSMISSION_STATE; // 0: ERBs are turned off, 1: ERBs are turned on

//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory
// these 4 variables store Table8-5/G993.5 parametes according to FW internal interpolation
uint16 gusa_Fsub[8];
uint16 gusa_Lw[8];
uint16 gusa_Bmin[8];
uint16 gusa_Bmax[8];

// XDSLRTFW-3507 (Start)
//ERBParams_t gt_ShowtimeErbParams;  // This variable stored the ERB parameters from the current  OHC Error Feedback request
ERBParams_t gt_PrevErbParams;      // This variable stored the ERB parameters from the previous OHC Error Feedback request (only ERB enable message i.e. m=1)
uint16 gus_ERB_Params_Changed;  // Result of the comparison between previous ERB request message (enable) and current ERB request message (enable)
// XDSLRTFW-3507 (End)

//L2_Back_Channel
// XDSLRTFW-3492 (Start)
DSM_Stats_t gt_DsmStats;
uint16 gus_NumofSymbols_ERB_Computation;
uint16 gus_TotalNumofSymbols_ERB;
// XDSLRTFW-3492 (End)

FlagT gft_BlockSRA;
uint8 guc_SraReject;
MacFrameConfigure_t gt_MacFrameConfigure;

//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (Start)
int32 gla_AvgFGainLinSqInitTrain[MAX_NUM_RX_BANDS];   //Sum of fine gain linear square of each band computed
int32 gla_AvgFGainLinInitTrain[MAX_NUM_RX_BANDS];  //Sum of fine gain linear square of each band computed
int32 gla_AvgFGaindBInitTrain[MAX_NUM_RX_BANDS];   //Sum of fine gain linear square of each band computed
int32 gla_AvgFGainLinSqRefTrain[MAX_NUM_RX_BANDS];
int32 gla_SumFGainLinSq[MAX_NUM_RX_BANDS]; // Sum of fine gain linear square of each band
int32 gla_AvgFGainLinSqInit[MAX_NUM_RX_BANDS];  //Sum of fine gain linear square of each band computed

//during the initialization

//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (End)
int16 gs_RFIBand;                 //number of minima found
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
int16 gs_TxAfeFilter;           //AFE ADSL Filter Mode Settings
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
RxToneFlags guca_RxSupportedToneSet_Aelem;   // One-bit-per-tone array. It includes all tones within the Band Limits [Generated from Rx Band Left and Right Channel].
                                             // This buffer should not exclude tones for RFI bands, blackout bands and pilot tones as the RFI Bands are interpolated,
                                             // while calculating HLOG.

//int16 gsa_PsdAnalysis_out[RX_MAX_NUM_TONES];
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
#endif

//XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH
int16 gs_ChangeTxBand ;
//XDSLRTFW-1836 : Identify the wrong MaxNomPSD Values Calulated
int16 gs_SaveRxNumBands;
int16 gs_PrevFirstToneLastBand;
//XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH

#ifdef DEBUG_TRAIL
// Structures to provide CMV control/status of Debug Trails
DebugTrailControl_t gt_debugTrailControl;
DebugTrailStatus_t gt_debugTrailStatus;
#endif // DEBUG_TRAIL

// Structures to provide CMV control and filter of Debug Streams
DebugStreamControl_t gt_debugStreamControl;
DebugStreamConfigure_t gt_debugStreamConfigure;


//XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt(START)
//memory overlay of Training only Buffers to ILV/DILV memory
DATA_ILV_DILV_TRAINING_ONLY_BEGIN
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
//Memory Overlay: Re-used this bufer to store SNR with out virtual noise during LDM in channel Ananlysis phase. XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization
int16 gsa_ELE_Tmp[RX_MAX_NUM_TONES];
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

// Qln/Holg temp arrays
uint8 guca_QLN_tmp[1024];

int16 gsa_PsdPerTone[RX_MAX_NUM_TONES];
//int16 gs_StreamComp[4096];

#ifdef VECTORING_MEM_LYT
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
int16 gsa_PsdAnalysis_out[RX_MAX_NUM_TONES];
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
#endif
// XDSLRTFW-3344 (Start)
int16 gsa_RxHLog_PerTone_Internal[RX_MAX_NUM_TONES];
uint8 guca_QLN_PerTone_Internal[RX_MAX_NUM_TONES];
int16 gs_QlnHlogCorrection;
int32 gl_RxPathTotalGain;
// XDSLRTFW-3344 (End)
DATA_MAP_END;
//XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt(END)
RT_DebugTiming_t *gpt_DebugTiming;
RT_DebugTiming_t gt_DebugTiming;
int32 gl_SumShowtimeSNR;  // Showtime ATTNDRds updating
uint32 gul_ATTNDR;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
uint8 guc_attndr_method;
FlagT gft_EnterL3State;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)
//XDSLRTFW-955 : To Accomadate the New Variable entry in G997
// Move few parameters to One Port Memory
// All of these are Initialized over Power Up
FlagT  gft_ReInitTrigger;
uint8 guc_seftrPrecFollowing;
uint8 guc_EftrLtETRby2OverObsPeriod;
//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory
//XDSLRTFW-1285 (start)
uint16 gus_attndr_REIN_INP_FE;
uint16 gus_attndr_SHINE_INP_FE;
uint16 gus_attndr_delay_FE;
//XDSLRTFW-1285 (end)
int16 gsa_TxBandLeftChannel[MAX_NUM_TX_BANDS];
int16 gsa_TxBandRightChannel[MAX_NUM_TX_BANDS];
int16 gs_NumOfTxBands;
int16 gsa_RxBandLeftChannel[MAX_NUM_RX_BANDS];
int16 gsa_RxBandRightChannel[MAX_NUM_RX_BANDS];
int16 gsa_BitloadLeftChannel[MAX_NUM_RX_BANDS];
int16 gsa_BitloadRightChannel[MAX_NUM_RX_BANDS];
int16 gs_NumOfRxBands;
uint16 gus_RpOpt_Attndr;
uint32 gul_ATTNDR_max_delay_octets;

//XDSLRTFW-1522 (Start)
uint32 gul_ATTNDR_M0_ChCapacityBased;
uint32 gul_RTmemMax;
//XDSLRTFW-1522 (End)

//XDSLRTFW-955 : To Accomadate the New Variable entry in G997

DATA_LOCAL_LD_ST_BEGIN
// XDSLRTFW-1958 (Start)
uint32 gul_StoreExceptionCode;
uint8 guc_InitSuccessFailCode;
// XDSLRTFW-1958 (End);

// XDSLRTFW-650 / XDSLRTFW-1384 (Start)
uint8 guc_PM_L3_InternalState;   //Global variable for PM L3 State Machine
uint8 guc_PM_L3_Response;       //Global variable for PM L3 State Machine
// XDSLRTFW-650 / XDSLRTFW-1384 (End)

// XDSLRTFW-1479 (Start)
DataPathFailures_t gt_DataPathFailures;
// XDSLRTFW-1479 (End)

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
ConfigVar_Improved_ATTNDR_t gt_DbgImprovedATTNDR;
Improved_ATTNDR_ActParam_t gt_Improved_ATTNDR_ActParam;
uint8 guc_ATTNDR_INP_Act_FE;
uint8 guc_ATTNDR_Delay_Act_FE;
uint8 guc_attndr_method_from_co;

FlagT gft_EnableImprovedATTNDR;
FlagT gft_CalcAttndr;
FlagT gft_ATTNDR_FrameGenFail;
FlagT gft_TestParam_Req;
// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)
DATA_MAP_END; //DATA_LOCAL_LD_ST_BEGIN

//XDSLRTFW-2509 Start Allow up to 180 degree Phase Error in VDSL code (instead of up to 45deg with phase-derotation)
FlagT gft_CTRL_EnablePLL;

//PLL Frquency Offset history
int16 gsa_pll_freq_offset_ppm_q4[32]; //12.4
int16 gs_PllRunningIndex;

//PLL Phase Offset history
PllPhaseRotInfo_t gta_PllPhaseRotInfo[20];
int16 gs_Last_Reported_Phase_Error   = 0;
int16 gs_SectorIdx_PhaseError   = 0;
int16 gs_Prev_SectorIdx_PhaseError  = 0;
int16 gs_NumOfIdenticalAdjacentPTPhases = 0;
int16 gs_MinNumberOfAdjPhaseErrorsToDeclareNewPhase = 1;
uint16 gus_PhaseErrorReporting_Idx = 0;
//XDSLRTFW-2509 End

//XDSLRTFW-1800 : 1K memory allocated for US FDPS data
// XDSLRTFW-1696 (start)
// FDPS variables
uint8 guca_FDPS1[8][64];
uint8 guca_FDPS2[8][64];
uint8 *gpuca_FDPSActive;
uint8 *gpuca_FDPSInActive;
uint8 guca_IndexIndependentPSActive[8];
uint8 guca_IndexIndependentPSInActive[8];
uint8 guca_CyclicalShiftOfSeqActive[8];
uint8 guca_CyclicalShiftOfSeqInActive[8];
uint8 guc_SignOfSeqActive;
uint8 guc_SignOfSeqInActive;
uint8 guc_NoOfAdditionalIPSActive;
uint8 guc_NoOfAdditionalIPSInActive;
uint16 gus_PSChangeReq;
uint16 gus_PSChangePerf;
//XDSLRTFW-1800 (end)


//XDSLRTFW-2302 End
// XDSLRTFW-1622 (Start_End)
RtxDbgCapture_t gt_RtxDbgCapture;
#ifndef STANDALONE_FRAMING_TEST
DATA_NOISE_MRGN_SEP_BEGIN
#endif
// !!!! note: This buffer is used as a Temporary buffer in 35Blite mode, and is used across Training and Showtime!!!!
// For all other VDSL modes, this buffer contain NMS coefficents and is used for estimating Showtime SNR.
uint8 guca_NMS[RX_MAX_NUM_TONES];
DATA_MAP_END;

DATA_BULK_DATA2_BEGIN
//int16 gsa_dbg_StateTrail[3072*2];
uint8 guca_erb_ping_pong_buffer[1056];
int16 gsa_RxHlog_DS[512];
#ifdef ENABLE_RETX_DS_DEBUG
uint8 guca_RetxDebugBuffer[12*1024];
#endif

//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(Start)
#ifdef BS_INSIDE_DEBUG
// !!!Before enabling this code section please make sure the availability of the memory!!!
int16 gsa_PerToneMargin[4*1024] = {0};
int16 gsa_BSDebugBuf[1200];
int16 gs_DSDebugBufCnt;
#endif
//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(End)

DATA_MAP_END;
//VR9, VRX318 use main bulk data memory for "guca_RxBitswapToneSet" and "guca_RxSupportedToneSet" &
//For VRX518 use one port data memory defined in the file "Vr9_1port_debug_data.c"
RxToneFlags guca_RxBitswapToneSet;     // One-bit-per-tone array used to indicate which tones
                                       // have been changed when reallocating bits for a
                                       // bitswap or OLR.

RxToneFlags guca_RxSupportedToneSet;   // One-bit-per-tone array used to indicate which tones
                                       // may be bitloaded. Specifically, indicates the tones
                                       // that are transmitted by far end (ie. tones in Rx Band Plan)
                                       // minus the pilot tone (incase of CPE), blackout tones and minus the RFI band tones.
TxToneFlags guca_TxSupportedToneSet;   // One-bit-per-tone array used to indicate which tones ...

// XDSLRTFW-2368 (Start)
#ifdef DEBUG_TRACES //DebugBufferTrace
#ifndef STANDALONE_FRAMING_TEST
DATA_DEBUG_TRACES_BUFFER_BEGIN
#endif
DebugBuffer_t gt_DebugBuff;
DATA_MAP_END;
#endif
// XDSLRTFW-2368 (End)
