/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: cmv_Data.c
*
*   This file contains global variables associated with cmv.c.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "mtkernel.h"
#include "states.h"
#include "cmv.h"
#include "cmv_data.h"
#include "data_alloc.h"

//------------------------------------------------------------------------------------
// CNTL
//------------------------------------------------------------------------------------
int16 CNTLArray[CNTLARRAY_SIZE];
int16 gs_prev_CNTL00;   // previous copy of CNTL 0 0 CMV value

//------------------------------------------------------------------------------------
// STAT
//------------------------------------------------------------------------------------
// CMV block name array pointers
int16 STATArray[STATARRAY_SIZE];       // STAT element 0 and 5, are now indirect CMVs.

int16 gsa_IndirectStat0[STAT_0_SIZE];
int16 *STAT_0_Map[1];

int16 gsa_Stat1_Mode[STAT_1_SIZE];
int16 *STAT_1_Map[1];

int16 *STAT_5_Map[1];

//------------------------------------------------------------------------------------
// INFO
//------------------------------------------------------------------------------------
int16 *INFOMap[INFOMAP_SIZE];
int16 *INFO2Map[INFO2MAP_SIZE];

//------------------------------------------------------------------------------------
// RATE
//------------------------------------------------------------------------------------
int16 *RATEMap[RATEMAP_SIZE];
RateInfo_t t_USRateInfo;
RateInfo_t t_DSRateInfo;

//------------------------------------------------------------------------------------
// TEST
//------------------------------------------------------------------------------------
int16 TESTArray[TESTARRAY_SIZE];

// TEST element 25 now indirect CMV.
int16 *TEST_25_Map[1];

//------------------------------------------------------------------------------------
// OPTN
//------------------------------------------------------------------------------------

int16 OPTNArray[OPTNARRAY_SIZE];   // OPTN elements 0, 2 and 4 are now indirect CMVs.

int16 gsa_Optn0_ModeControl[OPTN_0_SIZE];
int16 *OPTN_0_Map[1];

int16 gsa_Optn2_AlgControl[OPTN_2_SIZE];
int16 *OPTN_2_Map[1];

int16 gsa_Optn4_FilterControl[OPTN_4_SIZE];
int16 *OPTN_4_Map[1];

int16 *OPTN_28_Map[1];
int16 *OPTN_29_Map[1];

//------------------------------------------------------------------------------------
// PLAM
//------------------------------------------------------------------------------------

int16 *PLAMMap[PLAMMAP_SIZE];


//------------------------------------------------------------------------------------
// CNFG
//------------------------------------------------------------------------------------

int16 *CNFGMap[CNFGMAP_SIZE];


int16 gsa_Cnfg_Misc[CNFG_MISC_SIZE];


//------------------------------------------------------------------------------------
// CNTR
//------------------------------------------------------------------------------------

int16 *CNTRMap[CNTRMAP_SIZE];


//------------------------------------------------------------------------------------
// ALGS
//------------------------------------------------------------------------------------
int16 *ALGSMap[ALGSMAP_SIZE];


//------------------------------------------------------------------------------------
// SELT
//------------------------------------------------------------------------------------
int16 *SELTMap[SELTMAP_SIZE];

//------------------------------------------------------------------------------------
// DSL
//------------------------------------------------------------------------------------
int16 *DSLMap[DSLMAP_SIZE];
int16 *DSL_4_Map[1];  //XDSLRTFW-3705 (Start_End)

//------------------------------------------------------------------------------------
// Modem Monitor Control
//------------------------------------------------------------------------------------
int16 *MONIMap[MONIMAP_SIZE];
// XDSLRTFW-3647 (Start)
// Earlier there was only 1 paramter of length 16 bits for MONI 0. But now we have 2 paramters
// in MONI 0. The second parameter supports the POWER DOWN bit facilitates the sending of
// autonomous message. Hence, increased the size by 1.
uint16 gusa_MONI_ModemStat[2];         // currently this is initialized to 0x0 by compiler.
// it will not be re-init upon "sw reset" so that
// ME doesn't have to reconfig it.
uint16 gusa_MONI_ModemStat_Status[2];
uint32 gul_Pre_MONI_ModemStat_Status;
// XDSLRTFW-3647 (End)

int16 gs_MONI_LineFailure_NE;
int16 gs_MONI_LineFailure_FE;

int16 gs_MONI_AutoRestart;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
int16 gsa_MONI_ShowFailure_NE[2];
int16 gs_MONI_ShowFailure_FE;

FEReadTrigger_t gt_MONI_FEReadTrigger; // Trigger for retrieval of FE data

// Trigger, control and status for Clear-Eoc Msgs
ClearEocTrigger_t gt_MONI_CEocTrigger;
ClearEocAutoMsgControl_t gt_MONI_CEocAutoMsgCtrl;
ClearEocStatus_t gt_MONI_CEocStat;

// Control and Status for Tx/Rx Corrupt CRC Eoc Msgs
CorruptCRCControl_t gt_MONI_CrptCRCCtrl;
CorruptCRCStatus_t gt_MONI_CrptCRCStat;

// Control and Status for Eoc Get/Set Time Commands
TimeSyncControl_t gt_MONI_TimeSyncCtrl;
TimeStatus_t gt_TimeStat;


int16 gs_MONI_US_OLREventMask;
int16 gs_MONI_DS_OLREventMask;

//------------------------------------------------------------------------------------
// Autonomous Messaging Structures
//
//  A AutoMsgPayLoadEntry_t structure is created for for each type of Autonomous message.
//  The structure contains (1) a pointer to the message payload, (2) the payload length,
//  and (3) a PaylLoadSent indicator to prevent overwriting.
//  The structure is as follows:
//
//   typedef struct {
//      uint16 *pus_PayLoad;            // should point to global payload which should
//      uint8 uc_PayLoadLength;            // exist until msg is actually sent out.
//      uint8 uc_PayLoadSent;
//   } AutoMsgPayLoadEntry_t;
//------------------------------------------------------------------------------------

AutoMsgPayLoadEntry_t gt_ModemReadyPayLoad;
uint16 gus_BootupResultCode;
AutoMsgPayLoadEntry_t gt_ModemStatPayLoad;
AutoMsgPayLoadEntry_t gt_ModemStatFailPayLoad;
int16 gsa_PrevStat[STAT_0_SIZE];              // previous copy of gsa_IndirectStat0
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
AutoMsgPayLoadEntry_t gt_LineFailureNEPayLoad;
int16 gsa_prev_g997_Failure_Flag_NE[2];   // previous copy of gs_g997_Failure_Flag_NE

AutoMsgPayLoadEntry_t gt_LineFailureFEPayLoad;
int16 gs_prev_g997_Failure_Flag_FE;   // previous copy of gs_g997_Failure_Flag_FE

AutoMsgPayLoadEntry_t gt_Tr1RolloverPayLoad;
int16 gs_Tr1RolloverPayload;
FlagT gft_Tr1RolloverFlag;

AutoMsgPayLoadEntry_t gt_Tr1AlarmPayLoad;
FlagT gft_SendTr1AlarmFlag;

AutoMsgPayLoadEntry_t gt_FEDataPayload;
FlagT gft_SendFEDataFlag;

AutoMsgPayLoadEntry_t gt_CEocStatPayload;
FlagT gft_SendCEocStatFlag;

AutoMsgPayLoadEntry_t gt_CEocMsgPayload;
FlagT gft_SendCEocMsgFlag;

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
AutoMsgPayLoadEntry_t gt_ShowDSEventsPayload;
FlagT gft_SendDSShowEventsFlag;

AutoMsgPayLoadEntry_t gt_ShowUSEventsPayload;
FlagT gft_SendUSShowEventsFlag;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

//L2_Back_Channel
AutoMsgPayLoadEntry_t gt_ErbEvtPayload;
FlagT gft_SendErbEventFlag;

// Bonding and TC information
AutoMsgPayLoadEntry_t gt_Bonding_TC;
FlagT gft_autonomous_msg_flag;
FlagT gft_bonding_TC_autonomous_sent;

uint16 gus_DsmCtrlCmv;
MoniErbMsg_t gt_MONI_ErbMsg;

FlagT gft_SendTimeSyncMsgFlag;

int16 gs_AutoMsgHandlerState;
int16 gs_ModemMonitorState;
int16 gs_ModemMonitorCount;
// end of Modem Monitor Control


int16 gs_ModemOperationRequired = 0;
int16 gs_ModemOperationRequiredShadow = 0;
int16 gs_MpWinhostControl = 1;

HMP_DebugStreamMsg_t gt_DebugStreamMsg;
