/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   FIFO.C
 *
 *   Generic Routines and data structures to handle fifos of
 *   Functions, such as for the Background Task Handler
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "fifo.h"
#include "gdata.h"
#include "vdsl_xception.h"
#include "states.h"
#include "LL_IOf.h"
#include "dsp_op.h"

// Use only for background function fifo.
int16 AddFunctionToBkgdFifo(PtrToFunc Function)
{
   uint32 ul_int_status;
   FunctionFifo_t *fifo;
   int16 tmp;

   if (Function == 0 )
   {
      return(0);
   }

   // since this function can be called from time-critical (TC) task,
   // we do not want to accidentally enable interrupt in the middle of TC
   disable1_save(&ul_int_status);

   fifo = gp_BGTaskFifo;

   if (fifo->FunctionBuffer[fifo->NextAvailable] != 0)   /* we have run out of space */
   {
      KernelException(E_CODE_BKGD_FIFO_ADD_EXCEPTION);
      tmp = 0;
   }
   else
   {
      fifo->FunctionBuffer[fifo->NextAvailable] = Function;
      fifo->NextAvailable++;
      fifo->PendingFunctionCount++;
      if (fifo->NextAvailable==fifo->BufferSize)
      {
         fifo->NextAvailable=0;
      }
      tmp = 1;
   }

   restore1_save(ul_int_status);

   return(tmp);
}

/* returns a 1 if there is a Function, returns a 0 if fifo is empty */
// Use only for background function fifo.
int16 RemoveFunctionFromBkgdFifo(FunctionFifo_t *fifo, PtrToFunc *p_Function)
{
   uint32 ul_int_status;
   int16 tmp;

   disable1_save(&ul_int_status);

   if (fifo->FunctionBuffer[fifo->IndexOfOldest] == 0)
   {
      tmp = 0;
   }
   else
   {
      *p_Function=fifo->FunctionBuffer[fifo->IndexOfOldest];
      fifo->FunctionBuffer[fifo->IndexOfOldest] = 0;  /* make this one null */
      fifo->IndexOfOldest++;
      fifo->PendingFunctionCount--;
      if (fifo->IndexOfOldest==fifo->BufferSize)
      {
         fifo->IndexOfOldest=0;
      }
      tmp = 1;
   }

   restore1_save(ul_int_status);

   return(tmp);
}


// Use only for loading function fifo.
void AddFunctionToFifo(LoadingFunctionFifo fifo, LoadingFunction Function)
{
   uint32 ul_int_status;
   // fifo[0] contains number of valid entries in fifo[].
   // Valid entries start at index 1, i.e. fifo[1].
   int16 s_ValidEntries;

   // Prevent TX FG to load RX functions and vice versa.
   if ( ((gs_FGStateID == TX_FOREGROUND_STATE) && ((fifo == gp_RxLoadingFunctionFifo) || (fifo == gp_RxLoadingFunctionFifo_FC))) ||
         ((gs_FGStateID == RX_FOREGROUND_STATE) && (fifo == gp_TxLoadingFunctionFifo)) )
   {
      KernelException(E_CODE_WRONG_LOADING_FUNCTION_FIFO);
   }

   disable1_save(&ul_int_status);

   s_ValidEntries = (int16) fifo[0];
   if (s_ValidEntries+1 > LOADING_FUNCTION_FIFO_SIZE)
   {


      KernelException(E_CODE_LOADFUNC_FIFO_OVERFLOW);
   }
   else
   {
      s_ValidEntries++;
      fifo[0] = (PtrToLoadingFunction) s_ValidEntries;
      fifo[s_ValidEntries] = Function;
   }

   restore1_save(ul_int_status);
}

// Use only for loading function fifo.
void ExecuteQueuedLoadingFunctions(LoadingFunctionFifo fifo)
{
   // Removes all loading functions from the fifo and executes
   // them.  This function must not be interrupted by calls to
   // AddFunctionToFifo().

   // fifo[0] contains number of valid entries in fifo[].
   // Valid entries start at index 1, i.e. fifo[1].

   int16 i, s_ValidEntries;
   s_ValidEntries = (int16) fifo[0];

   for (i=1 ; i<=s_ValidEntries ; i++)
   {
      (fifo[i])();
   }

   fifo[0] = (PtrToLoadingFunction) 0;      // Reset count.
}
