/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gdata.c
*
*   This file contains global variable declarations.
*
*-------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// gdata.c
//
// History
//
// 16/05/2012 Vinjam: Enabling/Disabling Downstream Virtual Noise feature control is moved from CMV MONI 4 to
//            CMV DSL 0, as per VR9 Message Specifications (1.6.1). Also contains code pointers connected to
//            Down stream virtual noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
// 10/07/2012 Vinjam: Added a buffer to store actual Show time SNR with out virtual noise.
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//            Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//            Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
// 19/12/2012 Abu: FAST Loss detection in training (vectoring mode)
//            Grep XDSLRTFW-645 / XDSLRTFW-674
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//            Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//            Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
// 15/01/2013 Kannan: Added variable for CMV to control AFE init fail indication.
//            Grep for: "XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication"
// 01/02/2013 Kannan: Global variable declaration for PDBRAM handover and Orderly shutdown
//            Grep for: "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
// 18/02/2013 Hanyu: Added code to update VDSL2 DS Attainable Net Data Rate (ATTNDRds) in Showtime.
//            grep for: XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update
// 14/02/2013 Vinjam : Resolved memory corruption by relocating the guca_SNRBuf_NE[ ] to "ONE_PORT_SHOW_ONLY_DATA" section.
//            Grep for XDSLRTFW-726 Bug_All_VDSL2_All_MemoryCorruption
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//            Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//            Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//            Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
// 29/05/2013 Vinjam: Removed global variable gt_Bonding_DiscAggr_ControlCMV as it is redundant
//            Code changes are done for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (valid for VDSL2 & ADSL2)
// 05/07/2013 Varun: Added variable to update the imestamp in ReTx mode
//            Grep for "XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx"
// 19/07/2013 Kannan: added variavle to enable UsReTx and Tx Data pump setup debug
//            Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//            Grep for XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts
// 19/09/2013 Fuss: Addded code for vectoring to use only two different hybrid settings.
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
// 19/09/2013 Abu: Added code(Debug option) to check if the upstream rate gets improved
//            Grep for XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate
// 19/09/2013 Fuss: Global timeout clean-up for vectoring
//            Grep for XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts
// 10/10/2013 Fuss: Use "Pre-failstate" to pause FW for data-collection
//            Grep for XDSLRTFW-1218 Bugfix_ALL_VDSL2_ALL_DataCollect
// 18/12/2013 Kannan: Added variable for 5 secs shine noise test to enable/disable the FDQ
//            Grep for XDSLRTFW-1104
// 03/01/2014 Anantha Ramu: Added variables gsa_PllRefTone_unscale, gsa_PllRefTone_scale
//            Grep for XDSLRTFW-1271 DSReTx_uncorrected_DTUs_PLL_changes
// 16/01/2014 Abu: Added two pointers and change two variable names to implement ping-pong
//            buffers for Up stream pilot sequence update in showtme via EOC message.
//              Grep for XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS
// 28/01/2014 Fuss: Added fix to reach 2800m noise free
//            Grep XDSLRTFW-1506: No sync in vectoring mode on loops >1600m (US0 only).
// 11/08/2014 Fuss: R7 image (BT IOP bit set) has lower perf in US compared to VR9FB
//            Grep for XDSLRTFW-1841
//
// 30/10/2014 Anantha Ramu: Added variables for Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-1617"
//
// 24/09/2015 Vinay: Added variable for G.Fast capability in G.Hs session
//                   Grep for XDSLRTFW-2298
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//    The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//    The internal split is not well-balanced for the wished service rates.
//    According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//    According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//    framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//    D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//    1-symbol reduction in Qtx,min calculation:
//    It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//    the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//    occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it's not needed to take into account the
//    +1 symbol in the Qtx,min calculation.
//    If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//    For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//    the left triangle part.
//    If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//    is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//    shown in the drawings before the triangle.
//    So from the figures it could be derived:
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//    But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//    Grep for : XDSLRTFW-2858
// 07/12/2016 XDSLRTFW-3015 SHINE protection lower than reported : it is a PLL issue!
//            i. Pilot tone phase error saturation value while external noise detected was 1 degree.
//               When long SHINE noise comes, sometime it deviated the pilot tone phase in a way that
//               SHINE noise pulse appeared longer in Rx Path than the original SHINE pulse. As a result,
//               in some corner cases ( eg. SHINE protection 58 DMT symbol, SHINE noise 56 DMT symbol),
//               SHINE protection did not work well. To solved this issue, new pilot tone phase saturation values are introduced.
//
//           ii a. On very short loops, with low power SHINE pulses ( eg. 10 dB more than the background  noise),
//                 external noise detection threshold was not optimum.
//           ii b. On very long loops, where the DS data rates are < 5Mbps and Max Erasure Metric in Showtime is around 10, fixed threshold
//                 for noise detection logic may lead false external noise detection in case of margin verification test.
//                 To solve this issue, new noise detection threshold logic is introduced.
//
//              Grep for: XDSLRTFW-3015
//
// 18/09/2013 Hanyu: IOP fixes against EVLT-F/CNXT in A8D profile
//   1. IOP adjustment to reduce estimated KL0 from loop length ~2800ft to ~3800ft to connect to showtime.
//   2. Switched to US0 band if KL0 is greater than 25.8dB (~3700ft) to fix the no sync issue.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft
//
//   3. Added 0.6dB to final KL0 to reduce UPBO and boost US power by ~0.5dB to get comparable US data rate with BRCM CPE.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 10/10/2017 Abu Rahman
// XDSLRTFW-3071: US & DS ATP reporting is swapped
//     Variables contains the DS ActATP and US ActATP were wrongly (swapped) populated.
//     - Fixed the variable initialization.
//     - Fixed variables population for DS ActATP and US ActATP
//     - Fixed HDLC messages relating to these variables both for Showtime and diag mode
//     - Changed two structure names
//       1. old name: gt_G997_NeSignalAndMarginParams, new name: gt_LineStatusDS
//
// 20/12/2017 Stefan Krause:  XDSLRTFW-3656 : Mips issue during ERB processing
// reduce the Mips load during ERB calculation
// - we need currently around 600 ARC cycles for ERB calculation of one tone
//    (using the typical ERB configuration of 16 bits/error, 6 bits for real/imag part, 4 bits for exponent)
// - this settings results in a Mips load of around 35k cycles
// - R4 tests have shown that this may already be too high - we may see once in a while linkdrops due to Mips issues.
// to reduce the Mips load the number of tones has been reduced to 26
// this should still be good enoug - even if the most critical fsub is selected by the VCE
// Examples:      Number of DS tones | fsub | Num of Errors/Symbol | Num of symbols needed for ERB calulation
//                -------------------+------+--------------------------------------------
//                              7000 |    4 |                   51 |       34
//                              7000 |    2 |                   51 |       69
//                -------------------+------+--------------------------------------------
//                              7000 |    4 |                   26 |       68
//                              7000 |    2 |                   26 |      135
//     Grep for XDSLRTFW-3656
//
// 20/12/2017 Stefan Krause:  XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
// - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
// - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
// - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
//     Grep for XDSLRTFW-3665
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
//    Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
//    tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// 4. Added  new Tx IIR filter for  ISI optimization
// 5. Upstream performance optimization is  controlled by cmv. TEST 49 BITMASK- 9. Enabled by default
// Grep for XDSLRTFW-232
//
//14/12/2018 Sriram Shastry :XDSLRTFW-4052 : Low upstream data rates in 30a profile
// improvement for Kl0 alogorithm estimation for  30a profile
//   Control option to use AELEM for reporting KL0
//   Control option to set  Kl0 in RMSG1
//   Control option to set AELEM method instead of  KL0 method
//   Control option to Enable/disble psdpreprocessing (inter polation)
//   Initialize AELEM structure (gt_AELEM_UPBOInfo)
//  Grep for XDSLRTFW-4052
// ************************************************************************************************************

#include "common.h"
#include "mtkernel.h"
#include "socmessage.h"
#include "HDLC.h"
#include "SnrFrameAlignHandler.h"
#include "voc.h"
#include "data_alloc.h"
#include "pll.h"
#include "states.h"
#include "afe.h"
#include "Snr_b.h"
#include "FrameAlign.h"
#include "hercules_memrymap.h"
#include "eoc.h"
#include "DecAdapt.h"
#include "codeswap.h"
#include "profile.h"
#include "DebugBuffer.h"
#include "Us_Rtx.h"
#include "DshInterface.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "cmv.h"

uint16 gus_MaxWaitCnt_TxQtDone = 1;
int16  gs_MaxWaitState_TxQtDone;
int32  gl_TxSymCnt_MaxWaitState_TxQtDone;

//XDSLRTFW-3901 (START)
//Issue
//(1) Some of the HW resources like Inactive BAT and fine gain tables are
//shared between DSP and QTP. When HW is accessing the tables, DSP is not
//allowed to access those tables. Rx QTP was starting at 46K cycles from
//Rx buffer swap event and is expected to run 17K cycles more, i.e Rx QTP
//shall run up to 63K cycles (46 + 17 = 63K).
//
//(2) DSP was configured to use Tx Timer done interrupt to run Tx TC task
//and is configured to raise the interrupt at 43K cycles from Tx buffer
//swap event. Tx TC task is expected to run 7K cycles more, i.e Tx TC task
//may run up to 50K cycles (43 + 7 = 50K).
//
//(3) Starting of Tx TC task may be delayed in case if Rx NTC is not completed
//within the scheduled time and possibility that Rx QTP and Tx TC task
//may access the Inactive tables at the same time.
//Solution
//(1) Starting of Rx QTP is changed from 46K to 36K and and Tx Timer done interrupt
//is changed from 43K to 58K to avoid possible conflicts between Rx QTP and
//DSP (Tx TC task)
int32 gl_StartReqTxTimerInt = 58000;
//XDSLRTFW-3901 (END)

int32 gl_RxSymCnt_MaxWaitState_QtDone;
FlagT gft_SkipFirstRxTimerDoneInt;
uint16 gus_MaxWaitCnt_QtDone;
int16  gs_MaxWaitState_QtDone;
int32 gl_StartReqRxTimerInt = 21000;
uint32 gul_TxRRC_corrupted_Cnt;
uint32 gul_ReadRRC_TxPMS_Conflict_Cnt;

//XDSLRTFW-3493(Start)
uint32 gula_LpMin[HQV_MAX_ROWS];
uint32 gula_LpMax[HQV_MAX_ROWS];
HQV_ETRu_t gt_HQV_ETRu[HQV_MAX_ROWS];
uint16 gusa_n_tones_per_Bi[MAX_BI_INDEX];
//% iDTU coding gains in dB as function of bi (column 1 for bi=1, column 2 for bi=2, ..., column 15 for bi=15), Ritlv value (column 16), Q value (column 17)
uint8 guca_CGv[15 * 15]=
{
    6,  7,  6,  6,  6,  6,  6,  5,  5,  4,  5,  5,  5,  5,  5, // 8  4
    9, 10,  9,  9,  9,  9,  9,  8,  8,  7,  8,  8,  8,  8,  8, // 8  8
   13, 14, 13, 13, 13, 13, 13, 12, 12, 11, 12, 12, 12, 12, 12, // 8  16
   14, 14, 13, 10,  8,  9,  8,  8,  8,  7,  8,  8,  9,  8,  8, // 10 4
   18, 18, 17, 14, 12, 13, 12, 12, 12, 11, 12, 12, 13, 12, 12, // 10 8
   18, 20, 19, 17, 15, 16, 15, 15, 15, 14, 15, 15, 16, 15, 15, // 10 16
   20, 21, 19, 16, 13, 14, 13, 12, 12, 11, 12, 12, 13, 12, 12, // 12 4
   20, 23, 22, 20, 18, 19, 18, 17, 17, 16, 17, 17, 18, 17, 17, // 12 8
   20, 23, 22, 20, 19, 20, 19, 18, 18, 17, 18, 18, 19, 18, 18, // 12 16
   22, 24, 23, 19, 17, 17, 16, 14, 14, 13, 13, 14, 14, 14, 14, // 14 4
   22, 24, 24, 22, 20, 20, 19, 17, 17, 16, 16, 17, 17, 17, 17, // 14 8
   22, 24, 24, 22, 22, 22, 21, 19, 19, 18, 18, 19, 19, 19, 19, // 14 16
   24, 26, 25, 22, 20, 20, 19, 17, 17, 16, 17, 17, 17, 17, 17, // 16 4
   24, 26, 25, 23, 23, 23, 22, 20, 20, 19, 20, 20, 20, 20, 20, // 16 8
   24, 26, 25, 23, 23, 23, 22, 20, 20, 19, 20, 20, 20, 20, 20  // 16 16
};
//XDSLRTFW-3590(Start)
//Use R as 8 for iDTU profiles <=17a and 35B.
uint8 guc_DS_ReTx_iDTU_R = 8;
//XDSLRTFW-3590(End)
//uint32 gul_dbg_ul_LpAvailable_In  = 0;
//uint32 gul_dbg_ul_LpAvailable_New = 0;
//XDSLRTFW-3493(End)

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
//Cascaded mode: Showtime only Mips count
CasFwTasksMips_t gt_CasFwTasksMipsCnt;
uint32 gul_MaxPllCycles;
//Cascaded mode: Training and Showtime Mips count to know overall Mips consumption
//in TC & NTC tasks.
CascadeMaxMipsCnt_t gt_CascadeTcNtcMaxMipsCnt[CASCADE_NUM_TC_NTC_FW_TASKS];
#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

//XDSLRTFW-3189 (Start)
int16  gs_MemSize_DsReTx_MinDtus_ReqOverQtx;
int16  gs_MemSize_UsReTx_Qtx_Overhead_R;
uint16 gus_MaxDTUSizeDS_iDTU;
uint16 gus_MaxDTUSizeUS_iDTU;
//XDSLRTFW-3189 (End)

int32 gl_TxTimer_TxTcStart;
int32 gl_TxTimer_MaxTxTc;
int32 gl_TxTimer_TxNTcStart;
int32 gl_TxTimer_MaxTxNTc;
int32 gl_TxQT_MaxTime = 0;
int32 gl_TxQT_MinTime = ((1 << 31) - 1); //Big Number
int32 gl_RxQT_MaxTime = 0;
int32 gl_RxQT_MinTime = ((1 << 31) - 1); //Big Number;

//debug
int32  gl_RxTimer_RxPMSStart = 0;
int32  gl_RxTimer_RxPMSDone = 0;
int32  gl_RxTimer_MaxRxPMSDone = 0;
int32  gl_TxTimer_MaxTxPMSDone = 0;
int32  gl_TxTimer_TxPMSDone = 0;
//uint16 gus_dbg_LogControl = 0;
int32  gl_RxTimer_MaxRxNTc = 0;
int32  gl_RxTimer_MaxRxTc = 0;
uint32 gul_RxQTP_NotDone = 0;
uint32 gul_RxTimer_RxQTDone;
uint32 gul_RxTimer_TxQTDone;
uint32 gul_TxTimer_TxQTDone;

uint16  gus_dbg_LowestMetric = 0;
uint16  gus_dbg_EnablePLL_Cnt = 0;
volatile int32   gl_RxSymbolCount_dbg = 0;
FlagT   gft_StopLog = 0;
int16   gs_dbg_LogContCount = 0;
int16   gs_dbg_ContLowMetricCounter = 0;
int16   gs_dbg_LowMetricThreshCount = 10;

uint32  gul_dbg_fec_count = 0;
int16   gs_dbg_QTMetricThresh = 255;

//#ifdef VRX518_LOG_DEBUG_INFO
uint32 *gpl_IriMetric = (uint32 *) 0x386468;
uint16 gus_dbg_LogControl = 0;
int16  gs_start_QTdone_Log = 0;
int16  gs_QTdone_LogIdx = 0;

//#endif
//int16  gs_dbg_OH_Frame_Idx = 0;
//int16  gs_start_QTdone_Log = 0;
//int16  gs_QTdone_LogIdx = 0;
//uint8 *gpuc_QT_Done   = (uint8 *)   0xA2400;
//uint32 *gpul_QT_Done  = (uint32 *)  0xA2400;

//int16 gs_Prev_RxState = -2;
//int16 gs_RxState_dbg = -1;
//int16 gs_RxSubState_dbg = -1;
//int16 gs_dbg_ToneTrack_Idx = 1500;
//FlagT gft_start_capture_tone = 0;
#ifdef VRX518_BRINGUP_DEBUG
uint32  gul_dbg_LogControl = 0;
uint32  gul_dbg_LogControl_Status = 0;
uint8 *gpuca_StVectoringBuffer;
#endif

DATA_LOCAL_LD_ST_BEGIN
//XDSLRTFW-2392 (Cascaded scheduling - Start)
// Note: All variables must be initalized to zero!
uint8  guc_CasMode_enable;
uint8  guc_Start_CasMode_Int;
int16  gs_dbg_DelayRxPms;
uint32 gul_RxTimer_FftStart;
uint32 gul_RxTimer_FftStop;
int32 gl_RxTimer_RxTcStart;
int32 gl_RxTimer_RxNTcStart;
//XDSLRTFW-2392 (Cascaded scheduling - End)

uint16 gus_FgNestedCount;
DATA_MAP_END;

//XDSLRTFW-1784 (Showtime Margin Equalization - START)
uint8  guc_MarginEqualization_ExitCode = 0;
uint8  guc_GainSwapCntr = 0;
uint8  guc_dbg_bitswap_decision_1 = 0;
uint8  guc_dbg_bitswap_decision_2 = 0;

uint8  guc_dbg_bitswap_decision_3 = 0;
uint8  guc_slow_gainswap_cnt = 0;
uint8  guc_Save_RxGain_Mgn_dB = 0;

int16  gs_Margin_Hi_Prev = (int16) 0x8000;      // Largest negative number.
int16  gs_Margin_Lo_Prev = (int16) 0x7fff;      // Largest positive number.
//XDSLRTFW-1784 (Showtime Margin Equalization - END)

//uint16 gus_delay_snr_update = 0;
//XDSLRTFW-1617 (Start)
int16 gs_bad_dtu = 0;
uint32 gul_TX_LP1_UCODE_ADDR;
uint32 gul_RX_LP1_UCODE_ADDR;
uint32 gul_TX_LP1_UCODE_ADDR;
uint32 gl_ilvSize;
uint32 gl_ilvsize1;
//XDSLRTFW-1617 (End)

// ERB Handling in VRx518
FlagT gft_ERB_Compute_Data;
uint16 gus_ERB_DMA_STATE = 0;                      // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
FlagT gft_ERB_VBB_Header_Configure = TRUE;
FlagT gft_ERB_Main_Header_Configure = TRUE;
FlagT gft_ERB_Configure_DMA = FALSE;
FlagT gft_Trigger_DMA = FALSE;
FlagT gft_Compute_CRC = FALSE;
FlagT gft_Triggered_DMA = FALSE;
FlagT gft_ERB_Last_Segment = FALSE;
FlagT gft_ERB_Descriptor_Wraparound = FALSE;
FlagT gft_ERB_Segment_Done = FALSE;
FlagT gft_CRC_Computed = FALSE;
FlagT gft_ERB_Buffer_Selector = TRUE;  // TRUE --> ERB_PART0; FALSE --> ERB_PART1
uint8 guc_SegmentCode = 0;
uint8 guc_NumOfSegments;
uint8 guc_erb_descriptor_index = 0;
uint8 guc_erb_descriptor_index_Previous;
uint8 guc_ping_pong = 0;               // This is used to select the buffer for erb comptation (i.e, inline computation or the buffer in BULK_DATA2)
uint8 guc_owner_bit_set = 0;   // XDSLRTFW-3454: A counter to keep check of the number of owner bit getting set
uint16 gus_PPD_ByteCounter_For_Segment;         // number of PROTOCOL PAYLOAD DATA in current segment
uint16 gus_ErbByteCounter_Previous;
uint16 gus_ByteCounter_For_Reversing;
uint16 gus_Start_Addr_Reversing;
uint16 gsa_Header_Length[MAX_NUM_ERB_SEGMENTS];
// XDSLRTFW-3656 : Mips issue during ERB processing
// reduce the Mips load during ERB calculation
// - we need currently around 600 ARC cycles for ERB calculation of one tone
//    (using the typical ERB configuration of 16 bits/error, 6 bits for real/imag part, 4 bits for exponent)
// - this settings results in a Mips load of around 35k cycles
// - R4 tests have shown that this may already be too high - we may see once in a while linkdrops due to Mips issues.
// to reduce the Mips load the number of tones has been reduced to 26
// this should still be good enoug - even if the most critical fsub is selected by the VCE
// Examples:      Number of DS tones | fsub | Num of Errors/Symbol | Num of symbols needed for ERB calulation
//                -------------------+------+--------------------------------------------
//                              7000 |    4 |                   51 |       34
//                              7000 |    2 |                   51 |       69
//                -------------------+------+--------------------------------------------
//                              7000 |    4 |                   26 |       68
//                              7000 |    2 |                   26 |      135
uint16 gus_NumberOfErrorVectorsPerSymbol = 26;
uint32 gul_ERB_CRC;                    // This is the CRC generated by the Zephyr for ERB segments.
uint32 gul_DREG_ERB_Descriptor_Base;   // This contains the offset that needs to be used to get the location of ERB descriptor in BAR17
uint32 gul_DREG_ERB_Number;            // It describes the number of ERB descriptors.
ERBDescriptor gt_ERBDescriptor[MAX_NUM_ERB_SEGMENTS];
uint32 *gpul_ERB_Descriptor = NULL;
uint8 *gpuca_StErbBuffer_CRC = NULL;   // XDSLRTFW-3826 Start/End make pointer a global variable, otherwise is is used as uninitialized pointer in ShowtimeErbHandler()

// XDSLRTFW-2629 (Start)
FlagT gft_Mailbox_thru_SDRAM = FALSE;       // Flag to indicate if we request a SDRAM variable via mailbox
FlagT gft_XDMA_Mailbox_Busy = FALSE;        // XDMA busy when trying to use it for SDRAM access via mailbox
FlagT gft_Mailbox_XDMA_Triggered = FALSE;
int32 gl_Source_Address = 0;                // backup of source address
int32 gl_Dest_Address = 0;                  // backup of destination address
int16 gus_Length = 0;                       // backup of length
uint32 gul_XDMA_Busy_Cnt = 0;               // Counter if the XDMA is busy during attempt of usage within mailbox access to SDRAM
FlagT gft_Interrupt_Mailbox = FALSE;        // This flag is used to service Mailbox only once in cascaded mode
// XDSLRTFW-2629 (End)

// XDSLRTFW-3591 (Start_End)
uint8 guc_Showtime_Entered = 0;

// XDSLRTFW-3344 (Start_End)
FlagT gft_Swap_HLog_QLN_Offchip = FALSE;

// XDSLRTFW-3662 (Start)
uint16 gusa_PPA_FW[2];  // This information is provided/configured by host.
uint16 gusa_PPE_FW[2];  // This value is read out from DREG register DREG3
// XDSLRTFW-3662 (End)

//XDSLRTFW-2162 (Start)
uint16 gus_partial_DTU_bytes = 0;
uint16 gus_DTU_bytes;
FlagT gft_IDILV_DS_SRA_event = FALSE;
//XDSLRTFW-2162 (End)
//XDSLRTFW-2341 (Start)
FlagT gft_US_IDILV_ucode = FALSE;
FlagT gft_IDILV_US_SRA_event = FALSE;
//XDSLRTFW-2341 (End)
FlagT gft_PingPongDtb= TRUE;
FlagT gft_DisablePingPongDtb=FALSE;

#include "zep_memmap_cnfg.h"

// Only following combinations of G,T,M make sense due to the constraints, determined by a pre-calculation
int16 GTM[6*3] =
{
   16,    2,    2,
   20,    4,    4,
   24,    4,    4,
   28,    4,    4,
   32,    4,    2,
   32,    4,    4,
};

// following framings are the result of simulations for DTU sizes Q*H<=2048; column 4 is parameter A, column 5 the RTX overhead portion of DTU size in %
uint8 guca_HQV[HQV_NUM_ROW*HQV_NUM_COLUMN]=
{
   67,   1,   0,  // Idx = 0
   132,  1,   0,
   197,  1,   0,
   131,  2,   0,
   164,  2,   1,
   196,  2,   0,  // Idx = 5
   229,  2,   1,
   174,  3,   0,
   196,  3,   1,
   218,  3,   2,
   239,  3,   0,  // Idx = 10
   196,  4,   2,
   212,  4,   1,
   228,  4,   0,
   245,  4,   3,
   209,  5,   3,  // Idx = 15
   222,  5,   3,
   235,  5,   3,
   248,  5,   3,
   217,  6,   0,
   228,  6,   1,  // Idx = 20
   239,  6,   2,
   250,  6,   3,
   224,  7,   6,
   233,  7,   4,
   242,  7,   2,  // Idx = 25
   251,  7,   0,
   228,  8,   2,
   236,  8,   1,
   244,  8,   0,
   202,  10,  3,  // Idx = 30
   // Following additional framings are the result of simulations for DTU sizes Q*H<=3072;
   232,  9,  6,   // Idx = 31
   239,  9,  4,
   246,  9,   2,
   228,  10,  3,
   213,  11,  1,  // Idx = 35
   241,  10,  3,
   225,  11,  3,
   231,  11,  4,
   237,  11,  5,
   243,  11,  6,  // Idx = 40
   249,  11,  7,
   200,  14,  3,
   239,  12,  6,
   244,  12,  1,
   250,  12,  8,  // Idx = 45
   204,  15,  3,  // Idx = 46
   //Additional 16 entries for 35b
   223,  14,  0,  // Idx = 47
   228,  14,  5,
   217,  15,  3,
   237,  14,  1,  // Idx = 50
   242,  14,  6,
   230,  15,  3,
   251,  14,  2,
   239,  15,  8,
   243,  15,  3,  // Idx = 55
   232,  16,  5,
   236,  16,  4,
   240,  16,  3,
   244,  16,  2,
   248,  16,  1,  // Idx = 60
   224,  18,  0,
   238,  17,  14,
};

//XDSLRTFW-1617 (Start)
//Array of H, Q & V values for Intra DTU Interleaving, for CO supporting
//all values of depth 'D' (and hence Q)
uint8 guca_HQV_IDILV[HQV_IDILV_NUM_ROW*HQV_IDILV_NUM_COLUMN] =
{
   17,     4,     1,
   33,     4,     0,
   50,     4,     3,
   66,     4,     2,
   82,     4,     1,
   98,     4,     0,
   115,    4,     3,
   131,    4,     2,
   147,    4,     1,
   163,    4,     0,
   180,    4,     3,
   196,    4,     2,
   212,    4,     1,
   228,    4,     0,
   196,    5,     3,
   209,    5,     3,
   222,    5,     3,
   235,    5,     3,
   207,    6,     5,
   217,    6,     0,
   228,    6,     1,
   239,    6,     2,
   214,    7,     1,
   224,    7,     6,
   233,    7,     4,
   212,    8,     4,
   220,    8,     3,
   228,    8,     2,
   236,    8,     1,
   217,    9,     1,
   225,    9,     8,
   232,    9,     6,
   239,    9,     4,
   222,    10,    8,
   228,    10,    3,
   235,    10,    8,
   219,    11,    2,
   225,    11,    3,
   231,    11,    4,
   237,    11,    5,
   223,    12,    9,
   228,    12,    4,
   234,    12,    11,
   239,    12,    6,
   226,    13,    11,
   231,    13,    11,
   236,    13,    11,
   //Additional 15 entries for 35b
   223,    14,    0,
   228,    14,    5,
   233,    14,    10,
   237,    14,    1,
   226,    15,    8,
   230,    15,    3,
   235,    15,    13,
   239,    15,    8,
   228,    16,    6,
   232,    16,    5,
   236,    16,    4,
   226,    17,    5,
   230,    17,    8,
   234,    17,    11,
   238,    17,    14,
};

//Array of H, Q & V values for Intra DTU Interleaving, for CO supporting
//depth 'D' (and hence Q) that are powers of 2 only.
uint8 guca_HQV_IDILV_Pow2[HQV_IDILV_POW2_NUM_ROW*HQV_IDILV_POW2_NUM_COLUMN] =
{
   17,     4,     1,    // 0
   33,     4,     0,    // 1
   50,     4,     3,    // 2
   66,     4,     2,    // 3
   82,     4,     1,    // 4
   98,     4,     0,    // 5
   115,    4,     3,    // 6
   131,    4,     2,    // 7
   147,    4,     1,    // 8
   163,    4,     0,    // 9
   180,    4,     3,    // 10
   196,    4,     2,    // 11
   212,    4,     1,    // 12
   228,    4,     0,    // 13
   123,    8,     7,    // 14
   131,    8,     6,    // 15
   139,    8,     5,    // 16
   147,    8,     4,    // 17
   155,    8,     3,    // 18
   163,    8,     2,    // 19
   171,    8,     1,    // 20
   179,    8,     0,    // 21
   188,    8,     7,    // 22
   196,    8,     6,    // 23
   204,    8,     5,    // 24
   212,    8,     4,    // 25
   220,    8,     3,    // 26
   228,    8,     2,    // 27
   236,    8,     1,    // 28
   122,    16,    0,    // 29
   127,    16,    15,   // 30
   131,    16,    14,   // 31
   135,    16,    13,   // 32
   139,    16,    12,   // 33
   143,    16,    11,   // 34
   147,    16,    10,   // 35
   151,    16,    9,    // 36
   155,    16,    8,    // 37
   159,    16,    7,    // 38
   163,    16,    6,    // 39
   167,    16,    5,    // 40
   171,    16,    4,    // 41
   175,    16,    3,    // 42
   179,    16,    2,    // 43
   183,    16,    1,    // 44
   187,    16,    0,    // 45
   192,    16,    15,   // 46
   //Additional 15 entries for 35b
   196,    16,    14,    // 47
   200,    16,    13,    // 48
   204,    16,    12,    // 49
   208,    16,    11,    // 50
   212,    16,    10,    // 51
   216,    16,    9,     // 52
   220,    16,    8,     // 53
   224,    16,    7,     // 54
   228,    16,    6,     // 55
   232,    16,    5,     // 56
   236,    16,    4,     // 57
   120,    32,    3,     // 58
   122,    32,    2,     // 59
   124,    32,    1,     // 60
   126,    32,    0,     // 61
};
//XDSLRTFW-1617 (End)

int32 gl_FramingGenErrCode;

int32 gl_delay_octet_LP0;


//XDSLRTFW-3255 (Start)
// ERB related BAR registers
uint32 gul_BAR14 = 0;
uint32 gul_BAR17 = 0;
FlagT gft_BAR_Not_Configured = FALSE;  // This Flag is set to "TRUE" if the BAR register (BAR-15, 16 and 18) are not configured as expected
//XDSLRTFW-3255 (End)

//=============================================================================
// Pause routine
//=============================================================================
//XDSLRTFW-2186(Start)
FlagT gft_PauseOff = TRUE, gft_Resume;
int16 gs_PauseMarker;
// XDSLRTFW-2186(End)

//==============================================================================
// G994 Vendor information
//==============================================================================

G994_VendorInformation_t gt_ne_VendorInformation;
G994_VendorInformation_t gt_fe_VendorInformation;

uint32 gul_ne_G994VendorID;
uint16 gus_ne_CountryCode;
uint16 gus_ne_G994VendorSpecific;
uint16 gusa_FW_version_number[5]; //XDSLRTFW-3364 (Start_End)

uint32 gul_fe_G994VendorID;
uint16 gus_fe_CountryCode;
uint16 gus_fe_G994VendorSpecific;
uint32 gul_fe_G994VendorID_NS;
uint16 gus_fe_CountryCode_NS;

// INTEROP flags based on vendor ID and/or vendor specific info
FlagT gft_IfxAtmPtmFix;

//================================================================
// Common shared memory blocks
//================================================================
#ifdef ILV_DBG_BUFFER
//set the debug buffer pointer to the ILV/DILV start address
FlagT gft_WriteToIlvDbgBuffer;
int16 gs_IlvDbgBufferControl;
int16 *gpsa_IlvDbgBuffer;
int16 gs_IlvDbgBufferStartTrigger;
int16 gs_IlvDbgBufferStopTrigger;
int16 gs_IlvDbgBufferDecimator;
int16 gs_IlvDbgBufferDecimatorCnt;
//int16 gs_IlvDbgBufferDecimator;
int16 gs_IlvDgbBufferContentSelector;
const uint32 *glp_IlvDbgBufferStart = (uint32 *)(ZEP_RAM_ILV_DLIV_BASE + ZEP_RAM_IIBRAM_ADDR);
int16 gs_IlvDbgBufferBytesPerCycle;
int16 gs_IlvDbgBytesPerCycleModSize;
FlagT gft_IlvDbgBufferPingPong_Prev;
FlagT gft_IlvDbgBufferPingPong;
#endif //ILV_DBG_BUFFER
int16 gs_IlvDbgBufferWriteIdx;   // write index is counting in bytes

DATA_ILVB_BEGIN
// Multi-purpose buffers.  This buffer is used for different purposes at different stages
// for example, it is used to hold TX and RX HDLC message, intermediate FDQ training results etc.
int16 gsa_CommonMemoryBlock0[COMMON_MEM_BLOCK_SIZE];
uint8 guca_EGT_save[128];
// Debug Stream buffer backing-up SOC messages. See gdata.h for detailed explanation
int16 gsa_DebugStreamBuffer[6][256];
// holds Strymon register addresses and their contents
int32 gta_StrymonRegDump[SIZE_STRYMON_REG_DUMP][2];
// XDSLRTFW-3935
FDQ_t gt_ChDisc_Fdq;
DATA_MAP_END;

// Do not declare these pointers as 'const'. Also: Must be initialized here!.
int16 *gpsa_CommonMemoryBlock0 = gsa_CommonMemoryBlock0;


int16 *gpsa_LinearPsdBuffer = gsa_CommonMemoryBlock0;
int16 *gpsa_LinearPsdExpBuffer = &gsa_CommonMemoryBlock0[RX_MAX_NUM_TONES];


//gpsa_PsdForAnalysis will be used early in training to hold the PSD used for the PsdAnalysis (LATN, SATN, HLOG)
//it will reside in the TX SOC portion of Common Memory.  It can reside 2 segments into this memory since
//the multisegments are not used until the longer bits/gains messages
int16 *gpsa_PsdForAnalysis = &gsa_CommonMemoryBlock0[HDLC_MAX_MSG_LEN*2];

//================================================================
// X memory blocks
//================================================================

DATA_X_RAM_BEGIN
int32 gla_SharedBuffer_X[SHARED_X_BLOCK_SIZE_LW];
DATA_MAP_END;

//================================================================
// Y memory blocks
//================================================================

DATA_Y_RAM_BEGIN
int32 gla_SharedBuffer_Y[SHARED_Y_BLOCK_SIZE_LW];
DATA_MAP_END;


DATA_XILVB_B4_SHOW_INIT_BEGIN
int16 gsa_MfdqTones[MAX_MFDQ_TONES*2];
int16 *gsa_FbckTones = &gsa_MfdqTones[MAX_MFDQ_TONES];
DATA_MAP_END;

int16 *gsa_RxHlog;




//================================================================
// Exec layer variables:
//================================================================

FlagT gft_EnableCntlNack = 1; // temporary
FlagT gft_IssueSoftReset;
FlagT gft_AllowSoftReset; // used to filter CNTL_0_0_0 msg
FlagT gft_LinkInitiated; // used to filter CNTL_0_0_x msg where x != 0
FlagT gft_RunPostGhsInit; // force to run post GHS initialization at link start
FlagT gft_MPMessageCheckBG; // if 1, MP handling is done in BG, if 0, it is done in FG

Bonding_TC_Info gt_Bonding_TC_Info;

// XDSLRTFW-3359 (Start_End)
US_SRA_Stats_t gt_US_SRA_Stats;

// XDSLRTFW-3367 (Start_End)
DS_OLR_Reject_t gt_DS_OLR_Reject_t;

//XDSLRTFW-4051 Fast downstream up shift SRA(start)
FastDsSraConfig_t gt_FastDsSraConfig;    // attached to CMV CNFG 93
int16 gs_SraNotEnableRejectionCnt = 0;  // count continuous SRA not enabled (0x3) rejection code
uint16 gus_FastDsSraControl = 0;
//XDSLRTFW-4051 Fast downstream up shift SRA(End)

//================================================================
// State machine variables:
//================================================================
// LD/ST memory is common to all ports in 6.0, so modem variables cannot be placed there.
DATA_LOCAL_LD_ST_BEGIN

int16 SizeTcb;

PtrToFunc gpF_TxStateFunc;      // Global function pointer of TX state function
PtrToFunc gpF_RxStateFunc;      // Global function pointer of RX state function
PtrToFunc gpF_TxStateJumpTo;   // Global function pointer of TX jump state
PtrToFunc gpF_RxStateJumpTo;   // Global function pointer of RX jump state
PtrToFunc gpF_BgTask;

int16 gs_TCStateID;              //denotes which side (TX or RX) current TC function is running in.
int16 gs_FGStateID;             // Denotes which side (TX or RX) current FG function is running in.
int16 gs_BGStateID;

const int16 gs_zero_cmv = 0;

int16 gft_SkipTCTasks;
FailStateInfo_t gt_FailStateInfo_Prev;


int16 gs_TxState;               /* current Tx state */
int16 gs_RxState;               /* current Rx states */
int16 gs_TxSubState;                /* current Tx substate */
int16 gs_RxSubState;             /* current Rx substate */
int16 gs_TxSubStateCnt;             /* TX substate symbol counts */
int16 gs_RxSubStateCnt;               /* RX substate symbol counts */
int32 gl_TxSymbolCount;            /* Tx state symbol counts */
int32 gl_TotalTxSymbolCount;      /* Tx state symbol counts since LinkStart */
volatile int32 gl_RxSymbolCount;            /* Rx state symbol counts */
int32 gl_TxTcCount;               /* TX TC task counts */
int32 gl_RxTcCount;               /* TX TC task counts */
int32 gl_TxStateTimeOutCount;      // maximum TX state count
int32 gl_RxStateTimeOutCount;      // maximum RX state count
int32 gl_TxRxSymbolCountDiff;       /* When TA lengthens a TX frame, one needs to account for */
/* the potential order change of TX and RX interrupts. This */
/* variable will keep track of that change. */
int32 gl_GHSTimeOutCount;         // GHS timeout count
int32 gl_SynchroTimeoutCnt;      // variable to control the timeout threshold at discovery phase

int32 gl_TxFixedStateLength;
int32 gl_RxFixedStateLength;

int16 gs_MinOPQuiet1StateLength;   //minimum length of O-P-Quiet1 state
int16 gs_MaxOPQuiet1StateLength;   //maximum length of O-P-Quiet1 state
int16 gs_Log2NumSymbolsToMeasureQln;//Log2 of number of symbols used to measure the quiet line noise

int16 gs_RPSynchroTxTransitionCount; /* Rx Count following O-P-SYNCHRO1 detection on   */
/* which to transition Tx State */
int16 gs_ORMsg2RxTransitionCount;   /* this variable is temporary */
int32 gl_TxBridgeStateSymbolCount;

int32 gl_TxRPQuiet2SymbolCount;

int32 gl_HandshakePhaseSymCnt_start;  // marks the start of each phase
int32 gl_RPVector1PhaseSymCnt_start;
int32 gl_DiscoveryPhaseSymCnt_start;
int32 gl_TrainPhaseSymCnt_start;
int32 gl_AnalysisPhaseSymCnt_start;
int32 gl_HandshakePhaseSymCnt;
int32 gl_DiscoveryPhaseSymCnt;      //count of the number of symbols in discovery phase
int32 gl_TrainPhaseSymCnt;          //count of the number of symbols in training phase
int32 gl_AnalysisPhaseSymCnt;       //count of the number of symbols in analysis/exchange phase
int16 gs_RxState_prev;               /* current Rx states */

int32 gl_HybTrSymcnt_start;         //marks start of hybrid training
int32 gl_HybTrSymcnt_end;         //marks end of hybrid training
FlagT gft_StartHybTrn;            // Indicates start of Hybrid Training
int16 gs_TxNextState, gs_RxNextState;               /*  next states */
int16 gs_TxStopState,  gs_RxStopState;               /*  stop states */
int16 gs_TxDoneState, gs_RxDoneState;               /*  done states */
int16 gs_TxStateJumpTo, gs_RxStateJumpTo;            /*  jump-to states */
int16 gs_TxStateJumpFrom, gs_RxStateJumpFrom,gs_RxSubStateJumpFrom;         /*  jump-from states */

TCB_t gt_TaskArray[NUM_TCB_BUFFERS];   /* allow at most NUM_TCB_BUFFERS tasks */
PtrToFunc gt_BGTaskArray[NUM_BG_BUFFERS];
FunctionFifo_t gt_BGTaskFifoBuf,*gp_BGTaskFifo;
int16 gs_TxBkgdProcessFlag;        //flag to indicate the state of TX background process
int16 gs_RxBkgdProcessFlag;        //flag to indicate the state of RX background process
int16 gs_RxProcessFlag;            //flag to indicate the state of a RX process

/* use Fifos to allow multiple loading functions per TC task   */
// First entry of array is # of valid entries in rest of array, so add +1 to array size.
// First entry of array is # of valid entries in rest of array, so add +1 to array size.
PtrToLoadingFunction gp_TxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];
PtrToLoadingFunction gp_RxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];
PtrToLoadingFunction gp_RxLoadingFunctionFifo_FC[LOADING_FUNCTION_FIFO_SIZE+1];

int16 gs_EnableTimeoutCheckFlag;  //flag to control whether or not to do timeout check
uint32 gul_TxTimer;              //timer used by TX states
uint32 gul_RxTimer;              //timer used by RX states

//TX variables
int16 gs_WhichOPPilotState;      //can be 1, 2, or 3
int16 gs_FirstLink;

//RX variables
int16 gs_PeriodicSnrCalcEnableFlag; //TRUE: enable SNR calculation during Periodic state
int16 gs_RxMedleyStateFlag;         //TRUE: indicate that the RX side enter Medley state

int16 gs_TxRxMessaging;   //used to message between Tx and Rx substates

int32 gta_BAR15LookUpTable[NUM_OF_OFF_CHIP_BUFFERS][OFF_CHIP_MAX_INDEX];
int16 gs_AllowSaveDataToSram;       // need to map to a control CMV
uint8 guc_BAR15LookUpTableIdx;      // Used to separate request types within the lookup table
uint8 guc_OffChipRequestHandle;

int16 gsa_ConstellationSNR[RX_MAX_BITS_PER_TONE+1];   // required SNRs for all constellation sizes without margin.
uint8 guca_QLN[512]; //For QLN Decim factor of 8 being used for profiles <=17M and 16 for 35M
FlagT gft_StrongNoiseDetected = 0;  // 1-> Strong noise detected, 0 -> Strong noise not detected
uint16 gus_QlnLow;
uint16 gus_QlnHigh;

int16 gs_CarrierGroupSizeTx_Disc;
int16 gs_Log2CarrierGroupSizeTx_Disc;
int16 gs_CarrierGroupSizeRx_Disc;
int16 gs_Log2CarrierGroupSizeRx_Disc;
int16 gs_CarrierGroupSizeTx_Medley;
int16 gs_Log2CarrierGroupSizeTx_Medley;
int16 gs_CarrierGroupSizeRx_Medley;
int16 gs_Log2CarrierGroupSizeRx_Medley;

ChannelMeasurement_t gt_ChannelMeasurement_FE;   //measurement done by the far-end RX side
ChannelMeasurement_t gt_ChannelMeasurement_NE;   //measurement done by the near-end RX side

// What ceil is adequate for PGA, and what ceiling maximizes data rate.
int32 gl_MaxBits_CeilingOpt_ADC;
int16 gs_NumTones_CeilingOpt_ADC;
int16 gs_ceil_adequate;
int16 gs_ceil_best;
FlagT gft_EnableProposedCeilingOpt;              // flag used to enable ceiling reduction for improved SNR
FlagT gft_EnableProposedCeiling;         // if set to 1, enable calculation of proposed ceiling
int16 gs_CeilingOptBandPlanEnable;       // enable Ceiling Opt per band plan
int16 gs_ForceSpecialCeilValueDs_Cntl;   // Bit field to force special ceiling value for DS.
                                         // XDSLRTFW-1836 : Identify the wrong MaxNomPSD Values Calulated
int16 gs_Force_Dn_ProposedPsdCeiling;    // format: dB/10
                                         // special value      0: CPE calculates DS ceiling
                                         // special value   != 0: Forced value is used as DS ceiling, e.g. 0x1000 - no CPE limit on DS ceiling

/* ====================================================== */
/* global variable definitions for Tx/Rx Cyclic Extension */
/* ====================================================== */
int16 gs_TxCELength;       // TX cyclic extension length
int16 gs_RxCELength;       // RX cyclic extension length
int16 gs_TxBetaLength;     // the beta length for TX
int16 gs_RxBetaLength;     // the beta length for RX (that is the remote modem TX's beta length)
int16 gs_TxWindowLength;   // Tx windowing length in samples
int16 gs_RxWindowLength;   // Rx windowing length in samples
int16 gs_PreCELength;      // Previous CE length
int16 gs_m;                // parameter m in equation Tx-/RxCELength = m*N/32
FlagT gft_ReduceChDiscoveryRxWindowLength;   // Flag to reduce Channel Discovery Windowing length

int16 gsa_NMS_ResetPllRefToneInput_Re_Save[MAX_NUM_PILOT_TONES];
int16 gsa_NMS_ResetPllRefToneInput_Im_Save[MAX_NUM_PILOT_TONES];
int16 gs_NMS_AGC1_Gain_Save;
uint8 guc_NMS_AlgHandler;

FlagT gft_OKToSendBGFlag;      //flag used to hold off R/O-BG message until code swap is complete
// XDSLRTFW-3898(Start)
int32 gla_HybTrMetric_US0US1[VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH];

//                                     | SNR based algo                 | ECHO based algo                   |
//-------------------------------------+--------------------------------+-----------------------------------+
// guc_HybridAlgoCtrl                  | SNR_BASED                      | (ECHO_BASED | GAIN_BASED)         |
// at INIT:  (ECHO_BASED | GAIN_BASED) |                                |                                   |
// US0 only: (SNR_BASED)               |                                |                                   |
//-------------------------------------+--------------------------------+-----------------------------------+
// TEST_XDSLRTFW_CONFIG                | CONFIG_VEC_HYBRID = 0          | CONFIG_VEC_HYBRID = 1             |
//                                     | CONFIG_VEC_HYBRID_ECHO = 0     | CONFIG_VEC_HYBRID_ECHO = 1        |
//-------------------------------------+--------------------------------+-----------------------------------+


//                                  | SNR based algo                 | Echo based algo                   | GAIN based algo            | COMMENT
//----------------------------------+--------------------------------+-----------------------------------+----------------------------+---------------------------
// TEST_XDSLRTFW_CONFIG             | CONFIG_VEC_HYBRID = 0          | CONFIG_VEC_HYBRID = 1             | CONFIG_VEC_HYBRID = 1      |
//                                  | CONFIG_VEC_HYBRID_ECHO = 0     | CONFIG_VEC_HYBRID_ECHO = 1        | CONFIG_VEC_HYBRID_ECHO = 0 |
//----------------------------------+--------------------------------+-----------------------------------+----------------------------+---------------------------
// INIT                             | CONFIG_VEC_HYBRID = 1          | CONFIG_VEC_HYBRID = 1             | CONFIG_VEC_HYBRID = 1      |
//                                  | CONFIG_VEC_HYBRID_ECHO = 1     | CONFIG_VEC_HYBRID_ECHO = 1        | CONFIG_VEC_HYBRID_ECHO = 1 |
//----------------------------------+--------------------------------+-----------------------------------+----------------------------+---------------------------
// AFTER G.HS                       | CONFIG_VEC_HYBRID = 1          | CONFIG_VEC_HYBRID = 1             | CONFIG_VEC_HYBRID = 1      |
//                                  | CONFIG_VEC_HYBRID_ECHO = 1     | CONFIG_VEC_HYBRID_ECHO = 1        | CONFIG_VEC_HYBRID_ECHO = 1 |
//----------------------------------+--------------------------------+-----------------------------------+----------------------------+---------------------------
// TESTArray[TEST_HP2_CONFIG]       | always:  (TEST_HP2_CONFIG_DC_TO_ZERO | TEST_HP2_CONFIG_USE_SNR_HYB_FOR_US0);

// Note: It is not allowed to change the order of the below 4 - arrays, i.e.
//       gla_HybMetricTrace, gsa_HybTrRxPathGain, gsa_HybTrMetricEcho and gsa_AceModeforHybridSelected.
//------------------------------
int32 gla_HybMetricTrace[2];
int16 gsa_HybTrRxPathGain[((VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH +1) >> 1) << 1]; // allocate always an even number of 16-bit data
int16 gsa_HybTrMetricEcho[((VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH +1) >> 1) << 1]; // allocate always an even number of 16-bit data
int16 gsa_AceModeforHybridSelected[VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH];
//------------------------------
int16 gs_HybTrMaxMetricEcho;
int16 gs_HybTrMaxIndexEcho;
int16 gs_HybTrMaxIndexEcho_save;

// Note: Dependent of the hybrid algo a different step size is used for the CAP search.
//       Gain or Echo based: step size = 1
//       SNR based         : step size = 2
//       This is reflected in the array value order, i.e. SNR based is using -2 and 2!
//int16 gsa_CapCpb_delta[VRX_NUM_CAP_CPB_SEARCH] = {-2, -4, +2, +4, +5, -5};
// WARNING!
// Structure cannot be initialized if mapped to ARC memory (here: DATA_LOCAL_LD_ST)
// ALL VARIABLES need to be initialized in function
int16 gsa_CapCpb_delta[VRX_NUM_CAP_CPB_SEARCH];
int16 gsa_CapCpb_delta_size;
//int16 gsa_CapCpc_delta[VRX_NUM_CAP_CPC_SEARCH] = {-2, -4, +2, +4, +5, -5};
int16 gsa_CapCpc_delta[VRX_NUM_CAP_CPC_SEARCH];
int16 gsa_CapCpc_delta_size;
// XDSLRTFW-3898(End)

DATA_MAP_END
#ifdef DEBUG_TRAIL
int16 gsa_StatesTrail[STATES_TRAIL_LENGTH];
int16 gsa_StatesTrailIndex;
#endif // DEBUG_TRAIL

DSH_ModemFsmState *gpt_DSH_ModemFsmState;
DebugPLL_t gta_DebugPll;
DebugPilot_t gta_DebugPilot;
FlagT gft_EnablePilotStream = FALSE;

int16 gs_DSH_PrevFsmState;
uint16 gus_RequeueBGFunction;
uint8 guc_DSH_VersionInfoStreamed;

uint16 gus_Dbg_RequeueCnt;    //this variable is used for testing the re-queue mechanism and might be removed
uint16 gus_Dbg_DSH_skip_BGF_add;  //this variable is used to determine the correct size of NUM_BG_BUFFERS
uint16 gus_Dbg_msg_length;

int16 gs_Prev_TxOvhdMsg_length;                // Last ovhd tx msg length

//================================================================
// Tones/Samples buffer variables:
//================================================================

int16 gs_TxNumTones;
int16 gs_RxNumTones;
int16 gs_TxNumTonesUsed; // # of in-band tones
int16 gs_RxNumTonesUsed; // # of in-band tones

//==============================================================================
/* Band Control Internal variables. */
//==============================================================================

//XDSLRTFW-955 : Moved to One Port Memory
// To Accomadate New variable in G997 Structure
//int16 gsa_TxBandLeftChannel[MAX_NUM_TX_BANDS];
//int16 gsa_TxBandRightChannel[MAX_NUM_TX_BANDS];
//int16 gs_NumOfTxBands;
int16 gs_CurrentTxBand;
int16 gs_HighestAllowedTxTone;
int16 gs_HighestLoadedTxTone;   //XDSLRTFW-2059 (START_END)

uint16 gusa_SwitchingThreshTxBands[TX_BANDS_SWITCH_ARRAY_SIZE];
uint16 gusa_SwitchingThreshRxHyb[RX_HYB_SWITCH_ARRAY_SIZE];
uint16 gus_SwitchingCriterionVal;

int16 gsa_TxBandLeftChannelOSignature[MAX_NUM_TX_BANDS];
int16 gsa_TxBandRightChannelOSignature[MAX_NUM_TX_BANDS];
int16 gs_NumOfTxBandsOSignature;
int16 gsa_RxBandLeftChannelOSignature[MAX_NUM_RX_BANDS];
int16 gsa_RxBandRightChannelOSignature[MAX_NUM_RX_BANDS];
int16 gs_NumOfRxBandsOSignature;
int16 gs_NumOfRxBandsOPrm;
int16 gsa_RxBandLeftChannelOPrm[MAX_NUM_RX_BANDS];
int16 gsa_RxBandRightChannelOPrm[MAX_NUM_RX_BANDS];


//XDSLRTFW-955 : Moved to One Port Memory
// To Accomadate New variable in G997 Structure
//int16 gsa_RxBandLeftChannel[MAX_NUM_RX_BANDS];
//int16 gsa_RxBandRightChannel[MAX_NUM_RX_BANDS];
//int16 gsa_BitloadLeftChannel[MAX_NUM_RX_BANDS];
//int16 gsa_BitloadRightChannel[MAX_NUM_RX_BANDS];
//int16 gs_NumOfRxBands;
int16 gs_CurrentRxBand;
int16 gs_LowestAllowedRxTone;
int16 gs_HighestAllowedRxTone;
int16 gs_MIN_BAND_METRIC;
int16 gs_MIN_BAND_METRIC_START;
int16 gs_NumOfTonesInBand;



//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory

//#ifdef MTK_VECTORING_SUPPORT
int16 gs_NumOfVecRxBands;
int16 gsa_RxVecBandLeftChannel[MAX_NUM_RX_BANDS];
int16 gsa_RxVecBandRightChannel[MAX_NUM_RX_BANDS];
//#endif

int16 gsa_RFIBandLeftChannel[MAX_NUM_RFI_BANDS];
int16 gsa_RFIBandRightChannel[MAX_NUM_RFI_BANDS];
int16 gs_NumOfRFIBands;

int16 gsa_DsBlackoutBandLeftChannel[MAX_NUM_BLACKOUT_BANDS];
int16 gsa_DsBlackoutBandRightChannel[MAX_NUM_BLACKOUT_BANDS];
int16 gs_NumOfDsBlackoutBands;

int16 gsa_UsBlackoutBandLeftChannel[MAX_NUM_BLACKOUT_BANDS];
int16 gsa_UsBlackoutBandRightChannel[MAX_NUM_BLACKOUT_BANDS];
int16 gs_NumOfUsBlackoutBands;

int16 gsa_EstRxBandLeftChannel[MAX_NUM_RX_BANDS];
int16 gsa_EstRxBandRightChannel[MAX_NUM_RX_BANDS];
int16 gs_NumOfEstRxBands;


int16 gs_EocGroupSize ;
int16 gs_EocGroupSizeHLOG ;
int16 gs_EocGroupSizeSNR ;
FlagT gft_US0BandUsed;
FlagT gft_US0BandUsedInCD;
int16 gs_SelectBandStart, gs_SelectBandSize;
int16 gs_MinSnrThreshForFACluster;

int16 gs_TxLog2IfftLength;
int16 gs_TxIfftLength;
int16 gs_TxCPLength;
int16 gs_TxCSLength;
int16 gs_TxGain = TX_POW_LEVEL;         //Used by GenerateSynSymLookUpData to set the signal level
int16 gsa_TxSingleToneBuf[2];         //Used by LoadSingleToneToIfftBuf to set the signal level

int16 gs_RxFftRsh;//scale-backs for the FFT block //XDSLRTFW-3441
int16 gs_RxLog2FftLength;
int16 gs_RxFftLength;
int16 gs_RxCPLength;
int16 gs_RxCSLength;
int16 gs_RxRefToneLevel;

uint32 gul_TxIfftRate =  (7)<<16;
uint32 gul_RxFftRate;
uint32 gul_RXIIR_reg = 0;
uint32 gul_DecimCfg_reg = 0;
int32 gl_Active_BGTN_Size; //CHECK_VRX518
int16 gs_Active_TxEGT_Size;
int16 gs_TxAbgtOffset;
int16 gs_RxAbgtOffset;
int16 gs_TxFrameAlignRemain;
int16 gs_RxFrameAlignRemain;
FlagT gft_EnableQtStall = TRUE;

FlagT gft_IFFT_On;
FlagT gft_TxDataPump_On;

FlagT gft_EnableGetRxTones;
FlagT gft_CopyPilotFromRegisters;
FlagT gft_PrintRxTones;             // Set to 1 to log/print contents of gpsa_RxToneBuf
FlagT gft_RxMedleyTransition;
FlagT gft_EnableRxTimeDomainRead;   //set to TRUE to enable capture of time-domain input samples

FlagT gft_EctPllDisable;         //if set to 1, disable the PLL while receiving the ECT signal

int16 gs_PeriodicPllDisable;      //if set to 1, disable the PLL during transition between
//periodic state to non-periodic state or vice versa
int16 gs_EnablePeriodicFrameRealign; //if set to 1, enable the frame realignment during transion
//between periodic state to non-periodic state or vice versa
int16 gs_RxTxCsDiff;
int16 gs_CsLength;
int16 gs_HandleRxCE_PeriodicStateStart_s_count;
int16 gs_HandleRxCE_PeriodicStateStart_StartSym_Offset;
int16 gs_HandleRxCE_PeriodicStateStart_EndSym_Offset;
int16 gs_HandleRxCE_Periodic2StateStart_StartSym_Offset;
int16 gs_HandleRxCE_Periodic2StateStart_EndSym_Offset;

int16 gs_TurnOffPLL_in_OPSYNCRO1;

FlagT gft_RxTxCsDiff_err;
FlagT gft_SkipSymbol;
int16 gs_FeModemLog2IfftSize;      //log2 of the IDFT size used bythe far-end modem

int16 *gpsa_RxToneBuf;      // Tone buffer after FFT (and FDQ) (Rx)
int16 *gpsa_RxTDSampleBuf; // pointer to the RX time-domain sample buffer
int16 gs_RxToneOffset;
int16 gs_RxToneOffsetSave;
int16 gs_RtvSelect;

int16 gft_EocNack;
int16 gs_EocMsgRcv;
//XDSLRTFW-3463 Init Default values of AFE TX/TRX mode as 17MHz
uint16 gus_AFE_RxMode = VDSL17_CPE;
uint16 gus_AFE_TxMode = VDSL17_CPE;

uint16 gus_DAC_Rate, gus_ADC_Rate;
//0x30c690          V_SRC_CFG
//V_SRC_CFG                   0x700001  35MHZ SRC.FACTOR=1  TX.SRC.IN_RATE = 144/2^(8-7) = 72
//V_SRC_CFG                   0x600071  17MHZ SRC.FACTOR=1  TX.SRC.IN_RATE = 144/2^(8-6) = 36
//V_SRC_CFG                   0x600071   8MHZ SRC.FACTOR=1  TX.SRC.IN_RATE = 144/2^(8-6) = 36
uint16 gus_TxSRC_InRate,gus_TxSRC_UpsamplingFactor,gus_TxSRC_OutRate;


#ifndef STANDALONE_FRAMING_TEST
DATA_LD_ST_MKERNEL_BEGIN
#endif
uint8 guc_ch_id = 0;
uint8 guc_PortMode = 0;      //0: 1-port mode, 1: 2-port mode
uint8 guc_num_ports = 1;

uint8 guc_adma_reg_offset;              // will be set to 0 or (DSP_ADMA1_CTRL - DSP_ADMA0_CTRL) for port0 and port1 respectively
uint8 guc_xdma_reg_offset;              // will be set to 0 or (DSP_XDMA1_CTRL - DSP_XDMA0_CTRL) for port0 and port1 respectively
uint8 guc_adma = 0;
uint32 gula_adma_status[3];

int32 gl_MaxBgDuration;
int32 gl_CurrentStackPointer;

uint8 guc_KernelState;                  // first interrupts or not
DATA_MAP_END;

int16 gs_RtvSelectLastFrame;
//FlagT gft_UpdateVRegShadowFifo;

//populated when running  TRT reorder.
int16 gs_Tblcpy_Num0bit[2] ,gs_Tblcpy_NumGT1bit[2] ;
int16 gs_unpairedBatZeroTone[2];
FlagT gft_ByPassAfe = FALSE; //Bypass AFE for Emulation environment testing
FlagT gft_ByPassCustomerMsgHandling = FALSE;

int32 *gpla_SnrAccuBuf;
int32 *gpla_RxAccumBuf;
int16 *gpsa_RxRepBuf;
int16 gs_LeftChannel, gs_RightChannel;
int16 gs_NumChannelsPerGroup;
int16 gs_NumChannelsPerGroupSave;
int16 gs_NumChannelsDetect;



#ifdef HW_SNR_FDQ
int16 gs_LeftChannel_AsyncFDQ, gs_RightChannel_AsyncFDQ;
int16 gs_CurrentRxBand_AsyncFDQ;

uint32 gul_FD_RNG0Shadow = 0;   // Used in TRigger and Detrigger Vector Power.
uint32 gul_FD_RNG0CNTShadow =0;
uint32 gul_RX_MISC_Shadow;      // Used in TRigger and Detrigger Vector Power;
#endif //#ifdef HW_SNR_FDQ

int16 gs_TxVarGain;      // Tx gain mantissa
int16 gs_TxVarGainExp;   // Tx gain exponent
int16 gs_RxVarGain;      // Rx gain mantissa
int16 gs_RxVarGainExp;   // Rx gain exponent
int16 gs_RxVarGainMarginDB;   //Rx gain margin in q8.8 dB form
int16 gs_RxVarGainDB_NoEcho; // Rx gain in q8.8 dB form; without echo during Ch Disc phase
int16 gs_RxVarGainDB_ChDisc; // Rx gain in q8.8 dB form; with echo during Ch Disc
int16 gs_RxVarGainDB_NoEcho_Train; // Rx gain in q8.8 dB form; without echo during Training Phase
int16 gs_RxVarGainDB_Dbg;   // Rx gain in q8.8 dB

//==============================================================================
// AFE & PGA control variables
//==============================================================================
uint64 gll_Pa;
int32 gl_Pa;                              /*  average received power */
int16 gs_PGA_required;                    /*  receommended PGA, in dB (Q8.8) */
int16 gs_PGA_required_Pre;                /*  receommended PGA before compensation, in dB (Q8.8) */

//int16 gs_PGA_margin;                    /*  margin added for PGA calculation  */
int16 gs_PGA_margin_AGC1;                 /*  margin added for PGA calculation  */
int16 gs_PGA_margin_AGC2;                 /*  margin added for PGA calculation  */
int16 gsa_PgaCorrection;
int16 gs_Pga_XtakNoiseScale;
int16 gs_Pga_XtakNoiseScaleCtrl;

int16 gs_PGA_set;                         /* current PGA setting, in dB (Q8.8) */
int16 gs_PGA_set_GHS;                     /* PGA setting used in Ghs, in dB (Q8.8) */
int16 gs_PGA_set_ChDisc;                  /* PGA setting with Echo during Ch Disc, in dB (Q8.8) */
int16 gs_PGA_set_NoEcho_Train;            /* PGA setting (without echo during Training phase), in dB (Q8.8) */
int16 gs_PGA_required_In_PropCeilCalc;    /* PGA value in Proposed Ceil calc */
int16 gs_PGA_required_In_GHS;             /* Initial PGA value for GHS */
int16 gs_PGA_init_In_Train;               /* Initial PGA value for training */

int16 gs_HwSettleTime;
int16 gs_RTVxCfgLatency;

int16 gs_MaxFreqDomainValueTone;
int16 gs_MaxFreqDomainValue;

uint8 guc_RxPwrIndicator = 0;                  //XDSLRTFW-2467
int16 gs_AvRxTimePwr;                          // Average time domain received power per sample
int16 gs_MaxRxTonePwr;                         // The maximum of the received tone power among all tones (8.8)
int32 gl_LinMaxRxTonePwr;

int16 gs_AvRxTimePwr_NoEcho;                   // without echo during Ch Disc phase
int16 gs_AvRxTimePwr_ChDisc;                   // with Echo during Ch Disc
int16 gs_AvRxTimePwr_NoEcho_Train;

int16 gs_MaxRxTonePwr_NoEcho;                  // without echo during Ch Disc phase
int16 gs_MaxRxTonePwr_ChDisc;                  // with Echo during Ch Disc
int16 gs_MaxRxTonePwr_NoEcho_Train;

FlagT gft_UpdateVRegShadowFifo;
FlagT gft_UnityRxVarGain;
int16 gs_PGA_set_Qln;
int16 gs_RxVarGainDB_Qln;
int16 gs_HybridGain_Qln;

uint8 guc_PgaState;
uint8 gft_PGADnldEnable;

int16 gs_PgaHandlerState;
int16 gs_PgaHandlerRun;

int16 gs_FdqAlgLog2NumFramesToAccum_Saved;
int16 gs_SnrAlgLog2NumFramesToAccum_Saved;
int16 gs_PsdAlgLog2NumFramesToAccum_Saved;
int16 gs_FinalSnrAlgLog2NumFramesToAccum = 9;

//#ifdef MTK_VECTORING_SUPPORT
FlagT gft_FastLosEnabled;
int16 gs_VectorHandlerState;
int16 gs_RxFrmCnt=0, gs_TxFrmCnt=0, gs_RxSuperFrmCnt=0, gs_TxSuperFrmCnt=0,gs_RxVecFrmCnt=0, gs_DSVec_N_SSC;
uint32 gul_EOC_ErrorFB_CMD_count;   // Special value 0x0000 indicates that this is the 1st ERROR-FB request
int16 gsa_Indx_RxSyncFrm[2];
//XDSLRTFW-2059 (Start)
PSDCompData_t gt_PSDCompData = {0};
uint32 gul_CompTableSourceAddrsOffset;
uint32 gul_CompTableDestinationAddrs;
uint32 gul_CompTableSize;
//XDSLRTFW-2059 (End)

//moved to LD_ST XDSLRTFW-1485(START_END)
//uint8 guca_Vector_NPilotSeq[64];
//uint8 guca_Vector_NPilotSeq_EOC[64];
FlagT gft_DSVectoringEnabled;
uint16 gus_VectoringOptionsEnabled;
FlagT gft_PilotseqInterruptionNotAllowed = 0;
//XDSLRTFW-1621 DeltInVectoring (Start/End)
FlagT gft_DeltInVectoringMode = 0;
uint16 gus_VceT35CountryCode;
uint32 gul_VceProviderCode;
uint32 gul_VceVersionNumber;
uint32 gul_CpeTransId;

int32 gl_USPilotSeqRaw;
int16 gs_VecIndx_PilotSeq=0,gs_VecIndx_PilotSeq_comp = -1, gs_VecNPilotLength_US=512;
int16 gs_MsgReceiveOPSYNCHROV1Flag;
int16 gs_VecRPVector1PSDCutback; // check these are needed or not
int8  gc_VecUSSyncOffset; // this veriable represents US sync symbol offset defined in Table 10-2/G993.5 field#5
int8  gc_VecDeltaRxTxSyncSym;
int16 gs_DSSyncPosition_cnt;
// XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
uint8 guc_SwitchGlobalTimeout = FALSE;
FlagT gft_FirstRxSyncSybmolInShowtime = TRUE;
uint8 guc_VecDebugSwitchEnable;
FlagT gft_ExecuteShadowing;
uint8 guc_VectorPowerRightShifts;
uint8 guc_VectorPowerRightShiftsMax;

uint32 gul_QtpTxPrbsMisc_Shadow;
uint16 gus_ReTxOptionsEnabled;

uint32 gul_dbg_Zephyr[20];


int16 gs_Debug0=15, gs_Debug3 = 0, gs_Debug4 = 0, gs_Debug5 = 0, gs_Debug6 = 0, gs_Debug7 = 0, gs_Debug8 =0, gs_Debug9 = 0, gs_Debug10 = 0;

//XDSLRTFW-3554: DS datarate exceeds configured max (start)
// These variables are used for framing parameter generation debugging
int16 gs_ForcedMaxRate_DS = -1; // format [data_rate_in_kbps/8]
int16 gs_ForcedMinRate_DS = -1; // format [data_rate_in_kbps/8]
int16 gs_ForcedMinINP_DS = -1;
int16 gs_ForcedMaxDelay_DS = -1;
int16 gs_EnableForcedFailState = 0;   // 1 : Enable Forced fail state at end of Framming generation, 0: Disable
//XDSLRTFW-3554: DS datarate exceeds configured max (start)
// XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start)
int16 gs_NumFramesFastPLLStabilization_ChDiscV1 = 2000;
int16 gs_NumFramesSlowPLLStabilization_ChDiscV1 = 1330;
int16 gs_NumFramesFastPLLStabilization_ChDisc1 = PLL_STABILIZATION_LEN_650;
int16 gs_NumFramesSlowPLLStabilization_ChDisc1 = PLL_STABILIZATION_LEN_300;
// XDSLRTFW-1506 (start)
//int16 gs_NumFramesFastPLLStabilization_TrainV1 = 6000;
//int16 gs_NumFramesSlowPLLStabilization_TrainV1 = 4000;
int16 gs_NumFramesFastPLLStabilization_TrainV1 = 2000;
int16 gs_NumFramesSlowPLLStabilization_TrainV1 = 1330;
// XDSLRTFW-1506 (end)
int16 gs_NumFramesFastPLLStabilization_Train1 = PLL_STABILIZATION_LEN_650;
int16 gs_NumFramesSlowPLLStabilization_Train1 = PLL_STABILIZATION_LEN_300;
// XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (End)

int16 gs_PhaseErrorThresholdConstant = 8;


int16 gs_RTV0Probe = 4;
int16 gs_CGShiftFactor = 4;

int16 gs_NoOfRTV0ToneToCapture = (RX_MAX_NUM_TONES >> G9932_VECTORING_IR_NPR_DECIM);
int16 gs_IR_NPR_DECIM = G9932_VECTORING_IR_NPR_DECIM;

uint32 gl_IR_TCM_CTRL_Shadow;
uint32 gul_QTRxNotDone = 0;
int16 gs_QTDebugCnt = 0;
int16 gs_TxQTRunAfterStall = 0;      // zero indicates stall
int16 gs_RxQTRunAfterStall = 0;      // zero indicates stall

uint8 guc_TxRxCommunicator;
FlagT gft_IT_MISC_RefGainEna = FALSE;
uint32 gul_RX_MISC_Shadow2;
// XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start/End)
uint32 gul_ItlvMemSizeReTxRMsg2; // This Variable value transmitted in R-MSG2.G.INP.Field10.
// After implementing G.INP Amd 2, this variable can be removed!

uint8 guc_RxFirstShwotimeSymbol = 1;
FlagT gft_TxFirstShwotimeSymbol = TRUE;

//moved to LD_ST XDSLRTFW-1485(START_END)
//int16 gsa_DebugCA[20];
//int16 gsa_DebugCB[20];
//int16 gs_DebugCnt = 0;


int16 gs_RxSuperFrmCnt_ForEOC;

uint16 gus_RefGain = 0x2000 ; // 0x2000 = Unity Gain in 2.13 format

int16 *gpsa_IIBA,*gpsa_IIBB;
int32 *gpla_IIBC;

int16 *gpsa_MonitorConstallation = (int16 *) 0x4b2b0;

DecMsg_PMS_VDSL2_Vectoring_t gt_DecMsg_O_PMS_G9935;     // //Table10-10 G.993.5 variables

int16 gs_RxSuperFrmCnt_in_Showtime = 0;
int16 gs_NoOfEocTransmitted1 = 0;
int16 gs_NoOfEocTransmitted2 = 0;
int16 gs_NoOfEocTransmitted3 = 0;
int16 gs_EocDebug[16];
uint16 gus_DCTOptimization = 1;
//#endif

uint16 gus_SyncSymbolPattern1;  // XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4 (end)
uint16 gus_SyncSymbolPattern2;  // XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4 (end)
int16 gs_PauseControl; // this variable is introduced to control Pause in different state machine


AFEConfig_t gt_AFEConfig;
GainCalibration_t gt_GainCalibration;
FlagT gft_DisableAdcCalibration;
FlagT gft_ModeSelectAdcCalibration;

//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
int16 gs_InitFreqOffsetDelta;
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]
int16 gs_lowOscOffset_ppm; //XDSLRTFW-2442


uint16 gus_wrfail_done = 0;
uint16 gus_wrfail_busy = 0;
uint16 gus_rdfail_done = 0;
uint16 gus_rdfail_busy = 0;
//25/11/2009; Kannan ; SSC Speed changed it to 10Mhz 288/2/10 = 14,
//This is done to do the ADC Trimming properly
uint32 gul_SSC_Speed = 0xE;
uint16 gus_3GLP_timeout_count = 0;

//==============================================================================
// Hybrid Training variables
//==============================================================================
//To load VR9 AFE functions in the RxLoadingFunctionFifo
PtrToFunc gpF_AfeLoadFunc;
FlagT gft_LoadAfeFunctions = 0;
FlagT gft_AFEBkgdTaskDone = 0;

uint8  guc_ForceNumHybrid;                // Force the required number of hyb settings.
uint8  guc_EnableHybCapacitorSearch;
// XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
uint8  guc_HybridAlgoCtrl;
uint8  gft_HybridTrainingEnable;
uint8  guc_HybridEchoAccu;

int16  gs_HybrTrHandlerState, gs_HybrTrHandlerCount;
int16  gs_HybTrStepSize;
int16  gs_HybTrIndex, gs_HybTrMaxIndex, gs_HybTrFinishUp;
int16  gs_HybTrMaxIndex_CapSearch;
int16  gs_MaxNumHybrSettings;
int16  gs_HybTrMaxIndex_save, gs_MaxNumHyb_save;
int16  gs_HybTrIterat_save;
int16  gs_HybTrIndexDbg;
int16  gs_HybNumUsBand;

int32 gl_HybTrMaxMetric;
//XDSLRTFW-1485(START)
int32 gl_HybTrMetric[VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH]; //SMS01357115 - VDSL_62 HybridTraining

uint16 gs_PgaTrainingDbg;

int32 gl_ld_line_gain_db;

FlagT gft_EnablePsdMeasurementInPgaHandler = FALSE;
FlagT gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
FlagT gft_EnableDoublePGATrain = FALSE;
FlagT gft_BypassRxAFE_HPF = FALSE;
FlagT gft_EnableBypassRxAFE_HPF = FALSE;
FlagT gft_EnableGlpOvflCheck = 0;

//==============================================================================
// HW Specific Variables
//==============================================================================

// Indicator for the attached hybrid module, set by cmv OPTN 5
uint16 gus_HybridType;
uint16 gus_LD_Mode;
uint16 gus_CurrLDMode;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
uint16 gus_FeaturesControl;
//XDSLRTFW-439: Feature_All1_DS_All_All_SupportDsTxRefVirtualNoise (End)
int16 gs_DSL_AlgControl4;  // dsl 2 0


int32 gl_afe_fixed_gain; // Conversion factor for AFE effects (measured impirically), and to dBm/Hz. //VRX518_Remove

//==============================================================================
// Timer variables
//==============================================================================

int32 gl_MaxTimePerFrame;
int16 gs_LpbkAlignmentOffset;
int32 gl_TxFcTimerCount;
int16 gs_RxFcTimerCount;
uint16 gus_TxQtTimerCount;
int32 gl_TxQtpTimerCount;
int16 gs_RxQtTimerCount;
int16 gs_RxQtpTimerCount;



#ifdef PROFILE_TASKS

int16 gsa_MaxMIPSCnt[NUM_OF_PROFILE_POINTS];
int16 gsa_MaxMIPSTxState[NUM_OF_PROFILE_POINTS];
int16 gsa_MaxMIPSTxSubState[NUM_OF_PROFILE_POINTS];
int16 gsa_MaxMIPSRxState[NUM_OF_PROFILE_POINTS];
int16 gsa_MaxMIPSRxSubState[NUM_OF_PROFILE_POINTS];

#endif //PROFILE_TASKS

#ifdef PROFILE_TASKS_VR9
int32 gla_MipsCnt[NUM_OF_MIPS_CNTS];
MaxMipsCnt_t gta_MaxMIPSCnt[2];
uint16 gus_MaxRxTcTime;
#endif //#ifdef PROFILE_TASKS_VR9

FlagT gft_EnableTaskProfile = FALSE;
int16 gs_RxTimerRollOverFlag;      //0: roll over on Rx buffer swap, 1: roll over at max count
int32 gl_MaxRxTimerCnt;

FlagT gft_LimitedRatecase=0;
FlagT gft_AdaptiveRatecase=0, gft_FixedRatecase=0;

#ifdef DEBUG_TRAIL
// Structures to provide CMV control/status of Debug Trails
//DebugTrailControl_t gt_debugTrailControl; //Moved to One Port Memory
//DebugTrailStatus_t gt_debugTrailStatus;
#endif // DEBUG_TRAIL
//==============================================================================
// active/inactive pointers to HW Ping-Pong tables
//==============================================================================
uint8 *ghpuca_TxBat_Active; // HW pointer to active TX bit allocation table (BAT)
uint8 *ghpuca_RxBat_Active; // HW pointer to active RX bit allocation table (BAT)
int16 *ghpsa_TxFineGains_Active; // HW pointer to active TX fine gain table (GST)
int16 *ghpsa_RxFineGains_Active; // HW pointer to active RX fine gain table (GST)
uint8 *ghpuca_TxExtGains_Active; // HW pointer to active TX extended gain table (EGT)
int16 *ghpsa_TxToneOrder_Active; // HW pointer to active TX tone ordering table (TRT)
int16 *ghpsa_RxToneOrder_Active; // HW pointer to active RX tone ordering table (TRT)

uint8 *ghpuca_TxBat_Inactive; // HW pointer to inactive TX bit allocation table (BAT)
uint8 *ghpuca_RxBat_Inactive; // HW pointer to inactive RX bit allocation table (BAT)
int16 *ghpsa_TxFineGains_Inactive; // HW pointer to inactive TX fine gain table (GST)
int16 *ghpsa_RxFineGains_Inactive; // HW pointer to inactive RX fine gain table (GST)
uint8 *ghpuca_TxExtGains_Inactive; // HW pointer to inactive TX extended gain table (EGT)
uint8 *ghpuca_RxExtGains_Inactive; // HW pointer to inactive RX extended gain table (EGT)
int16 *ghpsa_TxToneOrder_Inactive; // HW pointer to inactive TX tone ordering table (TRT)
int16 *ghpsa_RxToneOrder_Inactive; // HW pointer to inactive RX tone ordering table (TRT)

//==============================================================================
// other pointers to HW buffers
//==============================================================================
int16 *ghpsa_SFDQMantissa;

uint8 *ghpuca_SFDQExponet;

int16 gs_FixedFdqMant;
uint8 guc_FixedFdqExp;

#ifdef USE_FRAME_BUFFERS
int16 *ghpsa_rxframebuffer;
int16 *ghpsa_txframebuffer;
#endif /*  USE_FRAME_BUFFERS */

// Modem configuration variables
uint16 gus_ModemMode; // CO or CPE
uint16 gus_PhysicalTransportMode; // PTM/STM/ATM mapping
// gus_TpsTcType used for forming and interpretting O-MSG1, R-MSG2, O-TPS messages
uint16 gus_TpsTcType[MAX_TPS_TC_TYPE] = {TPS_TC_TYPE_PTM, TPS_TC_TYPE_ATM, TPS_TC_TYPE_STM};
// Flag to select between ATM/PTM cores (valid only for HW platforms with a PTM core)
FlagT gft_TcTypeSelected;
// general modem configuration / VDSL-mode only configurations
ModemConfig_t gt_ModemConfig;

#ifdef PPE_ENGINE
DATA_LOCAL_LD_ST_BEGIN
//PPE configuration variables
uint32 gula_DREG_AT_CFG_Cnfg[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CFG_Cnfg[NUM_BEARER_CHANNELS];

//PPE TX counter shadow registers
uint32 gula_DREG_AT_CELL_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AT_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];

//PPE RX counter shadow registers
uint32 gula_DREG_AR_CELL_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_AIIDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_BE_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_HEC_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CD_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_OVDROP_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CERRN_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CERRNP_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CVN_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CVNP_CNT_Shadow[NUM_BEARER_CHANNELS];
/*
    G997_PtmPerfCnts_t gt_g997_PtmPerf_Running_NE;
    G997_PtmPerf_Cur_Prev_t gt_g997_PtmPerf_Cur_Prev_NE;
    G997_PtmPerfCnts_t gt_g997_PtmPerf_Running_FE;
    G997_PtmPerf_Cur_Prev_t gt_g997_PtmPerf_Cur_Prev_FE;
*/
DATA_MAP_END;

#endif //#ifdef PPE_ENGINE

//==============================================================================
// Modem configuration variables (CMV able)
// Data structures that ME 'generally' configures
// In normal mode of operation used by CO only
// We connect these in RT mode too for sleep state, showtime only tests etc
//==============================================================================
// TPS-TC Bearer Channel Control supported
TPS_TC_BearerChannel_t gta_DsBearerChannel[NUM_BEARER_CHANNELS];
TPS_TC_BearerChannel_t gta_UsBearerChannel[NUM_BEARER_CHANNELS];

// PMS-TC Latency Path Control
PMS_TC_LatencyPath_t gta_DsLatencyPath[NUM_DATA_PATHS];
PMS_TC_LatencyPath_t gta_UsLatencyPath[NUM_DATA_PATHS];
uint8 guc_DsOneOverSmax;
uint8 guc_DsMinMsgOHR;            //in unit of kbps
uint8 guc_DsDynamicInlvEnable;      //1: enable, 0: disable
uint8 guc_UsOneOverSmax;
uint8 guc_UsMinMsgOHR;            //in unit of kbps
uint8 guc_UsDynamicInlvEnable;      //1: enable, 0: disable

MinMsgOHR_t gt_MinMsgOHRConfig;      //structure used for CMV control of min overhead rate

// SNR margin configuration (DS/US target/max/min)
SnrMgnConfig_t gt_SnrMgnConfig;
NoiseMarginChange_t gt_NoiseMarginChange;
SNROffsetControl_t gta_SNROffset; //XDSLRTFW-3823
SNROffsetChange_t gt_SNROffsetBitLoad[SNR_OFFSET_TONEGROUPS+2]; //XDSLRTFW-3823 local copy
int16 gs_ToneGroupIdx; // index used for ToneGroups of SNR offset feature



// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
DATA_LOCAL_LD_ST_BEGIN

AutoSRA_t gt_RxAutoSRA_Ctrl = {0, 0x3FFF, 0, 0x3FFF};   // RX (or US) SRA control parameters


uint16 gus_USShowtimeEvents;
uint16 gus_DSShowtimeEvents;

//XDSLRTFW-1456
int16 gs_MinMsgOHR_save;

uint8 guc_SRAState;
FlagT gft_USRAInitiate;         // Flag to initiate an upshift SRA
FlagT gft_DSRAInitiate;         // Flag to initiate a downshift SRA
FlagT gft_RxSraInProgress;      // Flag that an SRA is in progress
FlagT gft_SNRUpdated_PostSRA;   // Flag to inidicate that SNR has been updated since the last SRA task
FlagT gft_CapableRxAutoSRA; // indicates whether capable of RX SRA
FlagT gft_CapableTxSRA;     // indicates whether capable of TX SRA

FlagT gft_EnableRxAutoSRA;  // RX SRA enabled if both NE and FE are capable.
FlagT gft_EnableTxSRA;      // TX SRA enabled if both NE and FE are capable.
// Auto SRA framing threshold
FlagT gft_SRARateViolated;
FlagT gft_SRA_FAIL;
uint8 guc_SraShiftControl;
uint8 guc_SraShiftOffset;

int16 gs_UTIME_Count;           // variable to monitor time the average margin is above RA-USNRMds/us
int16 gs_DTIME_Count;           // variable to monitor time the average margin is below RA-DSNRMds/us
int16 gs_delta_Lp;              // Number of tones changes in one call the background fucntion
int16 gs_MaxTones_SRAIteration; // Maximum number of tones changed in an SRA request

uint32 gul_AutoSRALmin;
uint32 gul_AutoSRALmax;

uint16 gus_DsRAMode;
uint16 gus_UsActRAMode;// Variable to indicate the Rate Adaptation mode in US direction
int16 gs_data_path;

uint16 gusa_Lmin[5];
uint32 gula_Lmax[7];


uint32 gul_rx_current_Lp[NUM_DATA_PATHS];
uint32 gul_tx_current_Lp[NUM_DATA_PATHS];

int32 gl_ActualDeltaSumLp;      // Actual nukmber of bits changed in an SRA request
int32 gl_SRATotalLpDeltaMax;    // Max Lp bits changed before an SNR update is done
int32 gl_SRATotalLp_DeltaCnt;   // Running count of the Lp bits changes in the current SRA task
int32 gl_SRATotalLp_Delta;      // Desired Lp change for the current SRA task

int16 gs_NoOfDsSraAfterSnrUpdate; // No of DS SRA count after last DS SNR update


int16 gsa_DebugCA[20];
int16 gsa_DebugCB[20];
//XDSLRTFW-1485(END)

//XDSLRTFW-2260 (Start)
PSDCompDescriptorTable32_t gt_UsPsdCompensationTable = {0};      // Controlled by CNFG 88 0
PSDCompDescriptorTable16_t gt_DsPsdCompensationTable = {0};      // Controlled by CNFG 87 0
PSDCompDescriptorTableCombined_t gt_DsPSDCompensationTableCombined = {0};
//XDSLRTFW-2260 (End)

ReTxForcedFraming_t gt_ReTxForcedFraming;  //XDSLRTFW-3020


DATA_MAP_END;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
// Band Configuration variables
BandDescriptorTable_t   gt_TxBandControl;
BandDescriptorTable_t   gt_RxBandControl;
RFIBandDescriptorTable_t gt_RFIBandControl;

// IIR Filter config variables
int16 gs_TxIIRFilterSelect;
int16 gs_RxIIRFilterSelect;
int16 gs_TxPathAfeDfeCustomSettings;


// PSD Configuration Variables
//Default to ITU_AnnexF_o_TCMISDN_17a_HAM_unnotched bandplan
PwrConfigParam_t      gt_PwrConfigParamCMV;
PwrConfigParam_t      gt_PwrConfigParam;
int16 gs_MAX_US0_CEILING;
int16 gsa_Dn_MaxNomPSD[MAX_NUM_DS_BANDS];

DsPSDDescriptorTable_t gt_MaxDsPSDDescriptorTableCMV;
UsPSDDescriptorTable_t gt_MaxUsPSDDescriptorTableCMV;
UsPSDDescriptorTable_t gt_RefUsPSDDescriptorTableCMV;
UPBOPSDDescriptorTable_t gt_UPBOPSDDescriptorTable;

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
uint16 gus_ELEDsMin;
uint8 guc_ELEDsBands;
uint8 guc_ELEUsBands;
AELEM_UPBOInfo_t gt_AELEM_UPBOInfo;
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

DATA_DILVB_BEGIN
// Internal PSD Configuration Variables
DsPSDDescriptorTable_t gt_MaxDsPSDDescriptorTable;
UsPSDDescriptorTable_t gt_MaxUsPSDDescriptorTable;
UsPSDDescriptorTable_t gt_RefUsPSDDescriptorTable;


RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_HYB_UNKNOWN =
{
   2,
   {
      { 0,   0,   1   },
      { 8192,   0,   1   }
   }
};


// ##A21####A21####A21####A21## New LIF PSD Table ##A21####A21####A21####A21##  START
// New PSD tables for Modified LIF
//XDSLRTFW-3569 start
//VRX518 Normalised Rx path compensation table for 35b mode and legacy modes(17M/12M/8M)
//Generated normalised Rx path tarnsfer function(unity gain)
//Seperated Trafo Gain,AFe level shift gain,Hybrid Gain,PGA,PREFI into structure
RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_35M =
{
   44,
   {
      {0   , 27181,1 },  // Q8.8 format, 106.18dB
      {1   , 24209,1 },  // Q8.8 format,  94.57dB
      {2   , 20317,1 },  // Q8.8 format,  79.36dB
      {3   , 17889,1 },  // Q8.8 format,  69.88dB
      {4   , 16160,1 },  // Q8.8 format,  63.13dB
      {5   , 14839,1 },  // Q8.8 format,  57.96dB
      {6   , 13783,1 },  // Q8.8 format,  53.84dB
      {7   , 12911,1 },  // Q8.8 format,  50.43dB
      {8   , 12174,1 },  // Q8.8 format,  47.55dB
      {9   , 11538,1 },  // Q8.8 format,  45.07dB
      {10  , 10982,1 },  // Q8.8 format,  42.90dB
      {11  , 10488,1 },  // Q8.8 format,  40.97dB
      {12  , 10040,1 },  // Q8.8 format,  39.22dB
      {14  ,  9278,1 },  // Q8.8 format,  36.24dB
      {15  ,  8948,1 },  // Q8.8 format,  34.95dB
      {17  ,  8350,1 },  // Q8.8 format,  32.62dB
      {20  ,  7601,1 },  // Q8.8 format,  29.69dB
      {24  ,  6795,1 },  // Q8.8 format,  26.54dB
      {29  ,  5998,1 },  // Q8.8 format,  23.43dB
      {35  ,  5248,1 },  // Q8.8 format,  20.50dB
      {41  ,  4652,1 },  // Q8.8 format,  18.17dB
      {48  ,  4086,1 },  // Q8.8 format,  15.96dB
      {56  ,  3570,1 },  // Q8.8 format,  13.95dB
      {65  ,  3105,1 },  // Q8.8 format,  12.13dB
      {75  ,  2691,1 },  // Q8.8 format,  10.51dB
      {86  ,  2327,1 },  // Q8.8 format,   9.09dB
      {98  ,  2007,1 },  // Q8.8 format,   7.84dB
      {112 ,  1710,1 },  // Q8.8 format,   6.68dB
      {127 ,  1457,1 },  // Q8.8 format,   5.69dB
      {144 ,  1232,1 },  // Q8.8 format,   4.81dB
      {163 ,  1024,1 },  // Q8.8 format,   4.00dB
      {207 ,   706,1 },  // Q8.8 format,   2.76dB
      {258 ,   490,1 },  // Q8.8 format,   1.91dB
      {319 ,   335,1 },  // Q8.8 format,   1.31dB
      {398 ,   225,1 },  // Q8.8 format,   0.88dB
      {500 ,   138,1 },  // Q8.8 format,   0.54dB
      {806 ,    72,1 },  // Q8.8 format,   0.28dB
      {1338,   105,1 },  // Q8.8 format,   0.41dB
      {2278,   289,1 },  // Q8.8 format,   1.13dB
      {5318,  1034,1 },  // Q8.8 format,   4.04dB
      {7680,  1365,1 },  // Q8.8 format,   5.33dB
      {7974,  1478,1 },  // Q8.8 format,   5.77dB
      {8089,  1607,1 },  // Q8.8 format,   6.28dB
      {8191,  1763,1 }   // Q8.8 format,   6.89dB
   }
};

RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_17M =
{
   49,
   {
      {0   , 27172,1 },  // Q8.8 format, 106.14dB
      {1   , 24200,1 },  // Q8.8 format,  94.53dB
      {2   , 20309,1 },  // Q8.8 format,  79.33dB
      {3   , 17881,1 },  // Q8.8 format,  69.85dB
      {4   , 16152,1 },  // Q8.8 format,  63.09dB
      {5   , 14831,1 },  // Q8.8 format,  57.93dB
      {6   , 13774,1 },  // Q8.8 format,  53.80dB
      {7   , 12902,1 },  // Q8.8 format,  50.40dB
      {8   , 12165,1 },  // Q8.8 format,  47.52dB
      {9   , 11529,1 },  // Q8.8 format,  45.04dB
      {10  , 10973,1 },  // Q8.8 format,  42.86dB
      {11  , 10480,1 },  // Q8.8 format,  40.94dB
      {12  , 10033,1 },  // Q8.8 format,  39.19dB
      {14  ,  9268,1 },  // Q8.8 format,  36.20dB
      {16  ,  8625,1 },  // Q8.8 format,  33.69dB
      {19  ,  7829,1 },  // Q8.8 format,  30.58dB
      {21  ,  7386,1 },  // Q8.8 format,  28.85dB
      {23  ,  6979,1 },  // Q8.8 format,  27.26dB
      {27  ,  6289,1 },  // Q8.8 format,  24.57dB
      {32  ,  5596,1 },  // Q8.8 format,  21.86dB
      {37  ,  5029,1 },  // Q8.8 format,  19.64dB
      {43  ,  4468,1 },  // Q8.8 format,  17.45dB
      {50  ,  3940,1 },  // Q8.8 format,  15.39dB
      {57  ,  3508,1 },  // Q8.8 format,  13.70dB
      {65  ,  3099,1 },  // Q8.8 format,  12.11dB
      {74  ,  2722,1 },  // Q8.8 format,  10.63dB
      {84  ,  2382,1 },  // Q8.8 format,   9.30dB
      {95  ,  2076,1 },  // Q8.8 format,   8.11dB
      {107 ,  1806,1 },  // Q8.8 format,   7.05dB
      {120 ,  1556,1 },  // Q8.8 format,   6.08dB
      {150 ,  1152,1 },  // Q8.8 format,   4.50dB
      {181 ,   878,1 },  // Q8.8 format,   3.43dB
      {217 ,   661,1 },  // Q8.8 format,   2.58dB
      {260 ,   494,1 },  // Q8.8 format,   1.93dB
      {311 ,   351,1 },  // Q8.8 format,   1.37dB
      {459 ,   169,1 },  // Q8.8 format,   0.66dB
      {678 ,    72,1 },  // Q8.8 format,   0.28dB
      {1445,   117,1 },  // Q8.8 format,   0.46dB
      {2826,   409,1 },  // Q8.8 format,   1.60dB
      {3197,   539,1 },  // Q8.8 format,   2.11dB
      {3523,   556,1 },  // Q8.8 format,   2.17dB
      {3610,   626,1 },  // Q8.8 format,   2.45dB
      {3689,   743,1 },  // Q8.8 format,   2.90dB
      {3763,   924,1 },  // Q8.8 format,   3.61dB
      {3833,  1168,1 },  // Q8.8 format,   4.56dB
      {3901,  1481,1 },  // Q8.8 format,   5.79dB
      {3969,  1881,1 },  // Q8.8 format,   7.35dB
      {4033,  2340,1 },  // Q8.8 format,   9.14dB
      {4095,  2884,1 }   // Q8.8 format,  11.27dB
   }
};
//XDSLRTFW-3569 End
RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_NewHYB_ABJ_Dfe17Src35Afe35_30M =
{
   50, // Number of Entries
   {
      {29  ,     3472,1 },   //Q8.8 format, 13.56 dB
      {32  ,     3162,1 },   //Q8.8 format, 12.35 dB
      {35  ,     2896,1 },   //Q8.8 format, 11.31 dB
      {39  ,     2592,1 },   //Q8.8 format, 10.13 dB
      {43  ,     2336,1 },   //Q8.8 format, 9.12 dB
      {47  ,     2115,1 },   //Q8.8 format, 8.26 dB
      {52  ,     1880,1 },   //Q8.8 format, 7.34 dB
      {57  ,     1681,1 },   //Q8.8 format, 6.57 dB
      {63  ,     1480,1 },   //Q8.8 format, 5.78 dB
      {69  ,     1312,1 },   //Q8.8 format, 5.12 dB
      {75  ,     1169,1 },   //Q8.8 format, 4.57 dB
      {82  ,     1029,1 },   //Q8.8 format, 4.02 dB
      {89  ,      911,1 },   //Q8.8 format, 3.56 dB
      {97  ,      798,1 },   //Q8.8 format, 3.12 dB
      {105 ,      704,1 },   //Q8.8 format, 2.75 dB
      {114 ,      616,1 },   //Q8.8 format, 2.40 dB
      {124 ,      531,1 },   //Q8.8 format, 2.08 dB
      {146 ,      398,1 },   //Q8.8 format, 1.55 dB
      {172 ,      295,1 },   //Q8.8 format, 1.15 dB
      {202 ,      217,1 },   //Q8.8 format, 0.85 dB
      {241 ,      154,1 },   //Q8.8 format, 0.60 dB
      {285 ,      113,1 },   //Q8.8 format, 0.44 dB
      {341 ,       85,1 },   //Q8.8 format, 0.33 dB
      {410 ,       73,1 },   //Q8.8 format, 0.29 dB
      {489 ,       73,1 },   //Q8.8 format, 0.29 dB
      {727 ,      130,1 },   //Q8.8 format, 0.51 dB
      {1077,      242,1 },   //Q8.8 format, 0.94 dB
      {1500,      451,1 },   //Q8.8 format, 1.76 dB
      {1840,      598,1 },   //Q8.8 format, 2.34 dB
      {2262,      808,1 },   //Q8.8 format, 3.16 dB
      {2578,      906,1 },   //Q8.8 format, 3.54 dB
      {2918,     1051,1 },   //Q8.8 format, 4.11 dB
      {3011,     1066,1 },   //Q8.8 format, 4.16 dB
      {3264,     1088,1 },   //Q8.8 format, 4.25 dB
      {3328,     1123,1 },   //Q8.8 format, 4.39 dB
      {3387,     1171,1 },   //Q8.8 format, 4.57 dB
      {3456,     1264,1 },   //Q8.8 format, 4.94 dB
      {3520,     1394,1 },   //Q8.8 format, 5.45 dB
      {3580,     1558,1 },   //Q8.8 format, 6.08 dB
      {3641,     1771,1 },   //Q8.8 format, 6.92 dB
      {3701,     2029,1 },   //Q8.8 format, 7.93 dB
      {3760,     2328,1 },   //Q8.8 format, 9.09 dB
      {3815,     2644,1 },   //Q8.8 format, 10.33 dB
      {3932,     3360,1 },   //Q8.8 format, 13.12 dB
      {3959,     3508,1 },   //Q8.8 format, 13.70 dB
      {3984,     3637,1 },   //Q8.8 format, 14.21 dB
      {4014,     3765,1 },   //Q8.8 format, 14.71 dB
      {4041,     3852,1 },   //Q8.8 format, 15.05 dB
      {4068,     3908,1 },   //Q8.8 format, 15.26 dB
      {4095,     3923,1 },   //Q8.8 format, 15.32 dB
   }
};

// ##A21####A21####A21####A21## New LIF Hybrid Table ##A21####A21####A21####A21##  END


// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##  START
RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_35M_A21 =
{
  48,
   {
      {0   , 29858,1 },
      {1   , 28858,1 },
      {2   , 24976,1 },
      {3   , 22550,1 },
      {4   , 20817,1 },
      {5   , 19489,1 },
      {6   , 18422,1 },
      {7   , 17539,1 },
      {8   , 16789,1 },
      {9   , 16140,1 },
      {10  , 15571,1 },
      {11  , 15065,1 },
      {12  , 14604,1 },
      {14  , 13816,1 },
      {15  , 13474,1 },
      {17  , 12851,1 },
      {20  , 12063,1 },
      {24  , 11211,1 },
      {27  , 10676,1 },
      {30  , 10199,1 },
      {33  , 9774,1 },
      {37  , 9259,1 },
      {45  , 8411,1 },
      {53  , 7727,1 },
      {62  , 7084,1 },
      {73  , 6440,1 },
      {85  , 5867,1 },
      {98  , 5359,1 },
      {112 , 4910,1 },
      {128 , 4493,1 },
      {145 , 4134,1 },
      {163 , 3828,1 },
      {183 , 3557,1 },
      {205 , 3305,1 },
      {257 , 2911,1 },
      {310 , 2669,1 },
      {374 , 2481,1 },
      {454 , 2346,1 },
      {557 , 2233,1 },
      {856 , 2134,1 },
      {1332, 2141,1 },
      {2221, 2308,1 },
      {5314, 3039,1 },
      {6281, 3184,1 },
      {7687, 3337,1 },
      {7977, 3464,1 },
      {8092, 3586,1 },
      {8191, 3738,1 }
   }
};

RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_17M_A21 =
{
  50,
   {
      {0   , 28849,1 },
      {1   , 28849,1 },
      {2   , 24967,1 },
      {3   , 22541,1 },
      {4   , 20809,1 },
      {5   , 19480,1 },
      {6   , 18414,1 },
      {7   , 17530,1 },
      {8   , 16780,1 },
      {9   , 16131,1 },
      {10  , 15562,1 },
      {11  , 15049,1 },
      {13  , 14184,1 },
      {14  , 13811,1 },
      {16  , 13138,1 },
      {19  , 12299,1 },
      {23  , 11395,1 },
      {28  , 10489,1 },
      {34  , 9623,1 },
      {40  , 8913,1 },
      {47  , 8222,1 },
      {55  , 7565,1 },
      {64  , 6951,1 },
      {74  , 6382,1 },
      {85  , 5863,1 },
      {96  , 5428,1 },
      {108 , 5025,1 },
      {122 , 4635,1 },
      {136 , 4317,1 },
      {152 , 3996,1 },
      {188 , 3487,1 },
      {222 , 3164,1 },
      {261 , 2901,1 },
      {308 , 2686,1 },
      {362 , 2520,1 },
      {431 , 2386,1 },
      {512 , 2276,1 },
      {723 , 2143,1 },
      {1451, 2152,1 },
      {2826, 2436,1 },
      {3197, 2565,1 },
      {3511, 2578,1 },
      {3600, 2638,1 },
      {3682, 2753,1 },
      {3758, 2933,1 },
      {3829, 3175,1 },
      {3900, 3498,1 },
      {3967, 3889,1 },
      {4033, 4361,1 },
      {4095, 4905,1 }
   }
};

RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_8M_A21 =
{
  50,
   {
      {0   , 28949,1 },
      {1   , 28849,1 },
      {2   , 24967,1 },
      {3   , 22541,1 },
      {4   , 20809,1 },
      {5   , 19480,1 },
      {6   , 18414,1 },
      {7   , 17530,1 },
      {8   , 16780,1 },
      {9   , 16131,1 },
      {10  , 15562,1 },
      {11  , 15051,1 },
      {13  , 14173,1 },
      {16  , 13133,1 },
      {19  , 12301,1 },
      {23  , 11394,1 },
      {28  , 10491,1 },
      {34  , 9620,1 },
      {41  , 8805,1 },
      {48  , 8135,1 },
      {56  , 7493,1 },
      {65  , 6890,1 },
      {75  , 6333,1 },
      {86  , 5822,1 },
      {97  , 5393,1 },
      {110 , 4971,1 },
      {124 , 4579,1 },
      {155 , 3946,1 },
      {192 , 3451,1 },
      {230 , 3114,1 },
      {274 , 2849,1 },
      {329 , 2639,1 },
      {393 , 2489,1 },
      {477 , 2378,1 },
      {578 , 2297,1 },
      {822 , 2296,1 },
      {1264, 2505,1 },
      {1510, 2671,1 },
      {2123, 3181,1 },
      {2847, 3853,1 },
      {3189, 4215,1 },
      {3492, 4438,1 },
      {3587, 4551,1 },
      {3670, 4715,1 },
      {3748, 4941,1 },
      {3822, 5232,1 },
      {3895, 5607,1 },
      {3963, 6043,1 },
      {4031, 6569,1 },
      {4095, 7172,1 }
   }
};
// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##  END


DATA_MAP_END;
//XDSLRTFW-2059 (Start)
DATA_MAP_COMMON_COMP_TABLE
//XDSLRTFW-3678 Start
//XDSLRTFW-3715
//XDSLRTFW-3746 Tx PSD compensation table based on new POFI config
PSDCompDescriptorTable_t gt_PSDCompDescriptorTable[TX_PSD_COMPENSATION_TABLE_SIZE] = {

   /*gt_UsPsdCompData.us_TxIIRFilter = 0(UnityTxIIR -1) :POFI Cut off =26700KHz USx Bands = [ 6 60] [870 1206][1970 3242]*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -3},{1970, -4},{2279, -5},{3242, -8}}}, /*   0 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -4},{2593, -6},{3242, -8}}}, /*   1 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -4},{2592, -5},{3242, -7}}}, /*   2 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -4},{2592, -5},{3242, -7}}}, /*   3 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2591, -5},{3242, -7}}}, /*   4 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2591, -5},{3242, -6}}}, /*   5 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2590, -5},{3242, -6}}}, /*   6 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2590, -4},{3242, -6}}}, /*   7 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2589, -4},{3242, -6}}}, /*   8 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2589, -4},{3242, -6}}}, /*   9 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -2},{1970, -3},{2589, -4},{3242, -6}}}, /*  10 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1206, -3},{1970, -4},{2278, -5},{3242, -9}}}, /*  11 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1038, -2},{1206, -3},{1970, -5},{3242,-10}}}, /*  12 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1038, -3},{1206, -3},{1970, -5},{3242,-11}}}, /*  13 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1038, -3},{1206, -3},{1970, -6},{3242,-12}}}, /*  14 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -2},{1038, -3},{1206, -3},{1970, -6},{3242,-14}}}, /*  15 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -3},{1038, -3},{1206, -4},{1970, -7},{3242,-16}}}, /*  16 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -3},{1037, -3},{1206, -4},{1970, -8},{3242,-18}}}, /*  17 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -3},{1037, -4},{1206, -5},{1970, -9},{3242,-21}}}, /*  18 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 21, -2},{ 28,  0},{ 60,  0},{870, -3},{1037, -4},{1206, -5},{1970,-11},{3242,-24}}}, /*  19 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /*gt_UsPsdCompData.us_TxIIRFilter = 1(gula_TxIIR_POTS_17M_Filter) :POFI Cut off =26700KHz USx Bands = [ 6 32] [870 1206][1970 3242]*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -4},{2504, -6},{2844, -6},{3242, -9}}},/*  20 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -4},{2504, -6},{2844, -6},{3242, -8}}},/*  21 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -4},{2504, -6},{2844, -5},{3242, -8}}},/*  22 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2504, -5},{2844, -5},{3242, -8}}},/*  23 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2504, -5},{2844, -5},{3242, -7}}},/*  24 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2504, -5},{2844, -5},{3242, -7}}},/*  25 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  26 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  27 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  28 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  29 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -3},{2496, -5},{2844, -4},{3242, -6}}},/*  30 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -4},{2504, -7},{2844, -7},{3242,-10}}},/*  31 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -3},{1206, -3},{1970, -5},{2504, -7},{2844, -7},{3242,-11}}},/*  32 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -4},{1206, -3},{1970, -5},{2504, -8},{2836, -8},{3242,-12}}},/*  33 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -4},{1206, -4},{1970, -6},{2504, -9},{2836, -9},{3242,-13}}},/*  34 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -4},{1206, -4},{1970, -6},{2504,-10},{2836,-11},{3242,-15}}},/*  35 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -4},{1206, -4},{1970, -7},{2504,-11},{2836,-12},{3242,-17}}},/*  36 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -4},{1206, -4},{1970, -8},{2504,-13},{2836,-14},{3242,-19}}},/*  37 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -4},{1206, -5},{1970, -9},{2504,-14},{2836,-16},{3242,-22}}},/*  38 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 19, -4},{ 32,-16},{870, -5},{1206, -6},{1970,-11},{2504,-17},{2836,-19},{3242,-25}}},/*  39 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /*gt_UsPsdCompData.us_TxIIRFilter = 2(gula_TxIIR_2XPOTS_17M_Filter) :POFI Cut off =26700KHz USx Bands = [ 6 60] [870 1206][1970 3242]*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206,  0},{1970, -2},{2504, -4},{2844, -4},{3242, -7}}},/*  40 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2504, -4},{2844, -3},{3242, -6}}},/*  41 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2504, -3},{2844, -3},{3242, -6}}},/*  42 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2504, -3},{2844, -3},{3242, -5}}},/*  43 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2504, -3},{2844, -2},{3242, -5}}},/*  44 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2504, -3},{2844, -2},{3242, -5}}},/*  45 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2504, -3},{2844, -2},{3242, -4}}},/*  46 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2496, -2},{2844, -2},{3242, -4}}},/*  47 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2496, -2},{2844, -2},{3242, -4}}},/*  48 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2496, -2},{2844, -2},{3242, -4}}},/*  49 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  1},{1206,  0},{1970, -1},{2496, -2},{2844, -2},{3242, -4}}},/*  50 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206,  0},{1970, -2},{2504, -4},{2844, -4},{3242, -7}}},/*  51 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206,  0},{1970, -2},{2504, -5},{2844, -5},{3242, -8}}},/*  52 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206, -1},{1970, -3},{2504, -6},{2844, -6},{3242, -9}}},/*  53 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206, -1},{1970, -3},{2504, -6},{2836, -7},{3242,-11}}},/*  54 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206, -1},{1970, -4},{2504, -7},{2836, -8},{3242,-12}}},/*  55 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206, -1},{1970, -5},{2504, -9},{2836,-10},{3242,-14}}},/*  56 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870,  0},{1206, -2},{1970, -6},{2504,-10},{2836,-12},{3242,-17}}},/*  57 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870, -1},{1206, -2},{1970, -7},{2504,-12},{2836,-14},{3242,-19}}},/*  58 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16,-12},{ 19, -7},{ 60,-14},{870, -1},{1206, -3},{1970, -8},{2504,-14},{2836,-17},{3242,-23}}},/*  59 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /*gt_UsPsdCompData.us_TxIIRFilter = 3(gula_TxIIR_ISDN_17M_Filter) :POFI Cut off =26700KHz USx Bands = [32 60] [870 1206][1970 3242]*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -4},{2504, -6},{2844, -6},{3242, -9}}},/*  60 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -4},{2504, -6},{2844, -6},{3242, -8}}},/*  61 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -4},{2504, -6},{2844, -5},{3242, -8}}},/*  62 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -3},{2504, -5},{2844, -5},{3242, -8}}},/*  63 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -3},{2504, -5},{2844, -5},{3242, -7}}},/*  64 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -3},{2496, -5},{2844, -5},{3242, -7}}},/*  65 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -2},{1970, -3},{2496, -5},{2844, -5},{3242, -7}}},/*  66 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -2},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  67 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -2},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  68 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -2},{1970, -3},{2496, -5},{2844, -4},{3242, -7}}},/*  69 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -2},{1970, -3},{2496, -5},{2844, -4},{3242, -6}}},/*  70 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -4},{2504, -7},{2844, -7},{3242,-10}}},/*  71 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -5},{2504, -7},{2844, -7},{3242,-11}}},/*  72 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -5},{2504, -8},{2836, -8},{3242,-12}}},/*  73 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -3},{1970, -6},{2504, -9},{2836, -9},{3242,-13}}},/*  74 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -4},{1970, -6},{2504,-10},{2836,-11},{3242,-15}}},/*  75 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -3},{1206, -4},{1970, -7},{2504,-11},{2836,-12},{3242,-17}}},/*  76 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -4},{1206, -4},{1970, -8},{2504,-13},{2836,-14},{3242,-19}}},/*  77 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -4},{1206, -5},{1970, -9},{2504,-15},{2836,-16},{3242,-22}}},/*  78 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -5},{ 41,  1},{ 60, -3},{870, -4},{1206, -6},{1970,-11},{2504,-17},{2836,-19},{3242,-25}}},/*  79 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /*gt_UsPsdCompData.us_TxIIRFilter = 4(gula_TxIIR_LP_17MHz_VDSL35B) :POFI Cut off =26700KHz USx Bands = [ 6 32] [870 1206][1970 2784]*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -5},{2784, -7}}},/*  80 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -5},{2784, -6}}},/*  81 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -5},{2784, -6}}},/*  82 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1040, -2},{1206, -2},{1970, -4},{2518, -4},{2784, -5}}},/*  83 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1040, -2},{1206, -2},{1970, -3},{2518, -4},{2784, -5}}},/*  84 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1040, -2},{1206, -2},{1970, -3},{2518, -4},{2784, -5}}},/*  85 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1044, -2},{1206, -2},{1970, -3},{2518, -4},{2784, -5}}},/*  86 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1044, -2},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/*  87 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1044, -1},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/*  88 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1044, -1},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/*  89 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -1},{1044, -1},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/*  90 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -6},{2784, -7}}},/*  91 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -2},{1970, -5},{2511, -6},{2784, -8}}},/*  92 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -2},{1970, -5},{2509, -7},{2784, -9}}},/*  93 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -3},{1970, -6},{2504, -8},{2784,-10}}},/*  94 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -2},{1206, -3},{1970, -6},{2504, -9},{2784,-11}}},/*  95 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -3},{1206, -3},{1970, -7},{2500,-10},{2784,-12}}},/*  96 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -2},{1040, -3},{1206, -4},{1970, -8},{2500,-12},{2784,-14}}},/*  97 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -3},{1040, -3},{1206, -4},{1970, -9},{2494,-13},{2784,-16}}},/*  98 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 22, -2},{ 32,  0},{870, -3},{1040, -4},{1206, -5},{1970,-11},{2493,-16},{2784,-19}}},/*  99 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /*gt_UsPsdCompData.us_TxIIRFilter = 5(gula_TxIIR_LP_17MHz_VDSL35B) :POFI Cut off =26700KHz USx Bands = [ 6 60] [870 1206][1970 2784]*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -5},{2784, -7}}},/* 100 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -5},{2784, -6}}},/* 101 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -5},{2784, -6}}},/* 102 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1040, -2},{1206, -2},{1970, -4},{2518, -4},{2784, -5}}},/* 103 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1040, -2},{1206, -2},{1970, -3},{2518, -4},{2784, -5}}},/* 104 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1040, -2},{1206, -2},{1970, -3},{2518, -4},{2784, -5}}},/* 105 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1044, -2},{1206, -2},{1970, -3},{2518, -4},{2784, -5}}},/* 106 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1044, -2},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/* 107 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1044, -1},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/* 108 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1044, -1},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/* 109 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -1},{1044, -1},{1206, -2},{1970, -3},{2520, -4},{2784, -5}}},/* 110 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -2},{1970, -4},{2514, -6},{2784, -7}}},/* 111 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -2},{1970, -5},{2511, -6},{2784, -8}}},/* 112 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -2},{1970, -5},{2509, -7},{2784, -9}}},/* 113 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -3},{1970, -6},{2504, -8},{2784,-10}}},/* 114 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -2},{1206, -3},{1970, -6},{2504, -9},{2784,-11}}},/* 115 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -3},{1206, -3},{1970, -7},{2500,-10},{2784,-12}}},/* 116 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -2},{1040, -3},{1206, -4},{1970, -8},{2500,-12},{2784,-14}}},/* 117 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -3},{1040, -3},{1206, -4},{1970, -9},{2494,-13},{2784,-16}}},/* 118 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 16, -6},{ 28,  0},{ 60,  0},{870, -3},{1040, -4},{1206, -5},{1970,-11},{2493,-16},{2784,-19}}},/* 119 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /*gt_UsPsdCompData.us_TxIIRFilter = 6(gula_TxIIR_isdn_17MHz_VDSL35B) :POFI Cut off =26700KHz USx Bands = [32 60] [870 1206][1970 2784]*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -4},{1970, -7},{2628, -8},{2784, -9}}},/* 120 POFI_Gain=  0dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -4},{1206, -4},{1970, -6},{2628, -7},{2784, -9}}},/* 121 POFI_Gain= -1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -7},{2784, -8}}},/* 122 POFI_Gain= -2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -7},{2784, -8}}},/* 123 POFI_Gain= -3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -8}}},/* 124 POFI_Gain= -4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -8}}},/* 125 POFI_Gain= -5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -8}}},/* 126 POFI_Gain= -6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -7}}},/* 127 POFI_Gain= -7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -7}}},/* 128 POFI_Gain= -8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -7}}},/* 129 POFI_Gain= -9dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -3},{1023, -3},{1206, -4},{1970, -6},{2628, -6},{2784, -7}}},/* 130 POFI_Gain=-10dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -4},{1970, -7},{2628, -8},{2784,-10}}},/* 131 POFI_Gain=  1dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -4},{1970, -7},{2628, -9},{2784,-10}}},/* 132 POFI_Gain=  2dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -4},{1970, -8},{2628, -9},{2784,-11}}},/* 133 POFI_Gain=  3dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -5},{1970, -8},{2628,-10},{2784,-12}}},/* 134 POFI_Gain=  4dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -5},{1970, -9},{2628,-11},{2784,-13}}},/* 135 POFI_Gain=  5dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -4},{1206, -5},{1970,-10},{2628,-13},{2784,-15}}},/* 136 POFI_Gain=  6dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -4},{1023, -5},{1206, -6},{1970,-11},{2613,-14},{2784,-17}}},/* 137 POFI_Gain=  7dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -5},{1023, -5},{1206, -6},{1970,-12},{2613,-16},{2784,-19}}},/* 138 POFI_Gain=  8dB {FreqBin,GaindB 0.1dB steps}*/
   {{{ 32, -2},{ 44,  1},{ 60,  0},{870, -5},{1023, -6},{1206, -7},{1970,-13},{2613,-19},{2784,-22}}},/* 139 POFI_Gain=  9dB {FreqBin,GaindB 0.1dB steps}*/

   /* US0 only Filters compensation functions*/
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 140 US0Only_POTS_17m12m8m              Fc = 80KHz  POFI gain = 7dB(POCO1= 0036) */
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 141 US0Only_oISDN_17m12m8m             Fc = 320KHz POFI gain = 8dB(POCO1= 0026) */
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 142 US0Only_POTSDOUBLE_17m12m8m (eu64) Fc = 320KHz POFI gain = 6dB(POCO1= 0096)*/
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 143 US0Only_POTSQUAD_17m12m8m (eu128)  Fc = 552KHz POFI gain = 2dB(POCO1= 0076)*/
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 144 US0Only_POTS_35b                   Fc = 80KHz  POFI gain = 6dB(POCO1= 0036)*/
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 145 US0Only_ISDN_35b //XDSLRTFW-3570   Fc = 320KHz POFI gain = 6dB(POCO1= 0036)*/
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}},  /* 146 US0Only_POTSDOUBLE_35b(eu64)       Fc = 320KHz POFI gain = 0dB(POCO1= 0096)*/
   {{{2,0},    {8,0},   {12,0},  {34,0},  {60,0},  {65,0},  {80,0},  {127,0}, {130,0}}}   /* 147ForFuture US0Only_POTSQUAD_35b(eu128)Fc = 552KHz POFI gain = 2dB(POCO1= 0076) */
};
//XDSLRTFW-3678 End

DATA_MAP_END;
//XDSLRTFW-3715 End
//XDSLRTFW-2059 (End)

UsTssiPSDDescriptorTable_t gt_UsTSSIPSDDescriptorTable;



FlagT gft_EnableRxPathCorrection = TRUE;
FlagT gft_DisallowInbandTssi = 1;
FlagT gft_disable_tx_tssi;
int16 gs_interp_psd_with_tssi;
DATA_DILVB_BEGIN

UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_new;

// XDSLRTFW-232 (Start)
// For  debugging purpose
PSDDescriptorTable_t gt_DBG_UsTSSIPSDDescriptorTable =
{

// Flat signal psd 0-6
 12,
   {
      {0   ,000,1}, //00.0 dB, in unit of 0.1 dB
      {6   ,000,1}, //00.0 dB, in unit of 0.1 dB
      {8   ,000,1}, //00.0 dB, in unit of 0.1 dB
      {32  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {33  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {40  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {42  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {44  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {56  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {57  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {60  ,000,1}, //00.0 dB, in unit of 0.1 dB
      {64  ,000,1}  //00.0 dB, in unit of 0.1 dB
   }
};

PSDDescriptorTable_t gt_Shape_UsTSSIPSDDescriptorTable =
{

// Tx-Lower and upper tones are  TSSI-shaped
 7,
   {
      {0   ,60  ,1}, //6.0 dB,  in unit of 0.1 dB
      {4   ,60  ,1}, //6.0 dB,  in unit of 0.1 dB
      {5   ,0  ,1},  //00.0 dB, in unit of 0.1 dB
      {32  ,0  ,1},  //00.0 dB, in unit of 0.1 dB
      {36  ,0  ,1},  //00.0 dB, in unit of 0.1 dB
      {54  ,620 ,1},  //62.0  dB,in unit of 0.1 dB
      {64  ,620 ,1}  //62.0  dB,in unit of 0.1 dB
   }
};
// XDSLRTFW-232 (End)

// This array shows the freq-response of TX path from Strymon input to AFE output, measured for VR9 POTS LIF
UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_POTS =
{
   12,
   {
      {1, 494, 1}, //49.4 dB, in unit of 0.1 dB
      {5, 172, 1},
      {8, 27, 1},
      {21, 0, 1},
      {25, 0, 1},
      {35, 17, 1},
      {43, 59, 1},
      {50, 129, 1},
      {55, 216,  1},
      {58, 327, 1},
      {64, 220, 1},
      {65, 0, 1}
   }
};


// This array shows the freq-response of TX path from Strymon input to AFE output,measured for VR9 ISDN LIF
UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_ISDN =
{
   10,
   {
      {11, 420, 1}, //42 dB, in unit of 0.1 dB
      {18, 220, 1},
      {25, 86, 1},
      {32, 5, 1},
      {37, -8, 1},
      {44, -7, 1},
      {46, 0, 1},
      {65, 0, 1},
      {96, 6, 1},
      {97, 0, 1}
   }
};




//The digital filter is a unity one + 25k-17M LIF.
UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_Transparent =
{
   6,
   {
      {1, 5*43, 1},
      {3, 5*19, 1},
      {7, 5*8,  1},
      {14, 5*2, 1},
      {31, 5*0, 1},
      {65, 5*0, 1},
   }
};

DATA_MAP_END;


//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)

//=============================================================================
// virtual noise status flag variable
//=============================================================================
FlagT gft_DSVirtualNoiseStatus;
FlagT gft_USVirtualNoiseStatus;
FlagT gft_VirtualNoiseStatus_save;
FlagT gft_OldVNPsdFormat;
//=============================================================================

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

int16 gs_min_atten_dB;
int16 gs_MaxUsPsdCompensation = 0;

// ProfileControl
ProfileControl_t   gt_ProfileControl;

//==============================================================================
// Modem Actual Variables
//==============================================================================
// Actual Profile Selected
ProfileActual_t   gt_ProfileAct;

// Actual TPS-TC Bearer Channel Parameters negotiated between VTU-R and VTU-O
TPS_TC_BearerChanAct_t gta_DsBearerChanAct[NUM_BEARER_CHANNELS];
TPS_TC_BearerChanAct_t gta_UsBearerChanAct[NUM_BEARER_CHANNELS];

// Actual PMS latency path parameters negotiated between VTU-R and VTU-O
PMS_TC_LatencyPathAct_t gta_DsLpAct[NUM_DATA_PATHS];
PMS_TC_LatencyPathAct_t gta_UsLpAct[NUM_DATA_PATHS];
uint8 guc_DsOneOverSmaxAct;
uint8 guc_DsMinMsgOHRAct;            //in unit of kbps
uint8 guc_DsDynamicInlvEnableAct;      //1: enable, 0: disable
uint8 guc_UsOneOverSmaxAct;
uint8 guc_UsMinMsgOHRAct;            //in unit of kbps
uint8 guc_UsDynamicInlvEnableAct;      //1: enable, 0: disable


// Band Actual variables
BandDescriptorTable_t   gt_TxBandControl_Act;
BandDescriptorTable_t   gt_RxBandControl_Act;
RFIBandDescriptorTable_t gt_RFIBandControl_Act;

// PSD Actual Variables
#if defined(VR9_SAVE_CDPSD)
DsRefPSDDescriptorTable_t gt_DsCDPSDDescriptorTable;
UsPSDDescriptorTable_t    gt_UsCDPSDDescriptorTable;
#endif
//Moving to ONE_PORT_SHOW_ONLY memory section (Vr9_1port_debug_data.c)
//to make space in MAIN_BULK memory section
#ifndef VECTORING_MEM_LYT
DsRefPSDDescriptorTable_t gt_DsREFPSDDescriptorTable;
UsPSDDescriptorTable_t    gt_UsREFPSDDescriptorTable;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
DsVnPSDDescriptorTable_t    gt_DS_RefVirtNoiseLevel_VDSL2; // Field16 of O-SIG

UsVnPSDDescriptorTable_t    gt_US_RefVirtNoiseLevel_VDSL2; // Field18 of O-SIG
#endif

// LATN, SATN and SNRM per Rx band
AttenSnrMPerRxBand_t gt_AttenSnrMPerRxBand;
AttenSnrMPerRxBand_t gt_AttenSnrMPerRxBand_FE;

CustomerIOPBits_t gt_CustomerIopBits;

//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)
Dsl_Operator_Select_t gt_Dsl_Operator_Select;
//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (End)

//XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2
uint16 gus_TcModeUsed_PPE;

//XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START_END)
uint16 gus_DSL_FW_InternalControl;

//XDSLRTFW-1924 (Start_End)
uint16 gus_curr_TC_mode_value;

//================================================================
// Algorithm Handlers variables:
//================================================================
int16 gs_AlgHandlerState, gs_AlgHandlerCount;
int16 gs_AlgNumFramesToAccum, gs_AlgLog2NumFramesToAccum;
int16 gs_AlgNumTonesToProcess;
int16 *gpsa_AlgMsrdBuffer;

//================================================================
//PSD Control variables
//================================================================

TxPsdControl_t gt_TxPsdControl;
UPBOControl_t gt_UPBOControl;

int16 gs_Kl0Threshold_LimitUsCeiling = 0x7FFF;      // loop length limit in 0.1 dB (where kl0 of 9.5 dB is about 1000ft)
int16 gs_DeltaUsPsdCeilValue;                       // max. PSD difference between US0 and max USx working variabe,         format [0.1 dB]
int16 gs_DeltaUsPsdCeilValue_ChDis;                 // max. PSD difference between US0 and max USx at discovery phase,      format [0.1 dB]
int16 gs_DeltaUsPsdCeilValue_TrTrain;               // max. PSD difference between US0 and max USx at transceiver training, format [0.1 dB]
int16 gs_AppliedUpboCeiling;

int16 gs_Us0Ds1PsdDiff;
FlagT gft_EnableUS0PsdCut = 0;                  //if set to 1 enable US0 PSD reduction feature
FlagT gft_IOP_UPBO_FEXT;// IOP fixes for UPBO FEXT : Enabled if 1
int16 gsa_IOP_LATN_Kl0[10];// IOP fixes for LATN and Kl0

uint8 guc_ClearTransmitGainsState;
uint8 guc_SetTransmitGainsState;
uint8 guc_LoadTransmitGainsState;


//================================================================
//Detect signal onset
//================================================================
FlagT gft_EnableMultiBandSigDetect = TRUE; // If set to FALSE, signal detection is done only on the first band (i.e. the old way)
int16 gs_NumChannels[MAX_NUM_RX_BANDS];
int16 gs_PowInnerRshCnt[MAX_NUM_RX_BANDS];
int16 gs_SigPowerScale;
int32 gl_SigPower;
int32 gl_SigPowThresh;
int32 gl_SigPowThreshPerBand[MAX_NUM_RX_BANDS];
int16 gs_SigDetectBandIdx;



//================================================================
//Frame alignment variables
//================================================================

FrameAlignConfig_t gt_FrameAlignConfig;

int16 gs_AlignmentOffset;
int16 gs_CumulativeAlignmentOffset;
uint8 gft_FrameAlignRemoveOutliers;
uint8 guc_FrameAlignmentState;      /* Frame Alignment status flag */
int16 gs_NumFrameAlignClusters;
int16 gs_FrameAlignIteration;
int16 gs_MaxOffsetCount;
int16 gs_MaxFAOffset_at_convergence;

//================================================================
// Medley state frame realignment
// SnrFrameAlignHandler variables:
//================================================================

SnrFrameAlignConfig_t gt_SnrFrameAlignConfig;

int16 gs_MedleyFrameSynchEnableFlag;   //TRUE: perform medley frame synch, FALSE, not perform

int16 gs_MaxMedleyAlignOffset;     // the maximum frame re-alignment offset
int16 gs_BestSynchPointIdx;         //the best frame synch point index
int16 gs_CurrSynchPointIdx;         //the current frame synch point index
int32 gl_BestSnrSum;            //the highest SNR sum

DATA_DILVB_BEGIN
int32 gla_MedleySnrSum[NUM_FRAME_REALIGNMENT_POINTS];
DATA_MAP_END;

uint8 guc_RotateFDQState;
FlagT gft_RestoreOrigFdq;
int16 gs_RxCPLength_save;
int16 gs_SyncSearchMode;

//================================================================
//FDQ variables
//================================================================

FdqConfig_t gt_FdqConfig;

int16 gsa_pre_FDQ_coef[(MAX_NUM_CHANNELS_PER_GROUP<<1)];     // FDQ coefficient mantissa (MAX_NUM_CHANNELS_PER_GROUP = NUM_CHANNELS_PER_GROUP_1024, i.e. 1024*2 16-bit words)
uint8 guca_pre_FDQ_exp[MAX_NUM_CHANNELS_PER_GROUP];          // FDQ coefficient exponent
int16 *gpsa_BitSwapGain = (int16 *)(void *)guca_pre_FDQ_exp; // buffer to store the gains affected by bitswap
//use 128 16-bit words
uint8 *gpuca_BitSwapBat = (uint8 *)&guca_pre_FDQ_exp[128*2]; // buffer to store the bits affected by bitswap

int16 gs_FDQTrainTypeCntrlFlag;
int16 gs_FDQTrainType;
uint8 guc_FdqTrainingState;                     // FDQ training status flag

//Note: this memory block is also shared by several operations
int16* gpsa_DILVB_SharedMemory;

// Used only in Medley for temporary FDQs
int16 *gpsa_MedleyTempFDQCoeffs;
uint8 *gpuca_MedleyTempFDQExps;

MfdqConfig_t gt_MfdqConfig;

#ifdef USE_MFDQ_HW_WORK_AROUND
MfdqHwWkArndConfig_t gt_MfdqHwWkArndConfig;
#endif

FlagT gft_EnableMfdq; // flag to enable/disable MFDQ training
FlagT gft_ForceMfdq; // flag to force MFDQ training
uint8 guc_MfdqTrainingState;

//================================================================
//SNR variables
//================================================================
SnrConfig_t gt_SnrConfig;
uint8 guc_SnrCalcState;
int16 *gpsa_MeasuredSnrBuf;               // pointer to measured SNRs
int16 gs_avg_snr;                     // average snr calculated in sleep.c
int16 gs_num_active_rx_ch;            // counted in sleep.c

DATA_AWRE_IBRAM_BEGIN
#ifdef VECTORING_MEM_LYT
//Vectoring merge: This variable is mapped to section TWO_PORT_SNR_BUF/AWRE_IBRAM
//and is not used in Single port mode of operation. Hence, this unused memory is
//being used to meet extra Training PM requirements.
//However, this variable/array is still kept (with lower size to take care of alignment
//of memory sections) to prevent error/warnings during compiling.
int16 gsa_SnrBuf_TwoPortMode[128];
#else
int16 gsa_SnrBuf_TwoPortMode[RX_MAX_NUM_TONES >> 1];
#endif
DATA_MAP_END;

    // for one-port mode
 DATA_ONE_PORT_SNR_BUF_BEGIN

int16 gsa_SnrBuf_OnePortMode[RX_MAX_NUM_TONES];
DATA_MAP_END;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
//Showtime SNR with Downstream Virtual Noise feature enabled
#ifndef STANDALONE_FRAMING_TEST
DATA_TWO_PORT_SHOW_ONLY_BEGIN
#endif
int8 gca_SnrBuf_WithOutVN[RX_MAX_NUM_TONES];

DATA_MAP_END;
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

//Vectoring Buffer to collect 'Constell points' data, OLR data and ERB
#ifndef STANDALONE_FRAMING_TEST
DATA_ST_VECTORING_BUFFER_BEGIN
#endif
int16 gsa_StVectoringBuffer[RX_MAX_NUM_TONES];  // Buffer for capturing 2048 (VR9, VRx318) or 4096 (VRx518) Showtime constellation points
int16 gsa_SyncSymConstelForOlr[60];             // Buffer for capturing 30 showtime OLR related constellation points
uint32 gul_SyncSybmolRef;  //Store Reference SEGUE constellation points for Showtime Sync Symbol (two bits for each constellation, only sign bit)
uint8 *gpuca_StErbBuffer; // XDSLRTFW-2049 Final ERB output buffer pointer for showtime
// Never move these variables out of IIBRAM. If moved, then ERB mechanism fails.
uint16 gsa_ERB_Part0[80];
uint16 gsa_ERB_Part1[80];
DATA_MAP_END;

//XDSLRTFW-1104 DSReTx_5sec_shine_noise (Start)
uint16 gus_FdqUpdateEnableCount = 0;
int8  gc_FdqUpdateState = 0;
int8  gc_Prev_FdqUpdateState = -1;
//XDSLRTFW-1104 DSReTx_5sec_shine_noise (End)
#ifndef STANDALONE_FRAMING_TEST
DATA_TRN_VECTORING_BUFFER_BEGIN
#endif
int16 gsa_TrnVectoringBuffer[RX_MAX_NUM_TONES]; // Buffer for capturing 2048 Training constellation error points used only in O-P Vector2 state
#ifndef STANDALONE_FRAMING_TEST
DATA_MAP_END;
#endif

DATA_PORTMODECONTROL_BEGIN
PortModeControl_t gt_PortModeControl;
DATA_MAP_END;

int16 *gsa_SnrBuf = gsa_SnrBuf_OnePortMode;     // this pointer init'ed here to support
// SW tests. It will init'ed again in
// InitGlobalVars.c and cnfg_task_postGhs.c

// gusa_ConstGainPow_dB(i) = 20*log10(const_gain_i/const_gain_2)
int16 gusa_ConstGainPow_dB[RX_MAX_BITS_PER_TONE+1] =
{
   0,
   CONST_GAIN_POW2_DB,
   CONST_GAIN_POW2_DB,
   CONST_GAIN_POW3_DB,
   CONST_GAIN_POW4_DB,
   CONST_GAIN_POW5_DB,
   CONST_GAIN_POW6_DB,
   CONST_GAIN_POW7_DB,
   CONST_GAIN_POW8_DB,
   CONST_GAIN_POW9_DB,
   CONST_GAIN_POW10_DB,
   CONST_GAIN_POW11_DB,
   CONST_GAIN_POW12_DB,
   CONST_GAIN_POW13_DB,
   CONST_GAIN_POW14_DB,
   CONST_GAIN_POW15_DB
};

//================================================================
//PSD variables
//================================================================

PsdConfig_t gt_PsdConfig;

uint8 guc_PsdCalcState;
uint8 guc_QlnCalcState;

int8 gc_Log2NumFramesToAccumForPGA;

//================================================================
//Timing advance variables
//================================================================
int16 gs_TimingAdvanceHandlerState;  // dedicated state variable for TimingAdvanceHandler
int16 gs_TimingAdvanceFixedDelay;    // Sum of const TX and RX filter delay (in samples at 4096 IDFT sample rate)
int16 gs_TimingAdvanceTxIirDelay;    // TX IIR filter delay                 (in samples at 4096 IDFT sample rate)
int16 gs_TimingAdvanceRxIirDelay;    // RX IIR filter delay                 (in samples at 4096 IDFT sample rate)
int16 gs_TargetTimingAdvance;        // current targeted timing advance value
int16 gs_TimingAdvance;              // number of TX timing advance (in samples)
int16 gs_TimingAdvance_sav;
int16 gs_TimingAdvanceOffset;        // Additional offset for IOP fixes
int16 gs_TxTimerVal;                 // Variables used to measure tx/rx timers
int16 gs_RxTimerVal;
int32 gl_txRxFrameOffset;
int16 gs_ReduceInitFrameOffsetCnt;
int16 gs_RemoteTxCPLength;           // TX CP length of the remote modem
int16 gs_RemoteTxBetaLength;         // TX window length (beta) of the remote modem

int16 gs_TimingAdvanceTrailIndex;
int16 gsa_TaActualTrail[MAX_NUM_TA_ITERATIONS];         //Actual Timing Advance applied
int16 gsa_TaAdjustTrail[MAX_NUM_TA_ITERATIONS];         //trail of TimingAdvance adjustments
int16 gsa_TaTargetTrail[MAX_NUM_TA_ITERATIONS];         //trail of the targeted timing advance to be met
int16 gsa_TaActualTrailPre[MAX_NUM_TA_ITERATIONS];      //Actual Timing Advance applied
int16 gsa_TaAdjustTrailPre[MAX_NUM_TA_ITERATIONS];       //trail of TimingAdvance adjustments
int16 gs_DbgFrameSkewErrorIndex;
int16 gs_DbgFrameSkewError;

int16 gs_EnableTaBugFix;        //if set to TRUE, use the new TA code
//where the second TA is applied 5 symbols after R-ACK

FlagT gft_SkipCpAdjust = 0;        //if set to 1, skip the CP beta adjustment in CalcTxRxFrameOffset()

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
FlagT gft_SNRM_MODE_workaround; //if set to TURE at CO side, Field#17 of O-SIGNATURE will always be 1.
//if set to TRUE at CPE side, gft_DSVirtualNoiseStatus will be 0 always.

//================================================================
// TDQ variables and flags
//================================================================

int16 gs_bypass_tdq;
int16 gs_bypass_doubletrain;
int16 gs_trysecondtrain;
int16 gs_doubletrain_decision_offset;
int16 gs_ModemHwMode;


//================================================================
// DEC variables and flags
//================================================================

FlagT gft_EnableDEC;
FlagT gft_EnableDecUpdate;


//================================================================
//Misc variables and flags
//================================================================
uint16 gus_VdslCntlFlag;      //each bit constrols different operation in training
uint16 gus_VdslStatusFlag;      //each bit indicates a operation status
int16 gs_SynchSymbolDetectCnt;   //symbol symbol detection count
FlagT gft_RegStartIfft;         //if set to 1, IFFT is configured to register start mode
FlagT gft_ReverbSegue;         //indicator of reverb or segue signal

//================================================================
// Bitloading vars:
//================================================================
FlagT gft_RestrictDpTo1=0;

BitloadParam_t gt_BitloadParam;
int32 gl_MaxLpLimit = -1;         //the maximum Lp allowed
uint16 gus_BitloadErrorCode;      // indicates bitload error codes
uint16 gus_MedleyBitloadErrorCode; // indicates bitload error codes during Medley

int16 gs_RxExtraBits;           // extra bits allocated due to use of fine gains
int16 *gpsa_RxFineGainPlusBitChannel;  // RX fine gains marker array

int16 gs_extra_snrmargin_for_low_tones;      //Extra SNR margin to use on lower band edge tones having correlated noise.
int16 gs_high_tone_for_extra_snrmargin;      //Upper tone of band edge tones having correlated noise.


DATA_DILVB_BEGIN
RxToneFlags guca_RxSupportedToneSet_temp; // One-bit-per-tone array used to indicate which tones
                                          // may be bit-loaded. Specifically, indicates the tones
                                          // that are transmitted by far end (ie. tones in Rx Band Plan)
                                          // minus tones with SNR lower than 10dB, minus blackout tones and
                                          // minus the RFI band tones.
DATA_MAP_END;

// XDSLRTFW-441 Relocating the "LOCAL_LD_ST" section to get more space for PERSISTENT Memory
//int16 gsa_ConstellationSNR[RX_MAX_BITS_PER_TONE+1];   // required SNRs for all constellation sizes without margin.
int16 gsa_SNRRequired[RX_MAX_BITS_PER_TONE+1];       // required SNRs for all constellation sizes.

uint16 gus_ncloaded;
uint16 gusa_ncloaded[MAX_NUM_RX_BANDS];      // Number of tones with bits allocated to them in each band.
int16 gs_TxMaxConstSize;                     // Maximum bits per tone allocated for TX path
int16 gs_RxMaxConstSize;                     // Maximum bits per tone allocated for RX path
int16 gs_RxMinConstSize;                     // Minimum bits per tone allocated for RX path
int16 gs_MaxToneForFast;                     // Number of tones whose bits are allocated to fast path
int16 gs_MinTargetSnrMargin;                 // Minimum target SNR margin
int16 gs_BsDecisionThreshold;                // XDSLRTFW-3807 8.8dB formated Threshold for BS decision
// !! Debug code to test maximum bits per tone per band, i.e. max constellation per band!!
int16 gsa_RxMaxConstSize[MAX_NUM_RX_BANDS];  // Maximum bits per tone per band.

int32 gl_MaxSumLpSupported;            // Maximum number of bits supported without coding gain.
int32 gl_FinalSumLp;                   // total number of bits per DMT symbol (should be less than gl_MaxSumLpSupported)
int16 gs_RxMinMargin;                  // Minimum SNR margin in Q8.8
int16 gs_RxMinMarginTone;              // Tone with the minimum SNR margin
int16 gs_RxAvFineGain;                 // Average fine gain in Q8.8
int16 gs_ExcessMarRedDB;               // Excess Margin reduction in DB (Q8.8)
int16 gs_ExcessMarFGReduction;         // Fine gain reduction in dB (Q8.8)
int16 gs_ExcessMarFGReduction_save;
// XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START_END)
int32 gl_SumMedleySNR;  //gl_Medley_maxATTNDRds;         // Medley maximum ATTNDRds estimation for Showtime ATTNDRds updating

int16 gs_MaxMarginIterations;         //the max. number of iterations allowed for margin reduction
int16 gs_min_fine_gain_MarginRed;      //the min. fine gain for margin reduction
int16 gs_MarginReductionEnableFlag;      //If set to 1, enable the code to limit the SNR margin (internal use)
int16 gs_DisableFGMarginReductionFlag;   //1: margin reduction is not controlled by the fine gain
int16 gs_ApplyMarginReduction;         //internal flag used in CalcMedleySnrMargin()
int16 gs_UnloadedToneFGreduction_dB;   //reduce the fine gain of unloaded tones, i.e. monitoring tones [Q8.8 format]

int16 gs_MedleyAvgMargin;            //Medley state average SNR margin
int16 gs_MedleyMinMargin;            //Medley state average SNR margin
int16 gs_MedleyMinMarginTone;         //the tone which has the lowest margin at Medley state
int16 gs_MedleyAvgFineGain;            //Medley state average fine gain
int16 gs_CurRxBand_save;
int16 gs_ch_save;

uint32 gul_NOMATP_linear;            //linear nominal aggregate transmit power computed in bitloading
uint32 gul_NOMATP_linear_lw;         //Lower word of linear NOMATP
uint32 gul_NOMATP_linear_hw;         //High word of linear NOMATP
uint32 gul_MAXNOMATP_linear_lw;         //Lower word linear maximum NOMATP to compare with
uint32 gul_MAXNOMATP_linear_hw;         //High word linear maximum NOMATP to compare with
int16 gs_NOMATP_dBm;               //NOMATP in dBm as defined in the standard
int16 gs_MAXNOMATP_dBm;               //MAXNOMATP in dBm as defined in the standard
int16 gs_MedleyNOMATP_dBm;            //NOMATP in dBm of the remote modem sent during Medley state
int16 gs_PreMarginRedNOMATP_dBm;      //NOMATP in dBm prior to SNR margin reduction
int16 gs_PsdOffset_dB;               //the PSD offset in MREFPSD
int16 gs_LogSubCarrierSpace;         //10log(4312.5)*10 or 10log(4312.5*2)*10
FlagT gft_MAXNOMATP_Flag;            //if set to 1, impose the MAXNOMATP limit
FlagT gft_UpdateNomAtp_Flag;

#ifdef SNRMARGIN_DEBUG
int16 gs_AvFineGain_Pre;            //Average fine gain prior to the margin reduction in dB (Q8.8)
int16 gs_AvFineGain_after;            //Average fine gain after the margin reduction in dB (Q8.8)
int16 gs_AvSnrMargin_Pre;            //Average SNR prior to the margin reduction in dB (Q8.8)
int16 gs_AvSnrMargin_after;            //Average SNR after the margin reduction in dB (Q8.8)
int16 gs_MaxSnrMargin;
int16 gs_MinSnrMargin;
int16 gs_LimitByMinGain;
int16 gs_LimitByMinMargin;
#endif //#ifdef SNRMARGIN_DEBUG
FlagT gft_SaveMarginPerTone;         // debug flag to force SNR update to store margin rather than SNR
// and disable subsequent SNR calculations.

FlagT gft_BitloadOK;                   // Indicates whether bit loading SUCCEEDED or FAILED.
FlagT gft_FineGainOn;                  // Indicates if fine gain should be used (TRUE) or not (FALSE).
FlagT gft_TxTcmFlag;
FlagT gft_RxTcmFlag;
FlagT gft_DsErasureDecodingFlag;      // erasure capability of receiver
FlagT gft_NewBitLoadFlag;            // flag (set to 1) means do bitload from scratch

int16 gs_RxMinTone; // used to set MIN_TONE in IR_TONE register
int16 gs_RxMaxTone; // used to set MAX_TONE in IR_TONE register
int16 gs_Tcm_Oh;
uint16 gus_Tx_Tcm_Num1bits; // Number of 1 bit loaded tones in the TX BAT
uint16 gus_Rx_Tcm_Num1bits; // Number of 1 bit loaded tones in the RX BAT
uint16 gus_Rx_1Bit_Index;   // index in TRT of first 1-bit tone
int16 gs_ChooseFgThresh;   //the initial value of s_threshold used in ChooseFineGains()

FlagT gft_extrafinegainallocated; // flag to allocate extra fine gain as soon as we can to take care of forceeven1 changes
FlagT gft_Flag_limitCause;

// Fine gains & adjustment vars:
int16 gs_fgain_adjust;               // Amount of fine gain adjustment in Q8.8
int16 gs_max_fine_gain;                // Max fine gain in Q8.8
int16 gs_min_fine_gain;                // Min fine gain in Q8.8

int16 gs_TxToneOrderType;            // Tx tone order type
int16 gs_RxToneOrderType;            // Rx tone order type
int16 gs_ToneReorderErrorCode;         // tone order error code
FlagT gft_ToneOrderOK;               // flag to indicate tone ordering failure
FlagT gft_EnableRxIlvTrt;
int16 gs_ilv_tone_order_parm_K;         // calculated parameter for interleaved tone-reordering
int16 gs_ilv_tone_order_parm_L = 16;   // input parameter for interleaved tone-reordering
int16 gs_ilv_tone_order_parm_L_effective;
int16 gs_ilv_tone_order_num_empty_slots;// calculated parameter for interleaved tone-reordering

int16 gs_NumCheckByte; // # of check byte on which coding gain is determined
int16 gsa_TotalCodingGain[NUM_DATA_PATHS]; // total coding gain in dB applied to each path.
uint8 guca_RSCodingGain[MAX_NUM_CHECK_BYTE]; // RS coding gain table in Q4.4 format
int32 gla_MaxSumLp[MAX_NUM_CHECK_BYTE]; // maximum channel capacity for different value of check byte

//================================================================
// PLL vars:
//================================================================
// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
int16 gs_PhaseError;                            // Current Phase Error
int16 gs_MaxPhaseError;                         // Current Max Absolute Phase Error
int32 gl_pll_loopfilter_out;                    // Output of PLL loop filter
int32 gl_pll_freq_offset;                       // PLL frequency offset
FlagT gft_EnablePLL;                            // Flag to turn on/off PLL update (freeze or update PLL)
FlagT gft_PrevPLLState;

int16 gs_Kp_Fast, gs_Ki_Fast;                   // Fast Kp and Ki parameters in the PLL loop filter
int16 gs_Kp_Slow, gs_Ki_Slow;                   // Slow Kp and Ki parameters in the PLL loop filter

int16 gs_NumFramesPLLAcquisition;
int16 gs_NumFramesPLLRelock;
uint16 gs_PllWaitMedley;

FlagT gft_UpdateTimingRecoveryHWEnable;         // Enables updating of Strymon Timing Recovery HW
FlagT gft_EnableNoiseShaping;                   // Enables PLL loop filter output noise shaping.
int16 gs_ForcePllShowLimit;                     // Variable to set s_PhaseErrThreshold
int32 gl_noise_shaping_quan_err;                // Quantization error used in PLL noise shaping.
int32 gl_constant_SRCFR_offset;                 // Constant SRCFR offset
int16 gs_TiedClocks;
FlagT gft_DisableSRCBugWorkAround;
int16 gs_PLLAvgHandlerState;
int16 gs_PLLAvgHandlerCnt;
int16 gs_PLLSymbolsToAvg = 1024;
int16 gs_PLLSymbolsToAvgLog2 = 10;
FlagT gft_Try2ndBestPTIdx = FALSE;
uint16 gs_PTSwitchMaxPhaseError=21;

// Variables to estimate line condition (used for PLL control, etc.) XDSLRTFW-2481
uint8  guc_EdMetricThresholdDuringExtNoise;           // XDSLRTFW-3015
uint16 gus_MicroInterruptionDetectionCnt     =   0;   //
uint16 gus_SymbolWithLowEdMetricCnt          =   0;   //
int16  gs_PhaseErrorThresholdDuringMI        =   3;   // 0.02 degree   (this variable can be used for debug puopose), XDSLRTFW-3015
int16  gs_PhaseErrorThresholdDuringExtNoise  =  20;   // 0.14 degree , XDSLRTFW-3015
int16  gs_PhaseErrorThreshold                = 715;   // 5 degree
uint16 gus_NoiseDetected                     =   0;   // XDSLRTFW-2481


//================================================================
// Pilot tone vars:
//================================================================

// XDSLRTF-4056: Restrict the maximum pilot tone index to 3856.
// This tone is a grid tone for vector engines using a grid of 16 + x * 32 tones, and it avoids
// using tones above as PT, where the SNR is sometimes bad due to SRC effects and sub-optimal
// vectoring. Was 4095, now 3856.
// Also the offset from the right edge is changed to 32, to avoid using a pilot tone,
// where the vector engine is not extrapolating the coefficients correctly.

PilotConfig_t gt_PilotConfig;                   // contains the global pilot tone configuration including pilot tone array

FlagT gft_DeRotateMedleyPilot;                  // Flag to enable data-on-pilot feature
FlagT gft_EnableShowPllToneSwitch = TRUE;       // Flag to enable the search for multiple pilot tone
int16 gs_PilotSelectOffset;                     // Left band edge offset for pilot tone selection (to avoid PT being selected on ISI affected tones)
int16 gs_PilotSelectRightEdgeOffset = 32;       // Right band edge offset for pilot tone selection
int16 gs_MaxPhaseErrorThreshold;                // Max phase error allowed.
int16 gs_MaxPilotToneIndex = 3856;              // Maximum pilot tone index

int16 gsa_AvgRefPilotToneReal[MAX_NUM_PILOT_TONES];   // averaged real part of the pilot tone
int16 gsa_AvgRefPilotToneImag[MAX_NUM_PILOT_TONES];   // averaged imag part of the pilot tone
int32 gla_AvgRefPilotToneReal[MAX_NUM_PILOT_TONES];   // variable to calculate an averaged version of the pilot tone
int32 gla_AvgRefPilotToneImag[MAX_NUM_PILOT_TONES];   // variable to calculate an averaged version of the pilot tone

int16 gs_FrameWithLowPilotPwrCnt = 0;           // For FAST Loss with aid of pilot tone. XDSLRTFW-645 & XDSLRTFW-674
int16 gs_MaxNumofCorruptedPilot = 10;           // For FAST Loss with aid of pilot tone. XDSLRTFW-645 & XDSLRTFW-674
int16 gs_Kl0_thresh_pilot_select;               // NOTE: consider to remove, is set to 0;
                                                // Kl0 threshold from which loop lengths onwards the PT shall be offset to avoid being selected at band edge

// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

/* =============================================== */
/* global variable declarations for TDQ  */
/* =============================================== */
int16 gsa_pre_tdq_h[TDQ_LENGTH];      /* TDQ filter coefficients' mantissas */
int16 gs_pre_tdq_h_exp;               /* TDQ filter coefficients' common exponent */
int16 gs_TDQLen;

FlagT gft_ReconfigHw;
/* ====================================================== */
/* Array to hold the diagnostic information */
/* ====================================================== */
// XDSLRTFW-441 Relocating the "LOCAL_LD_ST" section to get more space for PERSISTENT Memory
//uint8 guca_QLN[512];    // Relocating the "LOCAL_LD_ST" section
//int16 gs_CarrierGroupSizeTx_Disc;
//int16 gs_Log2CarrierGroupSizeTx_Disc;
//int16 gs_CarrierGroupSizeRx_Disc;
//int16 gs_Log2CarrierGroupSizeRx_Disc;
//int16 gs_CarrierGroupSizeTx_Medley;
//int16 gs_Log2CarrierGroupSizeTx_Medley;
//int16 gs_CarrierGroupSizeRx_Medley;
//int16 gs_Log2CarrierGroupSizeRx_Medley;

//ChannelMeasurement_t gt_ChannelMeasurement_FE;   //measurement done by the far-end RX side
//ChannelMeasurement_t gt_ChannelMeasurement_NE;   //measurement done by the near-end RX side

// What ceil is adequate for PGA, and what ceiling maximizes data rate.
//int16 gs_ceil_adequate, gs_ceil_best;

//FlagT gft_EnableProposedCeilingOpt;      //flag used to enable ceiling reduction for improved SNR
//FlagT gft_EnableProposedCeiling; //if set to 1, enable calculation of proposed ceiling

//int16 gs_CeilingOptBandPlanEnable;   //enable Ceiling Opt per band plan

FlagT gft_LimitUsCeiling = TRUE;
FlagT gft_SlidingUsInitialCeiling = TRUE;

/* ====================================================== */
/* global variable definitions for Tx/Rx Cyclic Extension */
/* ====================================================== */
// XDSLRTFW-441 Relocating the "LOCAL_LD_ST" section to get more space for PERSISTENT Memory
//int16 gs_TxCELength;      // TX cyclic extension length
//int16 gs_RxCELength;      // RX cyclic extension length
//int16 gs_TxBetaLength;      // the beta length for TX
//int16 gs_RxBetaLength;      // the beta length for RX (that is the remote modem TX's beta length)
//int16 gs_PreCELength;      // Previous CE length
//int16 gs_m;               // parameter m in equation Tx-/RxCELength = m*N/32
//int16 gs_RxWindowLength;
FlagT gft_DisableTxWin = FALSE;      //TRUE: disable TX windowing, FALSE: enable TX windowing
FlagT gft_DisableRxWin = FALSE;      //TRUE: disable RX windowing, FALSE: enable RX windowing
FlagT gft_StartTxWin = TRUE;

DATA_DILVB_BEGIN

// RX and TX (raised cosine) window coefficients
int16 gsa_WindowCoeffs[TX_WINDOW_LENGTH_8K_IFFT/2] =
{
       0,     // 0,
       1,     // 1,
       3,     // 3,
       6,     // 6,
       9,     // 9,
       13,    // 13,
       17,    // 17,
       22,    // 22,
       28,    // 28,
       35,    // 35,
       42,    // 42,
       50,    // 50,
       59,    // 59,
       68,    // 69,
       79,    // 79,
       89,    // 90,
       101,   // 101,
       113,   // 113,
       126,   // 126,
       140,   // 140,
       154,   // 154,
       169,   // 169,
       185,   // 185,
       201,   // 202,
       218,   // 219,
       236,   // 236,
       254,   // 255,
       273,   // 274,
       293,   // 294,
       314,   // 315,
       335,   // 336,
       357,   // 358,
       379,   // 380,
       402,   // 404,
       426,   // 428,
       451,   // 452,
       476,   // 478,
       502,   // 504,
       529,   // 530,
       556,   // 558,
       584,   // 586,
       613,   // 615,
       642,   // 644,
       672,   // 674,
       703,   // 705,
       734,   // 736,
       766,   // 768,
       799,   // 801,
       832,   // 835,
       866,   // 869,
       901,   // 904,
       936,   // 939,
       972,   // 975,
       1009,  // 1012,
       1046,  // 1049,
       1084,  // 1087,
       1122,  // 1126,
       1162,  // 1165,
       1201,  // 1205,
       1242,  // 1246,
       1283,  // 1288,
       1325,  // 1329,
       1368,  // 1372,
       1411,  // 1415,
       1454,  // 1459,
       1499,  // 1504,
       1544,  // 1549,
       1590,  // 1595,
       1636,  // 1641,
       1683,  // 1688,
       1730,  // 1736,
       1778,  // 1784,
       1827,  // 1833,
       1877,  // 1883,
       1927,  // 1933,
       1977,  // 1984,
       2029,  // 2035,
       2081,  // 2087,
       2133,  // 2140,
       2186,  // 2193,
       2240,  // 2247,
       2294,  // 2302,
       2349,  // 2357,
       2405,  // 2413,
       2461,  // 2469,
       2517,  // 2526,
       2575,  // 2583,
       2633,  // 2641,
       2691,  // 2700,
       2750,  // 2759,
       2810,  // 2819,
       2870,  // 2879,
       2931,  // 2940,
       2992,  // 3002,
       3054,  // 3064,
       3116,  // 3127,
       3180,  // 3190,
       3243,  // 3254,
       3307,  // 3318,
       3372,  // 3383,
       3437,  // 3449,
       3503,  // 3515,
       3570,  // 3582,
       3637,  // 3649,
       3704,  // 3716,
       3772,  // 3785,
       3841,  // 3854,
       3910,  // 3923,
       3980,  // 3993,
       4050,  // 4063,
       4120,  // 4134,
       4192,  // 4206,
       4263,  // 4278,
       4336,  // 4350,
       4408,  // 4423,
       4482,  // 4497,
       4555,  // 4571,
       4630,  // 4645,
       4705,  // 4720,
       4780,  // 4796,
       4856,  // 4872,
       4932,  // 4948,
       5009,  // 5025,
       5086,  // 5103,
       5164,  // 5181,
       5242,  // 5259,
       5321,  // 5338,
       5400,  // 5418,
       5479,  // 5498,
       5560,  // 5578,
       5640,  // 5659,
       5721,  // 5740,
       5803,  // 5822,
       5884,  // 5904,
       5967,  // 5987,
       6050,  // 6070,
       6133,  // 6153,
       6217,  // 6237,
       6301,  // 6322,
       6385,  // 6407,
       6470,  // 6492,
       6556,  // 6578,
       6642,  // 6664,
       6728,  // 6750,
       6814,  // 6837,
       6901,  // 6924,
       6989,  // 7012,
       7077,  // 7100,
       7165,  // 7189,
       7254,  // 7278,
       7343,  // 7367,
       7432,  // 7457,
       7522,  // 7547,
       7612,  // 7638,
       7703,  // 7728,
       7794,  // 7820,
       7885,  // 7911,
       7977,  // 8003,
       8069,  // 8096,
       8161,  // 8188,
       8254,  // 8281,
       8347,  // 8375,
       8440,  // 8468,
       8534,  // 8563,
       8628,  // 8657,
       8723,  // 8752,
       8817,  // 8847,
       8912,  // 8942,
       9008,  // 9038,
       9104,  // 9134,
       9200,  // 9230,
       9296,  // 9327,
       9393,  // 9424,
       9489,  // 9521,
       9587,  // 9619,
       9684,  // 9716,
       9782,  // 9815,
       9880,  // 9913,
       9978,  // 10012,
       10077, // 10111,
       10176, // 10210,
       10275, // 10309,
       10375, // 10409,
       10474, // 10509,
       10574, // 10609,
       10674, // 10710,
       10775, // 10811,
       10875, // 10912,
       10976, // 11013,
       11077, // 11114,
       11179, // 11216,
       11280, // 11318,
       11382, // 11420,
       11484, // 11522,
       11586, // 11625,
       11689, // 11728,
       11791, // 11831,
       11894, // 11934,
       11997, // 12037,
       12100, // 12141,
       12204, // 12244,
       12307, // 12348,
       12411, // 12452,
       12515, // 12557,
       12619, // 12661,
       12723, // 12766,
       12828, // 12870,
       12932, // 12975,
       13037, // 13080,
       13142, // 13185,
       13247, // 13291,
       13352, // 13396,
       13457, // 13502,
       13562, // 13608,
       13668, // 13713,
       13773, // 13819,
       13879, // 13925,
       13985, // 14031,
       14091, // 14138,
       14197, // 14244,
       14303, // 14351,
       14409, // 14457,
       14515, // 14564,
       14622, // 14670,
       14728, // 14777,
       14835, // 14884,
       14941, // 14991,
       15048, // 15098,
       15155, // 15205,
       15261, // 15312,
       15368, // 15419,
       15475, // 15526,
       15582, // 15634,
       15689, // 15741,
       15796, // 15848,
       15903, // 15955,
       16009, // 16063,
       16116, // 16170,
       16223, // 16277,
       16330, // 16385
};

// RX and TX (raised cosine) window coefficients
// beta = 256
int16 gsa_WindowCoeffsBrcm[TX_WINDOW_LENGTH_8K_IFFT/2] =
{
    1,
    5,
    11,
    20,
    31,
    44,
    60,
    78,
    99,
    122,
    148,
    176,
    206,
    239,
    275,
    312,
    352,
    395,
    440,
    487,
    537,
    589,
    643,
    700,
    759,
    821,
    884,
    950,
    1019,
    1089,
    1162,
    1238,
    1315,
    1395,
    1477,
    1561,
    1647,
    1736,
    1827,
    1920,
    2015,
    2112,
    2212,
    2313,
    2417,
    2523,
    2631,
    2740,
    2852,
    2966,
    3082,
    3200,
    3320,
    3442,
    3566,
    3691,
    3819,
    3948,
    4080,
    4213,
    4348,
    4485,
    4623,
    4763,
    4905,
    5049,
    5195,
    5342,
    5491,
    5641,
    5793,
    5947,
    6102,
    6258,
    6417,
    6576,
    6738,
    6900,
    7064,
    7230,
    7396,
    7564,
    7734,
    7905,
    8077,
    8250,
    8424,
    8600,
    8777,
    8955,
    9134,
    9314,
    9495,
    9677,
    9861,
    10045,
    10230,
    10416,
    10603,
    10791,
    10979,
    11169,
    11359,
    11550,
    11742,
    11934,
    12127,
    12321,
    12515,
    12710,
    12906,
    13102,
    13298,
    13495,
    13692,
    13890,
    14088,
    14287,
    14486,
    14685,
    14884,
    15084,
    15283,
    15483,
    15683,
    15883,
    16084,
    16284,
};

DATA_MAP_END;


//================================================================
// TX/RX message control variable/flags
//================================================================

//TX side
int16 gs_TxHDLCMsgState;         // Tx HDLC message handler state
uint16 gus_TxHDLCMsgFCS;         // FCS check word
int16 gs_UpdateTxMsgIdxFlag;     // flag indicating if the TX msg index should be updated or not
int16 gs_NumOctetsInTxHDLCMsg;   // number of octets in TX message payload
int16 gs_SendRAckFlag;           // flag indicating which ACK message to send
int16 gs_FormMsgFlag;            // flag to indicate if the message generation is done or not
int16 gs_SendAckSegFlag;         // indicate if ACK-SEG should be transmitted or not
int16 gs_RevAckSegFlag;          // indicate if ACK-SEG is received or not
int16 gs_TxNumBytesPerSymbol;    // number of bytes modulated per TX symbol
int16 gs_NumEocBytesPerSym;      // actual no. of EOC bytes per symbol
int16 gs_NumVocBytesPerSym;      // actual no. of EOC bytes per symbol
uint8 guc_MaxNumEocBytesPerSym;  // max. no. of EOC bytes per symbol
uint8 guc_MaxNumVocBytesPerSym;  // max. no. of EOC bytes per symbol
uint8 *gpuca_TxSocMsg;           // Pointer to TX Soc Messages
int16 gs_NumRxRepeatRequest;     // number of times to resend O-UPDATE message
int16 gs_NumTxRepeatRequest;     // number of REPEAT_REQUEST messages have been sent

uint8 guc_TxHDLCMsgIndex;        // TX Message index
uint8 guc_TxMsgCode;             // TX message code
uint8 guc_TxSegmentIdx;          // TX segment index
uint8 guca_TxSocResend[5];       // O-REPEAT_REQUEST is exactly 5 bytes. Because the buffer is shared between
// RX/TX these bytes must be saved and restored to resend the TX-message correct again.
//#ifdef MTK_VECTORING_SUPPORT
FlagT gft_TxHDLCSegmentedAutoRepeatMode = 0;    // Flag for Segmented SOC in AR mode
uint8 guc_TxHDLCMsgIndexBackup;  // TX Message index backup for RP Vector 2 ERB message
//#endif //#ifdef MTK_VECTORING_SUPPORT



//RX Side
int16 gs_RxHDLCMsgState;         //Rx HDLC message handler state
uint16 gus_RxHDLCMsgFCS;         //FCS check word
int16 gs_RxWholeMsgLength;         //length of a complete RX message
int16 gs_RxMsgCheckOkFlag;         //Flag set to TRUE if the message check is ok, else FALSE
int16 gs_RxMsgErrorCode;         //RX message decoding error code
int16 gs_MsgReceiveFlag;         //Flag set to TRUE if a TX message has been received correctly
int16 gs_NumOfToneClustersForMsgDecode;      //number of tone clusters to use for decoding message
int16 gsa_SOCMsgRxToneClusterStarts[NUM_TONE_CLUSTERS_FOR_MSG_DECODING];  // The starting indices for
// each msg decode tone cluster
int16 gs_RxNumChannelsForMsgDecode;         //=gs_NumOfToneClustersForMsgDecode*10
int16 gs_RxNumBytesPerSymbol;      //number of bytes modulated per RX symbol
uint8 guc_NumberOfPossibleRxMsgs;   //number of possible expected messages
uint8 guca_PossibleRxMsgCodes[10];   //possible expected message codes
uint8 guc_RxMsgCode;            //RX Message code
uint8 guc_ExpectedMsgIdx;         //RX expected message index
uint8 guc_RxHDLCMsgIndex;         //RX Message index
uint8 guc_RxSegmentIdx;            //RX segment index
uint8 guc_RxNumOfSegments;         //number of segments in RX message
int16 gs_OContractIdx;            //Index n of O-CONTRACTn

FlagT gft_StrictSynchroDetect;

HDLC_Fifo_attrib_t RxHDLCFifo;      //received HDLC message descriptor
uint8 *gpuca_RxHDLCMsgBuf;

uint8 guca_TxOctet[2];         // contains the next HDLC byte(s) for transmission.
uint32 gl_SocTxDataForPrbs; // contains HDLC msg byte(s) in HW format for each VDSL frame during training.

//#ifdef MTK_VECTORING_SUPPORT
uint32 gl_SocTxDataForPrbs_ext[7]; //7 additional regsters
//#endif


uint8 guc_ExchangePhaseTxNumBytesPerSymbol; //desired number of bytes modulated per TX symbol used in the exchange phase
uint8 guc_ExchangePhaseRxNumBytesPerSymbol; //desired number of bytes modulated per RX symbol used in the exchange phase

// Soc Msg info saved in case of FCS error:
RxSocMsgFCSErrInfo_t  gt_RxSocMsgFCSErrInfo;

// ******************************************
// SOC (Special Operation Channel) Messages:
// ******************************************

//========================================
//TRAINING PHASE MESSAGES
//========================================
uint16 gus_OSignatureErrorCode;

DecMsg_O_Signature_t gt_DecMsg_O_Signature;   //Decoded O-Signature Message
DecMsg_O_Update_t gt_DecMsg_O_Update;      //Decoded O-Update Message


//VDSL2 messages and structures
DecMsg_O_Signature_VDSL2_t gt_DecMsg_O_Signature_VDSL2;   //Decoded O-Signature Message
DecMsg_O_Update_VDSL2_t    gt_DecMsg_O_Update_VDSL2;    //Decoded O-UPDATE
DecMsg_O_Prm_VDSL2_t       gt_DecMsg_O_Prm_VDSL2;       //Decoded O-PRM
DecMsg_O_TA_Update_VDSL2_t gt_DecMsg_O_TA_Update;      //Decoded O-TA-UPDATE
DecMsg_O_Msg1_VDSL2_t      gt_DecMsg_O_Msg1_VDSL2;      //Decoded O-MSG1
DecMsg_O_TPS_VDSL2_t       gt_DecMsg_O_TPS_VDSL2;       //Decoded O-TPS


int16 gs_RxNextState_ToBe;         //Next RX state to be in (but may not immediately)
PtrToFunc gpF_RxStateFunc_ToBe;      //Next RX state function to be used ((but may not immediately)
int16 gs_RxNextStatePeriodicFlag;   //1: means peridodic state, 0 means no periodic state

int16 gs_TxNextState_ToBe;         //Next TX state to be in (but may not immediately)
PtrToFunc gpF_TxStateFunc_ToBe;      //Next RX state function to be used ((but may not immediately)

int32 gl_TxTeqLength;            //duration of TX TEQ state length in symbol of 2N
int32 gl_TxEctLength;            //duration of TX EC state length in symbol of 2N
int32 gl_TxPeriodicLength;         //duration of TX Periodic EC state length in symbol of 2N
int32 gl_RxTeqLength;            //duration of RX TEQ state length in symbol of (2N+Lce)
int32 gl_RxEctLength;            //duration of RX ECT state length in symbol of (2N+Lce)
int32 gl_RxPeriodicLength;         //duration of TX Periodic EC state length in symbol of (2N+Lce)

int32 gl_TxQuiet3Length;         //duration of TX Quiet 3 state length in symbol of (2N)
int32 gl_RxPilot2Length;         //duration of RX Pilot 2 state length in symbol of (2N+Lce)
int32 gl_RxPilot3Length;         //duration of RX Pilot 3 state length in symbol of (2N+Lce)


//CPE requested training length
uint8 guc_RtReq_EcLength;         //duration of VTU-R EC training in multiple of 64
uint8 guc_RtReq_TeqLength;         //duration of VTU-R TEQ training in multiple of 64
uint8 guc_RtReq_CoTeqLength;      //duration of VTU-O TEQ training in multiple of 64
uint8 guc_RtReq_PeriodicLength;      //duration of Periodic signal in multiple of 64
uint8 guc_RtReq_RPTrainLength;      //duration of R-P-Training

uint8 guc_RtAct_RPTrainLength;      //duration of actual R-P-Training

int16 gs_VDSL2_MIN_R_IDLE_TX_TRAIN2;

//========================================
//CHANNEL ANALYSIS AND EXCHANGE MESSAGES
//========================================
Inlv_Descriptor_t gta_TX_DetailedInlvSetting[4];
Inlv_Descriptor_t gta_RX_DetailedInlvSetting[4];

R_O_Msg2_t gt_O_Msg2;                  //O-MSG2
R_O_Msg2_t gt_R_Msg2;                  //R-MSG2
Contract_t gt_tx_contract;      //TX contract
Contract_t gt_rx_contract;      //RX contract
int8 gc_RMargin;                     //R-MARGIN in 0.5 dB step size
uint8 guc_jmax;

//#ifdef MTK_VECTORING_SUPPORT
R_Msg1_G993_5 gt_R_Msg1_G993_5;  // R-MSG1_G993.5
//#endif //MTK_VECTORING_SUPPORT


FlagT gft_StartTxShowinit;
FlagT gft_StartTxSynchro;

//==============================================================================
// PMS/PMD parameters
//==============================================================================
Config_t gt_tx_config; // TX PMS/PMD parameters
Config_t gt_rx_config; // RX PMS/PMD parameters

VDSL2Config_t gt_tx_config_v2;
VDSL2Config_t gt_rx_config_v2;
VDSL2Config_t gt_rx_config_v2_Attndr;

// XDSLRTFW-3898(Start)
Reconfig_Hyb_Coeff_t gt_Reconf_Hybrid_Coeff;
// XDSLRTFW-3898(End)

BC_LP_TPS_Map_t   gt_tx_TPS_Map;
BC_LP_TPS_Map_t   gt_rx_TPS_Map;

uint8 guc_data_path_tx;
uint8 guc_ohmsg_path_tx;
uint8 guc_data_path_rx;
uint8 guc_ohmsg_path_rx;

uint16 gus_dilvb_avail[NUM_DATA_PATHS];
uint16 gus_invalid_bytes[NUM_DATA_PATHS];

int16 gs_wt_step[NUM_DATA_PATHS];
int16 gs_rd_step[NUM_DATA_PATHS];

//=============================================================================
// VDSL2 framing parameter selection variables
//=============================================================================
// Input to the framing parameter selection function
VDSL2FramingParamsInputs_t gt_FormFramingParamsInputs_v2;

// Bit-field register to indicate the error code/status from FormVDSL2FramingParams()
int16 gs_VDSL2FrameParamGenStatus;

//The following is log2(K), K = 1, 2, 4, 8, 16 (ignore other terms)
int16 gsa_log2Tbl[17] = {0, 0, 1, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 4};

uint32 gul_DILV_MEM_SIZE;         // I*D/2 must be less than this parameter (NE)
uint32 gul_FE_DILV_MEM_SIZE;      // I*D/2 must be less than this parameter (FE)
uint32 gul_HW_ILV_MEM_SIZE[NUM_DATA_PATHS];         // HW interleaver memory limit
uint32 gul_HW_DILV_MEM_SIZE[NUM_DATA_PATHS];      // HW deinterleaver memory limit

uint32 gul_FE_HW_ILV_MEM_SIZE;      // FE HW interleaver memory limit
uint32 gul_FE_HW_DILV_MEM_SIZE;      // FE HW deinterleaver memory limit
uint32 gul_ilvb_size;            // Actually used ILVB memory size
uint32 gul_dilvb_size;            // Actually used DILVB memory size

FlagT gft_NE_IlvDilvMemType;      // NE ILV/DILV memory type
FlagT gft_FE_IlvDilvMemType;      // FE ILV/DILV memory type
uint16 gus_PctMaxDelayOctetsForUS; // Proportion of MAXDELAYOCTET or HW buffer size used for US (in Q1.15)

int16 gs_DataFrameRate = 0;         //in symbols/second
FlagT gft_AccurateFrameRateEnable, gft_computeDataRateFS6;

uint8 guc_NumLantencyPath=1;
int32 gla_MaxInlvDelay[NUM_DATA_PATHS];
int32 gla_MaxInlvDelayUs[NUM_DATA_PATHS];

uint8 guc_minR, guc_maxM, guc_maxT, guc_maxG;
uint16 gus_DSearchRange;
// There are corner cases (e.g. minINP=4, maxDelay=4msec) where with INP fix enabled we would generate
// framing parameters with Nfec = 31 (violation of G.993.2), while without INP fix we would get Nfec = 32 and
// still "good" INP. Therefore we keep the INP fix disabled by default; can be enabled for debugging purposes.
FlagT gft_EnableINPFix = FALSE;

uint16 gus_SelectedFramingParam = 0;            //XDSLRTFW-2547(Start_End)

//==============================================================================
// variables used during showtime initialization
//==============================================================================
uint8 guc_TxShowInitState; // used in TxShowInitHandler()
uint8 guc_RxShowInitState; // used in RxShowInitHandler()
uint8 guc_BgTxShowInitState; // used in all background tasks in TxShowInitHandler()
uint8 guc_BgRxShowInitState; // used in all background tasks in RxShowInitHandler()
uint8 guc_TxDataPumpState; // used in TxDataPumpSetUp()
uint8 guc_RxDataPumpState; // used in RxDataPumpSetUp()

//==============================================================================
// variables used during showtime
//==============================================================================
uint16 gus_ShowtimeFGTask;
uint16 gus_ShowtimeControl; // showtime control flag (bit-field defined in vdsl_const.h)
uint16 gus_ShowtimeControlDDSave;
int16 gs_RxToneOffsetShadow;
int16 gs_first10secs_in_Showtime;
FlagT gft_ErrorFree_10sInShowtime;

uint8 guc_RxDataFrameState; // state used in RxDataFrameProcess()

int16 gs_CorruptCRCControl=0; // Showtime test control
uint8 guc_CrcOffHistory = 0;
uint8 guc_SefHistory;


int16 gs_ALF_HEC_override_cnt[NUM_BEARER_CHANNELS] = {0,0};

//==============================================================================
// Showtime synch frame processing
//==============================================================================
int16 gs_TxPMDFrameCount;      // Tx PMD frame count (0 to 256)
volatile int16 gs_RxPMDFrameCount;      // Rx PMD frame count (0 to 256)
int16 gs_RxSynchFrameNumTones;   // # of tones to read from RTV buffer
int16 gs_RxSynchFrameOffset;   // offset into RTV buffer
int16 *gpsa_RxSynchFrame;      // pointer to Rx synch frame which is read from the RTV buffer that
// contains the FDQ output

// Used for saving PRBS related registers which are needed for modulating Medley PRBS on unused
// tones (b_i=0 and g_i > 0) of data frames
int16 gusa_PrbsRegistersSav[NUM_PRBS_SAVE_REGS];

//==============================================================================
// variables used in decision-directed SNR/FDQ calculation
//==============================================================================
DDSnrFdqConfig_t gt_DDSnrFdqConfig;

int16 gs_DDSnrFdqState; // used in DDSnrFdqHandler()
int16 gs_DDSnrState; // used in DDSnrFdqHandler() to control SNR update separately
int16 gs_DDFdqState; // used in DDSnrFdqHandler() to control FDQ update separately
int16 gs_NumSnrUpdate; // # of SNR updates during showtime
int16 gs_NumFdqUpdate; // # of FDQ updates during showtime
int16 gs_NumRxPowerUpdate; // # of Rx Power updates during showtime
int16 gs_DDFdqAdaptSlew; // step-size used in SSLMS FDQ adaptation algorithm
FlagT gft_ApplyConstGain; // apply constellation gain on signal power during SNR calculation
uint8 guc_SNRFDQControl;

#ifndef HW_SNR_FDQ
int16 *gpsa_FftOutputBuf; // pointer to FFT output buffer read from RTV buffer
int16 *gpsa_ErrOutputBuf; // pointer to error ouput buffer read from RTV buffer
int16 *gpsa_FftErrCorrBuf; // pointer to correlation output buffer between FFT output & error ouput
int16 *gpsa_ScratchPad_X; // pointer to scratch pad in X memory
int16 *gpsa_ScratchPad_Y; // pointer to scratch pad in Y memory
#endif //#ifndef HW_SNR_FDQ

FlagT gft_EnableFdqUpdate;
FlagT gft_EnableSnrUpdate;

#ifndef PILOT_TONE_LOS_DETECT
DDRxPowerCalc_t gt_DDRxPowerCalc; // used for signal power calculation for LOS detection
#endif

int16 gs_DDSnrFdqCount;
FlagT gft_EnableFDQUpdateWorkaround = FALSE;   //maybe enabled later
int16 gs_DDFdqAdaptSlewSlow = 0;   //2^0 = 1, equivalent to vinax case
int16 gs_DDFdqAdaptSlewFast = 1;   //2^1 = 2, smaller than vinax case
int16 gs_DDFdqSpeedupMaxCount = 10;
FlagT gft_SkipBitswap;

//==============================================================================
// Overhead messaging variables
//==============================================================================

// Variables that defined how often the IBits should be processed and it's in terms of PMD frames (a.k.a. DMT symbols)
int16 gs_PMDFramesPerTxIBStructure;
int16 gs_PMDFramesPerRxIBStructure;

// IB variables
uint8 guca_TxIbMsgBuf[MAX_IB_BYTES_PER_SFRAME];
uint8 guca_RxIbMsgBuf[MAX_IB_BYTES_PER_SFRAME];

// Temporary IB storage - used to hold IBs until CRC is received.
// if CRC error occurs, then the IBs are discarded
uint8 guca_RxIbMsgBufTemp[MAX_IB_BYTES_PER_SFRAME];
// FeLprLosDelay is used to delay between FE LPR indicator
// and NE LOS check.  This allows time for LOS to appear.
int16 gs_FeLprLosDelay=0;
uint16 gusa_nSyncLoss[2]; //Debug for XDSLRTFW-2050

TxIbDataStruct_t gt_TxIbData;
RxIbDataStruct_t gt_RxIbData;

#ifdef PILOT_TONE_LOS_DETECT
//Used for LOS detection
int8 gc_log2_num_syms_for_avg;
uint8 guc_LosDefect_state;
int16 gs_LosDefect_state_cnt;
int16 gs_num_syms_for_avg;
int32 gl_AvgPilotPow_Thresh;
int32 gl_AvgPilotPow;
#endif //#ifdef PILOT_TONE_LOS_DETECT

// Test variables for introducing far end anomalies/defects in the form of indicator
// bytes(IBs) at one end and read out the received IBs content at the other end
int16 IB_override_count;
int16 IB_override_content[3];
int16 IB_readout_count;
int16 IB_readout_content[3];

// Flag used to write Tx IB to HW Fifo
FlagT gft_WriteTxIbHwFifo;

// VOC variables
uint8  *puca_NextTxVocMsgBytes;
uint16 us_NumNextTxVocMsgBytes;

uint8 guca_TxVocSwFifoBuf[TX_VOC_MSG_SWFIFO_LEN];
int16 gs_TxVocSwFifoDepth;
int16 gs_TxVocRdPtr;
int16 gs_TxVocWrPtr;
int16 gs_TxVocState;

uint8 guca_RxVocSwFifoBuf[RX_VOC_MSG_SWFIFO_LEN];
int16 gs_RxVocRdPtr;
int16 gs_RxVocWrPtr;
int16 gs_RxVocState;
uint8 guc_RxVocMsgType;
uint16 gus_RxVocMsgLen;
uint16 gus_RxVocMsgCnt;

/////////////////////////
// VDSL2 ovhd FIFOs
/////////////////////////
uint8 guca_TxOvhdSwFifoBuf[TX_OVHD_MSG_SWFIFO_LEN];
int16 gs_TxOvhdSwFifoDepth;
int16 gs_TxOvhdRdPtr;
int16 gs_TxOvhdWrPtr;
int16 gs_TxOvhdState;
int16 gs_TxOvhdMsgIndex;
int16 gs_NumOHFrames;


uint8 guca_RxOvhdSwFifoBuf[RX_OVHD_MSG_SWFIFO_LEN];
int16 gs_RxOvhdRdPtr;
int16 gs_RxOvhdWrPtr;
int16 gs_RxOvhdMsgIndex;
int16 gs_RxOvhdState;
int16 gs_RxOvhdSubState;

// Received sync byte in VDSL2
uint8 guc_RxSyncByte;

//==============================================================================
// variables used for NTR
//==============================================================================

FlagT gft_EnableNTR;
uint8 guc_TxNTRByte;
uint8 guc_RxNTRByte;
FlagT gft_NTR_Rcvd;   // Use separate variable to indicate new NTR byte.
// This is a fix from 2379 [06232009] to solve an intermittent race condition
// when using a bit in the gus_showtimeControl varaible


FlagT gft_NTR_use_212_Clock_units;


int32 gl_NTR_Offset;
int32 gl_NTRSRC_residual = 0;
int16 gs_correct = 240;         //value to correct the slope for adjusting NTRSRCFR

//variables for NTR drift tracking.
int16 gs_enable_ntr_drift_correction;
int32 gl_stu_count_212clocks;
int32 gl_ntr_drift_metric;
int32 gl_ntr_drift_metric_0;
int32 gl_ntr_drift_correction_amount;



//==============================================================================
// variables used for ATM PMS-TC layer
//==============================================================================


//==============================================================================
// G997 related variables
//==============================================================================
int16 gs_G997_1sec_Task_Done_Flag;
int16 gs_100msecIntervalCount = 0;

G997_NE_AtmPerf_HEC_t         gt_g997_AtmPerf_HEC_Running_NE;
G997_NE_Curr_Prev_HEC_t         gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE;
G997_FE_AtmPerf_HEC_t         gt_g997_AtmPerf_HEC_Running_FE;
G997_FE_Curr_Prev_HEC_t         gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE;
G997_NE_AtmPerf_CD_t         gt_g997_AtmPerf_CD_Running_NE;
G997_NE_Curr_Prev_CD_t         gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE;
G997_FE_AtmPerf_CD_t         gt_g997_AtmPerf_CD_Running_FE;
G997_FE_Curr_Prev_CD_t         gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE;
G997_NE_AtmPerf_CU_t         gt_g997_AtmPerf_CU_Running_NE;
G997_NE_Curr_Prev_CU_t         gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE;
G997_FE_AtmPerf_CU_t         gt_g997_AtmPerf_CU_Running_FE;
G997_FE_Curr_Prev_CU_t         gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE;
G997_NE_AtmPerf_IBE_t         gt_g997_AtmPerf_IBE_Running_NE;
G997_NE_Curr_Prev_IBE_t         gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE;
G997_FE_AtmPerf_IBE_t         gt_g997_AtmPerf_IBE_Running_FE;
G997_FE_Curr_Prev_IBE_t         gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE;
G997_NE_AtmPerf_ICELL_t         gt_g997_AtmPerf_ICELL_Running_NE;
G997_NE_AtmPerf_UCELL_t         gt_g997_AtmPerf_UCELL_Running_NE;
G997_AtmPerf_t               gt_g997_AtmPerf;

G997_NE_AtmPerf_TX_UICELL_t      gt_g997_AtmPerf_TX_UICELL[NUM_BEARER_CHANNELS];
G997_NE_FE_AtmPerf_t         gt_g997_AtmPerf_NE[NUM_BEARER_CHANNELS];
G997_NE_FE_AtmPerf_t         gt_g997_AtmPerf_FE[NUM_BEARER_CHANNELS];
G997_NE_FE_PtmPerf_t         gt_g997_PtmPerf_NE[NUM_BEARER_CHANNELS];
G997_NE_FE_PtmPerf_t         gt_g997_PtmPerf_FE[NUM_BEARER_CHANNELS];
G997_Cntrl_t               gt_G997_Cntrl;

G997_NE_Curr_Prev_ChMonCRC_t   gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE;
G997_NE_ChMonCRC_t            gt_g997_ChPerf_CRC_Running_NE;
G997_FE_Curr_Prev_ChMonCRC_t    gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE;
G997_FE_ChMonCRC_t             gt_g997_ChPerf_CRC_Running_FE;
G997_NE_Curr_Prev_ChMonFEC_t   gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE;
G997_NE_ChMonFEC_t            gt_g997_ChPerf_FEC_Running_NE;
G997_FE_Curr_Prev_ChMonFEC_t    gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE;
G997_FE_ChMonFEC_t             gt_g997_ChPerf_FEC_Running_FE;
G997_NE_LinePerf_t            gt_g997_LinePerf_Sec_NE;
G997_FE_LinePerf_t            gt_g997_LinePerf_Sec_FE;
G997_NE_Curr_Prev_LinePerf_t   gt_g997_LinePerf_Current_Previous_TR1_NE;
G997_NE_LinePerf_t            gt_g997_LinePerf_Running_NE;
G997_FE_Curr_Prev_LinePerf_t    gt_g997_LinePerf_Current_Previous_TR1_FE;
G997_FE_LinePerf_t             gt_g997_LinePerf_Running_FE;
G997_Curr_Prev_LineInitPerf_t   gt_g997_LineInitPerf_Current_Previous_TR1;
G997_LineInitPerf_t            gt_g997_LineInitPerf_Running;
G997_LinePerfThreshold_t      gt_g997_LinePerfThresholdControl;
G997_LinePerf_help_t         gt_g997_LinePerf_help;
G997_LinePerf_sec_t            gt_g997_LinePerf_sec_fail;
G997_LinePerf_sec_t            gt_g997_LinePerf_Prev_sec;

uint16 gusa_NonInhibit_CRC_Cntr_NE[NUM_DATA_PATHS];
uint16 gusa_NonInhibit_FEC_Cntr_NE[NUM_DATA_PATHS];
uint16 gusa_DeltaCRCsecp_NormFactor[NUM_DATA_PATHS];

uint8 guc_LOSDefectType = 2;       // 1-los_defect1 (based on power level), 2-los_defect2 (los_defect1 or sef_defect)

uint32 gul_NeSefDefectCounter;
uint32 gul_FeSefDefectCounter;

//=======================================================
// // Variables to store the last-10-second history of SES and ES counters
//=======================================================
uint16 gs_SES_Delay_Buf=0;
uint16 gs_ES_Delay_Buf=0;
FlagT gft_USx_Disable = 0; //XDSLRTFW-2040

//=== Intermediate counters to implement counters inhibited by UAS and SES,  such as CRC, FEC counters
//=== These counters will be incremented freely by the hardware but will be read and reset every second.
G997_NE_ChMonCRC_t gt_CRC_Curr_Reading;
G997_NE_ChMonCRC_t gt_CRC_Last_10_Sec;
uint32 gul_FEC_Curr_Reading[NUM_DATA_PATHS];
uint32 gul_FEC_Last_10_Sec[NUM_DATA_PATHS];
uint32 gul_FEC_Uncorr_Curr_Reading[NUM_DATA_PATHS];
uint32 gul_FEC_Uncorr_Last_10_Sec[NUM_DATA_PATHS];
uint32 gul_RS_CW_Curr_Reading[NUM_DATA_PATHS];
uint32 gul_RS_CW_Last_10_Sec[NUM_DATA_PATHS];
uint32 gul_FECS_Curr_Reading;
uint32 gul_FECS_Last_10_Sec;
FlagT gft_changed_from_unavail_to_avail;
FlagT gft_changed_from_avail_to_unavail;

//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
//G997 Section 7.1.1
uint16                     gsa_g997_Failure_Flag_NE[2];   //Hooked to PLAM CMV 0
uint16                     gs_g997_Failure_Flag_FE;   //Hooked to PLAM CMV 1

uint16 gsa_g997_Failure_Flag_NE_latched[2];
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
uint16 gs_g997_Failure_Flag_FE_latched;

G997_LineFailure_t            gt_g997_FailureState_NE;   //Holds the state of failures described
//in PLAM CMV 0
G997_LineFailure_t            gt_g997_FailureState_FE;   //Holds the state of failures described
//in PLAM CMV 1
uint16                     gs_DefectTesting;         //Debug variable to test Line/ ATM Failures
int16                     gs_DefectCount;            //Debug variable - number of defects faked.
G997_AtmFailure_t            gt_g997_AtmFailure_NE;
G997_AtmFailure_t            gt_g997_AtmFailure_FE;


//G997 DS/US Attenuation, Margin, etc. - Section 7.5.1.4-17 of the G997 Spec.
G997_SignalAndMarginParams_t gt_LineStatusDS;
G997_SignalAndMarginParams_t gt_LineStatusUS;
int16 gs_SnrMarginLomThresh = 4*10;   //1 dB

//G997 Alarm Related Variables
G997_TR1AlarmIndicators_t gt_G997_TR1AlarmIndicators;
G997_MONI_TR1AlarmEnable_t gt_G997_MONI_TR1AlarmEnable;
G997_ReTx_MgmtCnt_t gt_g997_ReTx_FE_MgmtCnt;

uint8 guc_EnableInhibition=1;
FlagT gft_Compute_delta;

//==============================================================
//PTM related variables


//==============================================================================
// Bitswap related variables
//==============================================================================
FlagT gft_EnableTxBitSwap;            // TRUE means enabling TX bit swap feature
FlagT gft_EnableRxBitSwap;            // TRUE means enabling RX bit swap feature
FlagT gft_TxBitSwapFlag;              // TRUE means requesting TX bit swap
FlagT gft_RxBitSwapFlag;              // TRUE means requesting RX bit swap
uint16 gus_RxBitSwapStatus;           // RX bitswap operation status

FlagT  gft_SendVocBSRMsg_Flag;         // Indicates if a VOC BSR message should be sent
FlagT  gft_SendVocBSAMsg_Flag;         // Indicates if a VOC BSA message should be sent
int32 gl_RxBitSwapDecisionErrorCode;
int16 gs_BitSwapErrorCode;           // Bitswap error codes.
uint8 guc_BitSwapReqIntrepretState;   // State of background BSR interpretation
uint8 guc_BitSwapState;

int16 gs_REDUCE_LP_DELTA_BITSWAP;     // the maximum number of bits to cut in each bit-swap
int16 gs_BITSWAP_TRIGGER_DELTA;        // the snr margin drop threshold for triggering bit-swap
int16 gs_BITWAP_MIN_SNR_MARGIN;        // the minmum snr margin for triggering bit-swap
int16 gs_NumOfBitSwapTones;           // the number of tones changed in a bit-swap

BitSwapInfoStruc_t gt_TxBitSwapInfo;  // structure for TX bit swap information
BitSwapInfoStruc_t gt_RxBitSwapInfo;  // structure for TX bit swap information

//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(Start)
int16 gs_BsDecisionExtraThreshold = 128; // 0.5dB in 8.8 dB format
uint32 gula_BSFailStat[12] = {0};     // BS Pass/Fail state statistics
FlagT gft_RmsFgOverShoot;
int16 gs_MaxFgReductionAfterRmsFgOverShoot; //Info variable
//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(End)

uint32 gula_SRAFailStat[10] = {0};    // SRA Pass/Fail state statistics

TxVOCMsgStruc_t gt_TxVocMsgBSR;        // structure containing TX BSR message
TxVOCMsgStruc_t gt_TxVocMsgBSA;        // structure containing TX BSA message
RxVOCMsgStruc_t gt_RxVocMsgBSR;         // structure containing RX BSR message
RxVOCMsgStruc_t gt_RxVocMsgBSA;        // structure containing RX BSA message





uint8 guc_TxBFICount;                 // TX Bitswap Frame Interval (BFI) count [0:255]
uint8 guc_RxBFICount;                 // RX Bitswap Frame Interval (BFI) count [0:255]
uint8 guc_TxBFISubCount;              // TX BFI subcount [0:15]
uint8 guc_RxBFISubCount;              // RX BFI subcount [0:15]

//moved to CMVs rate 1 and rate 0 respectively
//uint32 gul_RxLineRate;              // Rx Line Rate
//uint32 gul_TxLineRate;              // Tx Line Rate

//==============================================================================
//GHS variables
//==============================================================================
int16 gs_LoadGhsToneFlag;
FlagT gft_GotoFailStateOnTimeOut_FromHandshake;
uint8 guc_ClrControl;
uint8 guc_SI_SPar1_Optn0;
uint8 guc_SI_SPar3_Optn0;
uint8 guc_SI_SPar4_Optn0;
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG
uint8 guc_SI_SPar5_Optn0;

//Variable define capable/status operation modes
// Note: OperationModeX = [OperationModeCapable, OperationModeStatus]
// gul_OperationModeX_VDSL2 bits[7:0]   - standard info NPar2 octet 1 for VDSL2
// gul_OperationModeX_VDSL2 bits[15:8]  - standard info SPar2 octet 1 for VDSL2
// gul_OperationModeX_VDSL2 bits[23:16] - standard info SPar2 octet 2 for VDSL2
// gul_OperationModeX_VDSL2 bits[31:24] - standard info NPar2 octet 2 for VDSL2
uint32 gul_OperationModeCapable_VDSL2;
uint32 gul_OperationModeStatus_VDSL2;

//Variable define capabilities in G.Fast
uint32 gul_OperationModeCapable_G_Fast; // XDSLRTFW-2298 (Start_End)

//Variable defines actual operation mode: i.e. VDSL1 or VDSL2
uint16 gus_ModemOperationMode_Status;

//T1.413 variables
int16 gs_DetectCACT_State;
int16 gs_DetectCACT_AccumCount;
int32 gul_T1413_ACT_TimeOUT_Cnt;
//XDSLRTFW-2373
uint8 guc_T1413DetectCnt;
int16 gs_C_ACT_flag;
int16 gs_RxDetectCnt;
uint8 guc_AccumState;
uint8 guc_PgaToneState;



//------------------
// VDSL_BONDING
//------------------
#ifdef VDSL_BONDING
// flag to enable switching to single port mode if CO does not bond.
FlagT gft_SinglePort_if_CO_notBonding = 1;

// data structures to provide control and status of
// for GHs bonding negotiation
Bonding_DiscAggr_Control_t   gt_Bonding_DiscAggr_Control;
Bonding_DiscAggr_Status_t   gt_Bonding_DiscAggr_Status;

uint16 gus_Bonding_PME_ID;     // XDSLRTFW-2382 (Start_End)

Bonding_Continue_t           gt_Bonding_Continue;


int16 gs_DsMinDelayDeltaForBonding = 1; // Delta between DS max delay and DS min delay in msec
#endif
//==============================================================================
/* The following variables are used to coordinate access to the ARC-to-ME Mailbox.      */
/* The flags guc_MPMsgResp/AutoReq, CodeSwapMsgReq, are set by the   */
/* messaging, Code Swap, respectively.  The ProcessTxMailbox            */
/* function monitors these flags and coordinates the access to the ARC-to-ME Mailbox.   */
//==============================================================================

uint8   guc_MPMsgRespReq;
uint8   guc_MPMsgAutoReq;
uint8   guc_CodeSwapMsgReq;   // Flag indicating a request to perform a Codeswap

// used by codeswap build
#include "codeswap.h"
//#include "LinkStart.h"

//DATA_COMMON_LD_ST_BEGIN
int32 gl_ImageSize;
SwapRequest_t gt_SwapRequestQueue[MAX_SWAP_REQUESTS];
SwapControl_t gt_SwapControl;
//DATA_MAP_END;

uint16 gs_MaxSwapDuration;
uint8 guc_RequestedPage = 0;
uint8 guc_PrimPageHandle = INVALID_CODESWAP_HANDLE;
int16 gs_CodeSwapSection;
uint8 guc_InitialPage;
uint8 guc_RxSwapActivity = CODESWAP_DO_NOTHING;
uint8 guc_TxSwapActivity = CODESWAP_DO_NOTHING;

//==============================================================================
/* The following variables are used for the Parr algorithm */
//==============================================================================
FlagT gft_TxParrEnabled;
int16 gs_parr_threshold_dBm_8p8;
TxParrConfig_t gt_TxParrConfig;

//==============================================================================
/* PSD related globals.  */
//==============================================================================
//Electrical length (kl0)
Kl0ElectricalLength_t gt_Kl0ElectricalLength;
int16 gs_kl0_estimate_threshold = 1280;
FlagT gft_disable_autorestart_on_kl0_thresh_fail = FALSE;
FlagT gft_UPBO_is_enabled;
int16 gs_E_CODE_KL0_THRESHOLD_FAIL_count = 0;
//Value to offset the computed Electrical length (in 0.1 dB format)
int16 gs_kl0_offset;
//Whether to estimate electrical length
int16 gs_get_estimate_kl0;
int16 gs_kl0_BoostAmount; //1 dB in 0.1 dB step
FlagT gft_DisableKl0PreProc;
FlagT gft_EnableKl0Boost; //snv
int16 gs_Kl0PreProcDone;
//Whether to do signal and line attenuation calculations.
int16 gs_get_satn_latn;
int16 gs_SnrThreshForSATN = (10<<8); // On CPE, this threshold is also used for kl0 estimation
uint16 gus_kl0_estimation_method;           // XDSLRTFW-4052(Start_End)
FlagT gft_Enable_psdpreproc_kl0  = FALSE;   // XDSLRTFW-4052(Start_End)
FlagT gft_UseNewSATNCalc = TRUE;
int16 gs_GuardBinKl0; //Use this as KL0 Start bin Debug

// +1 because we use this same array to compute aggregate LATN/SATN across all the bands
//Near-end RX power per band
int32 gla_near_signal_power[MAX_NUM_RX_BANDS+1];
//Far-end TX power per band
int32 gla_far_signal_power[MAX_NUM_RX_BANDS+1];
//Difference of far-end tx minus near-end rx power
int16 gsa_satn_pb[MAX_NUM_RX_BANDS+1];
//LATn channel attenuation measurement
int32 gla_latn_pb[MAX_NUM_RX_BANDS+1];

//==============================================================================
// IFFT scale, txvargain, TX afe gain related variables
//==============================================================================
int16 gs_TxIfftGain_dB;
int16 gs_avg_ifft_in_dB;
int16 gs_TxVarGainIn_dB;
int16 gs_TxVarGain_dB;
int16 gs_TxVarGain_Inadequacy_dB;
int16 gs_tx_iir_atten_dB;
FlagT gft_Allow_20p5_dBm_8b = TRUE;
FlagT gft_Allow_17p5_dBm_8a = TRUE;
int16 gs_tx_afe_gain_setting_dB;
int16 gs_tx_afe_trim1_gain_dB = 0;         // format: 16.0dB,  supported settings are: 0 (0dB),  -6 (-6dB), -12 (-12dB)
int16 gs_max_fc_MHz = 28;                  // format: 16.0MHz, supported settings are: 5 (5MHz), 10 (10MHz), 20 (20MHz), 33 (33MHz), 40 (40MHz)
int16 gs_tx_afe_gain_inadequacy_dB;
int16 gs_frame_rate_is_8khz;
int16 gs_tx_psd_offset_dB_dbg =0;

int16 gs_tx_power_dBm_line;
uint32 gul_ifft_scales_cntl_word;
//uint32 gul_tx_vargain_cntl_word;
//uint16 gus_tx_afe_gain_cntl_word;
//uint32 gul_35bLiteConfig = 0x5823;
uint32 gul_35bLiteConfig;
//uint32 gul_35bLiteConfig;


int16 gs_TxVarGain_margin = 0;
int16 gs_MAX_PERMISSIBLE_TXVGN_OUT_DB;
FlagT gft_EnableIfftScalesFix = TRUE;
FlagT gft_EnableTxVarGainFix = TRUE;
FlagT gft_EnableFixedPofiCorner = TRUE;
FlagT gft_EnableFixedPofiCornerOverrule = FALSE;

FlagT gft_EnableRxAnalogFilterCornerFix = FALSE;

// Power Saving Flags
FlagT gft_PowerDownON;


// Lookup table for cosine values
int16 gsa_ShortCosTable[52] =
{
   32767,
   32754,
   32705,
   32625,
   32514,
   32370,
   32195,
   31989,
   31751,
   31482,
   31182,
   30852,
   30492,
   30102,
   29682,
   29234,
   28757,
   28252,
   27720,
   27160,
   26574,
   25962,
   25325,
   24663,
   23976,
   23267,
   22534,
   21780,
   21005,
   20208,
   19393,
   18558,
   17705,
   16835,
   15948,
   15046,
   14129,
   13199,
   12255,
   11300,
   10333,
   9356,
   8370,
   7376,
   6375,
   5367,
   4355,
   3338,
   2318,
   1295,
   272,
   -752
};

//=============================================================
//Variables used in Diagnostic Mode
//=============================================================
// Don't place pointer variables in DILVB because
// it causes problems with runtime initialization since
// non-initialized variables are overwritten when DILV page is loaded

uint16 *gpusa_HlinBuf_FE;        //pointer to the buffer storing far end Hlin (512*3) words
uint16 *gpusa_HlinBuf_NE;        //pointer to the buffer storing far end Hlin (512*3) words

DATA_DILVB_BEGIN

//variables used for sending the SOC messages
uint16 gus_TxSocMsgBitBuf;      //word which hold the current SOC message bits to be sent
int16 gs_TxSocMsgBitPosition;   //bit position of the bit to be sent in gus_TxSocMsgBitBuf
int16 gs_NumOfTxSocBitRepeat;   //number of times when the same bit is repeatly sent

//variable used for bit synchronization
int16 gs_BitSearchSymCount;
int16 gs_BitSynchInterationCnt;
int32 gl_RxBitStartSym;

//variables used in for the byte synchronization
int16 gs_SegueSymCntPerBit;
int16 gs_SymCntPerBit;
int16 gs_RxNumSocBitPerByte;
uint8 guc_RxSocByte;

//misc variables
FlagT gft_TxStateInitFlag;
FlagT gft_RxMsgLdFlag;
FlagT gft_CodeSwapDoneFlag;

DATA_MAP_END;

//The following structures have been defined above and used in the normal modem operation
//we will reuse them in the diagnostic mode
//gt_AttenSnrMPerRxBand_FE   //structure storing far end LATN-pb, SATN-pb, SNRM-pb
//gt_LineStatusUS.ul_AttainableDataRate      //for ATTNDR
//gt_LineStatusUS.s_ActualAggregateXmtPwr   //For ACTATP

//These two variables are used through showtime so they cannot be placed
//in interlever memory
int32 gl_RxStateTimeOutCountLoopDiagMode;
int32 gl_TxStateTimeOutCountLoopDiagMode;

int16 gs_NumOfTxSocBits;      //number of SOC message bits to be sent
FlagT gft_RunTxStateFuncFlag;   //flag, if TRUE, indicates always run the TX state function
FlagT gft_RxSocMsgDemodFlag;   //flag to control SOC msg demod operation
FlagT gft_TxSocMsgModFlag;      //flag to control when to modulate soc message in the diag. mode

//These variables are initialized in InitGlobalVars_PowerUp() or InitGlobalVars()
//so we do not put them in the interleave memory in case the interleave memory
//is used by GHS data
FlagT gft_DisableHlinCalc;
uint16 gus_NumSymbolsPerBit;
uint16 gus_NumSymbolsPerBitThresh;
int16 gs_NumOfSymbolsForBitSearchAccum;
int16 gs_Log2NumOfSymbolsForBitSearchAccum;
FlagT gft_SocRepeatFlag;         //flag, if TRUE, indicates resending the prevous message byte
FlagT gft_DisableTxDiagModulation;   //If TRUE, do not use the diag. mode modulation method
//but the regular initialization modulation method
int32 gl_MedleyStateLength_Diag;

int16 gs_TxSyncToneType;
int16 gs_RxSyncToneType;
int16 gs_CurrRxSyncType;         //RX synch type of current synch frame
int16 gs_NumTxSynchFlags;
int16 gs_NumRxSynchFlags;
FlagT gft_RxInvSynch;



#ifndef HW_TRT
int16 gs_TxTRT_write_band;
int16 gs_TxTRT_write_offset;

int16 gs_RxTRT_write_band;
int16 gs_RxTRT_write_offset;

int16 gs_TxTRT_read_band;
int16 gs_TxTRT_read_offset;

int16 gs_RxTRT_read_band;
int16 gs_RxTRT_read_offset;
int16 gs_TRT_readstate;
FlagT gft_use_framebuffer;
//For 5.0 platform, there is no HW support for TRT. Workaround is present in order to store inactive TRT in temporary unused memory.
//See Unpack_TRT(), ReadTRT() and WriteTRT() functions. With 35B mode, we need to map up to 8k tones. The mechanism to pack 2-trt-tone information
//in 3bytes does not work anymore. For COCOMO simulation purposes, where no memory limitations exist, required buffer is added.
int16 gs_InactiveTrtStorage[RX_MAX_NUM_TONES];
#endif //#ifndef HW_TRT


#ifdef DISTRIBUTE_TX_RX_PROCESS
FlagT gft_DistributeTxRxProcess;
FlagT gft_DistributeTxRxProcess_Save;
int32 gl_RxBSCount;
uint32 gul_RxTCStartTime;
uint32 gul_CCR1_Reg_BS;
uint32 gul_CCR1_Reg_QtDone;
#endif // DISTRIBUTE_TX_RX_PROCESS

int16 gsa_RxBitsInFifo[NUM_DATA_PATHS];
int16 gsa_TxBitsInFifo[NUM_DATA_PATHS];

int16 gs_rxnumfailures;
int16 gs_txnumfailures;
int16 gs_dbg_TxPmdCnt_TxFifoErr;
int16 gs_dbg_RxPmdCnt_RxFifoErr;
int32 gl_dbg_TxSymCnt_TxFifoErr;
int32 gl_dbg_RxSymCnt_RxFifoErr;

uint16 gus_ForceLPR=0;
uint16 gus_SetLPR;  // Tied to CMV DSL 5


FlagT gft_ADCOverflowed;



//
//
// DO NOT PUT NORMAL VARIABLES BEYOND THIS LINE
//
//

//==============================================================================
// DEBUG variables
// - can be used in all platforms for debug purpose
// - may be included for the target HW build
//==============================================================================

int16 *gpsa_LpbkBuf; // pointer to loopback buffer (used in showtime loopback mode)

uint32 gul_STR_OverflowData;  // strymon overflow debugging
uint32 gul_STR_OverflowMask;  // strymon overflow debugging
uint32 gul_STR_OverflowCount; // strymon overflow debugging
uint16 gus_ZEP_RxPMSNotDone, gus_ZEP_TxPMSNotDone;
#ifdef ENABLE_VR9_HW_ERR_CNT
FlagT gft_EnableCoreErrorCheck = 1;      //0: disable, 1: enable
FlagT gft_IncludeGhsInTrain = FALSE;   //if TRUE, include the overflow cases in GHS to the train counts

uint16 gsa_StrymonOverflowCnt_train[17];   //strymon overflow counts
uint16 gsa_StrymonOverflowCnt_medley[17];
uint16 gsa_StrymonOverflowCnt[17];

uint32 gul_FT_OverflowData;
uint16 gusa_FTOverflowCnt_train[2];   //0: FFT, 1: IFFT
uint16 gusa_FTOverflowCnt_medley[2];
uint16 gusa_FTOverflowCnt[2];

uint32 gul_TXQT_ErrorData;
uint16 gsa_TxQTErrorCnt_train[4];   //TX QT error counts
uint16 gsa_TxQTErrorCnt_medley[4];
uint16 gsa_TxQTErrorCnt[4];

uint32 gul_RXQT_ErrorData;
uint16 gsa_RxQTErrorCnt_train[4];   //RX QT error counts
uint16 gsa_RxQTErrorCnt_medley[4];
uint16 gsa_RxQTErrorCnt[4];

#endif //#ifdef ENABLE_VR9_HW_ERR_CNT


FlagT gft_StrymonLpbkMode = STR_NO_LPBK; //configure strymon lookback mode

#ifdef LOG_FA_DEBUG_INFO
//Discovery phase frame alignment information
int16 gs_ToneSelect_FA_ChDisc;
int16 gs_NumCluster_FA_ChDisc;
int16 gs_FrameAlignIteration_ChDisc;
int16 gs_CumulativeAlignmentOffset_ChDisc;
int16 gsa_FrameAlignOffsets_ChDisc[MAX_NUM_FRAME_ALIGN_ITERATIONS];

//Training state frame alignment information
int16 gs_ToneSelect_FA_Train;
int16 gs_NumCluster_FA_Train;
int16 gs_FrameAlignIteration_Train;
int16 gs_CumulativeAlignmentOffset_Train;
int16 gsa_FrameAlignOffsets_Train[MAX_NUM_FRAME_ALIGN_ITERATIONS];


//Medley state frame alignment information
int16 gs_CumulativeAlignmentOffset_Medley;

DATA_XILVB_B4_SHOW_INIT_BEGIN
int16 gsa_FA_debug_buf[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
int16 gsa_FA_debug_buf_ChDisc[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
int16 gsa_FA_debug_buf_Train[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
int16 gsa_FA_debug_buf_Periodic2[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
int16 gsa_FrameAlignOffsets[MAX_NUM_FRAME_ALIGN_ITERATIONS];
DATA_MAP_END;
#endif // LOG_FA_DEBUG_INFO

//DATA_XILVB_B4_SHOW_INIT_BEGIN
int16 gsa_VecSSyncAlignIn[15];
int16 gsa_VecSSyncAlignOut[15];
uint16 gs_VecSSyncAlignIdx;

DATA_XILVB_B4_SHOW_INIT_BEGIN
// Tracee debug info
int16 gsa_CeilingValues[NUM_CEILING_VALUES];
int32 *gpsa_OPVectorDbgBuffer32;
DATA_MAP_END;

#ifdef LOG_SNR_FDQ_UPDATE
int16 gs_LogIndex = 0;
int16 gs_ToneSelect;
int16 gsa_SnrLog[SNR_FDQ_UPDATE_LOG_LENGTH];
int16 gsa_FdqMantissaLog[2*SNR_FDQ_UPDATE_LOG_LENGTH];
int8 gca_FdqExponentLog[SNR_FDQ_UPDATE_LOG_LENGTH];
#endif // LOG_SNR_FDQ_UPDATE

// !! DEBUGGING
int16 gs_pilotbias;

int16 gs_HybridGain;

DATA_DILVB_BEGIN
// save selected tone index for message decoding during different phases
int16 gs_ToneSelect_Msg_NoEcho;
int16 gs_NumCluster_Msg_NoEcho;
int16 gs_ToneSelect_Msg_ChDisc;
int16 gs_NumCluster_Msg_ChDisc;
int16 gs_ToneSelect_Msg_Train;
int16 gs_NumCluster_Msg_Train;
int16 gs_ToneSelect_Msg_AnaExc;
int16 gs_NumCluster_Msg_AnaExc;

// save debug info for pilot tone selection
int16 gs_PilotToneIdx_Initial;
int16 gs_PilotToneIdx_ChDisc;
int16 gs_PilotToneIdx_Train;
int16 gs_PilotToneIdx_Medley;

int16 gsa_SnrOfPilotTone_Initial[5]; // 5 for SNR around pilot tone
int16 gsa_SnrOfPilotTone_ChDisc[MAX_NUM_PILOT_TONES][5];
int16 gsa_SnrOfPilotTone_Train[MAX_NUM_PILOT_TONES][5];
int16 gsa_SnrOfPilotTone_Medley[MAX_NUM_PILOT_TONES][5];

// XDSLRTFW-4099 : Memory corruption in gla_SnrAccuBuf[] in PsdHandler()& SnrHandler() when RTV Size is 1024
// The buffer is used by SNR and PSD Handler. It must be of size 32bit * RTV size = 32bit *1024
// to hold the SNR/PSD values for 1024 tones. But it is also used to store the Hw values of 48bit, i.e.
// fct. ReadAccumulatedNoise(void), out of which the 32bit values are generated inplace. Therefore it must be 2 * 32bit * 1024.
int32 gla_SnrAccuBuf[((RX_MAX_NUM_TONES>>3)<<1)];
DATA_MAP_END;

/* XDSLRTFW-2858 */
//===================================================
// Debug variables / structures
//===================================================

REIN_Test_Config_t  gt_REIN_Test_Config;
REIN_Test_Status_t  gt_REIN_Test_Status;
int16 gs_RxVarGain_Showtime;
int16 gs_CpeRxHalfRoundTripDelays_ForcedInFraming;
/* XDSLRTFW-2858 */

//===================================================
//Interop debug variables
//===================================================
int16 gs_DetectDelay;
int16 gs_dbgLogSocMsg;      //default not to log SOC message
int16 gs_dbgLogSocMsgPause;      //used to pause logging during AutoRepeat messages

int16 gs_DbgRecnfgCpCsBeta;
int16 gs_DbgTxBetaLength;
int16 gs_DbgTxCPLength;
int16 gs_DbgTxCSLength;
int16 gs_DbgRxBetaLength;
int16 gs_DbgRxCPLength;
int16 gs_DbgRxCSLength;
int16 gs_DbgRxWindowLength;
int16 gs_DbgTimingAdvanceTx;
int16 gs_DbgTimingAdvanceOffset;   // Offset to Timing Advance calculation used for test purposes
int16 gs_DbgTargetTimingAdvance;  // Initial target timing advance used for test
int16 gs_DbgFrameSkewError;

FlagT gft_dbg_DisableMedleyPRBS = 0;
FlagT gft_dbg_ShowSnr = 0;
int16 gs_dbg_ToneOffset = 0;

uint16 gus_DbgFramingChCapInput;  // hard-coded channel capacity [in bits] for FormVDSL2FramingParams()
int16 gs_DbgFramingDisableFlag;

FlagT gft_dbgDisableLoadSrcCoefPostGhs;

FlagT gft_DisableFailState = 0;      //if set to 1, disallowe the modem go to fail state

int16 gs_dbgRxPilotThreshold;
uint32 gul_dbgMiscControl;         // 0x1         -   RX: Disable PLL if recieved pilot tone is less than a configurable threshold
// 0x2         -   Follow Version 4.5 of VDSL2 Draft Standard
// 0x4         -   Disable Tx Periodic transition: Transmit "equivalent" duration of non-periodic signal instead of Periodic signal.
// 0x8         -   Disable Rx Periodic transition:   Expect "equivalent" duration of non-periodic signal instead of Periodic signal.

int16 gs_dbgMaxOHR;



int16 gus_dbgMaxSEQp; //XDSLRTFW-3226 (Start_End)



uint8 guc_dbgFeModemLog2IfftSize;   // To force a given size of far ends IFFT

FlagT gft_dbgSkipLastTwoOPSynchro = 0;
int16 gs_dbgDelayRPSynchro6 = 0;
FlagT gft_DisBitswap_ForIKAN = 0;
FlagT gft_EnableTxPSDCtrl;
//////////////////
// Handshake Hooks
//////////////////

// Handshake messaging
uint32 gul_dbgGHSControl;      // 0x1      - Ignore Mode Select Message
// 0x2      - Disable T1 MCM Vdsl1 in SI Spar1
// 0x4      - Support STM in SI Npar2 for VDSL1
// 0x8      - Support Init CE Length in SI Spar2 for VDSL1


FlagT gft_CL_CLR_Comparison;
FlagT gft_FW_Initiate_Retrain;
//////////////////
// Training Hooks
//////////////////

// Signal Detection Thresholds
int16 gs_dbg_NUM_NONSILENCE_SYMBOLS_THRESH;

// State transition timing
int16 gs_DbgRPSynchro1TransitionDelay;
int16 gs_DbgOPSynchro1TransitionDelay;
int16 gs_dbgDelayTxSynchro2;
int16 gs_dbgDelayRMsg2;
int16 gs_dbgRPTrain1Delay;
int16 gs_dbgROPTrain1Delay;

// SoC Messaging
uint32 gul_SocMsgNotCompliedAmends;                     // if soc msg shows that part (but not whole) of an
// amendment is there, the amend-per-msg bit will be set:
uint32 gul_dbgSocMsgControl, gul_dbgSocMsgControl2;
int16 gs_dbgLimitUsMaxNomPsd;

// PRBS
uint8 guc_dbgMedleyTxPrbsSkipBits;
uint8 guc_dbgMedleyRxPrbsSkipBits;

// Bitloading and B/G/T Message Control
uint8 guc_dbgForceEvenNcLoaded;
uint32 gul_dbg_DILV_MEM_SIZE;
int16 gs_dbgTxBgMsgInsertZeros, gs_dbgRxBgMsgIgnoreZeros, gus_dbgTxBgMsgAppendBi0Gi1;

// Showtime Transition Timing
int16 gs_dbgAdvanceTxSynchro2, gs_dbgAdvanceEnableXTC, gs_dbgDelayTxShowTransition, gs_dbgDelayRxShowTransition;

//////////////////
// Showtime Hooks
//////////////////

// Showtime Data Pump
uint32 gul_dbgShowtimeControl;      // 0x1      -   TX: Register Start Tx FC
// 0x2      -   TX: Register Start Tx XTC
// 0x4      -   TX: Split Tx processing to isolate CRC byte
// 0x8      -   TX: Bit Reverse CRC and do not pass it through scrambler
// 0x10      -   RX: Fix CRC byte in the CWRAM to get around non-compliant far-end's
//            that do not scramble the CRC
// 0x20      -   RX: Fix data byte in the BCR when CRC is not accessible in CWRAM due to PMS
//            PMD frames being aligned to get around non-compliant far-end's that do not scramble the CRC
// 0x40      -   VDSL1 Disbale Eoc
// 0x80      -   VDSL1 Tx Eoc Swap Address and Control Field
// 0x100   -   VDSL1 Tx Eoc Swap LSB and MSB of Data Field
// 0x200   -   VDSL1 Tx Echo back the far end FCS in Tx EOC message
// 0x400   -   VDSL1 Rx Ignore the far end FCS
// 0x800   -   VDSL1 Rx Eoc Swap Address and Control Field
// 0x1000   -   VDSL1 Rx Eoc Swap LSB and MSB of Data Field
// 0x2000   -   VDSL1 Rx Eoc Process any OPCodes recieved during Read/Write state instead of sending UTC
// 0x4000   -   VDSL1 Rx reformat the LATN data sent for CNXT far ends
// 0x8000   -   VDSL1 Rx reformat the SNRM data sent for CNXT far ends
uint8 guc_dbgIncreaseFifoLength, guc_dbg_ZEP_MAX_RX_FC_RUN_CNT;
uint16 gus_dbgRecievedFcs;

#ifdef TX_CRC_SCRAMBLE_DISABLE
// Globals to implelent TX functionality of bit-reverse TX CRC and NOT pass it through scrambler
int16 gs_MuxFrameCount, gs_CodewordRateBufferSize, gs_PMDRateBufferSize, gs_AZRunCount, gsa_AZRunSize[4], gs_MuxFramePerOvhdSuperframe, gs_maxAZRunCount, gs_RxMuxFramePerOvhdSuperframe, gs_RxPmsPmdAlignedState;
#endif

#ifdef RX_CRC_SCRAMBLE_DISABLE
// Globals to implelent RX functionality to bit-reverse RX CRC and NOT pass it through descrambler
int16 gs_RxMuxFramePerOvhdSuperframe, gs_RxPmsPmdAlignedState;
uint16 gus_RxDtByteIdx, gus_RxCodewordsBuffered;
uint32 gul_dscrm;
#endif

//Keeps a count of the # of rogue HDLC octets
//Send a UTC on recieving threshold many rogue octets, -1 implies Disabled
int16 gs_dbgRogueHdlcOctets, gs_dbgRogueHdlcOctetThreshold;

FlagT gft_dbg_SkipTxSyncFrame; // debug feature to skip TX showtime sync frame
FlagT gft_dbg_SkipRxSyncFrame; // debug feature to skip RX showtime sync frame


//==============================================================================
// Sniffer Variables
//==============================================================================
uint32 gul_dbgSnifferControl;      // 0x1         -   TX: Disable Transmitter
// 0x2         -   Disable Swap Timing
// 0x4         -   Pre-pone GHS Codeswap
// 0x8         -   Disable GHS state machine
// 0x10         -   Disable GHS Timeout check
// 0x20         -   Disable Training state machine
// 0x40         -   RX: Enable Decision Directed Pilot
// 0x80         -   RX: Bypass interpreting of recieved SoC message
// 0x80000000   -   Pause "gs_dbgSnifferPauseControl" symbols after Msg Detection
int16 gs_dbgSnifferMedleyTransitionControl, gs_dbgSnifferRxToneOffsetControl;


//==============================================================================
// DEBUG variables for simulation
// - used only for simulation platforms: COCOMO, ASIM, ARC
// - should be excluded for the target HW build
// - variables used for COCOMO and ASIM builds may be allocated to separate
//   memory space, which does not exist in real HW
//==============================================================================

#if defined(TARGET_HW_TEST)
int16 gs_test_sf_cnt;
int32 gl_ExitSymbolCount;
#endif


#ifdef POLLING_CORE_INTERRUPTS
int16 gs_FDInterruptSource;
#endif

// variables used for COCOMO and ASIM builds
// may be allocated to separate memory space, which does not exist in real HW

DATA_EXT_BULK_BEGIN

#ifdef SAVE_REVERB_FDQ
int16 gsa_ReverbFdqMantissa[2*RX_MAX_NUM_TONES];
uint8 guca_ReverbFdqExponent[RX_MAX_NUM_TONES];
#endif //SAVE_REVERB_FDQ

#ifdef SAVE_MEDLEY_FDQ
int16 gsa_MedleyFdqMantissa[2*RX_MAX_NUM_TONES];
uint8 guca_MedleyFdqExponent[RX_MAX_NUM_TONES];
int16 gsa_MedleyMfdqFFMantissa[2*MAX_MFDQ_TONES];
int16 gsa_MedleyMfdqFBMantissa[2*MAX_MFDQ_TONES];
uint8 guca_MedleyMfdqFBExponent[MAX_MFDQ_TONES];
#endif //SAVE_MEDLEY_FDQ


#if (defined(CAPTURE_AFE_TX_OUT) || defined(CAPTURE_AFE_RX_IN))
int16 gs_CoCpeFlag = 0;   //0-> CO, 1->CPE
#endif

#ifdef CAPTURE_AFE_TX_OUT
int16 gs_CaptureAfeTxOutFlag = 0;   //disable capture
int16 gs_TxAfeFrameCount = 0;
int16 gs_TxPreAfeFrameCount = -1;
FILE *fpAfeTx = NULL;
#endif //CAPTURE_AFE_TX_OUT

#ifdef CAPTURE_AFE_RX_IN
int16 gs_CaptureAfeRxInFlag = 0;   //disable capture
int16 gs_RxAfeFrameCount = 0;
int16 gs_RxPreAfeFrameCount = -1;
FILE *fpAfeRx = NULL;
#endif //CAPTURE_AFE_RX_IN

DATA_MAP_END;

int16 gs_LOS_override_cnt;                            // used to override the no. of LOS defects
//int16 gs_ncd_override_cnt[NUM_BEARER_CHANNELS];      // used to override the no. of NCD anomalies
//int16 gs_lom_override_cnt;                     // used to override the no. of LOM defect
//int16 gs_sef_override_cnt;                     // used to override the no. of SEF defect
//int16 gs_expected_sync_byte1;
//int16 gs_expected_sync_byte2;

//============== Variables used by the new Zephyr  ======================
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
uint8 guc_8khz_count;
uint16 gus_LinkDownState_SymCount;
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
// XDSLRTFW-1218 Bugfix_ALL_VDSL2_ALL_DataCollect (Start / End)
FlagT gft_LinkDownState_Cntrl;


uint32 gula_txILVBaseAddr[2];
uint32 gula_rxILVBaseAddr[2];
uint32 gul_RtxQBaseAddr;

uint32 gul_DTBLOOP_lastTxSize = 0;

#ifdef CHECK_ILV_MEM_ERROR
int32 gl_IlvMemErr_Cnt = -1;
#endif //CHECK_ILV_MEM_ERROR

#ifdef ZEP_DEBUG_BLD

//Data used for capture the scrambler input and output data
int16 gs_TxScamNumBytesPerSym;   //the estimated number of bytes per symbol to going to TX scrambler
int16 gs_CapturedTxScamSyms;   //the captured TX number of symbols
int16 gs_TxCapBufFullness;      //the number of bytes left in TX capture buffer
int16 gs_TxPreWRPTR;         //the previous TX FIFO3 write pointer

int16 gs_RxScamNumBytesPerSym;   //the estimated number of bytes per symbol to going to RX scrambler
int16 gs_CapturedRxScamSyms;   //the captured RX number of symbols
int16 gs_RxCapBufFullness;      //the number of bytes left in RX capture buffer
int16 gs_RxPreWRPTR;         //the previous RX FIFO3 write pointer

FlagT gft_TxFifo3Capture = 0;   //TX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
FlagT gft_RxFifo3Capture = 0;   //RX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
FlagT gft_EnableFifo3Capture = 0; //if set to 1 enable FIFO3 capture


#endif //#ifdef ZEP_DEBUG_BLD

//#ifdef VR9_ERASURE
FlagT gft_erasure_on =1 ;
int16 gs_wb_maxscore = 0xFFE;
//#endif //VR9_ERASURE
uint32 gul_metric_value;                              // Erasure Metric value

//NOTE : Please don't disturb the order in which following erasure metric variables are defined as they are used in debug buffer for memcpy => contiguous memory location needed
//Erasure metric variables order starts

//the max impulse width is 7/40 and the max shine is 63 symbols
//In 200 DMT symbols period the worst case would be 7*5 +63 =98 frames get corrupted.
uint32 gul_num_frame_lowmetric;
uint16 gus_metric_eval_cnt;
uint16 gus_lowmetric_detect_cnt, gus_lowmetric_detect_period=200;
uint16 gus_lowmetric_discard_cnt,  gus_lowmetric_discard_max =100;

uint16 gus_metric_eval_period = 12000;
uint16 gus_LowPowerSetting = 0; //low power setting in dying gasp
uint8 guc_metric_discard_threshold;
uint8 guc_max_metric;
uint8 guc_min_metric;
//Erasure metrics to calculate the threshold to discard frames for DD
FlagT gft_frame_with_lowmetric, gft_Calculate_EdMetric_PilotPwr_Threshold =1; //XDSLRTFW-2481
FlagT gft_DisableDiscardFrame = 0;

//Erasure metric variables order ends

//Rein noise profile REIN-86dbmPhz-IL1.4-p10ms
//max metric =120, min_rein = 10
uint16 gus_rmetric_scale = 0xB; //number of positions to shift priot to satuation
uint32 gul_CntrTrellisTonePairs;
uint32 gul_MaxQtScore;
uint8 guc_msb;

//---------------------------------------------------
// VR9 debug control variables
//---------------------------------------------------
int16 gs_CRI_DbgCntl = 0;   //debug control variable for CRI
int16 gs_STR_DbgCntl = 0;   //debug control variable for Strymon
uint8 guc_ftb_tx_qt;       // changed from signed int to unsigned int to remove warning
uint8 guc_ftb_rx_qt;

FlagT gft_SkipTxQtStallCheck = 0;
FlagT gft_SkipRxQtStallCheck = 0;

#if defined (VR9_BRINGUP_DBG) || defined (BIT_PATTERN_TEST)
//int32 jgSERDESLoop = 0x100; // 0x100 to loop, 0 to not.
int32 jgSERDESLoop = 0;

FlagT gft_EnableGetRxTime = 0;
FlagT gft_TriggerGetRxTime = 0;
int16 *gpsa_RxTimeBuffer = (int16 *)0x64000; //FFT buffer

FlagT gft_EnableGetIfftBuf = 0;
FlagT gft_TriggerGetIfft = 0;
int16 *gpsa_IfftBuffer = (int16 *)(0x60000); //IFFT buffer, 0x4000 for 8192 samples

FlagT gft_EnableGetGhsRxTones = 0;
FlagT gft_TriggerGetGhsRxTones = 0;

FlagT gft_BypassPGATrain;
FlagT gft_SkipInitAfeHSExit;

int16 gsa_ForcedToneIdx[3] = {257,383,511};
int16 gsa_ForcedToneValue[6] = {TX_NEG165DBM, 0, -TX_NEG165DBM, 0, TX_NEG165DBM, 0};

//Log the DTB data
//CHECH_DTB
FlagT gft_CapDtbFlag = 0;   //0: no capture, 1, capture TX DTB, 2: capture RX DTB
uint16 *gpusa_DbgDtb = (uint16 *)0x62000;
int16 gs_DbgDtbSize = 0x1000;
int16 gs_DbgDtbCnt = 0;
int16 gs_NumBytesInDtb = 4;
int16 gs_NumBytesInDtbCheck = -1;

int16 gs_DtbPtrBufCnt = 0;
int16 gs_DtbPtrBufSize = 0x400;   //1024 frames
uint16 *gusa_ZEP_DTBPTR_DbgBuf = (uint16 *)0x63000;
uint16 *gusa_QT_DTBPTR_DbgBuf = (uint16 *)0x63400;

#ifdef PROFILE_TASKS_VR9
//Log the task overruns
FlagT gft_EnableLogOverrun = 0;
int32 gl_TaskOverRunBufCnt = 0;
int16 gl_TaskOverRunBufSize = 4000;
int32 *gpla_TaskOverrunBuf = (int32 *)(0x60000);
#endif //#ifdef PROFILE_TASKS_VR9

#endif //#ifdef VR9_BRINGUP_DBG

#ifdef LOG_PILOT_CONSTELLATION
int16 *gpsa_PilotBuf = (int16 *)0x60000;
int16 gs_PilotBufSize = 0x4000;      //16384
int16 gs_PilotLogSymStep = 1;
int16 gs_PilotLogSymCnt = 0;
int16 gs_PilotLogCnt = 0;
FlagT gft_StartPilotLog = 0;
FlagT gft_EnablePilotLog = 0;
#endif //#ifdef LOG_PILOT_CONSTELLATION

#define LOG_LOWMETRIC
FlagT gft_EnableLogLowMetric = 0; //disable this logging by default
FlagT gft_frame_with_lowmetric_pre = 0;
int16 gs_LogLowMetricCnt = 0;
int16 LogLowMetricBufSize = 0x2000;      //8192;
int32 *gpla_LogLowMetricBuf = (int32 *)(0x60000);


#ifdef BIT_PATTERN_TEST

uint16 gus_BitPatternIndex =0;
uint8 guc_FindPathDelayState;
uint8 guc_FindSampleDiffState;
int16 gs_BitPatternToneOffset;
int16 gs_PathDelay; //loopback path delay

uint16 gus_BitPatternError;
uint16 gus_BitPatternVal =8192;

uint32 gul_NumDiff;
int16  gs_DiffLogIndex;
int16  gs_CompareLog_Enable = 1;

#endif //BIT_PATTERN_TEST

DbgAllowedToneInfo_t gt_DbgAllowedToneInfo;

uint16 gus_UseUS0OnlyCntrl;
FlagT gft_DisableUseUS0Only = 0;
// XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft (START_END)
FlagT gft_EVLT_IOPtuning = 0;

int16 gs_O_UpdateTAC_backup;
int16 gs_ForceTimingAdvanceCorrection = 0x7fff;
int16 gs_MaxCapTAValue; //Debug variable to force max value of TAC (default MaxTAC is 300)
//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (end)

int16 gs_ZEP_DTB_SIZE_TX_WDS;
int16 gs_ZEP_DTB_SIZE_RX_WDS;

int16 gs_ZEP_ILV_RAM_TXDTB_OFFSET;
int16 gs_ZEP_ILV_RAM_RXDTB_OFFSET;

int16 gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE;
int16 gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
int16 gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE;

int16 gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
int16 gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE;
int16 gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE;
int16 gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE;


DATA_LOCAL_LD_ST_BEGIN

// ReTX related variables
uint8 guc_RxUcodeHandle, guc_TxUcodeHandle;

RRC_Stat_t gt_RrcStat;
ReTX_Stats_t gt_ReTXStats;
ReTX_Params_t gt_ReTXParams;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
uint16 gus_DsUsReTxStatus;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)
uint16 gus_PPE_INPUT_MAX; //XDSLRTFW-2942 (Start_End)
ReTx_RxDebug gt_ReTxDebug;

uint8 guc_Wr_SID_idx;
uint8 guc_Rd_SID_idx;
uint8 guc_EstimatedTS;
uint8 guc_maxdtuout = 2;


volatile uint32 gul_ZrFifoSetupWait;
volatile uint32 gul_ZrFifoReadWait;
uint32 gul_ZrFifoValidBytes;

QretxTableEntry_t gta_QretxTable[QRETX_TRANS_TABLE_SIZE];

//XDSLRTFW-1393 (Start)
FlagT gft_DsSraReTxInit;  //To Init vars before transition to new SRA params.
FlagT gft_Qrx_Full;

//To detect DTU Stoppage period
uint8 gft_SRAInvSync_Detected;
FlagT gft_DTU_Stoppage_Detected;
FlagT gft_Start_DTU_Stoppage_Detection;
uint8 guc_DTU_Stoppage_Detect_Cntr;
uint8 guc_DTU_Status_Arr_Indx;
DTU_Status_t gt_DTU_Status_Arr[63+1]; //Max QTx => 63 (Table A.6 of G.998.4 (G.Inp) standard)
//XDSLRTFW-1393 (End)

//int32 gl_RxHalt;
int32 gl_NoRetxMsg;         // bit-0 set = RETX not detected in OSMG1
// bit-1 set = RETX not detected in OTPS
// bit-2 set = msg is not amend 1&3 compliant in OTPS
// bit-3 set = RETX not detected in OPMS


FlagT gft_NotFirstDTU;
//FlagT gft_ForwardDtusToPPE;
//FlagT gft_EnableXdtuWrite;
//FlagT gft_InsertRRC; //Not used in code

uint8 guc_ReTX_CRC1_ReportTS;
uint16 gus_ReTX_crc1;

uint8 guc_Prev_Rd_SID_idx;
uint8 guc_Curr_Wr_DTU_idx;
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start)
uint8 guc_Prev_Rd_SID;
uint8 guc_Prev_Rd_DTU_idx;
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (End)
//int16 gs_extra_DTU =20; //Not used in code

#ifdef DEBUG_GINP_MSGS
// debug ReTX training messages
uint8 guc_DebugReTXTrainingMsg; // 1 - debug OMSG1; 2 - debug OPTS; 3 - OPMS
uint8 *gpuca_GINP_MsgBuf;
int32 gl_GINP_StartIdx;
int32 gl_GINP_MsgLength;
#endif

//XDSLRTFW-1393 (Start)
#ifdef ENABLE_RETX_DS_DEBUG
uint8 guc_ReTxDebugBufWrEnable;
uint16 gus_ReTxDebugBufIdx;
uint8 *gpuca_ReTxDebugBuf;
#endif
//XDSLRTFW-1393 (End)
//XDSLRTFW-1571 (Start)
#ifdef ENABLE_THREE_NEEDLE_TEST
uint8 guc_StartThreeNeedle;
uint8 guc_ThreeNeedleBadDTUCount;
uint8 guc_ThreeNeedleCount;
uint8 guc_CountToNextNeedle;
uint16 gus_ThreeNeedleDurationCount;
uint16 gus_ThreeNeedleDuration;
#endif

QueueNode_t gt_NodeList[QRETX_TRANS_TABLE_SIZE];
QueueStatus_t gt_FreeBufList;
uint8 guca_InpBufList[ILVB_WRPTR_TABLE_SIZE_LW];
uint8 guc_InpBufListIndx;
//uint32 *gpul_ILVBWrptrTable;
//XDSLRTFW-1571 (End)

DATA_MAP_END;


DATA_DILVB_BEGIN
//OP-VECTOR Detector variables
int32 gla_EnergyArr[257];
int32 gl_NoiseEnergyAverage;
int32 gl_EnergyExit;
int32 gl_EnergyFourAdjFrm;
int32 gl_MaxEnergy;
int32 gl_MaxEnergyPrev;
int16 gs_OPVector1_SyncSymCnt = 0;
int16 gus_NoSyncSymbolEnergyCnt;
DATA_MAP_END;


DATA_LOCAL_LD_ST_BEGIN

//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START)
FlagT gft_MipsAvgStart1;
long long int gl_MaxMIPSCntSumN;
int32 gl_MaxMIPSCntAvg;
int16 gs_MipsCntRun;
int32 gl_FGMipsCnt[MAX_MIPS_LOGGING_COUNT];
//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(END)

// XDSLRTFW-2774 (Start)
FEDataArrays_t gt_FEParams;
// XDSLRTFW-2774 (End)

//US ReTX related Global variables Start
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (Start)
int16 gft_InitialRRC = TRUE;

#ifdef ENABLE_RETX_US_DEBUG
FlagT gft_RRCworkaround;
#endif
#ifdef DEBUG_RETX_LOG ////For Debug_UsRetx
FlagT gft_REIN_NoiseUS;
int16 gs_US_InterArrivalTime = 0;
int16 gs_num_US_REIN_impulses;
int16 gs_max_num_US_REIN_impulses;
uint16 gs_num_corrupted_RRCs;
uint16 gs_corrupted_RRC_cnt;
FlagT gft_corruptRRC;
uint16 gus_log_index;
uint16 gus_retx_log_type;
#endif // DEBUG_RETX_LOG ////For Debug_UsRetx
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC(End)

//XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx(START_END)
//Time stamp byte of ReTx DTU => counts the number of tx symbols
uint8 guc_TS_byte_Retx=0;
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START_END)
FlagT gft_Enable_UsReTx = 2;
//US ReTX related Global variables End
DATA_MAP_END;

//XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
FlagT gft_TonesDetected =0;
FlagT gft_Log_Symbol_Count_Start = 0;
uint16 gs_RxIndex = 0;
int32 *gpla_RxTone_Buffer;
#endif
//XDSLRTFW-2288 (End)

// Variables Mapped to DSL cmvs
uint16 gus_ApiOptions;         //[DSL_OPTIONS]
uint16 gus_DSL_TC_Status;   // CMD_TC_StatusGet / DSL_TC_STATUS / DSL 14
uint16 gus_PpeClockControl;   //[DSL_PPE_CLOCK_CONTROL]

// XDSLRTFW-3565 (Start_End)
uint16 gus_PPEClockConfigure = FSCALE_AUTO_A;   // This variable is linked to CMV DSL 34 --> It indicates the Mode configured for PPE clock Frequency scaling
uint16 gus_PPEClock_Configured;  // This variable is linked to CMV INFO 244 --> This indiactes the configured PPE clock frequency

// Data buffers for saving data off chip (SRAM)
DATA_MAP_SRAM_BAR15
int16 gsa_MedleySnrBuf[RX_MAX_NUM_TONES];
int16 gsa_ReverbSnrBuf[RX_MAX_NUM_TONES];
uint8 guca_offChipDebugBuff[RAW_DUMP_MAX_SDRAM_SIZE_BYTES]; // memory reserved to write guca_DebugBuf[] buffer data SDRAM
DATA_MAP_END;

DATA_MAP_SRAM_BAR16
int16 gsa_Periodic1SnrBuf[RX_MAX_NUM_TONES];
int16 gsa_DiscPsdBuf_EchoOff[RX_MAX_NUM_TONES];
int16 gsa_DiscPsdBuf_EchoOn[RX_MAX_NUM_TONES];
uint32 gula_RrcCaptureBuffer[256];  // Buffer for capturing RRC CodeWords  // XDSLRTFW-1622 (Start_End)
// The following variables were commented out and were stored in BAR-14. Since, BAR-14 is owned by PPE FW
// moving these variables to BAR-16 to prevent illegal access. Also the size of the buffer needs to be modified
// to account for 8K and XDMA has to be used to trigger the copying of data to these buffers !!!!!
// XDSLRTFW-3344 (Start)
int16 gsa_RxHLog_PerTone[RX_MAX_NUM_TONES];
uint8 guca_QLN_PerTone[RX_MAX_NUM_TONES];
// XDSLRTFW-3344 (End)
DATA_MAP_END;

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
ModemFeatureMap_t gt_VdslFeatureMap;
uint32 gul_ExceptionCode = 0;

//XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
uint16 gus_DacTrimVal;
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
ReInit_Thresholds_t gt_ReInit_Threshold;
//XDSLRTFW-2387 (Start)
FlagT  gft_ReducePilotThr;
uint8  guc_PilotSelectionFailure;
//XDSLRTFW-2387 (End)
int16 gs_KL0_tone_count; //XDSLRTFW-2379 (Start_End)
//XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start)
//For Debug
uint8 guc_QRxFullCntr; //XDSLRTFW-3182 (Start_End)
uint8 guc_QRetxTableFullCntr;
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start)
uint16 gus_DropPktCntr;
uint16 gus_BufOverWriteCntr;
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (End)


int16 gs_cl_bonding;
int16 gs_clr_bonding;

//XDSLRTFW-1617 (Start)
FlagT gft_Intra_DTU_Ilv_DS;
uint8 guc_DS_ReTx_Max_D_CO_support;
uint8 guc_ReTx_US_D;
uint8 guc_ReTx_DS_D;
uint8 guc_IntraDtu_DS_D;
uint32 gul_Bytes_in_fifo;
//XDSLRTFW-1617 (End)
int32 gl_ReTxFramingStart = 0;  //XDSLRTFW-1610 (START_END)
// XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (End)
// XDSLRTFW-441 (START)
ERBParams_t gt_ShowtimeErbParams;  // This variable stored the ERB parameters from the current  OHC Error Feedback request

DATA_MAP_PERSISTENT_ADSL
int32 gl_SelectedMode;  // Taken from ADSL memory persistent memory, to verify if it's aligned with ADSL memory map
int32 gl_Test_Persistmem_Adsl; // Taken from ADSL memory persistent memory, to verify if it's aligned with ADSL memory map
// Don't add anything here, and is reserved for ADSL persistent memory.
DATA_MAP_END;

// XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
// - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
// - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
// - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
// - failstate history is shared between ADSL and VSDL codes -  so it needs to be in COMMON persistent memory

// Structure of VDSL persistent memory:
// Bytes  0 -  3 : gl_Test_Persistmem_Vdsl
// Bytes  4 - 38 : gt_FailStateInfo
DATA_MAP_PERSISTENT_VDSL
int32 gl_Test_Persistmem_Vdsl;
FailStateInfo_t gt_FailStateInfo;
uint16 gus_TxStrymonOverflowCnt_Medley = 0;
FlagT gft_TxStrymonOverflow = FALSE;
DATA_MAP_END;

// Structure of COMMON persistent memory:
// Bytes  0 -  3 : gl_Test_Persistmem_Common
// Bytes  4      : gft_ATM_PTM_MisMatch_TTNet
// Bytes  6 -  7 : gus_VendorSpecific_Info
// Bytes  8 - 11 : gul_DSH_SymCount
// Bytes 12 - 31 : gula_FailStateHistory[5]
DATA_MAP_PERSISTENT_COMMON
int32 gl_Test_Persistmem_Common;
FlagT gft_ATM_PTM_MisMatch_TTNet;      //XDSLRTFW-1983
uint16 gus_VendorSpecific_Info;        //XDSLRTFW-1983
uint32 gul_DSH_SymCount;
uint32 gula_FailStateHistory[5];       //XDSLRTFW-3665
DATA_MAP_END;
// XDSLRTFW-441 (END)

//To Dump Rx DTB
uint32 gul_RxDTBSize = 0;
uint32 gul_RxDTBBase = 0;
uint32 gul_RxDTBOffset = 0;
uint32 gul_DTBRdPtr = 0;
uint32 gul_DTBWrPtr = 0;
uint32 gul_PrevDTBWrPtr = 0;
uint32 gul_PrevDTBRdPtr = 0;
uint16 gus_StopDump = 0;
uint16 gus_DTBBufIdx = 0;
uint8 *gpuc_DTBBuf = (uint8 *)(0xA2400); //Total mem available = 23K
uint16 gus_DTBBufSize = (23*1024);
uint16 gus_WrapAround = 0; //1 = enable wrap around of local 24K buffer, 0 = disable wrap around
//
//
// DO NOT PUT VARIABLES BEYOND THIS LINE
//
//
