/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   initfifo.c
*
*   Functions for initializing FIFOs, TCBs.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "mtkernel.h"
#include "states.h"
#include "showtime.h"


void NtrInterruptHandler(void);


/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void tcb_init(void);
*
*   Description:
*
*      Initializes the Task Control Blocks for each interrupt.
*   This includes assigning the Time Critical (TC) and Non-Time
*   Critical (NTC) Tasks for each interrupt.
*
*   Arguments:
*      none
*
*   Global Variables:
*      gt_TaskArray   --  Array of Task Control Block structures.
*
*-------------------------------------------------------------------
*^^^
*/
void tcb_init(void)
{
   int16 i;

   /* Setup the task control block for each interrupt */
   for (i=0; i<NUM_INTERRUPTS; i++)
   {
      gt_TaskArray[i].Next= (TCB_t *) NULL;
      gt_TaskArray[i].TaskID = i;
      gt_TaskArray[i].NonTimeCriticalTask = (PtrToFunc) NULL;
      gt_TaskArray[i].TimeCriticalTask= (PtrToFunc) NULL;
   }

   //Assign time-critical and non-time critical task for TX used during training
   gt_TaskArray[TX_QT_DONE].TimeCriticalTask = TxProcessTones;
   gt_TaskArray[TX_QT_DONE].NonTimeCriticalTask = TxForeGround;

   //Assign the TX processing to the frame start interrupt for situations
   //in which the QT processing is disabled, e.g. for DSP control of
   //transmit waveform.
   gt_TaskArray[TX_FRAME_START].TimeCriticalTask = TxProcessTones;
   gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask = TxForeGround;

   //NTR interrupt handling function, triggered on an NTR counter wrap.
   gt_TaskArray[RX_FC_NTR].TimeCriticalTask = NtrInterruptHandler;
   // Assign 2nd time-critical task for TX used only during showtime.
   // NTC for this interrupt remains NULL.
   gt_TaskArray[TX_PARR_DONE].TimeCriticalTask = TxParrReshuffle;

   //Assign time-critical and non-time critical task for RX used during training
   //RX processing is typically executed on QT DONE interrupt
   gt_TaskArray[RX_QT_DONE].TimeCriticalTask = RxProcessTones;
   gt_TaskArray[RX_QT_DONE].NonTimeCriticalTask = RxForeGround;

   //Assign the RX processing to the frame start interrupt for situations
   //in which the QT processing is disabled, e.g. for DSP access to
   //the FFT buffers
   gt_TaskArray[RX_FRAME_START].TimeCriticalTask = RxProcessTime;
   gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask = RxForeGround;

#ifdef DISTRIBUTE_TX_RX_PROCESS
   gt_TaskArray[RX_TIMER_DONE].TimeCriticalTask = RxProcessTime;
   gt_TaskArray[RX_TIMER_DONE].NonTimeCriticalTask = NULL;
#endif // DISTRIBUTE_TX_RX_PROCESS


   SizeTcb = sizeof(TCB_t);

   // Initialize foreground queue
   KernelInit();
}
/*************
The following function handle the background queue: We will use the same TCB structures, but
will only fill the non-time critical tasks
**************/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitBackground
 *
 *
 *  Prototype:
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void InitBackground(void)
{
   int16 i;


   for (i=0; i<NUM_BG_BUFFERS; i++)
   {
      gt_BGTaskArray[i]= (PtrToFunc) NULL;
   }

   gp_BGTaskFifo=&gt_BGTaskFifoBuf;

   gp_BGTaskFifo->BufferSize=NUM_BG_BUFFERS;
   gp_BGTaskFifo->ErrorCode=0;
   gp_BGTaskFifo->FunctionBuffer= &gt_BGTaskArray[0];
   gp_BGTaskFifo->IndexOfOldest=0;
   gp_BGTaskFifo->NextAvailable=0;
   gp_BGTaskFifo->PendingFunctionCount=0;
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitTxLoadingFunctionFifo
 *
 *  Prototype:  void InitTxLoadingFunctionFifo(void)
 *
 *      initializes the fifo used to hold the TxLoadingFunctions.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */



void InitTxLoadingFunctionFifo(void)
{
   gp_TxLoadingFunctionFifo[0] = 0;

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitRxLoadingFunctionFifo
 *
 *  Prototype:  void InitRxLoadingFunctionFifo(void)
 *
 *      initializes the fifo used to hold the RxLoadingFunctions.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */



void InitRxLoadingFunctionFifo(void)
{
   gp_RxLoadingFunctionFifo[0] = 0;
   gp_RxLoadingFunctionFifo_FC[0] = 0;
}

