/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   profile.c
*
*   function used to generate the task profiling information
*
*-------------------------------------------------------------------------
*/

#include <stdarg.h>
#include "common.h"
#include "gdata.h"
#include "cri_iof.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "PrintTrail.h"
#include "stdio.h"
#include "vdsl_state.h"
#include "cmv_Data.h"
#include "LL_IOf.h"
#include "nmp.h"
#include "cmv.h"
#include "dsp_op.h"
#include "profile.h"
#include "states.h"
#include "eoc.h"


#ifdef VRX518_BRINGUP_DEBUG
extern uint8 *gpuca_StVectoringBuffer;
#endif

//--------------------------------------------
// "break point" may be triggered based on
// rxstate,txstate/substate,substatecnt/symbolcount
//--------------------------------------------
int16 gs_BPRxStateTrigger = (-2);
int16 gs_BPTxStateTrigger = (-2);
int16 gs_BPSubStateTrigger = (-2);
int16 gs_BPSubStateCntTrigger = (-2);
int32 gl_BPSymbolCntTrigger = (-2);

//--------------------------------------------
// Trail collections may be triggered based on
// rxstate/rxsubstate/rxsymbolcount.
// The following variables are used to set
// the trigger point.
// The variable
//--------------------------------------------
int16 gs_RxStateTrigger = (-2);
int16 gs_RxSubStateTrigger = (-2);
int32 gl_SymbolCountTrigger = (-2);
#ifdef DEBUG_TRAIL
int16* gps_StatesTrailIndex;

/*****************************************************************************
;   Prototype: DebugTrail1(int16 s_count, ... )
;
;   Description:
;   Declare function to take variable number of input arguments first argument
;   (s_count) specifies # of input arguments for logging second argument
;   specifies the log type the subsequent s_count arguments forms the log data
;
;   Arguments:
;
;   Return:
;
;   Global Variables:
;
;****************************************************************************/
void DebugTrail1(int16 s_count, ... )
{
   va_list argp; /* arg ptr */
   int16 s_logType[2];

   /* initalize var ptr */
   va_start( argp, s_count );

   /* check if valid logtype */
   s_logType[0] = va_arg( argp, int16 );
   s_logType[1] = va_arg( argp, int16 );
   if ((gt_debugTrailControl.s_logType[0] & s_logType[0]) || (gt_debugTrailControl.s_logType[1] & s_logType[1]))
   {
      /* repeat for each arg */
      while(s_count-- > 0 && gt_debugTrailStatus.s_debugTrailIndex < gt_debugTrailStatus.s_debugTrailSize)
      {
         *(INFOMap[INFO_DebugTrail] + gt_debugTrailStatus.s_debugTrailIndex) = va_arg( argp, int16 );
         gt_debugTrailStatus.s_debugTrailIndex++;
         if (gt_debugTrailControl.s_cyclicTrailUpdate &&
               gt_debugTrailStatus.s_debugTrailIndex == gt_debugTrailStatus.s_debugTrailSize)
         {
            gt_debugTrailStatus.s_debugTrailIndex = 0;

            //Update the wrap around count
            gt_debugTrailStatus.s_debugTrailWrapCount++;
         }
      }
   }

   /* done with args */

   va_end( argp );
}
#endif // DEBUG_TRAIL





/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*   external debug reads and writes to be performed.
*
*-------------------------------------------------------------------
*^^^
*/
//Feature_DS_VDSL2_ALL_UsReTx XDSLRTFW-1077 Rx RRC word (Start)

//FlagT gft_PauseOff = FALSE, gft_Resume;
//Feature_DS_VDSL2_ALL_UsReTx XDSLRTFW-1077 Rx RRC word (Start)

void Pause(int16 s_Marker)
{
   if (gft_PauseOff)
   {
      return;
   }

   // Disable DSL interrupts so that the state machine's MP handler
   // does not interfere with the handler loop in this function.
   // Disable all Tx/Rx core interrupts
   DisableAllInterrupt();


   // disable Arc level 1 interrupts
   _disable1();

   gs_PauseMarker = s_Marker;
   gft_Resume = 0;
   // XDSLRTFW-2186(Start)
   if (gs_PauseMarker == 1)
   {
      while (gft_Resume == 0) {
         gft_Resume = 0;
      }
   }
   else
   {
      while (gft_Resume == 0) {
         NewMPCheckMessage();
      }
   }
   // XDSLRTFW-2186(End)
}



/*****************************************************************************
;   Prototype: void TxProfileHandler(void)
;
;   Description:
;      Called each frame from RxForeground, this function logs the state transition
;   information.
;
;   Input Arguments:
;
;   Return:
;
;   Global Variables:
;****************************************************************************/


void TxProfileHandler(void)
{
   static int16 s_PrevTxState=-1, s_PrevTxSubState=-1;
   if(s_PrevTxState != gs_TxState)
   {
      uint16 usa_stateArray[] =  {gs_RxState,gs_TxState};
      DSH_SendEvent(DSH_EVT_STATE_CHANGE,4,&usa_stateArray);
   }

   if(gs_TxSubState != gs_TxSubState)
   {
      uint16 usa_substateArray[] =  {gs_RxSubState,gs_TxSubState};
      DSH_SendEvent(DSH_EVT_SUB_STATE_CHANGE,4,&usa_substateArray);
   }
   //--------------------------------------------
   // Log Rx SubState changes into States Trail
   //--------------------------------------------
   if ((s_PrevTxState != gs_TxState) ||
         (s_PrevTxSubState != gs_TxSubState))
   {
#ifdef DEBUG_TRAIL
      // Log only substate transitions here
      if (s_PrevTxState == gs_TxState)
      {
         LeaveSubStatesTrail(gl_TxSymbolCount, s_PrevTxSubState, gs_TxSubState, (int16)0xAAA1);
      }
#endif //DEBUG_TRAIL
      s_PrevTxSubState = gs_TxSubState;
      s_PrevTxState = gs_TxState;
   }

}

/*****************************************************************************
;   Prototype: void RxProfileHandler(void)
;
;   Description:
;      Called each frame from RxForeground, this function logs the state transition
;   information and RX breaking points.
;
;   Input Arguments:
;
;   Return:
;
;   Global Variables:
;****************************************************************************/
void RxProfileHandler(void)
{
   static int16 s_PrevRxState=-1,s_PrevRxSubState=-1,s_PrevAlgHandlerState=-1;


   //--------------------------------------------
   // "break point" may be triggered based on rxstate/rxsubstate
   //--------------------------------------------
   if ((gs_RxState == gs_BPRxStateTrigger && ((gs_RxSubState == gs_BPSubStateTrigger && ((gs_RxSubStateCnt == gs_BPSubStateCntTrigger) || (gs_BPSubStateCntTrigger == -2))) || (gl_RxSymbolCount == gl_BPSymbolCntTrigger))) ||
         (gs_TxState == gs_BPTxStateTrigger && ((gs_TxSubState == gs_BPSubStateTrigger && ((gs_TxSubStateCnt == gs_BPSubStateCntTrigger) || (gs_BPSubStateCntTrigger == -2))) || (gl_TxSymbolCount == gl_BPSymbolCntTrigger))))
   {
      gs_BPRxStateTrigger = (-1);
      gs_BPSubStateTrigger = (-1);
      gs_BPSubStateCntTrigger = (-1);
      gl_BPSymbolCntTrigger = (-1);

      Pause(0x1);

      gs_TxNextState = DONE_TX;
      gs_RxNextState = DONE_RX;

      gpF_TxStateFunc = (PtrToFunc)EmptyState;
      gpF_RxStateFunc = (PtrToFunc)EmptyState;

      gs_EnableTimeoutCheckFlag = FALSE; // disable time out check
   }


#ifdef DEBUG_TRAIL
   //--------------------------------------------
   // Trail collections may be triggered based on
   // rxstate/rxsubstate/rxsymbolcount.
   // The following variables are used to set
   // the trigger point.
   // The variable
   //--------------------------------------------
   if ((gs_RxState == gs_RxStateTrigger) &&
         ((gs_RxSubState == gs_RxSubStateTrigger) ||
          (gl_RxSymbolCount == gl_SymbolCountTrigger)))
   {
      (*gps_StatesTrailIndex) = 0;
      gs_RxStateTrigger = (0x7FFF);
      gs_RxSubStateTrigger = (0x7FFF);
#ifdef VRX518_BRINGUP_DEBUG
      gpuca_StVectoringBuffer = (uint8 *) gsa_StVectoringBuffer;
#endif

   }

   if (gt_debugTrailControl.ft_RxStateTrigger == FALSE &&
         gt_debugTrailControl.s_triggerRxState == gs_RxState &&
         (gt_debugTrailControl.s_triggerRxSubState == gs_RxSubState || gt_debugTrailControl.s_triggerRxSymbolCount == (int16)gl_RxSymbolCount))
   {
      gt_debugTrailControl.ft_RxStateTrigger = TRUE;
   }

   //--------------------------------------------
   // Log Rx SubState changes into States Trail
   //--------------------------------------------
   if ((s_PrevRxState != gs_RxState)
         || (s_PrevRxSubState != gs_RxSubState)
//      || (s_PrevAlgHandlerState != gs_AlgHandlerState)
      )
   {

      // Log only substate transitions here
      if (s_PrevRxState == gs_RxState)
      {
         LeaveSubStatesTrail(gl_RxSymbolCount, s_PrevRxSubState, gs_RxSubState, (int16)0xBBB1);
      }
#endif //DEBUG_TRAIL
      if(s_PrevRxState != gs_RxState)
      {
         uint16 usa_stateArray[] =  {gs_RxState,gs_TxState};
         DSH_SendEvent(DSH_EVT_STATE_CHANGE,4,&usa_stateArray);
      }

      if(s_PrevRxSubState != gs_RxSubState)
      {
                                          // XDSLRTFW-3634 Start/End avoid streaming sub state change during scanning for GHS tones,
         if (gs_RxState != R_C_TONES_RX)  // since this is generating a huge amount of events without useful info for debugging
         {
            uint16 usa_substateArray[] =  {gs_RxSubState,gs_TxSubState};
            DSH_SendEvent(DSH_EVT_SUB_STATE_CHANGE,4,&usa_substateArray);
         }
      }

#ifdef PROFILE_TASKS
      if (gft_EnableTaskProfile == TRUE)
      {
         LeaveMipsTrail((int16)0xEE00, s_PrevRxState, s_PrevRxSubState, s_PrevAlgHandlerState);
      }
#endif //#ifdef PROFILE_TASKS

#ifdef DEBUG_TRAIL
      DebugTrail1(5,DEBUG_TRAIL_MAXPHERR_ENABLE,0x0000,
                  0xDD00, gs_TxState, gs_RxState, s_PrevRxSubState,
                  //s_PrevAlgHandlerState,
                  gs_MaxPhaseError);
#endif // DEBUG_TRAIL
      gs_MaxPhaseError = 0;

      s_PrevRxSubState = gs_RxSubState;
      s_PrevRxState = gs_RxState;
      s_PrevAlgHandlerState = gs_AlgHandlerState;

#ifdef DEBUG_TRAIL
   }
   //--------------------------------------------
   // Log Tone Trail into States Trail
   //--------------------------------------------
   if (gt_debugTrailControl.ft_RxStateTrigger)
   {
      LeaveToneTrail(gl_RxSymbolCount, gt_debugTrailControl.s_toneIndex, gt_debugTrailControl.s_numTones);
   }
#endif //DEBUG_TRAIL
}

#ifdef PROFILE_TASKS

/*****************************************************************************
;   Prototype: void LogTaskProfile(int16 s_TimeLabelId)
;
;   Description:
;      Log the task profiling information.
;
;   Input Arguments:
;      s_TimeLabelId -- Identifier to which the time measurment is taken
;                   (such as TX TC start, TX TC end, etc.)
;      s_StartTime   -- Start time of associated TC or NTC task.  Used to log
;                   task duration.
;
;   Return:
;      (int16)l_RxTimer   -- rx timer value
;
;   Global Variables:
;      gsa_MaxMIPSCount[]   -- (I/O) Maintains max duration of each task.
;      gsa_MinMIPSCount[]   -- (I/O) Maintains min duration of each task.
;      gsa_StatesTrail[]   -- (O) memory block to store all the task profile data
;****************************************************************************/
int16 LogTaskProfile(int16 s_TimeLabelId, int16 s_StartTime)
{
   int32 l_TxTimer, l_RxTimer;
   int16 s_MIPS;
   FlagT /*ft_isNTCTask, */ft_isRxTask;

   if (gft_EnableTaskProfile == FALSE)
   {
      return (int16)0;
   }

   //ft_isNTCTask = (s_TimeLabelId & 0x80)? TRUE: FALSE;
   ft_isRxTask = (s_TimeLabelId & 0x40)? TRUE: FALSE;
   s_TimeLabelId &= 0x3f;

   //--------------------------------------------
   // Get Timer Information
   //--------------------------------------------

   //Read TX timer value
   ReadTxTimer(&l_TxTimer);

   //Read RX timer value
   ReadRxTimer(&l_RxTimer);

   //--------------------------------------------
   // log Max/Min MIPS information
   //--------------------------------------------
   if (s_StartTime != 0)
   {
      // Compute the MIPS for this task
      s_MIPS = (int16)(l_RxTimer - (int32)s_StartTime);

      //Account for timer rollover
      if (s_MIPS < 0)
      {
         s_MIPS = (int16)(s_MIPS + gl_MaxRxTimerCnt);
      }

      // Log Max and Min MIPS
      if (s_MIPS > gsa_MaxMIPSCnt[s_TimeLabelId])
      {
         gsa_MaxMIPSCnt[s_TimeLabelId] = s_MIPS;
         if (ft_isRxTask)
         {
            gsa_MaxMIPSRxState[s_TimeLabelId] = gs_RxState;
            gsa_MaxMIPSRxSubState[s_TimeLabelId] = gs_RxSubState;
         }
         else
         {
            gsa_MaxMIPSTxState[s_TimeLabelId] = gs_TxState;
            gsa_MaxMIPSTxSubState[s_TimeLabelId] = gs_TxSubState;
         }
      }
   }

   //--------------------------------------------
   // Log Task Time Stamp info into the Time Stamp Trail
   //--------------------------------------------
   LeaveTimeStampTrail(s_TimeLabelId, (int16)(l_TxTimer), (int16)(l_RxTimer));

   return((int16)l_RxTimer);

}

#endif //PROFILE_TASKS


#ifdef PROFILE_TASKS_VR9

/*****************************************************************************
;   Prototype: void LogTaskProfile(int16 s_TimeLabelId)
;
;   Description:
;      Log the task profiling information.
;
;   Input Arguments:
;      s_TimeLabelId -- Identifier to which the time measurment is taken
;                   (such as TX TC start, TX TC end, etc.)
;
;   Return:
;      none
;
;   Global Variables:
;      gla_MipsCnt[]      -- (I/O) Maintains duration of each task.
;      gta_MaxMIPSCnt[]   -- (I/O) Maintains max duration of each task.
;****************************************************************************/

#ifdef VR9_BRINGUP_DBG
//Log the task overruns
extern FlagT gft_EnableLogOverrun;
extern int32 gl_TaskOverRunBufCnt;
extern int16 gl_TaskOverRunBufSize;
extern int32 *gpla_TaskOverrunBuf;
#endif //#ifdef VR9_BRINGUP_DBG

int32 LogTaskProfile(int16 s_TimeLabelId, int32 l_StartTime)
{
   int32 l_RxTimer = 0;
   int32 l_MIPS;
   MaxMipsCnt_t *pt_Mips;

   //XDSLRTFW-3709 (Start_End)
   //LogTaskProfile() is common for both Time Slotted 17a profile and cascaded 35B profile.
   //while transition to 35B mode after handshake, showtime specific arrays is being modified
   //with time slotted mode "s_TimeLabelId", hence restricted only to showtime specific
   //"s_TimeLabelId"
   if ((gft_EnableTaskProfile == FALSE) ||
     (guc_CasMode_enable) && (s_TimeLabelId < ST_RX_TC_QT_DONE_SYNC_SYMBOL))
   {
      return l_RxTimer;
   }
//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   //35B Cascaded mode - profile log
   if (guc_CasMode_enable)
   {
      FlagT ft_isRxTask;
      FlagT ft_TcNtcMips;
      uint16 us_FrameCnt;


      //--------------------------------------------
      // log Max/Min MIPS information
      //--------------------------------------------
      ft_isRxTask  = (s_TimeLabelId & 0x40)? TRUE: FALSE;
      ft_TcNtcMips = (s_TimeLabelId & 0x20)? TRUE: FALSE;
      s_TimeLabelId &= 0x0f;
      if (ft_isRxTask)
      {
         //Read RX timer value
         ReadRxTimer((uint32 *)(void *)&l_RxTimer);
         us_FrameCnt = gs_RxPMDFrameCount;
      }
      else
      {
         //Read TX timer value
         ReadTxTimer((uint32 *)(void *)&l_RxTimer);
         us_FrameCnt = gs_TxPMDFrameCount;
      }

      if (l_StartTime != -1)
      {
         // Compute the MIPS for this task
         l_MIPS = l_RxTimer - l_StartTime;

         //Account for timer rollover
         if (l_MIPS < 0)
         {
            l_MIPS = l_MIPS + gl_MaxRxTimerCnt;
         }

         if (ft_TcNtcMips)
         {
            //Log the Tc & Ntc task Max Mips information to get overall
            //Training and showtime
            if (l_MIPS > gt_CascadeTcNtcMaxMipsCnt[s_TimeLabelId].l_MaxMips)
            {
               gt_CascadeTcNtcMaxMipsCnt[s_TimeLabelId].l_MaxMips = l_MIPS;
               gt_CascadeTcNtcMaxMipsCnt[s_TimeLabelId].s_TxState = gs_TxState;
               gt_CascadeTcNtcMaxMipsCnt[s_TimeLabelId].s_TxSubState = gs_TxSubState;
               gt_CascadeTcNtcMaxMipsCnt[s_TimeLabelId].s_RxState = gs_RxState;
               gt_CascadeTcNtcMaxMipsCnt[s_TimeLabelId].s_RxSubState = gs_RxSubState;
            }
         }
         else
         {
            //Showtime specific MIPS information including data or sync symbol
            if (l_MIPS > gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[s_TimeLabelId].l_MaxMips)
            {
               gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[s_TimeLabelId].l_MaxMips = l_MIPS;
               gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[s_TimeLabelId].l_MaxMipsPmdFrameCnt = us_FrameCnt;
            }

            if (l_MIPS < gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[s_TimeLabelId].l_MinMips)
            {
               gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[s_TimeLabelId].l_MinMips = l_MIPS;
               gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[s_TimeLabelId].l_MinMipsPmdFrameCnt = us_FrameCnt;
            }
         }
      }
   }
   else
#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)
   {

#ifdef VR9_BRINGUP_DBG
   if(gta_MaxMIPSCnt[FG_TASK_ID].l_MaxMIPSCnt == 0)
   {
      gl_TaskOverRunBufCnt = 0;
   }
#endif //#ifdef VR9_BRINGUP_DBG

   //Read RX timer value
   ReadRxTimer((uint32 *)(void *)&l_RxTimer);

   if(l_StartTime == -1)
   {
      gla_MipsCnt[s_TimeLabelId] = l_RxTimer;
      return l_RxTimer;
   }


   //--------------------------------------------
   // log Max/Min MIPS information
   //--------------------------------------------

   // Compute the MIPS for this task
   l_MIPS = (l_RxTimer - gla_MipsCnt[s_TimeLabelId]);

   //Account for timer rollover
   if(l_MIPS < 0)
   {
      l_MIPS += gl_MaxRxTimerCnt;
   }

   gla_MipsCnt[s_TimeLabelId] = l_MIPS;

   // Log Max MIPS
   if((s_TimeLabelId == FG_TASK_ID) || (s_TimeLabelId == FG_TC_TASK_ID))
   {
      pt_Mips = &gta_MaxMIPSCnt[s_TimeLabelId];

      if(l_MIPS > pt_Mips->l_MaxMIPSCnt)
      {
         pt_Mips->l_MaxMIPSCnt = l_MIPS;
         pt_Mips->l_TxTC_MIPSCnt = gla_MipsCnt[FG_TX_TC_TASK_ID];
         pt_Mips->l_RxTC_MIPSCnt = gla_MipsCnt[FG_RX_TC_TASK_ID];

         if(s_TimeLabelId == FG_TASK_ID)
         {
            pt_Mips->l_TxNTC_MIPSCnt = gla_MipsCnt[FG_TX_NTC_TASK_ID];
            pt_Mips->l_RxNTC_MIPSCnt = gla_MipsCnt[FG_RX_NTC_TASK_ID];
         }

         pt_Mips->s_TxState = gs_TxState;
         pt_Mips->s_TxSubState = gs_TxSubState;
         pt_Mips->s_RxState = gs_RxState;
         pt_Mips->s_RxSubState = gs_RxSubState;
      }
   }


#ifdef VR9_BRINGUP_DBG
   // Note: gft_EnableLogOverrun also control which over run(s) to log:
   // if bit 0 is set, log the forground overruns
   // if bit 1 is set, log the TC task overruns
   // if bit 2 is set, log the RX TC task overruns

   //Log the overrun cases
   if(gft_EnableLogOverrun)
   {
      switch(s_TimeLabelId)
      {
      case FG_TASK_ID:

         //The total foreground tasks should be limited within 2 time-slots
         if((l_MIPS > (CRI_TSC_CTRL_NUM_CLKS<<1)) && (gft_EnableLogOverrun & 1))
         {
            if(gl_TaskOverRunBufCnt < (gl_TaskOverRunBufSize - 10))
            {
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = 0xAAAAAAAA;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = l_MIPS;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_TX_TC_TASK_ID];
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_RX_TC_TASK_ID];
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_TX_NTC_TASK_ID];
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_RX_NTC_TASK_ID];

               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_TxState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_TxSubState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_RxState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_RxSubState;
            } //if(gl_TaskOverRunBufCnt < (gl_TaskOverRunBufSize-10))
         } //if(l_MIPS > (CRI_TSC_CTRL_NUM_CLKS<<1))

         break;

      case FG_TC_TASK_ID:

         //The total time-critical tasks should be limited within 1 time-slot
         if((l_MIPS > (CRI_TSC_CTRL_NUM_CLKS>>gs_frame_rate_is_8khz)) && (gft_EnableLogOverrun & 2))
         {
            if(gl_TaskOverRunBufCnt < (gl_TaskOverRunBufSize - 8))
            {
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = 0xBBBBBBBB;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = l_MIPS;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_TX_TC_TASK_ID];
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_RX_TC_TASK_ID];

               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_TxState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_TxSubState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_RxState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_RxSubState;
            } //if(gl_TaskOverRunBufCnt < (gl_TaskOverRunBufSize-10))
         }

         break;

      case FG_RX_TC_TASK_ID:

         //The total RX time-critical tasks should be limited within gus_MaxRxTcTime
         if((l_MIPS > gus_MaxRxTcTime) && (gft_EnableLogOverrun & 4))
         {
            if(gl_TaskOverRunBufCnt < (gl_TaskOverRunBufSize - 7))
            {
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = 0xCCCCCCCC;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = l_MIPS;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gla_MipsCnt[FG_RX_TC_TASK_ID];

               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_TxState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_TxSubState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_RxState;
               gpla_TaskOverrunBuf[gl_TaskOverRunBufCnt++] = gs_RxSubState;
            } //if(gl_TaskOverRunBufCnt < (gl_TaskOverRunBufSize-10))

         }

         break;

      default:
         break;

      } //switch()

   } //if(gft_EnableLogOverrun)
#endif //VR9_BRINGUP_DBG
   }//if-else(guc_CasMode_enable)

   return l_RxTimer;
}

#ifdef VR9_BRINGUP_DBG
void CompRxTime(int32 l_InTimer, int32 *pl_OutTimer, int32 *pl_TimeDiff)
{

   //Get the current RX timer
   ReadRxTimer((uint32 *)(void *)pl_OutTimer);

   if(l_InTimer >= 0)
   {
      *pl_TimeDiff = *pl_OutTimer - l_InTimer;
      if(*pl_TimeDiff < 0)
      {
         *pl_TimeDiff += gl_MaxRxTimerCnt;
      }

   }
}

#endif //VR9_BRINGUP_DBG

#endif //PROFILE_TASKS_VR9
