/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ComputeRates.c
*
*   This file contains functions to initialize showtime variables.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// ComputeRates.c
//
// History
//
// 11/07/2014 Kannan : "CalcDataBytesPerSymbol(uint8 uc_bc)" is moved from TxDataPumpUpSetup.c
//                     to call this function during training and showtime to update the
//                     PPE register to change in Tx throuput rate.
//                     Grep for XDSLRTFW-1474
//
// 12/03/2015 Anantha Ramu: The Bytes drawn from DFE from PPE(TC layer) varies drastically from symbol to
//                          symbol in case of US Intra DTU Interleaving. This resulted in PPE sending
//                          idle cells whenever there is more demand from DFE than what PPE can supply.
//                          This resulted in low data traffic throughput as viewed from TC layer
//                          although, PMD layer is capable of supporting higher throughput. The issue
//                          is resolved by programming DREG B0_LDAR register with bytes to support
//                          2 DTUs(Peak demand).
//                          Grep for XDSLRTFW-2178
//
//************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv_Data.h"
#include "fifo.h"
#include "InitShowTimeTx.h"
#include "TxDataPumpSetUp.h"
#include "ToneReorder.h"
#include "eoc.h"
#include "vdsl_xception.h"
#include "dsp_op.h"
#include "mul.h"
#include "Framing_VDSL2.h"
#include "dsp_op.h"  //XDSLRTFW-1474 (START-END)

//XDSLRTFW-1474 (START-END)
int16 CalcDataBytesPerSymbol(uint8 uc_bc);

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeRates(VDSL2Config_t *pt_Config, int32 *pl_OHRate, int32 *pl_NetRate)
*
*   This function computes the net data rate in unit of 4kbps.
*
*   Input Arguments:
*      pt_Config -- pointer to the structure of the framing parameters
*      s_lp      -- latency path
*
*   Output Arguments:
*      pl_NetDataRate -- pointer of the returned net data rate.
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ComputeRates(uint32 ul_Lp, uint16 us_CWSize, uint16 us_Rp, uint16 us_Gp, uint16 us_Mp, uint16 us_Tp, int16 s_fs, int32 *pl_OHRate, int32 *pl_NetRate)
{
   uint32 ul_LineRate;
   int32 l_a0, l_a1, l_TotalRate;
   int16 s_k_x_CWSize;
   int16 s_k;


   // ul_LineRate = ul_Lp*s_fs;
   MULS32x16(ul_LineRate, ul_Lp, s_fs);
   ul_LineRate += 1<<(FRAME_RATE_SHIFT_CNT-1);
   ul_LineRate >>= FRAME_RATE_SHIFT_CNT;

   // OHRate = Lp*fs*Gp/(k*CWSize) (in Q28.4)
   l_a0 = (ul_LineRate*us_Gp) << 4;
   s_k = floor16((int16)us_Tp,(int16)us_Mp); // Tp/Mp is always an integer
   MULS16(s_k_x_CWSize, s_k, us_CWSize);     // worst case is 64*255 =16320 (store in 16-bit signed number is ok)
   *pl_OHRate = l_a0/s_k_x_CWSize;

   // convert TotalRate to signed Q28.4 format
   l_a1 = (ul_LineRate*(us_CWSize-us_Rp))<<4;
   // TotalRate = Lp*fs*(CWSize-Rp)/CWSize (in Q28.4)
   l_TotalRate = l_a1/us_CWSize;

   // NetRate = TotalRate - OHRate (in Q28.4)
   *pl_NetRate = l_TotalRate - *pl_OHRate;
}

extern ReTX_ShowtimeParams_t gt_ReTxShowtimeParams;
//XDSLRTFW-1478(START)
/*
*-------------------------------------------------------------------------------
*
*   Prototype: int32 Calc_DsNDR_DsReTx(int16 s_Nfec,int16 s_Rp,uint32 ul_Lp, int16 s_fs)
*
*   This function computes the net data rate in unit of kbps(28.4 format).
*
*   Input Arguments:
*     int16 s_fs (Q6.10)
*
*   Output Arguments:
*      l_NetDataRate in 28.4 format
*
*   Returns: NDR
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
int32 Calc_DsNDR_DsReTx(int16 s_Nfec, int16 s_Rp, uint32 ul_Lp, int16 s_fs)
{
   uint32 ul_temp1, ul_TotalDataRate;
   int32 l_NetDataRate;
   int16 s_Hp;

   // The "TotalDataRate" for latency path p = (aggregate data rate for latency path p + RS coding overhead for latency path p)
   // TotalDataRate = ul_Lp*s_fs;
   // Note: fs in Q6.10 format
   MULS32x16(ul_TotalDataRate, ul_Lp, s_fs);
   ul_TotalDataRate += 1<<(FRAME_RATE_SHIFT_CNT-1);
   ul_TotalDataRate >>= FRAME_RATE_SHIFT_CNT;

   // NDRp = L1*fs*(H/Nfec)*(1-DTUframingOH), with H = Nfec1-R1 and ul_TotalDataRate = L1*fs.
   // NDRp -> Q28.4 format
   s_Hp = (s_Nfec - s_Rp);
   ul_temp1 = (uint32)((ul_TotalDataRate * s_Hp) << 4) / (s_Nfec);

   //NDR -> Q28.4 format
   l_NetDataRate  = ul_temp1 - (ul_temp1*(2 + gt_ReTxShowtimeParams.uc_DtuPaddingSize_V))/(gt_ReTxShowtimeParams.uc_CWsPerDtu_Q * s_Hp);

   return(l_NetDataRate);
}
//XDSLRTFW-1478(END)


//XDSLRTFW-1474 (START)
/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 CalcDataBytesPerSymbol(uint8 uc_bc)
*
*   This function computes the average number of bytes per DMT symbol sent
*   from DFE to PPE engine.
*
*   Input Arguments:
*      uc_bc -- bearer channel number
*
*   Output Arguments:
*
*   Returns:
*      the average number of bytes per DMT symbol for a given bearer channel
*
*   Global Variables:
*      gt_rx_TPS_Map -- (I)
*      gus_ModemOperationMode_Status -- (I)
*      gt_rx_config_v2 -- (I)
*      gt_rx_config -- (I)
*-------------------------------------------------------------------------------
*/
int16 CalcDataBytesPerSymbol(uint8 uc_bc)
{
   int16 s_P, s_lp;

   // s_bc is enabled !
   // which latency path is assigned to s_bc ?
   s_lp = gt_tx_TPS_Map.s_BCtoLP[uc_bc];

   if(s_lp == DISABLED_LP)
   {
      return(-1);
   }

   // VDSL2 mode

   VDSL2Config_t *pt_Config;
   int16 s_Tp, s_Gp, s_Mp, s_Nfecp, s_Bp;
   uint16 us_temp;
   uint32 ul_Acc, ul_Acc1, ul_Lp;

   // map the RX parameter structure
   pt_Config = &gt_tx_config_v2;

   // Number of mux data frames in an OH sub-frame
   s_Tp = pt_Config->s_Tp[s_lp];

   // Total number of ovhd octets in an OH sub-frame
   s_Gp = pt_Config->s_Gp[s_lp];

   // number of mux data frames in a codeword
   s_Mp = pt_Config->s_Mp[s_lp];

   // number of bits transmitted per data symbol
   ul_Lp = pt_Config->ul_Lp[s_lp];

   // size of codeword in bytes
   s_Nfecp = pt_Config->s_Nfecp[s_lp];

   // number of octets from bearer channel per MDF
   s_Bp = pt_Config->sa_Bpn[s_lp][uc_bc];

   if (uc_bc == 0)
   {
//XDSLRTFW-2178 (Start)
      if(guc_ReTx_US_D > 1)
      {
         MULU16(ul_Acc, gt_ReTXParams.uc_US_H, gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q);
         ul_Acc -= 3;//Deduct SID & TS
         s_P = ((int16)ul_Acc << 1);
         return(s_P);
      }
      else
      {
         //Compute ceil(Gp/Tp)*Tp - Gp
         s_P = ceil16(s_Gp, s_Tp);
         MULU16(ul_Acc, s_P, s_Tp);
         s_P = ul_Acc - s_Gp;

         // calculate net data rate for bearer channel 0
         // scale by 16 to preserve the precision
         us_temp = (uint32)((s_Bp<<4) + (s_P<<4)/s_Tp );
      }
//XDSLRTFW-2178 (End)
   }
   else
   {
      // calculate net data rate for bearer channel 1
      us_temp = (uint32)(s_Bp<<4);
   }

   // number of payload octets per data symbol, denoted by s_P,  is calculated by
   // sP = s_Bp*Mp/Sp, where Sp = 8*Nfecp/Lp
   // sP = s_Bp*Mp*Lp/(8*Nfecp) = (us_temp>>4)*Mp*Lp/(8*Nfecp) = (us_temp*Mp*Lp/Nfecp)>>7

   //Compute ul_Acc = ul_temp*ul_Lp
   MULS32xU16(ul_Acc, ul_Lp, us_temp);

   //right shift by 4 to undo the previous scale up, also avoid overflow by the next multiply
   ul_Acc = (ul_Acc + (1<<3))>>4;            //where adding (1<<3) is for rounding

   //ul_Acc1 = ul_Acc * s_Mp
   MULS32x16(ul_Acc1, ul_Acc, s_Mp);

   //Compute the final average payload bytes per DMT symbol
   s_P = ((ul_Acc1 / s_Nfecp) + (1<<2))>>3;      //where adding (1<<2) is for rounding

   return(s_P);

} //Flag CalcDataBytesPerSymbol(uint8 uc_bc)
//XDSLRTFW-1474 (END)


