/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitShowTimeRx.c
*
*   This file contains functions to initialize showtime variables.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// InitShowTimeRx.c
//
// History
//
// 05/12/2012 Ram: Aligning to Msg Spec 1.8:- INFO 68, has no variable 'Line Rate'
//                 Grep for 'XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68'
//
// 10/10/2017 Abu Rahman
// XDSLRTFW-3071: US & DS ATP reporting is swapped
//     Variables contains the DS ActATP and US ActATP were wrongly (swapped) populated.
//     - Fixed the variable initialization.
//     - Fixed variables population for DS ActATP and US ActATP
//     - Fixed HDLC messages relating to these variables both for Showtime and diag mode
//     - Changed two structure names
//       1. old name: gt_G997_NeSignalAndMarginParams, new name: gt_LineStatusDS
//       2. old name: gt_G997_FeSignalAndMarginParams, new name: gt_LineStatusUS
//     Grep for XDSLRTFW-3071
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv_Data.h"
#include "fifo.h"
#include "InitShowTimeRx.h"
#include "RxDataPumpSetUp.h"
#include "ToneReorder.h"
#include "BitswapHandler.h"
#include "g997.h"
#include "eoc.h"
#include "vdsl_xception.h"
#include "IRI_IOf_mfdq.h"
#include "MfdqAdjust.h"
#include "cmv_data.h"
#include "DDSnrFdqHandler.h"
#include "showtime.h"
#include "dsp_op.h"
#include "mul.h"
#include "states.h"
#include "cmv.h"

void ClearRxZephyrRegs(void);

extern ReTX_Params_t gt_ReTXParams;
extern QretxTableEntry_t gta_QretxTable[];

//XDSLRTFW-1393 (Start)
extern uint8 guc_Curr_Wr_DTU_idx;
extern uint8 guc_Prev_Rd_SID;
extern uint8 guc_Prev_Rd_DTU_idx;
extern uint8 guc_Prev_Rd_SID_idx;
extern uint8 guc_Wr_SID_idx;
extern uint8 guc_Rd_SID_idx;
//XDSLRTFW-1393 (End)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RxShowInitHandler(void)
*
*   This function initializes variables and cores for showtime RX processing.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#ifdef INCLUDE_NON_CACHE_FUNCTIONS
void RxShowInitHandler(void)
{
   switch (guc_RxShowInitState)
   {

   case RX_SHOW_INIT_VARS:
      // For VRx518 the RTV is twice, i.e. for 1024 tones.
      // But for showtime only 512 of the 1024 tones can be used for FDQ and SNR.
      //XDSLRTFW-4065 for 30a profile due to MIPS constraint, restricted NUM_CHANNELS_PER_GROUP to 256
      if (gs_frame_rate_is_8khz == 1)
      {
         gs_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_256;
      }
      else
      {
         gs_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_512;
      }
      gs_NumChannelsPerGroupSave = gs_NumChannelsPerGroup;
      gt_FdqConfig.s_NumChannelsPerGroup = gs_NumChannelsPerGroup;
      gt_SnrConfig.s_NumChannelsPerGroup = gs_NumChannelsPerGroup;

      // Save Hybrid ECHO metric in lifetime all common metric memory
      // Note: For Hybrid ECHO based algo the metric is located in ILV memory and
      //       must therefore be saved before showtime entry. Beside the ECHO
      //       based algo also the gain based algo is running for comparison. This gain
      //       based is stored in lifetime all memory. Debug tools can read until showtime
      //       both metric infos and later in showtime only the metric for the real used
      //       hybrid algo.
      if(guc_HybridAlgoCtrl & HYB_ALGO_ECHO_BASED)
      {
         signed int i;

         for (i = 0; i < (VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH); i++)
         {
            gl_HybTrMetric[i] = (int32)gsa_HybTrMetricEcho[i];
         }

         gs_HybTrMaxIndex_save = gs_HybTrMaxIndexEcho_save;
// Already done in HybridTrainingHandler.
//         gs_HybTrMaxIndex = gs_HybTrMaxIndexEcho;
      }

      // initialize showtime variables & BG tasks
      guc_BgRxShowInitState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeRx);

      guc_RxShowInitState = RX_SHOW_INIT_VARS_WAIT;
      break;

   case RX_SHOW_INIT_VARS_WAIT:
      // wait until background task is done
      if (guc_BgRxShowInitState == TRAINING_DONE)
      {
         if (gul_dilvb_size == 0)
         {
            EnterFailStates(E_CODE_DILV_INIT_FAIL);
         }

         if (gft_ToneOrderOK == FAIL)
         {
            EnterFailStates(E_CODE_TONE_ORDERING_ERROR);
         }

         if (gft_EnableMfdq)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadMfdqCoef);
            guc_RxShowInitState = RX_SHOW_INIT_ADJUST_MFDQ;
         }
         else
         {
            guc_RxDataPumpState = RX_CONFIG_CORE_START;
            guc_RxShowInitState = RX_SHOW_INIT_CORES;

            ClearRxZephyrRegs();
         }
      }
      break;

   case RX_SHOW_INIT_ADJUST_MFDQ:
      // initialize showtime variables & BG tasks
      guc_BgRxShowInitState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAdjustMfdq);
      guc_RxShowInitState = RX_SHOW_INIT_ADJUST_MFDQ_WAIT;
      break;

   case RX_SHOW_INIT_ADJUST_MFDQ_WAIT:
      if (guc_BgRxShowInitState == TRAINING_DONE)
      {
         guc_RxDataPumpState = RX_CONFIG_CORE_START;
         guc_RxShowInitState = RX_SHOW_INIT_CORES;

         // reset all Zephyr-FCI RX PRAM
         ClearRxZephyrRegs();
      }
      break;

   case RX_SHOW_INIT_CORES:
      // initialize cores if variable initialization is done
      if (guc_RxDataPumpState != RX_CONFIG_CORE_DONE)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, RxDataPumpSetUp);
      }
      else
      {
         guc_RxShowInitState = RX_SHOW_INIT_DONE;
      }
      break;
   }
}

#endif // INCLUDE_NON_CACHE_FUNCTIONS
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgInitShowTimeRx(void)
*
*   This function initializes background function to call InitShowTimeRx().
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#ifdef INCLUDE_CACHE_FUNCTIONS
void BgInitShowTimeRx(void)
{
   if (guc_dbgForceEvenNcLoaded)
   {
      int16 i, s_numTonesLoaded = 0;
      for(i=0; i<gs_NumOfRxBands; i++)
      {
         s_numTonesLoaded += gusa_ncloaded[i];
      }
      if (s_numTonesLoaded % 2)
      {
         int16 s_minNumBits, s_minBitsTone;

         s_minNumBits = gs_RxMaxConstSize;
         // !! Debug code to test maximum bits per tone per band, i.e. max constellation per band!!
         if (gsa_RxMaxConstSize[0] > 0)
         {
            s_minNumBits = gt_ModemConfig.s_DsMaxConstSize;
         }

         s_minBitsTone=0;

         // Find largest indexed tone with minimum # of bits
         for (i=0; i<gs_RxNumTones; i++)
         {
            if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i) &&
                  ghpuca_RxBat_Inactive[i] <= s_minNumBits)
            {
               s_minNumBits = ghpuca_RxBat_Inactive[i];
               s_minBitsTone = i;
            }
         }
         // Redistribute these bits among loaded tones
         ghpuca_RxBat_Inactive[s_minBitsTone] = 0;
         // Since we go from odd to even # of tones, we reduce tcm overhead by one bit
         if (gft_RxTcmFlag)
         {
            s_minNumBits--;
         }
         for (i=0; (i<gs_RxNumTones && s_minNumBits); i++)
         {
            if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i) &&
                  ghpuca_RxBat_Inactive[i] >= gs_RxMinConstSize &&
                  ghpuca_RxBat_Inactive[i] < gs_RxMaxConstSize)
            {
               ghpuca_RxBat_Inactive[i]++;
               s_minNumBits--;
            }
         }
      }
   }

   // this flag suppresses a call to UpdateNOMATP() during showtime
   gft_UpdateNomAtp_Flag = FALSE;

   // initialize showtime variables
   InitShowTimeRxVars_VDSL2();

   // Initialize the far end ACTATP based on the NOMATP computed during bitloading
   // This parameter will be updated in VDSL2 mode through overhead messages
   // VDSL1 mode has no such parameter defined in EOC message exchange
   // XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)
   // gt_LineStatusDS structure contains DS information.
   // gt_LineStatusDS.s_ActualAggregateXmtPwr also contains DS ACT ATP

   gt_LineStatusDS.s_ActualAggregateXmtPwr = gs_NOMATP_dBm;
   // Rx Actual aggregate PSD value is never used in VDSL2 code.
   gt_LineStatusDS.s_ActualAggregatePSD = OUT_OF_RANGE_ACTPSD;
   // XDSLRTFW-3071 US & DS ATP reporting is swapped (End)

   // XDSLRTFW-4051 Fast downstream up shift SRA(start)
   // Enable/Disable the fast downstream up shift SRA feature via gus_FastDsSraControl flag
   gus_FastDsSraControl = 0;

   if ((gt_FastDsSraConfig.us_FastDsSraConfig & CNFG_DISABLE_FAST_DS_UPSHIFT_SRA) != CNFG_DISABLE_FAST_DS_UPSHIFT_SRA)
   {
      if (gft_DSVectoringEnabled && (gul_fe_G994VendorID == BRCM_VENDOR_ID)) // Vectoring and CO dependency
      {
         // Vector engine vendor dependency
         // gt_FastDsSraConfig.us_FastDsSraConfig bit 0 = 0 : Fast SRA feature is enabled for any vector engine
         // gt_FastDsSraConfig.us_FastDsSraConfig bit 0 = 1 : Fast SRA feature is enabled for BRCM vector engine
         if((gt_FastDsSraConfig.us_FastDsSraConfig & CNFG_FAST_DsSRA_Config_MaskBit0 ) == 0)
         {
            // Any vectoring engine configuration is enabled
            gus_FastDsSraControl = FAST_DS_UPSHIFT_SRA_ENABLED | FAST_DS_SRA_USED_IN_PRESENT_LINK;
         }
         else // BRCM only vector engine is enabled
         {
            if ((gul_VceVersionNumber == BRCM_VENDOR_ID))
            {
               gus_FastDsSraControl = FAST_DS_UPSHIFT_SRA_ENABLED | FAST_DS_SRA_USED_IN_PRESENT_LINK;
            }
         }
      }
   }
   // XDSLRTFW-4051 Fast downstream up shift SRA(End)

   if(gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2)
   {
      //Generate the TRT table for both PMS message and HW
      BgFormRxTRT();

      //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (Start)
      //Commenting out as INFO 68 in Msg Spec 1.8 does not have variable 'Line Rate'
      //gt_LineStatusDS.ul_LineRate = gul_RxLineRate;   // Setting the Rx Line Rate to the cmv
      //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (End)
   }

   // configure RX Deinterleave FIFO Management buffers
   gul_dilvb_size = ConfigZephyrIlvRxDFM_VDSL2();


   // init gta_QretxTable[]
   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      int32 i;

      memset(gta_QretxTable, 0, sizeof(QretxTableEntry_t)*QRETX_TRANS_TABLE_SIZE);
      for (i = 0; i < QRETX_TRANS_TABLE_SIZE; i++)
      {
         gta_QretxTable[i].uc_Stat = EMPTY_DTU;
         //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
         gta_QretxTable[i].uc_DTU_idx = EMPTY_DTU;
      }

      //XDSLRTFW-1393 (Start)
      guc_Prev_Rd_SID = 0;
      guc_Prev_Rd_DTU_idx = 0;
      guc_Prev_Rd_SID_idx = 0;

      guc_Wr_SID_idx = (QRETX_TRANS_TABLE_SIZE-1);
      guc_Rd_SID_idx = (QRETX_TRANS_TABLE_SIZE-1);
      guc_Curr_Wr_DTU_idx = 0;

      gta_QretxTable[guc_Wr_SID_idx].uc_SID = (SID_MODULO - 1);
      gta_QretxTable[guc_Rd_SID_idx].uc_SID = (SID_MODULO - 1);

      gft_DsSraReTxInit = FALSE;
      gft_Qrx_Full = FALSE;

      gft_SRAInvSync_Detected = FALSE;
      gft_DTU_Stoppage_Detected = FALSE;
      gft_Start_DTU_Stoppage_Detection = FALSE;
      guc_DTU_Stoppage_Detect_Cntr = 0;
      guc_DTU_Status_Arr_Indx = 0;
      memset(gt_DTU_Status_Arr, 0, sizeof(DTU_Status_t)*(63+1));//Max QTx => 63 (Table A.6 of G.998.4 (G.Inp) standard)
      //XDSLRTFW-1393 (End)
      //XDSLRTFW-1571 (Start)
      /* Init of Free buffer list */
      for (i = 0; i < ILVB_WRPTR_TABLE_SIZE_LW; i++) {
         gt_NodeList[i].uc_NextNode = 0xFF;
         gt_NodeList[i].uc_Indx = i;

         //Add first four buffers to ILVB Write Pointer table.
         guca_InpBufList[i] = i;
      }

      for (i = ILVB_WRPTR_TABLE_SIZE_LW; i < ((gt_ReTXParams.uc_Qrx)-1); i++) {
         gt_NodeList[i].uc_NextNode = i+1;
         gt_NodeList[i].uc_Indx = i;
      }
      gt_NodeList[i].uc_NextNode = 0xFF;
      gt_NodeList[i].uc_Indx = i;

      //First four buffers will be added to ILVB Write Pointer table. Rest will be in the free buffer list.
      gt_FreeBufList.uc_NumNodes = (gt_ReTXParams.uc_Qrx-ILVB_WRPTR_TABLE_SIZE_LW);
      gt_FreeBufList.uc_Head = ILVB_WRPTR_TABLE_SIZE_LW; //Head points to the 5th Node.

      /* Init of Input Buffer list */
      guc_InpBufListIndx = 0;
      //XDSLRTFW-1571 (End)
   }

   guc_BgRxShowInitState = TRAINING_DONE;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitRxIBStruct()
*
*   This function initializes RxIbData structures.
*
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void RxIbInit(void)
{
   int16   s_lp;

   //Initialize the elements of the Rx IB Bits data structure
   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      gt_RxIbData.s_fncd_cnt[s_lp] = TERMINATED;
      gt_RxIbData.uc_atm_state[s_lp] = OCD;
      gt_RxIbData.uc_flcd_def[s_lp] = TERMINATED;
      gt_RxIbData.uc_fncd_anom[s_lp] = TERMINATED;
      gt_RxIbData.uc_fncd_hist[s_lp] = 0;
      gt_RxIbData.uc_fncd_ind[s_lp] = TERMINATED;
      gt_RxIbData.uc_focd_anom[s_lp] = TERMINATED;
      gt_RxIbData.s_fncd_cnt[s_lp] = 0;
   }

   gt_RxIbData.uc_frdi_def = TERMINATED;
   gt_RxIbData.uc_flol_fail = TERMINATED;
   gt_RxIbData.uc_flos_def = TERMINATED;
   gt_RxIbData.uc_flos_hist = 0;
   gt_RxIbData.uc_flos_ind = TERMINATED;
   gt_RxIbData.uc_flpr_def = TERMINATED;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitRxVarsCommon( BC_LP_TPS_Map_t *pt_Config)
*
*   This function initializes the BC to TPS mapping.
*
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitRxVarsCommon( BC_LP_TPS_Map_t *pt_Config)
{
   int16 s_bc, s_lp, s_TpsMode;

   // initialize per BC variables
   for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
   {
      s_TpsMode = gta_DsBearerChanAct[s_bc].s_TypeEnabled;
      if (s_TpsMode == TPS_TC_TYPE_PTM)
      {
         // Since there is currently no PTM, map PTM aot ATM
         // but set PhysicalTransportMode to PTM
         if (s_bc == BC0)
         {
            pt_Config->s_BCtoTPS[BC0] = MAP2ABC0;
            gus_PhysicalTransportMode |= RX_BC0_PTM_MASK;
         }
         else
         {
            pt_Config->s_BCtoTPS[BC1] = MAP2ABC1;
            gus_PhysicalTransportMode |= RX_BC1_PTM_MASK;
         }
         gft_TcTypeSelected = TPS_TC_TYPE_PTM;
      }
      else if (s_TpsMode == TPS_TC_TYPE_ATM)
      {
         // if BC is ATM, always connect BC0 to ATM0, BC1 to ATM1
         if (s_bc == BC0)
         {
            pt_Config->s_BCtoTPS[BC0] = MAP2ABC0;
            gus_PhysicalTransportMode |= RX_BC0_ATM0_MASK;
         }
         else
         {
            pt_Config->s_BCtoTPS[BC1] = MAP2ABC1;
            gus_PhysicalTransportMode |= RX_BC1_ATM1_MASK;
         }
         gft_TcTypeSelected = TPS_TC_TYPE_ATM;
      }
      else if (s_TpsMode == TPS_TC_TYPE_STM)
      {
         // there exists only 1 STM channel
         if (s_bc == BC0)
         {
            pt_Config->s_BCtoTPS[BC0] = MAP2EBC; // JBK ??? - Electra is STM?
            gus_PhysicalTransportMode |= RX_BC0_STM_MASK;
         }
         else
         {
            pt_Config->s_BCtoTPS[BC1] = MAP2EBC;
            gus_PhysicalTransportMode |= RX_BC1_STM_MASK;
         }
         gft_TcTypeSelected = TPS_TC_TYPE_STM;
      }
      else
      {
         pt_Config->s_BCtoTPS[s_bc] = MAP2NONE;
      }
   }

   // initialize per LP variables
   pt_Config->s_LPtoABC[LP0] = DISABLED_ABC;
   pt_Config->s_LPtoABC[LP1] = DISABLED_ABC;

   for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
   {
      s_lp = pt_Config->s_BCtoLP[s_bc];

      if (s_lp != DISABLED_LP)
      {
         if (pt_Config->s_BCtoTPS[s_bc] == MAP2ABC0)
         {
            pt_Config->s_LPtoABC[s_lp] = ABC0;
         }
         else if (pt_Config->s_BCtoTPS[s_bc] == MAP2ABC1)
         {
            pt_Config->s_LPtoABC[s_lp] = ABC1;
         }

      }
   }

}
#endif // INCLUDE_CACHE_FUNCTIONS
