/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitShowTimeRx_VDSL2.c
*
*   This file contains functions to initialize VDSL2 Rx showtime variables.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// InitShowTimeRx_VDSL2.c
//
// History
//
// 16/05/2012 Vinjam: Conveying Downstream Virtual Noise feature control status is moved from RATE 1 12 to
//           CMV INFO 68 10, as per VR9 Message Specifications (1.6.1)
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 08/08/2012 Vinjam: Populating of "CMV INFO 68 8 Bit-8" is moved to InterpOSignatureMsg_VDSL2.c file,
//            as it is required for Normal Initialization Mode & DELT mode.
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//             VDSL2 Bitloading algo doesn't consider the "Erasure decoding" capability.
//            So, as per R6 DSL-API request, report same INP value through "RATE 1 [14:15]" & "RATE 1 [16:17]", if Erasure decoding is not used.
//            Grep for XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec
//
// 26/2/2013 Vinjam: Report ActINPnoErasure & ActINPErasure in 0.1 DMT symbol granularity
//           Grep for XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec
//
// 05/3/2013 Vinjam: Report Delay in 0.01 milli seconds granularity to the near-end
//           Grep for XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms
// 09/05/2013 Kannan: Round of error corrected for l_NetDataRate computation.
//            Grep for "XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop "
//20/5/2013 Mahesh: Removed the restriction of upshift for SRA.
//            Grep for XDSLRTFW-921: Fix_All_VDSL2_All_SraUpshift
//30/5/2013 Mahesh Capped the downshift SRA to 77 percent of initial showtime Lp for Brcm
//          XDSLRTFW-921/922: Fix_All_All_VDSL2_BRCM_Vdsl2Sra
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Delta CRC for ReTx mode should be 1. This fixed the 'SES counter not incrementing in Retx mode' issue.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
// 11/10/2013 Ram: NDR (to be reported in CMV RATE 1) for ReTx mode is computed using equation provided in
//                 Table 9-2 in G.998.4 (G.Inp) standard. This value is computed in RtxFramingVdsl_V1() in
//                 file FramingGenLP1.c
//                 Grep for XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx
//
// 19/10/2018 Abu Rahman
//            XDSLRTFW-4005: DS VDSL Fine gains are increased by bitswaps even in max noise margin case
//
//            DS Bitswap/SRA  algorithm in BgRxBitSwapDecision_VDSL2() assumed that
//            Max FG = +2.5 dB
//            Min FG = -2.5 dB and
//            Monitoring (0 bit loaded) tone FG = 0 dB
//
//            This algorithm does not consider any FG reduction (eg. gs_ExcessMarFGReduction) which is done during initial bit loading.
//            As a consequence, in cases of access margin (where SNR margin is higher than that of Max margin) FG reduction is done in
//            training to reduce the overall received DS ActATP,  DS power is increased over time in conjunction with DS bitswap/SRA.
//
//            As a solution, initial FG reduction (gs_ExcessMarFGReduction) in training for Bitloading is consider in Max FG, Min FG as
//            well as monitoring tone FG calculation during Bitswap/SRA computation.
//            Grep for XDSLRTFW-4005
//
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "InitShowTimeRx.h"
#include "BitswapHandler.h"
#include "g997.h"
#include "eoc.h"
#include "DDSnrFdqHandler.h"
#include "dsp_op.h"
#include "mul.h"
#include "Framing_VDSL2.h"
#include "showtime.h"
#include "GenFramingParams_VDSL2.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitShowTimeRxVars_VDSL2(void)
*
*   This function initializes showtime variables for RX path.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void InitShowTimeRxVars_VDSL2(void)
{
   int16 i, s_lp, s_bc;
   uint16 us_delay;
   int32 l_temp, l_NetDataRate, l_OHRate;
   VDSL2Config_t *pt_Config;
   pt_Config = &gt_rx_config_v2;
   uint32 l_tempPERp;

   // Initialize Rx synch frame processing vars
   gs_RxPMDFrameCount = 0;
   //Debug for XDSLRTFW-2050
   gusa_nSyncLoss[0] = 0;
   gusa_nSyncLoss[1] = 0;

////XDSLRTFW-3362 (Start)
//#ifdef PROFILE_TASKS_35B
//   //35B MIPS profiling
//   if ((TESTArray[TEST_Control] & TEST_TaskProfileControl) && (guc_CasMode_enable))
//   {
//     gft_EnableTaskProfile = TRUE;
//   }
//#endif //#ifdef PROFILE_TASKS_35B
////XDSLRTFW-3362 (End)

   gul_EOC_ErrorFB_CMD_count = 0;
   gs_RxSuperFrmCnt_in_Showtime = 0;

   // Initialize the BC->TPS and Lp->ABC mapping
   InitRxVarsCommon(&gt_rx_TPS_Map);


// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]


   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      pt_Config->ul_Reconfig_Lp[s_lp] = pt_Config->ul_Lp[s_lp];
      pt_Config->s_Reconfig_Dp[s_lp] = pt_Config->s_Dp[s_lp];
      pt_Config->s_Reconfig_Gp[s_lp] = pt_Config->s_Gp[s_lp];
      pt_Config->s_Reconfig_Tp[s_lp] = pt_Config->s_Tp[s_lp];
   }
   pt_Config->s_Nlp = 0;

   // Get the count of active latency paths
   for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
   {
      // Check which latency path is assigned to s_bc
      s_lp = gt_rx_TPS_Map.s_BCtoLP[s_bc];

      if (s_lp != DISABLED_LP)
      {
         pt_Config->sa_Reconfig_Bpn[s_lp][s_bc] = pt_Config->sa_Bpn[s_lp][s_bc];
         pt_Config->s_Nlp++;   // Increment the count of number of active latency paths
      }
   }
   gs_data_path = pt_Config->s_Nlp-1;

   //gul_AutoSRALmin = 8;

   //Don't go beyond the original Lp when doing upshift SRAs
   //gul_AutoSRALmax = (pt_Config->ul_Lp[0]*15)/ 10;
   //XDSLRTFW-1026: Feature_DS_VDSL2_All_RetxSra [Start]
   if ((gft_EnableRxAutoSRA) && (gt_ReTXParams.uc_OMSG1_DsReTxEnabled != RETX_SELECTED))
   {
      ComputeFramingConstraints();
   }
   else
   {
      gul_AutoSRALmin = gul_AutoSRALmax = pt_Config->ul_Lp[gs_data_path];
   }

   //XDSLRTFW-1026: Feature_DS_VDSL2_All_RetxSra [End]
   gft_BlockSRA = FALSE;


   // XDSLRTFW-4005: DS VDSL Fine gains are increased by bitswaps even in max noise margin case (Start)
   // Initial FG reduction (gs_ExcessMarFGReduction) in training for Bitloading is consider in Max FG, Min FG as
   // well as monitoring tone FG calculation during Bitswap/SRA computation
   gs_max_fine_gain =  MAX_FINEGAIN_DB - gs_ExcessMarFGReduction;       //  Q8.8 dB format
   gs_min_fine_gain = -MAX_FINEGAIN_DB - gs_ExcessMarFGReduction;       //  Q8.8 dB format
   // XDSLRTFW-4005: DS VDSL Fine gains are increased by bitswaps even in max noise margin case (End)


// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      gus_invalid_bytes[s_lp] = 0;

      for (i = 0; i <gt_rx_config_v2.s_Ip[s_lp]; i++)
      {
         // compute # of invalid bytes = summation over I (floor(D*i)/I)
         MULS16(l_temp, i, gt_rx_config_v2.s_Dp[s_lp]);

         if(gt_rx_config_v2.s_Ip[s_lp])
         {
            gus_invalid_bytes[s_lp] += (int16)floor32(l_temp, gt_rx_config_v2.s_Ip[s_lp]);
         }
      }

      // compute # of DILVB AVAIL = (D + q - 1) * I - #invalid bytes
      MULS16(l_temp, gt_rx_config_v2.s_Ip[s_lp], (gt_rx_config_v2.s_Dp[s_lp] + gt_rx_config_v2.s_q[s_lp] - 1));
      gus_dilvb_avail[s_lp] = (int16)l_temp - gus_invalid_bytes[s_lp];
   }

   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      gs_wt_step[s_lp] = GetFifoReadWriteStep(gt_rx_config_v2.s_Dp[s_lp], gt_rx_config_v2.s_Ip[s_lp]);
   }

   // clear G997 variables
   G997_RestartHandler();

   gus_ShowtimeControl = 0;

   //
   // Rx overhead messaging initialization
   //
   // Initialize Rx IB message buffer
   for(i=0; i<MAX_IB_BYTES_PER_SFRAME; i++)
   {
      guca_RxIbMsgBuf[i] = (uint8 )~NO_INDICATIONS;
      guca_RxIbMsgBufTemp[i] = (uint8 )~NO_INDICATIONS;
   }

   //clear variable used in FE LPR processing
   gs_FeLprLosDelay = 0;

   // Clear Rx IB structure
   memset(&gt_RxIbData, 0, sizeof(RxIbDataStruct_t));

   // Initialize Rx IB structure
   RxIbInit();

   // Initialize Rx EOC vars
   RxEocInit();

   gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

   // Clear Rx SW message buffers
   memset(guca_RxOvhdSwFifoBuf, 0, RX_OVHD_MSG_SWFIFO_LEN * sizeof(uint8));

   // Initialize Rx VOC message state machine
   gs_RxOvhdState = GET_SYNC;
   gs_RxOvhdSubState = 0;
   gs_RxOvhdMsgIndex = 0;

   gl_NTR_Offset = 0;

   gs_RxOvhdRdPtr = 0;
   gs_RxOvhdWrPtr = 0;

   guc_BitSwapReqIntrepretState = BSR_INTERPRETATION_IDLE;

   // variables used in RxDataFrameProcess
   guc_RxDataFrameState = SNR_FDQ_UPDATE;

   // variables used in SNR/FDQ updates
   gs_DDSnrFdqState = DD_SNRFDQ_INIT;
   gs_DDFdqAdaptSlew = gs_DDFdqAdaptSlewSlow;
   gs_NumSnrUpdate = 0;
   gs_NumFdqUpdate = 0;
   gs_NumRxPowerUpdate = 0;


   // variables used in bitswap
   guc_BitSwapState = BITSWAP_INIT;
   gus_RxBitSwapStatus = (RX_BITSWAP_BGT_MISMATCH);

   for(i=0; i<gs_NumOfRxBands; i++)
   {
      if(gusa_ncloaded[i] > 0)
      {
         gla_AvgFGainLinSqInit[i] = gla_SumFGainLinSq[i]/gusa_ncloaded[i];
      }
      else
      {
         gla_AvgFGainLinSqInit[i] = 0;
      }
   }

   if (gul_dbgShowtimeControl & VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL)
   {
      gs_RxSyncToneType = REVERB;
   }
   else
   {
      gs_RxSyncToneType = SEGUE;
   }
   gft_RxInvSynch = FALSE;

   //------------------------------------------
   // compute variables used for CMV access
   //------------------------------------------
   pt_Config = &gt_rx_config_v2;
   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      // only for enabled latency path
      if (pt_Config->ul_Lp[s_lp] != 0)
      {
         //------------------------------------------------------------------------
         // The computation of TotalRate, OHRate & NetRate is based on the framing
         // parameters performed in FormVDSL2FramingParams().
         //------------------------------------------------------------------------
         if (gft_computeDataRateFS6)
         {
            ComputeRatesFS6(s_lp, pt_Config, &l_NetDataRate);
            // RATE CMV reports NetRate in unit of 4 kbps, so right shift by 2 (convert from kbps to 4kbps) + 4 (convert from Q28.4 to Q32.0)
            l_NetDataRate >>= 6;
         }
         else
         {
            //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start)
            if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) && (s_lp == 1))
            {
               l_NetDataRate = gt_ReTXStats.ul_ReTX_NDR; //Q28.4
               l_OHRate = 0;
            }
            else
               //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (End)
            {
               ComputeRates(pt_Config->ul_Lp[s_lp], pt_Config->s_Nfecp[s_lp], pt_Config->s_Rp[s_lp],
                            pt_Config->s_Gp[s_lp], pt_Config->s_Mp[s_lp], pt_Config->s_Tp[s_lp],
                            gt_FormFramingParamsInputs_v2.s_fs, &l_OHRate, &l_NetDataRate);

               //XDSLRTFW-1478(START)
               if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
               {
                  //NDR is zero for LP0 in DS ReTx mode
                  l_NetDataRate=0;

                  if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
                  {
                     // RRC part of ADR/TDR is taken care here!
                     // Note: The RRC in downstream is only available when US ReTx is enabled.
                     //       fs is in Q6.10 and kHz format, i.e. for m=5 -> ((4kHz * 256) << 10)/257 = 4080 (0xff0).
                     //       fs = 4080/2^10 = 4080/1024 = 3.984375 kHz
                     {
                        uint32 ul_temp;

                        ul_temp = ((uint32)US_RRC_BITS * gt_FormFramingParamsInputs_v2.s_fs);

                        // The aggregate data rate in kbit/s: ADR = SUM(ADRp) + 12*fs
                        // Note: For ADR only half of RRC gets be considered, i.e. additional rshift by one ( >> 1).
                        t_DSRateInfo.ul_ADR += ((ul_temp + (1<<(FRAME_RATE_SHIFT_CNT-1+1))) >> (FRAME_RATE_SHIFT_CNT+1));
                        // The total data rate in kbit/s: TDR = SUM(TDRp) + 24*fs, with TDRp = Lp *fs
                        t_DSRateInfo.ul_TDR += (ul_temp + (1<<(FRAME_RATE_SHIFT_CNT-1)) >> FRAME_RATE_SHIFT_CNT);
                     }
                  }
               }
               //XDSLRTFW-1478(END)
            }

            // convert NDR from Q28.4 to Q32.0, i.e. kbit/s
            //XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop (Start_End)
            l_NetDataRate += (1 << 3);
            //XDSLRTFW-572 : NewFeature_ALL_ALL_ALL_RateIn1Kbps(Start_End)
            l_NetDataRate >>= 4;
         }

         //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start)
         t_DSRateInfo.t_CurRate[s_lp].us_RateLSW = l_NetDataRate & 0xFFFF;
         t_DSRateInfo.t_CurRate[s_lp].us_RateMSW = l_NetDataRate >> 16;

         //XDSLRTFW-1478(START)
         // The aggregate data rate in kbit/s: ADRp = NDRp + OHRatep
         // Note: l_OHRate is in 28.4 format ==> convert back to Q32.0!!
         t_DSRateInfo.ul_ADR += (l_NetDataRate + (l_OHRate>>4));
         t_DSRateInfo.ul_TDR += (((gt_rx_config_v2.ul_Lp[s_lp] * gt_FormFramingParamsInputs_v2.s_fs) +
                                  (1 << (FRAME_RATE_SHIFT_CNT-1))) >> FRAME_RATE_SHIFT_CNT);
         t_DSRateInfo.ul_OHRate[s_lp] = l_OHRate;
         //XDSLRTFW-1478(END)

         //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)

         //---------------------------------------------------------------
         // Compute delay (in milliseconds)
         //---------------------------------------------------------------
         ComputeDelay(pt_Config, s_lp, &us_delay);

         //XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms (Start_End)
         //Report Delay in 0.01 milli seconds granularity to the near-end
         t_DSRateInfo.us_IntlDelay[s_lp] = (us_delay * 100);

         // Interleaver depth
         t_DSRateInfo.s_D[s_lp] = pt_Config->s_Dp[s_lp];

         // TCM and parity bytes info
         gt_LineStatusDS.us_LineStatus &= (uint16)0xFFFE;
         gt_LineStatusDS.us_LineStatus |= gft_RxTcmFlag;
         t_DSRateInfo.s_TcmParityInfo[s_lp] = (pt_Config->s_Rp[s_lp] & 0xFF) | (gft_RxTcmFlag << 8);

         // Report INP value in 0.1 DMT Symbol granularity format
         //XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec (Start)
         //Note: VDSL2 Bitloading algo doesn't consider the "Erasure decoding" capability
         //So, as per R6 DSL-API request, reporting same INP value through "RATE 1 [14:15]" & "RATE 1 [16:17]".
         // s_INPp Q8.8 format
         {
            int32 l_InpReport;

            l_InpReport = ((((uint32)pt_Config->s_INPp[s_lp]) * 10) >> 8);
            t_DSRateInfo.s_ActInpNoErasure[s_lp] = l_InpReport; //0.1 DMT symbol granularity
            t_DSRateInfo.s_ActInpErasure[s_lp]   = l_InpReport; //0.1 DMT symbol granularity
         }
         //XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec (End)
         //In 7.2.1.1.3/G.997.1 and 7.2.1.2.3/G.997.1, a one-second counter is used to
         //declare a near-end severely errored second (SES). The one-second counter shall
         //be incremented by the delta_CRCsec (the one-second normalized CRC anomaly counter increment)
         //for each occurrence of a crc-p anomaly. A delta_CRCsec value is defined for each downstream
         //and upstream latency path separately, as a real value in the 0.125 to 8 range, as:

         //if 15ms <= PER <= 20ms:   delta_CRCsec = 1
         //if PER < 15ms:            delta_CRCsec = (PER/15)

         //Improve Precision on PERp calculation to 3 decimal places
         //XDSLRTFW-967 : Bug_DS_ALL_ALL_DeltaCRCPrecision
         //==================================================================================
         // Compute PERp = 8*PERBp/(Lp*fs) = 8*PERBp/DRp in ms with higher precision (Q16.16)
         //==================================================================================
         // 8*PERBp/DRp  Q16.16 (no overflow since PERBpMax=17000)
         l_tempPERp = (uint32)((pt_Config->l_PERBp[s_lp]<<16)/pt_Config->l_DRp[s_lp])<<3;

         if (l_tempPERp >= (15<<16))
         {
            gusa_DeltaCRCsecp_NormFactor[s_lp] = (uint16)(1 << 8);
         }
         else
         {
            gusa_DeltaCRCsecp_NormFactor[s_lp] = (uint16)(((l_tempPERp/15) + (1<<7))>>8);
         }
         //XDSLRTFW-967 : Bug_DS_ALL_ALL_DeltaCRCPrecision

         //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)
         //ES counter has to be build as mentioned in chapter 11.3.1/G.998.4,
         //No defect, anamoly and failure are defined for LP0 (carrying ovhd chnl)
         //Make Delta CRC to be 1 for RETX
         if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
         {
            gusa_DeltaCRCsecp_NormFactor[s_lp] = (uint16)(1 << 8);
            gt_ReTXStats.ul_UncorrectedDtuCnt = 0;
            gt_ReTXStats.ul_UncorrectedDtuCnt_Prev = 0;
            gt_ReTXStats.us_New_EFTRMin_Avail = FALSE;
            guc_EftrLtETRby2OverObsPeriod = TRUE;
         }
         //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)
      }

   }

}


// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeFramingConstraints(void)
*
*   This function performs the framing checks needed for Auto SRA decision
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
#define MAX_LP        0x19FFF

void ComputeFramingConstraints(void)
{
   int16 i, s_path;
   uint16 us_temp;
   uint32 ul_L_orig, ul_Lmin, ul_Lmax, ul_Lptemp, ul_Lp;
   int16 s_Upmax, s_SEQpmax, s_index_Lmax, s_index_Lmin;
   uint16 us_Qmax, us_DRmax;

   int16 s_k, s_Mp, s_Tp, s_Rp, s_Dp, s_Nfecp, s_Gp;
   int16 s_MinIBitsOHR, s_MinOHRate, s_MaxOHRate;
   int32 l_temp;
   uint32 ul_temp1, ul_temp2;

   int16 s_OHOct_Per_MDF, s_MDF_Per_Symbol, s_OHOct_Per_Sym_rounded, s_r0, s_r1, s_r2, s_L_Delta;
   int32 l_a0, l_OHRate;
   uint32 ul_LineRate;
   int16 s_k_x_CWSize, s_Up, s_SEQp, s_Ip, s_q;

   VDSL2FramingParamsInputs_t *pt_Input;
   VDSL2Config_t *pt_Config;
   int16 s_bitCheck_Lmax, s_bitCheck_Lmin, s_bit;

   s_path = gs_data_path;
   pt_Input = &gt_FormFramingParamsInputs_v2;
   pt_Config = &gt_rx_config_v2;

   //clear out the global arrays
   s_index_Lmax = 7;
   s_index_Lmin = 5;
   memset(gula_Lmax, 0, sizeof(uint32)*s_index_Lmax);
   memset(gusa_Lmin, 0, sizeof(uint16)*s_index_Lmin);

   us_Qmax = QMAX;
   us_DRmax = DR0;
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      us_Qmax = QMAX_35B;
      us_DRmax = DR0_35B;
   }

   //For fixed rate configuration, we skip the framing constraints calculation
   //If MinDelay == MaxDelay, it is indirectly fixed rate, since Delay = 8*(Nfec - q)*(Dp - 1)/(q* Lp * fs);
   if ((pt_Input->s_MaxDelay == pt_Input->s_MinDelay) || (pt_Input->us_MaxRate == pt_Input->us_MinRate))
   {
      gul_AutoSRALmin = gul_AutoSRALmax = pt_Config->ul_Lp[s_path];
      return;
   }


   /**< @note: For VR9, check only the following
       for Lpmax
           1. Bound on the Mp/Sp ratio 2. Bound on the max codewords 3. Bound on Tp, Gp & Mp

       for Lpmin
           1. Bound on the Codeword limit
   */
   /*
   *-------------------------------------------------------------------------------
   *
   ERS = SRA Rate Check

   If rate check is enabled with bit ERC following additional checks will be done for upstream SRA (MODEus =
   RA_MODE_DYNAMIC).
    * minimum net data rate (Min_Rate in CMD_Bearer_Ch_Configuration)
    * maximum net data rate (Max_Rate in CMD_Bearer_Ch_Configuration)
    * minimum/maximum rate of message based portion of overhead channel (MSGmin)



   ESRC = SRA Strict Rate Check

   If strict rate check is enabled with bit ESRCand rate check is enabled with bit ERC following additional checks will
   be done for upstream SRA (MODEus = RA_MODE_DYNAMIC).
    * minimum impulse noise protection (Min_INP in CMD_Bearer_Ch_Configuration)
    * maximum delay (Max_Delay in CMD_Bearer_Ch_Configuration)
   *-------------------------------------------------------------------------------*/

   //For implementation, we use bit location to represent every limit constraint
   //s_bitCheck_Lmax
   //      bit0: LmaxConstraint#0     Lp <= 512 * Nfecp / Mp
   //      bit1: Sp = 8*CW/Lp <= Smax Lp <= 8 * Nfecp * (1/S)max
   //      bit2: rule #2              Lp <= 64 * Nfecp * Tp / (Gp * Mp)
   //      bit3: overhead rate max limit Lp <= ORpmax * Nfecp * Tp / (Gp * fs * Mp)
   //      bit4: max netdata rate limit  Lp <= ((NDRpmax + ORpmax) * Nfecp/ ((Nfecp - Rp) * fs)
   //      bit5: INP_min limit          Lp <= (4 * Rp * Dp) / INPmin
   //      bit6: Delay_min limit       Lp <= (Dp * 8 * Nfecp)/ (fs * MinDelay)
   //
   //s_bitCheck_Lmin
   //      bit0: Sp = 8*CW/Lp <= 64; if MaxLat = 1, Sp <=1
   //      bit1: OR_min limit            Lp >= (ORpmin * Nfecp * Tp) / (Gp * fs * Mp)
   //      bit2: min netdata rate limit    Lp >= RateMin*Nfecp/((Nfecp-Rp-Gp/kp)*fs)
   //      bit3: MSGp limit            MSGmin<=MSGp = ORp * (SEQp - 6) /SEQp <= MSGmax
   //      bit4: Max Delay limit           Lp >= (Dp * 8 * Nfecp)/ fs * Maxdelay
   if((OPTNArray[OPTN_OLRControl]&OPTN_DS_SRARATECheckMask) == (int16)(OPTN_DS_SRARateCheck|OPTN_DS_SRAStrictRateCheck))
   {
      s_bitCheck_Lmax = 0x7F;  //All bits are set
      s_bitCheck_Lmin = 0x1F;    //All bits are set
   }
   else if((OPTNArray[OPTN_OLRControl]&OPTN_DS_SRARATECheckMask) == (int16)OPTN_DS_SRARateCheck)
   {
      s_bitCheck_Lmax = 0x1F;  //bit 0~4 set
      s_bitCheck_Lmin = 0xF;   //bit 0~3 set
   }
   else if((OPTNArray[OPTN_OLRControl]&OPTN_DS_SRARATECheckMask) == (int16)OPTN_DS_SRAStrictRateCheck)
   {
      s_bitCheck_Lmax = 0x77;   //bit 0~3, bit5~6 are set.
      s_bitCheck_Lmin = 0x15;   //bit 0, bit 4 are set.
   }
   else
   {
      s_bitCheck_Lmax = 0x17;   //bit 0~3 are set.
      s_bitCheck_Lmin = 0x5;   //bit 0 is set.
   }

   pt_Input = &gt_FormFramingParamsInputs_v2;
   pt_Config = &gt_rx_config_v2;

   // Get the current framing parameters
   s_Mp = pt_Config->s_Mp[s_path];
   s_Tp = pt_Config->s_Tp[s_path];
   s_Rp = pt_Config->s_Rp[s_path];
   s_Dp = pt_Config->s_Dp[s_path];
   s_Gp = pt_Config->s_Gp[s_path];
   s_Rp = pt_Config->s_Rp[s_path];
   s_Ip = pt_Config->s_Ip[s_path];

   ul_L_orig = pt_Config->ul_Lp[s_path];

   s_Nfecp = pt_Config->s_Nfecp[s_path];

   // Compute k give by Tp = k * Mp
   s_k = s_Tp/ s_Mp;

   // Upmax = floor [us_Qmax /(k * Nfecp)]
   MULU16(us_temp, s_Nfecp, s_k);
   s_Upmax= us_Qmax/ us_temp;

   // SEQp = Up*Gp;  (note: highest value of SEQp is 17000 bytes)
   MULS16(s_SEQpmax, s_Upmax, s_Gp);

   MULS32x16(l_temp, pt_Input->s_MinMsgOHR, s_SEQpmax);

   // Compute Min overhead rate in Q13.3 format
   // ORp = SEQp * msgp / ( SEQp - 6)

   s_MinOHRate = ceil32((l_temp << 3),(int16)(s_SEQpmax - 6));

   // PERp max = (8 * Qmax)/DR0  ( equals 17.25 ms corresponding to Qmax = 17000 and DR0 = 7880 Kbps)

   // MinIBITSOHR = (6 * 8)/ PERpmax
   // MinIBITSOHR = (6 * 7880)/ 17000
   MULU16(ul_temp1, 6, DR0);
   s_MinIBitsOHR = ceil32(ul_temp1, QMAX);

   // Compute Min/Max Overhead Rate
   s_MaxOHRate = pt_Input->s_MaxMsgOHR + s_MinIBitsOHR;

   // Ensure that the max overhead rate is less than the theoretical max ie. MaxOHRate <= 64*fs
   //  Account for the "fs" format which is upscaled by a factor of 1024 and is in Q6.10 format
   us_temp = pt_Input->s_fs >> (FRAME_RATE_SHIFT_CNT - 6);

   // if (s_MaxOHRate > (pt_Input->s_fs << 6))
   //   s_MaxOHRate = (pt_Input->s_fs << 6);
   if (s_MaxOHRate > us_temp)
   {
      s_MaxOHRate = us_temp;
   }


   // Initialise the Lp min/ max values
   ul_Lmin = 8;
   ul_Lmax = 15 * gs_RxNumTonesUsed;

   /***********************************
   * LmaxConstraints:
   ************************************
   *
   * 0: Lp <= 512 * Nfecp / Mp                  <== rule #1: Mp/Sp <= 64
   * 1: Lp <= 8 * Nfecp * (1/S)max               <== Sp = 8*CW/Lp <= Smax
   * 2: Lp <= 64 * Nfecp * Tp / (Gp * Mp)          <== rule #2: simpler but coarse version (in the code followed by a strict calculation)
   * 3: Lp <= ORpmax * Nfecp * Tp / (Gp * fs * Mp) <== overhead rate max limit
   * 4: Lp <= ((NDRpmax + ORpmax) * Nfecp/ ((Nfecp - Rp) * fs)   <== max netdata rate limit
   * 5: Lp <= (4 * Rp * Dp) / INPmin                             <== INP_min limit
   * 6: Lp <= (Dp * 8 * Nfecp)/ (fs * MinDelay)                  <== Delay_min limit
   ************************************/

   // 0: Lp <= 512 * Nfecp / Mp
   ul_temp1 = (s_Nfecp << 9)/ s_Mp;
   gula_Lmax[0] = MIN(ul_temp1, MAX_LP);

   // 1: Lp <= 8 * Nfecp * (1/S)max
   MULU16(ul_temp1, (s_Nfecp << 3), pt_Input->s_OneOverSmax);
   gula_Lmax[1] = MIN(ul_temp1, MAX_LP);

   // 2: Lp <= (64 * Nfecp * k)/Gp
   MULU16(ul_temp1, (s_Nfecp << 6), s_k);
   ul_temp1 = ul_temp1/ s_Gp;
   gula_Lmax[2] = MIN(ul_temp1, MAX_LP);

   // 3: Lp <= ORpmax * Nfecp * k / (Gp * fs)
   MULU16(us_temp, s_k, s_MaxOHRate);
   MULU16(ul_temp1, us_temp, s_Nfecp);

   MULU16(ul_temp2, pt_Input->s_fs, s_Gp);

   //  Account for the "fs" format which is upscaled by a factor of 1024 and is in Q6.10 format
   ul_temp1 = (ul_temp1 << FRAME_RATE_SHIFT_CNT)/ ul_temp2;

   //Calculate the (1/Sp)max from OHOct_Per_Sym_rounded

//---------------------------------------------------------
   // Now determine if Gp and Tp comply with Rule #2 for Gp & Tp settings.  This has a stricter limit on OH-octet/symbol than the OHRate limit.
   /*
      % Formula according to Rule #2 of Gp & Tp selection
      OHOct_Per_MDF = floor(Gp/Tp);
      MDF_Per_Symbol = ceil(Mp/Sp);
      OHOct_Per_Sym_rounded = OHOct_Per_MDF*MDF_Per_Symbol + floor(MDF_Per_Symbol/Tp)*mod(Gp,Tp) + min(mod(MDF_Per_Symbol, Tp), mod(Gp,Tp));
   */

   s_OHOct_Per_MDF  = s_Gp/s_Tp;
   s_r0 = s_Nfecp<<3;               //s_r0 = us_CWSize * 8
   // s_r1 = mod(Gp,Tp)
   s_r1 = mod16(s_Gp, s_Tp);

   s_L_Delta = (int16) (ul_temp1 - ul_L_orig);
   if (s_L_Delta <= 0)
   {
      s_L_Delta = 1;
   }

   ul_Lp = MIN(ul_temp1, ul_Lmax);
   ul_Lptemp = ul_Lp;
   do
   {
      // to compute ceil(Mp/Sp) ==> ceil ((Mp*Lp)/(8*CWSize))
      MULS32x16(l_a0, ul_Lp, s_Mp);            //l_a0 = us_Mp * ul_Lp;   //worst case is 16*61440
      // inputs: l_a0 = Mp*Lp; s_r0 = 8*CWSize
      s_MDF_Per_Symbol = ceil32(l_a0, s_r0);
      // s_r2 = floor(MDF_Per_Symbol/Tp)
      s_r2 = s_MDF_Per_Symbol/s_Tp;

      // compute partial value of "OHOct_Per_Sym_rounded" -> sum up 1st & 2nd part of the equation
      MULS16(s_OHOct_Per_Sym_rounded, s_OHOct_Per_MDF, s_MDF_Per_Symbol);
      MULS16(l_a0, s_r2, s_r1);
      s_OHOct_Per_Sym_rounded += (int16)l_a0;      //s_OHOct_Per_Sym_rounded = s_OHOct_Per_MDF*s_MDF_Per_Symbol + s_r0*s_r1;

      // now compute min(mod(MDF_Per_Symbol, Tp), mod(Gp,Tp))
      // at this point: s_r1 = mod(Gp,Tp)
      s_r2 = mod16(s_MDF_Per_Symbol, s_Tp);
      if (s_r2>s_r1)
      {
         s_r2 = s_r1;   // s_r0 = min(s_r0,s_r1)
      }

      // finally, we can add the 3rd part to "OHOct_Per_Sym_rounded"
      s_OHOct_Per_Sym_rounded += s_r2;
      //---------------------------------------------------------

      // If the newly selected Gp violates Rule #2 or violates guc_maxG requirement,
      // then we should reduce Lp to bring down overall TotalRate
      if (s_OHOct_Per_Sym_rounded > 8)
      {
         ul_Lptemp = ul_Lp - (s_L_Delta/2);
         if (ul_Lptemp < ul_L_orig)
         {
            break;
         }

      }
      else
      {
         ul_Lptemp = ul_Lp + (s_L_Delta/2);
         if (ul_Lptemp > ul_temp1)
         {
            break;
         }
      }

      ul_Lp = ul_Lptemp;

      s_L_Delta >>= 1;
   }
   while (s_L_Delta > 1);


   if (s_OHOct_Per_Sym_rounded > 8)
   {
      ul_Lp -= 1;
   }

   gula_Lmax[3] = MIN(ul_temp1, ul_Lmax);

   // NOTE: Be on the conservative side to assume the min overhread rate
   // when computing the Lpmax for AutoSRA ie. the Lpmax value could be higher
   // if we assumed a higher overhead rate here. This ensures that we maintain
   // good margin when doing upshift SRA and don't do too much upshift

   //  4: Lp <= ((NDRpmax + ORpmin) * Nfecp)/((Nfecp - Rp) * fs)

   // Convert the unit of max rate from "multiple of 8 Kbps" to "kbps" value
   ul_temp1 = (pt_Input->us_MaxRate << 3);
   MULS32x16(ul_temp2, ul_temp1, s_Nfecp);

   MULU16(ul_temp1, s_MinOHRate, s_Nfecp);

   // Convert from Q13.3 to Q16.0 format
   ul_temp1 = (ul_temp1 + (1 << 2)) >> 3;

   ul_temp1 += ul_temp2;

   MULU16(ul_temp2, pt_Input->s_fs, (s_Nfecp - s_Rp));
   // Do a downshift here to partially account for "fs" format to avoid overflow in numerator in the next step
   ul_temp2 = (ul_temp2 + (1<<4)) >> 5;
   // Downshift in denominator for "fs" Q6.10 corresponds to an upshift of numerator
   // Upshift the numerator to account for the "fs" format
   ul_temp1 = (ul_temp1 << (FRAME_RATE_SHIFT_CNT -5));

   gula_Lmax[4] = BinarySearch(TRUE, ul_temp1, ul_temp2, ul_L_orig, ul_Lmax, ul_L_orig);



   //  5: Erasure disabled: Lp <= (4 * Rp * Dp)       / INPmin
   //  or Erasure enabled:  Lp <= (8 * (Rp-2*T) * Dp) / INPmin with T = erasure T bytes.
   if (pt_Input->s_MinINP)
   {
      {
         MULU16(ul_temp1, (s_Rp << 2), s_Dp);
         //ul_temp1 = ul_temp1 / pt_Input->s_MinINP;
      }
      gula_Lmax[5] = BinarySearch(TRUE, ul_temp1, (uint32)(pt_Input->s_MinINP), ul_L_orig, ul_Lmax, ul_L_orig);
   }
   else
   {
      gula_Lmax[5] = ul_Lmax;
   }

   // Compute Delay = 8*(Nfec - q)*(Dp - 1)/(q* Lp * fs);
   // 6: (q*fs*MinDelay)*Lp <= 8*(Nfec-q)*(Dp-1)/
   if (pt_Input->s_MinDelay != 0)
   {
      s_q = s_Nfecp/s_Ip;
      l_a0 = ((s_Nfecp - s_q)*(s_Dp-1))<<3;

      MULU16(ul_temp2, pt_Input->s_MinDelay, ((pt_Input->s_fs)*s_q));
      ul_temp2 += 1<<2;
      ul_temp2 = ul_temp2 >> 3;


      // Downshift in denominator for "fs" Q6.10 format corresponds to an upshift of numerator
      gula_Lmax[6] = BinarySearch(TRUE, (l_a0<<FRAME_RATE_SHIFT_CNT-3), ul_temp2, 0, ul_Lmax, ul_L_orig);
   }
   else
   {
      gula_Lmax[6] = ul_Lmax;
   }

   ul_Lmax=MAX_LP;


   for (i = 0; i < s_index_Lmax; i++)
   {
      //find the minimum of all the Lmax
      s_bit = (s_bitCheck_Lmax >> i) & 0x1;
      if (s_bit == 1)
      {
         if (ul_Lmax > gula_Lmax[i])
         {
            ul_Lmax = gula_Lmax[i];
         }
      }
   }

   //Make sure the Lmax is no less than Lorig, sometimes because the bitloading issue, we saw ul_Lmax < ul_L_orig
   //We may need to change our bitloading code because our current bitloading code has precision issue that in some cases
   //the orignal framing gives us the Delay < Delay_min. The framing constraints code doesn't have
   //precision issue, but it will give us the odd indication that the result ul_Lmax < ul_L_orig.
   ul_Lmax = MAX(ul_Lmax, ul_L_orig);

//XDSLRTFW-921: Fix_All_VDSL2_All_SraUpshift[Start_End]

   /***********************************
   * LminConstraints:
   ************************************
   *
   * 0: Lp >= Nfecp / 8                                         <== Sp = 8*CW/Lp <= 64
   * : As per G997 spec, if MaxLat = 1 (fast path), Sp <= 1
   * 1: Lp >= (ORpmin * Nfecp * Tp) / (Gp * fs * Mp)            <== OR_min limit
   * 2: Lp >= RateMin*Nfecp/((Nfecp-Rp-Gp/kp)*fs)               <== min netdata rate limit
   * 3. The message overhead data rate (for OH frame Type 1 only):  <== MSGp limit
   * The settings of framing parameters shall provide msgmin < msgp < msgmax.
   * The settings for msgmin and msgmax shall comply with the following conditions:
   * 16 kbit/s   msgmin < 248 kbit/s;  msgmax = 256 kbit/s.
   *   MSGmin<=MSGp = ORp * (SEQp - 6) /SEQp <= MSGmax
   *   MSGmin <= Lp*fs*Gp*(SEQp - 6)/(k*Nfecp*SEQp)
   * 4: Lp >= (Dp * 8 * Nfecp)/ fs * Maxdelay                   <== Max Delay limit
   ************************************/

   // 0: Lp >= Nfecp / 8 (Sp <= 64) or Lp >= 8*Nfecp (Sp <= 1)
   // Don't apply the Lmin check due to Sp in fastpath
   //  if (gft_RestrictDpTo1 == 1)
   //  {
   //   gusa_Lmin[0] = s_Nfecp << 3;
   //
   //   //Bo: couldn't find the Sp<=1 requirement in G997 or VDSL2 standard. So for the time being just reduce
   //   //gusa_Lmin[0] by 20%(almost Sp<=1.2)
   //   gusa_Lmin[0] = ((gusa_Lmin[0]/10) <<3);
   //
   //   }
   //   else
   //   {
   gusa_Lmin[0] = (s_Nfecp + 7)>> 3;
   //   }

   // 1: Lp >= (ORpmin * Nfecp * Tp) / (Gp * fs * Mp)
   MULU16(ul_temp2, s_k, s_MinOHRate);
   MULS32x16(ul_temp1, ul_temp2, s_Nfecp);

   // Downshift in denominator for "fs" Q6.10 format corresponds to an upshift of numerator
   ul_temp1 <<= (FRAME_RATE_SHIFT_CNT-5);

   MULU16(ul_temp2, (pt_Input->s_fs>>2), s_Gp);

   gusa_Lmin[1] = BinarySearch(FALSE, ul_temp1, ul_temp2, 8, ul_L_orig, 8);

   // 2: Lp >= (NDRpmin + ORpmin) * Nfecp)/ ((Nfecp - Rp) * fs)
   // 2: Lp >= RateMin*Nfecp/((Nfecp-Rp-Gp/kp)*fs)<== min netdata rate limit
   // Convert the unit of min rate from "multiple of 8 Kbps" to "kbps" value
   ul_temp1 = (pt_Input->us_MinRate)*s_k*8;
   MULS32x16(ul_temp1, ul_temp1, s_Nfecp);
   ul_temp1 <<= 5;

   // Convert from Q13.3 to Q16.0 format

   MULU16(ul_temp2, (s_Nfecp - s_Rp), s_k);
   ul_temp2 -= s_Gp;
   MULS32x16(ul_temp2, ul_temp2, pt_Input->s_fs);

   // Downshift in denominator for "fs" Q6.10 format corresponds to an upshift of numerator
   gusa_Lmin[2] = BinarySearch(FALSE, ul_temp1, ul_temp2>>(FRAME_RATE_SHIFT_CNT-5), 8, ul_L_orig, 8);

   // 3. MSGmin*Qhat <= Lp*fs*Gp*(SEQp - 6)
   ul_Lp = (uint32)gusa_Lmin[1];
   ul_Lptemp = ul_Lp;
   s_L_Delta = (int16) (ul_L_orig-ul_Lp);
   if (s_L_Delta < 0)
   {
      s_L_Delta = 0;
   }

   MULU16(s_k_x_CWSize, s_k, s_Nfecp);      // worst case is 64*255 =16320 (store in 16-bit signed number is ok)

   if (pt_Input->s_OHFrameType == 1)
   {
      uint16 us_Qhat;

      do
      {
         // compute frequently used terms and stored them in well-defined locals:
         // a) DRp = ul_LineRate = ul_Lp*pt_Input->s_fs;
         //MULU16(ul_LineRate, ul_Lp, pt_Input->s_fs);
         MULS32x16(ul_LineRate, ul_Lp, pt_Input->s_fs);
         ul_LineRate += 1<<(FRAME_RATE_SHIFT_CNT-1);
         ul_LineRate >>= FRAME_RATE_SHIFT_CNT;

         us_Qhat = us_Qmax;
         if (ul_LineRate < us_DRmax)
         {
            //us_Qhat = QMAX*ul_LineRate/DR0;
            MULS32xU16(ul_temp1, ul_LineRate, QMAX);
            us_Qhat = ul_temp1/DR0;
         }

         // Up = floor(Qhat*Mp/Tp/CWSize)
         //    = floor(Qhat/(k*CWSize)), where k = Tp/Mp;
         s_Up = us_Qhat/s_k_x_CWSize;

         // SEQp = Up*Gp;  (note: highest value of SEQp is 17000 bytes)
         MULS16(s_SEQp, s_Up, s_Gp);

         if (s_SEQp > 6)
         {
            // OHRate = Lp*fs*Gp/(k*CWSize) (in Q28.4)
            l_a0 = (ul_LineRate*s_Gp) << 8;
            l_OHRate = l_a0/s_k_x_CWSize;

            MULS32x16(ul_temp1, l_OHRate, (s_SEQp - 6));

            MULS16(ul_temp2, ((pt_Input->s_MinMsgOHR) << 8), s_SEQp);
         }
         else
         {
            ul_temp1 = ul_temp2 - 1;
         }


         if (ul_temp1 < ul_temp2)
         {
            if (ul_Lptemp >= ul_L_orig)
            {
               break;
            }
            else
            {
               ul_Lptemp = ul_Lptemp + (s_L_Delta/2);
               ul_Lp = ul_Lptemp;
               s_L_Delta >>= 1;
            }
         }
         else
         {
            if ((uint32)ul_Lptemp <= (uint32)gusa_Lmin[1] )
            {
               break;
            }
            else
            {
               ul_Lptemp = ul_Lptemp - (s_L_Delta/2);
               ul_Lp = ul_Lptemp;
               s_L_Delta >>= 1;
            }
         }

      }
      while (s_L_Delta > 0);

      if (ul_temp1 < ul_temp2)
      {
         ul_Lp += 1;
      }

   }

   gusa_Lmin[3] = (uint16)ul_Lp;

   // Compute Delay = 8*(Nfec - q)*(Dp - 1)/(q* Lp * fs);
   // 4: Lp >= 8*(Nfec-q)*(Dp-1)/(q*fs*MaxDelay)
   s_q = s_Nfecp/s_Ip;
   l_a0 = ((s_Nfecp - s_q)*(s_Dp-1))<<3;

   MULU16(ul_temp2, pt_Input->s_MaxDelay, ((pt_Input->s_fs)*s_q));
   ul_temp2 += 1<<2;
   ul_temp2 = ul_temp2 >> 3;

   ul_Lmin = 8;
   ul_L_orig = pt_Config->ul_Lp[0];
   // Downshift in denominator for "fs" Q6.10 format corresponds to an upshift of numerator
   gusa_Lmin[4] = BinarySearch(FALSE, (l_a0<<(FRAME_RATE_SHIFT_CNT-3)), (ul_temp2-64), 8, ul_L_orig, 8);

   for (i = 0; i < s_index_Lmin; i++)
   {
      s_bit = (s_bitCheck_Lmin >> i) & 0x1;
      if (s_bit == 1)
      {
         //find the maximum of all the Lmin
         if ((uint32)ul_Lmin  < (uint32)gusa_Lmin[i])
         {
            ul_Lmin = (uint32)gusa_Lmin[i];
         }
      }
   }

   //Make sure the Lmin is no greater than Lorig
   ul_Lmin = MIN(ul_Lmin, ul_L_orig);
   //XDSLRTFW-921/922: Fix_All_All_VDSL2_BRCM_Vdsl2Sra [Start]
   if (gul_fe_G994VendorID == BRCM_VENDOR_ID)
   {
      ul_Lptemp = ul_L_orig;

      //about 77 percent
      ul_Lptemp = ((6*ul_Lptemp + (ul_Lptemp >> 3))>>3);
      if(ul_Lmin < ul_Lptemp)
      {
         ul_Lmin = ul_Lptemp;
      }
      // @mahesh: For KPN, Disabling the cmv which blocks SRA on continuous triggers.
      //TESTArray[TEST_ReconfigControl] |=TEST_AbandonSRA;
   }
   //XDSLRTFW-921/922: Fix_All_All_VDSL2_BRCM_Vdsl2Sra[End]
   gul_AutoSRALmin = ul_Lmin;

// Don't go beyond the original Lp when doing upshift SRAs
   gul_AutoSRALmax = ul_Lmax;
}
/*
*-------------------------------------------------------------------------------
*
*   Prototype: uint32 BinarySearch(FlagT ft_FindMax, uint32 ul_Cnstrnt1, uint32 ul_Cnstrnt2, int16 s_start, int16 s_end, int16 s_default)
*
*
*   This function performs the binary search for Lmin, Lmax value for AutoSRA
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

uint32 BinarySearch(FlagT ft_FindMax, uint32 ul_Cnstrnt1, uint32 ul_Cnstrnt2, uint32 ul_start, uint32 ul_end, uint32 ul_default)
{
   int32 l_delta;
   uint32 ul_value, ul_result;
   uint32 ul_temp;

   if (ul_Cnstrnt2 == 0)
   {
      return (ul_default);
   }
   else if (ul_Cnstrnt2 == 1)
   {
      return (ul_Cnstrnt1);
   }
   else
   {

      while (ul_start < ul_end)
      {
         l_delta = (ul_end - ul_start) >> 1;
         ul_value = ul_start + l_delta;
         ul_temp = ul_Cnstrnt2 *ul_value;

         if(ul_Cnstrnt1 < ul_temp)
         {
            ul_end = ul_value-1;
         }
         else if (ul_Cnstrnt1 > ul_temp)
         {
            ul_start = ul_value+1;
         }
         else //(int32)ul_Cnstrnt1[i] == l_temp
         {
            return (ul_value);
         }
      }


      ul_temp = ul_Cnstrnt2 * ul_end;
      ul_result = ul_end;
      if (ft_FindMax == TRUE)
      {
         if (ul_Cnstrnt1 < ul_temp)
         {
            ul_result = ul_end-1;
         }
      }
      else if ((ft_FindMax == FALSE) && (ul_Cnstrnt1 > ul_temp))
      {
         ul_result = ul_end+1;
      }

      return (ul_result);
   }
}
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
