/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitShowTimeTx.c
*
*   This file contains functions to initialize showtime variables.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// InitShowTimeTx_VDSL2.c
//
// History
//
//
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//             VDSL2 Bitloading algo doesn't consider the "Erasure decoding" capability.
//            So, as per R6 DSL-API request, report same INP value through "RATE 1 [14:15]" & "RATE 1 [16:17]", if Erasure decoding is not used.
//            Grep for XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec
//
// 26/2/2013 Vinjam: Report ActINPnoErasure & ActINPErasure in 0.1 DMT symbol granularity
//            Grep for XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec
//
// 05/3/2013 Vinjam: Report Delay in 0.01 milli seconds granularity to the near-end
//           Grep for XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms
//
// 09/05/2013 Kannan: Round of error corrected for l_NetDataRate computation.
//            Grep for "XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop "
//
// 21/05/2013 Fuss: Link drop on CO due to FE LOF indication
//            Grep for XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication
//
// // 06/05/2013 Varun : Added code(Debug option) to initiate CMV for Structure Size
//
//                     Grep for "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//       Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//      - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//      - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
//30-10-2013 Varun : CPE reporting wrong test parameter values of Actual INP shine and rein .This was because Delay max for DS was taken
//                    instead of US Delay Max which resulted in wrong caluculation of NRET.
//                    Grep for XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation
// 09/12/2013 Varun : Updated the calculation of US NDR when US ReTx is in use
//                    Grep for XDSLRTFW-1434
// 03-01-2014 Varun : Added the Calculation for ADR,TDR,OH rate for both DS and US
//                    Grep for XDSLRTFW-1478
//
// 07/09/2017 Vinay: XDSLRTFW-3444: ERB vectoring control settings are not correct in showtime
//                    Analyse/decode all the ERB messages which are used to start the ERB transmission because
//                    - Stop messages do not include the right information (e.g. L_w may be 0 or F_block != 1)
//                    - the configuration may change in showtime
//                    Moved the ERB-Descriptor initialization to showtime configuration function
//                    Grep for "XDSLRTFW-3444".
//
//20/09/2017 Stefan: XDSLRTFW-3489: Reported US datarate 0 in the beginning of showtime
//                   We do not have the ETR available in the beginning of showtime.
//                   The ETR will be transmitted in showtime via the OHC from the CO to the CPE.
//                   To communicate at least a good estimation of the ETR to the API in the beginning of showtime
//                   until the particular OHC message has been received we initialize the US ETR to US NDR.
//                   Grep for: "XDSLRTFW-3489: Reported US datarate 0 in the beginning of showtime"
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv_Data.h"
#include "fifo.h"
#include "InitShowTimeTx.h"
#include "TxDataPumpSetUp.h"
#include "ToneReorder.h"
#include "eoc.h"
#include "vdsl_xception.h"
#include "dsp_op.h"
#include "mul.h"
#include "Snr_b.h"
#include "ConvertToDB.h"
#include "decimalgain.h"
#include "Framing_VDSL2.h"
#include "showtime.h"
#include "Us_Rtx.h"
#include "zep_memmap_cnfg.h"
#include "Dsp_regs_62.h"
#include "ppe_memmap.h"
#include "LL_Iof.h"
#include "ShowtimeErbHandler.h"
#include "cmv.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitShowTimeTxVars_VDSL2(void)
*
*   This function initializes showtime variables for TX path.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void InitShowTimeTxVars_VDSL2(void)
{
   uint8 uc_ovhd_byte=0, uc_erb_descriptor_index = 0;
   int16 s_lp, s_bc, i;
   int32 l_NetDataRate, l_OHRate;
   uint16 us_delay;
   VDSL2Config_t *pt_Config;
   uint32 ul_addr, ul_data;
   uint32 *ul_addr_pointer = NULL;

   //XDSLRTFW-1522 (Start)
   ReTx_ComputeInp_Params_t t_ComputeInp_Params;
   //XDSLRTFW-1522 (End)

   pt_Config = &gt_tx_config_v2;
   // Initialize Tx PMD frame counter
   gs_TxPMDFrameCount = 0;

   // REVIEW_STEFAN: TBD: Why do we do the initialization for ERBS in Tx function?
   if (gft_DSVectoringEnabled == TRUE)
   {
      //XDSLRTFW-3255 (Start)
      gul_BAR14 = *(uint32 *)(DSP_XMEM_BAR14);
      gul_BAR17 = *(uint32 *)(DSP_XMEM_BAR17);

      if ((gul_BAR14 == 0) || (gul_BAR17 == 0))
      {
         EnterFailStates(E_CODE_ERB_BAR_NOT_CONFIGURED);
      }
      //XDSLRTFW-3255 (End)

      // XDSLRTFW-3444 (Start)
      // Moved the ERB descriptor initialization from OHC handler
      // The ERB descriptor address
      // Bit definition of 0x7DC8 (DREG_MISCRAM8_ADDR)
      //  Bit 15 - Bit 0     --> Base address of ERB descriptor list
      ul_addr = DREG_MISCRAM8_ADDR;
      ReadPpeReg(ul_addr, &ul_data);
      gul_DREG_ERB_Descriptor_Base = (ul_data & 0xFFFF);

      // Number of ERB descriptors
      // Bit definition of 0x7DC9 (DREG_MISCRAM9_ADDR)
      //  Bit 3- Bit 0     --> Number of ERB descriptors
      // Currently, the maximum number of ERB descriptor is 9
      ul_addr = DREG_MISCRAM9_ADDR;
      ReadPpeReg(ul_addr,&ul_data);
      gul_DREG_ERB_Number = ul_data & (MASK_BIT0 | MASK_BIT1 | MASK_BIT2 | MASK_BIT3);

      // XDSLRTFW-3508 (Start)
      if (gul_DREG_ERB_Number > MAX_NUM_ERB_SEGMENTS)
      {
         EnterFailStates(E_CODE_ERB_DESCRIPTOR_NUMBER);
      }
      // XDSLRTFW-3508 (End)

      // BAR 17 consists of ERB descriptors
      ul_addr_pointer = (uint32 *)(((uint32)&__StartOfSramBAR17) + gul_DREG_ERB_Descriptor_Base); //XDSLRTFW-3421 (Start_End)
      memcpy(&gt_ERBDescriptor, ul_addr_pointer, 72);   // XDSLRTFW-3448 (Start_End)

      // We have a bit (Bit 2 of 0x7DC6 or DREG_MISC_RAM6) defined to indicate that ERB descriptors initialized.
      // But incase of older PPE driver, tis bit is not implemented.
      // The DSL FW does not wants to have 2 method of implementation for older and latest PPE drivers.
      // Hence, we are checking the Ownerbit in each of the ERB descriptors, which is a more robust fix.
      while (uc_erb_descriptor_index < gul_DREG_ERB_Number)
      {
         gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW0 &= (0xFFFF);
         gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW0 += (uint32)&(__StartOfSramBAR14);
         if (gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 & SET_OWNER_BIT_ERB_DESCRIPTOR)
         {
            EnterFailStates(E_CODE_ERB_DESCRIPTOR_OWNER_BIT);
         }
         uc_erb_descriptor_index++;
      }
      guc_erb_descriptor_index = 0;
      // XDSLRTFW-3444 (End)
   }

   // Initialize the BC->TPS and Lp->ABC mapping
   InitTxVarsCommon(&gt_tx_TPS_Map);
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      // In case of retransmission, LP0 always carries the overhead path
//        gt_tx_TPS_Map.s_IBITSlp = LP0;
//      gs_BytesProcessedPerDTU = 0;
      gs_DTU_size = (pt_Config->s_Nfecp[LP1]) * (gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q);// size in bytes

      //XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation(START_END)

      // use for 30 MHz Bandplan
      if (gs_frame_rate_is_8khz==1)
      {

         // Compute the max delay value expressed in symbols(Delay max in ms and 1ms=8 symbols); Assume 8 KHz mode
         guc_TS_Discard_Th = (gt_ReTXParams.t_ReTXConfigCMV.us_US_DelayMax << 3);
      }
      else
      {
         // Compute the max delay value expressed in symbols(Delay max in ms and 1ms=4 symbols); Assume 4 KHz mode
         guc_TS_Discard_Th = (gt_ReTXParams.t_ReTXConfigCMV.us_US_DelayMax << 2);
      }


      gsa_size_num_bytes_transfer[0]=0;
      gsa_size_num_bytes_transfer[1]=0;
      gsa_size_num_bytes_transfer[2]=0;

      gft_UsReTxSraStopRrcEval = FALSE;//XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start_end)
      gft_UsReTxSraTRansDetect = FALSE;
      gl_RrcValid = -1;
      gs_RRCOffset = 0;
      guc_PrevAbsoluteDtuCountLsbs = 31;
      gs_Delta_DTU_TX = 0;
      gl_TxAbsoluteDTUCount = 0;
      gul_retransmitted_delta=0;

      gs_ReTxTable_wr_pointer=-1;
      memset(gusa_ReTxTable, 0,  sizeof(gusa_ReTxTable));
      gt_UsReTx_DelayDTUs.us_MaxRoundTripDelay_DTUS=0;
      gt_UsReTx_DelayDTUs.us_MinRoundTripDelay_DTUS=0;
      gs_num_RndTrip_Errors = 0;
      gs_num_discarded_DTUs=0;
      //XDSLRTFW-1830(START)
      gs_RTXusR_Size = pt_Config->s_Rp[LP1]; //RS check bytes in CW
      //gs_DTUtc_Size = DTU Size - R check bytes.This being used for calculating TC bytes in case of DTU spread over DMT symbols
      gs_DTUtc_Size = gs_DTU_size - gs_RTXusR_Size;
      gs_DTUi_SizeInr = 0;
      //XDSLRTFW-1830(END)
      gs_DtuSizeIncr = gs_DTU_size;
      gs_running_DTUSize=0;
      gl_UsReTxBufWrRunningAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;
      gl_UsReTxBufEndAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress + (gs_DTU_size * gt_ReTXParams.us_OPMS_UsQtx)-1;
      gs_QTx = gt_ReTXParams.us_OPMS_UsQtx;
#ifdef ENABLE_RETX_US_DEBUG1
#endif
      gft_StopNewDtu = FALSE;
      guc_FirstQtxSymCnt = 0;
   }
   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      gt_tx_config_v2.ul_Reconfig_Lp[s_lp] = gt_tx_config_v2.ul_Lp[s_lp];
      gs_rd_step[s_lp] = GetFifoReadWriteStep(gt_tx_config_v2.s_Dp[s_lp], gt_tx_config_v2.s_Ip[s_lp]);
      pt_Config->s_Reconfig_Dp[s_lp] = pt_Config->s_Dp[s_lp];
      pt_Config->s_Reconfig_Gp[s_lp] = pt_Config->s_Gp[s_lp];
      pt_Config->s_Reconfig_Tp[s_lp] = pt_Config->s_Tp[s_lp];
   }

   pt_Config->s_Nlp = 0;

   // Get the count of active latency paths
   for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
   {
      // Check which latency path is assigned to s_bc
      s_lp = gt_tx_TPS_Map.s_BCtoLP[s_bc];

      if (s_lp != DISABLED_LP)
      {
         pt_Config->s_Nlp++;   // Increment the count of number of active latency paths
      }
   }
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
   // Clear Tx IB structure
   memset(&gt_TxIbData, 0, sizeof(TxIbDataStruct_t));

   // Initialize Tx IB structure
   TxIbInit();
   // XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
#ifdef DEBUG_TRACES



   gt_DebugBufferStatus.s_debugBuffer_Size_of_Super_Frame_structure_Bytes = sizeof(DebugShowTimeBuffSuperframe_t);

#endif //DEBUG_TRACES
// XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

   // Initialize Tx EOC vars
   TxEocInit();

   gt_TxOLRVars.uc_txOLRState = L0_STEADY_STATE;

   // Reset Tx OVHD message buffer read/write pointers
   gs_TxOvhdRdPtr = 0;
   gs_TxOvhdWrPtr = 0;
   gs_TxOvhdSwFifoDepth = 0;

   // Clear Tx OVHD message buffer
   memset(guca_TxOvhdSwFifoBuf, 0, TX_OVHD_MSG_SWFIFO_LEN * sizeof(uint8));

   gs_TxOvhdMsgIndex = 0;
   gs_TxOvhdState = INSERT_SYNC;

   guc_TxNTRByte = NTR_BYTE;

   gl_NTRSRC_residual = 0;

   if (gul_dbgShowtimeControl & VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL)
   {
      gs_TxSyncToneType = REVERB;
   }
   else
   {
      gs_TxSyncToneType = SEGUE;
   }

   gs_NumOHFrames = 0;

   //
   // Tx overhead messaging initialization
   //
   // Initialize Tx IB message buffer
   for(i=0; i<MAX_IB_BYTES_PER_SFRAME; i++)
   {
      if (i == 0)
      {
         guca_TxIbMsgBuf[i] = 0x1F;
      }
      else
      {
         guca_TxIbMsgBuf[i] = (uint8 )~NO_INDICATIONS;
      }
   }

   // Fill in the necessary overhead bytes for the first Zephyr run
   // accounting for the max ovhd bytes possible in a  PMD frame
// XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication (start)
// Note: Max 8 bytes (OPI) are allowed per standard in a MUX Data frame.
//       Since the HW is taking two times OPI bytes at the beginning of
//       showtime a preloading with 16bytes is necessary (worst case).
   while (gs_TxOvhdSwFifoDepth < MAX_OVHD_BYTES_PER_FRAME_INIT)
// XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication (end)
   {
      if (gs_TxOvhdState == INSERT_SYNC)
      {
         uc_ovhd_byte = SYNC_BYTE;

         // The sync byte is 0xAC for the first OH frame in a superframe
         if (gs_NumOHFrames == gt_tx_config_v2.s_Fp[gt_tx_TPS_Map.s_IBITSlp])
         {
            // Reset the count to start counting next set of Fp OH frames
            gs_NumOHFrames = 0;
         }

         // Take care of the sync byte value at the beginnning of an OH
         // superframe
         if (gs_NumOHFrames == 0)
         {
            uc_ovhd_byte = SYNC_BYTE_SFRAME;
         }

      }
      else if (gs_TxOvhdState < INSERT_NTR)
      {
         uc_ovhd_byte = guca_TxIbMsgBuf[gs_TxOvhdState -1];
      }
      else if (gs_TxOvhdState == INSERT_NTR)
      {
         uc_ovhd_byte = NTR_BYTE;

      }
      else if (gs_TxOvhdState >= INSERT_HDLC)
      {
         uc_ovhd_byte = (uint8)HDLC_FLAG;
      }

      if (gs_TxOvhdState < 5)
      {
         // Increment the ovhd state
         gs_TxOvhdState ++;
      }

      // Copy byte to SW FIFO buffer
      guca_TxOvhdSwFifoBuf[gs_TxOvhdWrPtr++] = uc_ovhd_byte;

      // Increment SW FIFO depth
      gs_TxOvhdSwFifoDepth++;

      // Increment the Tx message index
      gs_TxOvhdMsgIndex++;

      // Start back from SYNC byte every (SEQp -1) bytes
      if (gs_TxOvhdMsgIndex == (gt_tx_config_v2.s_SEQp[gt_tx_TPS_Map.s_IBITSlp] - 1))
      {
         // Increment the number of overhead frames every SEQp
         // bytes of overhead
         gs_NumOHFrames++;

         gs_TxOvhdMsgIndex = 0;
         gs_TxOvhdState = INSERT_SYNC;
      }

   } // End of while

   //------------------------------------------
   // compute variables used for CMV access
   //------------------------------------------
   {
      pt_Config = &gt_tx_config_v2;
      VDSL2ComputeRates_t t_ComputeRates;

      for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
      {
         // Set local variables
         t_ComputeRates.s_Path = s_lp;
         t_ComputeRates.s_Nfec = gt_tx_config_v2.s_Nfecp[s_lp];
         t_ComputeRates.s_Rp = gt_tx_config_v2.s_Rp[s_lp];
         t_ComputeRates.ul_Lp = gt_tx_config_v2.ul_Lp[s_lp];
         t_ComputeRates.us_Gp = gt_tx_config_v2.s_Gp[s_lp];
         t_ComputeRates.us_Mp = gt_tx_config_v2.s_Mp[s_lp];
         t_ComputeRates.us_Tp = gt_tx_config_v2.s_Tp[s_lp];

         // only for enabled latency path
         if (t_ComputeRates.ul_Lp != 0)
         {
            //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (start)
            if((gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE) && (s_lp == LP1))
            {
               //XDSLRTFW-1522 (Start)
               t_ComputeInp_Params.us_SHINE_ratio = gt_ReTXParams.us_US_SHINEratio;
               t_ComputeInp_Params.us_INP_min = gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min;
               t_ComputeInp_Params.us_INP_min_REIN = (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min_REIN & 0x1F);
               t_ComputeInp_Params.us_Iat_rein_flag = ((gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min_REIN>>7) & 0x1);
               t_ComputeInp_Params.us_DelayMax = gt_ReTXParams.t_ReTXConfigCMV.us_US_DelayMax;

               t_ComputeInp_Params.s_Nfecp = t_ComputeRates.s_Nfec;
               t_ComputeInp_Params.ul_Lp = t_ComputeRates.ul_Lp;

               t_ComputeInp_Params.us_Qtx = gt_ReTXParams.us_OPMS_UsQtx;
               t_ComputeInp_Params.us_Q = gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q;

               t_ComputeInp_Params.us_V = gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V;
               t_ComputeInp_Params.us_H = gt_ReTXParams.uc_US_H;

               //update the actual US INP values for LP1 only
               CalculateActualINP((int16 *)(void *)&gt_ReTXStats.us_US_InpActShine, (int16 *)(void *)&gt_ReTXStats.us_US_InpActRein, t_ComputeInp_Params);
               //XDSLRTFW-1522 (End)

               gt_ReTXStats.us_US_InpActShine= (10 * gt_ReTXStats.us_US_InpActShine); // s_INP_act_SHINE is in 0.1 symbols
               gt_ReTXStats.us_US_InpActRein = (10 * gt_ReTXStats.us_US_InpActRein); // s_INP_act_REIN is in 0.1 symbols
            }
            //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)

            //------------------------------------------------------------------------
            // The computation of TotalRate, OHRate & NetRate is based on the one
            // received in O-PMS SOC message.
            //
            // Note: It's confirmed from Matlab that the accuracy is within +/- 1 kbps.
            //------------------------------------------------------------------------
            if (gft_computeDataRateFS6)
            {
               ComputeRatesFS6(s_lp, pt_Config, &l_NetDataRate);
               // RATE CMV reports NetRate in unit of 4 kbps, so right shift by 2 (convert from kbps to 4kbps) + 4 (convert from Q28.4 to Q32.0)
               l_NetDataRate >>= 6;
            }
            else
            {
               //XDSLRTFW-1434(START)
               if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
               {
                  Calc_Rates_UsReTx(&t_ComputeRates, gt_FormFramingParamsInputs_v2.s_fs, &l_OHRate, &l_NetDataRate);
               }//XDSLRTFW-1434(END)
               else
               {
                  ComputeRates(t_ComputeRates.ul_Lp, t_ComputeRates.s_Nfec, t_ComputeRates.s_Rp,
                               t_ComputeRates.us_Gp, t_ComputeRates.us_Mp, t_ComputeRates.us_Tp,
                               gt_FormFramingParamsInputs_v2.s_fs, &l_OHRate, &l_NetDataRate);
               }

               // convert NDR from Q28.4 to Q32.0, i.e. kbit/s
               //XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop (Start_End)
               l_NetDataRate += (1 << 3);
               //XDSLRTFW-572 : NewFeature_ALL_ALL_ALL_RateIn1Kbps(Start_End)
               l_NetDataRate >>= 4;
            }

            //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
            t_USRateInfo.t_CurRate[s_lp].us_RateLSW = l_NetDataRate & 0xFFFF;
            t_USRateInfo.t_CurRate[s_lp].us_RateMSW = l_NetDataRate >> 16;

            //XDSLRTFW-3489: Reported US datarate 0 in the beginning of showtime (Start_End)
            // We do not have the ETR available at this point. The ETR will be transmitted in showtime
            // via the OHC from the CO to the CPE.
            // To communicate at least a good estimation of the ETR to the API in the beginning of showtime
            // until the particular OHC message has been received we initialize the US ETR to US NDR.
            if(gus_DSL_FW_InternalControl & DSL_REPORT_US_NDR_AS_ETR_AT_INIT)
            {
               gt_ReTXStats.ul_UsReTX_ReceiverETR = l_NetDataRate;
            }

            //XDSLRTFW-1478(START)
            // The aggregate data rate in kbit/s: ADRp = NDRp + OHRatep
            // Note: l_OHRate is in 28.4 format ==> convert back to Q32.0!!
            t_USRateInfo.ul_ADR += (l_NetDataRate + (l_OHRate >> 4));
            // Update the OH Rate in 28.4 format(kbps)
            t_USRateInfo.ul_OHRate[s_lp] = l_OHRate;
            //XDSLRTFW-1478(END)


            //-----------------------------------------------
            // Compute delay (in milliseconds)
            //-----------------------------------------------
            ComputeDelay(pt_Config, s_lp, &us_delay);

            //XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms (Start_End)
            //Report Delay in 0.01 milli seconds granularity to the near-end
            t_USRateInfo.us_IntlDelay[s_lp] = (us_delay*100);

            // Interleaver depth
            t_USRateInfo.s_D[s_lp] = pt_Config->s_Dp[s_lp];

            // TCM and parity bytes info
            gt_LineStatusUS.us_LineStatus &= (uint16)0xFFFE;
            gt_LineStatusUS.us_LineStatus |= gft_TxTcmFlag;
            t_USRateInfo.s_TcmParityInfo[s_lp] = (t_ComputeRates.s_Rp & 0xFF)| (gft_TxTcmFlag << 8);


            // Report INP value in 0.1 DMT symbol granularity format
            //XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec (Start)
            //Note: VDSL2 Bitloading algo doesn't consider the "Erasure decoding" capability
            //So, as per R6 DSL-API request, reporting same INP value through "RATE 0 [14:15]" & "RATE 0 [16:17]".
            // s_INPp Q8.8 format
            {
               int32 l_InpReport;

               l_InpReport = ((((uint32)pt_Config->s_INPp[s_lp]) * 10) >> 8);
               t_USRateInfo.s_ActInpNoErasure[s_lp] = l_InpReport; //0.1 DMT symbol granularity
               t_USRateInfo.s_ActInpErasure[s_lp]   = l_InpReport; //0.1 DMT symbol granularity
            }
            //XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec (End)
         }
      }
   }

   // set the 9th bit of Rate 0 12 to indicate whether US virtual noise is enabled
   if(gft_USVirtualNoiseStatus)
   {
      gt_LineStatusUS.us_LineStatus |= (uint16)0x100;
      t_USRateInfo.s_TcmParityInfo[LP0] |= (uint16)0x200;
      t_USRateInfo.s_TcmParityInfo[LP1] |= (uint16)0x200;
   }
   else
   {
      gt_LineStatusUS.us_LineStatus &= (uint16)0xfeff;
   }

#ifdef DEBUG_TRACES
   // XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   guc_ShowtimeEnter=1;
#endif
}

//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
/*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*       void CalculateActualINP(int16* ps_INP_Shine, int16* ps_INP_Rein, ReTx_ComputeInp_Params_t t_ComputeInp_Params)
*
*   Abstract:
*      Helper function to compute actual INP based on selected framing parameters
*
*  Notes: Initially the first and second parameter were of type int16 but to suppress/remove warnings
 *        they have been changed to type void. And suitable changes are made in the function and wherever
 *        it is being employed.
*
*------------------------------------------------------------------------------------------------*/
//XDSLRTFW-1522 (Start)
void CalculateActualINP(int16* ps_INP_Shine, int16* ps_INP_Rein, ReTx_ComputeInp_Params_t t_ComputeInp_Params)
{
   //RS codewords/DTU not equal to zero
   if (t_ComputeInp_Params.us_Q != 0)
   {
      // Calculate the actual INP Shine
      CalculateActualSHINE_INP(ps_INP_Shine, t_ComputeInp_Params);

      // Calculate the actual INP Shine
      CalculateActualREIN_INP(ps_INP_Rein, t_ComputeInp_Params);
   }
   else
   {
      *ps_INP_Shine = 0;
      *ps_INP_Rein = 0;
   }
}
//XDSLRTFW-1522 (End)


/*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*       void CalculateActualSHINE_INP(int16* ps_INP_Shine, ReTx_ComputeInp_Params_t t_ComputeInp_Params)
*
*   Abstract:
*      Helper function to compute actual SHINE INP based on selected framing parameters
*
*   Note:
*     Formula used :
*
*
*     In Rein only or Shine only situation :
*
*     INP =  (Nret*Qtx-1)*S*Q if Qtx >=roundtripDTU
*              0 otherwise
*       where Nret=(delay_max*fdmt/Qtx*Q*S)
*
*     In mixed shine rein environment :
*
*      INP = (((Nret-1)*Qtx-1)*S*Q) => Nret to be decided based on the follwing formula such that Nret>=2 and k>=1
*      a) ((Nret * Qtx)+Ceil[INP_min_rein/S*Q]+1) <= floor[k*fdmt/frein]-ceil[k*fsync/frein] => gives the condition for Kmin
*      b)  (Nret*Qtx) >= ceil[((k-1)*fdmt/frein)+INP_min_rein]-(floor[((k-1)/frein)+INP_min_rein/fdmt]*fsync)*(1/(S*Q))+1  => gives the condition for Kmax
*
*      Also fsync=fdmt/257
*
*------------------------------------------------------------------------------------------------*/
//XDSLRTFW-1522 (Start)
void CalculateActualSHINE_INP(int16* ps_INP_Shine, ReTx_ComputeInp_Params_t t_ComputeInp_Params)
{
   int16 MinDataSymbolsRein, MaxDataSymbolsRein, MinDataSymbolsDelaymax;
   int16 NRET, DtuSize, fdmt;
   int16 n, A, k_min, k_max, ia_rein_flag;
   int16 Trein, Nrtx, s_ActualINPShine, INP_min_rein,INP_min;
   int16 s_Qtx = (int16)t_ComputeInp_Params.us_Qtx;
   int16 cc=0;

   s_ActualINPShine = 0;

   ia_rein_flag = (int16)t_ComputeInp_Params.us_Iat_rein_flag;


   INP_min_rein = (int16)t_ComputeInp_Params.us_INP_min_REIN;
   INP_min = (int16)t_ComputeInp_Params.us_INP_min;

   // In case of 30a profile
   if (gs_frame_rate_is_8khz) //XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
   {
      fdmt = 8;
   }
   else
   {
      fdmt = 4;
   }

//XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation(START)


   if ((INP_min == 0) && (INP_min_rein == 0))
   {
      cc=0;   // config with no SHINE, no REIN
   }

   else if ((INP_min > 0) && (INP_min_rein == 0))
   {
      cc=1;   // config with SHINE only
   }

   else if ((INP_min > 0) && (INP_min_rein>0))
   {
      cc=2;   // config with SHINE and REIN
   }

   else if ((INP_min==0) && (INP_min_rein>0))
   {
      cc=3;   // config with REIN only
   }


   //calculate only if not rein only case
   if (cc!=3)
   {

      // REIN noise has a repetition rate of twice the AC power frequency (100 or 120 Hz).
      if (ia_rein_flag == 0)
      {
         // 100 Hz frequeny i.e (1/100)*1000 expressed in Q8.8 format
         // Expressed in Q8.8 format
         Trein = (10 << 8);   // REIN period in ms
      }
      else
      {
         // 120 Hz frequency i.e (1/120)*1000 expressed in Q8.8 format
         // Expressed in Q8.8 format
         Trein = (50 << 7) / 3;   // REIN period in ms
      }



      // Dtu size in symbols (expressed in Q8.8 format) or number of symbols/DTU
      DtuSize = ((t_ComputeInp_Params.us_Q * t_ComputeInp_Params.s_Nfecp) << 11)/t_ComputeInp_Params.ul_Lp;

      MinDataSymbolsDelaymax = ((t_ComputeInp_Params.us_DelayMax * fdmt) << 8) / 257; // min. number of DMT data symbols within delay_max

      NRET = (MinDataSymbolsDelaymax << 8)/ (s_Qtx * DtuSize);  // max number of retransmissions


      //////////////////////////////
      // No INP_Rein configured
      //////////////////////////////
      if (INP_min_rein  == 0)
      {
         // INP_Shine = DtuSize * (Nret* Qtx - 1)
         if ((NRET * s_Qtx) >= 1)
         {
            // Avoid negative INP value in computation
            s_ActualINPShine = (DtuSize * ((NRET * s_Qtx) - 1)) >> 8;
         }

      }

      /////////////////////////
      // INP_Rein configured
      /////////////////////////
      else if (INP_min_rein > 0)
      {

         // MinDataSymbolsRein = floor(Trein/Tdmt) - ceil(Trein/Tsync)
         //                    = floor(Trein * fdmt) - ceil((Trein * fdmt)/257)
         MinDataSymbolsRein = Trein * fdmt - ceil16(Trein * fdmt, 257);      // min. integer number of DMT data symbols witin a REIN period

         // MaxDataSymbolsRein = (Trein/Tdmt) - floor(Trein/Tsync)
         //                    = (Trein * fdmt) - floor((Trein * fdmt)/257)
         //                    = ((Trein * fdmt)*256)/257
         MaxDataSymbolsRein = ceil32((Trein * fdmt) << 8, 257);            // average fractional number of DMT data symbols in REIN period

         // Nrtx = ceil(INP_min_rein/DtuSize) + 1
         Nrtx = ceil16((INP_min_rein << 8), DtuSize) + 1; // number of corrupt DTUs due to single REIN pulse

         // Find the max number of retransmissions possible such that it also satisfies the
         // INP_rein constraints for the selected framing parameters
         for (n = NRET; n >= 2; n--)
         {
            // Nret*Qtx + Nrtx <= k * Trein
            A = ((n * s_Qtx) + Nrtx) * DtuSize;

            // Use the smaller value for Trein in denominator for a conservative Kmin
            k_min = ceil16(A, MinDataSymbolsRein);

            // (k-1)Trein <= (Nret*Qtx - 1)*DtuSize - INP_min_rein
            A = ((n * s_Qtx) - 1) * DtuSize - (INP_min_rein << 8);

            // Use the larger value for Trein in denominator for a conservative Kmax
            k_max = (A / MaxDataSymbolsRein) + 1;



            if (k_min <= k_max)
            {
               // For mixed REIN and SHINE noise
               // (Nret - 1)* Qtx >= ceil(INP_min/DTuSize) + 1
               // Hence we have
               // INP = DtuSize *((Nret - 1)*Qtx - 1)
               s_ActualINPShine = (DtuSize * ((n-1)* s_Qtx - 1)) >> 8;


               // Since we start with the max number of retransmissions in the for loop above,
               // we are sure to have the max INP value at the first instance of a valid solution found
               // Hence, break out of the loop
               break;
            }

         } // end of n loop

      } // end of if (INP_min_rein > 0)

   }// end of if (cc!=3)
//XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation(END)

   // Update the return value
   *ps_INP_Shine = s_ActualINPShine;
}
//XDSLRTFW-1522 (End)

/*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*       void CalculateActualREIN_INP(int16* ps_INP_Rein)
*
*   Abstract:
*      Helper function to compute actual REIN INP based on selected framing parameters
*
*   Note:
*
*------------------------------------------------------------------------------------------------*/
//XDSLRTFW-1522 (Start)
void CalculateActualREIN_INP(int16* ps_INP_Rein, ReTx_ComputeInp_Params_t t_ComputeInp_Params)
{
   int16 MinDataSymbolsRein, MaxDataSymbolsRein, MinDataSymbolsDelaymax;
   int16 NRET, NRETmin, NRETmax, DtuSize;
   int16 n, A, k_min, k_max, kfound;
   int16 Trein, Nrtx, s_temp, fdmt;
   int16 s_ActualINP_Rein, s_max_INP, INP_min, ia_rein_flag, INP_min_rein;
   int16 INPrein;
   int16 s_fs, Qtxmax;
   int16 s_Qtx = (int16)t_ComputeInp_Params.us_Qtx;
   int16 cc=0;

   uint16 TRELLISratio, REINratio, RTXOH;

   uint32 ul_temp1;
   int32 NDR, ETR, ETR_new;
   VDSL2Config_t* pt_Config;

   pt_Config = &gt_tx_config_v2;
   ia_rein_flag = (int16)t_ComputeInp_Params.us_Iat_rein_flag;

   // Expressed in Q1.15 format
   TRELLISratio = 3;

   //minimum US INP of PTM Bearer channel 0
   INP_min = (int16)t_ComputeInp_Params.us_INP_min;
   INP_min_rein = (int16)t_ComputeInp_Params.us_INP_min_REIN;

   s_ActualINP_Rein = 0;

//XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation(START)


   if ((INP_min == 0) && (INP_min_rein == 0))
   {
      cc=0;   // config with no SHINE, no REIN
   }

   else if ((INP_min > 0) && (INP_min_rein == 0))
   {
      cc=1;   // config with SHINE only
   }

   else if ((INP_min > 0) && (INP_min_rein>0))
   {
      cc=2;   // config with SHINE and REIN
   }

   else if ((INP_min==0) && (INP_min_rein>0))
   {
      cc=3;   // config with REIN only
   }

   // In case of 30a profile
   if (gs_frame_rate_is_8khz) //XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
   {
      fdmt = 8;
   }
   else
   {
      fdmt = 4;
   }


   //enter only if some INP is configured and is not shine only case
   if(cc!=1)
   {
      //In case of 30a profile (fdmt = 8);
      //else
      fdmt = 4;

      // Convert to Q10.6 format
      // Note: Normally gt_FormFramingParamsInputs_v2.s_fs should be used , which
      //       considers the "m"-value, i.e. CE.
      // !!!In this formula the fix value m=5 is used!!
      s_fs = (fdmt * 256 * 64)/257;

      // REIN noise has a repetition rate of twice the AC power frequency (100 or 120 Hz).
      if (ia_rein_flag == 0)
      {
         // 50 Hz frequeny
         // Expressed in Q8.8 format
         Trein = (20 << 7);   // REIN period in ms
      }
      else
      {
         // 60 Hz frequency
         // Expressed in Q8.8 format
         Trein = (50 << 7) / 3;   // REIN period in ms
      }

      // MinDataSymbolsRein = floor(Trein/Tdmt) - ceil(Trein/Tsync)
      //                    = floor(Trein * fdmt) - ceil((Trein * fdmt)/257)
      MinDataSymbolsRein = Trein * fdmt - ceil16(Trein * fdmt, 257);      // min. integer number of DMT data symbols witin a REIN period

      // MaxDataSymbolsRein = (Trein/Tdmt) - floor(Trein/Tsync)
      //                    = (Trein * fdmt) - floor((Trein * fdmt)/257)
      //                    = ((Trein * fdmt)*256)/257
      MaxDataSymbolsRein = ceil32((Trein * fdmt) << 8, 257);            // average fractional number of DMT data symbols in REIN period

      // Dtu size in symbols (expressed in Q8.8 format)
      DtuSize = ((t_ComputeInp_Params.us_Q * t_ComputeInp_Params.s_Nfecp) << 11)/ t_ComputeInp_Params.ul_Lp;

      MinDataSymbolsDelaymax = ((t_ComputeInp_Params.us_DelayMax * fdmt) << 8) / 257; // min. number of DMT data symbols within delay_max

      NRET = (MinDataSymbolsDelaymax << 8)/ (s_Qtx * DtuSize);  // max number of retransmissions

      // Compute NDR in Q28.4 format
      // NDR = Lp*fs*Hp/Np*(1-(2+Vp)/(Qp*Hp))
      ul_temp1 = (s_fs * t_ComputeInp_Params.ul_Lp * t_ComputeInp_Params.us_H) / (t_ComputeInp_Params.s_Nfecp << 2);
      NDR = ul_temp1 - (ul_temp1*(2+ t_ComputeInp_Params.us_V))/(t_ComputeInp_Params.us_Q * t_ComputeInp_Params.us_H);

      // REINratio = (INP_min_rein+DtuSize)/floor(Trein/Tdmt);
      // Express in Q1.15 format
      s_temp = (INP_min_rein << 8) + DtuSize;
      REINratio =  (s_temp << 15) / (Trein * fdmt);

      // Compute the Rtx overhead in Q1.15 format
      RTXOH = (t_ComputeInp_Params.us_SHINE_ratio << 15)/1000 + REINratio + TRELLISratio;

      // Expressed in Q28.4 format
      s_temp = ((1 << 15) - RTXOH) >> 8;
      ETR = (NDR * s_temp) >> 7;

      // The expected ETR value with the configured INP rein noise
      // gl_expected_ETR = (ETR >> 4);

      /////////////////////////////////////////////////////
      // Compute actual INP REIN if no SHINE configured
      /////////////////////////////////////////////////////

      //if (INP_min == 0)
      if(cc==3)
      {
         INPrein = 0;

         // Initialise to the max INP value possible
         s_max_INP = (DtuSize * ((NRET * s_Qtx) - 1)) >> 8;

         // Loop through different INPrein values to the point
         // where the constraints can still be met
         while (INPrein < s_max_INP)
         {
            // Number of corrupt DTUs due to single REIN pulse
            Nrtx = ceil16((INPrein << 8), DtuSize) + 1;

            // Qtx should be smaller than Rein impulse inter-arrival time
            // to allow successful retransmissions
            Qtxmax = (MinDataSymbolsRein/DtuSize) - Nrtx;

            // REINratio = (INP_min_rein+DtuSize)/floor(Trein/Tdmt);
            // Express in Q1.15 format
            s_temp = (INPrein << 8) + DtuSize;
            REINratio =  (s_temp << 15) / (Trein * fdmt);

            // Compute the Rtx overhead in Q1.15 format
            RTXOH = (t_ComputeInp_Params.us_SHINE_ratio << 15)/1000 + REINratio + TRELLISratio;

            // Expressed in Q28.4 format
            s_temp = ((1 << 15) - RTXOH) >> 8;
            ETR_new = (NDR * s_temp) >> 7;

            // Break out of the loop when the INP can't be met anymore
            //if ((ETR_new < (gt_RTX_config.us_ETR_min << 3)) || (INPrein > s_max_INP) || (s_Qtx > Qtxmax))
            if ((ETR_new < ETR) || (INPrein > s_max_INP) || (s_Qtx > Qtxmax))
            {
               break;
            }
            else
            {
               INPrein = INPrein+1;
            }

         } // end of while loop

         // Account for the increment before the break
         if (INPrein >= 1)
         {
            s_ActualINP_Rein = INPrein -1;
         }

      } // end of INP_min==0

      ////////////////////////////////////////////////
      // Compute actual INP REIN if SHINE configured
      ////////////////////////////////////////////////

      if (cc == 2)
      {
         // Nret * Qtx >= ((INP_min/DtuSize) + 1)
         s_temp = ceil16((INP_min << 8), DtuSize) + 1;
         NRETmin = ceil16(s_temp, s_Qtx) + 1;

         NRETmax = NRET;
         INPrein = 0;

         if (NRETmin <= NRETmax)
         {
            // Loop through different INPrein values
            while (1)
            {
               Nrtx = ceil16((INPrein << 8), DtuSize) + 1;;                         // Number of corrupt DTUs due to single REIN pulse

               // Qtx should be smaller than Rein impulse inter-arrival time
               // to allow successful retransmissions
               Qtxmax = (MinDataSymbolsRein/DtuSize) - Nrtx;

               if (s_Qtx > Qtxmax)
               {
                  break;
               }

               kfound = 0;

               for (n = NRETmin; n <= NRETmax; n++)
               {
                  // Nret*Qtx + Nrtx <= k * Trein
                  A = ((n * s_Qtx) + Nrtx) * DtuSize;

                  // Use the smaller value for Trein in denominator for a conservative Kmin
                  k_min = ceil16(A, MinDataSymbolsRein);

                  // (k-1)Trein <= (Nret*Qtx - 1)*DtuSize - INP_min_rein
                  A = ((n * s_Qtx) - 1) * DtuSize - (INPrein << 8);

                  // Use the larger value for Trein in denominator for a conservative Kmax
                  k_max = (A / MaxDataSymbolsRein) + 1;

                  if (k_min <= k_max)
                  {
                     // Atleast one valid solution found,
                     // no need to search further
                     kfound = 1;
                     break;
                  }

               } // end of n loop

               if (kfound == 0)
               {
                  break;
               }

               // REINratio = (INP_min_rein+DtuSize)/floor(Trein/Tdmt);
               s_temp = (INPrein << 8) + DtuSize;

               // Express in Q1.15 format
               REINratio =  (s_temp << 15) / (Trein * fdmt);

               // Compute the Rtx overhead in Q1.15 format
               RTXOH = (t_ComputeInp_Params.us_SHINE_ratio << 15)/1000 + REINratio + TRELLISratio;

               // Expressed in Q28.4 format
               s_temp = ((1 << 15) - RTXOH) >> 8;
               ETR_new = (NDR * s_temp) >> 7;

               //if (ETR < (gt_RTX_config.us_ETR_min << 3))
               if (ETR_new < ETR)
               {
                  break;
               }
               else
               {
                  INPrein = INPrein + 1;
               }

            } // end of while loop

            // Account for the increment before the break
            if (INPrein >= 1)
            {
               s_ActualINP_Rein = INPrein -1;
            }

         } // end of if NRETmin<=NRETmax


      } // end of INP_min>0

   }// end of if(cc!=1)

   //XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation(END)

   // Update the return value
   *ps_INP_Rein = s_ActualINP_Rein;

}
//XDSLRTFW-1522 (Start)
//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)


//XDSLRTFW-1434(START)
/*
 *-------------------------------------------------------------------------------
 *
 * Prototype:
 * Calc_Rates_UsReTx(VDSL2ComputeRates_t *pt_ComputeRates, int16 s_fs, int32 *pl_OHRate, int32 *pl_NetDataRate )
 *
 *   This function Calculates data rates of Upstream in US ReTx mode
 *
 *   Input Arguments:
 *   int16 s_Path,int16 s_Nfec,int16 s_Rp,uint16 ul_Lp,uint16 us_Gp,uint16 us_Mp,uint16 us_Tp
 *   int16 s_fs (Q6.10)
 *
 *   Returns:
 *
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */
void Calc_Rates_UsReTx(VDSL2ComputeRates_t *pt_ComputeRates, int16 s_fs, int32 *pl_OHRate, int32 *pl_NetDataRate)
{
   uint32 ul_LineRate;

   // Gp   = [1 to 32]
   // Mp   = [1,2,4,8 and 16]
   // Tp   = [1 to 64]
   // Fs   = Fdmt * 256/257
   // Nfec = [1 to 255]
   // Lp   = [8 to 15*Nsc-1], NSC = 3000 or 7100 (35b)
   // Note: T = k*M
   //       Fs Q10.6 format
   //          = 255.0038910505836575875486381323  (float)
   //          = 255                               (Q10.6)
   //          = 3.9844357976653696498054474708171 (float)
   //          = 3                                 (16.0) huge error

   // LineRate = ul_Lp*s_fs;
   MULS32x16(ul_LineRate, pt_ComputeRates->ul_Lp, s_fs);
   ul_LineRate += 1<<(FRAME_RATE_SHIFT_CNT-1);
   ul_LineRate >>= FRAME_RATE_SHIFT_CNT;

   if((pt_ComputeRates->s_Path) == LP0)
   {
      int16 s_k;
      // The FEC for the ROC shall only use R=16 and NFEC values from 32 to 66 with q = 1
      // The interleaving for the ROC shall only use D values up to 20.
      // For single latency with ROC, the ROC (in latency path 0) shall use OH frame Type 1 and
      // latency path 1 shall use OH frame Type 2.
      // L0 shall be an integer number of bytes consisting of overhead data only.
      // L0 = [8,16 to 128]
      // Nfec0 = [32 to 66]

      // NDR zero for LP0 in US ReTx
      *pl_NetDataRate=0;

      // OHRate = 8*fs*Gp*Mp / (Sp*Tp)            , with Sp = (8*Nfecp)/Lp  and fs in Q6.10
      //        = fs*(Gp*Mp*Lp)/(Nfecp*Tp)
      //        = ((fs*Lp)*Gp) / ((Tp/Mp)*Nfecp)) , with kp = Tp/Mp
      //        = ((fs*Lp)*Gp) / (kp*Nfecp)
      //        = ((fs*Lp)*Gp)*2^4 / (kp*Nfecp)   , Q28.4 format
      //
      // Note: kp = Tp/Mp is always an integer
      //       LineRate = ul_Lp*s_fs;
      // Note: OHRate is in Q28.4 format
      //
      s_k = floor16((int16)pt_ComputeRates->us_Tp, (int16)pt_ComputeRates->us_Mp);
      *pl_OHRate= ((ul_LineRate * pt_ComputeRates->us_Gp) << 4) /
                   (pt_ComputeRates->s_Nfec * s_k);
   }
   else
   {
      // LP1
      int16 s_Hp;
      uint32 ul_temp1;

      // NDRp = L1*fs*(H/Nfec)*(1-DTUframingOH), with H = Nfec1-R1
      // NDRp -> Q28.4 format
      s_Hp = (pt_ComputeRates->s_Nfec - pt_ComputeRates->s_Rp);
      ul_temp1 = (uint32)((ul_LineRate * s_Hp) << 4) / (pt_ComputeRates->s_Nfec);
      *pl_NetDataRate  = ul_temp1 - (ul_temp1*(2 + gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V))/(gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q * s_Hp);

      //OH rate is zero for LP1
      *pl_OHRate=0;

      // RRC part of ADR/TDR is taken care here!
      // Note: The RRC in upstream is only available when DS ReTx is enabled.
      //       But this is per standard the case for upstream ReTx, i.e. DS ReTx is always enabled,
      //       if US ReTx in use.

      // The aggregate data rate in kbit/s: ADR = SUM(ADRp) + 12*fs
      // Note: fs is in Q10.6 format
      //       Rounding is used!
      t_USRateInfo.ul_ADR += ((((uint32)DS_RRC_BITS * s_fs) + (1<<(FRAME_RATE_SHIFT_CNT-1+1))) >> (FRAME_RATE_SHIFT_CNT+1));
      // The total data rate in kbit/s: TDR = SUM(TDRp) + 24*fs, with TDRp = Lp * fs
      t_USRateInfo.ul_TDR = ((((uint32)(gt_tx_config_v2.ul_Lp[LP0] + gt_tx_config_v2.ul_Lp[LP1] +
                                        DS_RRC_BITS)*s_fs) + (1<<(FRAME_RATE_SHIFT_CNT-1))) >> FRAME_RATE_SHIFT_CNT);
   }
}
//XDSLRTFW-1434(END)

