/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Lantiq GmBH
*   Proprietary and Confidential.
*
*
*
*******************************************************************************
*
*   filename: ShowtimeERBHandler.c
*
*   This file contains foreground (FG) functions for Vectoring ERB formation.
*
*-------------------------------------------------------------------------------
*/

/*
*-------------------------------------------------------------------------------
*
*  ShowtimeERBHandler.c
*   History :
*
*  28/05/2013 Varun - modified code so as avoid conflict between DMA of L2 back Channel and DMA of Debug Buffer
*             Search for "XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer"
*  11/08/2014 Fuss: FW prepares and sends ERB to SW layer even there is no TC sync
*             Grep for XDSLRTFW-1955
*
*
*  20/10/2014 Abu - Freed up 3044 bytes of data memory from Vectoring code
*             Upto 5.8.0.7.1.7 FWs used 8192 bytes of memory for storing constellation points of sync symbol
*             at vectoring mode and then used 3048 bytes of memory to convert this constellation points to
*             DS error vector according to G993.5 standard.
*
*             Now 3048 bytes of memory for DS error vector is removed from the code and reused 8192 constellation
*             points memory.
*
*             Risk of this approach is, constellation points data will be lost during the DS error vector formation.
*             In case of debugging in DS error vector computation debugging we will not have any input data.
*             Grep for XDSLRTFW-2049 or pointer variable gpuca_StErbBuffer
*  06/03/2015 Fuss - Every Nth ERB is not being transmitted
*             Grep for XDSLRTFW-2250
*  07/09/2017: Vinay: XDSLRTFW-3454: ERB IOP with BRCM based (VCE+DSLAM) ADTRAN systems
*                     We were checking for the XDMA to be completed after 5 symbols of triggering an DMA. And this was leading
*                     to double setting of owner bit of the penultimate segment, if the number of symbols taken to
*                     contruct the last segment being greater than 5. This hard coding has been removed and we do
*                     not see any double setting of owner bit. Incase the owner bit has been set twice, we would
*                     be sending older data to the CO and CO would discard the ERB frames and we would never see
*                     Vectoring gain in ST.
*             Search Pattern: XDSLRTFW-3454
*-------------------------------------------------------------------------------
*/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "vdsl_state.h"
#include "ShowtimeERBHandler.h"
#include "eoc.h"
#include "cmv.h"
#include "FormRErrorFeedbackMsg_VDSL2.h"
#include "stdlib.h"

int16 VectorCopyErb(int32 *pSrc,uint32 ul_Size);

void InitL2BackChannelHeader(void);

void ShowtimeErbHandler(void)
{
   uint8 uc_CorruptedFrame = 0; // place holder for a global variable
   uint8 uc_S;
   int8 c_B_L, c_B_M;
   uint8 uc_erb_descriptor_index = 0;
   uint8 uc_cntr = 0;
   uint16 us_Temp = 0;
   uint16 us_ErbByteCounter = 0;
   uint16 us_ErbByteCounter1 = 0;
   uint16 us_ByteCounter_DMA = 0;
   signed int k = 0;
   uint16 us_WordLength, us_NewBitPos;
   int16 s_Error_sample_re, s_Error_sample_im;
   int16 s_TempPoint_re;
   uint16 us_ClippedErrorMask;
   int16 i = 0, j=0;
   uint32 *ul_addr_pointer = NULL;
   ERBDescriptor t_ERBDescriptor[MAX_NUM_ERB_SEGMENTS];

   if (TESTArray[TEST_StoreSramControl] & TEST_SAVE_VECTOR_ERB_WRITE_ONETIME) // only for non vectoring mode
   {
      // make sure that L2 back channel test works only one time per CMV write
      TESTArray[TEST_StoreSramControl] &= (~TEST_SAVE_VECTOR_ERB_WRITE_ONETIME);
      gc_FormErbInShowtimeState = FORM_ERB_L2_BACKCHANNEL_HEADER_FOR_TESTING;
      if (TESTArray[TEST_ErbData] > (MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE - 2))
      {
         gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
      }
   }

   switch (gc_FormErbInShowtimeState)
   {
      case CONFIGURE_ERB:

         gft_ERB_Last_Segment = FALSE;
         guc_ping_pong = 0;
         guc_SegmentCode = 0;                      // Segment index (starting with 0 for the 1st segment)
         guc_G9935_CurrentVectorredBand = 0;
         gft_ERB_VBB_Header_Configure  = TRUE;
         gft_ERB_Compute_Data          = TRUE;
         gft_ERB_Main_Header_Configure = TRUE;
         gft_Triggered_DMA             = FALSE;

         guc_owner_bit_set = 0;   // XDSLRTFW-3454 (Start_End)

         // EOC_ERB_TRANSMISSION_STATE
         //    0: ERB are turned off
         //    1: ERB parameters are being calculated:
         //    2: ERBs are on and valid parameters are available

         // Do we need a check here once more?
         // If FG task ShowtimeErbHandler is called directly after Rx-TC function this check is not needed.
         //if (guc_EOC_ERB_TRANSMISSION_STATE == 2)
         {
            uint16 i;

            // Configure ERB parameters:
            for (i = 0; i< MAX_NUM_RX_VEC_BANDS ; i++)
            {
               gsa_RxVecBandLeftChannel[ i] = gt_ShowtimeErbParams.usa_RxVecBandLeftChannel[ i];
               gsa_RxVecBandRightChannel[i] = gt_ShowtimeErbParams.usa_RxVecBandRightChannel[i];
            }
            //  Populate global control parameters to calculate ERB
            guc_G9935_NumBands   = gt_ShowtimeErbParams.us_Nband_ERBConfig ;
            guc_Padding          = gt_ShowtimeErbParams.uc_Padding;
            guc_FBlock           = gt_ShowtimeErbParams.uc_Fblock;

            for (i = 0; i< MAX_NUM_RX_VEC_BANDS; i++)
            {
               gusa_Fsub[i] = gt_ShowtimeErbParams.usa_Fsub[ i];
               gusa_Lw[i] = gt_ShowtimeErbParams.usa_Lw[i];
               // REVIEW_STEFAN: TBD: Why do we ignore Bmin in our FW ???
               //                     e.g. shouldn't FW at least go to failstate if Bmin > 0?
               gusa_Bmin[i] = gt_ShowtimeErbParams.usa_Bmin[ i];
               gusa_Bmax[i] = gt_ShowtimeErbParams.usa_Bmax[ i];
            }
            for (i=0; i<MAX_NUM_ERB_SEGMENTS; i++)
            {
               gsa_Header_Length[i] = gt_ShowtimeErbParams.usa_Header_Length[i];
            }
            guc_NumOfSegments = gt_ShowtimeErbParams.uc_NumOfSegments;
            // REVIEW_STEFAN: When do we need to set this counter???
            gs_RxSuperFrmCnt_ForEOC = gs_RxSuperFrmCnt;
         }
         // continue processing in state FORM_ERB_MAIN_HEADER in the following symbol
         gc_FormErbInShowtimeState = FORM_ERB_MAIN_HEADER;
         break;

      case FORM_ERB_MAIN_HEADER:
         // initialize gus_ErbByteCounter
         // REVIEW_STEFAN: definition of counter gus_ErbByteCounter is missing
         gus_ErbByteCounter = 0;
         gus_NumofSymbols_ERB_Computation++; // XDSLRTFW-3492 (Start_End)
         if (gft_ERB_Main_Header_Configure == TRUE)
         {
            if (guc_ping_pong == 0)
            {
               gpuca_StErbBuffer = (uint8 *)(void *)gsa_StVectoringBuffer;   // XDSLRTFW-2049
            }
            else if (guc_ping_pong == 1)
            {
               gpuca_StErbBuffer = guca_erb_ping_pong_buffer;
            }
            gus_Start_Addr_Reversing = 0;
            gt_DsmStats.ul_ErrVecTransmittedSegments++;

            // ------------------------------------------------------------------
            // Header: Part 1
            // Layer 2 Ethernet encapsulation of the backchannel data
            // ------------------------------------------------------------------
            // L2 data gets be stored in the SRAM with a different 32bit word byte indexing.
            // This is done because the MIPS is accessing the SRAM in the opposite endian format.
            InitL2BackChannelHeader();
            // Header for L2 Back channel ERB data
            //------------------------------------
            // [ 0 -  5]:  VCE MAC Address
            // [ 6 - 11] : VTU-R MAC Address
            // [12 - 13] : Length of segment
            // [14 - 16] : LLC header (0xAA - 0xAA - 0x3)
            // [17 - 19] : ITU-T OUI (0x0 - 0x19 - 0xA7)
            // [20 - 21] : Protocol ID (0x0 - 0x3)
            // [22 - 23] : LINE ID
            // [24 - 25] : Sync Symbol Count (gs_RxSuperFrmCnt_ForEOC)
            // [26]      : guc_SegmentCode + end flag

            // Beginning of ERB data linear byte index.
            // Note: Opposite endian idx would be 28 -> see inside fct. InitL2BackChannelHeader()
            // REVIEW-STEFAN: comment is wrong : shouldn't this be 24?
            gus_ErbByteCounter = 27;

            // PROTOCOL PAYLOAD DATA include:
            //    LINE ID (2 bytes), Sync Symbol Count (2 bytes), Segment Code (1 byte)
            gus_PPD_ByteCounter_For_Segment = 5;         // number of PROTOCOL PAYLOAD DATA in current segment

            // ------------------------------------------------------------------
            // Header: Part 2
            // ERB block start here
            // ------------------------------------------------------------------
            // ERB_ID (byte 27 for L2 back chennel / byte 5 for EOC back channel)
            // ERB_ID is added only once per ERB / not once per segment, so add it only for the 1st segment
            if (guc_SegmentCode == 0)
            {
               // REVIEW-STEFAN:
               // Why is the feature "Indicate Corrupted Frame" not implemented?
               // uc_CorruptedFrame is always "0".

               // Code for conversion "Little Endian to Big Endian format"
               us_ErbByteCounter = (gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3);
               // the remaining 7 bits of the ERB ID are set to 0 and reserved by ITU-T
               gpuca_StErbBuffer[us_ErbByteCounter] = uc_CorruptedFrame << 7; // need proper solution!
               gus_ErbByteCounter++;
               gus_PPD_ByteCounter_For_Segment++;        // number of PROTOCOL PAYLOAD DATA in current segment
               // [27]      : ERB_ID         (if it is the 1st segment)
            }
            gft_ERB_Main_Header_Configure = FALSE;
         }

         // VBB_ID (8bit)
         // Example: in the 1st segment these are always bits [28 - 29]
         // REVIEW_STEFAN: remove this section from here - it belongs to the FORM_ERB_VBB_DATA section
         //                add check in FORM_ERB_VBB_DATA to add VBB_ID if next tone is equal to the leftchannel of a vectored band
         if (gft_ERB_VBB_Header_Configure == TRUE)
         {
            us_ErbByteCounter = ((gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3));
            gpuca_StErbBuffer[us_ErbByteCounter] = (uint8)guc_G9935_CurrentVectorredBand <<5;
            gus_ErbByteCounter++; // increment byte counter
            gus_PPD_ByteCounter_For_Segment++;
            gus_RxToneTobeCranched = gsa_RxVecBandLeftChannel[guc_G9935_CurrentVectorredBand];
            guc_CurrentBitPositionInByte = 0;
            gft_ERB_VBB_Header_Configure = FALSE;
            gft_ERB_Compute_Data = TRUE;
         }
         gc_FormErbInShowtimeState = FORM_ERB_VBB_DATA;
         break;

      case FORM_ERB_VBB_DATA:
         // XDSLRTFW-3454 (Start_End)
         // REVIEW_STEFAN: Is the comment still correct?
         // We were checking for the XDMA done after 5 symbols of triggering an DMA. And this was leading to double setting of owner bit of
         // the penultimate segment, if the number of symbols taken to contruct the last segment being greater than 5. This hard coding has
         // been removed and we do not see any double setting of owner bit.
         // During the double setting of a owner bit, we would be sending older data to the CO and CO would discard the ERB frames and we never see
         // Vectoring gain in ST.
         gus_NumofSymbols_ERB_Computation++; // XDSLRTFW-3492 (Start_End)

         // REVIEW_STEFAN: needs to be analysed
         if ((gft_Triggered_DMA == TRUE) && (PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE))
         {
            uc_erb_descriptor_index = guc_erb_descriptor_index - 1;
            if (gft_ERB_Descriptor_Wraparound == TRUE)
            {
               uc_erb_descriptor_index = guc_erb_descriptor_index_Previous - 1;
               gft_ERB_Descriptor_Wraparound = FALSE;
            }
            // The owner bit in the ERB descriptor needs to be set to PPE
            // so PPE can start consuming data. The length also needs to be updated.
            // XDSLRTFW-3454 (Start_End)
            // We were setting the owner bit first and then configuring the length. This may lead to
            // an issue if the PPE starts picking the data soon as the Owner bit is set.
            // Also we are clearing the flag which was used to set the priority of DMA access.
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 &= (0xFFFF0000);
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 |= gus_ErbByteCounter_Previous;
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 |= SET_OWNER_BIT_ERB_DESCRIPTOR;
            guc_EVB_DebugBuff_flag &= (~0x1);

            // Setting the bit in PDBRAM
            ul_addr_pointer = (uint32 *)((uint32)&__StartOfSramBAR17 + gul_DREG_ERB_Descriptor_Base + 4 + (8*uc_erb_descriptor_index));
            //MemSet32(ul_addr_pointer, gus_ErbByteCounter_Previous, 1);
            *ul_addr_pointer = gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1;
            //gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
            gft_Triggered_DMA = FALSE;
            gft_ERB_Compute_Data = TRUE;
            guc_owner_bit_set++;
         }

         // XDSLRTFW-3454: (Start_End)
         // We are ensuring here that we do not set the owner bit twice. We proceed to the next state of ERB state
         // machine once all the owner bit of the ERB segments has been set.
         if ((gft_ERB_Last_Segment) && (guc_owner_bit_set == (guc_NumOfSegments - 1)))
         {
            gc_FormErbInShowtimeState = FORM_ERB_LAST_SEGMENT;
            break;
         }

         //if (gus_ERB_DMA_STATE == ERB_DMA_STATE_1_CONFIGURE_DMA)        // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
         if (gft_ERB_Configure_DMA == TRUE)
         {
            //gft_ERB_Compute_Data = FALSE;
            //gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
            //gft_PauseOff = 0;
            //Pause(0x1211);
            //break;
            if (guc_ping_pong == 1)
            {
               gpuca_StErbBuffer_CRC = (uint8 *)(void *)gsa_StVectoringBuffer;
            }
            else if (guc_ping_pong == 0)
            {
               gpuca_StErbBuffer_CRC = guca_erb_ping_pong_buffer;
            }

            guc_erb_descriptor_index_Previous = guc_erb_descriptor_index;
            // CRC
            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = (gul_ERB_CRC & 0xFF);
            gus_ErbByteCounter_Previous++;

            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = ((gul_ERB_CRC >> 8) & 0xFF);
            gus_ErbByteCounter_Previous++;

            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = ((gul_ERB_CRC >> 16) & 0xFF);
            gus_ErbByteCounter_Previous++;

            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = ((gul_ERB_CRC >> 24) & 0xFF);
            gus_ErbByteCounter_Previous++;
            gft_Trigger_DMA = TRUE;
            gft_ERB_Configure_DMA = FALSE;
            gus_ERB_DMA_STATE = ERB_DMA_STATE_2_TRIGGER_DMA;                      // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
         }

         //if (gus_ERB_DMA_STATE == ERB_DMA_STATE_2_TRIGGER_DMA)        // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
         if (gft_Trigger_DMA == TRUE)
         {
            // XDSLRTFW-3454: (Start_End)
            // We set a flag here to set the priority of XDMA transfer of the ERB segment over the Debug traces.
            guc_EVB_DebugBuff_flag |= 0x1;

            if (VectorCopyErb((int32 *)(void *)gpuca_StErbBuffer_CRC, gus_ErbByteCounter_Previous) == 1)
            {
               // switch ERB_DMA state
               gft_Triggered_DMA = TRUE;
               gft_Trigger_DMA = FALSE;
               gus_ERB_DMA_STATE = ERB_DMA_STATE_3_TRIGGERED_DMA;                      // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
            }
         }

         if (gft_ERB_Compute_Data == TRUE)
         {
            // XDSLRTFW-3656 : Mips issue during ERB processing
            // max number of error vectors per symbol was originally 51
            // it is now mapped to a global variable
            for (k = 0; k < gus_NumberOfErrorVectorsPerSymbol; k++)
            {
               //gt_FailStateInfo.l_RxSymbolCount_AtFail = k;
               // If next tone falls out of the current vectoring band
               // and
               // it was the last vectoring band
               if ((gus_RxToneTobeCranched > gsa_RxVecBandRightChannel[guc_G9935_CurrentVectorredBand]) &&
                   (guc_G9935_CurrentVectorredBand >= (guc_G9935_NumBands-1)))
               {
                  // L2 Back channel
                  // REVIEW_STEFAN: TBD: Why do we check here the PDB length of 46?
                  // code does not work for gus_PPD_ByteCounter_For_Segment == 46
                  // code does not work for empty segment
                  // Why is here the byte counter gus_ErbByteCounter not increasing?
                  // - we need gus_ErbByteCounter for CRC calculation - does this work ???
                  // gus_PPD_ByteCounter_For_Segment: number of PROTOCOL PAYLOAD DATA in current segment
                  if (gus_PPD_ByteCounter_For_Segment < 46)
                  {
                     while (gus_PPD_ByteCounter_For_Segment <= 46)
                     {
                        gpuca_StErbBuffer[us_ErbByteCounter++] = 0;
                        gus_PPD_ByteCounter_For_Segment++;
                     }
                  }
                  // PPE engin transmit the previous ERB data via L2 channel or not.
                  gft_ERB_Last_Segment = TRUE;
                  gft_ERB_Segment_Done = TRUE;
                  gft_ERB_Compute_Data = FALSE;
                  break;
               }

               // If next tone falls out of the current vectoring band
               // and
               // one more vectoring band follows
               if ((gus_RxToneTobeCranched > gsa_RxVecBandRightChannel[guc_G9935_CurrentVectorredBand]) &&
                   (guc_G9935_CurrentVectorredBand < (guc_G9935_NumBands-1)))
               {
                  guc_G9935_CurrentVectorredBand++;

                  // REVIEW_STEFAN: the guc_CurrentBitPositionInByte is not reset back to 0 - This sounds like a bug
                  if(guc_CurrentBitPositionInByte > 0)
                  {
                     gus_ErbByteCounter++;   // Padding
                     gus_PPD_ByteCounter_For_Segment++;         // number of PROTOCOL PAYLOAD DATA in current segment
                     guc_CurrentBitPositionInByte = 0;
                  }
                  // ERB trasmission via L2 Back channel
                  // Code for conversion "Little Endian to Big Endian format"
                  us_ErbByteCounter = (gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3);
                  // VBB_ID (8bit)
                  // 3 MSB shall include the number of vectored bands
                  // 5 MSB shall be set to '0' and be reserved for ITU-T
                  gpuca_StErbBuffer[us_ErbByteCounter] = (uint8)guc_G9935_CurrentVectorredBand <<5;

                  gus_ErbByteCounter++;                                    // increment byte counter
                  gus_PPD_ByteCounter_For_Segment++;         // number of PROTOCOL PAYLOAD DATA in current segment
                  gus_RxToneTobeCranched = gsa_RxVecBandLeftChannel[guc_G9935_CurrentVectorredBand];
               }


               //---------------------------------------------------------------------------
               //          Step x:  Calculate Error Vector
               //---------------------------------------------------------------------------
               // Input:   Error Vector Configuration:      gusa_Lw
               //                                           gusa_Bmax
               //          Error Vector Read from HW:       gsa_StVectoringBuffer
               //---------------------------------------------------------------------------
               // Output:  calculated Error Vector:         s_Error_sample_re / s_Error_sample_im
               //---------------------------------------------------------------------------
               // find B_M for error sample
               // REVIEW_STEFAN: the name us_Wordlength is not correct
               // Lw = Maximum number of bits for reporting of a clipped error sample component.
               us_WordLength = gusa_Lw[guc_G9935_CurrentVectorredBand];
               {
                  uint16 us_RxToneTobeCranched_HW;
                  us_RxToneTobeCranched_HW = gus_RxToneTobeCranched >> gs_IR_NPR_DECIM;

                  s_Error_sample_re  = gsa_StVectoringBuffer[us_RxToneTobeCranched_HW*2];
                  s_Error_sample_im  = gsa_StVectoringBuffer[us_RxToneTobeCranched_HW*2+1];
               }

               //if ( gs_RxState == R_O_SHOWTIME_RX) // showtime code
               {
                  s_Error_sample_re = s_Error_sample_re^(0x0800);
                  s_Error_sample_re = s_Error_sample_re<<4;
                  s_Error_sample_re = s_Error_sample_re>>4;

                  s_Error_sample_im = s_Error_sample_im^(0x0800);
                  s_Error_sample_im = s_Error_sample_im<<4;
                  s_Error_sample_im = s_Error_sample_im>>4;
               }

               // Clip Error Sample to B_max
               if(s_Error_sample_re > ((1<<gusa_Bmax[guc_G9935_CurrentVectorredBand])-1))
               {
                  s_Error_sample_re = ((1<<gusa_Bmax[guc_G9935_CurrentVectorredBand])-1);
               }
               else if(s_Error_sample_re <  -(1<<gusa_Bmax[guc_G9935_CurrentVectorredBand]))
               {
                  s_Error_sample_re = -(1<<gusa_Bmax[guc_G9935_CurrentVectorredBand]);
               }

               if(s_Error_sample_im > ((1<<gusa_Bmax[guc_G9935_CurrentVectorredBand])-1))
               {
                  s_Error_sample_im = ((1<<gusa_Bmax[guc_G9935_CurrentVectorredBand])-1);
               }
               else if(s_Error_sample_im <  -(1<<gusa_Bmax[guc_G9935_CurrentVectorredBand]))
               {
                  s_Error_sample_im = -(1<<gusa_Bmax[guc_G9935_CurrentVectorredBand]);
               }

               // package B_M and error sample
               // This operation is for finding the most significant bit.
               {
                  /*
                  s_TempPoint_re = s_Error_sample_re;
                  if (s_TempPoint_re < 0)
                  {
                     s_TempPoint_re = (~s_TempPoint_re);
                  }

                  s_TempPoint_im = s_Error_sample_im;
                  if (s_TempPoint_im < 0)
                  {
                     s_TempPoint_im = (~s_TempPoint_im);
                  }

                  // get maximum of the two components to calculate B_M
                  if(s_TempPoint_re < s_TempPoint_im)
                  {
                     s_TempPoint_re = s_TempPoint_im;
                  }
                  */
                  if (abs(s_Error_sample_re) > abs(s_Error_sample_im))
                  {
                     s_TempPoint_re = abs(s_Error_sample_re);
                  }
                  else
                  {
                     s_TempPoint_re = abs(s_Error_sample_im);
                  }

                  // get bit possition of the sign bit
                  for (us_Temp = (uint16)s_TempPoint_re, uc_S = 0; us_Temp>0 ; us_Temp>>=1)
                  {
                     uc_S++;
                  }
               }

               {
                  // Padding is mandatory for F_block = 1
                  // There are two ways to do padding (G992.5/7.2.2.2 eq. 7-2)
                  // i. Zero Padding
                  // ii. Sign extension

                  // Zero Padding code start
                  // c_B_M = uc_S;
                  // c_B_L = c_B_M - us_WordLength + 1;
                  //
                  // // Normalize B_L to bit position 0
                  // if(c_B_L < 0)
                  // {
                  //    s_Error_sample_re <<= -(c_B_L);
                  //    s_Error_sample_im <<= -(c_B_L);
                  // }
                  // else
                  // {
                  //    s_Error_sample_re >>= (c_B_L);
                  //    s_Error_sample_im >>= (c_B_L);
                  // }
                  // Zero Padding code end

                  // Sign extension padding code start
                  // B_M = max(S, Lw-1)
                  c_B_M = uc_S;
                  if (uc_S < (us_WordLength-1))
                  {
                     c_B_M = (us_WordLength-1);
                  }
                  // B_L = B_M - L_w + 1
                  // Note: From the above formula B_M >= L_w and therfore B_L >= 0.
                  c_B_L = c_B_M - us_WordLength + 1;

                  // Shift the relevant L_w bits, so that B_L is laying on the
                  // LSB, i.e. preparation to extract the L_w bits with a mask.
                  s_Error_sample_re >>= (c_B_L);
                  s_Error_sample_im >>= (c_B_L);
               }
               // sign extension padding code end

               // Mask the error samples, so that they contain only the relevant L_w bits.
               {
                  us_ClippedErrorMask = (1<<us_WordLength)-1;

                  s_Error_sample_re &= us_ClippedErrorMask;
                  s_Error_sample_im &= us_ClippedErrorMask;
               }

               //---------------------------------------------------------------------------
               //          Step x:  Pack Error Vector
               //---------------------------------------------------------------------------
               // Input:   calculated Error Vector:         s_Error_sample_re / s_Error_sample_im
               //          ByteCounter:                     gus_ErbByteCounter (...)
               //---------------------------------------------------------------------------
               // Output:  gpuca_StErbBuffer
               //---------------------------------------------------------------------------

               // Convert Little Endian data to Bin Endian data for PPE
               //       gus_ErbByteCounter | us_ErbByteCounter | us_ErbByteCounter1
               //       -------------------+-------------------+-------------------
               //                        0 |   3               |   2
               //                        1 |   2               |   1
               //                        2 |   1               |   0
               //                        3 |   0               |   7
               //                        4 |   7               |   6
               //                        5 |   6               |   5
               //                        6 |   5               |   4
               //                        7 |   4               |  11
               //                        8 |  11               |  10
               // Convert Little Endian data to Bin Endian data for PPE
               us_ErbByteCounter =(gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3);
               us_ErbByteCounter1 =((gus_ErbByteCounter+1) | 3) - ((gus_ErbByteCounter+1) & 3);

               //---------------------------------------------------------------------------
               //Package 4 bits B_M for current error sample
               //---------------------------------------------------------------------------
               us_NewBitPos = PackBitsInByteBufferST( &gpuca_StErbBuffer[us_ErbByteCounter],
                     &gpuca_StErbBuffer[us_ErbByteCounter1], c_B_M,
                     4, guc_CurrentBitPositionInByte);

               if (us_NewBitPos & OCTET_INCREMENT_FLAG) // format of us_NewBitPos:     lower 8-bit: 0x..YY : Bit position
                                                        //                             upper 8-bit: 0xYY.. : increment flag
               {
                  gus_ErbByteCounter++;
                  gus_PPD_ByteCounter_For_Segment++;         // number of PROTOCOL PAYLOAD DATA in current segment

                  // Convert Little Endian data to Bin Endian data for PPE
                  us_ErbByteCounter =(gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3);
                  us_ErbByteCounter1 =((gus_ErbByteCounter+1) | 3) - ((gus_ErbByteCounter+1) & 3);
               }
               guc_CurrentBitPositionInByte = (uint8)us_NewBitPos;     // remove OCTET_INCREMENT_FLAG (0x100)

               //---------------------------------------------------------------------------
               //Package clipped error sample /real part
               //---------------------------------------------------------------------------
               us_NewBitPos = PackBitsInByteBufferST( &gpuca_StErbBuffer[us_ErbByteCounter],&gpuca_StErbBuffer[us_ErbByteCounter1], s_Error_sample_re,
                     (uint8)us_WordLength, guc_CurrentBitPositionInByte);

               if (us_NewBitPos & OCTET_INCREMENT_FLAG) // format of us_NewBitPos:     lower 8-bit: 0x..YY : Bit position
                                                        //                             upper 8-bit: 0xYY.. : increment flag
               {
                  gus_ErbByteCounter++;
                  gus_PPD_ByteCounter_For_Segment++;         // number of PROTOCOL PAYLOAD DATA in current segment
                  // Convert Little Endian data to Bin Endian data for PPE
                  us_ErbByteCounter  = (gus_ErbByteCounter    | 3) -  (gus_ErbByteCounter    & 3);
                  us_ErbByteCounter1 =((gus_ErbByteCounter+1) | 3) - ((gus_ErbByteCounter+1) & 3);
               }
               guc_CurrentBitPositionInByte = (uint8)us_NewBitPos;

               //---------------------------------------------------------------------------
               //Package clipped error sample /imag part
               //---------------------------------------------------------------------------
               us_NewBitPos = PackBitsInByteBufferST( &gpuca_StErbBuffer[us_ErbByteCounter],&gpuca_StErbBuffer[us_ErbByteCounter1], s_Error_sample_im,
                     (uint8)us_WordLength, guc_CurrentBitPositionInByte);

               if (us_NewBitPos & OCTET_INCREMENT_FLAG)
               {
                  gus_ErbByteCounter++;
                  gus_PPD_ByteCounter_For_Segment++;         // number of PROTOCOL PAYLOAD DATA in current segment
               }
               guc_CurrentBitPositionInByte = (uint8) us_NewBitPos;     // remove OCTET_INCREMENT_FLAG (0x100)

               gus_RxToneTobeCranched += gusa_Fsub[guc_G9935_CurrentVectorredBand];

               // REVIEW_STEFAN: TBD: check of Segment length
               // to check the length only here is not sufficient
               // we may have increase the number of bytes by at least:
               //       - 2 bytes for error vector
               //       - 1 byte  for vector band header padding
               //       - 1 byte  for ...

               // The maximum payload size of an segment is MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE = 1024 bytes.
               // Hence creating new segment if size crosses 1022 bytes.
               // When the ERB data is more than 1024 byes, segmentation is required.
               //       REVIEW-STFAN: TBD: Why do we allow following restriction?
               // Based on discussions, it was decided that the ERB data for a single tone
               // need not be split across 2 segments.
               // Hence, to prevent such a scenario we are
               // checking the length of data. When data is greater than 1022 bytes, we do a
               // segmentation. Thereby the last tone in the segment may lie between 1022 and 1024 bytes.
               // And it wont be split across 2 segments or 1024 bytes wont be crossed within a
               // segment.
               // gus_PPD_ByteCounter_For_Segment: number of PROTOCOL PAYLOAD DATA in current segment
               if (gus_PPD_ByteCounter_For_Segment > (MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE - 2))
               {
                  gft_ERB_Main_Header_Configure = TRUE;
                  gus_ErbByteCounter_Previous = gus_ErbByteCounter;
                  guc_SegmentCode++;
                  gft_ERB_Configure_DMA = TRUE;
                  gft_ERB_Segment_Done = TRUE;
                  gft_ERB_Compute_Data = FALSE;
                  break;
               }
            }

            // gus_Start_Addr_Reversing is set to '0' for each segment
            // gus_PPD_ByteCounter_For_Segment | gus_ErbByteCounter    | gus_Start_Addr_Reversing     =>    gus_ByteCounter_For_Reversing
            // idx |     ByteIdx |      SegIdx |nTones|comment
            //   1 |    0 :   27 |    0 :    5 |    0 | SEG HEADER |
            //   2 |   28 :   28 |    6 :    6 |    0 | ERB_ID
            //   3 |   29 :   29 |    7 :    7 |    0 | VBB_ID
            //   4 |   30 :  131 |    8 :  109 |   51 | ERB
            //   5 |  132 :  233 |  110 :  211 |   51 | ERB
            //   6 |  234 :  335 |  212 :  313 |   51 | ERB
            //   7 |  336 :  437 |  314 :  415 |   51 | ERB
            //   8 |  438 :  539 |  416 :  517 |   51 | ERB
            //   9 |  540 :  641 |  518 :  619 |   51 | ERB
            //  10 |  642 :  743 |  620 :  721 |   51 | ERB
            //  11 |  744 :  845 |  722 :  823 |   51 | ERB
            //  12 |  846 :  947 |  824 :  925 |   51 | ERB
            //  13 |  948 : 1045 |  926 : 1023 |   49 | ERB

            // REVIEW_STEFAN: byte reversing is not needed if we populate the buffer already during parameter calculation
            gus_ByteCounter_For_Reversing = gus_ErbByteCounter - gus_Start_Addr_Reversing;
            Reverse_Packet();
            gus_Start_Addr_Reversing += gus_ByteCounter_For_Reversing;
            gft_Compute_CRC = TRUE;

            // REVIEW_STEFAN: TBD: comments are missing
            // Triggered only if it is NOT the last segment
            if (gft_ERB_Last_Segment == FALSE)
            {
               if ((gft_ERB_Configure_DMA == TRUE) && (gft_Triggered_DMA == FALSE))
               {
                  gc_FormErbInShowtimeState = FORM_ERB_MAIN_HEADER;
                  guc_ping_pong = guc_ping_pong ^ 0x1;
               }
            }
         }
         break;

      case FORM_ERB_LAST_SEGMENT:
         gus_NumofSymbols_ERB_Computation++; // XDSLRTFW-3492 (Start_End)
         gft_ERB_Configure_DMA = TRUE;
         gc_FormErbInShowtimeState = FORM_ERB_CRC;
         break;

      case FORM_ERB_CRC:
         // XDSLRTFW-3454: (Start_End)
         // We moved all the code sections where we used to set the owner bit of an ERB decriptor to one place
         // to eliminate risk of double setting of an owner bit.
         gus_NumofSymbols_ERB_Computation++; // XDSLRTFW-3492 (Start_End)
         if (gft_ERB_Configure_DMA == TRUE)
         {
            gus_ErbByteCounter_Previous = gus_ErbByteCounter;
            if (guc_ping_pong == 0)
            {
               gpuca_StErbBuffer_CRC = (uint8 *)(void *)gsa_StVectoringBuffer;
            }
            else if (guc_ping_pong == 1)
            {
               gpuca_StErbBuffer_CRC = guca_erb_ping_pong_buffer;
            }

            // CRC
            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = (gul_ERB_CRC & 0xFF);
            gus_ErbByteCounter_Previous++;

            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = ((gul_ERB_CRC >> 8) & 0xFF);
            gus_ErbByteCounter_Previous++;

            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = ((gul_ERB_CRC >> 16) & 0xFF);
            gus_ErbByteCounter_Previous++;

            us_ByteCounter_DMA = ((gus_ErbByteCounter_Previous | 3) - (gus_ErbByteCounter_Previous & 3));
            gpuca_StErbBuffer_CRC[us_ByteCounter_DMA] = ((gul_ERB_CRC >> 24) & 0xFF);
            gus_ErbByteCounter_Previous++;

            gft_ERB_Configure_DMA = FALSE;
            gft_Trigger_DMA = TRUE;
            gus_ERB_DMA_STATE = ERB_DMA_STATE_2_TRIGGER_DMA;                      // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
         }

         if (gft_Trigger_DMA == TRUE)
         {
            // XDSLRTFW-3454: (Start_End)
            // We set a flag here to set the priority of XDMA transfer of the ERB segment over the Debug traces.
            guc_EVB_DebugBuff_flag |= 0x1;
            if (VectorCopyErb((int32 *)(void *)gpuca_StErbBuffer_CRC, gus_ErbByteCounter_Previous) == 1)
            {
               gc_FormErbInShowtimeState = FORM_ERB_SET_BIT;

               // switch ERB_DMA state
               gft_Trigger_DMA = FALSE;
               gus_ERB_DMA_STATE = ERB_DMA_STATE_0_IDLE;                      // 0: IDLE, 1: CONFIGURE_DMA, 2: TRIGGER_DMA, 3: TRIGGERED_DMA
            }
         }
         break;

      case FORM_ERB_SET_BIT:
         gus_NumofSymbols_ERB_Computation++; // XDSLRTFW-3492 (Start_End)
         if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
         {
            uc_erb_descriptor_index = guc_erb_descriptor_index - 1;

            // REVIEW_STEFAN: Why do we need variable gft_ERB_Descriptor_Wraparound?
            //                A check for guc_erb_descriptor_index == 0 should be good enough
            //                Why do we need guc_erb_descriptor_index_Previous?
            if (gft_ERB_Descriptor_Wraparound == TRUE)
            {
               uc_erb_descriptor_index = guc_erb_descriptor_index_Previous - 1;
               gft_ERB_Descriptor_Wraparound = FALSE;
            }
            // XDSLRTFW-3454 (Start_End)
            // We were setting the owner bit first and then configuring the length. This may lead to
            // an issue if the PPE starts picking the data soon as the Owner bit is set.
            // Also we are clearing the flag which was used to set the priority of DMA access.
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 &= (0xFFFF0000);
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 |= gus_ErbByteCounter_Previous;
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 |= SET_OWNER_BIT_ERB_DESCRIPTOR;
            guc_EVB_DebugBuff_flag &= (~0x1);

            // Setting the bit in PDBRAM
            ul_addr_pointer = (uint32 *)((uint32)&__StartOfSramBAR17 + gul_DREG_ERB_Descriptor_Base + 4 + (8*uc_erb_descriptor_index));
            //MemSet32(ul_addr_pointer, gus_ErbByteCounter_Previous, 1);
            *ul_addr_pointer = gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1;
            gc_FormErbInShowtimeState = FORM_ERB_COMPLETION;

            // Last segment of current ERB has been sent out at this point
            // => reset ErrorFeedbackState back to "G9935_ERRORFB_ENABLE"
            gs_G9935ErrorFeedbackState = G9935_ERRORFB_ENABLE;

            // REVIEW_STEFAN: Why do we need a check for guc_erb_descriptor_index here? It's never true.
            if (guc_erb_descriptor_index > (gul_DREG_ERB_Number-1))
            {
               guc_erb_descriptor_index = 0;
            }
            guc_owner_bit_set++;

            // XDSLRTFW-3492 (Start)
            if (gus_NumofSymbols_ERB_Computation> gt_DsmStats.ul_NumOfSymbols_ERB)
            {
               gt_DsmStats.ul_NumOfSymbols_ERB = gus_NumofSymbols_ERB_Computation;
            }
            // XDSLRTFW-3492 (End)
         }
         break;

      // XDSLRTFW-3492 (Start)
      case FORM_ERB_COMPLETION:
         gus_NumofSymbols_ERB_Computation++;  // XDSLRTFW-3492 (Start_End)
         if (gs_RxPMDFrameCount < RX_DATA_SYMBOLS_PER_SUPERFRAME)
         {
            // BAR 17 consists of ERB descriptors
            ul_addr_pointer = (uint32 *)(((uint32)&__StartOfSramBAR17) + gul_DREG_ERB_Descriptor_Base); //XDSLRTFW-3421 (Start_End)
            memcpy(&t_ERBDescriptor, ul_addr_pointer, 72);   // XDSLRTFW-3448 (Start_End)

            for (i = 0, j = 0; i< MAX_NUM_ERB_SEGMENTS; i++)
            {
               if (t_ERBDescriptor[i].ul_DW1 & SET_OWNER_BIT_ERB_DESCRIPTOR)
               {
                  j++;
               }
            }

            if (j == 0)
            {
               if (gus_NumofSymbols_ERB_Computation > gt_DsmStats.ul_TotalNumofSymbols_ERB)
               {
                  gt_DsmStats.ul_TotalNumofSymbols_ERB = gus_NumofSymbols_ERB_Computation;
               }
               gt_DsmStats.ul_ErrVecTransmitted++;
               gus_NumofSymbols_ERB_Computation = 0;
               gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
               break;
            }
         }
         else
         {
            gt_DsmStats.ul_ErrVectDiscard++;
            gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
         }
         break;
         // XDSLRTFW-3492 (End)

      case FORM_ERB_L2_BACKCHANNEL_HEADER_FOR_TESTING:
         // Disable original ERB Transmission in Vectoring mode!
         // States in showtime
         // EOC_ERB_TRANSMISSION_STATE
         //    0: ST_ERBS_OFF                      : ERB are turned off
         //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
         //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
         guc_EOC_ERB_TRANSMISSION_STATE = ST_ERBS_OFF;    // turn off ERB transmission in TEST mode
         gpuca_StErbBuffer = (uint8* )(void *)gsa_StVectoringBuffer;
         gt_DsmStats.ul_ErrVecTransmitted++;
         gt_DsmStats.ul_ErrVecTransmittedSegments++;
         uint16 us_Length = 0;

         // Header for L2 Back channel ERB data
         //------------------------------------
         // Place holder for VCE MAC Address
         gpuca_StErbBuffer[3]  = 0xFF;
         gpuca_StErbBuffer[2]  = 0xFF;
         gpuca_StErbBuffer[1]  = 0xFF;
         gpuca_StErbBuffer[0]  = 0xFF;
         gpuca_StErbBuffer[7]  = 0xFF;
         gpuca_StErbBuffer[6]  = 0xFF;

         // Place holder for VTU-R MAC Address
         gpuca_StErbBuffer[5]   = (uint8)((gt_MacFrameConfigure.SrcMacAdrsB0_1 & 0xFF00) >> 8); // 0
         gpuca_StErbBuffer[4]   = (uint8)(gt_MacFrameConfigure.SrcMacAdrsB0_1 & 0x00FF);        // 1
         gpuca_StErbBuffer[11]  = (uint8)((gt_MacFrameConfigure.SrcMacAdrsB2_3 & 0xFF00) >> 8); // 2
         gpuca_StErbBuffer[10]  = (uint8)(gt_MacFrameConfigure.SrcMacAdrsB2_3 & 0x00FF);        // 3
         gpuca_StErbBuffer[9]  = (uint8)((gt_MacFrameConfigure.SrcMacAdrsB4_5 & 0xFF00) >> 8);  // 4
         gpuca_StErbBuffer[8]  = (uint8)(gt_MacFrameConfigure.SrcMacAdrsB4_5 & 0x00FF);         // 5

         // Place holder for Length
         us_Length = TESTArray[TEST_ErbData] + 13;
         gpuca_StErbBuffer[15] = ((us_Length >> 8) & 0xFF);
         gpuca_StErbBuffer[14] = (us_Length & 0xFF);

         // place holder for LLC header (0xAA - 0xAA - 0x3)
         gpuca_StErbBuffer[13] = 0xAA;
         gpuca_StErbBuffer[12] = 0xAA;
         gpuca_StErbBuffer[19] = 0x3;

         // place holder for ITU-T OUI (0x0 - 0x19 - 0xA7)
         gpuca_StErbBuffer[18] = 0x0;
         gpuca_StErbBuffer[17] = 0x19;
         gpuca_StErbBuffer[16] = 0xA7;

         // place holder for Protocol ID (0x0 - 0x3)
         gpuca_StErbBuffer[23] = 0x0;
         gpuca_StErbBuffer[22] = 0x3;

         // place holder for LINE ID
         gpuca_StErbBuffer[21] = (uint8)(gt_DecMsg_O_PMS_G9935.us_L2LineID>>8);     //Table10-10 G.993.5 Field#3 :2 bytes
         gpuca_StErbBuffer[20] = (uint8)gt_DecMsg_O_PMS_G9935.us_L2LineID;

         // place holder for Sync Symbol Count
         // VRX518_OPEN: Needs to be checked
         gpuca_StErbBuffer[27] = 0;  // Fixed Byte 3 of Table 8-6/G993.5
         gpuca_StErbBuffer[26] = 0;

         // Segment code
         gpuca_StErbBuffer[25] = guc_SegmentCode;  // need clarification with SW people

         gus_ErbByteCounter = 27;
         gus_RxToneTobeCranched = gus_ErbByteCounter;
         gus_Start_Addr_Reversing = 0;
         gc_FormErbInShowtimeState = FORM_ERB_L2_BACKCHANNEL_DATA_FOR_TESTING;
         break;

      case FORM_ERB_L2_BACKCHANNEL_DATA_FOR_TESTING:
         for (k = 0; k < 100; k++ ) // Compute only 100 data elements/symbol
         {
            uint16 j;
            if (gus_RxToneTobeCranched >=(uint16)TESTArray[TEST_ErbData]+27) // Exit condition
            {
               gc_FormErbInShowtimeState = FORM_ERB_L2_WAIT;
               gft_ERB_Segment_Done = TRUE;
               break;
            }
            j = (gus_RxToneTobeCranched|3)-(gus_RxToneTobeCranched & 3);
            gpuca_StErbBuffer[j] = (uint8)(gus_RxToneTobeCranched & 0xFF);
            gus_RxToneTobeCranched++;
            gft_Trigger_DMA = TRUE;
            gus_ErbByteCounter++;
         }
         gus_ByteCounter_For_Reversing = gus_ErbByteCounter - gus_Start_Addr_Reversing;
         Reverse_Packet();
         gus_Start_Addr_Reversing += gus_ByteCounter_For_Reversing;
         gft_Compute_CRC = TRUE;
         break;

      case FORM_ERB_L2_WAIT:
         gc_FormErbInShowtimeState = FORM_ERB_L2_TRIGGER_DMA;
         break;

      case FORM_ERB_L2_TRIGGER_DMA:
         if (gft_Trigger_DMA == TRUE)
         {
            gft_Trigger_DMA = FALSE;

            gpuca_StErbBuffer[(gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3)] = (gul_ERB_CRC & 0xFF);
            gus_ErbByteCounter++;

            gpuca_StErbBuffer[(gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3)] = ((gul_ERB_CRC >> 8) & 0xFF);
            gus_ErbByteCounter++;

            gpuca_StErbBuffer[(gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3)] = ((gul_ERB_CRC >> 16) & 0xFF);
            gus_ErbByteCounter++;

            gpuca_StErbBuffer[(gus_ErbByteCounter | 3) - (gus_ErbByteCounter & 3)] = ((gul_ERB_CRC >> 24) & 0xFF);
            gus_ErbByteCounter++;
         }
         gus_ErbByteCounter_Previous = gus_ErbByteCounter;
         // Trigger the DMA

         // XDSLRTFW-3454: (Start_End)
         // We set a flag here to set the priority of XDMA transfer of the ERB segment over the Debug traces.
         guc_EVB_DebugBuff_flag |= 0x1;
         if (VectorCopyErb((int32 *)(void *)gpuca_StErbBuffer, gus_ErbByteCounter) == 1)
         {
            gc_FormErbInShowtimeState = FORM_ERB_L2_SET_BIT;
         }
         else
         {
            gc_FormErbInShowtimeState = FORM_ERB_L2_TRIGGER_DMA;
         }
         break;

      case FORM_ERB_L2_SET_BIT:
         if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
         {
            // XDSLRTFW-3454 (Start_End)
            // We were setting the owner bit first and then configuring the length. This may lead to
            // an issue if the PPE starts picking the data soon as the Owner bit is set.
            // Also we are clearing the flag which was used to set the priority of DMA access.
            uc_erb_descriptor_index = guc_erb_descriptor_index - 1;
            if (gft_ERB_Descriptor_Wraparound == TRUE)
            {
               uc_erb_descriptor_index = guc_erb_descriptor_index_Previous - 1;
               gft_ERB_Descriptor_Wraparound = FALSE;
            }
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 &= (0xFFFF0000);
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 |= gus_ErbByteCounter_Previous;
            gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1 |= SET_OWNER_BIT_ERB_DESCRIPTOR;
            guc_EVB_DebugBuff_flag &= (~0x1);

            // Setting the bit in PDBRAM
            ul_addr_pointer = (uint32 *)((uint32)&__StartOfSramBAR17 + gul_DREG_ERB_Descriptor_Base + 4 + (8*uc_erb_descriptor_index));
            //MemSet32(ul_addr_pointer, gus_ErbByteCounter_Previous, 1);
            *ul_addr_pointer = gt_ERBDescriptor[uc_erb_descriptor_index].ul_DW1;

            // REVIEW_STEFAN: TBD: FW uses 8 instead of gul_DREG_ERB_Number
            //                (instead of 8 we should have used the define MAX_NUM_ERB_SEGMENTS)
            // REVIEW_STEFAN: Why do we need a check for guc_erb_descriptor_index here? It's never true.
            if (guc_erb_descriptor_index > 8)
            {
               guc_erb_descriptor_index = 0;
            }
            gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
         }
         break;
   }
}

void InitL2BackChannelHeader(void)
{
   // Header for L2 Back channel ERB data
   //------------------------------------
   // Place holder for VCE MAC Address
   gpuca_StErbBuffer[3]  = gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[0];
   gpuca_StErbBuffer[2]  = gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[1];
   gpuca_StErbBuffer[1]  = gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[2];
   gpuca_StErbBuffer[0]  = gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[3];
   gpuca_StErbBuffer[7] = gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[4];
   gpuca_StErbBuffer[6] = gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[5];

   // Place holder for VTU-R MAC Address
   gpuca_StErbBuffer[5]   = (uint8)((gt_MacFrameConfigure.SrcMacAdrsB0_1 & 0xFF00) >> 8); // 0
   gpuca_StErbBuffer[4]   = (uint8)(gt_MacFrameConfigure.SrcMacAdrsB0_1 & 0x00FF);        // 1
   gpuca_StErbBuffer[11]  = (uint8)((gt_MacFrameConfigure.SrcMacAdrsB2_3 & 0xFF00) >> 8); // 2
   gpuca_StErbBuffer[10]  = (uint8)(gt_MacFrameConfigure.SrcMacAdrsB2_3 & 0x00FF);        // 3
   gpuca_StErbBuffer[9]  = (uint8)((gt_MacFrameConfigure.SrcMacAdrsB4_5 & 0xFF00) >> 8);  // 4
   gpuca_StErbBuffer[8]  = (uint8)(gt_MacFrameConfigure.SrcMacAdrsB4_5 & 0x00FF);         // 5

   // Place holder for Length
   gpuca_StErbBuffer[15] = (((gsa_Header_Length[guc_SegmentCode]) >> 8) & 0xFF); //0x4;
   gpuca_StErbBuffer[14] = ((gsa_Header_Length[guc_SegmentCode]) & 0xFF);//0x15;

   // place holder for LLC header (0xAA - 0xAA - 0x3)
   gpuca_StErbBuffer[13] = 0xAA;
   gpuca_StErbBuffer[12] = 0xAA;
   gpuca_StErbBuffer[19] = 0x3;

   // place holder for ITU-T OUI (0x0 - 0x19 - 0xA7)
   gpuca_StErbBuffer[18] = 0x0;
   gpuca_StErbBuffer[17] = 0x19;
   gpuca_StErbBuffer[16] = 0xA7;

   // place holder for Protocol ID (0x0 - 0x3)
   gpuca_StErbBuffer[23] = 0x0;
   gpuca_StErbBuffer[22] = 0x3;

   // place holder for LINE ID
   gpuca_StErbBuffer[21] = (uint8)(gt_DecMsg_O_PMS_G9935.us_L2LineID>>8);     //Table10-10 G.993.5 Field#3 :2 bytes
   gpuca_StErbBuffer[20] = (uint8)gt_DecMsg_O_PMS_G9935.us_L2LineID;

   // place holder for Sync Symbol Count
   // VRX518_OPEN: Needs to be checked
   gpuca_StErbBuffer[27] = (uint8) (gs_RxSuperFrmCnt_ForEOC>>8);  // Fixed Byte 3 of Table 8-6/G993.5
   gpuca_StErbBuffer[26] = (uint8) gs_RxSuperFrmCnt_ForEOC;

   if (guc_SegmentCode == (guc_NumOfSegments-1))
   {
      gpuca_StErbBuffer[25] = (guc_SegmentCode | 0xC0);  // need clarification with SW people
   }
   else
   {
      gpuca_StErbBuffer[25] = guc_SegmentCode;
   }
}

int16 VectorCopyErb(int32 *pSrc,uint32 ul_Size)
{
   //XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   int16 s_RetValue = 0; //Stay in the same state

   /*
   // Debug code to analyze invalid codeswap requests with NULL Pointer
   if(pSrc == 0x0)
   {
      SDRAMDebug t_sdramdebug;
      t_sdramdebug.ft_ERB_Configure_DMA = gft_ERB_Configure_DMA;
      t_sdramdebug.ft_Trigger_DMA = gft_Trigger_DMA;
      t_sdramdebug.ft_Triggered_DMA = gft_Triggered_DMA;
      t_sdramdebug.uc_ping_pong = guc_ping_pong;
      t_sdramdebug.ft_ERB_Last_Segment = gft_ERB_Last_Segment;
      t_sdramdebug.uc_EVB_DebugBuff_flag = guc_EVB_DebugBuff_flag;
      t_sdramdebug.us_ERB_DMA_STATE = gus_ERB_DMA_STATE;
      t_sdramdebug.c_FormErbInShowtimeState = gc_FormErbInShowtimeState;
      DSH_SendEvent(DSH_EVT_CODESWAP_ISSUE,sizeof(t_sdramdebug) ,&t_sdramdebug);
   }
   */

   //Update header info
   if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
   {
      // update source address
      gta_BAR15LookUpTable[OFF_CHIP_ERROR_VECTOR][OFF_CHIP_SOURCE_INDEX] = (int32)pSrc;
      // destination;
      gta_BAR15LookUpTable[OFF_CHIP_ERROR_VECTOR][OFF_CHIP_DEST_INDEX] = (int32)gt_ERBDescriptor[guc_erb_descriptor_index].ul_DW0;
      // size in bytes; make sure length is multiple of 4-bytes
      gta_BAR15LookUpTable[OFF_CHIP_ERROR_VECTOR][OFF_CHIP_LENGTH_INDEX] = ((ul_Size + 3) >> 2) << 2;

      // Free handle for offchip request
      FreeSwapHandle(&guc_OffChipRequestHandle);

      guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF,OFF_CHIP_ERROR_VECTOR);

      //XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      s_RetValue = 1;

      guc_erb_descriptor_index++;
      if (guc_erb_descriptor_index > (gul_DREG_ERB_Number-1))
      {
         gft_ERB_Descriptor_Wraparound = TRUE;
         guc_erb_descriptor_index = 0;
         // REVIEW_STEFAN: TBD: FW uses 9 instead of gul_DREG_ERB_Number
         //                (instead of 9 we should have used the define MAX_NUM_ERB_SEGMENTS)
         guc_erb_descriptor_index_Previous = 9;
      }
      //DSM_Vectoring_Debug:
      //if (gs_PauseControl == 102)
      //Pause(gs_PauseControl);
   }
   //XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   return (s_RetValue);
}

void Reverse_Packet(void)
{
   uint16 i,j,k;
   uint32 l_swap;
   uint8* gpuca_StErbBuffer_Reverse = NULL;

   // REVIEW_STEFAN: TBD: Why do we need here a check for the ping pong tables???
   // gpuca_StErbBuffer should be good enough

   //uint8* gpuca_StErbBuffer_Reverse = (uint8 *)(void *)guca_ERB_Segment0;   // XDSLRTFW-2049
   if (guc_ping_pong == 0)
   {
      gpuca_StErbBuffer_Reverse = (uint8 *)(void *)gsa_StVectoringBuffer;   // XDSLRTFW-2049
   }
   else if (guc_ping_pong == 1)
   {
      gpuca_StErbBuffer_Reverse = guca_erb_ping_pong_buffer;
   }

   i = 0;
   j = gus_Start_Addr_Reversing;
   k = 0;

   // REVIEW_STEFAN: TBD: gsa_ERB_Part0 / gsa_ERB_Part1 have a length of 80
   // How do we guarantee that there is not violation in this while loop???
   // e.g.: if gus_ByteCounter_For_Reversing > 160?
   // Here we need an input-data validation!
   // How many data can be processed by HW in one symbol?
   //
   // Why do we need a logic with shifting?
   // To be replaced by:
   //     - gca_ERB_Part0(i+0) = gpuca_StErbBuffer_Reverse(j+3);
   //     - gca_ERB_Part0(i+1) = gpuca_StErbBuffer_Reverse(j+2);
   //     - gca_ERB_Part0(i+2) = gpuca_StErbBuffer_Reverse(j+1);
   //     - gca_ERB_Part0(i+3) = gpuca_StErbBuffer_Reverse(j+0);
   //  "if (gft_ERB_Buffer_Selector == TRUE)" needs to be set outside the loop
   while (i < gus_ByteCounter_For_Reversing)
   {
   // REVIEW_STEFAN: TBD: What do we do if not all 4 bytes were populated?
   //                     Add at least a comment why this does not have any impact
      l_swap = ((gpuca_StErbBuffer_Reverse[(j|3) - (j&3)] & 0xFF) | (((gpuca_StErbBuffer_Reverse[((j+1) | 3) - ((j+1) & 3)] << 8) & 0xFF00) | ((gpuca_StErbBuffer_Reverse[((j+2)|3) - ((j+2)&3)] << 16) & 0xFF0000) | ((gpuca_StErbBuffer_Reverse[((j+3)|3) - ((j+3)&3)] << 24) & 0xFF000000)));
      if (gft_ERB_Buffer_Selector == TRUE)
      {
         gsa_ERB_Part0[k++] = l_swap & 0xFFFF;
         gsa_ERB_Part0[k++] = ((l_swap & 0xFFFF0000) >> 16);
      }
      else
      {
         gsa_ERB_Part1[k++] = l_swap & 0xFFFF;
         gsa_ERB_Part1[k++] = ((l_swap & 0xFFFF0000) >> 16);
      }
      i = i+4;
      j = j+4;
   }
}



uint16 PackBitsInByteBufferST(uint8 *pt_OutputBufferCurrentIndex,uint8 *pt_OutputBufferCurrentIndex1,  int16 s_Value, uint8 uc_WordLength,
      uint8 uc_CurrentPosition)
{
   uint16 us_NewBitPositionMarker = 0;
   int16 s_Shift;
   uint16 us_TempValue;

   // compute Shift value
   s_Shift = (int16) uc_CurrentPosition - (int16) uc_WordLength;

   if(s_Shift<0)
   {
      s_Shift+=8;
   }

   // The s_Shift can be used in the next call as uc_CurrentPosition
   us_NewBitPositionMarker |= (uint16) s_Shift;

   us_TempValue = (uint16) s_Value<<s_Shift ;

   // Check if word is overlapping byte boundary
   if((s_Shift + uc_WordLength)>8)   // BYTE Boundary overlap
   {
      pt_OutputBufferCurrentIndex[0] |=  (uint8) (us_TempValue>>8);
      pt_OutputBufferCurrentIndex1[0]  =  (uint8) us_TempValue;
      us_NewBitPositionMarker |= OCTET_INCREMENT_FLAG; //0x0100
   }
   else if((s_Shift + uc_WordLength)== 8)// No previous Content in location
   {
      pt_OutputBufferCurrentIndex[0] =  (uint8) us_TempValue;
   }
   else     // Use OR since previous content present
   {
      pt_OutputBufferCurrentIndex[0] |=  (uint8) us_TempValue;
   }

   if(!s_Shift)
   {
      us_NewBitPositionMarker |= OCTET_INCREMENT_FLAG;   //0x0100
   }

   return(us_NewBitPositionMarker);
}

//#endif
