/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ShowtimeRxF_VDSL2.c
*
*   This file contains foreground (FG) functions for VDSL2 showtime Rx processing.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// ShowtimeRxF_VDSL2.c
//
// History
//
// 10/07/2012 Vinjam:  Added code to clear a buffer which  "Show time SNR with out virtual noise".
//                     Note: "Show time SNR with out virtual noise" buffer (used during show time)
//                     is overlaid on training code swap pages.
//                     Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 05/12/2012 Ram: Aligning to Msg Spec 1.8:- INFO 68, has no variable 'Line Rate'
//                 Grep for 'XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68'
//
// 09/05/2013 Kannan: Round of error corrected for l_NetDataRate computation.
//            Grep for "XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop "
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
// 10/09/2013 Sooraj: Added Support for DS-SRA with ReTx
//                 Grep for XDSLRTFW-1030: SRAds_Support_with_DS_ReTx
//                 Grep for XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode
//                 Grep for XDSLRTFW-1063: SRAds_Support_with_DS_ReTx
// 16/01/2013 Ram/Kannan: Bug Fix for Inverted sync detection for SRA
//
// 03/03/2014 Prashant: Use the SNR Margin based ATTNDR even during SRA also. In theory ATTNDR represents the Margin
//                      deltas from Medley SNR in Showtime. Disable the updates on ATTNDR during SRA.
//                 Grep for XDSLRTFW-1600
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with DS Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2162".
// ************************************************************************************************************

#include "string.h" // for memset()
#include "common.h"
#include "gdata.h"
#include "vdsl_state.h"
#include "cmv.h"
#include "profile.h"
#include "showtime.h"
#include "DDSnrFdqHandler.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "rx_ib.h"
#include "OvhdMsg_IOf.h"
#include "show_iof.h"
#include "g997.h"
#include "vdsl_xception.h"
#include "eoc.h"
#include "cri_iof.h"
#include "BitswapHandler.h"
#include "dslengin.h"
#include "dec_train.h"
#include "DecAdapt_IOf.h"
#include "SynchDetect.h"
#include "RxDataPumpSetUp.h"
#include "Framing_VDSL2.h"

#include "ShowtimeERBHandler.h"
#include "DetectReverbSegueG9935ST.h"

#include "fcs.h"
#include "DebugBuffer.h"
#include "qt_memmap.h"
#include "LL_IOf.h"
#include "vdsl_const.h"
#include "ModemMonitor.h"

// XDSLRTFW-1030: SRAds_Support_with_DS_ReTx (START)
#include "zep_memmap_cnfg.h"

void InitDsReTxForSra_VDSL2(void);
void InitDsReTxForSra_VDSL2_NTC(void); //XDSLRTFW-2577 (Start_End)

extern uint8 guc_Wr_SID_idx;
extern uint8 guc_Rd_SID_idx;
extern uint8 guc_EstimatedTS;
extern uint8 guc_Prev_Rd_SID_idx;
extern uint8 guc_Curr_Wr_DTU_idx;

//XDSLRTFW-1383 (Start)
extern uint8 guc_Prev_Rd_SID;
extern uint8 guc_Prev_Rd_DTU_idx;
//XDSLRTFW-1383 (End)

extern ReTX_ShowtimeParams_t gt_ReTxShowtimeParams;
extern void Compute_VDSL2Framing(VDSL2Config_t *pt_Config, BC_LP_TPS_Map_t *pt_TPS_Map, int16 *s_PMDFramesPerIBStructure);
extern void LoadRxZepMicroCode(void);
// XDSLRTFW-1030: SRAds_Support_with_DS_ReTx (END)
// Local function prototype
void Load_SHOW_2_V2_SwapPage(void);
void RxOLRPMHandler(void);
void RxOLRPMHandler_FC(void);
uint8 DetectSEF(int16 CurrRxSyncType);
void UpdateRxRatesForSRA(void);

#ifdef DEBUG_TRACES
void CalcBgtChecksum(void);
void TriggerEventLp(void);
void TriggerEventOlrHandler(void);
#endif

#ifdef PILOT_TONE_LOS_DETECT
void DetectLOS(void);
#endif //#ifdef PILOT_TONE_LOS_DETECT




/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ShowtimeRxF_QT_VDSL2(void)
*
*   This function is used as a VDSL2 Rx Foreground (FG) task for Showtime
*   processing. This is one of two FG tasks during showtime, which is executed
*   after ShowtimeRxTC_QT_VDSL2() TC task. All tasks requiring completion of QT run
*   are done here, which includes SNR/FDQ updates, etc.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ShowtimeRxF_QT_VDSL2(void)
{
   int16 s_CurrRxSyncType=0;
//   int32 l_cycles;

   //XDSLRTFW-2392 (Cascaded scheduling - Start - End)
   ReadRxTimer((uint32 *)(void *)&gl_RxTimer_RxNTcStart);

   //XDSLRTFW-2577 (Start)
   //Mips optimization: Init ReTx buffer mgmt variables in NTC task
   if (gft_DsSraReTxInit == TRUE) {
      InitDsReTxForSra_VDSL2_NTC();
      gft_DsSraReTxInit = FALSE;
   }
   //XDSLRTFW-2577 (End)

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   if (gsa_IndirectStat0[0] == STAT_ShowTimeTCSyncState)
   {
      gsa_IndirectStat0[3]=VDSL2_SHOWTIME_RX_WITH_TC_SYNC;
   }
   else
   {
      gsa_IndirectStat0[3]=VDSL2_SHOWTIME_RX_NO_TC_SYNC;
   }
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
//#ifdef PROFILE_TASKS
//   int16 s_Timer;
//   //Record the TX TC task start time based on the RX timer
//   s_Timer = LogTaskProfile(RX_SHOWTIME_QT_DONE_NTC_START,0);
//#endif //PROFILE_TASKS

   // Set STAT CMV when Tx and Rx have entered showtime,
   if (!(gus_ShowtimeControl & MASK_TX_RX_SHOWTIME))
   {

      if (gs_TxState == R_SHOWTIME_TX)
      {
         gsa_IndirectStat0[0] = STAT_ShowTimeState;
         gusa_MONI_ModemStat_Status[0] = MONI_STAT_SHOW_TC_NOSYNC;
         gus_ShowtimeControl |= MASK_TX_RX_SHOWTIME;

         // XDSLRTFW-3513 (Start)
         gs_AutoMsgHandlerState = CHECK_MODEM_MACRO_STATE;
         gs_ModemMonitorState = MODEM_MONITOR_AUTO_MSG_HANDLER;
         // XDSLRTFW-3513 (End)

         //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
         memset(gca_SnrBuf_WithOutVN, 0, RX_MAX_NUM_TONES); //RX_MAX_NUM_TONES = 4096

         // Set the Line as available beginning showtime
         gt_G997_Cntrl.s_LinkState = G997_LINK_AVAIL;
         //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start_End)
         //Link drop was seen with Avinax CO in NULL loop and when US is in fast path.
         //UAS counter was getting incremented until UAS state is set to AVAIL and when this
         //value was sent to AVINAX CO, CO drops the link. Fix: Set the UAS state to AVAIL as
         //soon as we enter showtime.
         gt_g997_LinePerf_help.s_UAS_L_State = UAS_STATE_LINE_AVAIL;

         // Reset gs_RxSubState for use by Load_SHOW_2_V2_SwapPage fcn
         gs_RxSubState = 0;
      }
   }
   else
   {
      // Once Tx and Rx have entered Showtime check whether SHOW_2 page
      // has been loaded
      if ((gus_ShowtimeControl & MASK_SHOW_2_PAGE_LOADED) == 0)
      {
         Load_SHOW_2_V2_SwapPage();
      }
   }

   //==================================================================
   // Run RxDataFrameProcess_VDSL2 once SHOW_2_V2 page has been loaded
   //==================================================================
   if (gus_ShowtimeControl & MASK_SHOW_2_PAGE_LOADED)
   {
      // Always run the following showtime FG tasks. Don't run these tasks after having read the
      // sync frame.
      //
      //   Task1: Update SNR/FDQ
      //
      {
         if(!(gus_ShowtimeControl & MASK_RX_SYNC_FRAME_PROC))
         {
            RxDataFrameProcess_VDSL2();
         }

         //DSM_Vectoring_Debug:
         //if (gs_PauseControl == 0x29)
         //Pause(gs_PauseControl);

      }
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
      //Detect reverb or segue
      //The result of this detection is used by both OLR and SEF detection
      if(gs_RxPMDFrameCount == RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         if (gft_DSVectoringEnabled == TRUE)
         {
            //XDSLRTFW-2875 (Start)
            if ((gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_FRIENDLY_MASK)) == 0)
            {
               //Vectoring mode
               s_CurrRxSyncType = DetectReverbSegueG9935ST(gs_RxSynchFrameNumTones);
            }
            else
            {
               //Vector Friendly mode
               s_CurrRxSyncType = DetectReverbSegueVectorFriendlyST(gpsa_RxSynchFrame, gs_RxSynchFrameNumTones);
            }
            //XDSLRTFW-2875 (End)
         }
         else
         {
            s_CurrRxSyncType = DetectReverbSegue(gpsa_RxSynchFrame, gs_RxSynchFrameNumTones);
         }

         //==================================================================
         //Perform SEF detection
         //==================================================================

         gt_TxIbData.uc_sef_def = DetectSEF(s_CurrRxSyncType);
         if (gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECV_SYNC_INDICATOR)
         {

            //Detect inverted synch symbol
            //Since REVERB == 0 and SEGUE == 1, so the sum of them should be 1
            if((gs_RxSyncToneType + s_CurrRxSyncType) == 1)
            {

               //Update the number of synch flag received
               gs_NumRxSynchFlags++;

               /* Update the sync signal type */
               gs_RxSyncToneType = !gs_RxSyncToneType;

               DSH_SendEvent(DSH_EVT_RX_PHASE_REVERSAL,sizeof(int16),&s_CurrRxSyncType);

               /* Sync indicator is received. Hence, don't wait for any HDLC message response */
               gta_TxEocControlInfo[0].ft_ack_expected = FALSE;

               /* change OLR state to Reconfigure */
               gt_RxOLRPMVars.uc_rxOLRPMState = OLR_RECONFIGURE;

               //XDSLRTFW-1393 (Start_End)
               //Inverted SYNC corresponding to SRA detected
               if (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ)
               {
                  gft_SRAInvSync_Detected = TRUE;
               }
            }
         }
      }
      else
      {
         //==================================================================
         //Run OLR/PM state machine
         //==================================================================
         if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECONFIGURE)
         {
//XDSLRTFW-2162 (Start)
            if ((gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt - 4)) && (gft_Intra_DTU_Ilv_DS == TRUE))
            {
               if(gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ)
               {
                  gft_IDILV_DS_SRA_event = TRUE;
               }
            }
//XDSLRTFW-2162 (End)
            //Run OLR handler
            if (gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt - 2))
            {
               // Get ready to switch RX ping pong tables
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, SwitchRxTableForBitswap);
            }
            else if (gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt - 1) && (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ))
            {
               //XDSLRTFW-3339 (Start)
               if (gft_Intra_DTU_Ilv_DS == FALSE)
               {
                  //Resetting of QT register in NTC task is not permitted.
                  //TBD: Hence move this resetting task to TC task.
                  //XDSLRTFW-1030: SRAds_Support_with_DS_ReTx (START)
                  WriteCoreReg(IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR, 0);
                  gsa_RxBitsInFifo[LP1] = 0;
               }
               //XDSLRTFW-3339 (End)
               // Copy the basic framing parameters for LP1 path
               gt_rx_config_v2.ul_Lp[LP1] = gt_rx_config_v2.ul_Reconfig_Lp[LP1];
               gt_rx_config_v2.s_Rp[LP1] = gt_ReTxShowtimeParams.s_Reconfig_Rp;
               gt_rx_config_v2.s_Mp[LP1] = gt_ReTxShowtimeParams.s_Reconfig_Mp;
               gt_rx_config_v2.s_Dp[LP1] = gt_rx_config_v2.s_Reconfig_Dp[LP1];
               gt_rx_config_v2.sa_Bpn[LP1][BC0] = gt_rx_config_v2.sa_Reconfig_Bpn[LP1][BC0];
               gt_rx_config_v2.s_Ip[LP1] = gt_ReTxShowtimeParams.s_Reconfig_Ip;
               gt_rx_config_v2.s_Nfecp[LP1] = gt_ReTxShowtimeParams.s_Reconfig_Nfecp;
               Compute_VDSL2Framing(&gt_rx_config_v2, &gt_rx_TPS_Map, &gs_PMDFramesPerRxIBStructure);

               //XDSLRTFW-1393 (Start)
               //AddFunctionToFifo(gp_RxLoadingFunctionFifo, InitDsReTxForSra_VDSL2);
               gft_DsSraReTxInit = TRUE;
               //XDSLRTFW-1393 (End)
               //XDSLRTFW-1030: SRAds_Support_with_DS_ReTx (END)
            }
         }//if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECONFIGURE)
      }//else(gs_RxPMDFrameCount == RX_DATA_SYMBOLS_PER_SUPERFRAME)
      //if ((gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt + 4)) && (guc_ReTx_DS_D > 1))
//XDSLRTFW-2162 (Start)
      if ((gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt + 4)) && (gft_Intra_DTU_Ilv_DS == TRUE))
      {
         gft_IDILV_DS_SRA_event = FALSE;
      }
//XDSLRTFW-2162 (End)

      //Check for EOC timeouts
      CheckEocTimeOut();
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]


      //==================================================================
      //Perform LOS detection
      //==================================================================
#ifdef PILOT_TONE_LOS_DETECT
      DetectLOS();
#endif
   }

   // Form ERB in showtime foreground
   if((gft_DSVectoringEnabled == TRUE) || (TESTArray[TEST_StoreSramControl] & TEST_SAVE_VECTOR_DEBUG_L2_ENABLE ))
   {
      ShowtimeErbHandler();
   }

   // update VDSL2 PMD frame counter which goes from 0 to 256
   gs_RxPMDFrameCount++;
   if (gs_RxPMDFrameCount > RX_DATA_SYMBOLS_PER_SUPERFRAME)
   {
      gs_RxPMDFrameCount = 0;
//#ifdef MTK_VECTORING_SUPPORT
      gs_RxSuperFrmCnt_in_Showtime++;
//#endif
   }

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   LogTaskProfile(RX_SHOWTIME_QT_DONE_NTC_END,s_Timer);
//#endif //PROFILE_TASKS

   //XDSLRTFW-2392 (Cascaded scheduling - Start)
   //Start RX FC NTC function to process the overhead information
   if (guc_CasMode_enable)
   {
      gt_TaskArray[RX_FC_DONE].NonTimeCriticalTask(); //ShowtimeRxF_FC_VDSL2()
   }
   //XDSLRTFW-2392 (Cascaded scheduling - End)

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   if ((guc_CasMode_enable) && (gft_EnableTaskProfile))
   {
      int32 l_RxNtc_Cycles; //XDSLRTFW-3901 (START_END)
      //Max & Min Cycles for Sync and Data symbol
      //Sync symbol checking is done after PMD count increment
      //hence gs_RxPMDFrameCount = 0 would be cycles consumed for previous
      //sync symbol.
      if (gs_RxPMDFrameCount != 0)
      {
         LogTaskProfile(ST_RX_NTC_QT_DONE_DATA_SYMBOL, gl_RxTimer_RxNTcStart);
      }
      else
      {
         LogTaskProfile(ST_RX_NTC_QT_DONE_SYNC_SYMBOL, gl_RxTimer_RxNTcStart);
      }

      //XDSLRTFW-3901 (START)
      //Go for exception if Rx NTC task exceeds > 24K cycles
      ReadRxTimer((uint32 *)(void *)&l_RxNtc_Cycles);
      l_RxNtc_Cycles -= gl_RxTimer_RxNTcStart;
      if(l_RxNtc_Cycles < 0) l_RxNtc_Cycles += gl_MaxRxTimerCnt;
      if (l_RxNtc_Cycles > 24000)
      {
        //Enter fail state if Rx NTC task exceeds the cycle budget.
        EnterFailStates(E_CODE_ST_RX_NTC_CYCLES_TIMEOUT);
      }
      //XDSLRTFW-3901 (END)
   }
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ShowtimeRxF_FC_VDSL2(void)
*
*   This function is used as a VDSL2 Rx Foreground (FG) task for Showtime
*   processing. This is one of two FG tasks during showtime, which is executed after
*   ShowtimeRxTC_FC_VDSL2() TC task. All tasks requiring completion of FC run are done
*   here, which includes overhead processing, error statistics monitoring, etc.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ShowtimeRxF_FC_VDSL2(void)
{

//#ifdef PROFILE_TASKS
//   int16 s_Timer;
//   //Record the TX TC task start time based on the RX timer
//   s_Timer = LogTaskProfile(RX_SHOWTIME_FC_DONE_NTC_START,0);
//#endif //PROFILE_TASKS

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   int32 l_Timer;
   ReadRxTimer((uint32 *)(void *)&l_Timer);
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

   // Run Rx overhead handler
   RxOvhdHandler();

   // Change the Rx transfer size if needed
   RxOLRPMHandler_FC();

   // Process RX IB for the current superframe
   // right after 3 IB bytes are read out from HW FIFO
   if (gus_ShowtimeControl & MASK_PROCESS_RX_IB)
   {
      RxIbHandler();
   }


//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   LogTaskProfile(RX_SHOWTIME_FC_DONE_NTC_END,s_Timer);
//#endif //PROFILE_TASKS

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   if ((guc_CasMode_enable) && (gft_EnableTaskProfile))
   {
      //Max & Min Cycles for Sync and Data symbol
      //Sync symbol checking is done after PMD count increment
      //hence gs_RxPMDFrameCount = 0 would be cycles consumed for previous
      //sync symbol.
      if (gs_RxPMDFrameCount != 0)
         LogTaskProfile(ST_RX_NTC_PMS_DATA_SYMBOL, l_Timer);
      else
         LogTaskProfile(ST_RX_NTC_PMS_SYNC_SYMBOL, l_Timer);
   }
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RxDataFrameProcess_VDSL2(void)
*
*   This function runs routine VDSL2 Rx showtime foreground tasks - SNR/FDQ updates, etc.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void RxDataFrameProcess_VDSL2(void)
{
   switch (guc_RxDataFrameState)
   {
   case SNR_FDQ_UPDATE:

      // update SNR/FDQ
      if (gs_DDSnrFdqState != DD_SNRFDQ_DONE)
      {
         DDSnrFdqHandler();
      }
      else
      {
         // prepare for the next round of SNR/FDQ update
         gs_DDSnrFdqState = DD_SNRFDQ_INIT;

         // Skip doing bitswap decision in case of real bad SNRs
         if ((gt_TxIbData.uc_los_def == PRESENT) || (gft_SkipBitswap == TRUE))
         {
            guc_BitSwapState = BITSWAP_DONE;
         }
         //XDSLRTFW-1379[Start]
         if(TESTArray[TEST_ReconfigControl] & TEST_AbandonSRA )
         {
            gft_BlockSRA = FALSE;
         }
         //XDSLRTFW-1379[End]
         // proceed to Bit-Swap decision
         guc_RxDataFrameState = BIT_SWAP_DECISION;
      }
      break;

   case BIT_SWAP_DECISION:

      // run Bit-Swap decision algorithm
      if (guc_BitSwapState != BITSWAP_DONE)
      {
         RxBitswapHandler_VDSL2();

         //XDSLRTFW-647 BugFix_DS_ALL_ALL_BitSwapCaseTimeout (Start)
         //Copy the active bit/gain/EGT table to the inactive ones if they are not same
         //(Note: the inactive tables may be contaminated in the previous
         // unsuccessful bit-swap attemps).
         //If there is a timeout on RX-Bitswap, Inactive is reset only in the next Bit-Swap Init Cycle.
         //Where the inactive table is used for SNR CALC after a Bit-Swap Fail or pass when BITSWAP_DONE is set
         if( (guc_BitSwapState == BITSWAP_DONE) && (gus_RxBitSwapStatus & RX_BITSWAP_BGT_MISMATCH) )//XDSLRTFW-647
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, CopyRxBGT_ActiveToInactive);
         }
         //XDSLRTFW-647 BugFix_DS_ALL_ALL_BitSwapCaseTimeout (Stop)

      }
      else
      {
         // go to SNR/FDQ update state.
         guc_RxDataFrameState = SNR_FDQ_UPDATE;

         // prepare for the next round of Bit-Swap
         guc_BitSwapState = BITSWAP_INIT;
      }
      break;

   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void Load_SHOW_2_V2_SwapPage(void)
*
*   This function loads the SHOW_2_V2 swap page.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void Load_SHOW_2_V2_SwapPage(void)
{
   switch (gs_RxSubState)
   {

   case 0:
      FreeSwapHandle(&guc_PrimPageHandle);
      guc_RxSwapActivity = CODESWAP_LOAD(VDSL_SHOW_2_V2_PM_SWAPPAGE);
      gs_RxSubState = 1;
      break;

   case 1:
      // Wait for codeswap to complete
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         gus_ShowtimeControl |= MASK_SHOW_2_PAGE_LOADED;

         gs_RxSubState = STATE_MACHINE_DONE;
      }
      break;
   }

   switch (guc_RxSwapActivity)
   {

   case CODESWAP_LOAD(VDSL_SHOW_2_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_SHOW_2_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_SHOW_2_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_SHOW_2_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_SHOW_2_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
   }
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RxOLRPMHandler(void)
*
*   This function runs RX OLR and PM state machine.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void RxOLRPMHandler(void)
{
   switch (gt_RxOLRPMVars.uc_rxOLRPMState)
   {

   case OLR_RECV_SYNC_INDICATOR:

      if (gs_RxPMDFrameCount == RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         //Detect inverted synch symbol
         //Since REVERB == 0 and SEGUE == 1, so the sum of them should be 1
         if((gs_RxSyncToneType + gs_CurrRxSyncType) == 1)
         {
            gft_RxInvSynch = TRUE;
         }
         else
         {
            gft_RxInvSynch = FALSE;
         }

         // Check if inverted synch symbol received
         if (gft_RxInvSynch)
         {
            //Update the number of synch flag received
            gs_NumRxSynchFlags++;

            /* Update the sync signal type */
            gs_RxSyncToneType = !gs_RxSyncToneType;

            /* Sync indicator is received. Hence, don't wait for any HDLC message response */
            gta_TxEocControlInfo[0].ft_ack_expected = FALSE;

            /* change OLR state to Reconfigure */
            gt_RxOLRPMVars.uc_rxOLRPMState = OLR_RECONFIGURE;
            //    EnterFailStates(E_CODE_DEBUG_POINT1);
         }
         //EnterFailStates(E_CODE_DEBUG_POINT4);
      }
      break;

   case OLR_RECONFIGURE:

      // time to reconfigure cores
      if (gs_RxPMDFrameCount == gt_RxOLRPMVars.s_ReconfigSymCnt-2)
      {
         // Get ready to switch RX ping pong tables
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SwitchRxTableForBitswap);

         //Increase the bitswap actual performed counter
         Update_OLRPMCnt(&gt_DsOLRPMCnt, gta_TxEocControlInfo[0].uc_ExpectedMsgType, PERFORM_CNT);
      }

      break;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RxOLRPMHandler_FC(void)
*
*   This function runs RX OLR state machine after the FC run.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
void RxOLRPMHandler_FC(void)
{
   int16 s_TimeToReconfigLp;
   int16 s_path = gs_data_path;

   if ((gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_REQ)
         || (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ)) // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode
   {
      s_TimeToReconfigLp = gt_RxOLRPMVars.s_ReconfigSymCnt;
   }
   else
   {
      s_TimeToReconfigLp = gt_RxOLRPMVars.s_ReconfigSymCnt - 1;
   }

   if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECONFIGURE)
   {
      if (gs_RxPMDFrameCount == (s_TimeToReconfigLp))
      {
         // Update the actual Lp here
         if(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_Lp)
         {
            gt_rx_config_v2.ul_Lp[s_path] = gt_rx_config_v2.ul_Reconfig_Lp[s_path];
            gt_RxOLRPMVars.s_rxOLRPMEvent &= ~RECONFIG_Lp;
            // Update the showtime event based on the OLR performed
            if ((gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_REQ)
                  || (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ))  // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode
            {
               gus_DSShowtimeEvents = 0x2;      // Bit 1 set indicates an SRA event
               gs_SraNotEnableRejectionCnt = 0; // XDSLRTFW-4051 reset continuous SRA not enabled (0x3) rejection code counter
            }
            AddFunctionToBkgdFifo((PtrToBkgdFunc)UpdateRxRatesForSRA);
         }
      }

      if (gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt))
      {
         uint8 uc_ExpectedMsgType = gta_TxEocControlInfo[0].uc_ExpectedMsgType;
         // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode (START)
         if (gta_TxEocControlInfo[0].uc_ExpectedMsgType == SRA_RETX_REQ)
         {
            // Update the SRA perform count as per the location in gt_UsOLRPMCnt
            uc_ExpectedMsgType = SRA_REQ;
         }
         // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode (END)
         //Increase the bitswap actual performed counter
         Update_OLRPMCnt(&gt_DsOLRPMCnt, uc_ExpectedMsgType, PERFORM_CNT);
         // reset OLR & PM state and event
         gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
         gt_RxOLRPMVars.s_rxOLRPMEvent = 0;
         //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (Start)
         //Commenting out as INFO 68 in Msg Spec 1.8 does not have variable 'Line Rate'
         //gt_LineStatusDS.ul_LineRate = gul_RxLineRate;
         //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (End)
#ifdef TEST_VDSL_SRA
         gt_LineStatusDS.s_SnrMargin = gt_SnrMgnConfig.s_MINSNRMds+1;
#endif
//            AddFunctionToBkgdFifo((PtrToBkgdFunc)CalcBgtChecksum);
      }
   }
}

void UpdateRxRatesForSRA(void)
{
   int32 l_NetDataRate, l_OHRate;
   VDSL2ComputeRates_t t_ComputeRates;
   int16 s_Path;


   //XDSLRTFW-1478(START_END)
   //reinitialize the ADR and TDR after SRA
   t_DSRateInfo.ul_ADR=0;
   t_DSRateInfo.ul_TDR=0;

   // Set local variables
   s_Path                = gt_rx_config_v2.s_Nlp-1;
   t_ComputeRates.s_Nfec = gt_rx_config_v2.s_Nfecp[s_Path];
   t_ComputeRates.s_Rp   = gt_rx_config_v2.s_Rp[s_Path];
   t_ComputeRates.ul_Lp  = gt_rx_config_v2.ul_Lp[s_Path];
   t_ComputeRates.us_Gp  = gt_rx_config_v2.s_Gp[s_Path];
   t_ComputeRates.us_Mp  = gt_rx_config_v2.s_Mp[s_Path];
   t_ComputeRates.us_Tp  = gt_rx_config_v2.s_Tp[s_Path];
   t_ComputeRates.s_Path = s_Path;


   if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) && (s_Path == LP1))
   {
      //XDSLRTFW-1478(START)
      //Q28.4
      gt_ReTXStats.ul_ReTX_NDR = Calc_DsNDR_DsReTx(t_ComputeRates.s_Nfec, t_ComputeRates.s_Rp,
                                                   t_ComputeRates.ul_Lp, gt_FormFramingParamsInputs_v2.s_fs);
      l_NetDataRate = gt_ReTXStats.ul_ReTX_NDR;
      l_OHRate = 0;

      if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         // RRC part of ADR/TDR is taken care here!
         // Note: The RRC in downstream is only available when US ReTx is enabled.
         //       fs is in Q6.10 and kHz format, i.e. for m=5 -> ((4kHz * 256) << 10)/257 = 4080 (0xff0).
         //       fs = 4080/2^10 = 4080/1024 = 3.984375 kHz
         {
            uint32 ul_temp;

            ul_temp = ((uint32)US_RRC_BITS * gt_FormFramingParamsInputs_v2.s_fs);

            // The aggregate data rate in kbit/s: ADR = SUM(ADRp) + 12*fs
            // Note: For ADR only half of RRC gets be considered, i.e. additional rshift by one ( >> 1).
            t_DSRateInfo.ul_ADR += ((ul_temp + (1<<(FRAME_RATE_SHIFT_CNT-1+1))) >> (FRAME_RATE_SHIFT_CNT+1));
            // The total data rate in kbit/s: TDR = SUM(TDRp) + 24*fs, with TDRp = Lp *fs
            t_DSRateInfo.ul_TDR += (ul_temp + (1<<(FRAME_RATE_SHIFT_CNT-1)) >> FRAME_RATE_SHIFT_CNT);
         }

         // The aggregate data rate in kbit/s: ADRp = NDRp + OHRatep
         // Note: l_OHRate is in 28.4 format ==> convert back to Q32.0!!
         //       This function gets called with LP1 only if DS ReTx enabled ==> OH rate of previous added.
         t_DSRateInfo.ul_ADR += (t_DSRateInfo.ul_OHRate[LP0] >> 4);
      }
      //XDSLRTFW-1478(END)
   }
   else
      //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (End)
   {
      ComputeRates(t_ComputeRates.ul_Lp, t_ComputeRates.s_Nfec, t_ComputeRates.s_Rp,
                   t_ComputeRates.us_Gp, t_ComputeRates.us_Mp, t_ComputeRates.us_Tp,
                   gt_FormFramingParamsInputs_v2.s_fs, &l_OHRate, &l_NetDataRate);
   }

   //XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop (Start)
   //l_NetDataRate = (l_NetDataRate + 8)/16
   // convert NDR in Q28.4 to in unit of kbps
   //XDSLRTFW-572 : NewFeature_ALL_ALL_ALL_RateIn1Kbps(Start)
   l_NetDataRate = (l_NetDataRate + (1 << 3)) >> 4;
   //XDSLRTFW-572 : NewFeature_ALL_ALL_ALL_RateIn1Kbps(Stop)
   //XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop (End)

   //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start)
   t_DSRateInfo.t_CurRate[s_Path].us_RateLSW = l_NetDataRate & 0xFFFF;
   t_DSRateInfo.t_CurRate[s_Path].us_RateMSW = l_NetDataRate >> 16;
   //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)

   //XDSLRTFW-1478(START)
   // The aggregate data rate in kbit/s: ADRp = NDRp + OHRatep
   // Note: l_OHRate is in 28.4 format ==> convert back to Q32.0!!
   t_DSRateInfo.ul_ADR += (l_NetDataRate + (l_OHRate>>4));
   // The total data rate in kbit/s: TDRp = Lp * fs
   t_DSRateInfo.ul_TDR += (((t_ComputeRates.ul_Lp * gt_FormFramingParamsInputs_v2.s_fs) +
                            (1 << (FRAME_RATE_SHIFT_CNT-1))) >> FRAME_RATE_SHIFT_CNT);
   t_DSRateInfo.ul_OHRate[s_Path] = l_OHRate;
   //XDSLRTFW-1478(END)
}

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

#ifdef DEBUG_TRACES
void TriggerEventLp(void)
{
   // Write OLR Event into debug buffer
   {
      int16 s_MsgRaw[3];
      uint32 ul_data;

      s_MsgRaw[0] = (uint16)gt_rx_config_v2.ul_Reconfig_Lp[gs_data_path];
      s_MsgRaw[1] = (uint16)gt_rx_config_v2.ul_Lp[gs_data_path];

      ReadCoreReg((uint32)IRI_QT_REG_RX_LP0_BITS_ADDR, &ul_data);
      s_MsgRaw[2] = (int16)ul_data;

      DebugBuffWriteEv(DEBUG_EVT_OLR_LP, sizeof(s_MsgRaw), s_MsgRaw);
   }
}


void TriggerEventOlrHandler(void)
{
   // Write OLR Event into debug buffer
   {
      int16 s_MsgRaw[3];
      uint32 ul_data;

      s_MsgRaw[0] = (int16)gus_RxBitSwapStatus;
      s_MsgRaw[1] = (int16)guc_BitSwapState;

      ReadCoreReg((uint32)IRI_QT_REG_RX_LP0_BITS_ADDR, &ul_data);
      s_MsgRaw[2] = (int16)ul_data;

      DebugBuffWriteEv(DEBUG_EVT_OLR_HANDLER_INFO, sizeof(s_MsgRaw), s_MsgRaw);
   }
}

void CalcBgtChecksum(void)
{
   if((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData & SHOW_TIME_EVENT_DISABLE_MASK) == 0)
   {
      // Active table
      {
         uint8 uc_Bi;
         uint16 us_Tone, us_NumTones;
         uint16 us_Num1bitTones, us_NumLoadedTones, us_SumBiActive;
         uint16 CrcActiveBgt = 0xffff;
         uint32 ul_data;

         int16 s_ActiveTblOffsetRx;
         uint32 *pula_Bat;
//         T_DebugBuffEvt *pEvtTraceBuf = &gt_DebugBuff.tDebugBuffEvt;

         s_ActiveTblOffsetRx = gs_RxAbgtOffset;
         pula_Bat = (uint32*)(void *)ghpuca_RxBat_Active; // GetActiveBGTNTableAddress()

         ReadCoreReg(IRI_QT_REG_RX_ACTIVE_ADDR, &ul_data);
         us_NumTones = (ul_data >> 16);
         pula_Bat += (ul_data & 0xFFFF);
         pula_Bat += s_ActiveTblOffsetRx;

         us_SumBiActive = 0;
         us_Num1bitTones = 0;
         us_NumLoadedTones = 0;
         for (us_Tone = 0; us_Tone < us_NumTones; us_Tone++)
         {
            uc_Bi = (uint8)(((*pula_Bat) & 0xf000) >> 12);
//            pEvtTraceBuf->aEvtTraceBuf[30].aPayload[us_Tone] = uc_Bi;
            if(uc_Bi > 0)
            {
               us_SumBiActive += uc_Bi;
               us_NumLoadedTones++;
//               CrcActiveBgt = calcCrc16(CrcActiveBgt, uc_Bi);
            }
            else if(uc_Bi == 1)
            {
               us_Num1bitTones++;
            }
            pula_Bat++;
         }
         // Write OLR Event into debug buffer
         {
            int16 s_MsgRaw[3];

            s_MsgRaw[0] = (int16) us_SumBiActive;
//            s_MsgRaw[1] = (int16) CrcActiveBgt;
            s_MsgRaw[1] = us_Num1bitTones;
            s_MsgRaw[2] = us_NumLoadedTones;

            DebugBuffWriteEv(DEBUG_EVT_RX_BGT_OLR_ACTIVE, sizeof(s_MsgRaw), s_MsgRaw);
         }
      }

      // Inactive table
      {
         uint8 *puc_BatEntry;
         uint8 uc_Bi;
         uint16 us_Tone, us_Band;
         uint16 us_NumLoadedTones, us_SumBiInactive;
         uint16 CrcInactiveBgt = 0xffff;

         int16 s_NumBands;
         int16 *ps_LeftTone, *ps_RightTone;
         uint8 *puca_Bat;

         s_NumBands = gs_NumOfRxBands;
         ps_LeftTone = &gsa_BitloadLeftChannel[0];
         ps_RightTone = &gsa_BitloadRightChannel[0];
         puca_Bat = ghpuca_RxBat_Inactive;

         us_SumBiInactive = 0;
         us_NumLoadedTones = 0;
         for (us_Band = 0; us_Band < s_NumBands; us_Band++)
         {
            puc_BatEntry = puca_Bat+ps_LeftTone[us_Band];

            for (us_Tone = ps_LeftTone[us_Band]; us_Tone <= ps_RightTone[us_Band]; us_Tone++)
            {
               uc_Bi = *puc_BatEntry++;
               if(uc_Bi > 0)
               {
                  us_SumBiInactive += uc_Bi;
                  us_NumLoadedTones++;
                  CrcInactiveBgt = calcCrc16(CrcInactiveBgt, uc_Bi);
               }
            }
         }
         // Write OLR Event into debug buffer
         {
            int16 s_MsgRaw[3];

            s_MsgRaw[0] = (int16) us_SumBiInactive;
            s_MsgRaw[1] = (int16) CrcInactiveBgt;
            s_MsgRaw[2] = (int16) us_NumLoadedTones;

            DebugBuffWriteEv(DEBUG_EVT_RX_BGT_OLR_InACTIVE, sizeof(s_MsgRaw), s_MsgRaw);
         }
      }
   }
}
#endif

/*
*-------------------------------------------------------------------------------
*
*   Prototype: uint8 DetectSEF(int CurrRxSyncType)
*
*   This function runs SEF detection and returns the SEF State (TERMINATED or PRESENT).
*
*   Input Arguments: int16 CurrRxSyncType
*
*   Output Arguments:
*
*   Returns: uc_sef_Defect_State
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
uint8 DetectSEF(int16 CurrRxSyncType)
{
   uint8 uc_sef_Defect_State;
   uint8 uc_sef_Defect_Ind;
   int16 s_SefTransition;

   // initialization for Event Debug
   s_SefTransition = 0;

   // Sync symbol evaluation to derive SEF indication
   // Note: One SEF must be ignored due to OLR inverted synch symbol
   uc_sef_Defect_Ind = FALSE;
   if(CurrRxSyncType != gs_RxSyncToneType)
   {
      uc_sef_Defect_Ind = TRUE;
   }

   guc_SefHistory = ((guc_SefHistory << 1) | uc_sef_Defect_Ind);
   uc_sef_Defect_Ind = (guc_SefHistory & 0x03);

   // SEF indication
   uc_sef_Defect_State = gt_TxIbData.uc_sef_def;
   switch(uc_sef_Defect_State)
   {
   case TERMINATED: // Terminated SEF

      if(uc_sef_Defect_Ind == 0x03)
      {
         // Present SEF
         uc_sef_Defect_State = PRESENT;
         //increase near-end SEF defect counter
         gul_NeSefDefectCounter++;

         // if SEF state changes, then set SefTransition variable to appropriate logging delimitter
         s_SefTransition = (int16)DEBUG_TRAIL_SHOW_EVENTS_NE_SEF_DEF_ON;
      }

      break;

   case PRESENT: // Present SEF

      if (uc_sef_Defect_Ind == 0x00)
      {
         // Terminated SEF
         uc_sef_Defect_State = TERMINATED;

         // if SEF state changes, then set SefTransition variable to appropriate logging delimitter
         s_SefTransition = (int16)DEBUG_TRAIL_SHOW_EVENTS_NE_SEF_DEF_OFF;
      }
      break;
   }

#ifdef DEBUG_TRAIL
   //log SEF to debug buffer
   if ((gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_ENABLE) &&
         (s_SefTransition != 0))
   {
      DebugTrail1(4,DEBUG_TRAIL_SHOWTIME_EVENTS_ENABLE,0,
                  (int16)s_SefTransition,
                  (int16)gl_RxSymbolCount,
                  (int16)(gl_RxSymbolCount>>16),
                  (int16)((guc_SefHistory<<8)|(CurrRxSyncType & 0xFF)));
   }
#endif // DEBUG_TRAIL

   return(uc_sef_Defect_State);
}


#ifdef PILOT_TONE_LOS_DETECT

void DetectLOS(void)
{
   int32 l_Pow;
   int16 s_LosTransition;
   uint8 uc_los_def;

   //Compute the pilot tone power
   //l_Pow = PilotTone_Re*PilotTone_Re + PilotToneIm*PilotToneIm
   l_Pow = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Re*gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Re + gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Im *gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Im ;

   //XDSLRTFW-2527 (Start)
   // Amplify pilot tone amplitude square in case FW detects low pilot tone power. See the comment below.
   if (guc_RxPwrIndicator & LOW_RX_PILOT_TONE_POWER)
   {
      l_Pow = l_Pow << gc_log2_num_syms_for_avg;
   }
   //XDSLRTFW-2527 (End)

   switch(guc_LosDefect_state)
   {

   case LOS_INIT:

      gl_AvgPilotPow_Thresh = 0;
      gs_LosDefect_state_cnt = 0;
      gc_log2_num_syms_for_avg = LOG2_NUM_SYMS_FOR_DETECT + gs_frame_rate_is_8khz;
      gs_num_syms_for_avg = NUM_SYMS_FOR_DETECT << gs_frame_rate_is_8khz;

      guc_LosDefect_state = LOS_SETUP;

      break;

   case LOS_SETUP:

      //Compute the average pilot tone power
      gl_AvgPilotPow_Thresh += (l_Pow>>LOG2_NUM_SYMS_FOR_THRESH);
      gs_LosDefect_state_cnt++;

      if(gs_LosDefect_state_cnt == NUM_SYMS_FOR_THRESH)
      {
         //Set the threshold to be 6 dB below the average pilot tone
         gl_AvgPilotPow_Thresh >>= 2;

         gl_AvgPilotPow = 0;
         gs_LosDefect_state_cnt = 0;
         //XDSLRTFW-2527 (Start)
         //Corner case : if l_Pow (pilot tone amplitude square) gives only 9 bit (512) or less value
         //then gl_AvgPilotPow_Thresh value will be "zero" or misleading!
         //Whenever FW detects this kind of situation, FW simply amplify pilot tone amplitude square (l_Pow) by 512 or 1024.
         //Since this variable is 32bit long, it should not face any overflow issue.

         if (( (guc_RxPwrIndicator & LOW_RX_PILOT_TONE_POWER) != LOW_RX_PILOT_TONE_POWER) && (gl_AvgPilotPow_Thresh < 128))
         {
            guc_RxPwrIndicator |= LOW_RX_PILOT_TONE_POWER;
            gl_AvgPilotPow_Thresh = 0;           // discard old calculation
            guc_LosDefect_state =  LOS_SETUP;   // repeat threshold calculation with new amplified value
         }
         else
         {
            guc_LosDefect_state = LOS_DETECT;
         }
         //XDSLRTFW-2527 (End)
      }
      break;

   case LOS_DETECT:

      //Compute the average pilot tone power
      gl_AvgPilotPow += (l_Pow>>gc_log2_num_syms_for_avg);
      gs_LosDefect_state_cnt++;

      if(gs_LosDefect_state_cnt == gs_num_syms_for_avg)
      {

         if(gl_AvgPilotPow < gl_AvgPilotPow_Thresh)
         {
            uc_los_def = PRESENT;
         }
         else
         {
            uc_los_def = TERMINATED;
         }

         // Override the LOS defects for debug purposes
         if (gs_LOS_override_cnt > 0)
         {
            uc_los_def = PRESENT;
            if(gs_LOS_override_cnt > 0)
            {
               gs_LOS_override_cnt--;
            }
         }

         s_LosTransition = 0;
         if (uc_los_def == PRESENT)
         {
            // if LOS state changes, then set LosTransition variable to appropriate logging delimitter
            if (gt_TxIbData.uc_los_def == TERMINATED)
            {
               s_LosTransition = (int16)DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_DEF_ON;
            }

            gt_TxIbData.uc_los_def = PRESENT;
         }
         else
         {
            // if LOS state changes, then set LosTransition variable to appropriate logging delimitter
            if (gt_TxIbData.uc_los_def == PRESENT)
            {
               s_LosTransition = (int16)DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_DEF_OFF;
            }

            gt_TxIbData.uc_los_def = TERMINATED;

            // the FE LPR "Dying Gasp" defect is set based on the received indicator bit.
            // The FE LPR Failure is defined as a FE LPR defect followed by a NE LOS Failure.
            // So the FE LPR defect is cleared here if the NE LOS is not detected
            // The gs_FeLprLosDelay is used to delay the check of the LOS in order
            // to give the LOS processing time to recognize the dropped link

            if (gs_FeLprLosDelay > 0)
            {
               gs_FeLprLosDelay--;
            }
            else
            {
               gt_RxIbData.uc_flpr_def = TERMINATED;
            }
         }

#ifdef DEBUG_TRAIL
         //log LOS to debug buffer
         if ((gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_ENABLE) &&
               (s_LosTransition != 0))
         {
            DebugTrail1(7,DEBUG_TRAIL_SHOWTIME_EVENTS_ENABLE,0,
                        (int16)s_LosTransition,
                        (int16)gl_RxSymbolCount,
                        (int16)(gl_RxSymbolCount>>16),
                        (int16)gl_AvgPilotPow,
                        (int16)(gl_AvgPilotPow>>16),
                        (int16)gl_AvgPilotPow_Thresh,
                        (int16)(gl_AvgPilotPow_Thresh>>16));
         }
#endif // DEBUG_TRAIL

         //Reset for the next period of NUM_SYMS_FOR_AVG
         gl_AvgPilotPow = 0;
         gs_LosDefect_state_cnt = 0;
      } //if(gs_LosDefect_state_cnt == NUM_SYMS_FOR_AVG)

      break;
   }

} //uint8 DetectLOS(void)
#endif //#ifdef PILOT_TONE_LOS_DETECT

//XDSLRTFW-2577 (Start)
void InitDsReTxForSra_VDSL2(void)
{
   int32 i;
   ReTX_Params_t *pt_ReTXParams = &gt_ReTXParams;
   QueueNode_t *pt_NodeList = gt_NodeList;

   gt_RrcStat.ull_64MostRecentDtuStats = 0;
   gt_RrcStat.ft_RrcStatUpdated = 0;
   //gt_RrcStat.ul_PrevRrc = 0; //Sooraj
   // AbsDtuCnt is set to 0x1F so that upon the first DTU received
   // in showtime, it will be incremented to 0
   gt_RrcStat.uc_AbsDtuNum = 0x1F;

   //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
   gt_ReTXStats.ul_ReTX_ReceiverETR = gt_ReTxShowtimeParams.ul_ReTX_ReceiverETR;

   pt_ReTXParams->uc_RPMS_Qtx = gt_ReTxShowtimeParams.uc_RPMS_Qtx;

   pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q = gt_ReTxShowtimeParams.uc_CWsPerDtu_Q;
   pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_DtuPaddingSize_V = gt_ReTxShowtimeParams.uc_DtuPaddingSize_V;

   pt_ReTXParams->uc_RPMS_DsLookBackValue = MIN(31, pt_ReTXParams->uc_RPMS_Qtx);

   pt_ReTXParams->uc_Qrx = gt_ReTxShowtimeParams.uc_ReTXQueueSize_Qrx_SIZE;
   //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)


   /* Init of Free buffer list */
   for (i = 0; i < ILVB_WRPTR_TABLE_SIZE_LW; i++) {
      pt_NodeList[i].uc_NextNode = 0xFF;
      pt_NodeList[i].uc_Indx = i;

      //Add first four buffers to ILVB Write Pointer table.
      guca_InpBufList[i] = i;
   }


   if(gft_Intra_DTU_Ilv_DS == FALSE)
   {
      //XDSLRTFW-1030: SRAds_Support_with_DS_ReTx (START)
      WriteCoreReg(ZEP_PRAM_ZR_ILV_CNTRS0_LP1_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZR_ILV_PMS_CNTRS0_LP1_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZR_ILV_PMD_CNTRS0_LP1_ADDR, 0);

      ConfigZephyrFcRxPath_VDSL2();
      LoadRxZepMicroCode();
      ConfigZephyrIlvRxPath_VDSL2();
      //XDSLRTFW-1030: SRAds_Support_with_DS_ReTx (END)
   }
   else
   {
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         //XDSLRTFW-3339 (Start)
         ConfigZephyrFcRxPath_VDSL2();
         //Initialize Framing processors internal state
         LoadRxZepMicroCode();
         ConfigZephyrIlvRxPath_VDSL2();
         WriteCoreReg(ZEP_PRAM_ZR_DTB_PTRS_LP1_ADDR, 0);
         //Need to reinitialize Fullness counter of ILV0 & ILV1
         WriteCoreReg(ZEP_PRAM_ZR_ILV_FULLNESS0_LP1_ADDR,0);
         WriteCoreReg(ZEP_PRAM_ZR_ILV_FULLNESS1_LP1_ADDR,0);
         //XDSLRTFW-3339 (End)
      }
      else
      {
         ConfigZephyrFcRxPath_VDSL2();
         ConfigZephyrIlvRxPath_VDSL2();
         //Resetting of DTB PTR is required for every SRA at
         //gs_RxPMDFrameCount == gt_RxOLRPMVars.s_ReconfigSymCnt) and QT wr ptr
         //resetting is required at (gs_RxPMDFrameCount == gt_RxOLRPMVars.s_ReconfigSymCnt-1)
         WriteCoreReg(ZEP_PRAM_ZR_DTB_PTRS_LP1_ADDR, 0);
      }
   }
}

void InitDsReTxForSra_VDSL2_NTC(void)
{
   ReTX_Params_t *pt_ReTXParams = &gt_ReTXParams;
   QueueNode_t *pt_NodeList = gt_NodeList;
   int32 i;

   memset(gta_QretxTable, 0, sizeof(QretxTableEntry_t)*QRETX_TRANS_TABLE_SIZE);
   for (i = 0; i < QRETX_TRANS_TABLE_SIZE; i++)
   {
      gta_QretxTable[i].uc_Stat = EMPTY_DTU;
      //XDSLRTFW-1383 (Start_End)
      gta_QretxTable[i].uc_DTU_idx = EMPTY_DTU;
   }

   //XDSLRTFW-1383 (Start)
   //XDSLRTFW-1393 (Start)
   guc_Prev_Rd_SID = 0;
   guc_Prev_Rd_DTU_idx = 0;
   guc_Prev_Rd_SID_idx = 0;
   //XDSLRTFW-1383 (End)

   guc_Wr_SID_idx = (QRETX_TRANS_TABLE_SIZE-1);
   guc_Rd_SID_idx = (QRETX_TRANS_TABLE_SIZE-1);
   guc_Curr_Wr_DTU_idx = 0;

   gta_QretxTable[guc_Wr_SID_idx].uc_SID = (SID_MODULO - 1);
   gta_QretxTable[guc_Rd_SID_idx].uc_SID = (SID_MODULO - 1);

   gft_Qrx_Full = FALSE;
   gft_SRAInvSync_Detected = FALSE;
   gft_DTU_Stoppage_Detected = FALSE;
   gft_Start_DTU_Stoppage_Detection = FALSE;
   guc_DTU_Stoppage_Detect_Cntr = 0;
   guc_DTU_Status_Arr_Indx = 0;
   memset(gt_DTU_Status_Arr, 0, sizeof(DTU_Status_t)*(63+1));//Max QTx => 63 (Table A.6 of G.998.4 (G.Inp) standard)
   //XDSLRTFW-1393 (End)



   for (i = ILVB_WRPTR_TABLE_SIZE_LW; i < ((pt_ReTXParams->uc_Qrx)-1); i++) {
      gt_NodeList[i].uc_NextNode = i+1;
      gt_NodeList[i].uc_Indx = i;
   }
   gt_NodeList[i].uc_NextNode = 0xFF;
   gt_NodeList[i].uc_Indx = i;

   //First four buffers will be added to ILVB Write Pointer table. Rest will be in the free buffer list.
   gt_FreeBufList.uc_NumNodes = (pt_ReTXParams->uc_Qrx-ILVB_WRPTR_TABLE_SIZE_LW);
   gt_FreeBufList.uc_Head = ILVB_WRPTR_TABLE_SIZE_LW; //Head points to the 5th Node.

   /* Init of Input Buffer list */
   guc_InpBufListIndx = 0;
   //XDSLRTFW-1571 (End)




}
//XDSLRTFW-2577 (End)
