/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ShowtimeRxTC_VDSL2.c
*
*   This file contains VDSL2 Time-Critical (TC) functions for RX showtime processing.
*
* Change: S N VENKATESH 29/06/2012
* Issue: ReTx Sequence number Issue with More than 1 DTU
* DS_RETX_SEQUENCE_NUM_ADSL_MERGE
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// ShowtimeRxTC_VDSL2.c
//
// History
//
// 05/3/2013 Vinjam: Report Delay in 0.01 milli seconds granularity to the near-end
//           Grep for XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//       Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//      - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//      - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
// 19/09/2013 Varun/Palaksha/Ram : Added new CMV INFO 238 0 ==> gives the Max mips count(Foregraound + Tc task) in showtime if test 0 0 is 0x1000
//                    Note that in VDSL Rx enters showtime first(look timing diagram of VDSL2 for more details). since we want showtime mips when both tx
//                    and rx in showtime we enable the profile tasking when tx enters showtime. foreground mips peaking occurs at tx in RPSynchro6 state.
//                    Hence condition is checked in foreground in showtime. Following additional improvements done
//                  - Added FG Task Averege MIPS profiling
//                  - Added a optimisation code to reduce the RxTc Mips
//                     Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
//
// 11/10/2013 Ram: 1. Added code to achieve Zero packet loss in ReTx mode.
//                   Issue:
//                   Uncorrected DTUs and hence Packet loss is seen during ReTx testing. Microcode or
//                   HW writes into QRx queue in circular mode. DTUs are lost or received in error
//                   due to noise. QRx queue is also used as Re-ordering buffer. When a particular
//                   DTU (say SID 100) is not received correctly (due to noise) even after a few
//                   retransmissions, QRx queue becomes full and there is no more memory left to
//                   receive new DTUs. Since no memory is left, we cannot take DTU with SID 100 even
//                   though it has been received correctly. QRx queue would be free again only after
//                   we time out on DTU with SID 100, thus leading to uncorrected DTUs. Due to
//                   uncorrected DTUs we have packet loss.
//
//                   Fix:
//                   Uncorrected DTUs can be avoided if we can take in new DTUs (received correctly
//                   without error) even on Q-Full condition. To achieve this, we allocating 4 more
//                   buffers (over and above the current requirement of Min_QRx = QTx+3) to QRx. When
//                   there are < 7 buffers available, FW declares Q-Full but would not inform to
//                   Microcode/HW. If informed, HW would not give any more DTUs to FW. Thus, Q-Full
//                   condition is entirely handled by FW. Once is Q-Full, FW checks if the newly
//                   received good DTU corresponds to the Expected DTU (e.g. SID 100). If newly
//                   received DTU/SID == Expected DTU/SID, Q-Full condition is removed. Else, FW
//                   resets the Queue pointers (ZEP_PRAM_ZR_OHRATE_LP1_ADDR, ZEP_PRAM_ZR_CRC1_LP1_ADDR)
//                   to their corresponding position when Q-Full was observed. By resetting (or moving
//                   back) the pointers, we are essentially proving space for new DTUs in QRx.
//
//                   + ZEP_PRAM_ZR_OHRATE_LP1_ADDR => Points to the end of newly written DTU
//                   + ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR => Actual Queue write pointer. Typically this
//                     is greater than ZEP_PRAM_ZR_OHRATE_LP1_ADDR due to "partial DTU" received in
//                     each symbol.
//                   + ZEP_PRAM_ZR_CRC1_LP1_ADDR => Indicates 'Repeat Counter', used by Microcode to
//                     handle Queue wraparound condition. After a new DTU is written to QRx queue and
//                     before writing 'Partial DTU', Microcode checks if Repeat_Counter == QRx_Size.
//                     If yes, then queue write pointer ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR is reset to
//                     QRx queue base address (ZEP_PRAM_ZR_RETX_PARAM3_LP1_ADDR), thus achieving
//                     wrap around.
//
//                   After resetting Queue pointers, FW will also have to copy the 'Partial DTU' present
//                   in queue (received along with new DTU) to newly reset position.
//
//                   Before pointers are reset:
//                   a) Starting Address of Partial DTU => ZEP_PRAM_ZR_OHRATE_LP1_ADDR
//                   b) Ending Address of Partial DTU => ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR
//                   b) Size of Partial DTU => ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR - ZEP_PRAM_ZR_OHRATE_LP1_ADDR
//
//                   After ZEP_PRAM_ZR_OHRATE_LP1_ADDR is reset to Original (Q-Full position) position,
//                   Partial DTU is copied to the location pointed by it.
//
//                   Grep for XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode
//
// 23/10/2013 Ram/Palaksha:
//                 delay_act_RTX being computed (and reported in CMV RATE 2) is not according to sec 11.2.5 of
//                    G.998.4 (G.Inp) standard. Hence commented the code. It is now being computed in
//                    RtxFramingVdsl_V1() in file FramingGenLp1.c
//
//                    Grep for XDSLRTFW-1227: BugFix_DS_VDSL2_ALL_InCorrect_ReTX_Delay
//
// 18/10/2013 Ram: Fix for JIRA XDSLRTFW-1323. Added check in func GetDTUQStat() and UpdateDTUQStat()
//                 to prevent memory corruption.
//                 Grep for XDSLRTFW-1323: BugFix_DS_VDSL2_ALL_STLinkDrop_KPNTestCase
//
// 28/10/2013 Ram: 1. To handle QFull condition at higher NDR we need atleast 10 free buffers. Hence
//                    min QRx=QTx+12 (i.e. DSRETX_MIN_DTUs_REQOVERQTX is set to 12).
//                    Grep for XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR
//
//                 2. Added code to drop the already received DTU, when guc_Wr_SID_idx has finished
//                    one complete circle (across 192 nodes) and still guc_Rd_SID_idx has not yet
//                    forwarded received DTU to PPE/TPS-TC layer. This case is seen when GHS tones
//                    are added as RFI in Showtime (this noise results in lots of consecutive
//                    BAD DTUs and some occasional good DTUs).
//                    Grep for XDSLRTFW-1318: BugFix_DS_VDSL2_ALL_ReTx_Showtime_LinkDrop_With_GHSRFI
//
// 12/06/2015 Kannan: Implemented Cascaded FW scheduling for 35b lite project to modify FFT output
//                    Grep for "XDSLRTFW-2392 Cascaded scheduling"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with DS Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2162".
// 07/12/2016 XDSLRTFW-3015 SHINE protection lower than reported : it is a PLL issue!
//            i. Pilot tone phase error saturation value while external noise detected was 1 degree.
//               When long SHINE noise comes, sometime it deviated the pilot tone phase in a way that
//               SHINE noise pulse appeared longer in Rx Path than the original SHINE pulse. As a result,
//               in some corner cases ( eg. SHINE protection 58 DMT symbol, SHINE noise 56 DMT symbol),
//               SHINE protection did not work well. To solved this issue, new pilot tone phase saturation values are introduced.
//
//           ii a. On very short loops, with low power SHINE pulses ( eg. 10 dB more than the background  noise),
//                 external noise detection threshold was not optimum.
//           ii b. On very long loops, where the DS data rates are < 5Mbps and Max Erasure Metric in Showtime is around 10, fixed threshold
//                 for noise detection logic may lead false external noise detection in case of margin verification test.
//                 To solve this issue, new noise detection threshold logic is introduced.
//
//              Grep for: XDSLRTFW-3015
//
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"
#include "show_iof.h"
#include "show_lpbk_iof.h"
#include "profile.h"
#include "OvhdMsg_IOf.h"
#include "V_STR_IOf.h"
#include "IRI_Iof.h"
#include "cri_iof.h"
#include "mtkernel.h"
#include "cri_memmap.h"
#include "LL_IOf.h"
#include "DDSnrFdqHandler.h"
#include "vdsl_xception.h"
#include "Cri_iof.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif //PPE_ENGINE

#ifdef DISTRIBUTE_TX_RX_PROCESS
#include "cri_iof.h"
#endif // DISTRIBUTE_TX_RX_PROCESS

//#ifdef MTK_VECTORING_SUPPORT
#include "FormRErrorFeedbackMsg_VDSL2.h"
#include "eoc.h"
#include "ShowtimeERBHandler.h"
//#endif
#include "Us_Rtx.h"
#include "Dsp_regs_62.h"


#include "DshInterface.h"

extern void CaptureRxBitsInFifo(void);
extern void ComputeRxDataTransferSize(void);
void Calculate_DiscardFrame_Threshold(void);
void CheckZepSTAT_Rx_PMSRegs(void);
void  DtbPingPongConfiguration(void);

#include "zep_memmap_cnfg.h"

//XDSLRTFW-1383 (Start)
#define USE_DMA_FOR_MEMCPY   (1)

extern void SetUpDMATransfer(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr,
                             uint32 ul_DspAdmaCtrl_FillMask, int32 ul_FillValue,
                             uint16 us_WaitForDMAComplete);
//XDSLRTFW-1383 (End)

extern void SetUpDMATransfer1(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr,
                              uint32 ul_DspAdmaCtrl_FillMask, int32 ul_FillValue,
                              uint16 us_WaitForDMAComplete);
extern uint16 CheckAdmaCompletion(void);


//XDSLRTFW-1393 (Start_End)
extern void InitDsReTxForSra_VDSL2(void);

uint32 SetUpZrFifo(int32 l_Fifo_n, int32 l_LP_n);
uint32 ReadZRFifo(int32 l_Fifo_n, int32 l_LP_n, uint8 *puc_DataByte);

void ForwardDtusToPPE(void);
void UpdateDsRrcStat(void);
uint8 UpdateQretxTable(uint8 uc_DtuStat, uint8 uc_NewSID, uint8 uc_TS, uint8 uc_DtuIndex);

FlagT InModZRange(uint16 us_Point, uint16 us_LowerBound, uint16 us_UpperBound, uint16 us_Modulo);
uint8 ModXIncrY(uint16 us_Input, uint16 us_Offset, uint16 us_Modulo);
//XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
uint8 CalcSIDidx(uint16 us_RefSID_idx, uint16 us_RefSID, uint16 us_NewSID);

void SetUpDtuForwarding(void);
void CheckQrxOverflow(void);

FlagT gft_AlwaysSendAckToCO = FALSE;

//XDSLRTFW-3493(Start)
int16 gs_dbg_MAX_RX_LOOP_COUNT = 2400;   //72000/30 = 2400
//For 35B with iDTU Rx Zephyr is allowed to consume upto 58000 cycles
//and the DSP Rx TC task can go upto 14000.
//For testing 66K cycles was set and MAX_RX_PMS_ALLOWED_CYCLES needs to rechecked.
uint32 gul_dbg_MAX_RX_PMS_ALLOWED_CYCLES = 66000;
//XDSLRTFW-3493(End)

extern RRC_Stat_t gt_RrcStat;
extern ReTX_Params_t gt_ReTXParams;
extern ReTX_Stats_t gt_ReTXStats;
extern QretxTableEntry_t gta_QretxTable[];
extern int32 __gla_ZrIlvbRdPtrTable[];

extern uint32 gul_RxTimer_RxQTDone;
extern uint32 gul_RxTimer_TxQTDone;
extern uint32 gul_TxTimer_TxQTDone;

//#ifdef VRX518_LOG_DEBUG_INFO
extern uint32 *gpl_IriMetric; // = (uint32 *) 0x386468;
extern uint16 gus_dbg_LogControl;
extern int16  gs_start_QTdone_Log;
extern int16  gs_QTdone_LogIdx;
extern FlagT   gft_StopLog;

extern int16   gs_dbg_LogContCount;
extern int16   gs_dbg_QTMetricThresh;
extern int16   gs_dbg_ContLowMetricCounter;
extern int16   gs_dbg_LowMetricThreshCount;
extern uint32  gul_dbg_fec_count;
extern uint16  gus_dbg_LowestMetric;

//extern uint32 *gpul_QT_Done;
//#endif
extern uint8 guc_Wr_SID_idx;
extern uint8 guc_Rd_SID_idx;
extern uint8 guc_EstimatedTS;
extern FlagT gft_ForwardDtusToPPE;

//extern int32 gl_RxHalt;
//    extern int32 gl_RxSymbolCount;
extern FlagT gft_NotFirstDTU;
extern uint8 guc_ReTX_CRC1_ReportTS;
extern uint16 gus_ReTX_crc1;
extern uint8 guc_Curr_Wr_DTU_idx;
extern uint8 guc_Prev_Rd_SID_idx;
//XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start)
extern uint8 guc_Prev_Rd_SID;
extern uint8 guc_Prev_Rd_DTU_idx;

extern FlagT gft_PauseOff;
//XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (End)

extern uint32 gul_RxQTP_NotDone;

extern int32 gl_RxQT_MaxTime;
extern int32 gl_RxQT_MinTime;

//TODO: Dump RX DTB buffer
   #define DTB_BASE_ADDR   (0x344000)

   #define ZT_DTB_CTRL     (ZEP_REG_ZT_DTB_CTRL_ADDR)
   #define ZT_DTB_PTRS     (ZEP_REG_ZT_DTB_PTRS_ADDR)
   #define ZT_DTB_OFFSET   (ZEP_REG_ZT_DTB_OFFSET_ADDR)

   #define ZR_DTB_CTRL     (ZEP_REG_ZR_DTB_CTRL_ADDR)
   #define ZR_DTB_PTRS     (ZEP_REG_ZR_DTB_PTRS_ADDR)
   #define ZR_DTB_OFFSET   (ZEP_REG_ZR_DTB_OFFSET_ADDR)

extern uint32 gul_RxDTBSize;
extern uint32 gul_RxDTBBase;
extern uint32 gul_RxDTBOffset;
extern uint32 gul_DTBRdPtr;
extern uint32 gul_DTBWrPtr;
extern uint32 gul_PrevDTBWrPtr;
extern uint32 gul_PrevDTBRdPtr;
extern uint16 gus_StopDump;
extern uint16 gus_DTBBufIdx;
extern uint8 *gpuc_DTBBuf;
extern uint16 gus_DTBBufSize;
extern uint16 gus_WrapAround;
void UpdateNTR(void);
//TODO: Dump RX DTB buffer
void DumpRxDTBBuf(void)
{
   if (gus_StopDump == 0)
   {
      uint32 ul_temp = 0;
      int32 l_cpsize1 = 0;
      int32 l_cpsize2 = 0;
      uint8 *temp_ptr = NULL;

      ul_temp = *(uint32 *)ZR_DTB_OFFSET;
      gul_RxDTBOffset = ((ul_temp) & (0x0FFF)) * 4; //in bytes

      ul_temp = *(uint32 *)ZR_DTB_CTRL;
      gul_RxDTBBase = ((ul_temp) & (0x0FFF)) * 4; //in bytes
      gul_RxDTBSize = ((((ul_temp) & (0x0FFF0000)) >> 16)+1) * 4; //Size in bytes;

      ul_temp = *(uint32 *)ZR_DTB_PTRS;
      gul_DTBRdPtr = (ul_temp) & (0xFFFF);
      gul_DTBWrPtr = ((ul_temp) & (0xFFFF0000)) >> 16;

      if (gul_DTBRdPtr >= gul_PrevDTBRdPtr) {
         /* NO wrap around in HW DTB buffer*/

         l_cpsize1 = gul_DTBRdPtr - gul_PrevDTBRdPtr;

         temp_ptr = (uint8 *)(DTB_BASE_ADDR + gul_RxDTBOffset + gul_RxDTBBase + gul_PrevDTBRdPtr);

         if ((gus_DTBBufSize - gus_DTBBufIdx) >= l_cpsize1) {
            /* NO wrap around in local buffer*/
            memcpy((void *)&gpuc_DTBBuf[gus_DTBBufIdx], (void *)temp_ptr, l_cpsize1);
            gus_DTBBufIdx += l_cpsize1;

            if(gus_DTBBufIdx  == gus_DTBBufSize) {
               gus_DTBBufIdx = 0;
            }
         } else {
            /* Wrap around in local buffer*/

            ul_temp = (gus_DTBBufSize - gus_DTBBufIdx);
            memcpy((void *)&gpuc_DTBBuf[gus_DTBBufIdx], (void *)temp_ptr, ul_temp);

            temp_ptr += ul_temp;
            gus_DTBBufIdx = 0;

            //If wrap around of local buffer is disabled
            if (gus_WrapAround == 0)
            {
               gus_StopDump = 1; //Prevent wrap around in local buffer
               //Pause(0xAA);
               return;
            }

            memcpy((void *)&gpuc_DTBBuf, (void *)temp_ptr, (l_cpsize1 - ul_temp));
            gus_DTBBufIdx += (l_cpsize1 - ul_temp);
         }
      } else {
         /* Wrap around in HW DTB buffer*/

         l_cpsize1 = (gul_RxDTBSize - gul_PrevDTBRdPtr);
         l_cpsize2 = gul_DTBRdPtr;

         temp_ptr = (unsigned char *)(DTB_BASE_ADDR + gul_RxDTBOffset + gul_RxDTBBase + gul_PrevDTBRdPtr);

         if ((gus_DTBBufSize - gus_DTBBufIdx) >= l_cpsize1) {
            /* NO wrap around in local buffer*/

            memcpy((void *)&gpuc_DTBBuf[gus_DTBBufIdx], (void *)temp_ptr, l_cpsize1);
            gus_DTBBufIdx += l_cpsize1;

            if(gus_DTBBufIdx  == gus_DTBBufSize) {
               gus_DTBBufIdx = 0;
            }
         } else {
            /* Wrap around in local buffer*/

            ul_temp = (gus_DTBBufSize - gus_DTBBufIdx);
            memcpy((void *)&gpuc_DTBBuf[gus_DTBBufIdx], (void *)temp_ptr, ul_temp);

            temp_ptr += ul_temp;
            gus_DTBBufIdx = 0;

            //If wrap around of local buffer is disabled
            if (gus_WrapAround == 0)
            {
               gus_StopDump = 1; //Prevent wrap around in local buffer
               //Pause(0xBB);
               return;
            }

            memcpy((void *)&gpuc_DTBBuf, (void *)temp_ptr, (l_cpsize1 - ul_temp));
            gus_DTBBufIdx += (l_cpsize1 - ul_temp);
         }

         temp_ptr = (unsigned char *)(DTB_BASE_ADDR + gul_RxDTBOffset + gul_RxDTBBase + 0);

         if ((gus_DTBBufSize - gus_DTBBufIdx) >= l_cpsize2) {
            /* NO wrap around in local buffer*/

            memcpy((void *)&gpuc_DTBBuf[gus_DTBBufIdx], (void *)temp_ptr, l_cpsize2);
            gus_DTBBufIdx += l_cpsize2;

            if(gus_DTBBufIdx  == gus_DTBBufSize) {
               gus_DTBBufIdx = 0;
            }
         } else {
            /* Wrap around in local buffer*/

            ul_temp = (gus_DTBBufSize - gus_DTBBufIdx);
            memcpy((void *)&gpuc_DTBBuf[gus_DTBBufIdx], (void *)temp_ptr, ul_temp);

            temp_ptr += ul_temp;
            gus_DTBBufIdx = 0;

            //If wrap around of local buffer is disabled
            if (gus_WrapAround == 0)
            {
               gus_StopDump = 1; //Prevent wrap around in local buffer
               //Pause(0xCC);
               return;
            }

            memcpy((void *)&gpuc_DTBBuf, (void *)temp_ptr, (l_cpsize2 - ul_temp));
            gus_DTBBufIdx += (l_cpsize2 - ul_temp);
         }
      }
      gul_PrevDTBRdPtr = gul_DTBRdPtr;
   }

   return;
}

#ifdef NTR_INTRPT_POLL_ENABLE

extern int32 sl_IntPriority[];

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void poll_ntr(void)
*
*   This function is used to poll for the arrival of an NTR interrupt, during
*   the servicing of other routines.  If one has arrived, set gft_early_ntr,
*   and read the state of the CRI counter.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void poll_ntr(void)
{
   if (gft_early_ntr==0)
   {
      GetCriStatus0();
      if ((gl_CriStatus0 & sl_IntPriority[0+1])!=0)
      {
         gft_early_ntr=1;
         GetRxCounter();
      }
   }
}

#endif // NTR_INTRPT_POLL_ENABLE

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ShowtimeRxTC_QT_VDSL2(void)
*
*   This function is used for VDSL2 RX time critical (TC) task for showtime state.
*   This is one of two TC tasks during showtime, which is interrupted by
*   RX_QT_DONE signal.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ShowtimeRxTC_QT_VDSL2(void)
{
//#ifdef PROFILE_TASKS
//   int16 s_Timer;
//#endif //PROFILE_TASKS
//   uint32 ul_RegBaseAddr_Lp1,ul_addr;
   int32 l_cycles;
   uint32 ul_data;
   uint8 uc_erb_descriptor_index = 0;
   uint32 *ul_addr_pointer = NULL;

   //PtrToBkgdFunc ptrToFunction;
   ReadRxTimer((uint32 *)(void *)&gl_RxTimer_RxTcStart);

//#ifdef VRX518_LOG_DEBUG_INFO
//   //TODO: Dump RX DTB buffer
//   if (gus_dbg_LogControl & 0x1)
//   {
//      DumpRxDTBBuf();
//   }
//#endif

// ReadCoreReg(ZEP_PRAM_ZR_FEC_CNT_LP1_ADDR, &gul_dbg_fec_count);

   //Rx QT completion check is required for Time Slotted mode and cascade mode take Rx QT done interrupt
   //and the Rx QT done event bit is already cleared in the Interrupt handling function. Hence this check is
   //not required here for cascaded mode.
   if (guc_CasMode_enable == 0)
   {
      ReadCoreReg(CRI_EVENT_ADDR, &ul_data);
      if (ul_data & MASK_BIT15)
      {
         //Clear event register for the next test
      //CRI_EVENT_ADDR contains W1C(Write 1 to clear bits)bits, Read modify clear the other bit mask
      //So use the WriteCoreReg() instead of SetCoreReg().
         WriteCoreReg(CRI_EVENT_ADDR, MASK_BIT15);
      }
      else
      {
         gul_QTRxNotDone++;
         //DSH_SendEvent(DSH_EVT_QTRX_NOT_DONE,sizeof(uint32),(void *)&gul_QTRxNotDone);
      }
   }
#ifndef ENABLE_PMS_DONE_INT_FOR_PMS_CYCLE_MEASUREMENT   //XDSLRTFW-3322 (Start)
   //Check for Rx PMD done status for data symbols and skip sync symbol
   //Do not run Zephyr when gs_RxPMDFrameCount = 256 (sync symbol) and skip Rx PMD done status check when gs_RxPMDFrameCount = 0;
   //TBD: Zephyr done status needs to be verified for Time Slot mode.
   //if ((gl_RxTcCount>0) && (gs_RxPMDFrameCount != 0) && (guc_CasMode_enable))
   //Enable the check for both Time Slotted 17a and cascaded 35B mode.
   if ((gl_RxTcCount>0) && (gs_RxPMDFrameCount != 0))
   {
      CheckZepSTAT_Rx_PMSRegs();
   }
#endif     //XDSLRTFW-3322 (End)

   //XDSLRTFW-2392 (Cascaded scheduling - Start)
   //Do the Zephyr Input configuration ,i.e call
   //ShowtimeRxTC_FC_VDSL2()
   if (guc_CasMode_enable)
   {
      if(gs_dbg_DelayRxPms > 0)
      {
         gs_dbg_DelayRxPms--;
      }
      else
      {
         gt_TaskArray[RX_FC_DONE].TimeCriticalTask();
      }
   }
   //XDSLRTFW-2392 (Cascaded scheduling - End)

   // REVIEW_STEFAN: TBD: all showtime variables need to be initialized in Synchro 6
   if (guc_RxFirstShwotimeSymbol == 1)
   {
      guc_RxFirstShwotimeSymbol = 0;
      gc_FormErbInShowtimeState = FORM_ERB_DISABLE; // initialize state variable used in ShowtimeErbHandler() FG function
   }

   gs_TCStateID = SHOWTIME_RX_QT_TC_START;

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   s_Timer = LogTaskProfile(RX_SHOWTIME_QT_DONE_TC_START,0);
//#endif //PROFILE_TASKS

   // increment TC task count (may be used for showtime debug)
   // do it in the beginning of TC to be consistent with FG symbol count increment
   gl_RxTcCount++;

#ifndef QT_LATCH_LP_BITS
   // Read the bits in fifo to program the Rx transfer size for next frame

   // Note it is important to call this before exceuting the loading function as
   // it needs to read the Lp value that last PMD frame ran with. This may be changed by
   // loading functions for SRA handling
   CaptureRxBitsInFifo();
#endif //#ifndef QT_LATCH_LP_BITS

   // execute loading function
   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   if ((gft_CRC_Computed == TRUE))
   {
      ReadCoreReg(ZEP_PRAM_ZR_CRC1_LP0_ADDR, &gul_ERB_CRC); //Set the address of IIBRAM to read ERB data
      gul_ERB_CRC = gul_ERB_CRC ^ 0xFFFFFFFF;
      gft_CRC_Computed = FALSE;

      //Init CRC accumulator as 0xFFFFFFFF to the once once compliment of first 32bit data
      WriteCoreReg(ZEP_PRAM_ZR_CRC1_LP0_ADDR, 0xFFFFFFFF);
   }

   if (gft_Compute_CRC)
   {
      Showtime_ERB_FCS32_Config();
      gft_Compute_CRC = FALSE;

      if (gft_ERB_Segment_Done)
      {
         gft_ERB_Segment_Done = FALSE;
         gft_CRC_Computed = TRUE;
      }

      if (gft_ERB_Buffer_Selector == TRUE)
      {
         gft_ERB_Buffer_Selector = FALSE;
      }
      else
      {
         gft_ERB_Buffer_Selector = TRUE;
      }
   }
   else
   {
      // REVIEW_STEFAN: TBD: Why do we write to these HW registers every symbol - even if ERBs are turned off?
      Disable_Showtime_ERB_FCS32_Config();
   }

   //Note: In 6.2 HW, the task scheduling is different from that of 5.0 implementation
   //In particular, the order of the RX PMS core and the RX QT core is switched.
   //Thus at the TC task, we need to postpone the PMS core reconfiguration one frame later
   //then the QT core reconfiguration (while in 5.0 implementation, they are done in the same time).
   if (gft_dbg_SkipRxSyncFrame == 0)
   {
      if (gs_RxPMDFrameCount == RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         //DSM_Vectoring_Debug:
         //if ( gs_PauseControl == 0x38)
         //Pause(gs_PauseControl);

         //Due to the order of PMS and QT is switched
         //so we need to delay this configuration by one symbol
         DisableRxPms();

         DisableRxPRBS();

         //XDSLRTFW-2875 (Start)
         // REVIEW_STEFAN: There is probably a better way to check whether "full vectoring" is turned on
         if ((gft_DSVectoringEnabled == TRUE) &&
             ((gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_FRIENDLY_MASK)) == 0))
         {
            //Restore RTV0 buffer from Vectoring Sync symbol configuration
            SetupRTV0ForRxNonSyncFrameVectoring();

            // States in showtime
            // EOC_ERB_TRANSMISSION_STATE
            //    0: ST_ERBS_OFF                      : ERB are turned off
            //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
            //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available

            // Stop ERB transmission while receiving new ERB parameters
            if (guc_EOC_ERB_TRANSMISSION_STATE == ST_ERBS_ON)
            {
               gt_DsmStats.ul_ErrVecRequested++;
               // REVIEW_STEFAN: Comment is missing: What do we do here?
               // REVIEW_STEFAN: TBD: FW uses 8 instead of gul_DREG_ERB_Number
               //                (instead of 8 we should have used the define MAX_NUM_ERB_SEGMENTS)
               if (guc_erb_descriptor_index == 0)
               {
                  uc_erb_descriptor_index = 8;
               }
               else
               {
                  uc_erb_descriptor_index = guc_erb_descriptor_index - 1;
               }

               // REVIEW_STEFAN: What does this code do? Comment missing.
               // Plus adding a missing cast, which is necessary for correct address calculation  //XDSLRTFW-3704
               ul_addr_pointer = (uint32 *)(((uint32)&__StartOfSramBAR17) + gul_DREG_ERB_Descriptor_Base + 4 + (8*uc_erb_descriptor_index)); //XDSLRTFW-3704: CleanUp of some Hard coding address space at VRx518 R4 (Start-End)
               if (*ul_addr_pointer & SET_OWNER_BIT_ERB_DESCRIPTOR)
               {
                  gc_FormErbInShowtimeState = FORM_ERB_DISABLE;
                  gt_DsmStats.ul_ErrVectDiscard++;
               }
               else
               {
                  // Start processing of next Error Vector
                  gs_G9935ErrorFeedbackState = G9935_ERRORFB_FORM_MSG;  // Where do we check for "G9935_ERROR_FORM_MSG?
                  gc_FormErbInShowtimeState = CONFIGURE_ERB;
               }
            }
         //XDSLRTFW-2875 (End)
         }

         // Restore RTV buffers for DDSnrFdqHandler
         SetUpRTVForDDSnrFdqHandler();

         gs_RxToneOffset = gs_RxToneOffsetShadow;
         SetRxToneOffset();

         //DSM_Vectoring_Debug:
         //if ( gs_PauseControl == 0x32)
         //Pause(gs_PauseControl);

         // Non Vectoring mode or Vector Friendly mode: Read Rx synch frame - FDQ output from NPR ( Noise Power RAM)
         // vectoring mode :  uses gsa_SyncSymConstelForOlr variable (in IIBRAM) to capture sync symbool data directly form RTV1
         //XDSLRTFW-2875 (Start)
         if (!((gft_DSVectoringEnabled == TRUE) &&
               ((gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_FRIENDLY_MASK)) == 0)))
         {
            ReadRxSynchFrame();
         }
         //XDSLRTFW-2875 (End)

         // Enable GC & DX for frame 0
         EnableRxGCDX();

      }
      else
      {
         //DSM_Vectoring_Debug:
         //if (gs_RxPMDFrameCount == 200)
         //if ( gs_PauseControl == 0x54)
         //Pause(gs_PauseControl);

         if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
         {
            UpdateDsRrcStat();
            //XDSLRTFW-2392 (Cascaded scheduling - Start)
            if (guc_CasMode_enable)
            {
               extern void InsertDsRRCToDTB(void);
               InsertDsRRCToDTB();
            }
            //XDSLRTFW-2392 (Cascaded scheduling - End)
         }

         if (gs_RxPMDFrameCount == (RX_DATA_SYMBOLS_PER_SUPERFRAME-1))
         {
            // Enable Rx PRBS State generator
            EnableRxResetPRBS();

            // Enable QTP RX PRBS
            EnableRxDescrambling();

            // Configure the shadow register
            gs_RxToneOffsetShadow = gs_RxToneOffset;

            // The Rx Synch Offset is already modified to 10n+1 for vectoring
            gs_RxToneOffset = gs_RxSynchFrameOffset;
            SetRxToneOffset();

            //enable Rx synch frame processing
            gus_ShowtimeControl |= MASK_RX_SYNC_FRAME_PROC;

            // Disable GC & DX for sync frame
            DisableRxGCDX();

            // Configure RTV buffer 0 for reading the Rx synch frame
            SetUpRTVForRxSynchFrame();

            //XDSLRTFW-2875 (Start)
            if ((gft_DSVectoringEnabled == TRUE) &&
                ((gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_FRIENDLY_MASK)) == 0))
            {
               //Config RTV0 buffer from Vectoring Sync symbol configuration
               SetupRTV0ForRxSyncFrameVectoring();

               // REVIEW_STEFAN: Why was the ERB start trigger here?
               // G9935_ERRORFB_DUMPED: name is misleading
               // EOC_ERB_TRANSMISSION_STATE
               //    0: ERB are turned off
               //    1: ERB parameters are being calculated:
               //    2: ERBs are on and valid parameters are available
               //gs_G9935ErrorFeedbackState = G9935_ERRORFB_DUMPED;
            }
            //XDSLRTFW-2875 (End)
         }
         else if (gs_RxPMDFrameCount == 0)
         {
            //Enable PMS
            //Due to the order of PMS and QT is switched
            //so we need to delay this operation by one symbol (compared to 5.0 implementation)
            EnableRxPms();

            //disable Rx synch frame processing
            gus_ShowtimeControl &= ~(MASK_RX_SYNC_FRAME_PROC);

//#ifdef MTK_VECTORING_SUPPORT
            //DSM_Vectoring_Debug:
            //ptrToFunction = (PtrToBkgdFunc)CheckNextVectorSyncFrame;
            //AddFunctionToBkgdFifo(ptrToFunction);
//#endif

         }

         //RTXus handling
         if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
         {
            //ReadRRCFifo(); //XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
            //Moved from RxFC TC to RxQT TC
            if (RRCGolayDecode())
            {
               RRC_Evaluation();
            }
            //XDSLRTFW-3101 (Start)
            else
            {
               gus_RRC_BadCW++;
            }
            //XDSLRTFW-3101 (End)
         }

         //DTB: Ping Pong
         //DSL FW/DSP has to change the following every symbol to implement the ping-pong mechanism.
            //This is a part of FW workaround for smaller DTB size in VRx518.
         //a.QT: Change RX_DTB_OFFSET within register ZR_DTB_OFFSET_35B. Changing the RXDTB_WR_BASE is not required, as it an offset from RX_DTB_OFFSET
         //b.Zephyr: Change DTB_BASE within register ZR_DTB_CTRL_35B
         DtbPingPongConfiguration();

      } //else  of (gs_RxPMDFrameCount == RX_DATA_SYMBOLS_PER_SUPERFRAME)

   } //if (gft_dbg_SkipRxSyncFrame == 0)

   //Check for Rx QTP done status, Rx QTP start running when Rx Timer value is at 0, where Rx Buffer swap occurs.
   //From Buffer swap Rx QTP is expected to take around 16500 cycles.
   ReadRxTimer((uint32 *)(void *)&l_cycles);
   if ((l_cycles < 16000) && (guc_CasMode_enable))
   {
      gul_RxQTP_NotDone++;
      //DSH_SendEvent(DSH_EVT_RXQTP_NOT_DONE,sizeof(uint32),(void *)&gul_QTRxNotDone);
   }

   guc_EstimatedTS = ModXIncrY(guc_EstimatedTS, 1, TS_MODULO);
   //CV counter has to be build as mentioned in chapter 11.3.1/G.998.4,
   //one or more uncorrected DTUs within a time window of 17 ms shall generate one CRC.
   // 17ms corresponds to 68 symbols for 4kHz, and 68*2 dmt symbols for 8kHz
   guc_ReTX_CRC1_ReportTS =  ModXIncrY(guc_ReTX_CRC1_ReportTS, 1, (uint16)(68<<gs_frame_rate_is_8khz));



#ifdef DISTRIBUTE_TX_RX_PROCESS
   // overwrite clock gating setting
   if (gft_DistributeTxRxProcess)
   {
      WriteCCR1RegAtQtDone();
   }
#endif // DISTRIBUTE_TX_RX_PROCESS

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif


   if(!(gus_ShowtimeControl & MASK_RX_SYNC_FRAME_PROC))
   {
      Calculate_DiscardFrame_Threshold();
   }
#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   RunPLL();


#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   if (gft_EnableNTR)
   {
      UpdateNTR();
   }

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

#ifndef HW_SNR_FDQ
   // read FFT output
   if (gus_ShowtimeControl & MASK_READ_RX_FFTOUT)
   {
      ReadRxFftOutput();
   }
#endif //#ifndef HW_SNR_FDQ

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

#ifndef HW_SNR_FDQ
   // read QAM decision error ouput
   if (gus_ShowtimeControl & MASK_READ_RX_ERROUT)
   {
      ReadRxErrOutput();
   }
#endif //#ifndef HW_SNR_FDQ

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   LogTaskProfile(RX_SHOWTIME_QT_DONE_TC_END,s_Timer);
//#endif //PROFILE_TASKS

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   gs_TCStateID = SHOWTIME_RX_QT_TC_END;

   //XDSLRTFW-1393 (Start)
   if (gft_DsSraReTxInit == TRUE)
   {
      InitDsReTxForSra_VDSL2();
      //gft_DsSraReTxInit = FALSE; //XDSLRTFW-2577 (Start_End)
   }
   //XDSLRTFW-1393 (End)
//XDSLRTFW-2162 (Start)
   if ((gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt - 1  )) &&(gft_IDILV_DS_SRA_event == TRUE))
   {
      uint32 ul_dat;
      ReadCoreReg(ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR, &ul_dat);
      ul_dat = ul_dat & 0xe000ffff; //<28:16> RXDTB_WR_ADDR_1
      WriteCoreReg(ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR, ul_dat);
   }

//XDSLRTFW-2162 (End)


   //Fail ADMA failure bit is SET, this check is required for both Time slotted and cascaded.
   //ADMA completion check is being done at Rx TC & Tx TC for cascaded and Time slotted mode
   //respectively.
   if (guc_CasMode_enable)
   {
      //Fail if ADMA failure bit is SET
      if (CheckAdmaCompletion())
         EnterFailStates(E_CODE_ADMA_NOT_FINISHED_CASCADED_MODE);
   }

   //XDSLRTFW-2392 (Cascaded scheduling - Start)
   //Start the Zephyr code in Reg start mode
   if ((guc_CasMode_enable) && (gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME))
   {
      //Start Zephyr only for the data symbols that QT is processed
      StartRxPmsRegStart();
      ReadRxTimer((uint32 *)(void *)&gl_RxTimer_RxPMSStart);
   }
   //XDSLRTFW-2392 (Cascaded scheduling - End)

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   if ((guc_CasMode_enable) && (gft_EnableTaskProfile))
   {
      int32 l_RxTc_Cycles; //XDSLRTFW-3901 (START_END)

      //Max & Min Cycles for Sync and Data symbol
      if (gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         LogTaskProfile(ST_RX_TC_QT_DONE_DATA_SYMBOL,gl_RxTimer_RxTcStart);
      }
      else
      {
         LogTaskProfile(ST_RX_TC_QT_DONE_SYNC_SYMBOL,gl_RxTimer_RxTcStart);
      }

      if (gl_RxTimer_RxTcStart > gt_CasFwTasksMipsCnt.l_Start_RX_TCtask_max)
      {
         gt_CasFwTasksMipsCnt.l_Start_RX_TCtask_max = gl_RxTimer_RxTcStart;
      }
      if (gl_RxTimer_RxTcStart < gt_CasFwTasksMipsCnt.l_Start_RX_TCtask_min)
      {
         gt_CasFwTasksMipsCnt.l_Start_RX_TCtask_min = gl_RxTimer_RxTcStart;
      }
      if (gl_RxTimer_RxPMSStart > gt_CasFwTasksMipsCnt.l_Start_RX_PMS_max)
      {
         gt_CasFwTasksMipsCnt.l_Start_RX_PMS_max = gl_RxTimer_RxPMSStart;
      }
      if (gl_RxTimer_RxPMSStart < gt_CasFwTasksMipsCnt.l_Start_RX_PMS_min)
      {
         gt_CasFwTasksMipsCnt.l_Start_RX_PMS_min = gl_RxTimer_RxPMSStart;
      }

      //XDSLRTFW-3901 (START)
      //Go for exception if Rx TC task exceeds > 13K cycles
      ReadRxTimer((uint32 *)(void *)&l_RxTc_Cycles);
      l_RxTc_Cycles -= gl_RxTimer_RxTcStart;
      if(l_RxTc_Cycles < 0)
      {
         l_RxTc_Cycles += gl_MaxRxTimerCnt;
      }

      if (l_RxTc_Cycles > 13000)
      {
         gt_CasFwTasksMipsCnt.ul_RX_TC_MaxMipsCnt++;
         //Enter fail state if Rx TC task exceeds the cycle budget.
         //EnterFailStates(E_CODE_RX_TC_CYCLES_TIMEOUT);
      }
      //XDSLRTFW-3901 (END)
   }
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ShowtimeRxTC_FC_VDSL2(void)
*
*   This function is used for VDSL2 RX time critical (TC) task for showtime state.
*   This is one of two TC tasks during showtime, which is interrupted by
*   RX_FC_DONE signal.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
extern int16 CheckForLowPower(void);

void ShowtimeRxTC_FC_VDSL2(void)
{
//#ifdef PROFILE_TASKS
//   int16 s_Timer;
//#endif //PROFILE_TASKS

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   int32 l_Timer;
#endif
//XDSLRTFW-3362 (End)

#if MIPS_PROFILE_USRETX
   int32 l_RxTimer1, l_RxTimer2;
   int32 s_MIPS;
#endif

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   ReadRxTimer((uint32 *)(void *)&l_Timer);
#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   gs_TCStateID = SHOWTIME_RX_FC_TC_START;

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   s_Timer = LogTaskProfile(RX_SHOWTIME_FC_DONE_TC_START,0);
//#endif //PROFILE_TASKS

   // execute loading function
   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo_FC);

#ifndef QT_LATCH_LP_BITS
   // Program the transfer size for every PMD frame
   ComputeRxDataTransferSize();
#endif

   // Read Rx overhead HW Fifo
   ReadRxOvhdHwFifo();

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (Start)
#if MIPS_PROFILE_USRETX
   //Read TX timer value
   ReadRxTimer(&l_RxTimer1);
#endif

   if( (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE) && (gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME) )
   {
      ReadRRCFifo(); //XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
      //Moved to RxNTC from RxTC
      //if (RRCGolayDecode())
      //{
      //   RRC_Evaluation();
      //}
      // XDSLRTFW-1344 (START)
      if (gft_UsReTxSraStopRrcEval == TRUE)
      {
         guc_FirstQtxSymCnt++;
      }
      // XDSLRTFW-1344 (END)
      // overwrite ZEP_REG_ZR_FRAME_IDX1_ADDR register
      //Overwrite_Frame_Idx(); //Prevent CRC extraction from LP1
   }
#if MIPS_PROFILE_USRETX
   ReadRxTimer(&l_RxTimer2);
   //Compute the MIPS for this task
   s_MIPS = (l_RxTimer2 - l_RxTimer1);

   if (s_MIPS < 0)
   {
      s_MIPS = (s_MIPS + gl_MaxRxTimerCnt);
   }

   if(s_MIPS > gl_mipsdebug3)
   {
      gl_mipsdebug3=s_MIPS;
   }
   gl_mipsdebug4= s_MIPS;
#endif
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (End)

   // Check for LPR
   gt_TxIbData.uc_lpr_def = (uint8)CheckForLowPower();

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   // execute per super-frame tasks
   RxSuperFrameProcess();

   // XDSLRTFW-3004 : Debug stream symbol counter is a factor 2 to high for cascaded mode (start_end)
   // only execute when debug streams are enabled
   if(gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK)
   {
      if(guc_CasMode_enable)
      {
         DSH_FgService();
      }
   }
   else
   {
      //Set VersionInfoStreamed to FALSE, so Version Info gets streamed again next time streams get enabled again
      guc_DSH_VersionInfoStreamed = FALSE;
   }

#ifdef DEBUG_SHOWTIME
   // log RxDTB/FFT buffer (FFT for loopback test only) for showtime debug purpose
   LogRxBufAtRxFcTc();
#endif DEBUG_SHOWTIME

#ifdef CHECK_ILV_MEM_ERROR
   CheckIlvMemErr();
#endif //CHECK_ILV_MEM_ERROR

#ifdef ZEP_DEBUG_BLD
   UpdateRxFifo3Stat();
#endif

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   LogTaskProfile(RX_SHOWTIME_FC_DONE_TC_END,s_Timer);
//#endif //PROFILE_TASKS

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif


   gs_TCStateID = SHOWTIME_RX_FC_TC_END;

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   if ((guc_CasMode_enable) && (gft_EnableTaskProfile))
   {
      //Max & Min Cycles for Sync and Data symbol
      if (gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME)
         LogTaskProfile(ST_RX_TC_PMS_DATA_SYMBOL, l_Timer);
      else
         LogTaskProfile(ST_RX_TC_PMS_SYNC_SYMBOL, l_Timer);
   }
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)
}


// Wrapper function for StartRxDataPath. Needed for Arc build since function called from multimode PreShowtimeRxF.
void StartRxDataPath_VDSL2(void)
{
   StartRxDataPath();
}


#ifdef PPE_ENGINE
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DFE_PPE_RxDataStatus_EnterShow()
*
*   This function notifies PPE that RX direction is about to entering showtime.
*   Set to 1 on first RxShowtimeSymbol
*
*   Input Arguments:
*
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DFE_PPE_RxDataStatus_EnterShow(void)
{
   uint32 ul_addr, ul_data;

   // XDSLRTFW-2778 (Start)
   // Set Bit 1 of DREG0 to inform PPE that both Rx and Tx has entered showtime.
   // Please refer the document "PPE DSL Notifications" for more information.
   // Bit defintion of DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF
   ul_addr = DREG_MISCRAM0_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   ul_data |=MASK_BIT1;
   WritePpeReg(ul_addr, ul_data);
   guc_Showtime_Entered |= MASK_BIT1;
   // XDSLRTFW-2778 (End)
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DFE_PPE_LinkStatus_TxRxShow()
*
*   This function notifies PPE that both TX and RX directions are
*   in showtime. (BIT0)
*
*   Input Arguments:
*
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DFE_PPE_LinkStatus_TxRxShow(void)
{
   uint32 ul_addr, ul_data;

   // Set Bit 0 of DREG0 to inform PPE that Rx has entered showtime.
   // Please refer the document "PPE DSL Notifications" for more information.
   // Bit defintion of DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF
   ul_addr = DREG_MISCRAM0_ADDR ;
   ReadPpeReg(ul_addr, &ul_data);
   ul_data |=MASK_BIT0;
   WritePpeReg(ul_addr, ul_data);
   guc_Showtime_Entered |= MASK_BIT0;
}
#endif //PPE_ENGINE








uint16 CalcRetxDelay(uint8 uc_OrigTS, uint8 uc_CorrectedTS)
{
   uint16 us_Temp;

   us_Temp = uc_CorrectedTS;
   if (us_Temp < uc_OrigTS)
   {
      us_Temp += TS_MODULO;
   }

   us_Temp = us_Temp - uc_OrigTS + 2;      // plus 2 to round-off 4 symbols/sec

   us_Temp >>= 2;

   return(us_Temp);

}


FlagT InModZRange(uint16 us_Point, uint16 us_LowerBound, uint16 us_UpperBound, uint16 us_Modulo)
{
   if (us_LowerBound >= us_Modulo)
   {
      us_LowerBound -= us_Modulo;
   }

   if (us_UpperBound >= us_Modulo)
   {
      us_UpperBound -= us_Modulo;
   }

   if (us_UpperBound >= us_LowerBound)
   {
      if ((us_LowerBound <= us_Point) && (us_Point <= us_UpperBound))
      {
         return(1);
      }
   }
   else
   {
      if ((us_LowerBound <= us_Point) || (us_Point <= us_UpperBound))
      {
         return(1);
      }
   }

   return(0);
}

uint8 ModXIncrY(uint16 us_Input, uint16 us_Y, uint16 us_Modulo_X)
{
   uint16 us_Output;

   us_Output = us_Input + us_Y;

   while (us_Output >= us_Modulo_X)
   {
      us_Output -= us_Modulo_X;
   }

   return((uint8)us_Output);
}

//XDSLRTFW-1571 (Start)
void push_node (uint8 *puc_Head, uint8 uc_NodeIndx, uint8 *puc_NumNodes)
{

#ifdef ENABLE_RETX_DS_DEBUG
   if (*puc_Head != 0xFF)
   {
      if (*puc_Head != gt_NodeList[*puc_Head].uc_Indx)
      {
         gft_PauseOff = 0;
         Pause(0x1101);
      }
   }
#endif

   if (*puc_NumNodes < gt_ReTXParams.uc_Qrx)
   {
      if (*puc_Head != 0xFF)
      {
         gt_NodeList[uc_NodeIndx].uc_NextNode = gt_NodeList[*puc_Head].uc_Indx;
      }
      *puc_Head = gt_NodeList[uc_NodeIndx].uc_Indx;

      (*puc_NumNodes)++;
   }
#ifdef ENABLE_RETX_DS_DEBUG
   else
   {
      //Max size exceeded. Remove this Pause after testing.
      gft_PauseOff = 0;
      Pause(0x1111);
   }
#endif

   return;
}

uint8 pop_node (uint8 *puc_Head, uint8 *puc_NumNodes)
{
   uint8 u_TmpIndx = 0xFF;

#ifdef ENABLE_RETX_DS_DEBUG
   if (*puc_Head != 0xFF)
   {
      if (*puc_Head != gt_NodeList[*puc_Head].uc_Indx)
      {
         gft_PauseOff = 0;
         Pause(0x2202);
      }
   }
#endif

   if ((*puc_NumNodes > 0) && (*puc_Head != 0xFF))
   {
      u_TmpIndx = *puc_Head;

      *puc_Head = gt_NodeList[u_TmpIndx].uc_NextNode;
      gt_NodeList[u_TmpIndx].uc_NextNode = 0xFF;

      (*puc_NumNodes)--;
   }
#ifdef ENABLE_RETX_DS_DEBUG
   else
   {
      //No more nodes to Pop. Remove this Pause after testing.
      gft_PauseOff = 0;
      Pause(0x2222);
   }
#endif

   return(u_TmpIndx);
}
//XDSLRTFW-1571 (End)

// calculate the index of the entry corresponding to the NewSID using
// a referenced entry and its SID.
//XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start)
uint8 CalcSIDidx(uint16 us_RefSID_idx, uint16 us_RefSID, uint16 us_NewSID)
{
   int16  s_Offset;

   s_Offset = us_NewSID - us_RefSID;
   if (s_Offset < 0)
   {
      s_Offset += SID_MODULO;
   }

   return(ModXIncrY(us_RefSID_idx, (uint16)s_Offset, QRETX_TRANS_TABLE_SIZE));
}
//XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (End)

//XDSLRTFW-3303 (Start)
uint8 UpdateQretxTable(uint8 uc_DtuStat, uint8 uc_NewSID, uint8 uc_TS, uint8 uc_DtuIndex)
{
   uint8 uc_TempSID_idx, uc_TempSID;
   uint8 uc_Rd_SID_idx, uc_Rd_SID;
   uint8 uc_Next_Wr_SID_idx;
   //XDSLRTFW-1571 (Start_End)
   FlagT ft_DTUAccepted;

   //XDSLRTFW-1571 (Start_End)
   ft_DTUAccepted = TRUE;
   uc_TempSID = gta_QretxTable[guc_Wr_SID_idx].uc_SID;
   uc_TempSID_idx = 0;

   uc_Rd_SID_idx = guc_Rd_SID_idx;
   uc_Rd_SID = gta_QretxTable[uc_Rd_SID_idx].uc_SID;

   uc_Next_Wr_SID_idx = ModXIncrY(guc_Wr_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);
   // to prevent any Q overflow, we ensure that our RD & WR pointers won't over run.
   if (uc_Next_Wr_SID_idx == uc_Rd_SID_idx)
   {
      uc_DtuStat = BAD_DTU;
   }

   if (uc_DtuStat == GOOD_DTU)
   {
      //XDSLRTFW-1393 (Start)
      //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start_End)
      if (ModXIncrY(uc_TempSID, 1, SID_MODULO) == uc_NewSID)
      {
         // new DTU (not a retransmitted one) because it gets the expected SID
         // in between this good DTU and previously good DTU, there might be incorrect DTUs.
         uc_TempSID_idx = uc_Next_Wr_SID_idx;

         guc_Wr_SID_idx = uc_Next_Wr_SID_idx;
      }
      else if ((InModZRange(uc_NewSID, uc_Rd_SID, uc_TempSID, SID_MODULO)) && (uc_TempSID != uc_Rd_SID))
      {
         // initial condition or retransmitted DTU

         //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
         uc_TempSID_idx = CalcSIDidx(uc_Rd_SID_idx, uc_Rd_SID, uc_NewSID);

         //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
         gt_ReTXStats.ul_RetransmittedDtuCnt++;

         //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start)
         if (gta_QretxTable[uc_TempSID_idx].uc_Stat == BAD_DTU)
         {
            gt_ReTXStats.ul_CorrectedDtuCnt++;
         }
         //Drop the packet if it has been received before and not yet forwarded to PPE
         else
         {
            //XDSLRTFW-1571 (Start_End)
            ft_DTUAccepted = FALSE;

            // unexpected DTU
            gt_ReTXStats.ul_UnexpectedDtuCnt++;
         }
         //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (End)
      }
      //XDSLRTFW-1393 (End)
      else
      {
         // unexpected DTU
         gt_ReTXStats.ul_UnexpectedDtuCnt++;

         // gotta be "unexpected" retransmitted DTU
         //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
         gt_ReTXStats.ul_RetransmittedDtuCnt++;

         //XDSLRTFW-1571 (Start_End)
         ft_DTUAccepted = FALSE;
         uc_TempSID_idx = 0;
      }

   }
   else
   {
      // throw away.
      // this could be a new DTU that is incorrect
      // this could be a retransmitted DTU that is incorrect again.

      //XDSLRTFW-1571 (Start_End)
      ft_DTUAccepted = FALSE;

      //XDSLRTFW-3182 (Start)
      // to prevent any Q overflow, we ensure that our RD & WR pointers won't over run.
      if (uc_Next_Wr_SID_idx != uc_Rd_SID_idx)
      {
         // estimated bad SID
         uc_TempSID = ModXIncrY(uc_TempSID, 1, SID_MODULO);

         //XDSLRTFW-1318: BugFix_DS_VDSL2_ALL_ReTx_Showtime_LinkDrop_With_GHSRFI (Start)
         if (gta_QretxTable[uc_Next_Wr_SID_idx].uc_DTU_idx != EMPTY_DTU)
         {
            //guc_Rd_SID_idx has not yet cleared the DTU; We have no choice, but
            //to drop the packet. This condition is seen when GHS tones are added as
            //RFI in showtime (This noise results in lots of consecutive BAD DTUs and
            //occasional GOOD DTUs)
            //XDSLRTFW-1571 (Start_End)
            push_node(&gt_FreeBufList.uc_Head, gta_QretxTable[uc_Next_Wr_SID_idx].uc_DTU_idx,
                      &gt_FreeBufList.uc_NumNodes);
            gta_QretxTable[uc_Next_Wr_SID_idx].uc_DTU_idx = EMPTY_DTU;
            gus_DropPktCntr++;
            //gft_PauseOff = 0;
            //Pause(0x7777);
         }
         //XDSLRTFW-1318: BugFix_DS_VDSL2_ALL_ReTx_Showtime_LinkDrop_With_GHSRFI (End)

         gta_QretxTable[uc_Next_Wr_SID_idx].uc_TS = guc_EstimatedTS;
         gta_QretxTable[uc_Next_Wr_SID_idx].uc_Stat = BAD_DTU;
         gta_QretxTable[uc_Next_Wr_SID_idx].uc_SID = uc_TempSID;

         guc_Wr_SID_idx = uc_Next_Wr_SID_idx;
      }
      //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start)
      else
      {
         guc_QRetxTableFullCntr++;
      }
      //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (End)
      //XDSLRTFW-3182 (End)

      gt_ReTXStats.ul_BadDtuCnt++;

   }

   //XDSLRTFW-1571 (Start)
   if (ft_DTUAccepted == TRUE)
   {
      gta_QretxTable[uc_TempSID_idx].uc_DTU_idx = uc_DtuIndex;
      gta_QretxTable[uc_TempSID_idx].uc_TS = uc_TS;
      gta_QretxTable[uc_TempSID_idx].uc_SID = uc_NewSID;
      gta_QretxTable[uc_TempSID_idx].uc_Stat = GOOD_DTU;

      gt_ReTXStats.ul_GoodDtuCnt++;
   }
   //XDSLRTFW-1571 (End)

   if (gft_AlwaysSendAckToCO == TRUE) {
      ft_DTUAccepted = TRUE;
   }

   return (ft_DTUAccepted);
}
//XDSLRTFW-3303 (End)

void ForwardDtusToPPE(void)
{
   uint8 uc_RdTS, uc_RdMinDelayTS, uc_RdMaxDelayTS, uc_Temp_Rd_SID_idx;
   uint16 us_DelayMinFrames, us_DelayMaxFrames;
   int32 l_DtuCnt;
   uint8 uc_Xdtus;
   int32 *pl_DtuAddr;
   int16 s_DtuSize;
   int32 l_ReTXQueue_BaseAddress;
   uint32 ul_source_addrs,ul_destn_addrs;

   //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start_End)
   uint8 uc_SID;

   // init pointers
   pl_DtuAddr = (int32*)__gla_ZrIlvbRdPtrTable;
   l_ReTXQueue_BaseAddress = gt_ReTXParams.ul_DS_ReTXQueue_BaseAddress;
   uc_Xdtus = 0;

   // delay min and max in term of frames/TS
   //XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
   us_DelayMinFrames = (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DelayMin << (2+gs_frame_rate_is_8khz));
   us_DelayMaxFrames = (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DelayMax << (2+gs_frame_rate_is_8khz));

   //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
   //XDSLRTFW-1393 (Start_End)
   //XDSLRTFW-3493(Start_End)
   s_DtuSize = (int16)(gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS);

   // from 2-4 Dtus out rate
   //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start)
   //for (l_DtuCnt = 0; l_DtuCnt < (int32)guc_maxdtuout; l_DtuCnt++)

   //XDSLRTFW-1393 (Start)
   //Limit No of DTUs forwared to PPE to guc_maxdtuout, but also process all the DTUs that are getting "Timedout"
   for (l_DtuCnt = 0; uc_Xdtus < guc_maxdtuout; l_DtuCnt++)
      //XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (End)
   {
      //if (guc_Wr_SID_idx == guc_Rd_SID_idx) break;

      uc_Temp_Rd_SID_idx = ModXIncrY(guc_Rd_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);

      uc_RdTS = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_TS;
      uc_SID = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_SID;

      if (gta_QretxTable[uc_Temp_Rd_SID_idx].uc_Stat == GOOD_DTU)
      {
         // need to check against MIN_DELAY
         uc_RdMinDelayTS = ModXIncrY(uc_RdTS, us_DelayMinFrames, TS_MODULO);

         //XDSLRTFW-3182 (Start_End)
         if ((us_DelayMinFrames == 0) || (!InModZRange(guc_EstimatedTS, uc_RdTS, uc_RdMinDelayTS, TS_MODULO)))
         {
            //XDSLRTFW-3493(Start)
            //Get Free ADMA queue
            ul_source_addrs = (ZEP_RAM_IIBRAM_ADDR + l_ReTXQueue_BaseAddress + gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx*s_DtuSize);
            ul_destn_addrs = ((uint32)0x4C000+uc_Xdtus*4096);
            if (gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx == 255)
            {
               //guc_ReTxDebugBufWrEnable = 0;
               EnterFailStates(E_CODE_ADMA_RETX_INVALID_ADDRESS);
            }

            //Not required to copy SID,TS,DTU_Status
            SetUpDMATransfer1(ul_source_addrs,(ul_source_addrs + s_DtuSize - BYTES_FOR_SID_TS_DTU_STATUS),ul_destn_addrs,0,0,0);
            *pl_DtuAddr++ = (int32)(ul_destn_addrs-ZEP_RAM_IIBRAM_ADDR);
            //XDSLRTFW-3493(End)

            uc_Xdtus++;

            //XDSLRTFW-1571 (Start_End)
            push_node(&gt_FreeBufList.uc_Head, gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx,
                      &gt_FreeBufList.uc_NumNodes);

            guc_Prev_Rd_SID_idx = uc_Temp_Rd_SID_idx;
            //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
            //Store the SID as well, as gta_QretxTable[guc_Prev_Rd_SID_idx] can get corrupted/over-written by
            //guc_Wr_SID_idx. When we get lots of DTUs in error (continuously), guc_Wr_SID_idx would keep
            //moving ahead and then wraps around and would eventually over write the node pointed by
            //guc_Prev_Rd_SID. guc_Prev_Rd_SID wouldn't have moved ahead due to Q-Full condition.
            guc_Prev_Rd_SID = uc_SID;
            guc_Prev_Rd_DTU_idx = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx;

            gt_ReTXStats.ul_ForwardedDtuCnt++;

         }
         else
         {
            break;
         }
      }
      else if (gta_QretxTable[uc_Temp_Rd_SID_idx].uc_Stat == BAD_DTU)
      {
         if (gft_AlwaysSendAckToCO == FALSE)
         {
            uc_RdMaxDelayTS = ModXIncrY(uc_RdTS, (us_DelayMaxFrames+8), TS_MODULO);
            // XDSLRTFW-3398 (Start_End)
            // During ReTX TESTMODE of operation, if we get a BAD DTU we count it as a Uncorrected DTU and send ACK to CO
            if ((!InModZRange(guc_EstimatedTS, uc_RdTS, uc_RdMaxDelayTS, TS_MODULO)) || (gft_DsUsReTxDiagEnter))
            {
               //Don't indicate uncorrected DTUs during DTU Stoppage period
               if ((gft_DTU_Stoppage_Detected == FALSE) && (gft_SRAInvSync_Detected == FALSE))
               {
                  gt_ReTXStats.ul_UncorrectedDtuCnt++;
               }
            }
            else
            {
               break;
            }
         }
      }
      else
      {
         break;
      }

      //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
      gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx = EMPTY_DTU;
      gta_QretxTable[uc_Temp_Rd_SID_idx].uc_Stat = EMPTY_DTU;
      guc_Rd_SID_idx = uc_Temp_Rd_SID_idx;
   }
   //XDSLRTFW-1393 (End)

   {
      //XDSLRTFW-1393 (Start_End)
      gt_ReTXParams.Un_UcodeReTXParam2.t_Param2.us_DtuPayloadSize = (int16)(gt_ReTXParams.ul_DtuPayloadSize);

      //TODO: Remove later after Zephyr microcode is modified to handle 3 DTUs via ADMA
      //Limit the number of DTUs sent to PPE per symbol to '2'
      //uc_Xdtus = (uc_Xdtus > 2)? 2 : uc_Xdtus;
      gt_ReTXParams.Un_UcodeReTXParam2.t_Param2.uc_FIFO3_DTU_FwdCount = 0; //Init to "0" for every DMT symbol
      gt_ReTXParams.Un_UcodeReTXParam2.t_Param2.uc_DtusToForward_XDTU = uc_Xdtus;
   }

   SetUpDtuForwarding();

}

void UpdateDsRrcStat(void)
{
   uint64 ull_64MostRecentDtuStats;
   //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start)
   uint32 ul_Temp1, ul_Temp3;
   //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (End)
   uint8  uc_QretxSize;
   uint8  uc_AbsDtuNum, uc_DtuIndex;
   //XDSLRTFW-1571 (Start)
   uint8 uc_TS, uc_SID, uc_DtuStat, uc_Temp_Rd_SID_idx, uc_Temp2_Rd_SID_idx; //uc_ILVBWrptrTableIndx;
   uint8 uc_DTU_Status_Arr_Indx, uc_DtuStat_Temp;
   uint8 i, uc_NumDTUsInThisSymbol, uc_InpBufListIndx;
   FlagT ft_Qrx_Full, ft_DTUAccepted;
   int16 s_NumFreeBufs;
   //XDSLRTFW-1571 (End)

   //XDSLRTFW-3493(Start)
   uint32 ul_temp;
   uint32 *ptr_SidTsDtuStatus;
   uint32 ul_data = 0;
   //XDSLRTFW-3493(End)

   uc_NumDTUsInThisSymbol = 0;

   //XDSLRTFW-3493(Start)
   uc_DtuIndex = guca_InpBufList[guc_InpBufListIndx];
   //If DTU index is valid, i.e < 0xFF
   if (uc_DtuIndex != 0xFF)
   {
      //DTU Start address
      ul_temp = (gt_ReTXParams.ul_DS_ReTXQueue_BaseAddress +
       (uc_DtuIndex * (gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS)));

      //Add offset to point to read SID, TS & DTU status next to the Padding bytes.
      //SID, TS, & DTU status was written next to padding bytes by Zephyr to make sure 32 Bit aligned payload can be easily DMAed to the
      //TC layer special memory.
      ptr_SidTsDtuStatus = (uint32 *)(ZEP_RAM_IIBRAM_ADDR + ul_temp + gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes);

      ul_data = *ptr_SidTsDtuStatus;
      ul_Temp1 = (ul_data & 0x00FF0000) >> 16;  //Get the DTU Status <23:16>

      if (ul_Temp1 != 0xFF)
      {
         //Complete DTU is available and reinitialize SID<7:0>, TS<15:8> and STATUS<23:16> and DUMMY<31:24>
         *ptr_SidTsDtuStatus = 0xFFFFFFFF;
      }
   }
   else
   {
      ul_Temp1 = uc_DtuIndex;  //set ul_Temp1 to 0xFF to exit the loop.
   }
   //XDSLRTFW-3493(End)

   //XDSLRTFW-3493(Start_End)
   //DTU status expected would be 0 (Good), 1 (Bad), 0xFF (Complete DTU is not available).
   if (ul_Temp1 != 0xFF)
   {
      if (!gft_NotFirstDTU)
      {
         // synchronize our estimated TS with CO TS
         gft_NotFirstDTU = 1;
         guc_EstimatedTS = 0;
      }

      ull_64MostRecentDtuStats = gt_RrcStat.ull_64MostRecentDtuStats;
      uc_AbsDtuNum = gt_RrcStat.uc_AbsDtuNum;
      //XDSLRTFW-1571 (Start)
      uc_QretxSize = gt_ReTXParams.uc_Qrx;

      uc_NumDTUsInThisSymbol = 0;
      uc_InpBufListIndx = guc_InpBufListIndx;
      s_NumFreeBufs = (int16)gt_FreeBufList.uc_NumNodes;
      ft_Qrx_Full = gft_Qrx_Full;

      //XDSLRTFW-1393 (Start_End)
      uc_Temp_Rd_SID_idx = ModXIncrY(guc_Rd_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);
      uc_Temp2_Rd_SID_idx = uc_Temp_Rd_SID_idx;

      while ((ul_Temp1 != 0xFF) && (uc_NumDTUsInThisSymbol < 3))
      {
         uc_SID =  ul_data & 0x000000FF;          //Get the SID <7:0>
         uc_TS  =  ((ul_data & 0x0000FF00) >> 8); //Get the TS <15:8>

         uc_DtuStat =  ul_Temp1;

         //XDSLRTFW-1617 (Start)
         if (uc_DtuStat)
         {
            gs_bad_dtu++;
         }
         //XDSLRTFW-1617 (End)

         ull_64MostRecentDtuStats <<= 1;
         uc_AbsDtuNum++;

         //if (uc_ILVBWrptrTableIndx != uc_InpBufListIndx) {
         /* We should never come here !!!*/
         //gft_PauseOff = 0;
         //Pause(0x3333);
         //}

#ifdef ENABLE_THREE_NEEDLE_TEST
         if (guc_StartThreeNeedle == 1)
         {
            if (guc_ThreeNeedleBadDTUCount < 3)
            {
               uc_DtuStat = BAD_DTU;
               guc_ThreeNeedleBadDTUCount++;

               if (guc_ThreeNeedleBadDTUCount == 3)
               {
                  guc_ThreeNeedleCount++;
               }
            }

            if (guc_ThreeNeedleCount == 3)
            {
               guc_StartThreeNeedle = 0;

               gus_ThreeNeedleDurationCount = 1;
            }

            guc_CountToNextNeedle++;
            if (guc_CountToNextNeedle == (gs_DsQTx+1)) //-2, -1
            {
               guc_ThreeNeedleBadDTUCount = 0;
               guc_CountToNextNeedle = 0;
            }
         }
         else
         {
            guc_ThreeNeedleBadDTUCount = 0;
            guc_ThreeNeedleCount = 0;
            guc_CountToNextNeedle = 0;

            if (gus_ThreeNeedleDurationCount > 0)
            {
               gus_ThreeNeedleDurationCount++;
               if (gus_ThreeNeedleDurationCount == 90)
               {
                  gft_PauseOff = 0;
                  Pause(0x6769);
               }
            }
         }
#endif

         uc_DtuIndex = guca_InpBufList[uc_InpBufListIndx];

         if (ft_Qrx_Full == TRUE)
         {
            if ( (gta_QretxTable[uc_Temp2_Rd_SID_idx].uc_Stat == GOOD_DTU) ||
                  ((uc_DtuStat == GOOD_DTU) && (uc_SID == gta_QretxTable[uc_Temp2_Rd_SID_idx].uc_SID)) )
            {
               ft_Qrx_Full = FALSE;
               uc_Temp2_Rd_SID_idx = ModXIncrY(uc_Temp2_Rd_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);
            }
         }
         //XDSLRTFW-1393 (Start)
         //Detect 'DTU Stoppage period' after CPE has sent DS_SRA_RETX_REQ to CO.
         if (gft_Start_DTU_Stoppage_Detection == TRUE)
         {
            uc_DtuStat_Temp = (ft_Qrx_Full == FALSE)? uc_DtuStat : BAD_DTU; //Treat all DTUs as bad during Q-Full condition

            uc_DTU_Status_Arr_Indx = guc_DTU_Status_Arr_Indx;
            gt_DTU_Status_Arr[uc_DTU_Status_Arr_Indx].uc_SID = uc_SID;
            gt_DTU_Status_Arr[uc_DTU_Status_Arr_Indx].uc_DTU_Stat = uc_DtuStat_Temp;
            guc_DTU_Status_Arr_Indx = ModXIncrY(uc_DTU_Status_Arr_Indx, 1, (gs_DsQTx+1));

            ul_Temp3 = uc_DTU_Status_Arr_Indx - gs_DsQTx;
            if ((int32)ul_Temp3 < 0)
            {
               ul_Temp3 = (int32)ul_Temp3 + (gs_DsQTx+1);
            }

            if ((uc_DtuStat_Temp == GOOD_DTU) &&
                  (gt_DTU_Status_Arr[ul_Temp3].uc_DTU_Stat == GOOD_DTU))
            {
               if (uc_SID == gt_DTU_Status_Arr[ul_Temp3].uc_SID)
               {
                  guc_DTU_Stoppage_Detect_Cntr++;

                  if (guc_DTU_Stoppage_Detect_Cntr == 4)
                  {
                     gft_DTU_Stoppage_Detected = TRUE;
                  }
               }
               else
               {
                  guc_DTU_Stoppage_Detect_Cntr = 0;
                  gft_DTU_Stoppage_Detected = FALSE;
               }
            }
         }

#ifdef ENABLE_RETX_DS_DEBUG
         {
            //The following code uses ST Vectoring Buffer 'gsa_StVectoringBuffer' (Size 8k bytes) for storing debug data.
            //Hence added a check to prevent debug data logging when vectoring mode is enabled.
            if (guc_ReTxDebugBufWrEnable == 1)
            {
               gpuca_ReTxDebugBuf = (uint8 *)((uint32)guca_RetxDebugBuffer + gus_ReTxDebugBufIdx);

               *gpuca_ReTxDebugBuf++ = uc_SID;
               *gpuca_ReTxDebugBuf++ = uc_DtuIndex;
               *gpuca_ReTxDebugBuf++ = (uint8)(((ft_Qrx_Full&1) << 7) |
                                               ((gft_DTU_Stoppage_Detected&1) << 6) |
                                               ((gft_SRAInvSync_Detected&1) << 5) |
                                               ((gft_DsSraReTxInit&1) << 4) |
                                               (uc_DtuStat & 0xF));
               *gpuca_ReTxDebugBuf++ = guc_Wr_SID_idx;

               *gpuca_ReTxDebugBuf++ = gta_QretxTable[guc_Wr_SID_idx].uc_SID;
               *gpuca_ReTxDebugBuf++ = guc_Rd_SID_idx;
               *gpuca_ReTxDebugBuf++ = gta_QretxTable[guc_Rd_SID_idx].uc_SID;
               *gpuca_ReTxDebugBuf++ = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_SID;

               *gpuca_ReTxDebugBuf++ = (uint8)guc_QRxFullCntr;
               *gpuca_ReTxDebugBuf++ = (uint8)guc_QRetxTableFullCntr;
               *gpuca_ReTxDebugBuf++ = (uint8)gs_RxPMDFrameCount;
               *gpuca_ReTxDebugBuf++ = (uint8)s_NumFreeBufs;

               *gpuca_ReTxDebugBuf++ = guca_InpBufList[0]; //guc_Prev_Rd_SID_idx;
               *gpuca_ReTxDebugBuf++ = guca_InpBufList[1]; //guc_Prev_Rd_SID;
               *gpuca_ReTxDebugBuf++ = guca_InpBufList[2]; //guc_Prev_Rd_DTU_idx;
               //*gpuca_ReTxDebugBuf++ = guca_InpBufList[3]; //guc_Prev_Rd_DTU_idx;
               *gpuca_ReTxDebugBuf++ = (uint8)((gt_ReTXStats.ul_UncorrectedDtuCnt & 0x3) |
                                               ((gt_ReTXStats.ul_BadDtuCnt & 0x3) << 2) |
                                               ((gt_ReTXStats.ul_UnexpectedDtuCnt & 0x3) << 4) |
                                               ((gt_ReTXStats.ul_ForwardedDtuCnt & 0x3) << 6));
               //Filled up 12 bytes of data
               gus_ReTxDebugBufIdx += 16;
               if (gus_ReTxDebugBufIdx == (12*1024))
               {
                  gus_ReTxDebugBufIdx = 0;
               }
            }
         }
#endif
         //XDSLRTFW-1393 (End)

         //Treat all DTUs as bad during Q-Full condition
         if (ft_Qrx_Full == TRUE)
         {
            uc_DtuStat = BAD_DTU;
         }

         // save SID and TS in translation table
         ft_DTUAccepted = UpdateQretxTable(uc_DtuStat, uc_SID, uc_TS, uc_DtuIndex);

         if (ft_DTUAccepted == TRUE)
         {
            guca_InpBufList[uc_InpBufListIndx] = 0xFF;
            s_NumFreeBufs--;
            if (s_NumFreeBufs <= 0)
            {
               ft_Qrx_Full = TRUE;
            }
         }

         //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
         if (gft_DsUsReTxDiagEnter == TRUE)
         {
            uc_DtuStat = GOOD_DTU; //XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (Start_End)
         }
         //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)

         if (uc_DtuStat != GOOD_DTU)
         {
#ifdef ENABLE_RETX_US_DEBUG1
            gula_PalakDebug[0] += 1;
#endif
            ull_64MostRecentDtuStats |= 1;

            //gt_ReTXParams.Un_UcodeReTXParam2.t_Param2.us_DtuPayloadSize *8
            //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
            //XDSLRTFW-1393 (Start_End)
            gt_ReTXStats.ul_ErroredBitsPerSec += (gt_ReTXParams.ul_DtuPayloadSize << 3);
         }

         gt_ReTXStats.ul_TotalDtuCnt++;


         uc_InpBufListIndx++;
         if (uc_InpBufListIndx == ILVB_WRPTR_TABLE_SIZE_LW)
         {
            uc_InpBufListIndx = 0;
         }

         //XDSLRTFW-3493(Start)
         //Preparation to get the next DTU status
         uc_DtuIndex = guca_InpBufList[uc_InpBufListIndx];
         if (uc_DtuIndex != 0xFF)
         {
            //DTU Start address
            ul_temp = (gt_ReTXParams.ul_DS_ReTXQueue_BaseAddress +
             (uc_DtuIndex * (gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS)));

            //Add offset to point to read SID, TS & DTU status next to the Padding bytes.
            //SID, TS, & DTU status was written next to padding bytes by Zephyr to make sure 32 Bit aligned payload can be easily DMAed to the
            //TC layer special memory.
            ptr_SidTsDtuStatus = (uint32 *)(ZEP_RAM_IIBRAM_ADDR + ul_temp + gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes);

            ul_data = *ptr_SidTsDtuStatus;
            ul_Temp1 = (ul_data & 0x00FF0000) >> 16;  //Get the DTU Status <23:16>
            if (ul_Temp1 != 0xFF)
            {
               //Complete DTU is available and reinitialize SID<7:0>, TS<15:8> and STATUS<23:16> and DUMMY<31:24>
               *ptr_SidTsDtuStatus = 0xFFFFFFFF;
            }
         }
         else
         {
            ul_Temp1 = uc_DtuIndex;  //set ul_Temp1 to 0xFF to exit the loop.
         }
         //XDSLRTFW-3493(End)

         uc_NumDTUsInThisSymbol++;

      }// While()
      //XDSLRTFW-1571 (End)

      gt_RrcStat.uc_AbsDtuNum = uc_AbsDtuNum;
      gt_RrcStat.ull_64MostRecentDtuStats = ull_64MostRecentDtuStats;
      gt_RrcStat.ft_RrcStatUpdated = 1;
   }

//   if ((gs_bad_dtu > 20) && (gus_dbg_pmdlen & 0x1000))
//   {
//      gft_PauseOff = 0;
//      Pause(0x6666);
//   }

   ForwardDtusToPPE();

   //Populate the input buffer list -> to be populated by microcode
   for (i = 0; i < uc_NumDTUsInThisSymbol; i++)
   {
      if (guca_InpBufList[guc_InpBufListIndx] == 0xFF)
      {
         uc_DtuIndex = pop_node(&gt_FreeBufList.uc_Head,&gt_FreeBufList.uc_NumNodes);

         if (uc_DtuIndex == 0xFF)
         {
#ifdef ENABLE_RETX_DS_DEBUG
            //We should never come here !!!
            gft_PauseOff = 0;
            Pause(0x4444);
#endif
            //guc_ReTxDebugBufWrEnable = 0;
            EnterFailStates(E_CODE_QRX_BUFFER_NOT_AVAILABLE);
            break;
         } else {
               //XDSLRTFW-3493(Start)
               //DTU Start address
               ul_temp = (gt_ReTXParams.ul_DS_ReTXQueue_BaseAddress +
                (uc_DtuIndex * (gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS)));

               guca_InpBufList[guc_InpBufListIndx] = uc_DtuIndex;
               *((uint32 *)__gula_ZrIlvbWrPtrTable[guc_InpBufListIndx]) = ul_temp;

               //Add offset to a point to clear SID, TS & DTU status next to the Padding bytes.
               ptr_SidTsDtuStatus = (uint32 *)(ZEP_RAM_IIBRAM_ADDR + ul_temp + gt_ReTXParams.ul_DtuPayloadSize + gt_ReTXParams.l_NumPaddingBytes);

               //Complete DTU is available and reinitialize SID<7:0>, TS<15:8> and STATUS<23:16> and DUMMY<31:24>
               *ptr_SidTsDtuStatus = 0xFFFFFFFF;
               //XDSLRTFW-3493(End)
         }
      }

      guc_InpBufListIndx++;
      if (guc_InpBufListIndx == ILVB_WRPTR_TABLE_SIZE_LW)
      {
         guc_InpBufListIndx = 0;
      }
   }

   gft_Qrx_Full = FALSE;
   if (gt_FreeBufList.uc_NumNodes == 0)
   {
      gft_Qrx_Full = TRUE;
      guc_QRxFullCntr++; //XDSLRTFW-3182 (Start_End)
   }

#ifdef ENABLE_RETX_DS_DEBUG
   {
      uint32 ul_DTU_0, ul_DTU_1, ul_DTU_2;

      ul_DTU_0 = *((uint32 *)__gula_ZrIlvbWrPtrTable[0]);
      ul_DTU_1 = *((uint32 *)__gula_ZrIlvbWrPtrTable[1]);
      ul_DTU_2 = *((uint32 *)__gula_ZrIlvbWrPtrTable[2]);

      if ((ul_DTU_0 == ul_DTU_1) || (ul_DTU_1 == ul_DTU_2) || (ul_DTU_2 == ul_DTU_0))
      {
         gft_PauseOff = 0;
         Pause(0xAAAA);
      }

   }
#endif

   return;
}


/*****************************************************************************
;   Subroutine Name: Calculate_DiscardFrame_Threshold()
;
;   This subroutine evaluates the metric of each DMT symbol and set the frame
;   discard flag for DD adaptation.
;
;   Prototype:
;      void Erasure_Reconfig(void)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Global Variable used by this file:
;
;****************************************************************************/

#define LOG_LOWMETRIC
extern FlagT gft_EnableLogLowMetric;
extern FlagT gft_frame_with_lowmetric_pre;
extern int16 gs_LogLowMetricCnt;
extern int16 LogLowMetricBufSize;
extern int32 *gpla_LogLowMetricBuf;

void Calculate_DiscardFrame_Threshold(void)
{
   //read the metric of most recent DMT symbol.
   uint8 uc_metric_value =0;


   //read metric value from QT register
   ReadMetricValue();

   uc_metric_value = gul_metric_value &0xFF;

   //In the first three second (12000 symbols), determine the threshold.
   //check flag to (re)calculate the threshold from discarding frame. The flag is set to 1 initially.
   if (gft_Calculate_EdMetric_PilotPwr_Threshold) // XDSLRTFW-2481 (only variable name changed)
   {
      //reset the max_metric and min_metric during the first frame of the evaluation period
      if (gus_metric_eval_cnt == 0)
      {
         guc_max_metric = 0;
         guc_min_metric = 0xFF;
         gus_metric_eval_cnt ++;

         gs_LogLowMetricCnt = 0;
         gft_frame_with_lowmetric_pre = 0;
      }
      // find the max metric  over gus_metric_eval_period
      else if (gus_metric_eval_cnt < gus_metric_eval_period)
      {
         gus_metric_eval_cnt ++;
         if (uc_metric_value > guc_max_metric)
         {
            guc_max_metric = uc_metric_value;
         }
         else if (uc_metric_value < guc_min_metric)
         {
            guc_min_metric = uc_metric_value;
         }
      }
      else // if (gus_metric_eval_cnt == gus_metric_eval_period)
      {
         gus_metric_eval_cnt = 0;
         //case of impulse noise is present when entering showtime
         if (((guc_max_metric - guc_min_metric) > 32) || (guc_max_metric > (2* guc_min_metric)))
         {
            guc_metric_discard_threshold = guc_min_metric + (guc_max_metric - guc_min_metric)/4;
         }
         else // case of FT type of impulse noise: set the discard threshold = 0.5*(guc_max_metric)
         {
            guc_metric_discard_threshold = guc_max_metric/2;
         }

      //XDSLRTFW-3015 (Start)
      // guc_EdMetricThresholdDuringExtNoise is used in RunPLL() at showtime
         // On very short loop, with low power SHINE pulses ( eg. 10 dB more than the background  noise),
         // erasure metric threshold for external noise detection logic was not optimum.
         // Also on very long where DS data rate is very low (<5 mbps), fiexd erasure metric threshold for external
         // noise detection was not optimum.
         // To overcome these corner cases, a new noise detection threshold logic is introduced.
         //
         // if (Maximum ED Metric value in Showtime >= 60 )
         //       Threshold = 10 , This fixed valuse is determined based on experiment , Please look in jira for more detail
         // Else if (Maximum ED Metric value in Showtime >= 20 )
         //       Threshold = 5 , This fixed valuse is determined based on experiment , Please look in jira for more detail
         // else
         // Threshold = (Max ED metric)/4 , This variable valuse is determined based on experiment , Please look in jira for more detail


         //if (guc_max_metric >= ERASURE_METRIC_THRESHOLD_HIGH_DS_DR)
         //   guc_EdMetricThresholdDuringExtNoise = ED_THRESHOLD_FOR_PLL_DURING_EXTERNAL_NOISE_SHORT_LOOP;
         //else if(guc_max_metric >= ERASURE_METRIC_THRESHOLD_MID_DS_DR)
         //   guc_EdMetricThresholdDuringExtNoise = ED_THRESHOLD_FOR_PLL_DURING_EXTERNAL_NOISE_MID_LONG_LOOP;
         //else
         //  guc_EdMetricThresholdDuringExtNoise = guc_max_metric >> 2;

      //XDSLRTFW-3015 (End)

         //reset the discard threshold calculation flag
         gft_Calculate_EdMetric_PilotPwr_Threshold =0;
      }
   }


   // if the metric of current frame is lower than the threshold for discarding,
   // lable the frame as lowmetric frame and exclude it from snr accumulation
   if (uc_metric_value < guc_metric_discard_threshold)
   {
      gft_frame_with_lowmetric = 1;
   }
   else
   {
      gft_frame_with_lowmetric = 0;
   }

   //To ensure that the snr update to happen if CO drops link, set a minimum update threshold
   //in gus_lowmetric_detect_period(=200) symbols, at least gus_lowmetric_discard_max=100
   //symbols are included in the snr update.
   if (gus_lowmetric_detect_cnt++ == gus_lowmetric_detect_period) //counter for detection
   {
      gus_lowmetric_detect_cnt = 0;
      gus_lowmetric_discard_cnt = 0;
   }

   if (gft_frame_with_lowmetric)  //counter for discard
   {
      if (gus_lowmetric_discard_cnt < gus_lowmetric_discard_max)
      {
         gus_lowmetric_discard_cnt ++;
         gul_num_frame_lowmetric ++;
      }
      else
      {
         gft_frame_with_lowmetric = 0;
      }
   }

   if(gft_EnableLogLowMetric)
   {
      if (gft_frame_with_lowmetric != gft_frame_with_lowmetric_pre)
      {
         if(gs_LogLowMetricCnt < (LogLowMetricBufSize-2))
         {
            gpla_LogLowMetricBuf[gs_LogLowMetricCnt++] = uc_metric_value|(gft_frame_with_lowmetric<<8);
            gpla_LogLowMetricBuf[gs_LogLowMetricCnt++] = gl_RxSymbolCount;
         }

         gft_frame_with_lowmetric_pre = gft_frame_with_lowmetric;
      }
   }

   if(gft_DisableDiscardFrame == 1)
   {
      gft_frame_with_lowmetric = 0;
   }

   //copy RTV0/RTV1 to FW accumulation buffer if a frame is a good frame.
   //otherwise, copy the FW acculmulation buffer to RTV0/RTV1 if a frame is of low metric.
   if ((gs_DDSnrFdqState == DD_SNRFDQ_CALC) && (guc_SnrCalcState == TRAINING_IN_PROGRESS))
   {
      if (TESTArray[TEST_Control4] & TEST_Control4_Ena_StAdma_Queue_Bit3_Mask)
      {
         gul_35bLiteConfig |= EN_ADMA_COPYBETWEEN_XRAM_RTV;
      }
      if (gft_frame_with_lowmetric ==1)
      {
         LoadAccumulatedNoisetoRTV();
      }
      else if (gs_AlgHandlerCount < gs_AlgNumFramesToAccum) //gft_frame_with_lowmetric ==0
      {
         CopyAccumulatedNoisefromRTV();
         gs_AlgHandlerCount++;
      }
      else if (gs_AlgHandlerCount == gs_AlgNumFramesToAccum) //gft_frame_with_lowmetric ==0
      {
         // XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling (Start_End)
         //Using DMA to get Accumulated Noise data -> To save Mips in RXTC task.
         ReadAccumulatedNoise2();
         gs_AlgHandlerCount++;
      }
      gul_35bLiteConfig &= ~(EN_ADMA_COPYBETWEEN_XRAM_RTV);
   }
}


void CheckZepSTAT_Rx_PMSRegs(void)
{
   uint32 ul_CriEvent;
   int32  l_cycles;
   uint16 i = 0;

   // Read CRI Event Register
   ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);

   if (ul_CriEvent & CRI_MASK_RX_PMS_DONE)
   {
      // RX PMS DONE
      // clear this event
      WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_RX_PMS_DONE);

   }
   else
   {
      if (guc_CasMode_enable)
      {
         //In cascaded mode wait till Zephyr completion and compare the expected time of completion, if time is exceeded
         //more than estimated time of completion, then enter the fail state.

         //wait till Zephyr completion
         //Waiting is required and noticed when Rx QT is processing Sync symbol and Zephyr is processing previous data symbol.
         //Rx QT finished much early for sync symbol before Zephyr completed its operation for data symbol, so DSL FW waiting is required
         //till Zephyr completed.
         do {
         i = i+ 1;
            ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);
//         } while (((ul_CriEvent & CRI_MASK_RX_PMS_DONE) == 0) && (i <= MAX_RX_LOOP_COUNT)); // XDSLRTFW-3229 (Start_End)
         } while (((ul_CriEvent & CRI_MASK_RX_PMS_DONE) == 0) && (i <= gs_dbg_MAX_RX_LOOP_COUNT)); // XDSLRTFW-3229 (Start_End)

         WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_RX_PMS_DONE);  //W1C, Write 1 to clear the bit

         ReadRxTimer((uint32 *)(void *)&l_cycles);
         //Rx PMS done Max MIPS
         l_cycles -= gl_RxTimer_RxPMSStart;
         if (l_cycles < 0)
         {
            l_cycles = (l_cycles + gl_MaxRxTimerCnt);
         }
         gl_RxTimer_RxPMSDone = l_cycles;
         if (l_cycles > gl_RxTimer_MaxRxPMSDone)
         {
            gl_RxTimer_MaxRxPMSDone = l_cycles;
         }

//         if ((gl_RxTimer_RxPMSDone > MAX_RX_PMS_ALLOWED_CYCLES) || (i > MAX_RX_LOOP_COUNT))
         if ((gl_RxTimer_RxPMSDone > gul_dbg_MAX_RX_PMS_ALLOWED_CYCLES) || (i > gs_dbg_MAX_RX_LOOP_COUNT))
         {
            gus_ZEP_RxPMSNotDone++;
            //Call Exception handler for cascaded mode
            EnterFailStates(E_CODE_RX_PMS_TIMEOUT);
         }
      }
      else
      {
         gus_ZEP_RxPMSNotDone++;
         //In Time Slotted mode if Rx Zephyr could not finish within 3 times slots (3*16384 = 49152), then Zephyr can enter into Fail state

         //Call Exception handler for Time Slotted mode.
         EnterFailStates(E_CODE_RX_PMS_TIMEOUT);
      }

   }
}


//DTB: Ping Pong
//DSL FW/DSP has to change the following every symbol to implement the ping-pong mechanism.
//This is a part of FW workaround for smaller DTB size in VRx518.
//a.QT: Change RX_DTB_OFFSET within register ZR_DTB_OFFSET_35B. Changing the RXDTB_WR_BASE is not required, as it an offset from RX_DTB_OFFSET
//b.Zephyr: Change DTB_BASE within register ZR_DTB_CTRL_35B
void  DtbPingPongConfiguration(void)
{
   uint32 ul_addr;
   uint32 ul_data;
   uint32 ul_RegBaseAddr_Lp;
   uint32 ul_PingPong_QtDtbBaseAddr;
   uint32 ul_PingPong_ZepDtbBaseAddr;

   if (gft_DisablePingPongDtb == FALSE)
   {
      //Use LP0 for Ping & Pong configuration for Non ReTx or US only ReTx
      //other case use LP1 for Ping & Pong
      if (((gus_DsUsReTxStatus & 0x3) == RETX_NOT_USED) || ((gus_DsUsReTxStatus & 0x3) == US_RETX_IN_USE))
      {
         //LP0 config
         ul_RegBaseAddr_Lp = ZEP_PRAM_RX_LP0_START_ADDR;
         ul_addr = ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR;
         if (gft_PingPongDtb)
         {
           ul_PingPong_QtDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP0_BASE_PONG;    //12:0 DTB_Base in 32-bit words
           ul_PingPong_ZepDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP0_BASE;
         }
         else
         {
           ul_PingPong_QtDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP0_BASE;         //12:0 DTB_Base in 32-bit words
           ul_PingPong_ZepDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP0_BASE_PONG;
         }
      }
      else
      {
         //LP1 config
         ul_RegBaseAddr_Lp = ZEP_PRAM_RX_LP1_START_ADDR;
         ul_addr = ZEP_REG_ZR_QTDTB_CONFIG_LP1_ADDR;
         if (gft_PingPongDtb)
         {
            ul_PingPong_QtDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP1_BASE_PONG;    //12:0 DTB_Base in 32-bit words
            ul_PingPong_ZepDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP1_BASE;
         }
         else
         {
            ul_PingPong_QtDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP1_BASE; //12:0 DTB_Base in 32-bit words
            ul_PingPong_ZepDtbBaseAddr = ZEP_ILV_RAM_RXDTB_LP1_BASE_PONG;
         }
      }

      //QT side DTB Ping Pong config LP0/LP1
      ReadCoreReg(ul_addr, &ul_data);
      ul_data &= 0xFFFFE000; //Mask DTB_Base bits 12:0
      ul_data |= ul_PingPong_QtDtbBaseAddr;
      WriteCoreReg(ul_addr, ul_data);

      //Zep side DTB Ping Pong config LP0/LP1
      ul_addr = ul_RegBaseAddr_Lp + ZR_DTB_CTRL_OFFSET;
      ReadCoreReg(ul_addr, &ul_data);
      ul_data &= 0xFFFFE000; //Mask DTB_Base bits 12:0
      ul_data |= ul_PingPong_ZepDtbBaseAddr; //12:0 DTB_Base in 32-bit words
      WriteCoreReg(ul_addr, ul_data);

      //Ping Pong
      if (gft_PingPongDtb)
         gft_PingPongDtb = FALSE;
      else
         gft_PingPongDtb = TRUE;

   }

}
