/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   filename: ShowtimeTxF_VDSL2.c
 *
 *   This file contains foreground (FG) functions for VDSL2 showtime Tx processing.
 *
 *-------------------------------------------------------------------------------
 */

// ***********************************************************************************************************
// ShowtimeTxF_VDSL2.c
//
// History
//
// 09/12/2013 Varun : Updated the calculation of US NDR when US ReTx is in use and SRA is triggered
//                    Grep for XDSLRTFW-1434
//
// 05/12/2012 Ram: Aligning to Msg Spec 1.8:- INFO 68, has no variable 'Line Rate'
//                 Grep for 'XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68'
//
// 06/05/2013 Varun : Added code(Debug option) to capture important variables to identify linkdrop conditions in
//                 Showtime
//                Grep for "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 09/05/2013 Kannan: Round of error corrected for l_NetDataRate computation.
//            Grep for "XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop "
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
// 19/09/2013 Varun : Added code to enable mips profiling if test 0 0 is 0x1000
//                    Note that in VDSL Rx enters showtime first(look timing diagram of VDSL2 for more details). since we want showtime mips when both tx
//                    and rx in showtime we enable the profile tasking when tx enters showtime. foreground mips peaking occurs at tx in RPSynchro6 state.
//                    Hence condition is checked in foreground in showtime.
//                     Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
//
// 29/10/2013 Sooraj: Added Support of US-SRA with ReTx
//                 Grep for XDSLRTFW-1263_DTU_Stoppage_Handling
//                          XDSLRTFW-1264_DTU_Stoppage_Framer_Handling
//                          XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode
//                          XDSLRTFW-1260_DTU_Handling_at_Framing Change for US-SRA in US-ReTx mode
//
// 8/11/2013 Palaksha: Fix for "XDSLRTFW-1344 US ReTx + SRA: UnCorrected DTUs observed during US DownShift and UpShift SRA"
//               It is observed that on every SRA transition 1 uncorrected DTU is observed.
//               The first DTU after SRA is going wrong. The fix includes clearing of ZT_CBYTE0_* registers as the
//               RS Encoder stores the intermediate syndromes in the ZT_CBYTE0_* registers
//            grep for XDSLRTFW-1344 BugFix_UsSra1UncorrectDTUPerSra
//
// 21/11/2013 Palaksha: Fix for "XDSLRTFW-1380 US ReTx + US SRA: UnCorrected DTUs observed during US SRA(DownShift and UpShift)
//               with REIN noise and SHINE"
//               It is observed that on some SRA transitions few uncorrected DTUs are observed with REIN and SHINE noise.
//            Root cause for the problem is
//                   (1) Starting of RRC evaluation after every SRA was not always right (ii) In DTU stoppage time calculation
//                    old new framing params used instead of Old ones.
//            Solution includes: (i) New implementaion done for RRC evaluation after every SRA
//                  (ii) In DTU stoppage time calculation use Old framing params
//            grep for XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine
//
//
// 09/09/2014 Kannan: TX scrambler state & RS check bytes are not cleared, since framing processors
//            internal states are continued without resetting for US SRA.
//            Micro code loading is not required once more for SRA,
//            since micro code executable is already swap in and is availble at IIBRAM.
//            Grep for "XDSLRTFW-1830"
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2341".
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "showtime.h"
#include "show_iof.h"
#include "tx_ib.h"
#include "OvhdMsg_IOf.h"
#include "eoc.h"
#include "profile.h"
#include "cmv.h"
#include "V_STR_IOf.h"
#include "DebugBuffer.h"
#include "vdsl_const.h"
#include "DshStreamAndEventDefines.h"

//#ifdef MTK_VECTORING_SUPPORT
#include "FormRErrorFeedbackMsg_VDSL2.h"
#include <string.h>
//#endif

#include "Us_Rtx.h"
#include "zep_memmap_cnfg.h"
#include "cmv_Data.h"
#include "cmv.h"
#include "vdsl_state.h"
#include "Framing_VDSL2.h"
#include "LL_IOf.h"
#include "cri_iof.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"  //XDSLRTFW-1474 (START-END)
#endif

void TxOLRPMHandler(void);

#define MICRO_INTERRUPT_SIMULATION
FlagT gft_EnableMIFlag = 0;
int16 gs_MI_duration = 1000;
int16 gs_MI_count = 0;

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
void UpdateTxRatesForSRA(void);
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
void InitUsReTxForSra_VDSL2(void);
// XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
extern void ConfigZephyrFcTxPath_VDSL2(void);
extern void ConfigZephyrIlvTxPath_VDSL2(void);
extern void LoadTxZepMicroCode(void);
// XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
extern int16 CalcDataBytesPerSymbol(uint8 uc_bc); //XDSLRTFW-1474 (START-END)

extern ReTX_ShowtimeParams_t gt_UsReTxShowtimeParams;
extern uint8 guc_MaxDtuPerSymb;

extern int32 gl_TxTimer_TxTcStart;
extern int32 gl_TxTimer_MaxTxTc;
extern int32 gl_TxTimer_TxNTcStart;
extern int32 gl_TxTimer_MaxTxNTc;


/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void ShowtimeTxF_VDSL2(void)
 *
 *   This function is used as the VDSL2 Tx Foreground (FG) task for showtime state.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */
void ShowtimeTxF_VDSL2(void)
{

//   int32 l_timer;
//
   ReadTxTimer((uint32 *)(void *)&gl_TxTimer_TxNTcStart);

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   if (gsa_IndirectStat0[0] == STAT_ShowTimeTCSyncState)
   {
      gsa_IndirectStat0[4]=VDSL2_SHOWTIME_TX_WITH_TC_SYNC;
   }
   else
   {
      gsa_IndirectStat0[4]=VDSL2_SHOWTIME_TX_NO_TC_SYNC;
   }
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   //#ifdef MTK_VECTORING_SUPPORT
   //   TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;
   //#endif

//#ifdef PROFILE_TASKS
//   int16 s_Timer;
//
//   //Record the TX TC task start time based on the RX timer
//   s_Timer = LogTaskProfile(TX_SHOWTIME_QT_DONE_NTC_START,0);
//#endif //PROFILE_TASKS

   //Simulate micro interrupt
   if(gft_EnableMIFlag)
   {
      if(gs_MI_count == 0)
      {
         //Set TX gain to 0
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, ClearTxVarGain);
      }
      else if((gs_MI_count == gs_MI_duration) && (gs_MI_duration != -1))
      {
         //Restore TX gain
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);

         gs_MI_count = -1;
         gft_EnableMIFlag = 0;
      }

      gs_MI_count++;
   } //if(gft_EnableMIFlag)

   // Check for the software fifo level every frame to figure out when to re-generate
   // the next set of ovhd data
   TxOvhdHandler();

   // prepare TX IB for the next superframe
   // triggered once per superframe inside WriteTxIbHwFifo()
   // right after HW FIFO is filled with 3 IB bytes
   if (gus_ShowtimeControl & MASK_PROCESS_TX_IB)
   {
      TxIbHandler();
   }

   // XDSLRTFW-3107 Check for Rx EOC timeouts
   CheckUSEocTimeOut();

   // run OLR/PM state machine
   TxOLRPMHandler();

   // update PMD frame counter which goes from 0 to 256
   gs_TxPMDFrameCount++;

#ifdef DEBUG_TRACES
   // XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   if((gsa_IndirectStat0[0] == STAT_ShowTimeState) || (gsa_IndirectStat0[0] == STAT_ShowTimeTCSyncState))
   {
      ShowtimeDebugBuffUpdate();
   }
#endif

   if (gs_TxPMDFrameCount > TX_DATA_SYMBOLS_PER_SUPERFRAME)
   {
      gs_TxPMDFrameCount = 0;


   }

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   LogTaskProfile(TX_SHOWTIME_QT_DONE_NTC_END,s_Timer);
//#endif //PROFILE_TASKS
//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   if ((guc_CasMode_enable) && (gft_EnableTaskProfile))
   {
      int32 l_TxNtc_Cycles; //XDSLRTFW-3901 (START_END)
      //Max & Min Cycles for Sync and Data symbol
      //Sync symbol checking is done after PMD count increment
      //hence gs_TxPMDFrameCount = 0 would be cycles consumed for previous
      //sync symbol.
      if (gs_TxPMDFrameCount != 0)
      {
         LogTaskProfile(ST_TX_NTC_QT_DONE_DATA_SYMBOL, gl_TxTimer_TxNTcStart);
      }
      else
      {
         LogTaskProfile(ST_TX_NTC_QT_DONE_SYNC_SYMBOL, gl_TxTimer_TxNTcStart);
      }
      //XDSLRTFW-3901 (START)
      //Go for exception if Tx NTC task exceeds > 5K cycles
      ReadTxTimer((uint32 *)(void *)&l_TxNtc_Cycles);
      l_TxNtc_Cycles -= gl_TxTimer_TxNTcStart;
      if(l_TxNtc_Cycles < 0) l_TxNtc_Cycles += gl_MaxRxTimerCnt;

      if (l_TxNtc_Cycles > 5000)
      {
        //Enter fail state if Tx NTC task exceeds the cycle budget.
        EnterFailStates(E_CODE_TX_NTC_CYCLES_TIMEOUT);
      }
      //XDSLRTFW-3901 (END)
   }
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

}

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void TxOLRPMHandler(void)
 *
 *   This function runs TX OLR and PM state machine.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */

// ------------------------------------
//          OLR Statemachine
// ------------------------------------
// non-ReTx (IFEC mode)
// ------------------------------------|-----------------------------------|------------------------------------
// STATES: gt_TxOLRVars.uc_txOLRState  | SET in                            | next TASK
// ------------------------------------|-----------------------------------|------------------------------------
//    L0_STEADY_STATE               1  | OLR_TX_TBLCP_WAIT                 | wait for next OLR Msg / decode Msg in BG
//                                     | and Abandon_US_OLRPM              |
//    OLR_SEND_SYNC_INDICATOR       3  | rx_reconfig_cmd_handler:          | PHASE REVERSAL
//                                     | set after having decoded a valid  |
//                                     | US OLR request                    |
//    OLR_RECONFIGURE               5  | set in OLR_SEND_SYNC_INDICATOR    | update BAT/FG table
//                                     | when performing PHASE REVERSAL    |
//    OLR_TX_TBLCP_WAIT            18  | set in OLR_RECONFIGURE            | wait for BAT/FT table swap done
// ------------------------------------|-----------------------------------|------------------------------------

// ReTx
// ------------------------------------|-----------------------------------|------------------------------------
// STATES: gt_TxOLRVars.uc_txOLRState  | SET in                            | next TASK
// ------------------------------------|-----------------------------------|------------------------------------
//    L0_STEADY_STATE               1  | OLR_TX_TBLCP_WAIT                 | wait for next OLR Msg / decode Msg in BG
//                                     | and Abandon_US_OLRPM              |
//    OLR_SEND_RTX_SYNC_INDICATOR   6  | rx_reconfig_cmd_handler:          | PHASE REVERSAL
//                                     | set after having decoded a valid  |
//                                     | US OLR request                    |
//    OLR_RECONFIGURE               5  | set in OLR_SEND_SYNC_INDICATOR    | update BAT/FG table
//                                     | when performing PHASE REVERSAL    |
//    OLR_TX_TBLCP_WAIT            18  | set in OLR_RECONFIGURE            | wait for BAT/FT table swap done
// ------------------------------------|-----------------------------------|------------------------------------

void TxOLRPMHandler(void)
{
   switch (gt_TxOLRVars.uc_txOLRState)
   {

   case OLR_SEND_SYNC_INDICATOR: // OLR indicator

      if (gs_TxPMDFrameCount == TX_DATA_SYMBOLS_PER_SUPERFRAME - 2)
      {
         // Update the synch tone type for OLRs
         gt_TxOLRVars.uc_txOLRState = OLR_RECONFIGURE;

         /* Update the synch tone type to send inverted sync symbol */
         gs_TxSyncToneType = !gs_TxSyncToneType;

         //Update the number of synch flag transmitted
         gs_NumTxSynchFlags++;
         DSH_SendEvent(DSH_EVT_TX_PHASE_REVERSAL,sizeof(int16),&gs_TxSyncToneType);
         //XDSLRTFW-3107 only look at OLR/PRIO 0
         // once passing this point the OLR will be performed (as the inverted sync symbol has been send out)
         // Therefore reset gft_UsOlrInProgress here to disable the timeout check
         gft_UsOlrInProgress = FALSE;
      }

      break;


      // XDSLRTFW-1263_DTU_Stoppage_Handling (START)
   case OLR_SEND_RTX_SYNC_INDICATOR: // OLR indicator

      gt_TxOLRVars.s_ReTxSymCnt--;

      if (gt_TxOLRVars.s_ReTxSymCnt < 0)
      {
         //Initial state. Calculate distance (in DMT symbols) from the current symbol
         //till the 1st symbol with new framing. This distance should be bigger
         //than T_DTU_Stoppage and may be bigger than super frame.

         //a) distance till the 10th symbol after the nearest SYNC
         gt_TxOLRVars.s_ReTxSymCnt = (int16)(TX_DATA_SYMBOLS_PER_SUPERFRAME - gs_TxPMDFrameCount + (TDTU_STOP_MIN-1));

         //b) distance till the 1st suitable case
         while (gt_TxOLRVars.s_ReTxSymCnt < (int16)(gt_TxOLRVars.s_ReconfigSymCnt + 1))
         {
            gt_TxOLRVars.s_ReTxSymCnt +=  (TX_DATA_SYMBOLS_PER_SUPERFRAME + 1);
         }

      }

      // XDSLRTFW-1264_DTU_Stoppage_Framer_Handling (START)
      if (gt_TxOLRVars.s_ReTxSymCnt == (gt_TxOLRVars.s_ReconfigSymCnt + 1))
      {
         //at the next symbol exactly T_DTU_Stoppage symbols will remain
         //till the 1st symbol with new framing
         //Set Indication to force Zephyr to stop generation of new DTUs
         gft_StopNewDtu = TRUE;
      }
      // XDSLRTFW-1264_DTU_Stoppage_Framer_Handling (END)
      else if (gt_TxOLRVars.s_ReTxSymCnt == (TDTU_STOP_MIN+1))
      {
         //this is symbol just before SYNC
         //i.e. request SYNC inversion and provide new framing parameters

         // Update the synch tone type for OLRs
         gt_TxOLRVars.uc_txOLRState = OLR_RECONFIGURE;

         /* Update the synch tone type to send inverted sync symbol */
         gs_TxSyncToneType = !gs_TxSyncToneType;

         //Update the number of synch flag transmitted
         gs_NumTxSynchFlags++;

         DSH_SendEvent(DSH_EVT_TX_PHASE_REVERSAL,sizeof(int16),&gs_TxSyncToneType);
         //XDSLRTFW-3107 only look at OLR/PRIO 0
         // once passing this point the OLR will be performed (as the inverted sync symbol has been send out)
         // Therefore reset gft_UsOlrInProgress here to disable the timeout check
         gft_UsOlrInProgress = FALSE;
         gt_TxOLRVars.s_ReconfigSymCnt = BITSWAP_RECONFIG_SYMBOL;
      }

      break;
      // XDSLRTFW-1263_DTU_Stoppage_Handling (END)

   case OLR_RECONFIGURE:

      // Reconfigure cores starting from the tenth symbol in the next
      // DMT superframe

      // reconfigure cores related to PMD layer changes
      if (gs_TxPMDFrameCount == (gt_TxOLRVars.s_ReconfigSymCnt - 2))
      {
         if (gt_TxOLRVars.s_txOLRPMEvent == RECONFIG_Lp)
         {
            if (gt_TxOLRVars.s_ReTxSymCnt == (TDTU_STOP_MIN+1))
            {
               // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
               gt_tx_config_v2.s_Rp[LP1] = gt_UsReTxShowtimeParams.s_Reconfig_Rp;
               gt_tx_config_v2.s_Mp[LP1] = gt_UsReTxShowtimeParams.s_Reconfig_Mp;
               gt_tx_config_v2.sa_Bpn[LP1][BC0] = gt_tx_config_v2.sa_Reconfig_Bpn[LP1][BC0];
               gt_tx_config_v2.s_Fp[LP1] = 1;
               gt_tx_config_v2.s_Dp[LP1] = 1;
               //XDSLRTFW-2341 (Start)
               if(gft_IDILV_US_SRA_event == TRUE)
               {
                  gt_tx_config_v2.s_Dp[LP1] = gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q;
                  guc_ReTx_US_D = gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q;
               }
               //XDSLRTFW-2341 (End)
               //Table 9-3 of G.998.4: Tp[LP1] and Gp[LP1] is ZERO for framing type 1,2,3.
               //We support framing type 1,3 in US ReTx
               gt_tx_config_v2.s_Tp[LP1] = 0;
               gt_tx_config_v2.s_Gp[LP1] = 0;
               gt_tx_config_v2.s_Ip[LP1] =  ComputeCWSize(&gt_tx_config_v2, LP1);

               Compute_VDSL2Framing(&gt_tx_config_v2, &gt_tx_TPS_Map, &gs_PMDFramesPerTxIBStructure);
               // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)

               AddFunctionToFifo(gp_TxLoadingFunctionFifo, InitUsReTxForSra_VDSL2);
               gt_TxOLRVars.s_ReTxSymCnt = 0;
            }
            // Updatge the Lp paramter based on the received message
            gt_tx_config_v2.ul_Lp[LP0] = gt_tx_config_v2.ul_Reconfig_Lp[LP0];
            gt_tx_config_v2.ul_Lp[LP1] = gt_tx_config_v2.ul_Reconfig_Lp[LP1];
            //XDSLRTFW-1474 (START)
            {
               uint8  uc_bc = 0;
               uint8  uc_offset = 0;
               uint32 ul_data = 0;
               //Update look ahead register in PPE HW for every US SRA, this is
               //required for PPE HW to prepare the amount of data necessary for
               //next symbol due to change in the data rate.
               for (uc_bc=0; uc_bc<2; uc_bc++)
               {
                  uc_offset = (uc_bc)<<2;
                  //Configure bearer channel 0
                  if(gt_tx_TPS_Map.s_BCtoTPS[uc_bc] != 0)
                  {
                     //DREG_Bx_LADR
                     //Compute the average number of bytes per DMT symbol
                     //transfered from PPE to DFE
                     ul_data = (uint32)CalcDataBytesPerSymbol(uc_bc);
                     WritePpeReg((DREG_B0_LADR_ADDR + uc_offset), ul_data);
                  }
               }
            }
            //XDSLRTFW-1474 (END)
            // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
            AddFunctionToBkgdFifo((PtrToBkgdFunc)UpdateTxRatesForSRA);
            gus_USShowtimeEvents = 0x2;
            // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
            gt_TxOLRVars.s_txOLRPMEvent &= ~RECONFIG_Lp;
         }
         // Get ready to switch TX ping pong tables
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, SwitchTxTableForBitswap);
         // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
         gt_TxOLRVars.uc_txOLRState = OLR_TX_TBLCP_WAIT;

      }
      break;

   case OLR_TX_TBLCP_WAIT:

      if (gs_TxPMDFrameCount == (gt_TxOLRVars.s_ReconfigSymCnt))
      {
         //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (Start)
         //Commenting out as INFO 68 in Msg Spec 1.8 does not have variable 'Line Rate'
         //gt_LineStatusUS.ul_LineRate = gul_TxLineRate;
         //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (End)
         gt_TxOLRVars.uc_txOLRState = L0_STEADY_STATE;
         // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
      }
      break;
   }
}

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
void UpdateTxRatesForSRA(void)
{
   int32 l_NetDataRate, l_OHRate;
   VDSL2ComputeRates_t t_ComputeRates;
   int16 s_Path;

   //XDSLRTFW-1522 (Start)
   ReTx_ComputeInp_Params_t t_ComputeInp_Params;
   //XDSLRTFW-1522 (End)

   // Set local variables
   // Earlier we were taking the LP0 parameters always for Tx Rates computation
   // during US SRA. And because of this, the RATE_0 was not getting updated.
   // It was because we were using "gt_tx_config_v2.s_Nlp" was getting set to 1 and
   // we were taking s_Path as "LP0" (Nlp-1).
   // XDSLRTFW-3348 (Start_end)
   s_Path = guc_NumLantencyPath-1;
   t_ComputeRates.s_Path = s_Path;
   t_ComputeRates.s_Nfec = gt_tx_config_v2.s_Nfecp[s_Path];
   t_ComputeRates.s_Rp = gt_tx_config_v2.s_Rp[s_Path];
   t_ComputeRates.ul_Lp = gt_tx_config_v2.ul_Lp[s_Path];
   t_ComputeRates.us_Gp = gt_tx_config_v2.s_Gp[s_Path];
   t_ComputeRates.us_Mp = gt_tx_config_v2.s_Mp[s_Path];
   t_ComputeRates.us_Tp = gt_tx_config_v2.s_Tp[s_Path];


   //XDSLRTFW-1478(START)
   //reinitialize the ADR,TDR after SRA
   t_USRateInfo.ul_ADR=0;
   t_USRateInfo.ul_TDR=0;
   //XDSLRTFW-1478(END)

   //XDSLRTFW-1434(START)
   if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      Calc_Rates_UsReTx(&t_ComputeRates, gt_FormFramingParamsInputs_v2.s_fs, &l_OHRate, &l_NetDataRate);
   }
   else
   {
      // Update rates based on new Lp value
      ComputeRates(t_ComputeRates.ul_Lp, t_ComputeRates.s_Nfec, t_ComputeRates.s_Rp,
                   t_ComputeRates.us_Gp, t_ComputeRates.us_Mp, t_ComputeRates.us_Tp,
                   gt_FormFramingParamsInputs_v2.s_fs, &l_OHRate, &l_NetDataRate);
   }
   //XDSLRTFW-1434(END)

   //XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop (Start)
   //l_NetDataRate = (l_NetDataRate + 8)/16
   // convert NDR in Q28.4 to in unit of kbps
   //XDSLRTFW-572 : NewFeature_ALL_ALL_ALL_RateIn1Kbps(Start)
   l_NetDataRate = (l_NetDataRate + (1 << 3)) >> 4;
   //XDSLRTFW-572 : NewFeature_ALL_ALL_ALL_RateIn1Kbps(Stop)
   //XDSLRTFW-773 XDSLRTFW-914: BugFix_DS_ALL_ALL_RetxMode17MhzLinkdrop (End)

   //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start)
   t_USRateInfo.t_CurRate[s_Path].us_RateLSW = l_NetDataRate & 0xFFFF;
   t_USRateInfo.t_CurRate[s_Path].us_RateMSW = l_NetDataRate >> 16;

   //XDSLRTFW-1478(START)
   //AggregateDataRate=NDR+OHRate in kbps,oh rate in 28.4 format
   t_USRateInfo.ul_ADR+=(l_NetDataRate + (l_OHRate>>4));

   //Update the OH Rate in 28.4 format(kbps)
   t_USRateInfo.ul_OHRate[s_Path]=l_OHRate;
   //XDSLRTFW-1478(END)


   if((gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE) && (s_Path == LP1))
   {
      //XDSLRTFW-1522 (Start)
      //Note that This functions gets called with gs_data_path=1 only if US ReTx enabled ==> use the same OH rate as previous as there is no change in that
      t_USRateInfo.ul_ADR+=(t_USRateInfo.ul_OHRate[LP0]>>4);

      t_ComputeInp_Params.us_SHINE_ratio = gt_ReTXParams.us_US_SHINEratio;
      t_ComputeInp_Params.us_INP_min = gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min;
      t_ComputeInp_Params.us_INP_min_REIN = (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min_REIN & 0x1F);
      t_ComputeInp_Params.us_Iat_rein_flag = ((gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min_REIN>>7) & 0x1);
      t_ComputeInp_Params.us_DelayMax = gt_ReTXParams.t_ReTXConfigCMV.us_US_DelayMax;

      t_ComputeInp_Params.s_Nfecp = t_ComputeRates.s_Nfec;
      t_ComputeInp_Params.ul_Lp = t_ComputeRates.ul_Lp;

      t_ComputeInp_Params.us_Qtx = gt_ReTXParams.us_OPMS_UsQtx;
      t_ComputeInp_Params.us_Q = gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q;

      t_ComputeInp_Params.us_V = gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V;
      t_ComputeInp_Params.us_H = gt_ReTXParams.uc_US_H;

      //update the actual US INP values for LP1 only
      CalculateActualINP((int16 *)(void *)&gt_ReTXStats.us_US_InpActShine,(int16 *)(void *) &gt_ReTXStats.us_US_InpActRein, t_ComputeInp_Params);

      gt_ReTXStats.us_US_InpActShine= (10 * gt_ReTXStats.us_US_InpActShine); // s_INP_act_SHINE is in 0.1 symbols
      gt_ReTXStats.us_US_InpActRein = (10 * gt_ReTXStats.us_US_InpActRein); // s_INP_act_REIN is in 0.1 symbols
      //XDSLRTFW-1522 (End)
   }

}
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

void InitUsReTxForSra_VDSL2(void)
{
   //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start)
   //gft_InitialRRC = TRUE; //Not Needed here
   // guc_PrevAbsoluteDtuCountLsbs = 31;
   // gs_RoundTrip_Estimate = 0;
   gft_UsReTxSraStopRrcEval=TRUE;
   gft_UsReTxSraTRansDetect = FALSE;
   //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (end)
   // XDSLRTFW-1264_DTU_Stoppage_Framer_Handling (START)
   gft_StopNewDtu = FALSE;
   // XDSLRTFW-1264_DTU_Stoppage_Framer_Handling (END)

   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
   gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V = gt_UsReTxShowtimeParams.uc_DtuPaddingSize_V;
   gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q = gt_UsReTxShowtimeParams.uc_CWsPerDtu_Q;
   gt_ReTXParams.us_OPMS_UsQtx = gt_UsReTxShowtimeParams.uc_RPMS_Qtx;
   gt_ReTXParams.us_OPMS_UsLookBackValue = gt_UsReTxShowtimeParams.uc_RPMS_DsLookBackValue;

   gs_DTU_size = (gt_tx_config_v2.s_Nfecp[LP1]) * (gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q);// size in bytes
   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)

   //XDSLRTFW-1260_DTU_Handling_at_Framing Change for US-SRA in US-ReTx mode (START)
   gsa_size_num_bytes_transfer[0]=0;
   gsa_size_num_bytes_transfer[1]=0;
   gsa_size_num_bytes_transfer[2]=0;

   gl_RrcValid = -1;
   gs_RRCOffset = 0;

   gs_Delta_DTU_TX = 0;
   gl_TxAbsoluteDTUCount = 0;
   gul_retransmitted_delta=0;

   gs_ReTxTable_wr_pointer = -1;
   memset(gusa_ReTxTable, 0,  sizeof(uint16)*SIZETT);

   gs_num_RndTrip_Errors = 0;
   gs_num_discarded_DTUs=0;
   //XDSLRTFW-1830(START)
   gs_RTXusR_Size  = gt_tx_config_v2.s_Rp[LP1];
   gs_DTUtc_Size   = gs_DTU_size - gs_RTXusR_Size;
   gs_DTUi_SizeInr = 0;
   //XDSLRTFW-1830(END)
   gs_DtuSizeIncr = gs_DTU_size;
   gs_running_DTUSize=0;
   gl_UsReTxBufWrRunningAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;
   gl_UsReTxBufEndAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress + (gs_DTU_size * gt_ReTXParams.us_OPMS_UsQtx)-1;
   //XDSLRTFW-1260_DTU_Handling_at_Framing Change for US-SRA in US-ReTx mode (END)

   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
   gsa_TxBitsInFifo[LP1] = 0;
   WriteCoreReg(IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR, 0);
   //XDSLRTFW-1830(START)
   //No need to clear the TX scrambler state & RS check bytes, since framing processors
   //internal states are continued without resetting for US SRA. Micro code loading
   //is not required once more for SRA, since micro code executable is already swap in
   //and is availble at IIBRAM. This comment is appicable for with intra dtu interleaving
   //since mirco code is different for both with and w/o iDTU interleaving.
   //XDSLRTFW-3334 (START)
   //Reinitialization of TX scrambler state & RS check bytes is required
   //for every US SRA. This is applicable for without Intra DTU interleaving.
   //Without Reinitialization observed NE-LOS after US SRA.
   if (gft_US_IDILV_ucode == FALSE)
   {
      WriteCoreReg(ZEP_PRAM_ZT_SCR_STATE_LP1_ADDR, 0);
      //XDSLRTFW-1344 BugFix_UsSra1UncorrectDTUPerSra (Start)
      //Below code is needed at the start of SRA, otherwise 1st DTU will not be decoded
      // at CO side and causing un-corrected DTU
      WriteCoreReg(ZEP_PRAM_ZT_CHECKBYTE0_LP1_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZT_CHECKBYTE1_LP1_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZT_CHECKBYTE2_LP1_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZT_CHECKBYTE3_LP1_ADDR, 0);
   }
   //XDSLRTFW-3334 (END)
   //XDSLRTFW-1344 BugFix_UsSra1UncorrectDTUPerSra (End)
   //XDSLRTFW-1830(END)
   ConfigZephyrFcTxPath_VDSL2();
   //XDSLRTFW-1830(START)
   //XDSLRTFW-3334 (START)
   //Reinitialization of the Framing Processors internal states is required
   //for every US SRA. This is applicable for without Intra DTU interleaving.
   //Without Reinitialization observed FE-LOS after US SRA.
   if (gft_US_IDILV_ucode == FALSE)
   {
      LoadTxZepMicroCode();
   }
   //XDSLRTFW-3334 (END)
   //XDSLRTFW-1830(END)
   ConfigZephyrIlvTxPath_VDSL2();
   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
   // XDSLRTFW-1344 (START)
   // Tdtu is DTU size in symbols -> 0.5 <= Tdtu <= 4, Tdtu=S1*Q=8*Nfec*Q/L1 in Q8.8 format
   uint16 T_DTU = (uint32)(gs_DTU_size << 11) / gt_tx_config_v2.ul_Reconfig_Lp[LP1];
   // MaxDtuPerSymbol = floor(2/Tdtu)
   guc_MaxDtuPerSymb = (uint8) ((2 << 8) / T_DTU);
   // XDSLRTFW-1344 (END)
}

