/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ShowtimeTxTC_VDSL2.c
*
*   This file contains Time-Critical (TC) functions for VDSL2 TX showtime processing.
*
*-------------------------------------------------------------------------------
*/
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"
#include "show_iof.h"
#include "show_lpbk_iof.h"
#include "showtime.h"
#include "profile.h"
#include "OvhdMsg_IOf.h"
#include "interrupt_control.h"
#include "cri_iof.h"
#include "qt_memmap.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "Dsp_regs_62.h"
#include "vdsl_xception.h"
#include "Cri_iof.h"

extern void CaptureTxBitsInFifo(void);
void CheckZepSTAT_Tx_PMSRegs(void);

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ShowtimeTxTC_VDSL2(void)
*
*   This function is used for TX time critical (TC) task for VDSL2 showtime state.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#include "zep_memmap_cnfg.h"

void InsertDsRRCToDTB(void);
extern uint8 guc_RrcCnt;
extern RRC_Stat_t gt_RrcStat;
extern ReTX_Params_t gt_ReTXParams;
//extern FlagT gft_InsertRRC; //Not used in code
extern ReTX_Stats_t gt_ReTXStats;

extern uint32 gul_adma0_stat, gul_adma1_stat, gul_adma2_stat;

extern int32 gl_TxTimer_TxTcStart;
extern int32 gl_TxTimer_MaxTxTc;
extern int32 gl_TxTimer_TxNTcStart;
extern int32 gl_TxTimer_MaxTxNTc;
extern uint32 gul_TxTimer_TxQTDone;

extern int32 gl_TxQT_MaxTime;
extern int32 gl_TxQT_MinTime;

#ifdef NTR_INTRPT_POLL_ENABLE
void poll_ntr(void);
#endif

void ShowtimeTxTC_VDSL2(void)
{

//#ifdef PROFILE_TASKS
//   int32 s_Timer;
//#endif

  ReadTxTimer((uint32 *)(void *)&gl_TxTimer_TxTcStart);

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   s_Timer = LogTaskProfile(TX_SHOWTIME_QT_DONE_TC_START,0);
//#endif //PROFILE_TASKS

   // increment TC task count (may be used for showtime debug)
   // do it in the beginning of TC to be consistent with FG symbol count increment
   gl_TxTcCount++;

#ifndef QT_LATCH_LP_BITS
   // Read the bits in fifo

   // Note it is important to call this before exceuting the loading function as
   // it needs to read the Lp value that last PMD frame ran with. This may be changed by
   // loading functions for SRA handling
   CaptureTxBitsInFifo();
#endif //#ifdef QT_LATCH_LP_BITS

#ifndef ENABLE_PMS_DONE_INT_FOR_PMS_CYCLE_MEASUREMENT  //XDSLRTFW-3322 (Start)
   // check if Zephyr STAT indicates a failure
   // Read CRI Event register and check thatPMS_TX_DONE are set
   // clear these after reading
   if ((gs_TxPMDFrameCount != (TX_DATA_SYMBOLS_PER_SUPERFRAME)) && (gl_TxTcCount > 0 ))
   {
      CheckZepSTAT_Tx_PMSRegs();

   }
#endif  //XDSLRTFW-3322 (End)




   // execute loading function
   ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif



#ifndef QT_LATCH_LP_BITS
   // Compute the Zephyr transfer size
   ComputeTxTransferSize();
#endif //#ifndef QT_LATCH_LP_BITS

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

//#ifdef MTK_VECTORING_SUPPORT
   if (gft_TxFirstShwotimeSymbol)
   {
      gft_TxFirstShwotimeSymbol = FALSE;
      //DSM_Vectoring_Debug:
      //if ( gs_PauseControl == 0x56)
      //Pause(gs_PauseControl);
   }
//#endif // end #ifdef MTK_VECTORING_SUPPORT

// XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx(START)
   if(gt_ReTXParams.uc_UsReTxStatus==US_RETX_IN_USE)
   {
      //increment the Time stamp counter
      guc_TS_byte_Retx = (guc_TS_byte_Retx + 1 ) % 255;

      // update the timestamp register
      Update_TimeStamp_Register();

   }
   // XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx(END)

   // Synch frame processing support
   if (gft_dbg_SkipTxSyncFrame == 0)
   {
      if (gs_TxPMDFrameCount == (TX_DATA_SYMBOLS_PER_SUPERFRAME-1))
      {
         // Save the current PRBS registers
         SavePRBSRegisters();

#ifdef QT_LATCH_LP_BITS
         DisableTxQtLpBitsLatch();
         DisableTxPms();
#endif

         // Generate sync frame using HW PRBS generator
         EnableTxShowGenRef();
      }
      else
      {
         //XDSLRTFW-2392 (Cascaded scheduling - Start - End)
         if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) && (guc_CasMode_enable==0))
         {
            InsertDsRRCToDTB();
         }

         if (gs_TxPMDFrameCount == TX_DATA_SYMBOLS_PER_SUPERFRAME)
         {
            RestorePRBSRegisters();


#ifdef QT_LATCH_LP_BITS
            EnableTxQtLpBitsLatch();
            EnableTxPms();
#endif //#ifndef QT_LATCH_LP_BITS

            EnableTxDataMode();
         }

      }

   }

   // Write to the HW fifo once every TC task such that the HW fifo
   // always has the MAX_OVHD_BYTE_PER_FRAME bytes
   WriteTxOvhdHwFifo();

#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif

   // Execute per super-frame tasks
   TxSuperFrameProcess();

   // execute Tx TC showtime test code (e.g. enable corrupt crc)
   ShowtimeTxTCTestControl();

#ifdef ENABLE_SHOW_LPBK
   // enable TX-to-RX loopback
   if (CNTLArray[CNTL_ModemControl] & CNTL_ModemLoopback)
   {
      ShowtimeLoopbackTC();
   }
#endif //#ifdef ENABLE_SHOW_LPBK

#ifdef DEBUG_SHOWTIME
   // log TxDTB/IFFT buffer (IFFT for loopback test only) for showtime debug purpose
   LogTxBufAtTxQtTc();
#endif // DEBUG_SHOWTIME

#ifdef ZEP_DEBUG_BLD
   UpdateTxFifo3Stat();
#endif

//#ifdef PROFILE_TASKS
//   //Record the TX TC task start time based on the RX timer
//   LogTaskProfile(TX_SHOWTIME_QT_DONE_TC_END,s_Timer);
//#endif //PROFILE_TASKS


#ifdef NTR_INTRPT_POLL_ENABLE
   poll_ntr();
#endif
//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
   if ((guc_CasMode_enable) && (gft_EnableTaskProfile))
   {
      int32 l_TxTc_Cycles; //XDSLRTFW-3901 (START_END)

      //Max & Min Cycles for Sync and Data symbol
      if (gs_TxPMDFrameCount != TX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         LogTaskProfile(ST_TX_TC_QT_DONE_DATA_SYMBOL, gl_TxTimer_TxTcStart);
      }
      else
      {
         LogTaskProfile(ST_TX_TC_QT_DONE_SYNC_SYMBOL, gl_TxTimer_TxTcStart);
      }

      if (gl_TxTimer_TxTcStart > gt_CasFwTasksMipsCnt.l_Start_TX_TCtask_max)
      {
         gt_CasFwTasksMipsCnt.l_Start_TX_TCtask_max = gl_TxTimer_TxTcStart;
      }

      if (gl_TxTimer_TxTcStart < gt_CasFwTasksMipsCnt.l_Start_TX_TCtask_min)
      {
         gt_CasFwTasksMipsCnt.l_Start_TX_TCtask_min =  gl_TxTimer_TxTcStart;
      }

      //XDSLRTFW-3901 (START)
      //Go for exception if Tx TC task exceeds > 7K cycles
      ReadTxTimer((uint32 *)(void *)&l_TxTc_Cycles);
      l_TxTc_Cycles -= gl_TxTimer_TxTcStart;
      if(l_TxTc_Cycles < 0)
      {
         l_TxTc_Cycles += gl_MaxRxTimerCnt;
      }

      if (l_TxTc_Cycles > 7000)
      {
         gt_CasFwTasksMipsCnt.ul_TX_TC_MaxMipsCnt++;
         //Enter fail state if Tx TC task exceeds the cycle budget.
         //EnterFailStates(E_CODE_TX_TC_CYCLES_TIMEOUT);
      }
      //XDSLRTFW-3901 (END)
   }
#endif //PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)
}

// Wrapper function for StartTxDataPath. Needed for Arc build since function called from multimode PreShowtimeTxF.
void StartTxDataPath_VDSL2(void)
{
   StartTxDataPath();
}

void CheckZepSTAT_Tx_PMSRegs(void)
{
   uint32 ul_CriEvent;
   int32  l_cycles;
   uint16 i = 0;

   // Read CRI Event Register
   ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);

   if (ul_CriEvent & CRI_MASK_TX_PMS_DONE)
   {
      // TX PMS DONE
      // clear this event
      WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_TX_PMS_DONE);

   }
   else
   {
      if (guc_CasMode_enable)
      {
         //In cascaded mode wait till Zephyr completion and compare the expected time of completion, if time is exceeded
         //more than estimated time of completion, then enter the fail state.

         // REVIEW_STEFAN: TBD: This code is not covering all timeout issues
         do {
            i = i + 1;
            ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);
         } while (((ul_CriEvent & CRI_MASK_TX_PMS_DONE) == 0) && (i <= MAX_TX_LOOP_COUNT)); // XDSLRTFW-3229 (Start_End)

         WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_TX_PMS_DONE);  //W1C, Write 1 to clear the bit

         ReadTxTimer((uint32 *)(void *)&l_cycles);
         //Tx PMS done Max MIPS
         l_cycles -= gl_TxFcTimerCount;
         if (l_cycles < 0)
         {
            l_cycles = (l_cycles + gl_MaxRxTimerCnt);
         }
         gl_TxTimer_TxPMSDone = l_cycles;
         if (l_cycles > gl_TxTimer_MaxTxPMSDone)
         {
            gl_TxTimer_MaxTxPMSDone = l_cycles;
         }
         if ((gl_TxTimer_TxPMSDone > MAX_TX_PMS_ALLOWED_CYCLES) || (i > MAX_TX_LOOP_COUNT))
         {
            gus_ZEP_TxPMSNotDone++;
            //Call Exception handler for cascaded mode
            EnterFailStates(E_CODE_TX_PMS_TIMEOUT);
         }
      }
      else
      {
         gus_ZEP_TxPMSNotDone++;
         //In Time Slotted mode if Tx Zephyr could not finish within 3 times slots (3*16384 = 49152), then Zephyr can enter into Fail state

         //Call Exception handler for Time Slotted mode.
         EnterFailStates(E_CODE_TX_PMS_TIMEOUT);
      }

   }

}

// initialization of RRC_Stat_t
// ....


extern RRC_Stat_t gt_RrcStat;
void WriteRrcToLp2TxDTB(uint32 ul_PrevRrc);

#define GOLAY_CODING                   1

//
// Each time we send out RRC for just num_of_dtus_per_frame
// if there's no new coming RRC info, we'll resend the previous RRC
// to simplify our RRC processing.
//
// Initially, ul_PrevRrc will be set to 0 <=> first DTU is correct.
//

uint32 GolayCoding(uint32 ul_Rrc);

void InsertDsRRCToDTB(void)
{
   uint32 ul_PrevRrc;
   uint64 ull_64MostRecentDtuStats;
   uint32 ul_2MostRecentDtuStats;
   uint32 ul_31MostRecentDtuStats;
   uint32 ul_CurrAbsDtuNum;
   int32  i;


   i = gt_RrcStat.ft_RrcStatUpdated;
   ull_64MostRecentDtuStats = gt_RrcStat.ull_64MostRecentDtuStats;

   if (i)  // need to generate new RRC
   {
      ul_2MostRecentDtuStats = (uint32)(ull_64MostRecentDtuStats & 0x3);
      ul_31MostRecentDtuStats = (uint32)(ull_64MostRecentDtuStats >> 1);

      ul_CurrAbsDtuNum = gt_RrcStat.uc_AbsDtuNum & 0x1F;
      ul_PrevRrc = 0;

      if (ul_2MostRecentDtuStats & MASK_BIT1)
      {
         uint32 ul_LookBackMask;
         uint32 ul_LookBackCount;

         ul_LookBackCount = gt_ReTXParams.uc_RPMS_DsLookBackValue;
         ul_LookBackMask = 1 << ul_LookBackCount;

         // look for NACK==1 starting from 31st DTU
         for (i = ul_LookBackCount; i > 0; i--)
         {
            if ((ul_31MostRecentDtuStats & ul_LookBackMask) != 0)
            {
               break;
            }

            // ul_PrevRrc = consecutive count
            ul_PrevRrc++;
            ul_31MostRecentDtuStats <<= 1;
         }
      }
      else
      {
         // look for NACK==1 starting from 1st DTU
         for (i = 31; i > 0; i--)
         {
            if ((ul_31MostRecentDtuStats & MASK_BIT1) != 0)
            {
               break;
            }

            // ul_PrevRrc = consecutive count
            ul_PrevRrc++;
            ul_31MostRecentDtuStats >>= 1;
         }
      }

      ul_PrevRrc <<= 7;                                   // consecutive count starts at bit 7
      ul_PrevRrc |= (ul_2MostRecentDtuStats << 5);        // two most recent NACKs starts at bit 5
      ul_PrevRrc |= ul_CurrAbsDtuNum;


#ifdef EXTRA_RETX_LOG
      // log 2 most recent RRCs (without golay bits)
      gt_ReTXStats.ul_LastRrcs = (gt_ReTXStats.ul_LastRrcs << 16) | ul_PrevRrc;
#endif
      ul_PrevRrc = GolayCoding(ul_PrevRrc);

      gt_RrcStat.ul_PrevRrc = ul_PrevRrc;
      gt_RrcStat.ft_RrcStatUpdated = 0;

   }
   else
   {
      ul_PrevRrc = gt_RrcStat.ul_PrevRrc;
   }


   //WriteCoreReg((uint32)(ZEP_ILV_RAM_DTB_ADDR + (ZEP_ILV_RAM_TXDTB_LP2_BASE << 2)), ul_PrevRrc);
   WriteRrcToLp2TxDTB(ul_PrevRrc);


   return;
}

