/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: UsRTX_Tasks.c
*
*   This file contains retransmission task layer functions.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// UsRTX_Tasks.c
//
// History
// 19/11/2013 Varun : Added Debug Option to capture data of US ReTx when retranmission is happening.
//                    Data is collected only if normal showtime logging(log per 'X' Symbol and Super symbol logging) is disabled and showtime logging
//                    for US ReTx is enabled(2nd bit of gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData is set ==> disable
//                    US ReTx showtime logging)
//                    Grep for XDSLRTFW-1392
//
// 16/07/2013 Palaksha: Changes related to RRC Golay code word extration,Golay Decoding, RRC Evaluation
//            Grep for: XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC
//
// 29/10/2013 Sooraj: Added Support of US-SRA with ReTx
//                 Grep for XDSLRTFW-1264_DTU_Stoppage_Framer_Handling
//
// 21/11/2013 Palaksha: Fix for "XDSLRTFW-1380 US ReTx + US SRA: UnCorrected DTUs observed during US SRA(DownShift and UpShift)
//               with REIN noise and SHINE"
//               It is observed that on some SRA transitions few uncorrected DTUs are observed with REIN and SHINE noise.
//            Root cause for the problem is
//                   (1) Starting of RRC evaluation after every SRA was not always right (ii) In DTU stoppage time calculation
//                    old new framing params used instead of Old ones.
//            Solution includes: (i) New implementaion done for RRC evaluation after every SRA
//                  (ii) In DTU stoppage time calculation use Old framing params
//            grep for XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine
//
// 21/11/2013 Palaksha: XDSLRTFW-1406 Link drop observed with NVLT-G VR9 - 5.7.1.6.1.7 while doing DS ReTx + SRA with US ReTx + SRA
//              After introducing fix for "XDSLRTFW-1380", which was causing some link drops. This because Tx  retransmission
//              was blocked for as the RRC evaluation in Rx was not setting the flag.The solution includes more robust old DTU to
//              new DTU transition detection and flag control was moved from Rx to tx.
//    grep for XDSLRTFW-1406
//
// 26/06/2014 Palaksha
//      XDSLRTFW-1854:Implement RTX_TESTMODE for both US and DS ReTx mode
//         Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2341".
// ************************************************************************************************************
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"
#include "show_iof.h"
#include "show_lpbk_iof.h"
#include "profile.h"
#include "OvhdMsg_IOf.h"
#include "V_STR_IOf.h"
#include "IRI_Iof.h"
#include "cri_iof.h"
#include "mtkernel.h"

#include "cri_memmap.h"
#include "LL_IOf.h"
#include "DDSnrFdqHandler.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif //PPE_ENGINE

#ifdef DISTRIBUTE_TX_RX_PROCESS
#include "cri_iof.h"
#endif // DISTRIBUTE_TX_RX_PROCESS

//#ifdef MTK_VECTORING_SUPPORT
#include "FormRErrorFeedbackMsg_VDSL2.h"
#include "eoc.h"
#include "ShowtimeERBHandler.h"

#include "Us_Rtx.h"

//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UsReTx_WrTCtoILV_RdILVtoDTB(void)
*   This routine provides invokes
*    functions to transfer data from TC layer to ILV ReTx buffer in every DMT symbol
*    functions to transfer data ILV ReTx buffer to DTB in every DMT symbol
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void UsReTx_WrTCtoILV_RdILVtoDTB(int16 s_TransferSize_Lp1)
{
   //Write pointer Handler (Writing from TC layer to ILV retx buffer)
   UsReTx_WrFromTCtoILV(s_TransferSize_Lp1);

   //Read pointer Handler (reading ILV retx buffer and writing to DTB)
   UsReTx_RdFromILVtoDTB(s_TransferSize_Lp1);
}

/*
*-------------------------------------------------------------------------------
*
* UsReTx_WrFromTCtoILV(int16 s_TransferSize_Lp1)
*   This routine provides  inputs (Address and correponding buffer Sizes of part/full DTU/s in symbol) for Micro code Engine
*     to transfer data from TC layer to ILV ReTx buffer in every DMT symbol
* - Detects DTU boundaries
* - Updates ILV base pointer
*   Updates ReTx table pointer
*   Indicates new DTU to be transmitted or old DTU to be transmitted
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void UsReTx_WrFromTCtoILV(int16 s_TransferSize_Lp1)
{
   int32 *pl_DtuAddr = (int32 *) (US_RETX_WR_POINTERS_BASE_ADDR + ZEP_RAM_IIBRAM_ADDR);
   int16 i,s_DtuSize,s_count;
   int32 l_ReTXQueue_BaseAddress, l_ReTXQueue_EndAddress;
   int32 ul_data;
   //int16 s_DtuSizeIncr;
   int32 la_addr[3] = {0, 0, 0};
   int16 sa_size[3] = {0, 0, 0};
   //XDSLRTFW-1830 (START)
   guc_StNewDtuTc = 0;
   guc_StPartialDtuTc = 0;
   guc_num_Dtu_EndBoundary = 0;
//XDSLRTFW-2341 (Start)
   if(gft_US_IDILV_ucode)
   {
      guc_num_Dtu_EndBoundary = 1;
   }
//XDSLRTFW-2341 (End)
   //XDSLRTFW-1830 (END)

   s_DtuSize = gs_DTU_size;
   l_ReTXQueue_BaseAddress = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;  //ReTx Queue start address
   l_ReTXQueue_EndAddress = gl_UsReTxBufEndAddr;

   gs_DTU_id =0;
   gs_running_PMSSize=s_TransferSize_Lp1;

   if (gs_DtuSizeIncr == 0)
   {
      gs_DtuSizeIncr = s_DtuSize;
   }

   while (gs_running_PMSSize > 0)
   {
      if (gs_running_PMSSize < gs_DtuSizeIncr)
      {
         gs_DtuSizeIncr = gs_running_PMSSize;
      }

      if (gs_running_DTUSize == 0)
      {
         CheckForRetransmission();

         gsa_size_num_bytes_transfer[gs_DTU_id]=gs_DtuSizeIncr;
         guca_DTU_Status[gs_DTU_id] = gft_RetransmitReq;
//XDSLRTFW-2341 (Start)
         if((!gft_RetransmitReq) && (gft_US_IDILV_ucode))
         {
            guc_num_Dtu_EndBoundary += 1;
         }
//XDSLRTFW-2341 (End)
      }
      else
      {
         gsa_size_num_bytes_transfer[gs_DTU_id]=gs_DtuSizeIncr;
         guca_DTU_Status[gs_DTU_id] = gft_RetransmitReq;
      }

      gs_running_DTUSize += gs_DtuSizeIncr;
      gs_running_PMSSize -= gs_DtuSizeIncr;
      if ( gs_running_DTUSize >= s_DtuSize)
      {
         gs_running_DTUSize -= s_DtuSize;
      }

      gs_DtuSizeIncr = s_DtuSize -gs_running_DTUSize;

      gpla_ReTxWrPtrTable[gs_DTU_id] = gl_UsReTxBufWrRunningAddr;
      gl_UsReTxBufWrRunningAddr += gsa_size_num_bytes_transfer[gs_DTU_id];
      if (gl_UsReTxBufWrRunningAddr > l_ReTXQueue_EndAddress)
      {
         gl_UsReTxBufWrRunningAddr = l_ReTXQueue_BaseAddress;
      }

      gs_DTU_id++;
   }//while loop end

   s_count=0;
   for (i=0; i < gs_DTU_id; i++)
   {
      if(guca_DTU_Status[i] != 1)
      {
         la_addr[s_count] = gpla_ReTxWrPtrTable[i];
         sa_size[s_count] = gsa_size_num_bytes_transfer[i];
         //XDSLRTFW-1830 (START)
         //New I/F for TC layer for Microcode STARTs
         // Code to identify start of New DTU (guc_StNewDtuTc) , Number of DTU end boundaries (guc_num_Dtu_EndBoundary)
         //Partial DTU start(guc_StPartialDtuTc) in a DMT symbol.
         //These inputs will be used by FP3/FP4 framing procs
//XDSLRTFW-2341 (Start - End)
         if ((gs_DTUi_SizeInr == 0) && (!gft_US_IDILV_ucode))
         {
            guc_StNewDtuTc = 1;
            guc_StPartialDtuTc = 1; //New DTU could be part DTU
         }

         gs_DTUi_SizeInr += sa_size[s_count]; //@B
//XDSLRTFW-2341 (Start - End)
         if ((gs_DTUi_SizeInr >= gs_DTUtc_Size) && (!gft_US_IDILV_ucode)) //@C
         {
            guc_num_Dtu_EndBoundary += 1;
            guc_StPartialDtuTc = 0;//if PMS size > DTUtc size means this size already has complete DTU
         }

         if (gs_DTUi_SizeInr >= gs_DTU_size)
         {
            gs_DTUi_SizeInr -= gs_DTU_size;         //@D Wrap around of DTUsize
         }
//XDSLRTFW-2341 (Start - End)
         // if size[0] <= R check byte size , means thease bytes are only Check bytes, TC boundary already part of prev symbol
         if ( ((i == 0) && (sa_size[s_count] <= gs_RTXusR_Size)) && (!gft_US_IDILV_ucode) )
         {
            guc_num_Dtu_EndBoundary = 0; //@E
         }
         //New I/F for TC layer for Microcode ENDs
         //XDSLRTFW-1830 (END)
         s_count++;
      }

      //Write ILVB addresses in the write pointer table.
      //below code is to make sure that dummy is addes is not inlcued in WRPTR table
      //pl_DtuAddr[i] = la_addr[i];
   }

   //Size in bytes
   //15:0 of ZEP_PRAM_ZT_OHRATE_LP1_ADDR for WrPtrCnt0
   //31:16  of ZEP_PRAM_ZT_OHRATE_LP1_ADDR for WrPtrCnt1
   //ul_data =(uint32)  ((gsa_size_num_bytes_transfer[1]<<16) | gsa_size_num_bytes_transfer[0]);
   ul_data =(uint32)  ((sa_size[1]<<16) | sa_size[0]);
   WriteCoreReg(ZEP_PRAM_ZT_OHRATE_LP1_ADDR, ul_data);

   //31:16 ZEP_PRAM_ZT_R4_LP1_ADDR for WrPtrCnt2
   ReadCoreReg(ZEP_PRAM_ZT_R4_LP1_ADDR, &ul_data);
   //ul_data = (ul_data >> 16) & 0xFFFF;
   ul_data &= 0x0000FFFF;
   //ul_data |= (gsa_size_num_bytes_transfer[2] << 16) ;
   ul_data |= (sa_size[2] << 16) ;
   WriteCoreReg(ZEP_PRAM_ZT_R4_LP1_ADDR, ul_data);


   //Reset the WRPTR to the beginning of the Write Pointer Table
   ul_data = US_RETX_WR_POINTERS_LW_BASE_ADDR;
   WriteCoreReg(ZEP_PRAM_ZT_ILVB_WRPTR_LP1_ADDR, ul_data);
   //XDSLRTFW-1830 (START)
   //Mask FP3 Internal counter <31:24> & update other bits <23:0>
   ul_data = ((guc_StPartialDtuTc << 16)|( guc_num_Dtu_EndBoundary << 8)| guc_StNewDtuTc);
   WriteCoreReg(ZEP_PRAM_ZT_R12_LP1_ADDR, ul_data);

   //Mask FP4 Internal counter <31:24>
   ResetCoreReg(ZEP_PRAM_ZT_FRAMING_LP1_ADDR, 0xFF000000);
   //XDSLRTFW-1830 (END)

   for (i=0; i < 3; i++)
   {
      //Write ILVB addresses in the write pointer table.
      //below code is to make sure that dummy is addes is not inlcued in WRPTR table
      pl_DtuAddr[i] = la_addr[i];
#ifdef ENABLE_RETX_US_DEBUG
      //Debug can be renoved
      gpla_UsReTxBufWrAddrDebug[i] = la_addr[i];
      gsa_UsReTxBufWrSize[i] = sa_size[i];
#endif
   }

}

/*
*-------------------------------------------------------------------------------
*
* CheckForRetransmission(void)
*   This routine Indicates new DTU to be transmitted or old DTU to be transmitted
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void CheckForRetransmission(void)
{
   int16 s_TT_index;
   int32 l_age;
   int16 s_DTUTableSize, s_TxAbsoluteDTUCount;
#ifdef DEBUG_TRACES
   uint16 *pus_dtu_base;
#endif


   // FIFO length = DTU size = Q * N  bytes
   //  s_FifoLength = gs_DTU_size;
   s_DTUTableSize = gt_ReTXParams.us_OPMS_UsQtx;
   s_TT_index = gs_ReTxTable_wr_pointer;

   s_TT_index++;

   if(s_TT_index ==  s_DTUTableSize)
   {
      s_TT_index = 0;
   }

   // XDSLRTFW-1264_DTU_Stoppage_Framer_Handling (START)
   if (gft_StopNewDtu)
   {
      gft_RetransmitReq = TRUE;
   }
   else
      // XDSLRTFW-1264_DTU_Stoppage_Framer_Handling (END)
   {
      gft_RetransmitReq = FALSE;
   }
   //XDSLRTFW-1406 Start
   if ((gft_UsReTxSraStopRrcEval == TRUE) && (gl_TxAbsoluteDTUCount >= (gt_ReTXParams.us_OPMS_UsLookBackValue - 1) ) )
   {

      if(gft_UsReTxSraTRansDetect == FALSE)
      {
         gl_RrcValid = -1;
         gs_RRCOffset = 0;
         guc_PrevAbsoluteDtuCountLsbs = 31;
         gul_retransmitted_delta=0;
         gs_num_RndTrip_Errors = 0;
         gs_num_discarded_DTUs=0;
         s_TxAbsoluteDTUCount = gl_TxAbsoluteDTUCount;
         gl_RrcValid <<= s_TxAbsoluteDTUCount;
         gs_Delta_DTU_TX = s_TxAbsoluteDTUCount;
      }
      gft_UsReTxSraTRansDetect = FALSE;

      guc_FirstQtxSymCnt = 0;  // XDSLRTFW-1344
      gft_UsReTxSraStopRrcEval = FALSE;
   }
   //XDSLRTFW-1406 End
   // Compute the address for the next DTU location
   //   l_DILV_Ptr = gul_ILVFifoBaseAddr + (uint32)(s_TT_index * s_FifoLength);
   //   gula_DTU_ILV_Base_ptr[guc_DTU_bounadry_idx] = l_DILV_Ptr;
   // check whether the oldest element guca_ReTxTable has been acknowledged
   //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start_end)
   if (((gl_RrcValid & ((long long int) 0x1 << (s_DTUTableSize - 1) )) == 0) && (gft_UsReTxSraStopRrcEval == FALSE))
   {
      // The way Timestamp evaluation is dealt with here, during the very first runs after
      // showtime entry, we wont run in the retransmission condition, since the
      // first DTUs are assumed to have been recieved correctly (see standard)
      l_age = (int32)(guc_TS_byte_Retx - gusa_ReTxTable[s_TT_index]);

      if (l_age < 0)
      {
         l_age += 255;
      }

      ///////////////////////////////////////////////////////////////
      // Check if DTU expired and not eligible for retransmission
      ///////////////////////////////////////////////////////////////
      if (l_age <= (int32)guc_TS_Discard_Th)
      {
         // no update required if we are only retransmitting the oldest DTU
         // timestamp and pointer to the buffer remain the same.
         gft_RetransmitReq = TRUE;

      }
      else
      {
         gs_num_discarded_DTUs++ ;
      }

   } // if ((gl_RrcValid[guc_ch_id]
   //XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (Start)
   //XDSLRTFW-4018 Link drop is solved with the f/w where DTUs from the
   //retransmission buffer are transferred to the retransmission multiplexer. "
   // When the DTU framer is stopped ( during the TDTU-_stoppage ).
   if ((gft_DsUsReTxDiagEnter == TRUE)
        &&(gft_StopNewDtu == FALSE) // XDSLRTFW-4018
       )
   {
      gft_RetransmitReq = FALSE;
   }
   //XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (End)


   if(!gft_RetransmitReq)
   {
      // Update entry in the guca_ReTxTable for every new DTU being transmitted
      gusa_ReTxTable[s_TT_index] = guc_TS_byte_Retx;
   }
   else
   {
      // Keep a count of the number of DTUs being retransmistted
      gt_g997_ReTx_FE_MgmtCnt.l_USRetransmittedDtuCnt++;

      gul_retransmitted_delta++; //Debug can be removed
      //XDSLRTFW-1392(START)
#ifdef DEBUG_TRACES

      if(((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData & US_RETX_ONLY_CAPTURE_DISABLE_MASK) == 0)&& !gft_StopNewDtu)
      {
         pus_dtu_base = (uint16*)(gt_ReTXParams.ul_US_ReTXQueue_BaseAddress+(s_TT_index*gs_DTU_size)+ZEP_RAM_IIBRAM_ADDR);

         gt_DebugShowTimeBuffUsReTxOnly.l_symbolCountBuff=gl_TxSymbolCount;
         gt_DebugShowTimeBuffUsReTxOnly.uc_DTU_Qtx_index=s_TT_index;
         gt_DebugShowTimeBuffUsReTxOnly.us_SID_Timestamp_requsted=(*pus_dtu_base);

         //stop logging retx data if  bytes reserved for Showtime in SDRAM are completely filled(No wrap around of data allowed)
         if(gt_DebugBufferStatus.s_debugBuffer_Showtime_length==(SDRAM_RAW_DUMP_SHOWTIME_SIZE_BYTES>>1))
         {
            gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData |= US_RETX_ONLY_CAPTURE_DISABLE_MASK;
         }

         LogShowtimeData((uint8 *)(void *)&gt_DebugShowTimeBuffUsReTxOnly,sizeof(gt_DebugShowTimeBuffUsReTxOnly));
      }
#endif
      //XDSLRTFW-1392(END)
   }


   // insert a zero , indicating that the current DTU has not been
   // acknowledged yet
   gl_RrcValid <<= 1;

   // Update the write pointer
   gs_ReTxTable_wr_pointer = s_TT_index;

   // Count the number of DTUs transmitted till the RRC processed
   gs_Delta_DTU_TX++;
   if(gs_Delta_DTU_TX == 32)
   {
      gs_Delta_DTU_TX = 0;
   }

   gl_TxAbsoluteDTUCount++;

}

/*
*-------------------------------------------------------------------------------
*
* UsReTx_WrFromTCtoILV(int16 s_TransferSize_Lp1)
*   This routine provides  inputs (Address and correponding buffer Sizes of part/full DTU/s in symbol) for Micro code Engine
*     to transfer data from ILV ReTx buffer to DTB  in every DMT symbol
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void UsReTx_RdFromILVtoDTB(int16 s_PMS_SizeLp1)
{
   int32 pl_ReTxRdPtrTable[2];
   int16 s_EndAdrMinusCurrAdr;
   int32 l_ReTXQueue_BaseAddress, l_curr_rd_address, l_ReTXQueue_EndAddress, l_curr_rd_pmscheck;
   int32 ul_data;
   uint16 us_temp[3]= {0,0,0};
   uint8 i=0,k=0;
   int32 *pl_DtuAddr;

   // init pointers
   pl_DtuAddr = (int32*) (ZEP_RAM_IIBRAM_ADDR + US_RETX_RD_POINTERS_BASE_ADDR);

   ReadCoreReg(ZEP_PRAM_ZT_ILVB_RDAD_LP1_ADDR, &l_curr_rd_address);

   l_ReTXQueue_BaseAddress = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;  //ReTx Queue start address
   //gl_UsReTxBufEndAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress + (gs_DTU_size * gt_ReTXParams.us_OPMS_UsQtx)-1;
   l_ReTXQueue_EndAddress = gl_UsReTxBufEndAddr;

   gusa_RdDataSize[0] = s_PMS_SizeLp1 ; //store the size
   gusa_RdDataSize[1] = 0 ; //store the size
   l_curr_rd_pmscheck = l_curr_rd_address + s_PMS_SizeLp1-1;

   if (l_curr_rd_pmscheck > l_ReTXQueue_EndAddress)
   {

      s_EndAdrMinusCurrAdr = (int16) (l_ReTXQueue_EndAddress - l_curr_rd_address+1);

      if (s_EndAdrMinusCurrAdr == 0)
      {
         //Wrap around occured,
         pl_ReTxRdPtrTable[0] = l_ReTXQueue_BaseAddress;//store the Addressl_curr_rd_address =
         //gusa_RdDataSize[1] = 0 ; //store the size
      }
      else
      {
         //Wrap around occured,
         pl_ReTxRdPtrTable[0] = l_curr_rd_address;//store the Address
         gusa_RdDataSize[0] = s_EndAdrMinusCurrAdr ; //store the size

         pl_ReTxRdPtrTable[1] = l_ReTXQueue_BaseAddress;//store the Address
         gusa_RdDataSize[1] = s_PMS_SizeLp1 - s_EndAdrMinusCurrAdr; //store the size
      }
   }
   else
   {
      //Wrap around occured,
      pl_ReTxRdPtrTable[0] = l_curr_rd_address;//store the Addressl_curr_rd_address =
   }

   if (gusa_RdDataSize[1] == 0)
   {
      //Wrap around occured,
      l_curr_rd_address = pl_ReTxRdPtrTable[0];
      pl_ReTxRdPtrTable[0] = l_curr_rd_address;//store the Addressl_curr_rd_address =
      pl_ReTxRdPtrTable[1] = l_curr_rd_address + (s_PMS_SizeLp1 >> 1);//store the Address
      gusa_RdDataSize[0] = (s_PMS_SizeLp1 >> 1); //Read half the size of PMS
      gusa_RdDataSize[1] = s_PMS_SizeLp1 - (s_PMS_SizeLp1 >> 1); //Read the remaining
   }

   pl_DtuAddr[0] = pl_ReTxRdPtrTable[0];
   pl_DtuAddr[1] = pl_ReTxRdPtrTable[1];

   //Size in bytes
   ul_data =(uint32)  ((gusa_RdDataSize[1]<<16) | gusa_RdDataSize[0]);
   WriteCoreReg(ZEP_PRAM_ZT_CRC1_LP1_ADDR, ul_data);

   //Reset the RDPTR to the beginning of the Read Pointer Table
   ul_data = US_RETX_RD_POINTERS_LW_BASE_ADDR;
   WriteCoreReg(ZEP_PRAM_ZT_ILVB_RDPTR_LP1_ADDR, ul_data);

#ifdef ENABLE_RETX_US_DEBUG
   if (gs_UsretxDebug1 !=0)
   {
      if (gs_UsretxDebug1 == (int16) gl_TxAbsoluteDTUCount)
      {
         Pause(0xD432);
      }

   }
#endif

}
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (End)



