/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: UsRTX_io.c
*
*   This file contains retransmission HW interface functions.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// UsRTX_io.c
//
// History
// 02/12/2013 Varun : Added code changes to record max and min delay in dtus for US retx ack
//                   Grep for XDSLRTFW-1422
//
// 16/07/2013 Palaksha: Changes related to RRC Golay code word extration,Golay Decoding, RRC Evaluation
//            Grep for: XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC
//
//06/09/2013 Palaksha/Kannan: To accomodate US RETX feature PM/DM changes
//   - Increased LOCAL_LD_ST_RAM from 8K - SIZEOF(STACK_RAM) to 2*8K - SIZEOF(STACK_RAM)
//   - Increased TX_UCODE_BUFFER to (500+256) from 500
//   - reduced ONE_PORT_TRAIN_IRAM  to 5K-2K from 5K and Increased ONE_PORT_SHOW_IRAM  to 5K+2K from 5K
//   - Moved function LogMessages from DebugBuffer.c to UsRTX_io.c
//   - allocated all US RETX showtime/Pre showtime code to ONE_PORT_SHOW_IRAM section
//Grep for XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx
//
// 21/11/2013 Palaksha: Fix for "XDSLRTFW-1380 US ReTx + US SRA: UnCorrected DTUs observed during US SRA(DownShift and UpShift)
//               with REIN noise and SHINE"
//               It is observed that on some SRA transitions few uncorrected DTUs are observed with REIN and SHINE noise.
//            Root cause for the problem is
//                   (1) Starting of RRC evaluation after every SRA was not always right (ii) In DTU stoppage time calculation
//                    old new framing params used instead of Old ones.
//            Solution includes: (i) New implementaion done for RRC evaluation after every SRA
//                  (ii) In DTU stoppage time calculation use Old framing params
//            grep for XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine
//
// 21/11/2013 Palaksha: XDSLRTFW-1406 Link drop observed with NVLT-G VR9 - 5.7.1.6.1.7 while doing DS ReTx + SRA with US ReTx + SRA
//              After introducing fix for "XDSLRTFW-1380", which was causing some link drops. This because Tx  retransmission
//              was blocked for as the RRC evaluation in Rx was not setting the flag.The solution includes more robust old DTU to
//              new DTU transition detection and flag control was moved from Rx to tx.
//    grep for XDSLRTFW-1406
//
// 15/12/2014 Prashant: Following things are implemented wrt RetxDegug feature
//            1. Transmitter should offer an RRC codeword capture feature for up to 256 RRC CWs and capturing is started with the
//               first RRC CW where Nack[1:0] is unequal 0b00. (256 * 24bits to be stored).
//               Capture can be enabled by setting gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0. Once set to zero,
//               capture will start from first bad dtu and gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt will be incremented upto 255.
//               To re-capture again set gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0.
//            2. Transmitter should offer the possibility to measure the actual roundtrip in number of DTUs per DTU from DTU TX insertion
//               until getting the first ACK info and should report the max./min. value captured during operation. (This already exist)
//               Reseting the measurement during operation is suppoterd now.
//            3. The structure RtxDbgCapture_t has been mapped to a new CMV INFO 241.
//    Grep for XDSLRTFW-1622
//
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"
#include "show_iof.h"
#include "show_lpbk_iof.h"
#include "profile.h"
#include "OvhdMsg_IOf.h"
#include "V_STR_IOf.h"
#include "IRI_Iof.h"
#include "cri_iof.h"
#include "mtkernel.h"
#include "cri_memmap.h"
#include "LL_IOf.h"
#include "DDSnrFdqHandler.h"
#include "dsp_op.h"
#include "string.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif //PPE_ENGINE

#ifdef DISTRIBUTE_TX_RX_PROCESS
#include "cri_iof.h"
#endif // DISTRIBUTE_TX_RX_PROCESS

//#ifdef MTK_VECTORING_SUPPORT
#include "FormRErrorFeedbackMsg_VDSL2.h"
#include "eoc.h"
#include "ShowtimeERBHandler.h"

#include "Us_Rtx.h"

#include <stdarg.h>
#include "stdio.h"
#include "states.h"
#ifdef DEBUG_TRACES
#include "DebugBuffer.h"
#endif

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ReadRRCFifo(void)
*
*   This function reads 3 RRC bytes from HW FIFO #1 and stores them into
*   gul_RRC_data
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*
*
*-------------------------------------------------------------------------------
*/


#ifdef DEBUG_RRC2
extern int16 gs_debugRRC;
extern int16 gs_debug_FIFO1_bytes;
extern int32 gl_debug_RXSymbolCount;
extern uint32 gul_debug_FIFO1_cntl;
#endif

#ifdef DEBUG_RRC
extern uint32 gul_RRC_buff[10];
extern uint16 gs_indexj;
#endif
extern uint8 guc_MaxDtuPerSymb;
extern uint32 gul_ReadRRC_TxPMS_Conflict_Cnt;


//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (Start)

void ReadRRCFifo(void)
{
   int32 l_data;

#ifdef DEBUG_RRC2
   {
      int16 s_byte_in_fifo;         // number of valid bytes in FIFO0
      uint32 ul_data;

      // read HW FIFO counter
      ReadCoreReg(ZEP_REG_ZR_FIFO1_BYTE_ADDR, &ul_data);      // Get number of valid bytes
      s_byte_in_fifo = (int16)((ul_data >> 8) & RX_FIFO1_CNTR_MASK);

      if(s_byte_in_fifo != NUM_RRC_BYTES)
      {
         gs_debugRRC++; //something is wrong.
         gs_debug_FIFO1_bytes = s_byte_in_fifo;
         gl_debug_RXSymbolCount = gl_RxSymbolCount;
         ReadCoreReg(ZEP_REG_ZR_FIFO1_CTRL_ADDR, &ul_data);      // Get number of valid bytes
         gul_debug_FIFO1_cntl = ul_data;
      }
   }
#endif


   if(guc_CasMode_enable)
   {
      ReadTxTimer((uint32 *)(void *)&l_data);
      if ((l_data > 71800) && (l_data < 8000))
      {
      //Debug counter to know whether ARC is accessing DTB when Tx PMS is running or not.
      //if (gul_ReadRRC_TxPMS_Conflict_Cnt > 0), then ARC is accessing DTB when Tx PMS is running
         gul_ReadRRC_TxPMS_Conflict_Cnt++;
      }
   }

   //XDSLRTFW-1881(START)
   if((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) && (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
   {
      // Read RRC code word of 24 bits
      ReadCoreReg((uint32)(ZEP_ILV_RAM_DTB_ADDR + ((US_DS_RETX_ZEP_ILV_RAM_RXDTB_OFFSET + ZEP_ILV_RAM_RXDTB_LP2_BASE) << 2)), &gul_RRC_data);
   }
   else
   {
      // Read RRC code word of 24 bits
      ReadCoreReg((uint32)(ZEP_ILV_RAM_DTB_ADDR + ((US_RETX_ZEP_ILV_RAM_RXDTB_OFFSET + ZEP_ILV_RAM_RXDTB_LP2_BASE) << 2)), &gul_RRC_data);
   }
   //XDSLRTFW-1881(END)

#ifdef DEBUG_RRC
   if(gs_indexj<10)
   {
      gul_RRC_buff[gs_indexj] = gul_RRC_data;
      gs_indexj = (gs_indexj + 1)%10;
   }
#endif

}


//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (Start)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RRCGolayDecode(void)
*
*   This function decodes the RRC Golay CW. A [24,12] Golay code is capable of
*   detecting any 4 bit errors and correcting any 3 bit errors. Currently,
*   only error detection is implemented. An error is detected when the remainder
*   of the polynomial division between the received 24bit CW and the generator
*   of polynomial is non-zero.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*
*-------------------------------------------------------------------------------
*/
#define BIT11 0x000800
#define BIT12 0x001000
#define BIT13 0x002000
#define BIT14 0x004000
#define BIT15 0x008000
#define BIT16 0x010000
#define BIT17 0x020000
#define BIT18 0x040000
#define BIT19 0x080000
#define BIT20 0x100000
#define BIT21 0x200000
#define BIT22 0x400000
#define BIT23 0x800000

#define BITS_13_15_16 0x01A000
#define BITS_17_18_23 0x860000

#ifdef DEBUG_GOLAY
uint32 gul_BadCW;
#endif

extern int32 gl_dbg1;
extern int32 gl_dbg2;
extern int16 gs_mips_usage;

FlagT RRCGolayDecode(void)
{
   uint32 ul_X=0;
   uint32 ul_GR=0x18EA00; //The Generator Polynomial 0xAE3 in reverse
   uint32 ul_C; // Divisor on the Polynomial division.
   int32 i;

#ifdef DEBUG_RETX_LOG

   if (gft_REIN_NoiseUS)
   {

      if ((gl_RxSymbolCount % gs_US_InterArrivalTime) == 0)
      {
         gft_corruptRRC = 1;
         gs_num_US_REIN_impulses++;
      }

      if (gs_num_US_REIN_impulses == gs_max_num_US_REIN_impulses)
      {
         gft_REIN_NoiseUS = 0;
      }
   }

   if(gft_corruptRRC)
   {
      gs_corrupted_RRC_cnt++;

      if(gs_corrupted_RRC_cnt == gs_num_corrupted_RRCs)
      {
         gft_corruptRRC = FALSE;
         gs_corrupted_RRC_cnt = 0;
      }

      return(FALSE);
   }

#endif // DEBUG_RETX_LOG


   if(gul_RRC_data &0xFFFFFF == 0)
   {
#ifdef DEBUG_GOLAY
      gul_GolayBad++;
      gul_BadCW = gul_RRC_data;
#endif
      return(FALSE); // There is an error. The number of ones should be even.

   }


   ul_X = gul_RRC_data;

   // Do a parity check

   ul_C = ul_X;
   ul_C ^= (ul_C >> 1);
   ul_C ^= (ul_C >> 2);
   ul_C ^= (ul_C >> 4);
   ul_C ^= (ul_C >> 8);
   ul_C ^= (ul_C >> 16);

   if((ul_C & 0x1) == 1)
   {

#ifdef DEBUG_GOLAY
      gul_GolayBad++;
      gul_BadCW = gul_RRC_data;
#endif

#ifdef DEBUG_RETX_LOG
      if(gus_retx_log_type & EVENT_SID_BAD_RRC)
      {
         LogReTxTrail((SID_BAD_RRC<<28)|((gul_RRC_data & 0xFFF) <<12)|(gl_TxAbsoluteDTUCount & 0xFFF));
         LogReTxTrail(gl_RrcValid);
      }
#endif
      return(FALSE); // There is an error. The number of ones should be even.
   }


   //Reorder the bits; based on 09XC-085_extGolay_CNXT.doc . G.INP v1.2 has a bug. see b23 in both C(D) and parity check
   // The bits in ul_X are reordered to create the CW. The CW bits are as follows

   // CW = [R31,R30,R29,R28,R27,R26,R25,R24,R23,R22,R21,R20,R19,R18,R17,R16,R15,R14,R13,R12,R11,R10,R9 ,R8,R7,R6,R5,R4,R3,R2,R1,R0]
   // CW = [C0 ,C1 ,C2 ,C3 ,C4 ,C5 ,C6 ,C7 ,C8 ,C9 ,C10,C11,C12,C13,C14,C15,C16,C17,C18,C19,C20,C21,C22]
   // CW = [X0 ,X1 ,X2 ,X3 ,X4 ,X5 ,X6 ,X7 ,X8 ,X9 ,X10,X11,X16,X15,X20,X13,X23,X19,X14,X21,X22,X18,X17]


   ul_C = (ul_X<<20);
   ul_C |= ((ul_X & BIT20) >> 3); //17
   ul_C |= ((ul_X & BIT14) >> 1); //13
   ul_C |= ((ul_X & BIT19) >> 5); //14
   ul_C |= ((ul_X & BIT21) >> 9); //12
   ul_C |= ((ul_X & BIT22) >> 11); //11
   ul_C |= ((ul_X & BITS_13_15_16) << 3);
   ul_C |= ((ul_X & BITS_17_18_23) >> 8);

   for(i=11; i>=0; i--)
   {
      if( ul_C & (0x200) )
      {
         ul_C ^= ul_GR;
      }
      ul_C >>= 1;
   }

   if(ul_C == 0x0)
   {
#ifdef DEBUG_GOLAY
      gul_GolayGood++;
#endif

      return(TRUE);
   }
   else
   {
#ifdef DEBUG_GOLAY
      gul_GolayBad++;
      gul_BadCW = gul_RRC_data;
#endif

#ifdef DEBUG_RETX_LOG
      if(gus_retx_log_type & EVENT_SID_BAD_RRC)
      {
         LogReTxTrail((SID_BAD_RRC<<28)|((gul_RRC_data & 0xFFF) <<12)|(gl_TxAbsoluteDTUCount & 0xFFF));
         LogReTxTrail(gl_RrcValid);
      }
#endif
      return(FALSE); // There is an error. The number of ones should be even.

   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RRC_Evaluation(void)
*
*   The function extracts the RRC fields from the RRC Golay CW and updates the
*   gl_RrcValid DTU acknowledgement bitfields corresponding to guca_ReTxTable.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gul_RRC_data; // RRC Codeword
*      guca_ReTxTable[]; // Translation Table
*      guc_lb; // Look Back value
*
*-------------------------------------------------------------------------------
*/

void RRC_Evaluation(void)
{
   uint8 uc_AbsoluteDtuCountLsbs, uc_ConsecutiveGoodDtus;
   uint8 uc_Nack;
   int16 s_Delta_DTU_RX;
   int16 s_LeftLimit, s_RightLimit;
   int16 s_RRCOffset;

#ifdef DEBUG_RETX_LOG
   int16 s_DILV_Ptr, s_FifoLength;
#endif

   unsigned long long int ul_RrcMask; // 64 bit variable

   long long int l_RRCMask = -1;

   uint8 uc_DTUTableSize = gt_ReTXParams.us_OPMS_UsQtx;
   int16 s_TxAbsoluteDTUCount;

   uc_AbsoluteDtuCountLsbs =  gul_RRC_data & 0x1f;
   uc_Nack               = (gul_RRC_data>>5) ;
   uc_Nack               = (~uc_Nack)& 0x3;
   uc_ConsecutiveGoodDtus =(gul_RRC_data>>7) & 0x1f;

   // XDSLRTFW-1622 (Start) // Capture RRC codewords
   if (( uc_Nack != 0x3) && (gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt <= 255))
   {
      gula_RrcCaptureBuffer[gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt++]= gul_RRC_data & 0xffffff;
   }
   // XDSLRTFW-1622 (End)

#ifdef ENABLE_RETX_US_DEBUG
   if (gs_Usretx_d2 < gs_Usretx_d3)
   {
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gsa_IndirectStat0[0];
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = (gl_TxAbsoluteDTUCount & 0xFFFF);
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = uc_AbsoluteDtuCountLsbs;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = uc_ConsecutiveGoodDtus;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = guc_PrevAbsoluteDtuCountLsbs;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gs_Delta_DTU_TX;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gs_RRCOffset;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gs_ReTxTable_wr_pointer;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = (gl_RrcValid & 0xFFFF);
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = (uc_AbsoluteDtuCountLsbs - guc_PrevAbsoluteDtuCountLsbs);
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gs_RRCOffset + gs_Delta_DTU_TX - s_Delta_DTU_RX;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gft_InitialRRC;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = uc_DTUTableSize;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = gs_num_RndTrip_Errors;
      gusa_ReTxDebugBuf[gs_Usretx_d2++] = 0x1234;
   }
#endif //ENABLE_RETX_US_DEBUG
   // Ignore the first few entries of RRC till the uc_AbsoluteDtuCountLsbs  count is  31
   // due to the roundtrip delay

   if ((gft_InitialRRC) && (uc_AbsoluteDtuCountLsbs  != 31))
   {
      return;
   }
   else
   {
      gft_InitialRRC = 0;
   }

   if (gft_InitialRRC == 0)
   {

      //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start)
      if(gft_UsReTxSraStopRrcEval == TRUE) //XDSLRTFW-1406 Start
      {
         s_Delta_DTU_RX = uc_AbsoluteDtuCountLsbs - guc_PrevAbsoluteDtuCountLsbs;
         // XDSLRTFW-1344 (START)
         // Qtx1 = (1ms/Tdmt) that is ==>> (1ms / 0.25ms)= 4 (in symbols)
         uint8 uc_Qtx1 = (uint8) (4);

         int8 Temp = (int8)guc_MaxDtuPerSymb;
         Temp--;
         if (Temp < 0)
         {
            Temp = 0;
         }
         //if ( (guc_FirstQtxSymCnt >= uc_Qtx1) && (s_Delta_DTU_RX < 0) || (uc_AbsoluteDtuCountLsbs <3) || (uc_AbsoluteDtuCountLsbs == 31) )
         if ( (guc_FirstQtxSymCnt >= uc_Qtx1) && (uc_AbsoluteDtuCountLsbs <= Temp) )   // XDSLRTFW-1344 (END)
         {
            gl_RrcValid = -1;
            gs_RRCOffset = 0;
            guc_PrevAbsoluteDtuCountLsbs = 31;
            gul_retransmitted_delta=0;
            gs_num_RndTrip_Errors = 0;
            gs_num_discarded_DTUs=0;
            s_TxAbsoluteDTUCount = gl_TxAbsoluteDTUCount;
            gl_RrcValid <<= s_TxAbsoluteDTUCount;

            gs_Delta_DTU_TX = s_TxAbsoluteDTUCount;
            gft_UsReTxSraTRansDetect = TRUE;
         }

      }//XDSLRTFW-1406 End
      // Count by how many DTUs the RRC absolute DTU count has increased since last time
      s_Delta_DTU_RX = uc_AbsoluteDtuCountLsbs - guc_PrevAbsoluteDtuCountLsbs;

      //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (end)
      if(s_Delta_DTU_RX < 0)
      {
         s_Delta_DTU_RX += 32;
      }

      ///////////////////////////////
      // Handling of lost RRCs
      ///////////////////////////////

      // Count the number of DTUs transmitted since valid RRC processed. This accounts for the left shifts added for every new DTU
      // transmitted
      s_RRCOffset = gs_RRCOffset + gs_Delta_DTU_TX - s_Delta_DTU_RX;

      // Return if "Out of range"
      if ((s_RRCOffset > (uc_DTUTableSize -1)) || (s_RRCOffset < 0))
      {
         // Ideally we should never come here
         gs_num_RndTrip_Errors++;
         return;
      }

      //////////////////////////////////////////////////
      // Return in case of redundant RRC information
      /////////////////////////////////////////////////
      if (s_Delta_DTU_RX == 0)
      {
         return;
      }

      //////////////////////////////////////////////////////
      // Book keeping in case of a valid, new RRC received
      //////////////////////////////////////////////////////

      gs_Delta_DTU_TX = 0;
      gs_RRCOffset = s_RRCOffset;

      //XDSLRTFW-1422(START)
      // Keep an estimate of maximum roundtrip delay measured in DTUs
      if(gs_RRCOffset > gt_UsReTx_DelayDTUs.us_MaxRoundTripDelay_DTUS)
      {
         gt_UsReTx_DelayDTUs.us_MaxRoundTripDelay_DTUS=gs_RRCOffset;
      }

      // XDSLRTFW-1622 (Start)
      if (gt_RtxDbgCapture.us_ResetRoundTripDelay == 1)
      {
         gt_UsReTx_DelayDTUs.us_MaxRoundTripDelay_DTUS = 0;
         gt_RtxDbgCapture.us_ResetRoundTripDelay = 0;
      }
      // XDSLRTFW-1622 (End)

      // Keep an estimate of minimum roundtrip delay measured in DTUs
      if(gs_RRCOffset < gt_UsReTx_DelayDTUs.us_MinRoundTripDelay_DTUS)
      {
         gt_UsReTx_DelayDTUs.us_MinRoundTripDelay_DTUS=gs_RRCOffset;
      }
      //XDSLRTFW-1422(END)

      guc_PrevAbsoluteDtuCountLsbs = uc_AbsoluteDtuCountLsbs;


      // generate a bit mask where a "1" corresponds to a correctly received DTU
      ul_RrcMask = (unsigned long long int)l_RRCMask;

      // find the left and right limits of the block: ul_ConsecutiveGoodDtus
      if ((uc_Nack & 0x2) == 0)
      {
         //s_LeftLimit  = gs_RRCOffset + gt_RTX_DSFrameInfo.us_lb + 2;
         s_LeftLimit  = gs_RRCOffset + gt_ReTXParams.us_OPMS_UsLookBackValue + 2;
         s_RightLimit = s_LeftLimit - uc_ConsecutiveGoodDtus - 1;

      }
      else
      {
         s_RightLimit = gs_RRCOffset + 1;
         s_LeftLimit  = s_RightLimit + uc_ConsecutiveGoodDtus + 1 ;
      }

      // Safety checks
      if (s_LeftLimit > uc_DTUTableSize)
      {
         s_LeftLimit = uc_DTUTableSize;
      }

      if (s_LeftLimit < (gs_RRCOffset + 2))
      {
         s_LeftLimit = gs_RRCOffset + 2;
      }

      if (s_RightLimit > (uc_DTUTableSize -1))
      {
         s_RightLimit = (uc_DTUTableSize - 1);
      }

      if (s_RightLimit < (gs_RRCOffset + 1))
      {
         s_RightLimit = gs_RRCOffset + 1;
      }

      // Look for the lb window in case of missing RRCs
      ul_RrcMask = ul_RrcMask >> (s_RightLimit + 1); //*******Redundant and can be removed *//
      ul_RrcMask = ul_RrcMask << (s_RightLimit + 1) ;
      ul_RrcMask = ul_RrcMask << ( 64 - s_LeftLimit );
      ul_RrcMask = ul_RrcMask >> ( 64 - s_LeftLimit ) ;

      ul_RrcMask |=  ((unsigned long long int)(uc_Nack) << gs_RRCOffset);

#ifdef ENABLE_RETX_US_DEBUG
      if(gft_RRCworkaround)
      {
         unsigned long long int ul_Nack_current;

         ul_Nack_current = 0;

         // Retain the previous RRC valid field
         ul_Nack_current = ~ul_Nack_current; // get the 1's mask only for the newly acknowledged s_Delta_DTU_RX DTUs

         ul_Nack_current >>= gs_RRCOffset;
         ul_Nack_current <<= gs_RRCOffset;

         ul_Nack_current <<= (64 - s_Delta_DTU_RX - gs_RRCOffset);
         ul_Nack_current >>= (64 - s_Delta_DTU_RX - gs_RRCOffset);

         // Retain the old zeros
         ul_RrcMask &= ul_Nack_current;

      }
#endif

      gl_RrcValid |= ul_RrcMask;

#ifdef DEBUG_RETX_LOG
      {
         uint16 us_temp;
         int16 s_TT_rd_pointer;

         s_FifoLength = gsa_DTU_size[guc_ch_id];

         // Log the RRC request for retransmission
         if(gus_retx_log_type & EVENT_SID_REQUESTED)
         {
            // NACK 1
            if (((gl_RrcValid >> (gs_RRCOffset + 1)) & 0x1) == 0)
            {
               // SID & TimeStamp
               s_TT_rd_pointer =  gs_ReTxTable_wr_pointer - gs_RRCOffset - 1;
               if (s_TT_rd_pointer < 0)
               {
                  s_TT_rd_pointer += uc_DTUTableSize;
               }

               s_DILV_Ptr = gus_ILVFifoBaseAddr + (uint32)(s_TT_rd_pointer * s_FifoLength);

               us_temp =  gusa_ReTxTable[s_TT_rd_pointer];

               LogReTxTrail((SID_REQUESTED<<28)|(us_temp<<12)|(gl_TxAbsoluteDTUCount & 0xFFF));
               //LogReTxTrail((int32)s_DILV_Ptr); // Log the ILV pointer address
               LogReTxTrail(gl_RrcValid); // Log the ILV pointer address
               //LogReTxTrail((gs_TxPMDFrameCount << 16) | ( gs_RxPMDFrameCount)); // Log the ILV pointer address
            }

            // NACK 0
            if (((gl_RrcValid >>gs_RRCOffset)  & 0x1) == 0)
            {
               // SID & TimeStamp
               s_TT_rd_pointer =  gs_ReTxTable_wr_pointer - gs_RRCOffset;
               if (s_TT_rd_pointer < 0)
               {
                  s_TT_rd_pointer += uc_DTUTableSize;
               }

               s_DILV_Ptr = gus_ILVFifoBaseAddr + (uint32)(s_TT_rd_pointer * s_FifoLength);

               us_temp =  gusa_ReTxTable[s_TT_rd_pointer];


               LogReTxTrail((SID_REQUESTED<<28)|(us_temp<<12)| (gl_TxAbsoluteDTUCount & 0xFFF));
               //LogReTxTrail((int32)(s_DILV_Ptr)); // Log the ILV pointer address
               LogReTxTrail(gl_RrcValid); // Log the ILV pointer address
               //LogReTxTrail((gs_TxPMDFrameCount << 16) | ( gs_RxPMDFrameCount)); // Log the ILV pointer address
            }

            // ACK 0+1: log ACKs only every 16 DTUs.
            if ((((gul_RRC_data>>5) & 0x3) == 0x0) && ((gl_TxAbsoluteDTUCount & 0xF) == 0x0))
            {
               // SID & TimeStamp
               s_TT_rd_pointer =  gs_ReTxTable_wr_pointer - gs_RRCOffset;
               if (s_TT_rd_pointer < 0)
               {
                  s_TT_rd_pointer += uc_DTUTableSize;
               }

               s_DILV_Ptr = gus_ILVFifoBaseAddr + (uint32)(s_TT_rd_pointer * s_FifoLength);

               us_temp =  gusa_ReTxTable[s_TT_rd_pointer];

               LogReTxTrail((SID_DTU_ACKS<<28)|(us_temp<<12)| (gl_TxAbsoluteDTUCount & 0xFFF));
               //LogReTxTrail((int32)(s_DILV_Ptr)); // Log the ILV pointer address
               LogReTxTrail(gl_RrcValid); // Log the ILV pointer address
               //LogReTxTrail((gs_TxPMDFrameCount << 16) | ( gs_RxPMDFrameCount)); // Log the ILV pointer address

            }
         }   // if(gus_retx_log_type & EVENT_SID_REQUESTED)
      }
#endif   // DEBUG_RETX_LOG

   } // if (gft_InitialRRC == 0)

}
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (End)

//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (End)


//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx (START)
#ifdef DEBUG_TRACES
#endif
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx (END)
