/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: preshow.c
*
*   This file contains functions for showtime-only tests.
*   None of functions defined here are used in the target build.
*
*-------------------------------------------------------------------------------
*/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"
#include "ToneReorder.h"
#include "preshow.h"
#include "InitShowTimeTx.h"
#include "TxDataPumpSetUp.h"
#include "InitShowTimeRx.h"
#include "RxDataPumpSetUp.h"
#include "DSLEngin.h"
#include "vdsl_xception.h"
#include "cri_iof.h"
#include "IRI_sync.h"
#include "Framing_VDSL2.h"

#include "IRI_Iof.h"

int32 gl_TxCurrentStateLen = -1;
int16 gs_TxFollowingState;
int16 gs_TxPreShowState;
FlagT gft_TxBitloadOK;

int32 gl_RxCurrentStateLen = -1;
int16 gs_RxFollowingState;
int16 gs_RxPreShowState;

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void TxPreShowHandler(void)
*
*   This function initializes TX path for showtime-only tests.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void TxPreShowHandler(void)
{
   switch (gs_TxPreShowState)
   {

   case 0:
      // initialize modem variables for showtime-only test
      // (these variables are usually set during training)
      guc_BgTxShowInitState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeTestTx);
      // insert TX CE
      // use default values for gs_TxCPLength, gs_TxCSLength,
      // gsa_WindowCoeffs, gs_TxBetaLength
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, InsertTxCE);
      gs_TxPreShowState = 1;
      break;

   case 1:
      if (guc_BgTxShowInitState == TRAINING_DONE)
      {
         if (gft_TxBitloadOK == FAIL)
         {
            EnterFailStates(E_CODE_BITLOAD_EXPLICIT_RATE_FAIL);
         }
         gs_TxPreShowState = 2;
      }
      break;

   case 2:
      // wait until background task is done & BgInitShowTimeRx is done
      if (gs_RxPreShowState == RX_SHOW_INIT_DONE)
      {
         // initialize showtime variables and cores
         guc_TxShowInitState = TX_SHOW_INIT_START;
         gs_TxPreShowState = 3;
      }
      break;

   case 3:
      // call TxShowInitHandler() until all showtime initialization tasks are done
      if (guc_TxShowInitState != TX_SHOW_INIT_DONE)
      {
         TxShowInitHandler();
      }
      else
      {
         gs_TxPreShowState = STATE_MACHINE_DONE;
      }
      break;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgInitShowTimeTestTx(void)
*
*   This function initializes TX path variables for showtime-only tests.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void BgInitShowTimeTestTx(void)
{
   int32 l_BitsPerSymbol;
   int16 i, s_bc;
   PT_ArrIdx_te UsedPilot = gt_PilotConfig.te_UsedPTArrayIdx;

   gs_TxMaxConstSize = gt_ModemConfig.s_UsMaxConstSize;

   // disable pilot tone for loopback test
   if (TESTArray[TEST_LoopbackMode] != TEST_LpbkDisabled)
   {
      gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx = 0;
   }
   else
   {
      ///ANDREAO: to be linked to a configuration message
      if(1)
      {
            #define BANDPLAN_OFFSET 0
            //#define BANDPLAN_OFFSET 4096

         gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx = PILOT_TONE + BANDPLAN_OFFSET;
      }
      else
      gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx = PILOT_TONE;
   }

   if (TESTArray[TEST_LoopbackMode] == TEST_LpbkAtDTB)
   {
      gft_dbg_SkipTxSyncFrame = 1;
   }
   else
   {
      gft_dbg_SkipTxSyncFrame = 0;
   }

   //if (gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2)
   //{

   for (i=0; i<MAX_TPS_TC_TYPE_API; i++)
   {
      for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
      {
         if (gta_UsBearerChannel[s_bc].s_Control & gus_TpsTcType[i])
         {
            gta_UsBearerChanAct[s_bc].s_TypeEnabled = gus_TpsTcType[i];
//            memcpy(&gta_UsBearerChanAct[s_bc].ta_TpsTcType, &gta_UsBearerChannel[s_bc].ta_TpsTcType[i], sizeof(TPS_TC_Type_t));
            gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate = (uint16)(gta_UsBearerChannel[s_bc].ta_TpsTcType[i].ul_MinNetDataRate >> 1);
            gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate = (uint16)(gta_UsBearerChannel[s_bc].ta_TpsTcType[i].ul_MaxNetDataRate >> 1);
            gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MinResNetDataRate = (uint16)(gta_UsBearerChannel[s_bc].ta_TpsTcType[i].ul_MinResNetDataRate >> 1);
            gta_UsBearerChanAct[s_bc].ta_TpsTcType.s_MaxLatency = gta_UsBearerChannel[s_bc].ta_TpsTcType[i].s_MaxLatency;
            gta_UsBearerChanAct[s_bc].ta_TpsTcType.uc_IMAxINP = (uint8)(gta_UsBearerChannel[s_bc].ta_TpsTcType[i].s_IMAxINP);
            gta_UsBearerChanAct[s_bc].ta_TpsTcType.uc_TPSTCoptions = gta_UsBearerChannel[s_bc].ta_TpsTcType[i].uc_TPSTCoptions;
         }
      }
   }

   // compute the VDSL2 derived framing parameters
   Compute_VDSL2Framing(&gt_tx_config_v2, &gt_tx_TPS_Map, &gs_PMDFramesPerTxIBStructure);
   l_BitsPerSymbol = (int32)(gt_tx_config_v2.ul_Lp[LP0] + gt_tx_config_v2.ul_Lp[LP1]);
   //}

   // use ADSL like tone-reordering
   gs_TxToneOrderType = NORMAL_TONE_ORDER;
   gs_RxToneOrderType = NORMAL_TONE_ORDER;

   // set up TX ping-pong table - BAT/GST/EGT/TRT
   gft_TxBitloadOK |= PingPongTableSetUp(TX, l_BitsPerSymbol, gs_TxMaxConstSize);

   // Set the frame rate in symbols/second for running Showtime tests on HW
   gs_DataFrameRate = 0x0FA0;

   guc_BgTxShowInitState = TRAINING_DONE;
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RxPreShowHandler(void)
*
*   This function initializes RX path for showtime-only tests.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void RxPreShowHandler(void)
{
   switch (gs_RxPreShowState)
   {

   case 0:
      // initialize modem variables for showtime-only test
      // (these variables are usually set during training)
      guc_BgRxShowInitState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeTestRx);
      // insert RX CE
      // use default values for gs_RxCPLength, gs_RxCSLength,
      // gsa_WindowCoeffs, gs_TxBetaLength, gs_RxWindowLength
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, InsertRxCE);
      gs_RxPreShowState = 1;
      break;

   case 1:
      // wait until background task is done
      if (guc_BgRxShowInitState == TRAINING_DONE)
      {
         if (gft_BitloadOK == FAIL)
         {
            EnterFailStates(E_CODE_BITLOAD_EXPLICIT_RATE_FAIL);
         }
         gs_RxPreShowState = 2;
      }
      break;

   case 2:
      // read TX and RX timer
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, GetTxRxCounters);
      gs_RxPreShowState = 3;
      break;

   case 3:
#ifdef ENABLE_SHOW_LPBK
      if (CNTLArray[CNTL_ModemControl] & CNTL_ModemLoopback)
      {
         // adjust alignment for loopback test
         gs_AlignmentOffset = gs_TxTimerVal - gs_RxTimerVal;
         gs_AlignmentOffset -= gs_LpbkAlignmentOffset;
         gs_AlignmentOffset /= 3;
         // double the alignment offset for 8kHz frame rate to keep
         // the TX and RX alignment the same as in 4kHz frame rate
         if (gs_frame_rate_is_8khz)
         {
            gs_AlignmentOffset <<= 1;
         }
         // if RX interrupt happened first, increase RX preshowtime length
         // by 1 so that TX goes into showtime first
         if (gl_RxTcCount > gl_TxTcCount)
         {
            gl_RxCurrentStateLen++;
         }
      }
      else
#endif //#ifdef ENABLE_SHOW_LPBK
      {
         // frame alignment to compensate inherent DLI delay
         gs_AlignmentOffset = -152;
      }

      if (TESTArray[TEST_LoopbackMode] == 0 )      // not a loopback test
      {
         if((TESTArray[TEST_Mode] & 0x00F0) == ST_TIME_DOMAIN_CONNECT)
         {
            gs_AlignmentOffset = 3337;
         }
      }

      gs_RxFrameAlignRemain = 0;

      AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
      gs_RxPreShowState = 4;
      break;

   case 4:

      //For the 6.2 HW, it is not allowed to make a strymon frame less than FFT size
      //so it may take more than one frame to do frame adjustment if gs_AlignmentOffset is greater than
      //CE Length. Note the variable gs_RxFrameAlignRemain stores the remaining adjustment
      //after each call to AdjustAlignment()
      if(gs_RxFrameAlignRemain != 0)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
         break;
      }

      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetRxAlign);

      // initialize showtime variables and cores
      guc_RxShowInitState = RX_SHOW_INIT_START;
      gs_RxPreShowState = 5;

      break;

   case 5:
      // call RxShowInitHandler() until all showtime initialization tasks are done
      if (guc_RxShowInitState != RX_SHOW_INIT_DONE)
      {
         RxShowInitHandler();
      }
      else
      {
         gs_RxPreShowState = STATE_MACHINE_DONE;
      }
      break;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgInitShowTimeTestRx(void)
*
*   This function initializes RX path variables for showtime-only tests.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void BgInitShowTimeTestRx(void)
{
   int32 l_BitsPerSymbol;
   int16 i, s_bc;
   PT_ArrIdx_te UsedPilot = gt_PilotConfig.te_UsedPTArrayIdx;

   gs_RxMinConstSize = gt_ModemConfig.s_DsMinConstSize;
   gs_RxMaxConstSize = gt_ModemConfig.s_DsMaxConstSize;

   // disable pilot tone for loopback test
   if (TESTArray[TEST_LoopbackMode] != TEST_LpbkDisabled)
   {
      gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx = 0;
   }
   else
   {
        ///ANDREAO: to be linked to a configuration message
        if(1)
        {
            #define BANDPLAN_OFFSET 0
            //#define BANDPLAN_OFFSET 4096

            gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx = PILOT_TONE + BANDPLAN_OFFSET;
        }
        else

   {
      gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx = PILOT_TONE;
   }
 }

   if (TESTArray[TEST_LoopbackMode] == TEST_LpbkAtDTB)
   {
      gft_dbg_SkipRxSyncFrame = 1;
   }
   else
   {
      gft_dbg_SkipRxSyncFrame = 0;
   }

   //if (gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2)
   //{

   for (i=0; i<MAX_TPS_TC_TYPE_API; i++)
   {
      for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
      {
         if (gta_DsBearerChannel[s_bc].s_Control & gus_TpsTcType[i])
         {
            gta_DsBearerChanAct[s_bc].s_TypeEnabled = gus_TpsTcType[i];
//            memcpy(&gta_DsBearerChanAct[s_bc].ta_TpsTcType, &gta_DsBearerChannel[s_bc].ta_TpsTcType[i], sizeof(TPS_TC_Type_t));
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate = (uint16)(gta_DsBearerChannel[s_bc].ta_TpsTcType[i].ul_MinNetDataRate >> 1);
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate = (uint16)(gta_DsBearerChannel[s_bc].ta_TpsTcType[i].ul_MaxNetDataRate >> 1);
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinResNetDataRate = (uint16)(gta_DsBearerChannel[s_bc].ta_TpsTcType[i].ul_MinResNetDataRate >> 1);
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.s_MaxLatency = gta_DsBearerChannel[s_bc].ta_TpsTcType[i].s_MaxLatency;
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.uc_IMAxINP = (uint8)(gta_DsBearerChannel[s_bc].ta_TpsTcType[i].s_IMAxINP);
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.uc_TPSTCoptions = gta_DsBearerChannel[s_bc].ta_TpsTcType[i].uc_TPSTCoptions;

         }
      }
   }

   // compute the VDSL2 derived framing parameters
   Compute_VDSL2Framing(&gt_rx_config_v2, &gt_rx_TPS_Map, &gs_PMDFramesPerRxIBStructure);
   l_BitsPerSymbol = (int32)(gt_rx_config_v2.ul_Lp[LP0] + gt_rx_config_v2.ul_Lp[LP1]);
   //}

   // use ADSL like tone-reordering
   gs_TxToneOrderType = NORMAL_TONE_ORDER;
   gs_RxToneOrderType = NORMAL_TONE_ORDER;

   // set up RX ping-pong table - BAT/GST/EGT/TRT
   gft_BitloadOK |= PingPongTableSetUp(RX, (int32)l_BitsPerSymbol, gs_RxMaxConstSize);

#ifdef ENABLE_SHOW_LPBK
   // initialize FDQ coefficients for showtime test
   //Call this function only in loopback test
   if(TESTArray[TEST_LoopbackMode] != TEST_LpbkDisabled)
   {
      SetFDQForShowtimeTest();
   }
#endif //#ifdef ENABLE_SHOW_LPBK

   //Initialize these variable used by synch frame operation
   gs_RxSynchFrameNumTones = 16; // # of tones to read from RTV buffer, should be less than RX_SYNC_FRAME_SIZE_LW
   gs_RxSynchFrameOffset = gsa_RxBandLeftChannel[0];   // Offset into RTV buffer

   guc_BgRxShowInitState = TRAINING_DONE;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT PingPongTableSetUp(FlagT ft_TxRxID, int32 l_TotalDataBits, int16 s_ConstSize)
*
*   This function sets BAT and GST for either TX or RX.
*
*   Input Arguments:
*      ft_TxRxID: indicate if this is TX or RX
*      l_TotalDataBits: total number of data bits
*      s_ConstSize: maximum constellation size
*
*   Output Arguments:
*
*   Returns:
*      ft_BitloadStatus: bitloading succeed, 0: bitload fail
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

FlagT PingPongTableSetUp(FlagT ft_TxRxID, int32 l_TotalDataBits, int16 s_ConstSize)
{
   FlagT ft_BitloadStatus;
   int16 s_channel, s_CurBand;
   int16 s_NumTonesLoaded = 0;
   int16 s_Num1BitTones = TESTArray[TEST_NumOneBitTone];
   PT_ArrIdx_te UsedPilot = gt_PilotConfig.te_UsedPTArrayIdx;
   FlagT ft_TcmFlag;
   int16 s_NumOfBands;
   int16 *psa_BandLeftChannel, *psa_BandRightChannel;
   uint8 *puca_Bat;
   int16 *psa_Gain;

   if(ft_TxRxID == TX)
   {
      ft_TcmFlag = gft_TxTcmFlag;
      s_NumOfBands = gs_NumOfTxBands;
      psa_BandLeftChannel = gsa_TxBandLeftChannel;
      psa_BandRightChannel = gsa_TxBandRightChannel;
      puca_Bat = ghpuca_TxBat_Inactive;
      psa_Gain = ghpsa_TxFineGains_Inactive;
   }
   else //RX
   {
      ft_TcmFlag = gft_RxTcmFlag;
      s_NumOfBands = gs_NumOfRxBands;
      psa_BandLeftChannel = gsa_RxBandLeftChannel;
      psa_BandRightChannel = gsa_RxBandRightChannel;
      puca_Bat = ghpuca_RxBat_Inactive;
      psa_Gain = ghpsa_RxFineGains_Inactive;
   }


   // for TCM
   if (ft_TcmFlag)
   {
      // we need to add a bit depending on number of loaded tones, so reduce constsize by 1
      s_ConstSize--;
      // we need to add 4 bits to the BAT table to send predetermined sequence to drive TCM Encode/Decoder to know state
      l_TotalDataBits += 4;
   }

   // set BAT/GST
   for (s_CurBand=0; s_CurBand<s_NumOfBands; s_CurBand++)
   {
      for (s_channel=psa_BandLeftChannel[s_CurBand]; s_channel<=psa_BandRightChannel[s_CurBand]; s_channel++)
      {
         if (s_channel == gt_PilotConfig.ta_PilotTones[UsedPilot].s_PilotToneIdx)
         {
            puca_Bat[s_channel] = 0;
         }
         else if (s_NumTonesLoaded < s_Num1BitTones)
         {
            puca_Bat[s_channel] = 1;
            l_TotalDataBits--;
            s_NumTonesLoaded++;
            if (ft_TcmFlag && !(s_NumTonesLoaded % 4))
            {
               l_TotalDataBits++;   // if TCM Enabled, add a bit for every tone pair
            }
         }
         else if (l_TotalDataBits > s_ConstSize)
         {
            puca_Bat[s_channel] = (uint8)s_ConstSize;
            l_TotalDataBits -= s_ConstSize;
            s_NumTonesLoaded++;
            if (ft_TcmFlag && (s_NumTonesLoaded % 2))
            {
               puca_Bat[s_channel]++;   // if TCM Enabled, add a bit for every tone pair
            }
         }
         else if (l_TotalDataBits > 0)
         {
            if (l_TotalDataBits > 1)
            {
               puca_Bat[s_channel] = (uint8)l_TotalDataBits;
            }
            else
            {
               puca_Bat[s_channel-1]--;
               puca_Bat[s_channel] = (uint8)(l_TotalDataBits+1);
            }
            l_TotalDataBits = 0;
            s_NumTonesLoaded++;
            if (ft_TcmFlag && ((s_NumTonesLoaded % 2)||(s_Num1BitTones % 4)))
            {
               puca_Bat[s_channel]++;   // if TCM Enabled, add a bit for every tone pair
            }
         }
         psa_Gain[s_channel] = 0x2000;
      }
   }

   if(ft_TxRxID == RX)
   {
      for (s_CurBand=0; s_CurBand<s_NumOfBands; s_CurBand++)
      {
         gsa_BitloadLeftChannel[s_CurBand] = psa_BandLeftChannel[s_CurBand];
         gsa_BitloadRightChannel[s_CurBand] = psa_BandRightChannel[s_CurBand];
      }
   }

   if (l_TotalDataBits == 0)
   {
      ft_BitloadStatus = SUCCEED;
   }
   else
   {
      ft_BitloadStatus = FAIL;
   }

   return(ft_BitloadStatus);
} //PingPongTableSetUp(Flag ft_TxRxID, int32 l_TotalDataBits, int16 s_ConstSize)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetFDQForShowtimeTest(void)
*
*   This function sets FDQ coefficients for showtime test.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

extern int16 gs_FdqMant;
extern uint8 guc_FdqExp;

void SetFDQForShowtimeTest(void)
{
   int16 s_NumChans;
   int16 s_FdqMant;
   uint8 uc_FdqExp;
   int16 s_CurBand, s_ToneIdx, s_Idx;

   if(TESTArray[TEST_LoopbackMode] == TEST_LpbkDisabled)
   {
      s_FdqMant = gs_FixedFdqMant;
      uc_FdqExp = guc_FixedFdqExp;
   }
   else
   {
      s_FdqMant = 0x2A66;
      uc_FdqExp = 1;
   }

   for (s_ToneIdx = 0; s_ToneIdx < MAX_NUM_CHANNELS_PER_GROUP; s_ToneIdx++)
   {
      s_Idx = s_ToneIdx << 1;
      gsa_pre_FDQ_coef[s_Idx] = s_FdqMant;
      gsa_pre_FDQ_coef[s_Idx+1] = 0;
      guca_pre_FDQ_exp[s_ToneIdx] = uc_FdqExp;
   }

   // apply Tx/Rx CG difference (0x4000/0x304D)
   // additional factor of 2 is needed for connectivity test because of scaleback in transmitter's IFFT preprocessing stage

   // these coeficients get scale the differences between Tx Gain Scale and Rx Gain Scale
   for (s_CurBand = 0; s_CurBand < gs_NumOfRxBands; s_CurBand++)
   {
      for (s_ToneIdx = gsa_RxBandLeftChannel[s_CurBand]; s_ToneIdx <= gsa_RxBandRightChannel[s_CurBand];
            s_ToneIdx += MAX_NUM_CHANNELS_PER_GROUP)
      {
         if ((s_ToneIdx + MAX_NUM_CHANNELS_PER_GROUP - 1) <= gsa_RxBandRightChannel[s_CurBand])
         {
            s_NumChans = MAX_NUM_CHANNELS_PER_GROUP;
         }
         else
         {
            s_NumChans = gsa_RxBandRightChannel[s_CurBand] - s_ToneIdx + 1;
         }

         StoreFdqMant(gsa_pre_FDQ_coef, s_ToneIdx, s_NumChans);
         StoreFdqExp(guca_pre_FDQ_exp, s_ToneIdx, s_NumChans);
      }
   }
}


