/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CmvInit_PowerUp.c
*
*   This file contains CMV initialization routines.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// CmvInit_PowerUp.c
//
// History
//
// 16/05/2012 Vinjam: Enabling/Disabling Downstream Virtual Noise feature control is moved from CMV MONI 4 to
//            CMV DSL 0, as per VR9 Message Specifications (1.6.1).
//            By default, Both Downstream & Upstream virtual noise feature's are disabled as per VR9 Message Spec.
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 16/05/2012 Vinjam: A structure "gt_DS_RefVirtNoiseLevel_VDSL2" contains DS Virtual Noise break points
//            is attached to "CMV CNFG 47".
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//                 Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 15/01/2013 Kannan: Added CMV to control AFE init fail indication. Be default AFE init fail indication
//                is enabled.
//                Grep for: "XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication"
//
// 29/01/2013 Sooraj: Added "CMV INFO 234" used to convey the AELEM status
//                Grep for: XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
//
//01/02/2013 Kannan: Added CMV in CNTR[56] to hold the DSL FW in Pre Fail wait state(LinkDownState)
//                  to read debug data using DCT tool. CNTR[56] set to "0"
//                  for VRX318 and VRX318 will wait for ACK from PPE FW to own S_44K mem,
//                  but for VR9 set to 2048, since VR9 don't have S_44K mem and can't poll
//                  with PPE FW, since VR9 PPE FW don't have S_44K mem handshake implementation.
//                  So VR9 to wait till 2048(min) symbols to pull TX_CB data.
//                  Grep for: "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 18/2/2013 Vinjam: Corrected enabling of upstream & downstream bitswaps as per VRx Msg Spec using "CMV OPTN 15"
//               Grep for XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//                       new CMV DSL 25 added & mapped to delta freq offset
//                       Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
//
// 05/03/2013 Vinjam: Removed "Hardcoded" enabling of AELEM feature. Firmware must honour the API setting to enable/disable AELEM.
//                    By default, AELEM feature is enabled by default (as per Vrx Msg Spec 1.2)
//                    Grep for XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
//
// 10/04/2013 Vinjam: XDSLRTFW-789 : IKanos no connect with AELEM Bit advertised in HandShake (CLR)
//                    To avoid the IOP issue, disable conveying the AELEM capabilities in G.Hs CLR message by default (CMV INFO 232 3 Bit#0).
//                    Grep for XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg
//
// 06/05/2013 Varun : Added CMVs(DSL 26 0 to DSL 29 0) to status and controlling of Debug Buffer opereation
//                   Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and
//                "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 29/5/2013 Vinjam: Removed global variable gt_Bonding_DiscAggr_ControlCMV as it is redundant
//           (i) CMV CNFG 17 is initialized to gt_Bonding_DiscAggr_Control & (ii) Disabled bonding feature by default (as per VRx Msg Spec)
//           Code changes are done for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (valid for VDSL2 & ADSL2)
//
// 26/06/2013 Ram: Added new CMV DSL 31 to read G.Hs Handshake Control structure using DCT
//            Grep for XDSLRTFW-360 Enh_All_All_All_GetHandshakeControlInfo
//
// 11/07/2013 Vinjam: Added new IOP bit to toggle the Firmware version (first digit, chip ID) string sent in G.Hs
//            CMV allotted: CMV INFO 232 3 Bit#1, default set to "0" (i.e. sends FW version as 7.x.x.x).
//            Reason for this: (i) Old deployed Avinax Firmware supports VDSL2 ReTx for VR9 FW (5.x.x.x.x.x) only. So
//            to bring up VDSL2 ReTx with old Avinax DSLAM, send VRx318 FW version as 5.x.x.x (instead of 7.x.x.x) in G.Hs.
//            (ii) VRx318 FW sends FW version as 7.x.x.x with new Avinax firmware for VDSL2 ReTx.
//            Grep for XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString
//
// 24/07/2013 Vinjam: Added new IOP bit to change the GHs Revision between "2" & "3".
//            CMV allotted: CMV INFO 232 2 Bit#2, default set to G.Hs revision as "2".
//            Grep for XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//            Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
// 27/08/2013 Varun : Modified the code to make CMV INFO 229 0 common for both DS and US ReTx
//            Grep for  "XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV"
//            Also Modified code to make CMV CNFG 80 0 common for both DS and US ReTx
//            Grep for "XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV"
// 27/08/2013 Varun : Added new CMV CNTR 58 0 ==> US ReTx DTU Status counters
//                                  CNTR 59 0 ==> Us ReTx Performance Counters
//                                 INFO 237 0 ==> Us ReTx O PMS PARAMETERS(Ex - US Framing type selected, Qtx,lb,Q,V)
//                                  CNFG 84 0 ==> configure US Delay in DTUS and Symbols
//                                  RATE 3 0  ==> US ReTX ETR , Actual receiver delay , Actual INP shine and rein
//            Grep for "XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV"
// 06/09/2013 Ram: Added bug fix for 'No connect' with Vinax v1.4 CO when Bonding is enabled in CLR
//            Grep for XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode
// 19/09/2013 Varun: Added new CMV INFO 238 0 ==> gives the Max mips count(Foregraound + Tc task) in showtime if test 0 0 is 0x1000
//            Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
// 19/09/2013 Fuss: Addded new bits to CMV Test 41
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
//
// 05/03/2014 Prashant: Enable conveying AELEM capability in G.Hs CLR messages by default
//            Grep for XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg
// 10/03/2014 Kannan: Added CMV "test 43" to know the No of symbols spend in DS ReTx Framing.
//            it can be read using "cr test 43 0 1" or "./dsl_cpe_pipe.sh dms 2b04 0 1"
// 24/10/2014 Fuss: Controlling the line driver mode using a CMV gets broken
//            Grep for XDSLRTFW-2067
//
// 15/12/2014 Prashant: Following things are implemented wrt RetxDegug feature
//            1. Transmitter should offer an RRC codeword capture feature for up to 256 RRC CWs and capturing is started with the
//               first RRC CW where Nack[1:0] is unequal 0b00. (256 * 24bits to be stored).
//               Capture can be enabled by setting gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0. Once set to zero,
//               capture will start from first bad dtu and gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt will be incremented upto 255.
//               To re-capture again set gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0.
//            2. Transmitter should offer the possibility to measure the actual roundtrip in number of DTUs per DTU from DTU TX insertion
//               until getting the first ACK info and should report the max./min. value captured during operation. (This already exist)
//               Reseting the measurement during operation is suppoterd now.
//            3. The structure RtxDbgCapture_t has been mapped to a new CMV INFO 241.
//    Grep for XDSLRTFW-1622
//
// 30/09/2015 Vinay: Added a new CMV(CNFG 89) to support PME ID in bonding. The PME ID can be configured using the CMV in vdsl.scr
//                   Grep for XDSLRTFW-2382
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//    The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//    The internal split is not well-balanced for the wished service rates.
//    According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//    According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//    framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//    D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//    1-symbol reduction in Qtx,min calculation:
//    It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//    the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//    occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it is not needed to take into account the
//    +1 symbol in the Qtx,min calculation.
//    If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//    For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//    the left triangle part.
//    If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//    is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//    shown in the drawings before the triangle.
//    So from the figures it could be derived:
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//    But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//    Grep for : XDSLRTFW-2858
//
// 07/02/2018 Sriram shastry: VRX518: VDSL2 35b Vect. Sync Prob. with ADTRAN IUVDSL:48:SVM:F
//         No sync issue is seen when the maxETR is higher than maxNDR. Due to  CO Mis configuration
//         CPE fail with E_CODE_RX_LOW_PILOT_TONE_POWER.So the solution is cap max ETR to max NDR if maxETR > maxNDR
//         cmv description : TEST 55 0 1
//         (Default:ON)
//         Search  pattern : XDSLRTFW-3677
//
// 21/03/2018 Stefan Krause:  XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
// - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
// - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
// - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
//     Grep for XDSLRTFW-3665
//
// 08/08/2018 Stefan Krause/Sriram Shastry: XDSLRTFW-3914 :VRX518: Enable IOP bit for Vinax CO always in CPE FW per default
// During qualification efforts for Century-link it turned out that US performance versus Vinax V2 based DSLAMs increases significantly, when this IOP bit is set.
// Actually CO then sends a higher US PSD ceiling, CPE TX PSD is higher, US rates are higher.
// It was decided to enable this bit on VRX518 FW always versus all DSLAMs,
// as it does not harm versus BRCM based DSLAMs according our tests
//    Grep for XDSLRTFW-3914
//
// ************************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "timestmp.h"
#include "ghs.h"
#include "eoc.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"

extern RdyOvfUdf_t gt_RdyOvfUdfStatus;
// move these to gdata.h, cmv.h
extern int16 gs_ImageType;
extern FlagT  gft_ReInitTrigger;
extern FlagT gft_EnterL3State;
extern uint8 guc_PM_L3_InternalState;

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void CmvInit_PowerUp(void)
*
*   This function initializes all CMV mappings at power up.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void CmvInit_PowerUp(void)
{
   int16 i;

   /*========================================================================*/
   /* clear all CMV's */
   /*========================================================================*/

   for (i=0; i<CNTLARRAY_SIZE; i++)
   {
      CNTLArray[i] = 0;
   }
   for (i=0; i<STATARRAY_SIZE; i++)
   {
      STATArray[i] = 0;
   }
   for (i=0; i<TESTARRAY_SIZE; i++)
   {
      TESTArray[i] = 0;
   }

   for (i=0; i<OPTNARRAY_SIZE; i++)
   {
      OPTNArray[i] = 0;
   }
   for (i=0; i<INFOMAP_SIZE; i++)
   {
      INFOMap[i] = &gs_zero_cmv;
   }
   for (i=0; i<INFO2MAP_SIZE; i++)
   {
      INFO2Map[i] = &gs_zero_cmv;
   }
   for (i=0; i<RATEMAP_SIZE; i++)
   {
      RATEMap[i] = &gs_zero_cmv;
   }
   for (i=0; i<PLAMMAP_SIZE; i++)
   {
      PLAMMap[i] = &gs_zero_cmv;
   }
   for (i=0; i<CNTRMAP_SIZE; i++)
   {
      CNTRMap[i] = &gs_zero_cmv;
   }
   for (i=0; i<CNFGMAP_SIZE; i++)
   {
      CNFGMap[i] = &gs_zero_cmv;
   }
   for (i=0; i<SELTMAP_SIZE; i++)
   {
      SELTMap[i] = &gs_zero_cmv;
   }

   for (i=0; i<DSLMAP_SIZE; i++)
   {
      DSLMap[i]  = &gs_zero_cmv;
   }

   // XDSLRTFW-1184: BugFix_ALL_ALL_IFTN_No_Connect_In_AVDSL_Mode (Start)
   // XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (Start_End)
//   guc_ClrControl = 0;
   guc_ClrControl = CLR_SEND_NOT_TRANCSEIVER_ID;

   /*========================================================================*/
   /* initialize STAT */
   /*========================================================================*/
   // Initialize STAT map
   STAT_0_Map[0] = &gsa_IndirectStat0[0];    // gsa_IndirectStat0[2]= SOC message,
   // gsa_IndirectStat0[3]= Rx Signal, gsa_IndirectStat0[4]= Tx Signal
   STAT_1_Map[0] = &gsa_Stat1_Mode[0];
   STAT_5_Map[0] = (int16 *)(void *)&gt_FailStateInfo;

   /*========================================================================*/
   /* initialize DSLcmv */
   /*========================================================================*/
   gus_ApiOptions = OPTION_NTR_DISABLE;    // [DSL_OPTIONS]
   gus_PpeClockControl = 0;            // [DSL_PPE_CLOCK_CONTROL]

   /*========================================================================*/
   /* initialize OPTN */
   /*========================================================================*/
   // Initialize OPTN map
   OPTN_0_Map[0] = &gsa_Optn0_ModeControl[0];
   OPTN_2_Map[0] = &gsa_Optn2_AlgControl[0];
   OPTN_4_Map[0] = &gsa_Optn4_FilterControl[0];
   OPTN_28_Map[0] = (int16*)(void *)(NoiseMarginChange_t*)&gt_NoiseMarginChange;
   OPTN_29_Map[0] = (int16*)(void *)(SNROffsetControl_t*)&gta_SNROffset;

   // Initialize OPTN 0 Mode Control for VDSL2 mode
   gsa_Optn0_ModeControl[0] = 0;
   gsa_Optn0_ModeControl[1] = OPTN_ConfigMode_G993_2;

   // Initialize OPTN 0 Alg Control
   gsa_Optn2_AlgControl[0] = OPTN_DecUpdateDisable;   //Reserved

   gsa_Optn2_AlgControl[1] = (OPTN_PARRDisable |
                              OPTN_MFDQInitDisable |
                              OPTN_TdqDisable |
                              OPTN_DecDisable);

   gsa_Optn2_AlgControl[2] = (int16)(OPTN_MFDQUpdatesDisable |
                                     OPTN_USExtSMaxDisable |
                                     OPTN_DSExtSMaxDisable);

   gsa_Optn2_AlgControl[3] = OPTN_Config_4096_TONES;

   // Initialize OPTN 3 GHS Control

   // Initialize OPTN 4 Filter Control for ISDN signals
   gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] = ((OPTN_ISDN_Filter_Select << OPTN_RX_Filter_Select_POS)|OPTN_ISDN_Filter_Select);
   gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] = (int16)(OPTN_Rx_Filter_Auto_Reconfig|OPTN_Tx_Filter_Auto_Reconfig|OPTN_Tx_Filter_Enable|OPTN_Rx_Filter_Enable);
   gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] = 0;
   gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] = 0;
   gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] = 0;
   gsa_Optn4_FilterControl[OPTN_4_IDX5_FILTER_TTR] = 0;


   //For HW build
   OPTNArray[OPTN_HWConfiguration] = VRX_HYB_TYPE_ABJ;

   OPTNArray[OPTN_FeParamControl] = 0;
   OPTNArray[OPTN_FeParamControl] = OPTN_FeTestParamEnable | OPTN_FePMCountersEnable;
   OPTNArray[OPTN_FeParamControl] |= (OPTN_FeTestParamPollingTime << 8);
   // Initialize CMV Test 40 0 to zero (Default value)
   TESTArray[TEST_STR_IIR_HYB_LIF_CONFIG] = TEST_STR_IIR_HYB_LIF_CONFIG_AUTO;   // NewFeatures_All_VdslVectoring_All_CmvTest40


   //XDSLRTFW-1610 (START_END)
   TESTArray[TEST_NUM_SYM_DS_RETX_FRAMING] = 0;


   OPTNArray[OPTN_StateMachineCtrl] = OPTN_Skip_RLineProbe;

   //XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl (Start_End)
   // XDSLRTFW-2151 (Start_End)
   OPTNArray[OPTN_OLRControl] |= (OPTN_TxBitSwapEnable | OPTN_RxBitSwapEnable | OPTN_US_SRAEnable | OPTN_DS_SRAEnable); //Enable US & DS Bitswaps by default and Enable US and DS SRA by default //

//   OPTNArray[OPTN_NoiseMarginChange] = (int16*)(void *)(NoiseMarginChange_t*)&gt_NoiseMarginChange;

   /*========================================================================*/
   /* initialize RATE */
   /*========================================================================*/
   // Initialize RATE map

   RATEMap[RATE_UsRate] = (int16 *)(void *)&t_USRateInfo;
   RATEMap[RATE_DsRate] = (int16 *)(void *)&t_DSRateInfo;
   RATEMap[RTX_Status_Param_DS] = (int16 *)(void *)&gt_ReTXStats.ul_ReTX_ReceiverETR;

   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
   RATEMap[RTX_Status_Param_US] = (int16 *)(void *)&gt_ReTXStats.ul_UsReTX_ReceiverETR;

   /*========================================================================*/
   /* initialize CNFG */
   /*========================================================================*/

   // each of the CNFG_TPS entries points to a structure of type (TPS_TC_BearerChannel_t)
   CNFGMap[CNFG_TPS_TC_DS0] = (int16*)(void *)(TPS_TC_BearerChannel_t*)&gta_DsBearerChannel[BC0];
   CNFGMap[CNFG_TPS_TC_DS1] = (int16*)(void *)(TPS_TC_BearerChannel_t*)&gta_DsBearerChannel[BC1];
   CNFGMap[CNFG_TPS_TC_US0] = (int16*)(void *)(TPS_TC_BearerChannel_t*)&gta_UsBearerChannel[BC0];
   CNFGMap[CNFG_TPS_TC_US1] = (int16*)(void *)(TPS_TC_BearerChannel_t*)&gta_UsBearerChannel[BC1];

   // each of the CNFG_PMS entries points to a structure of type (PMS_TC_LatencyPath_t)
   CNFGMap[CNFG_PMS_TC_DS0] = (int16*)(void *)(PMS_TC_LatencyPath_t*)&gta_DsLatencyPath[LP0]; // INLV
   CNFGMap[CNFG_PMS_TC_DS1] = (int16*)(void *)(PMS_TC_LatencyPath_t*)&gta_DsLatencyPath[LP1]; // FAST
   CNFGMap[CNFG_PMS_TC_US0] = (int16*)(void *)(PMS_TC_LatencyPath_t*)&gta_UsLatencyPath[LP0]; // INLV
   CNFGMap[CNFG_PMS_TC_US1] = (int16*)(void *)(PMS_TC_LatencyPath_t*)&gta_UsLatencyPath[LP1]; // FAST

   CNFGMap[CNFG_Overhead_Requirements] = (int16*)(void *)(MinMsgOHR_t*)&gt_MinMsgOHRConfig;

   CNFGMap[CNFG_tx_Cnfg_BCtoLP] = &gt_tx_TPS_Map.s_BCtoLP[BC0];

   CNFGMap[CNFG_rx_Cnfg_BCtoLP] = &gt_rx_TPS_Map.s_BCtoLP[BC0];


   CNFGMap[CNFG_Snr_Margin] = (int16*)(void *)(SnrMgnConfig_t*)&gt_SnrMgnConfig;

   CNFGMap[CNFG_DSAutoSRA_Ctrl] = (int16*)(void *)(AutoSRA_t*)&gt_RxAutoSRA_Ctrl;

   // cmv's used in selt state

#ifdef VDSL_BONDING
   //XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (Start)
   CNFGMap[CNFG_Bonding_DiscAggr_Control] = (int16*)(void *)(Bonding_DiscAggr_Control_t*)&gt_Bonding_DiscAggr_Control;
   //Disable bonding by default
   gt_Bonding_DiscAggr_Control.s_PCS_control = 0;
   //XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (End)
#endif

   CNFGMap[CNFG_pwr_Cnfg_Param] = (int16*)(void *)(PwrConfigParam_t*)&gt_PwrConfigParamCMV;
   CNFGMap[CNFG_DS_Band_Ctrl] = (int16*)(void *)(BandDescriptorTable_t*)&gt_RxBandControl;
   CNFGMap[CNFG_US_Band_Ctrl] = (int16*)(void *)(BandDescriptorTable_t*)&gt_TxBandControl;

   CNFGMap[CNFG_DS_MAX_PSD_Brkpt_Ctrl] = (int16*)(void *)(DsPSDDescriptorTable_t*)&gt_MaxDsPSDDescriptorTableCMV;
   CNFGMap[CNFG_US_REF_PSD_Brkpt_Ctrl] = (int16*)(void *)(UsPSDDescriptorTable_t*)&gt_RefUsPSDDescriptorTableCMV;
   CNFGMap[CNFG_US_MAX_PSD_Brkpt_Ctrl] = (int16*)(void *)(UsPSDDescriptorTable_t*)&gt_MaxUsPSDDescriptorTableCMV;

   CNFGMap[CNFG_RFI_Band_Ctrl] = (int16*)(void *)(RFIBandDescriptorTable_t*)&gt_RFIBandControl;

   CNFGMap[CNFG_Profile_Ctrl] = (int16*)(void *)(ProfileControl_t*)&gt_ProfileControl;

   CNFGMap[CNFG_GHS_CarSet] = (int16*)&gs_GhsCarSetCfg;

   CNFGMap[CNFG_Modem_Config] = (int16*)(void *)(ModemConfig_t*)&gt_ModemConfig;

   CNFGMap[CNFG_GAIN_CALIBRATION] = (int16*)(void *)(GainCalibration_t*)&gt_GainCalibration;

   CNFGMap[CNFG_UPBO_PSD_Brkpt_Ctrl] = (int16*)(void *)(UPBOPSDDescriptorTable_t*)&gt_UPBOPSDDescriptorTable;

   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
   CNFGMap[CNFG_VirtNoiseDS_PSD_Brkpt_Ctrl] = (int16*)(void *)(DsVnPSDDescriptorTable_t*)&gt_DS_RefVirtNoiseLevel_VDSL2;

   CNFGMap[CNFG_VirtNoiseUS_PSD_Brkpt_Ctrl] = (int16*)(void *)(UsVnPSDDescriptorTable_t*)&gt_US_RefVirtNoiseLevel_VDSL2;

   CNFGMap[CNFG_UPBO_CONTROL] = (int16*)(UPBOControl_t*)&gt_UPBOControl;


   CNFGMap[CNFG_PARRThreshold] = (int16*)&gs_parr_threshold_dBm_8p8;

   CNFGMap[CNFG_DilvPartition] = (int16*)(void *)&gus_PctMaxDelayOctetsForUS;

   CNFGMap[CNFG_CeilingOptBandPlanEnable] = (int16*)&gs_CeilingOptBandPlanEnable;

#ifdef USE_MFDQ_HW_WORK_AROUND
   CNFGMap[CNFG_MfdqHwWkArnd] = (int16*)&gt_MfdqHwWkArndConfig;
#endif

   CNFGMap[CNFG_Misc] = (int16*)(void *)&gsa_Cnfg_Misc;

   //XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG
   gsa_Cnfg_Misc[0] = CNFG_Misc_SendShortCLR_G992_1 | CNFG_Misc_SendShortCLR_G992_3 | CNFG_Misc_SendShortCLR_G992_5;

   //XDSLRTFW-3688 Control of GPIO14 to indicate dying gasp
   //place holder for enabling by default GPIO14 indicator for Dying Gasp
   //gsa_Cnfg_Misc[0] |= CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP;

   // XDSLRTFW-4086: Enable custom HLOG reporting option by default for all operators.
   // This avoids Hlog reporting for not supported tones with very bad SNR.
   gsa_Cnfg_Misc[0] |= CNFG_Misc_HlogReportStdVsCustm;

   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
   CNFGMap[CNFG_RTX_CTRL_DS_US] = (int16*)(void *)&gt_ReTXParams.t_ReTXConfigCMV.us_DsUsReTxCapable;

   // Disable the support of full vectoring and any vectoring-friendly operation
   gus_DsmCtrlCmv = G9935_G9932_VECTORING_DISABLED;
   CNFGMap[CNFG_DSM_CTRL] = (int16*)(void *)&gus_DsmCtrlCmv;

   CNFGMap[CNFG_CMD_MAC_FRAMECONFIGURE] = (int16 *)(void *)&gt_MacFrameConfigure;

   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
   CNFGMap[CNFG_US_RETX_DELAY_PARAMS] = (int16*)(&gt_UsReTx_ConfigVar.s_UsReTx_FrameType_Support);

   CNFGMap[CNFG_AMEND2_ILV_MEM_AVAIL] = (int16*)(void *)(&gul_ItlvMemSizeReTxRMsg2);

   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start_End)
   CNFGMap[CNFG_DBG_IMPROVED_ATTNDR] = (int16*)(void *)(&gt_DbgImprovedATTNDR);

   //XDSLRTFW-2260 (Start)
   CNFGMap[CNFG_RX_PSD_EXTERNAL_COMPENSATION] = (int16*)(void *)(&gt_DsPsdCompensationTable);
   CNFGMap[CNFG_TX_PSD_EXTERNAL_COMPENSATION] = (int16*)(void *)(&gt_UsPsdCompensationTable);
   //XDSLRTFW-2260 (End)

   //XDSLRTFW-2382 (Start_End)
   CNFGMap[CNFG_BONDING_PME_ID] = (int16 *)(void *)&gus_Bonding_PME_ID;
   CNFGMap[CNFG_RETX_FORCED_FRAMING] = (int16*)(void *)(&gt_ReTxForcedFraming); // XDSLRTFW-3020

   CNFGMap[CNFG_FAST_DsSRA_Config] =  (int16*)(void *)(&gt_FastDsSraConfig); // XDSLRTFW-4051 Fast downstream up shift SRA
   /*========================================================================*/
   /* initialize INFO */
   /*========================================================================*/

   INFOMap[INFO_TxState] = &gs_TxState;
   INFOMap[INFO_RxState] = &gs_RxState;
   INFOMap[INFO_TxNextState] = &gs_TxNextState;
   INFOMap[INFO_RxNextState] = &gs_RxNextState;
   INFOMap[INFO_TxStateJumpFrom] = &gs_TxStateJumpFrom;
   INFOMap[INFO_RxStateJumpFrom] = &gs_RxStateJumpFrom;

// JumpTo CMVs are no longer valid, they are also removed from MP files.
// Two new global variables "gpF_TxStateJumpTo" and "gpF_RxStateJumpTo"will
// be added in and initialized as Done State function pointer.
// THERE IS NO CMV CONTROL FOR IT. The only way to changes their values is
// by a "memory write" command in WinHost.


   INFOMap[INFO_UsContract]        = (int16*)(void *)&gt_tx_contract;
   INFOMap[INFO_DsContract]        = (int16*)(void *)&gt_rx_contract;
   INFOMap[INFO_UsConfig]        = (int16*)(void *)&gt_tx_config;
   INFOMap[INFO_DsConfig]        = (int16*)(void *)&gt_rx_config;

   INFOMap[INFO_UsConfigVDSL2]    = (int16*)(void *)&gt_tx_config_v2;
   INFOMap[INFO_DsConfigVDSL2]    = (int16*)(void *)&gt_rx_config_v2;

#ifdef DEBUG_TRAIL
   // Debug Trail Control, Status, Data
   INFOMap[INFO_DebugTrailControl] = (int16*)(void *)&gt_debugTrailControl;
   INFOMap[INFO_DebugTrailStatus] = (int16*)(void *)&gt_debugTrailStatus;
   INFOMap[INFO_DebugTrail] = &gsa_StatesTrail[0];
#endif // DEBUG_TRAIL
   INFOMap[INFO_SnrBuf] = gsa_SnrBuf;
   INFOMap[INFO_MedleySnrBuf] = gsa_MedleySnrBuf;

   INFOMap[INFO_DEBUG_STREAM_CONTROL] = (int16*)(void *)&gt_debugStreamControl;
   INFOMap[INFO_DEBUG_STREAM_CONFIGURE] = (int16*)(void *)&gt_debugStreamConfigure;

   INFOMap[INFO_Reverb2SnrBuf] = gsa_ReverbSnrBuf;

   INFOMap[INFO_TimeStamp]=(int16*)(void *)(&guca_TimeStampString);
   INFOMap[INFO_Version] = (int16*)(void *)(&gusa_FW_version_number[0]);

   INFOMap[INFO_BulkMemory] = (int16*)0x20000;   //Start of Bulk memory

   //------------------------------------------------
   // inventory information
   //------------------------------------------------
   // XDSLRTFW-1479 (Start)
   INFOMap[INFO_CPEG9941VendorID] = (int16*)(void *) (&(gt_ne_VendorInformation. uca_CountryCode[0]));
   INFOMap[INFO_COG9941VendorID] = (int16*)(void *) (&(gt_fe_VendorInformation. uca_CountryCode[0]));
   // XDSLRTFW-1479 (End)
   INFOMap[INFO_CPESystemVendorID] = (int16*)(void *)(guca_ne_SystemVendorID);
   INFOMap[INFO_CPESystemVersionNum] = (int16*)(void *)(guca_ne_SystemVersionNum);
   INFOMap[INFO_CPESystemSerialNum] = (int16*)(void *)(guca_ne_SystemSerialNum);
   INFOMap[INFO_COSystemVendorID] = (int16*)(void *)(guca_fe_SystemVendorID);
   INFOMap[INFO_COSystemSerialNum] = (int16*)(void *)(guca_fe_SystemSerialNum);
   INFOMap[INFO_COSystemVersionNum] = (int16*)(void *)(guca_fe_SystemVersionNum);

   INFOMap[INFO_COAuxInvInfo] = (int16*)(void *)&guca_fe_AuxInvInfo[0];
   INFOMap[INFO_CPEAuxInvInfo] = (int16*)(void *)&guca_ne_AuxInvInfo[0];

   //------------------------------------------------
   // Signal and Margin Information
   //------------------------------------------------

   INFOMap[INFO_DsSignalAndMargin] = (int16* )(void *) &gt_LineStatusDS;
   INFOMap[INFO_UsSignalAndMargin] = (int16* )(void *) &gt_LineStatusUS;

   INFOMap[INFO_PsdBuf] = &gsa_SnrBuf[0];

   INFOMap[INFO_HLIN_DS] = (int16*)(void *)gpusa_HlinBuf_NE;
   INFOMap[INFO_HLOG_DS] = gsa_RxHlog;
   INFOMap[INFO_QLN_DS] = (int16*)(void *)guca_QLN;
   INFOMap[INFO_SNR_DS] = (int16*)(void *)guca_SNRBuf_NE;
   INFOMap[INFO_ChannelMeasurement_DS] = (int16*)(void *)&gt_ChannelMeasurement_NE;

   INFOMap[INFO_HLIN_US] = (int16*)(void *)gpusa_HlinBuf_FE;

   // XDSLRTFW-3606 (Start)
   INFOMap[INFO_HLOG_US] = (int16*)(void *)&gt_FEParams.us_Hlog;
   INFOMap[INFO_QLN_US] = (int16*)(void *)&gt_FEParams.uc_Qln;
   INFOMap[INFO_SNR_US] = (int16*)(void *)&gt_FEParams.uc_Snr;
   INFOMap[INFO_ChannelMeasurement_US] = (int16*)(void *)&gt_ChannelMeasurement_FE;
   // XDSLRTFW-3606 (End)

   INFOMap[INFO_FEDATA] = (int16 *)(void *)&gt_FEData;

   // The 1st 2 bytes are the length (in bytes)
   // If an Snmp msg then the next 2 bytes are 0x814C
#ifdef CLEAR_EOC
   INFOMap[INFO_ME_HDLC_TxBuffer] = (int16 *)(void *)&gt_INFO_CEocTxBuf;
   INFOMap[INFO_ME_HDLC_RxBuffer] = (int16 *)(void *)&gt_INFO_CEocRxBuf;
#endif
   INFOMap[INFO_US_OLRPMCnt] = (int16*)(void *)&gt_UsOLRPMCnt;
   INFOMap[INFO_DS_OLRPMCnt] = (int16*)(void *)&gt_DsOLRPMCnt;

   INFOMap[INFO_TIMESTATUS] = (int16*)(void *)&gt_TimeStat;
   // XDSLRTFW-3898(Start)
   INFOMap[INFO_RECONF_HYB_COEFF]= (int16*)(void *)&gt_Reconf_Hybrid_Coeff;
   // XDSLRTFW-3898(End)
   /*========================================================================*/
   /* initialize INFO2 */
   /*========================================================================*/

   INFO2Map[INFO2_DS_Band_Ctrl] = (int16*)(void *)(BandDescriptorTable_t*)&gt_RxBandControl_Act;
   INFO2Map[INFO2_US_Band_Ctrl] = (int16*)(void *)(BandDescriptorTable_t*)&gt_TxBandControl_Act;

   INFO2Map[INFO2_RFI_Band_Ctrl] = (int16*)(void *)(RFIBandDescriptorTable_t*)&gt_RFIBandControl_Act;

   INFO2Map[INFO2_ATN_SNRM_PER_BAND_DS] = (int16*)(void *)(AttenSnrMPerRxBand_t*)&gt_AttenSnrMPerRxBand;
   INFO2Map[INFO2_ATN_SNRM_PER_BAND_US] = (int16*)(void *)(AttenSnrMPerRxBand_t*)&gt_AttenSnrMPerRxBand_FE;

   INFO2Map[INFO2_FE_OperatingModes] = (int16*)(void *)(FE_OperatingModes_t*)&gt_FE_OperatingModes;
   INFO2Map[INFO2_FE_StdInfo_CL] = (int16*)(void *)(VDSL2_FE_StdInfo_CL_t*)&gt_VDSL2_FE_StdInfo_CL;

   INFO2Map[INFO2_Profile_Actual] = (int16*)(void *)(ProfileActual_t*)&gt_ProfileAct;

   INFO2Map[INFO2_ImageType] = (int16*)&gs_ImageType;


   INFO2Map[INFO2_DS_ACT_PSD] = (int16*)(void *)(DsRefPSDDescriptorTable_t*)&gt_DsREFPSDDescriptorTable;
   INFO2Map[INFO2_US_ACT_PSD] = (int16*)(void *)(UsPSDDescriptorTable_t*)&gt_UsREFPSDDescriptorTable;

   INFO2Map[INFO2_KL0_ELECTRICAL_LENGTH] = (int16*)(void *)(Kl0ElectricalLength_t*)&gt_Kl0ElectricalLength;


   INFO2Map[INFO2_pwr_Cnfg_Param_Actual] = (int16*)(void *)(PwrConfigParam_t*)&gt_PwrConfigParam;

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]

   INFO2Map[INFO2_RA_ModeDS] = (int16*)(void *)(&gus_DsRAMode);
   INFO2Map[INFO2_RA_ModeUS] = (int16*)(void *)(&gus_UsActRAMode);

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

#ifdef BIT_PATTERN_TEST

   INFO2Map[INFO2_BIT_PATTERN_SEL] = (int16 *)(void *) &gus_BitPatternIndex;
   INFO2Map[INFO2_NUM_MISMATCH] =(int16 *)(void *)&gul_NumDiff;
   INFO2Map[INFO2_IFFT_ARRAY] = gpsa_IfftBuffer;
   INFO2Map[INFO2_FFT_ARRAY] =   gpsa_RxTimeBuffer;
   INFO2Map[INFO2_BIT_PATERN_VAL] =(int16*)(void *) &gus_BitPatternVal;
   INFO2Map[INFO2_LOOP_DELAY]=  (int16 *) &gs_PathDelay;
   INFO2Map[INFO2_COMPARELOG_ENABLE] = (int16 *)&gs_CompareLog_Enable;
   INFO2Map[INFO2_RXTONEBUF] = gpsa_RxToneBuf;
#endif //BIT_PATTERN_TEST
#ifdef VDSL_BONDING
   INFO2Map[INFO2_Bonding_DiscAggr_Status] = (int16*)(void *)(Bonding_DiscAggr_Status_t*)&gt_Bonding_DiscAggr_Status;
#endif

   INFO2Map[INFO2_CutUS0Psd] = (int16*)(void *)&gft_EnableUS0PsdCut;
   INFO2Map[INFO2_IOP_LATN_KL0] = (int16*)&gsa_IOP_LATN_Kl0[0];
   //XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
   INFO2Map[INFO2_CUSTOMER_IOPBITS] = (int16*)(void *)(CustomerIOPBits_t *) &gt_CustomerIopBits;
   //XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
   INFO2Map[INFO2_AELEM_UPBO] = (int16*)(void *)(AELEM_UPBOInfo_t*)&gt_AELEM_UPBOInfo;

   //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (Start_End)
   // XDSLRTFW-3914:Enable_IOP_bit_Vinax_default(Start_End)
   // Vinax & Avinax CO's looking for VR9 platform ID to enable certain features
   // like UPBO, ReTx and G.vector etc,
   // Hence by default send VR9 Platform ID for VRX518 too
   gt_CustomerIopBits.us_Generic_IOP_Fixes |= GENERIC_TOGGLE_CHIP_ID_IN_GHS_VERSION;
   //XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange (Start_End)
   gt_CustomerIopBits.us_Generic_IOP_Fixes &= ~GENERIC_GHS_REVISION_CHANGE_IN_GHS_MSGS;

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
   INFO2Map[INFO2_RETX_STATUS] = (int16*)(void *) &gus_DsUsReTxStatus;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

//XDSLRTFW-565 IOP_US_ALL_HaweVDMF_UPBO_FEXT_WITHOUT_CO_GHS_SUPPORT
   INFO2Map[INFO2_IOP_UPBO_FEXT] = (int16*)(void *)&gft_IOP_UPBO_FEXT;

//XDSLRTFW-554 BUG_US_ALL_ALL_PSDVIOLATION
   //INFO2Map[INFO2_US_PSD_BOOST] = (int16*)&gsa_IOP_PSD_Boost[0];

   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
   INFO2Map[INFO2_US_RETX_O_PMS_PARAMETERS] = (int16*)(void *)(&gt_ReTXParams.us_OPMS_UsFramingType);

   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

   //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START_END)
   INFO2Map[INFO2_MIPS_FOREGROUND_TCTASK_VALUES] = (int16*)(void *)(&gta_MaxMIPSCnt[0]);

   //XDSLRTFW-1422(START_END)
   INFO2Map[INFO2_USRETX_DELAY_ESTIMATE] = (int16*)(void *)(&gt_UsReTx_DelayDTUs);

   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start_End)
   INFO2Map[INFO2_IMPROVED_ATTNDR_ACT_PARAMS]= (int16*)(void *)(&gt_Improved_ATTNDR_ActParam);

   // XDSLRTFW-1622 (Start_End)
   INFO2Map[INFO2_ReTxDbgCapture]= (int16*)(void *)(&gt_RtxDbgCapture);

   // XDSLRTFW-3565 (Start_End)
   // XDSLRTFW-3711 (Start_End)
   INFO2Map[INFO2_PPE_CLOCK_GET] = (int16 *)(void *)(&gus_PPEClock_Configured);

   // XDSLRTFW-3344 (Start)
   INFO2Map[INFO2_HLOG_PERTONE] = (int16 *)(void *)(&gsa_RxHLog_PerTone);
   INFO2Map[INFO2_QLN_PERTONE] = (int16 *)(void *)(&guca_QLN_PerTone);
   // XDSLRTFW-3344 (End)
   /*========================================================================*/
   /* initialize CNTR */
   /*========================================================================*/

   CNTRMap[CNTR_NE_LinePerf_Running] = (int16* )(void *) &gt_g997_LinePerf_Running_NE;
   CNTRMap[CNTR_NE_LinePerf_TR1_Curr_Prev] = (int16* )(void *) &gt_g997_LinePerf_Current_Previous_TR1_NE.t_Current;
   CNTRMap[CNTR_FE_LinePerf_Running] = (int16* )(void *) &gt_g997_LinePerf_Running_FE;
   CNTRMap[CNTR_FE_LinePerf_TR1_Curr_Prev] = (int16* )(void *) &gt_g997_LinePerf_Current_Previous_TR1_FE.t_Current;
   CNTRMap[CNTR_LineInitPerf_Running] = (int16*)(void *)(G997_LineInitPerf_t*)&gt_g997_LineInitPerf_Running;
   CNTRMap[CNTR_LineInitPerf_TR1_Curr_Prev] = (int16*)(void *)(G997_Curr_Prev_LineInitPerf_t*)&gt_g997_LineInitPerf_Current_Previous_TR1;
   CNTRMap[CNTR_NE_CRC_Running] = (int16*)(void *) &gt_g997_ChPerf_CRC_Running_NE;
   CNTRMap[CNTR_NE_CRC_TR1_Curr_Prev] = (int16*)(void *) &gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE.t_Current;
   CNTRMap[CNTR_NE_FEC_Running] = (int16*)(void *) &gt_g997_ChPerf_FEC_Running_NE;
   CNTRMap[CNTR_NE_FEC_TR1_Curr_Prev] = (int16*)(void *) &gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE.t_Current;
   CNTRMap[CNTR_FE_CRC_Running] = (int16*)(void *) &gt_g997_ChPerf_CRC_Running_FE;
   CNTRMap[CNTR_FE_CRC_TR1_Curr_Prev] = (int16*)(void *) &gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE.t_Current;
   CNTRMap[CNTR_FE_FEC_Running] = (int16*)(void *) &gt_g997_ChPerf_FEC_Running_FE;
   CNTRMap[CNTR_FE_FEC_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE.t_Current;

   //XDSLRTFW-952 : ALL_ALL_VDSL_ALL_Inhibition
   //CMV Mapping is for Byte 1 - CW CNTR 0 1 "val"
   CNTRMap[CNTR_TR1_Control] = (int16 *)  &gt_G997_Cntrl.s_MaxInterval_Count; //Inhibition Counters
   //XDSLRTFW-952 : ALL_ALL_VDSL_ALL_Inhibition
   CNTRMap[CNTR_LinePerf_Alarm_Threshold] = (int16 *) &gt_g997_LinePerfThresholdControl.t_NE_Alarm.l_FECS_L_count;
   CNTRMap[CNTR_NE_HEC_Running] = (int16 *)(void *) &gt_g997_AtmPerf_HEC_Running_NE.la_HEC_P_count[ABC0];
   CNTRMap[CNTR_NE_HEC_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE.t_Current.la_HEC_P_count[ABC0];
   CNTRMap[CNTR_NE_CD_Running] = (int16 *)(void *) &gt_g997_AtmPerf_CD_Running_NE.la_CD_P_count[ABC0];
   CNTRMap[CNTR_NE_CD_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE.t_Current.la_CD_P_count[ABC0];
   CNTRMap[CNTR_NE_CU_Running] = (int16 *)(void *) &gt_g997_AtmPerf_CU_Running_NE.la_CU_P_count[ABC0];
   CNTRMap[CNTR_NE_CU_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE.t_Current.la_CU_P_count[ABC0];
   CNTRMap[CNTR_NE_IBE_Running] = (int16 *)(void *) &gt_g997_AtmPerf_IBE_Running_NE.la_IBE_P_count[ABC0];
   CNTRMap[CNTR_NE_IBE_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE.t_Current.la_IBE_P_count[ABC0];
   CNTRMap[CNTR_NE_TX_IDLE_CELL_Running] = (int16 *)(void *) &gt_g997_AtmPerf_ICELL_Running_NE.la_ICELL_P_count[ABC0];
   CNTRMap[CNTR_NE_TX_NON_IDLE_CELL_Running] = (int16 *)(void *) &gt_g997_AtmPerf_UCELL_Running_NE.la_UCELL_P_count[ABC0];
   CNTRMap[CNTR_FE_HEC_Running] = (int16 *)(void *) &gt_g997_AtmPerf_HEC_Running_FE.la_HEC_PFE_count[ABC0];
   CNTRMap[CNTR_FE_HEC_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE.t_Current.la_HEC_PFE_count[ABC0];
   CNTRMap[CNTR_FE_CD_Running] = (int16 *)(void *) &gt_g997_AtmPerf_CD_Running_FE.la_CD_PFE_count[ABC0];
   CNTRMap[CNTR_FE_CD_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE.t_Current.la_CD_PFE_count[ABC0];
   CNTRMap[CNTR_FE_CU_Running] = (int16 *)(void *) &gt_g997_AtmPerf_CU_Running_FE.la_CU_PFE_count[ABC0];
   CNTRMap[CNTR_FE_CU_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE.t_Current.la_CU_PFE_count[ABC0];
   CNTRMap[CNTR_FE_IBE_Running] = (int16 *)(void *) &gt_g997_AtmPerf_IBE_Running_FE.la_IBE_PFE_count[ABC0];
   CNTRMap[CNTR_FE_IBE_TR1_Curr_Prev] = (int16 *)(void *) &gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE.t_Current.la_IBE_PFE_count[ABC0];

   CNTRMap[CNTR_NE_CRC_NonInhibit] = (int16 *)(void *) gusa_NonInhibit_CRC_Cntr_NE;
   CNTRMap[CNTR_NE_FEC_NonInhibit] = (int16 *)(void *) gusa_NonInhibit_FEC_Cntr_NE;

//PTM counters
   CNTRMap[CNTR_NE_PTM_BC0] =(int16 *)(void *)&gt_g997_PtmPerf_NE[BC0];
   CNTRMap[CNTR_FE_PTM_BC0] =(int16 *)(void *)&gt_g997_PtmPerf_FE[BC0];
   CNTRMap[CNTR_FE_PTM_BC1] =(int16 *)(void *)&gt_g997_PtmPerf_FE[BC1];
   CNTRMap[CNTR_NE_PTM_BC1] =(int16 *)(void *)&gt_g997_PtmPerf_NE[BC1];

//ATM counters
   CNTRMap[CNTR_NE_ATM_BC0] =(int16 *)(void *)&gt_g997_AtmPerf_NE[ABC0];
   CNTRMap[CNTR_NE_ATM_BC1] =(int16 *)(void *)&gt_g997_AtmPerf_NE[ABC1];
   CNTRMap[CNTR_FE_ATM_BC0] =(int16 *)(void *)&gt_g997_AtmPerf_FE[ABC0];
   CNTRMap[CNTR_FE_ATM_BC1] =(int16 *)(void *)&gt_g997_AtmPerf_FE[ABC1];

//TX cell counter
   CNTRMap[CNTR_NE_TX_CELLS_BC0] = (int16 *)(void *)&gt_g997_AtmPerf_TX_UICELL[ABC0];
   CNTRMap[CNTR_NE_TX_CELLS_BC1] = (int16 *)(void *)&gt_g997_AtmPerf_TX_UICELL[ABC1];

   //L2_Back_Channel
   CNTRMap[CNTR_DSM_STATS_GET] = (int16 *)(void *)&gt_DsmStats;

   CNTRMap[CNTR_NE_SEF_Defect_Count] = (int16 *)(void *)&gul_NeSefDefectCounter;
   CNTRMap[CNTR_FE_SEF_Defect_Count] = (int16 *)(void *)&gul_FeSefDefectCounter;


   CNTRMap[CNTR_RETX_OVHD_COUNTER] = (int16 *)(void *)&gt_ReTXStats.ul_ErrorFreeBits;
   //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
   //XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode (Start_End)
   CNTRMap[CNTR_RETX_DTU_STATS] = (int16 *)(void *)&gt_ReTXStats.ul_RetransmittedDtuCntFE;

   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   //VR9, this value came from bedford Lantiq office implementation, Zephyr need to wail
   //for 2048 symbols to pull 120k bit amount data from the TX_CB in PTM mode.
   gus_Zep_Tx_DelayCnt = 2048; //default value
   CNTRMap[CNTR_PRE_FAIL_STATE_WAIT_COUNT] = (int16*)(void *)&gus_Zep_Tx_DelayCnt;
   CNTRMap[CNTR_NO_OF_SYM_IN_PRE_FAIL_STATE] = (int16*)(void *)&gus_LinkDownState_SymCount;
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
   CNTRMap[CNTR_US_RETX_DTU_STATUS_COUNTERS] = (int16*)(void *)&gt_g997_ReTx_FE_MgmtCnt;
   CNTRMap[CNTR_US_RETX_PERF_CNT_STATS] = (int16*)(void *)&gt_g997_ReTx_FE_MgmtCnt.ul_Error_Freebits_cnt;
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

   // XDSLRTFW-3359 (Start_End)
   CNTRMap[CNTR_US_SRA_REJECT] = (int16*)(void *)&gt_US_SRA_Stats;

   // XDSLRTFW-3367 (Start_End)
   CNTRMap[CNTR_DS_SRA_REJECT] = (int16 *)(void *)&gt_DS_OLR_Reject_t;

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B

   CNTRMap[CNTR_CASCADE_MODE_35B_ST_MIPS] = (int16*)(void *)&gt_CasFwTasksMipsCnt;
   CNTRMap[CNTR_CASCADE_MODE_35B_TC_NTC_MIPS] = (int16*)(void *)&gt_CascadeTcNtcMaxMipsCnt;
#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)
   /*========================================================================*/
   // Init PLAM CMV
   /*========================================================================*/
   //G997.1 Failure State mapping
   PLAMMap[PLAM_NearEndFailureFlags] = (int16*)(void *)&gsa_g997_Failure_Flag_NE[0];
   PLAMMap[PLAM_FarEndFailureFlags] = (int16*)(void *)&gs_g997_Failure_Flag_FE;
   PLAMMap[PLAM_TR1AlarmIndicators] = (int16 *)(void *)&gt_G997_TR1AlarmIndicators;
   PLAMMap[PLAM_DataPathFailures] = (int16 *)(void *)(&gt_DataPathFailures); // XDSLRTFW-1479 (Start_End)

   /*========================================================================*/
   // Init Modem Monitor
   /*========================================================================*/
   MONIMap[MONI_MODEM_STAT] = (int16 *)(void *)&gusa_MONI_ModemStat;
   MONIMap[MONI_LINE_FAILURES_NE] = &gs_MONI_LineFailure_NE;
   MONIMap[MONI_LINE_FAILURES_FE] = &gs_MONI_LineFailure_FE;
   MONIMap[MONI_AUTO_RESTART] = &gs_MONI_AutoRestart;
   MONIMap[MONI_SHOW_FAILURES_NE] = (int16*)(void *)&gsa_MONI_ShowFailure_NE;
   MONIMap[MONI_SHOW_FAILURES_FE] = &gs_MONI_ShowFailure_FE;
   MONIMap[MONI_TR1_ALARMENABLE] = (int16 *)(void *)&gt_G997_MONI_TR1AlarmEnable;
   MONIMap[MONI_FEREADTRIGGER] = (int16 *)(void *)&gt_MONI_FEReadTrigger; // For triggering FE data retrieval
   MONIMap[MONI_CLEAREOC_TRIGGER_CONTROL] = (int16 *)&gt_MONI_CEocTrigger;
   MONIMap[MONI_CLEAREOC_AUTOMSG_CONTROL] = (int16 *)&gt_MONI_CEocAutoMsgCtrl;
   MONIMap[MONI_CLEAREOC_STATUS] = (int16 *)(void *)&gt_MONI_CEocStat;
   MONIMap[MONI_CORRUPTCRC_CONTROL] = (int16 *)&gt_MONI_CrptCRCCtrl;
   MONIMap[MONI_CORRUPTCRC_STATUS] = (int16 *)&gt_MONI_CrptCRCStat;
   MONIMap[MONI_SETANDREADTIME_CONTROL] = (int16 *)&gt_MONI_TimeSyncCtrl;

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   MONIMap[MONI_USShowtimeEvents_Mask] = (int16 *)(void *)&gs_MONI_US_OLREventMask;
   MONIMap[MONI_DSShowtimeEvents_Mask] = (int16 *)(void *)&gs_MONI_DS_OLREventMask;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]

   //L2_Back_Channel
   MONIMap[MONI_EVT_DSM_ERRORVECTORREADY] = (int16 *)(void *)&gt_MONI_ErbMsg;

   // XDSLRTFW-3647 (Start)
   memset(&gusa_MONI_ModemStat, 0, sizeof(gusa_MONI_ModemStat));
   // XDSLRTFW-3647 (End)

   gs_MONI_LineFailure_NE = 0;
   gs_MONI_LineFailure_FE = 0;
   gs_MONI_AutoRestart = 0;
   gsa_MONI_ShowFailure_NE[0] = 0;
   gsa_MONI_ShowFailure_NE[1] = 0;
   gs_MONI_ShowFailure_FE = 0;

   // XDSLRTFW-650 / XDSLRTFW-1384 (Start)
   guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
   gft_EnterL3State = FALSE;
// XDSLRTFW-3773 (Start)
// Note: FW should always use the default API configuration. Reason is, that it is not known,
//       if a customer is writing the message. In such a case the FW would enabled not wanted test features.
//       API writes TESTArray[TEST_Control3] = TEST_EnableImprovedATTNDR;!
//       When this test feature is needed, it has to be set after API cmv was latched!
//   TESTArray[TEST_Control3] |= TEST_DisableL3Mode;
   // XDSLRTFW-650 / XDSLRTFW-1384 (End)
   // Disabling the Bitloading on the G.Hs tones in Vectoring(Start_End)
//   TESTArray[TEST_Control3] |= TEST_EnableGHSToneMaskOutVectoring;
   // XDSLRTFW-2368 (Start)
//   TESTArray[TEST_Control3] |= (TEST_GHS_Fix);
// XDSLRTFW-3773 (End)

   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
   TESTArray[TEST_Control3] |= TEST_EnableImprovedATTNDR;
   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

   //L2_Back_Channel
   gs_MONI_US_OLREventMask = 0;
   gs_MONI_DS_OLREventMask = 0;

   gft_ReInitTrigger = 0; //ReInit Trigger set to 0, on failure will set to 1 from MomdemMonitor
   /*========================================================================*/
   /* initialize TEST CMVs*/
   /*========================================================================*/

   TESTArray[TEST_RxTestPilotTone] = PILOT_TONE;
   TESTArray[TEST_MaxNumHybrSettings] = NUM_ADAP_HYB_SETTINGS;

   TESTArray[TEST_RxBetaLength] = -1;
   TESTArray[TEST_RxCPLength] = -1;
   TESTArray[TEST_RxCSLength] = -1;
   TESTArray[TEST_TxBetaLength] = -1;
   TESTArray[TEST_TxCPLength] = -1;
   TESTArray[TEST_TxCSLength] = -1;
   TESTArray[TEST_SetHybrid_Index] = -1; // XDSLRTFW-3897(Start_End), Default - No hybrid selection is forced by user, FW will select

   TESTArray[TEST_ChangeVendorID] = 0;
   guc_OffChipRequestHandle = CODESWAP_NO_ACTION;
   //Enable saving Periodic1 SNR, Medley SNR and Discovery phase SNR and PSD in SRAM by default
   TESTArray[TEST_StoreSramControl] = (TEST_SAVE_PERIODIC1_SNR_ENABLE|TEST_SAVE_MEDLEY_SNR_ENABLE|TEST_SAVE_DISC_EchoOn_PSD_ENABLE|TEST_SAVE_DISC_SNR_ENABLE|TEST_SAVE_DISC_EchoOff_PSD_ENABLE);

   TESTArray[TEST_TCNOSYNC] = 0; //XDSLRTFW-2050

   // XDSLRTFW-1181: XDSLRTFW-1500: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/Stop)
   // Initialize CMV Test 41 (Default value)
   TESTArray[TEST_XDSLRTFW_CONFIG] = (int16)(TEST_XDSLRTFW_CONFIG_SKIP_PLL_O_TA_Update | TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_Periodic2 |
                                     TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_Pilot3 | TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_TEQ |
                                     TEST_XDSLRTFW_CONFIG_VEC_HYBRID_ECHO | TEST_XDSLRTFW_CONFIG_VEC_HYBRID |
                                     TEST_XDSLRTFW_CONFIG_XTALK_CONNECT |
                                     TEST_XDSLRTFW_CONFIG_FLOS);

   TESTArray[TEST_HP2_CONFIG] = (TEST_HP2_CONFIG_DC_TO_ZERO | TEST_HP2_CONFIG_USE_SNR_HYB_FOR_US0); //OPEN_VRX518AFE  Check

   // Performance test is  NOT  done against  all CO's.
   // This cmv  bit  is controlling the Tx TSSI shaping
   // if  enable,then we send out correct TxOOB signal on the line for oPOTS band,
   // if disabled,then we  send out Tx OOB signal in oPOTS band but it is wrong

   TESTArray[TEST_JIRA2257_CONFIG] = TEST_ENABLE_TXTSSI_SHAPE;   //XDSLRTFW_232(Start_End)
   TESTArray[TEST_35B_CONTROL] = 0;

#ifdef GHS_TN_DBG
   TESTArray[TEST_GHS_LOG] = (TEST_GHS_AVG_FULL_BAND); //XDSLRTFW-2288 (Start_End)
#endif
   TESTArray[TEST_CMVCTRL_LINKDROP] = 0;  // XDSLRTFW-1535 CMV_Controlled_Link_Drop(start-end)
   TESTArray[TEST_DS_RETX_HRT] = 0;       // XDSLRTFW-2858
   // Allowed values could be ACE_52p5F(0) ACE_30pF(1) ACE_15pF(2) ACE_7p5F (3) ACE_OFF (4)
   TESTArray[TEST_DS_ACE] = (TEST_DS_PREFI_CAP_DIS|ACE_MODE_MASK);

   // XDSLRTFW-3677(Start_End)
   TESTArray[TEST_CO_ERR_CONF_CONTROL] = TEST_OVER_WRITE_MAXETR_WITHMAXNDR;
   /*========================================================================*/
   /* initialize DSL CMVs */
   /*========================================================================*/

   // defined VDSL_62
   DSL_4_Map[0] =  (int16*)(void *)&gt_AFEConfig;  //XDSLRTFW-3705 (Start_End)

   //XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (Start_End)
   //Enable AELEM feature by default
   //XDSLRTFW-439: Feature_All1_DS_All2_All3_SupportDsTxRefVirtualNoise (Start)
   //Default: Downstream & upstream virtual noise feature are disabled.
   //XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg (Start_End)
   gus_FeaturesControl |= DSL_EnableAELEM;

   DSLMap[DSL_FeaturesControl] =(int16*)(void *) &gus_FeaturesControl;      // DSL_0
   //XDSLRTFW-439: Feature_All1_DS_All2_All3_SupportDsTxRefVirtualNoise (End)
   DSLMap[DSL_AlgControl4] = &gs_DSL_AlgControl4;                           // DSL_2
   DSLMap[DSL_DS_PILOT_INDEX]    =  (int16*)(void *)&gt_PilotConfig.s_NumPilotTones; // DSL_3: skipping the padding long word, hence starting at s_NumPilotTones
   DSLMap[DSL_LPR_TRIGGER]       =  (int16*)(void *)&gus_SetLPR;            // DSL_5
   DSLMap[DSL_HYBRID_TYPE]       =  (int16*)(void *)&gus_HybridType;        // DSL_9
   DSLMap[DSL_LD_MODE]           =  (int16*)(void *)&gus_LD_Mode;           // DSL_10
   DSLMap[DSL_AFE_CHIPID]        =  (int16*)(void *)&gusa_AfeChipId[0];     // DSL_11
   DSLMap[DSL_BONDING_CONTINUE]  =  (int16*)(void *)&gt_Bonding_Continue;   // DSL_12
   DSLMap[DSL_OPTIONS]           =  (int16*)(void *)&gus_ApiOptions;        // DSL_13
   DSLMap[DSL_TC_STATUS]         =  (int16*)(void *)&gus_DSL_TC_Status;     // DSL_14:  //CMD_TC_StatusGet / DSL_TC_STATUS / DSL 14
   DSLMap[DSL_PPE_CLOCK_CONTROL] =  (int16*)(void *)&gus_PpeClockControl;   // DSL_15:

   //DSLMap[DSL_ADSL_FEATURE_MAP]  =  (int16*)(void *)&gt_AdslFeatureMap;   // DSL_19: XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
   DSLMap[DSL_VDSL_FEATURE_MAP]  =  (int16*)(void *)&gt_VdslFeatureMap;     // DSL_20: XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
   DSLMap[DSL_OPERATOR_SELECT]   =  (int16*)&gt_Dsl_Operator_Select;        // DSL_21: XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)

   DSLMap[DSL_TC_MODE_USED]      =  (int16*)(void *)&gus_TcModeUsed_PPE;    // DSL_23: XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2

   //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START)
   //AFE initialization indication is enabled by default.
   gus_DSL_FW_InternalControl = DSL_VR9_VRX318_AFE_INIT_FAIL_ENABLE;
   gus_DSL_FW_InternalControl |= DSL_ERASE_SRAM_VARS;
   DSLMap[DSL_FW_InternalControl] = (int16*)(void *)&gus_DSL_FW_InternalControl;       // DSL_24:
   //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (END)

   //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
   gs_InitFreqOffsetDelta = 0;
   DSLMap[DSL_CRYSTAL_OFFSET] = (int16 *)&gs_InitFreqOffsetDelta;                      // DSL_25
   //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]

#ifdef DEBUG_TRACES
   //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //Debug Buffer CMV initialization
   DSLMap[DSL_DEBUGBUFF_STATUS] = (int16 *)(void *)&gt_DebugBufferStatus;              // DSL_26
   DSLMap[DSL_DEBUGBUFF_GHS_TO_EXCHANGE] = (int16*)(void *)&guca_offChipDebugBuff[0];  // DSL_27
   DSLMap[DSL_DEBUGBUF_SHOWTIME] = (int16*)(void *)&guca_offChipDebugBuff[SDRAM_RAW_DUMP_SHOWTIME_START_INDEX];  // DSL_28
   DSLMap[DSL_DEBUGBUF_CONTROL_SHOWTIME] = (int16 *)(void *)&gt_DebugBuffControl;      // DSL_29
   //XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
   //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif //   #ifdef DEBUG_TRACES

   DSLMap[DSL_CONFIG_REINIT_THRESH] = (int16*)(void *)&gt_ReInit_Threshold;         // DSL_30: XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   DSLMap[DSL_HNSK_CONTROL_INFO] = (int16 *)(void *)&gt_hsc;                        // DSL_31: XDSLRTFW-360 Enh_All_All_All_GetHandshakeControlInfo (Start_End)
   // XDSLRTFW-3565 (Start_End)
   // XDSLRTFW-3711 (Start_End)
   DSLMap[DSL_PPE_CLOCK_CONFIGURE] = (int16 *)(void *)&gus_PPEClockConfigure;

   DSLMap[DSL_PPA_FW_VERSION] = (int16 *)(void *)&gusa_PPA_FW[0];                   // DSL_35:  XDSLRTFW-3662 (Start)
   DSLMap[DSL_PPE_FW_VERSION] = (int16 *)(void *)&gusa_PPE_FW[0];                   // DSL_36:  XDSLRTFW-3662 (Start)

   // XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
   // - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
   // - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
   DSLMap[DSL_PREV_FAILSTATE]        = (int16 *)(void *)&gt_FailStateInfo_Prev;     // DSL_37: XDSLRTFW-3665
   DSLMap[DSL_PREV_EXCEPTION_CODES]  = (int16 *)(void *)&gula_FailStateHistory[0];  // DSL_38: XDSLRTFW-3665

   DSLMap[DSL_DBG_ALLOWED_TONE_INFO] = (int16 *)(void *)&gt_DbgAllowedToneInfo;     // DSL_39


   gs_DsQRx = 0;
   gs_DsQTx = 0;
//XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start)
//For Debug
   guc_QRxFullCntr = 0; //XDSLRTFW-3182 (Start_End)
   guc_QRetxTableFullCntr = 0;
   //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start)
   gus_DropPktCntr = 0;
   gus_BufOverWriteCntr = 0;
   //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (End)

   //XDSLRTFW-1393 (Start)
#ifdef ENABLE_RETX_DS_DEBUG
   guc_ReTxDebugBufWrEnable = 1;
   gus_ReTxDebugBufIdx = 0;
   gpuca_ReTxDebugBuf = (uint8 *)guca_RetxDebugBuffer;
#endif
   //XDSLRTFW-1393 (End)

   //XDSLRTFW-1571 (Start)
#ifdef ENABLE_THREE_NEEDLE_TEST
   guc_StartThreeNeedle = 0;
   guc_ThreeNeedleBadDTUCount = 0;
   guc_ThreeNeedleCount = 0;
   guc_CountToNextNeedle = 0;
   gus_ThreeNeedleDurationCount = 0;
   gus_ThreeNeedleDuration = 100; //Duration between 2 'three needles' - In num of DTUs.
#endif
   //XDSLRTFW-1571 (End)
//XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (End)


   // XDSLRTFW-1553 (Start_End) Enable by default
   gft_IOP_UPBO_FEXT = 1;

   //Initialize debug variable
   gs_TxAfeFilter = 0;

   //XDSLRTFW-1887 (Start_End)
   TESTArray[TEST_FREEZE_CPE_TX] = 0;

   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
   gul_ATTNDR_max_delay_octets = 0;
   //XDSLRTFW-1522 (Start_End)
   gul_ATTNDR_M0_ChCapacityBased = 0;
   gus_RpOpt_Attndr = 0;
   gft_CalcAttndr = FALSE;
   gft_ATTNDR_FrameGenFail = FALSE;
   memset(&gt_DbgImprovedATTNDR, 0, sizeof(gt_DbgImprovedATTNDR));
   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

   // XDSLRTFW-1622(Start)
   gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt = 255;
   gt_RtxDbgCapture.us_ResetRoundTripDelay = 0;
   // XDSLRTFW-1622(End)

   //XDSLRTFW-1983
   gft_ATM_PTM_MisMatch_TTNet = 0;
   gus_VendorSpecific_Info = 0;
   //XDSLRTFW-1983
   //XDSLRTFW-3823 (start)
   gta_SNROffset.s_NoOfToneGroups = SNR_OFFSET_TONEGROUPS;
   gt_SNROffsetBitLoad[0].s_ToneGroupStartIdx = 0;
   gt_SNROffsetBitLoad[0].s_ToneGroupSNROffset  = 0;
   //gta_SNROffset.ta_SNROffset[0].s_ToneGroupStartIdx = 0;
   //gta_SNROffset.ta_SNROffset[0].s_ToneGroupSNROffset  = 0;

   for(i=0;i<(SNR_OFFSET_TONEGROUPS);i++)
   {
      gta_SNROffset.ta_SNROffset[i].s_ToneGroupStartIdx = RX_MAX_NUM_TONES;
      gta_SNROffset.ta_SNROffset[i].s_ToneGroupSNROffset  = 0;

      gt_SNROffsetBitLoad[i+1].s_ToneGroupStartIdx = RX_MAX_NUM_TONES;
      gt_SNROffsetBitLoad[i+1].s_ToneGroupSNROffset  = 0;
   }
   //XDSLRTFW-3823 (end)
}
