/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   DetectInterrupts.c
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// DetectInterrupts.c
//
// History
//
// 12/06/2015 Kannan: Implemented Cascaded FW scheduling for 35b lite project to modify FFT output
//                    Grep for "XDSLRTFW-2392 Cascaded scheduling"
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "cri_iof.h"


#ifdef DEBUG_FLOW_TEST
extern uint32 gul_dbg_flowtest;
#endif
extern uint32 gul_RxTimer_RxQTDone;
extern uint32 gul_RxTimer_TxQTDone;
extern uint32 gul_TxTimer_TxQTDone;


int16 gs_InterruptSource;


extern uint16 gus_MaxWaitCnt_QtDone;
extern int16  gs_MaxWaitState_QtDone;
extern int16 gs_dbg_MAX_RX_LOOP_COUNT;
extern FlagT gft_SkipFirstRxTimerDoneInt;
extern int32 gl_RxSymCnt_MaxWaitState_QtDone;
extern uint16 gus_MaxWaitCnt_TxQtDone;
extern int16  gs_MaxWaitState_TxQtDone;
extern int32  gl_TxSymCnt_MaxWaitState_TxQtDone;

int16 DetectInterrupts(void)
{
   //XDSLRTFW-2392 (Cascaded scheduling - Start)
   uint32 ul_CriEvent;
   uint32 ul_IntSrc = 0;
   uint32 ul_TxIntMask, ul_RxIntMask;
   int16 s_interrupt = -1;

   gs_InterruptSource = 0;
   /************************************************/
   /* Read CRI to get interrupt status            */
   /************************************************/

   ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);

   if (guc_Start_CasMode_Int)
   {
      //Take interrupts which are enabled in Tx & Rx Int Mask registers
      ReadCoreReg(CRI_MASK0_TX_ADDR, &ul_TxIntMask);
      ReadCoreReg(CRI_MASK0_RX_ADDR, &ul_RxIntMask);

      ul_CriEvent = (ul_CriEvent & (ul_TxIntMask | ul_RxIntMask));
      //XDSLRTFW-3670, XDSLRTFW-3660 (Start)

      if ((ul_CriEvent & CRI_MASK_RX_CRI_TIMER) && (gft_SkipFirstRxTimerDoneInt == FALSE))
      {
        gft_SkipFirstRxTimerDoneInt = TRUE;
        ul_IntSrc = CRI_MASK_RX_CRI_TIMER;
        WriteCoreReg(CRI_EVENT_ADDR, ul_IntSrc);
        WriteCoreReg(CRI_STATUS0_ADDR, ul_IntSrc);
        return (s_interrupt);
      }

      if (ul_CriEvent & CRI_MASK_RX_CRI_TIMER)
      {
         //Wait for Rx QT processing completion
         uint32 i = 0;
         do {
            i = i+ 1;
            ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);
         } while (((ul_CriEvent & CRI_MASK_RX_QT_DONE) == 0) && (i <= gs_dbg_MAX_RX_LOOP_COUNT)); // XDSLRTFW-3229 (Start_End)

         if (i > gus_MaxWaitCnt_QtDone)
         {
            gus_MaxWaitCnt_QtDone = i;
            gs_MaxWaitState_QtDone = gs_RxState;
            gl_RxSymCnt_MaxWaitState_QtDone = gl_RxSymbolCount;
         }

         ul_IntSrc = CRI_MASK_RX_QT_DONE | CRI_MASK_RX_CRI_TIMER;
         //XDSLRTFW-3670, XDSLRTFW-3660 (End)
         s_interrupt = RX_QT_DONE; //Reusing the "RX_QT_DONE" macro even though RX TIMER INT is being used.
         //gul_dbg_RxQtDoneInt++;
         gs_InterruptSource |= (1 << RX_QT_DONE);
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x800;
#endif
         //Save Rx QT Done Timer Value
         ReadRxTimer((uint32 *)(void *)&gul_RxTimer_RxQTDone);

      } else if (ul_CriEvent & CRI_MASK_TX_CRI_TIMER)
      {

         //XDSLRTFW-3670, XDSLRTFW-3660 (Start)

         //Wait Till RT QT is not finished
         uint32 i = 0;
         do {
            i = i+ 1;
            ReadCoreReg(CRI_EVENT_ADDR, &ul_CriEvent);
         } while (((ul_CriEvent & CRI_MASK_TX_QT_DONE) == 0) && (i <= gs_dbg_MAX_RX_LOOP_COUNT)); // XDSLRTFW-3229 (Start_End)

         if (i > gus_MaxWaitCnt_TxQtDone)
         {
            gus_MaxWaitCnt_TxQtDone = i;
            gs_MaxWaitState_TxQtDone = gs_TxState;
            gl_TxSymCnt_MaxWaitState_TxQtDone = gl_TxSymbolCount;
         }

         ul_IntSrc = CRI_MASK_TX_QT_DONE | CRI_MASK_TX_CRI_TIMER;
         //XDSLRTFW-3670, XDSLRTFW-3660 (End)

         s_interrupt = TX_QT_DONE; //Reusing the "TX_QT_DONE" macro even though TX TIMER INT is being used.
         //gul_dbg_TxQtDoneInt++;
         gs_InterruptSource |= (1 << TX_QT_DONE);
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x1000;
#endif
         //Save Tx QT Done Timer Value
         ReadRxTimer((uint32 *)(void *)&gul_RxTimer_TxQTDone);
         ReadTxTimer((uint32 *)(void *)&gul_TxTimer_TxQTDone);
      }
#ifdef ENABLE_PMS_DONE_INT_FOR_PMS_CYCLE_MEASUREMENT  //XDSLRTFW-3322 (start_End)
      else if (ul_CriEvent & CRI_MASK_RX_PMS_DONE)
      {
         //Rx PMS done interrupt
         ul_IntSrc = CRI_MASK_RX_PMS_DONE;
         s_interrupt = TX_PARR_DONE;
         //gul_dbg_TxQtDoneInt++;
         gs_InterruptSource |= (1 << RX_FC_DONE);
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x4000;
#endif
         //Save Tx QT Done Timer Value
         ReadRxTimer((uint32 *)(void *)&gl_RxTimer_RxPMSDone);
         gl_RxTimer_RxPMSDone -= gl_RxTimer_RxPMSStart;
         if (gl_RxTimer_RxPMSDone < 0)
         gl_RxTimer_RxPMSDone += 72000;

         if (gl_RxTimer_RxPMSDone > gl_RxTimer_MaxRxPMSDone)
         {
            gl_RxTimer_MaxRxPMSDone = gl_RxTimer_RxPMSDone;
         }
      }
      else if (ul_CriEvent & CRI_MASK_TX_PMS_DONE)
      {
         //Rx PMS done interrupt
         ul_IntSrc = CRI_MASK_TX_PMS_DONE;
         s_interrupt = TX_PARR_DONE;
         //gul_dbg_TxQtDoneInt++;
         gs_InterruptSource |= (1 << TX_FC_DONE);
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x8000;
#endif
         //Save Tx QT Done Timer Value
         ReadTxTimer((uint32 *)(void *)&gl_TxTimer_TxPMSDone);
         gl_TxTimer_TxPMSDone -= gl_TxFcTimerCount;
         if (gl_TxTimer_TxPMSDone < 0)
         gl_TxTimer_TxPMSDone += 72000;

         if (gl_TxTimer_TxPMSDone > gl_TxTimer_MaxTxPMSDone)
         {
            gl_TxTimer_MaxTxPMSDone = gl_TxTimer_TxPMSDone;
         }
      }

#endif ////XDSLRTFW-3322 (start_End)
      //clear status & event register
      if (ul_IntSrc)
      {
         WriteCoreReg(CRI_EVENT_ADDR, ul_IntSrc);
         WriteCoreReg(CRI_STATUS0_ADDR, ul_IntSrc);
      }
   }    //XDSLRTFW-2392 (Cascaded scheduling - End)
   else
   {
      //Since we only enabled one interrupt, i.e., TSC_RX_INT,
      //we will only look for this interrupt and ignore all the others
      if(ul_CriEvent & CRI_MASK_RX_TSC_INT)
      {
         //By doing this, we can share some code with 5.0 build
         gs_InterruptSource = (1<<RX_QT_DONE);

         //Clear this interrupt

         WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_RX_TSC_INT);

      }
      else
      {
         gs_InterruptSource = 0;
      }
   }

   return((int16) (s_interrupt));  //XDSLRTFW-2392 (Cascaded scheduling - Start - End)
}
