/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*******************************************************************************
*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitGlobalVars.c
*
*   This file contains functions which initialize global variables at start-up.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// InitGlobalVars.c
//
// History
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 08/08/2012 Vinjam: Added a seprate buffer to hold SNR with out virtual noise for DELT mode
//                    It is valid for single port mode only (unbonded - 8a,12a,17a & 30a profiles)
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//                 Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
//
// 07/11/2012 Kannan: Read hybrid type from the port mode control structure offset 9 (bits b4 to b2)
//                    and set gus_HybridType accordingly. Port mode control structure will be
//                    initialized by the MEI driver.
//                    Grep for: "XDSLRTFW-542: Platform_VRX318"
//
// 03/12/2012 Vinjam: To save data memory in "Port-1", "gsa_RxWithOutVnSnrBuf[4096]" is converted
//                    to "gca_DELT_RxWithOutVnSnrBuf[2048]"
//                    Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 24/12/2012 Ram: Fix for JIRA 373. Initializing ReTx related variables during soft reset.
//                 Grep for XDSLRTFW-373: BugFix_DS_VDSL2_ALL_ReTx_Vars_Not_Init_At_SoftReset
//
// 01/02/2012 Kannan: PDBRAM handover and Orderly shutdown variable initialization.
//                 Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 15/02/2013 Vinjam : Memory Optimization. Re-used gsa_RxPathAtten_Tmp[] to store SNR with out virtual noise during LDM in channel Ananlysis phase.
//                gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(&gsa_RxPathAtten_Tmp[0]);
//                     Grep for XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization
//19/07/2013 Kannan: Enable/Disable UsReTx using variable
//Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//    Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//    - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//    - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1056: VDSL2 US ReTx Overhead message changes for US ReTx Receive"
//  reception of below things in  response  to  a  Single  Read  command  if US retransmission is enabled
//    -  ETR (RTX Receiver Expected Throughput)
//    - delay_act_RTX (RTX Receiver Actual Delay)
//       Modified the code so as to capture FE management counters in ReTx mode as below if US retransmission is enabled
//     - rtx-c(counter of corrected DTU)
//     - rtx-uc( counter of uncorrected DTU)
//     - Counter of ''leftr'' defect seconds
//     - Counter of error free bits
//     - EFTR_min
//    grep for XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt
//
// 19/09/2013 Abu: Initialize (Debug variable) to check if the upstream rate gets improved
//            Grep for XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate
// 19/09/2013 Fuss: Addded code for vectoring to use only two different hybrid settings.
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
// 10/10/2013 Fuss: Use "Pre-failstate" to pause FW for data-collection
//            Grep for XDSLRTFW-1218 Bugfix_ALL_VDSL2_ALL_DataCollect
//
// 30/10/2013 Anantha Ramu: Initialisation for variables involved with ATTNDR calculation
//                          Grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
//
// 18/12/2013 Kannan: Added test cmv TEST 28 0 0x2000 to enable 5 secs shine noise fix, it is enabled by default
//                    This is applicable if DS ReTx is ON in showtime.
//                    Grep for XDSLRTFW-1104
// 15/01/2014 Kannan: Added test cmv TEST 28 0 0x0800 to disable US ReTx & to indicate the extended ILV mem size
//                    for 30Mhz profiles. it is enabled by default
//                    This is applicable if 30Mhz, IFX CO's.
//                    Grep for XDSLRTFW-1495
// 16/01/2014 Abu: Ping pong buffers are introduced to maintain the US pilot sequence.
//            Tx Sync symbol in vectoring mode is always modulated from the Active
//            buffer (gpuca_UsPsActive) of the ping-pong buffers.
//            In training US Pilot sequence from the O-Signature is stored in Active buffer.
//            In showtime, if USPS change request comes with interruption of current USPS
//            is allowed command according to Table 8-9/G993.5 then the new USPS is directly
//            stored in Active buffer
//            If USPS change request comes with interruption of current USPS is not allowed
//            command then the new USPS is stored in in-active buffer (gpuca_UsPsInActive)
//            and swap the Active-InActive buffers in proper time according to Section 8.2/G993.5
//            Grep for XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS
// 11/08/2014 Fuss: R7 image (BT IOP bit set) has lower perf in US compared to VR9FB
//            Grep for XDSLRTFW-1841
//
// 24/09/2015 Vinay: Initialised the variable for G.Fast capability in G.Hs session.
//                   Grep for XDSLRTFW-2298
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//    The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//    The internal split is not well-balanced for the wished service rates.
//    According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//    According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//    framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//    D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//    1-symbol reduction in Qtx,min calculation:
//    It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//    the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//    occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it's not needed to take into account the
//    +1 symbol in the Qtx,min calculation.
//    If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//    For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//    the left triangle part.
//    If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//    is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//    shown in the drawings before the triangle.
//    So from the figures it could be derived:
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//    But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//
// 22/11/2017 Abu Rahman
//            XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)
//            Introduced a CMV based option to select Method_0 framing based DS ATTNDR or
//            channel capacity based DS ATTNDR calculation algorithm.
//                Set CNFG 86 3 = 0 : to select frame based Method_0 ATTNDR algorithm or
//                Set CNFG 86 3 = 1 : to select channel capacity based Method_0 ATTNDR algorithm (VR9-R7 like)
//            Note that this switching works only with Method_0 configuration
//            SEARCH PATTERN: XDSLRTFW-3556
//
// 24/09/2019 Chih-Wen
//            Bug fix for several issues related to V43 and T1413 setup.
//            SEARCH PATTERN: XDSLRTFW-4227
//
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "cnfg_task.h"
#include "ToneReorder.h"
#include "vdsl_xception.h"
#include "TimingAdvanceHandler.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "afe.h"
#include "InitGlobalVars.h"
#include "vdsl_state.h"
#include "PsdHandler.h"
#include "cmv_data.h"
#include "cmv.h"
#include "Bitload.h"
#include "g997.h"
#include "InitShowTimeRx.h"
#include "InitShowTimeTx.h"
#include "eoc.h"
#include "profile.h"
#include "LL_IOf.h"
#include "IRI_Ini.h"
#include "showtime.h"
#include "CheckForUS0Enable.h"
#include "dsp_regs_62.h"
#include "AFED_Data.h"
#include "ZPH_Ini.h"

uint8 gft_InitDebugTrailsOnReset = 1;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
//Added a buffer to store SNR with out virtual noise in DELT mode
//Valid for single port mode only (12a, 17a & 30a Profiles only - in unbonded mode)
//Valid for 8a profile in "unbonded" mode
//SNR in 8.8 format is converted to 7.1 format to same physical memory
//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start)
extern int8 *gpca_DELT_RxWithOutVnSnrBuf;
//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (End)

extern FlagT gft_NotFirstDTU;
extern ReTX_Params_t gt_ReTXParams;

extern int32 gl_Test_Persistmem_Vdsl;
extern int32 gl_Test_Persistmem_Common;

void SetupDefaultIlvDilv(void);
void SetupDefaultDTB(void);

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InitGlobalVars_PreHandshake(void)
*
*  This function initializes all global variables at start-up.
*  This function is executed everytime at modem restart.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void InitGlobalVars_PreHandshake(void)
{
   int16 i;
   int16 s_numDOPenabled=0;

#ifdef LOG_PILOT_CONSTELLATION
   gft_StartPilotLog = 0;
#endif
   // XDSLRTFW-441 (START)
   int32 *lp_PersistMemPtr = &gl_Test_Persistmem_Vdsl;

   if (gl_Test_Persistmem_Vdsl != 0x12345678)
   {
      memset(lp_PersistMemPtr, 0, 64);
      gl_Test_Persistmem_Vdsl = 0x12345678;
   }

   lp_PersistMemPtr = &gl_Test_Persistmem_Common;

   if (gl_Test_Persistmem_Common != 0x12345678)
   {
      memset(lp_PersistMemPtr, 0, 32);
      gl_Test_Persistmem_Common = 0x12345678;
   }
   // XDSLRTFW-441 (END)
   // clear common memory block
   memset(gsa_CommonMemoryBlock0, 0, sizeof(int16)*COMMON_MEM_BLOCK_SIZE);

   //XDSLRTFW-2364 (start)
   //XDSLRTFW-2184
   // Initialize US-HLOG/QLN/SNR tables in external SDRAM
   // HLOG - special value: 0x3FF (2^10-1)
   // QLN - special value: 255
   // SNR - special value: 255
   // XDSLRTFW-2774 (Start)
   for (i=0; i<512; i++)
   {
      gt_FEParams.us_Hlog[i] = 0x03FF;
   gt_FEParams.uc_Qln[i] = 0xFF;
   gt_FEParams.uc_Snr[i] = 0xFF;
   }
   // XDSLRTFW-2774 (End)

   //overlay with BAR15 SDRAM space
#ifdef GHS_TN_DBG
   gpla_RxTone_Buffer = (int32 *)(void *)gsa_MedleySnrBuf;
#endif
   //XDSLRTFW-2364 (end)

   //XDSLRTFW-1784 (Showtime Margin Equalization - START)
   //Clear Rxfine gain & per tone margin buffer available in the external memory
   //this is required mainly for debug
   //XDSLRTFW-1784 (Showtime Margin Equalization - END)
   //The following code is needed for the bitload software test
#ifdef SW_BITLOAD_TEST
   //Default to use 4096 tones for both US and DS
   gs_TxLog2IfftLength = US_LOG2_FFT_LENGTH_8192;
   gs_RxLog2FftLength  = DS_LOG2_FFT_LENGTH_8192;
   gs_m = 5;            // The mandatory "m" value for VDSL2
   gs_FeModemLog2IfftSize = gs_RxLog2FftLength;

   // Mei: this intialization is unnecessary for the HW test (at least for IFX)
   // However, for some unknown reason, if we do not call this function here,
   //we see the CRC error in vdsl2_lpbk2_cpeshow.bat (but not other COCOMO tests)
   //This call is also needed for some SW test (such as bitload)
   ConfigDfeParam();
#endif //#ifdef SW_BITLOAD_TEST

   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   guc_8khz_count = 0;
   gus_LinkDownState_SymCount = 0;
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
   // XDSLRTFW-1218 Bugfix_ALL_VDSL2_ALL_DataCollect (Start / End)
   gft_LinkDownState_Cntrl = 0;

   // initialize this to be not set
   gus_SetLPR = 0;

   gus_ZEP_RxPMSNotDone = 0;
   gus_ZEP_TxPMSNotDone  = 0;
   // Initialize for 4 kHz GHS.
   gs_frame_rate_is_8khz = 0;

   //Enable the accurate frame rate calculation
   //(the inaccurate frame rate calculation does not count for the synch frame inserton)
   gft_AccurateFrameRateEnable = TRUE;

   gft_IfxAtmPtmFix = FALSE;
   gft_computeDataRateFS6 = FALSE;

   gft_SNRM_MODE_workaround = FALSE;
   gft_OldVNPsdFormat = FALSE;

   gs_TxGain = TX_POW_LEVEL;           //Used by GenerateSynSymLookUpData to set the signal level
   gsa_TxSingleToneBuf[0] = TX_NEG165DBM; //Used by LoadSingleToneToIfftBuf to set the signal level
   gsa_TxSingleToneBuf[1] = TX_NEG165DBM; //Used by LoadSingleToneToIfftBuf to set the signal level

   // Enable Rx frequency domain data read
   gft_EnableRxTimeDomainRead = FALSE;

   /* =========================================================================================*/
   /* Set TC Task control flags                                               */
   /* =========================================================================================*/
   gft_SkipTCTasks = FALSE;
   gft_IFFT_On = TRUE;
   gft_TxDataPump_On = 0;
   gft_DeRotateMedleyPilot = 0;
   gft_EnablePLL     = 0;
   gft_PrevPLLState = 0;
   gft_EnableGetRxTones = 0;
   gft_PrintRxTones     = 1;
   gft_RxMedleyTransition = 0;

   /* =========================================================================================*/
   /* Init Num of Tone selections                                                */
   /* =========================================================================================*/
   gs_NumFrameAlignClusters = (int16)(1 << LOG2_NUM_TONE_CLUSTERS_FRAME_ALIGN);
   gs_NumOfToneClustersForMsgDecode = NUM_TONE_CLUSTERS_FOR_MSG_DECODING;
   gs_RxNumChannelsForMsgDecode = gs_NumOfToneClustersForMsgDecode*NUM_CHANNELS_PER_CLUSTER;

   gs_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_512;
   gs_NumChannelsPerGroupSave = NUM_CHANNELS_PER_GROUP_512;
   gs_NumChannelsDetect = 64;

   //=======================================================================
   //Init GHS variables
   //=======================================================================
   //Disable loading GHS tone bit, and register start IFFT bit
   gs_LoadGhsToneFlag = 0;


   //============= VDSL2 ===================================
   // Initialize GHS capability list

   // gul_OperationModeCapable_VDSL2 bits[7:0]   - standard info NPar2 octet 1 for VDSL2
   // gul_OperationModeCapable_VDSL2 bits[15:8]  - standard info SPar2 octet 1 for VDSL2
   // gul_OperationModeCapable_VDSL2 bits[23:16] - standard info SPar2 octet 2 for VDSL2
   // gul_OperationModeCapable_VDSL2 bits[31:24] - standard info NPar2 octet 2 for VDSL2

   gul_OperationModeCapable_VDSL2 = (V2_DFT_SIZE << 8) |
                                    ((0) << 8) |
                                    ((V2_LINEPROBE) & 0xF);

   // Initialize the operation mode and prefered mode to be as the same as the capability
   gul_OperationModeStatus_VDSL2 = gul_OperationModeCapable_VDSL2;

   // XDSLRTFW-2298 (Start_End)
   // =========== G.Fast ========================
   // Initialize GHS capability list
   // gul_OperationModeCapable_G_Fast bits[7:0]   - standard info NPar2 octet 1 for VDSL2
   // gul_OperationModeCapable_G_Fast bits[15:8]  - standard info SPar2 octet 1 for VDSL2
   // gul_OperationModeCapable_G_Fast bits[23:16] - standard info SPar2 octet 2 for VDSL2
   // gul_OperationModeCapable_G_Fast bits[31:24] - standard info SPar2 octet 3 for VDSL2
   gul_OperationModeCapable_G_Fast = (G_Fast_Default_CE_Length | G_Fast_Default_Symbol_Periods_TDD_Frame ) |
                                     ((G_Fast_Profiles | G_Fast_Duration_Channel_Discovery ) << 8) |
                                     ((G_Fast_Symbol_Period_TDD_Frame) << 16);

   //=========================================================================
   // Initialize VDSL band variables
   //=========================================================================

   gs_NumOfTxBands = 0;
   gs_TxNumTonesUsed = 0;
   memset(gsa_TxBandLeftChannel, 0, sizeof(int16)*MAX_NUM_TX_BANDS);
   memset(gsa_TxBandRightChannel, 0, sizeof(int16)*MAX_NUM_TX_BANDS);

   gs_NumOfRxBands = 0;
   gs_RxNumTonesUsed = 0;
   memset(gsa_RxBandLeftChannel, 0, sizeof(int16)*MAX_NUM_RX_BANDS);
   memset(gsa_RxBandRightChannel, 0, sizeof(int16)*MAX_NUM_RX_BANDS);

   memset(&gt_TxBandControl_Act, 0, sizeof(BandDescriptorTable_t));
   memset(&gt_RxBandControl_Act, 0, sizeof(BandDescriptorTable_t));
   memset(&gt_RFIBandControl_Act, 0, sizeof(RFIBandDescriptorTable_t));

   gs_NumOfRFIBands = 0;
   memset(gsa_RFIBandLeftChannel, 0, sizeof(int16)*MAX_NUM_RFI_BANDS);
   memset(gsa_RFIBandRightChannel, 0, sizeof(int16)*MAX_NUM_RFI_BANDS);

   memset(&gt_ChannelMeasurement_FE, 0, sizeof(ChannelMeasurement_t));
   memset(&gt_ChannelMeasurement_NE, 0, sizeof(ChannelMeasurement_t));

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
   //Initialize Virtual Noise Structure
   memset(&gt_DS_RefVirtNoiseLevel_VDSL2, 0, sizeof(DsVnPSDDescriptorTable_t));
   //Added a buffer to store SNR with out virtual noise in DELT mode
   //Valid for single port mode only (12a, 17a & 30a Profiles only - in unbonded mode)
   //Valid for 8a profile in "unbonded" mode
   //SNR in 8.8 format is converted to 7.1 format to same physical memory
   //XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start)
   //Initialization of memory will be done during channel analysis phase
   //memset(gca_DELT_RxWithOutVnSnrBuf, 0, sizeof(int8) * 4096);
   gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(void *)(&gsa_ELE_Tmp[0]);  //Just pointer initialization, will be used only from Channel Analysis phase onwards
   //XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (End)
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   // @TODO: mahesh: need to debug later why this fails NVLT-G bitswap
   gul_AutoSRALmin = 8;
   gul_AutoSRALmax = 105000;

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
   //=========================================================================
   // Clear average LATN, SATN and SNR margin per band
   //=========================================================================
   gt_AttenSnrMPerRxBand.us_NumberOfBands = 0;
   for(i=0; i<MAX_NUM_RX_BANDS; i++)
   {
      gt_AttenSnrMPerRxBand.t_AttenSnrM[i].s_LATN = OUT_OF_RANGE_LATN;
      gt_AttenSnrMPerRxBand.t_AttenSnrM[i].s_SATN = OUT_OF_RANGE_SATN;
      gt_AttenSnrMPerRxBand.t_AttenSnrM[i].s_SNRM = OUT_OF_RANGE_SNRM;
   }

   gt_AttenSnrMPerRxBand_FE.us_NumberOfBands = 0;
   for(i=0; i<MAX_NUM_TX_BANDS; i++)
   {
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[i].s_LATN = OUT_OF_RANGE_LATN;
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[i].s_SATN = OUT_OF_RANGE_SATN;
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[i].s_SNRM = OUT_OF_RANGE_SNRM;
   }

   //=========================================================================
   // Clear actual profile selected
   //=========================================================================
//#ifdef MTK_VECTORING_SUPPORT
   gft_DSVectoringEnabled = FALSE;
   gt_ProfileAct.us_GvectorSelected    = 0;
//#endif
   gt_ProfileAct.us_ProfileSelected    = CNFG_V2_PROFILE_NONE_MASK;
   gt_ProfileAct.ul_AnxAUS0PsdSelected = CNFG_V2_ANXA_US0_NONE_MASK;
   gt_ProfileAct.us_AnxBUS0PsdSelected = CNFG_V2_ANXB_US0_NONE_MASK;
   gt_ProfileAct.us_AnxCUS0PsdSelected = CNFG_V2_ANXC_US0_NONE_MASK;


   //=========================================================================
   // Clear Electrical Length Estimate (kl0)
   //=========================================================================
   gt_Kl0ElectricalLength.s_kl0_estimate = 0;
   gt_Kl0ElectricalLength.s_kl0_final = 0;

   //estimate electrical length
   gs_get_estimate_kl0 = 1;
   gs_get_satn_latn = 1;

   /* =========================================================================================*/
   /* Initialize bitloading variables                                            */
   /* =========================================================================================*/
#ifndef SW_BITLOAD_TEST
   SetupDefaultIlvDilv();
   SetupDefaultDTB();
#endif //#ifndef SW_BITLOAD_TEST

   gs_MaxToneForFast = 0;

   gs_max_fine_gain = MAX_FINEGAIN_DB;       // 2.5dB in Q 8.8
   gs_min_fine_gain = - MAX_FINEGAIN_DB;     // -2.5dB in Q8.8

   gs_fgain_adjust = 0;
   gft_extrafinegainallocated = 0;
   gft_Flag_limitCause = 0;

   //These variable settings can be jointly controlled using the cmv
   gft_FineGainOn = 1;

   //SNR margin reduction debug control.
   //If this flag is set to 0, the SNR margin reduction is determined by the fine gain on/off flag
   //if this flag is set to 1, the SNR margin reduction is determined by gs_MarginReductionEnableFlag
   gs_DisableFGMarginReductionFlag = 0;
   gs_ApplyMarginReduction = 0;
   gs_MarginReductionEnableFlag = 1;
   gs_MaxMarginIterations = 1;
   gs_min_fine_gain_MarginRed = DEFAULT_MIN_FINEGAIN_DB;
   gs_UnloadedToneFGreduction_dB = 0;                     //fine gain of unloaded tones 0 dB in Q8.8 format
   gs_ExcessMarRedDB = 0;
   gs_ExcessMarFGReduction = 0;

   gs_RxMinTone = 0;
   gus_Tx_Tcm_Num1bits = 0;
   gus_Rx_Tcm_Num1bits = 0;
   gus_Rx_1Bit_Index = 0;

   gsa_TotalCodingGain[INLV] = 0;
   gsa_TotalCodingGain[FAST] = 0;

   guca_RSCodingGain[0] = 0;              // R = 0
   guca_RSCodingGain[1] = RS_CODING_GAIN_2;  // R = 2
   guca_RSCodingGain[2] = RS_CODING_GAIN_4;  // R = 2
   guca_RSCodingGain[3] = RS_CODING_GAIN_6;  // R = 2
   guca_RSCodingGain[4] = RS_CODING_GAIN_8;  // R = 2
   guca_RSCodingGain[5] = RS_CODING_GAIN_10; // R = 2
   guca_RSCodingGain[6] = RS_CODING_GAIN_12; // R = 2
   guca_RSCodingGain[7] = RS_CODING_GAIN_14; // R = 2
   guca_RSCodingGain[8] = RS_CODING_GAIN_16; // R = 16

   gft_UpdateNomAtp_Flag = TRUE;

   //==========================================================================
   // Parameters associated with TDQ and DEC training
   //==========================================================================
   gs_TDQLen = MIN_TDQ_LENGTH;


   //==========================================================================
   // Parameters associated with pilot tone, PLL
   //==========================================================================

   gft_UpdateTimingRecoveryHWEnable = 0; // Disables updating of Strymon Timing Recovery HW
   gft_EnableNoiseShaping = TRUE;        // Enables PLL loop filter output noise shaping.
   gl_noise_shaping_quan_err = 0;
   gs_MaxPhaseError = 0;                 // Current Max Absolute Phase Error
   gl_pll_freq_offset = 0;
   gl_pll_loopfilter_out = 0;
   // Constant SRC FR offset value. CO crytal @ 35.328 MHz; CPE @ 36 MHz.
   // This value corresponds to even phase increment.
   //Changed as an experiment to pass the Training and showtime test
   gl_constant_SRCFR_offset = 0x4C757;

   // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
   //XDSLRTFW-522: IOP_US_VDSL2_ALL_US_Data_Rate_Variation_In_BT_ECI_Tests (start)
   memset(&gt_PilotConfig, 0, sizeof(PilotConfig_t));
   gt_PilotConfig.s_NumPilotTones = 3;

   // !!!!!!!!!! NOTE: !!!!!!!!!!!!
   // Do NOT enable data-on-pilot on more than MAX_NUM_PILOT_TONES-1 pilot tones,
   // With more DOP pilot tones we would not report any normal pilot tone to CO which would lead to interop issues
   gt_PilotConfig.ta_PilotTones[2].ft_DeRotatePilot = TRUE; // Enable data-on-pilot on pilot tone 2

   for (i = 0; i < MAX_NUM_PILOT_TONES; i++)
   {
      gt_PilotConfig.ta_PilotTones[i].ul_RxMinPilotPWR = 0xFFFFFFFF; // we need to init the min value different to 0, otherwise it will not work
      // Count the number of enabled DOP pilot tones
      if(gt_PilotConfig.ta_PilotTones[i].ft_DeRotatePilot == TRUE)
      {
         s_numDOPenabled++;
      }
   }
   // Ensure that not more than MAX_NUM_PILOT_TONES-1 DOP pilot tones are enabled
   // With more DOP pilot tones we would not report any normal pilot tone to CO which would lead to interop issues
   // @todo add MTK_ASSERT(s_numDOPenabled < MAX_NUM_PILOT_TONES, break);" which is planned for R6.

   // default setting for PLL/pilot tone selection configuration
   gt_PilotConfig.s_PilotToneControl = (ADD_OFFSET_FROM_BANDEDGE | SWITCH_PILOT_IN_SHOWTIME);


   //XDSLRTFW-2442 (Start_End)
   gs_lowOscOffset_ppm = -45;//difference of initOffset in ppm b/w low and High Osc levels.

   //XDSLRTFW-2302 Start
   gs_ForcePllShowLimit = -1;
   if(gt_PilotConfig.s_PilotToneControl & DISABLE_MULTI_PILOT_SELECT)
   {
      gft_EnableShowPllToneSwitch = FALSE;
   }
   // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
   /* XDSLRTFW-2302 */
   gs_NumFramesPLLAcquisition = PLL_ACQUISITION_LEN1;
   gs_NumFramesPLLRelock      = PLL_ACQUISITION_LEN0;
   gs_PllWaitMedley           = 32;

   // Initialize Rx synch frame processing vars
   // (note this must be initialized here, otherwise pll will now be run during training
   // if this variable happens to be RX_DATA_SYMBOLS_PER_SUPERFRAME)
   gs_RxPMDFrameCount = 0;


   gft_RestoreOrigFdq = FALSE;

   gft_TxParrEnabled = FALSE;


//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
   //Added during virtual noise bringup from Vinax code base (Mercurial Tag: REL_V12_08_03_26_0_04)
   gs_Log2CarrierGroupSizeTx_Disc = -1;
   gs_Log2CarrierGroupSizeTx_Medley = -1;
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

   //XDSLRTFW-3226 (Start_End)
   gus_dbgMaxSEQp = 0;   // 0 implies no max limit defined by default (as per standard)

   gs_dbgMaxOHR = 256; // max msgp = 256 Kbps as per VDSL2 spec

   // this variable is set based on TPS-TC Bearer Channel Control during showtime initialization
   gus_PhysicalTransportMode = 0;

   //---------------------------------------------
   // there are problems with 1 bit constellations.
   // until fixed, the TARGET_HW builds will use
   // const sizes of 2-15.
   //---------------------------------------------
   gt_ModemConfig.s_DsMinConstSize = RX_MIN_BITS_PER_TONE;
   gt_ModemConfig.s_DsMaxConstSize = RX_MAX_BITS_PER_TONE;
   gt_ModemConfig.s_DsMaxNumEocBytes = MAX_EOC_BYTES_PER_SYMBOL;
   gt_ModemConfig.s_DsMaxNumVocBytes = MAX_VOC_BYTES_PER_SYMBOL;

   gt_ModemConfig.s_UsMinConstSize = RX_MIN_BITS_PER_TONE;
   gt_ModemConfig.s_UsMaxConstSize = RX_MAX_BITS_PER_TONE;
   gt_ModemConfig.s_UsMaxNumEocBytes = MAX_EOC_BYTES_PER_SYMBOL;
   gt_ModemConfig.s_UsMaxNumVocBytes = MAX_VOC_BYTES_PER_SYMBOL;

   gft_EnableMfdq = 0;
   gft_ForceMfdq = 0;
   gft_TxTcmFlag = 0;
   gft_RxTcmFlag = 0;
   gft_DsErasureDecodingFlag = 0;      // erasure capability of receiver

   gft_EnableFdqUpdate = 0;
   gft_EnableSnrUpdate = 0;

   gs_RxRefToneLevel = RX_POW_LEVEL;

   gft_HybridTrainingEnable = FALSE;
   gft_PGADnldEnable = 1;

   gs_PgaHandlerRun = 0;

   gs_TxToneOrderType = NO_TONE_ORDER;
   gs_RxToneOrderType = NO_TONE_ORDER;

#ifndef HW_TRT
   gs_TxTRT_write_band = 0;
   gs_TxTRT_write_offset = 0;

   gs_RxTRT_write_band = 0;
   gs_RxTRT_write_offset = 0;

   gs_TxTRT_read_band = 0;
   gs_TxTRT_read_offset = 0;

   gs_RxTRT_read_band = 0;
   gs_RxTRT_read_offset = 0;
   gs_TRT_readstate = 0;
   gft_use_framebuffer = 0;
#endif //#ifndef HW_TRT

   gsa_RxBitsInFifo[LP0] = 0;
   gsa_TxBitsInFifo[LP0] = 0;
   gsa_RxBitsInFifo[LP1] = 0;
   gsa_TxBitsInFifo[LP1] = 0;

   gs_rxnumfailures = 0;
   gs_txnumfailures = 0;
   gs_dbg_TxPmdCnt_TxFifoErr = -1;
   gs_dbg_RxPmdCnt_RxFifoErr = -1;
   gl_dbg_TxSymCnt_TxFifoErr = -1;
   gl_dbg_RxSymCnt_RxFifoErr = -1;


   // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   //=========================================
   // Auto SRA related variables
   //=========================================
   gft_SRARateViolated = FALSE;
   gft_SRA_FAIL = FALSE;

   gl_ActualDeltaSumLp = 0;
   gl_SRATotalLp_Delta = 0;
   gl_SRATotalLp_DeltaCnt = 0;
   gft_RxSraInProgress=FALSE;

   gft_DSRAInitiate = FALSE;
   gft_USRAInitiate = FALSE;
   gft_SNRUpdated_PostSRA = FALSE;
   gs_DTIME_Count = 0;
   gs_UTIME_Count = 0;
   guc_SraShiftOffset = SRA_TR115_SHIFT_OFFSET_1DOT3DB;
   guc_SraShiftControl = SHIFT_TO_TARGET_SRNM;

   // Initializing the RA mode to 2 for now..
   gus_DsRAMode = INFO2_RA_Mode_AT_INIT;
   gus_UsActRAMode = INFO2_RA_Mode_AT_INIT;


   // These flags will be set later on based on the capability negotiation
   gft_EnableTxSRA = FALSE;
   gft_EnableRxAutoSRA = FALSE;

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

   //=========================================
   //Init. framing parameters
   //=========================================

   guc_DsOneOverSmax = DEFAULT_MAX_ONE_OVER_S;
   guc_DsDynamicInlvEnable = 0;                 //disable

   guc_UsOneOverSmax = DEFAULT_MAX_ONE_OVER_S;
   guc_UsDynamicInlvEnable = 0;                 //disable

   //==============================================================================
   // EOC variables
   //==============================================================================

   // EOC timer for autonomous messages
   guc_EocTimerCount = 0;

   gus_EocTimerInterval = 50; //5 seconds for PM Counters read
   gus_FeParamTimerInterval = 100; //10 seconds by default for FE Params read

   gus_EocInvMsgResp = 0;

   gus_param_rd_carrier_index_Rx = 0; // For PMD Test Param MULT_READ command
   gs_param_rd_carrier_index_Tx = -1; // For PMD Test Param MULT_READ command

   gft_EocME_FEBlockReadPending = 0; // For PMD Test Param BLOCK_READ command

   gus_EocFEData_AutoMsgIx = 0; // Index field of the FE Data auto-msg
   gus_EocCEocMsg_AutoMsgIx = 0; // Index field of the Clear-Eoc-Msg auto-msg
   gs_EocCEocMsgLen = 0; // The number of words sent in the Clear-Eoc-Msg auto-msg

   gus_EocDesignatorErr = 0;
   gus_EocAckExpErr = 0;
   gus_EocBadPrioVal = 0;
   gus_EocSegmentAck = 0;
   gus_EocEscRcvd = 0;
   gus_EocLenTooSmall = 0;
   gus_EocLenTooBig = 0;
   gus_EocBadFCS = 0;
   gus_EocFCSCalcErr = 0;
   gus_EocTxIndex = 0;
   gus_EocRxIndex = 0;
   gs_NumTxSynchFlags = 0;
   gs_NumRxSynchFlags = 0;

   memset(&gt_DsOLRPMCnt, 0, sizeof(OLRPMCntInfo_t));
   memset(&gt_UsOLRPMCnt, 0, sizeof(OLRPMCntInfo_t));

   // Substitute the usage of MULT_READ and BLOCK_READ macros with guc_MULT_READ and guc_BLOCK_READ respectively.
   // Initialize guc_MULT_READ to MULT_READ and guc_BLOCK_READ by BLOCK_READ by default and re-initialize them to
   // 2 and 4 in post-handshake only if backward compatibility is necessary.
   guc_MULT_READ = MULT_READ;
   guc_BLOCK_READ = BLOCK_READ;


   // Control and Status for Tx/Rx Corrupt CRC Eoc Msgs
   memset(&gt_MONI_CrptCRCCtrl,0,sizeof(gt_MONI_CrptCRCCtrl));
   memset(&gt_MONI_CrptCRCStat,0,sizeof(gt_MONI_CrptCRCStat));

   /* =============================================================================== */
   /* Initialize modem configuration parameters */
   /* =============================================================================== */

   // Unity Tx variable gain = (1/2)*(2^1)
   gs_TxVarGain = UNITY_TX_VAR_GAIN;
   gs_TxVarGainExp = UNITY_TX_VAR_GAIN_EXP;

   // default TX IIR gain of unity.
   // If nonunity gain coeffs are loaded later, gs_tx_iir_atten_dB will be changed.
   gs_tx_iir_atten_dB = 0;
   gs_tx_psd_offset_dB_dbg = 0;  //8.8 To Increase the PSD use -ve values' say to increase PSD by 0.5 dB = -128

   gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC = FALSE;

   // Unity Rx variable gain = (1/2)*(2^1)
   gs_RxVarGain = UNITY_RX_VAR_GAIN;
   gs_RxVarGainExp = UNITY_RX_VAR_GAIN_EXP;
   gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = 0;
   gs_RxVarGainMarginDB = 0;

   //for some reason, we need to use higher PGA for Ghs to have longer loop reach
   //(this is not needed in Vinax CPE)
   gs_PGA_required_In_GHS = (AFED_MAX_PGA_GAIN << 8);   //this is the PGA used in GHS  XDSLRTFW-3613

   //Set the initial value used for PGA training
   gs_PGA_init_In_Train = DEFAULT_PGA_IN_TRAIN;

   gs_PGA_set = (0<<8);

   // This specifies the settel time/delay until the HW change gets be visible for the FW.
   // The delay is based on the time taken by HW and it is schedule. For cascaded mode with 8K tones FFT
   // a delay of 4 symbols and for 4K tones FFT of 3 symbols should be used.
   // It is mainly scheduling dependent and therefore a variable must be used!
   // Note: 35b Scheduling: AFE-Strymon-FFT-QT
   gs_HwSettleTime = AFE_TO_QT_LATENCY;
   gs_RTVxCfgLatency = RTV0_CFG_LATENCY;

   TESTArray[TEST_TxSubState] = 0;      // Initialize Selt Tx. and Rx. substates to 0
   TESTArray[TEST_RxSubState] = 0;      // for the selt and sleep state machines to start at
   // the desired substates.

   //==================================================
   //Misc. flags and variables
   //==================================================

   gs_EnableTaBugFix = TRUE;

   //Init the VDSL2 training state lengths
   gs_MinOPQuiet1StateLength = VDSL2_MIN_O_QUIET_TX_LENGTH;
   gs_MaxOPQuiet1StateLength = VDSL2_MAX_O_QUIET_TX_LENGTH;
   gs_Log2NumSymbolsToMeasureQln = LOG2SYMBOLCNT_MEASURE_QLN;

   // Rx Count following O-P-SYNCHRO1 detection on
   // which to transition Tx State
   gs_RPSynchroTxTransitionCount = 11;
   gs_ORMsg2RxTransitionCount = 1;
   gs_RxTxCsDiff = 0;
   gs_CsLength = 0;
   gs_HandleRxCE_PeriodicStateStart_s_count = -1;
   gs_HandleRxCE_PeriodicStateStart_StartSym_Offset = 0;
   gs_HandleRxCE_PeriodicStateStart_EndSym_Offset   = 0;
   gs_HandleRxCE_Periodic2StateStart_StartSym_Offset = 0;
   gs_HandleRxCE_Periodic2StateStart_EndSym_Offset   = 0;
   gs_TurnOffPLL_in_OPSYNCRO1 = 0;
   gft_RxTxCsDiff_err = 0;
   gft_SkipSymbol = 0;


   gl_MaxTimePerFrame = MAX_TIME_PER_FRAME_4K;

   gl_TxFcTimerCount = CRI_TX_PMS_GO_CNT_4K;
   gs_RxFcTimerCount = CRI_RX_PMS_GO_CNT_4K;
   gus_TxQtTimerCount = CRI_TX_QT_GO_CNT_4K;
   gl_TxQtpTimerCount = CRI_TX_QTP_GO_CNT_4K;
   gs_RxQtTimerCount = CRI_RX_QT_GO_CNT_4K;
   gs_RxQtpTimerCount = CRI_RX_QTP_GO_CNT_4K;

   gs_MaxSwapDuration = MAX_SWAP_TIMING;
   gl_TxStateTimeOutCount = STATE_TIMEOUT_LEN;
   gl_RxStateTimeOutCount = STATE_TIMEOUT_LEN;
   gl_GHSTimeOutCount = (STATE_TIMEOUT_LEN*3); // jg incr to 3 was 2*

   gus_ShowtimeControl = 0;
   gus_ShowtimeControlDDSave = 0;

   gs_first10secs_in_Showtime = 0;

   gft_StartTxShowinit = FALSE;
   gft_OKToSendBGFlag = 0;

   guc_RxShowInitState = RX_SHOW_INIT_VARS;
   guc_TxShowInitState = TX_SHOW_INIT_VARS;

   // bytes per symbol in exchange phase
   guc_ExchangePhaseTxNumBytesPerSymbol = 2;
   guc_ExchangePhaseRxNumBytesPerSymbol = 2;

   // initialize Macro State to RESET state
   gsa_IndirectStat0[0] = STAT_ResetState;
   gusa_MONI_ModemStat_Status[0] = MONI_STAT_RESET;

   gs_SendAckSegFlag = FALSE;

   gft_MPMessageCheckBG = 0;

   gl_SocTxDataForPrbs = 0;

   gs_VDSL2_MIN_R_IDLE_TX_TRAIN2 = (int16)VDSL2_MIN_R_IDLE_TX_TRAIN2;

   //=========================================================================
   // Debug variables
   //=========================================================================


   //XDSLRTFW-2050 : Debug Counter for TC No Sync PTM
   gusa_nSyncLoss[0] = 0;
   gusa_nSyncLoss[1] = 0;

   gus_RequeueBGFunction = 0;
   gus_Dbg_RequeueCnt = 0;
   gus_Dbg_DSH_skip_BGF_add = 0;
   gus_Dbg_msg_length = 0;
   gpt_DSH_ModemFsmState->ul_FsmState = 0;
   memset(&gta_DebugPll, 0 , sizeof(DebugPLL_t));
   gs_DSH_PrevFsmState = 0;
   guc_DSH_VersionInfoStreamed = FALSE;

   // Init DSH Statics
   memset(&gt_DshStatics, 0, sizeof(DSH_Statics_t));
   memset(&gt_DebugStreamMsg, 0, sizeof(HMP_DebugStreamMsg_t));

   gul_MaxPllCycles = 0;

   gs_Prev_TxOvhdMsg_length = 0;

   //==============================================================================
   // Algorithm Initialization
   //==============================================================================
   InitAlgConfigStructures();

   //==============================================================================
   // Timing Advance variables
   // init fixed delay(in samples)due to tx and rx path digital filter delays and
   // the 7.5 usec assumed channel delay
   //==============================================================================

   // clear TimingAdvanceTrail
   for (i=0; i<MAX_NUM_TA_ITERATIONS; i++)
   {
      gsa_TaAdjustTrail[i]=0;
      gsa_TaTargetTrail[i]=0;
      gsa_TaActualTrail[i]=0;
      gsa_TaAdjustTrailPre[i]=0;
      gsa_TaActualTrailPre[i]=0;
   }
   gs_TimingAdvanceTrailIndex=0;
   gs_DbgFrameSkewErrorIndex = 0;
   gs_DbgFrameSkewError = 0;

   gs_TimingAdvanceOffset = 0;
   gs_ReduceInitFrameOffsetCnt = MAX_NUM_TA_INIT_REPETITION;

   //==============================================================================
   // timing profile variables
   //==============================================================================
#ifdef DEBUG_TRAIL
   gt_debugTrailStatus.s_debugTrailPrevEvent = 0;

   if (gft_InitDebugTrailsOnReset == 1)
   {
      // Init Debug Trail Index
      gt_debugTrailStatus.s_debugTrailIndex = 0;
      gt_debugTrailStatus.s_debugTrailWrapCount = 0;
#endif // DEBUG_TRAIL
#ifdef PROFILE_TASKS
      // initialize Min/Max MIPS counts
      for(i=0; i<NUM_OF_PROFILE_POINTS; i++)
      {
         gsa_MaxMIPSCnt[i] = 0;
      }
#endif //#endif //PROFILE_TASKS

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
      for (i=0; i <CASCADE_ST_NUM_FW_TASKS ; i++)
      {
         gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[i].l_MaxMips = 0;
         gt_CasFwTasksMipsCnt.t_CasMipsCntFwTasks[i].l_MinMips = ((1 << 31) -1); //Init with big number 2^31 - 1;
      }
      gt_CasFwTasksMipsCnt.l_Start_TX_TCtask_min = ((1 << 31) -1); //Init with big number 2^31 - 1;
      gt_CasFwTasksMipsCnt.l_Start_TX_TCtask_max = 0;
      gt_CasFwTasksMipsCnt.l_Start_RX_TCtask_min = ((1 << 31) -1); //Init with big number 2^31 - 1;;
      gt_CasFwTasksMipsCnt.l_Start_RX_TCtask_max = 0;;
      gt_CasFwTasksMipsCnt.l_Start_RX_PMS_min    = ((1 << 31) -1); //Init with big number 2^31 - 1;;
      gt_CasFwTasksMipsCnt.l_Start_RX_PMS_max    = 0;

      for (i=0; i < CASCADE_NUM_TC_NTC_FW_TASKS ; i++)
      {
         gt_CascadeTcNtcMaxMipsCnt[i].l_MaxMips = 0;
         gt_CascadeTcNtcMaxMipsCnt[i].s_TxState = 0;
         gt_CascadeTcNtcMaxMipsCnt[i].s_TxSubState = 0;
         gt_CascadeTcNtcMaxMipsCnt[i].s_RxState = 0;
         gt_CascadeTcNtcMaxMipsCnt[i].s_RxSubState = 0;
      }

#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

#ifdef PROFILE_TASKS_VR9
      //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START)
      gta_MaxMIPSCnt[0].l_MaxMIPSCnt = 0;
      gta_MaxMIPSCnt[1].l_MaxMIPSCnt = 0;
      gus_MaxRxTcTime = CRI_TSC_CTRL_NUM_CLKS;
      gl_MaxMIPSCntSumN =0;
      gs_MipsCntRun =0;
      gl_MaxMIPSCntAvg=0;
      //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(END)

#endif //#ifdef PROFILE_TASKS_VR9

#if (defined(PROFILE_TASKS) || defined(PROFILE_TASKS_VR9))
      gs_RxTimerRollOverFlag = 0;
      gl_MaxRxTimerCnt = gl_MaxTimePerFrame;
#endif //#if (defined(PROFILE_TASKS) || defined(PROFILE_TASKS_VR9))
#ifdef DEBUG_TRAIL
   } //if (gft_InitDebugTrailsOnReset == 1)
#endif // DEBUG_TRAIL

   gs_TxRxMessaging = 0;

   // enable timeout check
   gs_EnableTimeoutCheckFlag = TRUE;

   //Enable SNR calculation in the periodic state
//   gs_PeriodicSnrCalcEnableFlag = TRUE;
   gs_PeriodicSnrCalcEnableFlag = FALSE;

   // for strymon overflow debugging
   gul_STR_OverflowData  = 0;

   gul_STR_OverflowMask  = 0x0001FEBF;

#ifdef ENABLE_VR9_HW_ERR_CNT
   for(i=0; i<17; i++)
   {
      gsa_StrymonOverflowCnt_train[i] = 0;
      gsa_StrymonOverflowCnt_medley[i] = 0;
      gsa_StrymonOverflowCnt[i] = 0;
   }

   gul_FT_OverflowData = 0;
   for(i=0; i<2; i++)
   {
      gusa_FTOverflowCnt_train[i] = 0;
      gusa_FTOverflowCnt_medley[i] = 0;
      gusa_FTOverflowCnt[i] = 0;
   }

   gul_TXQT_ErrorData = 0;
   gul_RXQT_ErrorData = 0;
   for(i=0; i<4; i++)
   {
      gsa_TxQTErrorCnt_train[i] = 0;
      gsa_TxQTErrorCnt_medley[i] = 0;
      gsa_TxQTErrorCnt[i] = 0;

      gsa_RxQTErrorCnt_train[i] = 0;
      gsa_RxQTErrorCnt_medley[i] = 0;
      gsa_RxQTErrorCnt[i] = 0;
   }

#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

   TESTArray[TEST_InitState] = TEST_GhsInitState;


   //------------------------------------------------------------------------
   //Used in loop diagnostic mode
   //------------------------------------------------------------------------
   gs_NumOfTxSocBits = 0;
   gft_RxSocMsgDemodFlag = DISABLE_LD_DEMOD_SOC_MSG;
   gft_TxSocMsgModFlag = FALSE;

   gl_TxStateTimeOutCountLoopDiagMode = DIAG_MODE_STATE_TIMEOUT_LEN;
   gl_RxStateTimeOutCountLoopDiagMode = DIAG_MODE_STATE_TIMEOUT_LEN;

   //10 second is the maximum length allowed for discovery, train and medely phase respectively
   //3 addition seconds is used for interlop with some "slower" modem
   gl_SynchroTimeoutCnt = (10+3)*TIMEOUT_CNT_1_SECONDS;

#if defined(VRX518_SINGAPORE_BRINGUP)
   gl_SynchroTimeoutCnt = (10+6)*TIMEOUT_CNT_1_SECONDS;
#endif // VRX518_SINGAPORE_BRINGUP

// reset the symbol counts for each initialization phase
   gl_TotalTxSymbolCount = 0;
   gl_TxRxSymbolCountDiff = 0;
   gl_HandshakePhaseSymCnt = 0;
   gl_HandshakePhaseSymCnt_start = 0;
   gl_DiscoveryPhaseSymCnt = 0;
   gl_DiscoveryPhaseSymCnt_start = 0;
   gl_TrainPhaseSymCnt = 0;
   gl_TrainPhaseSymCnt_start = 0;
   gl_AnalysisPhaseSymCnt = 0;
   gl_AnalysisPhaseSymCnt_start = 0;

   gpt_DebugTiming = &gt_DebugTiming;
   memset(gpt_DebugTiming, 0, sizeof(RT_DebugTiming_t));

   gft_UPBO_is_enabled = FALSE;


#ifdef DEBUG_TRAIL
   gt_debugTrailControl.ft_RxStateTrigger = FALSE;
   gt_debugTrailControl.ft_TxStateTrigger = FALSE;
#endif // DEBUG_TRAIL
   //Tssi will be enabled, except for certain CO vender/revisions addressed at link start or post handshake.
   gft_disable_tx_tssi = FALSE;

   //Initialize this to 0
   gs_interp_psd_with_tssi = 0;

   //Set the additional US0 PSD reduction to 0
   gs_Us0Ds1PsdDiff = 0;


   if (gft_EnableTxVarGainFix == TRUE)
   {
      gs_MAX_PERMISSIBLE_TXVGN_OUT_DB = (int16)MAX_PERMISSIBLE_TXVGN_OUT_DB - (int16)0x0100; // -17dB in Q8.8
   }
   else
   {
      gs_MAX_PERMISSIBLE_TXVGN_OUT_DB = (int16)MAX_PERMISSIBLE_TXVGN_OUT_DB; // -16dB in Q8.8
   }

   gs_DDSnrFdqCount = 0;
   gft_SkipBitswap = FALSE;


   gft_EnableFixedPofiCorner = TRUE;

   gs_MAX_US0_CEILING = MAX_US0_CEILING;

   gt_PwrConfigParamCMV.s_Up_InitialPsdCeiling = INITIAL_UP_PSDCEIL; /* specified in tenth of dB */

   //Enable computing the proposed ceiling
   gft_EnableProposedCeiling = 1;
   //XDSLRTFW-1836 : Identify the wrong MaxNomPSD Values Calulated
   gs_ForceSpecialCeilValueDs_Cntl &= (~WRONG_DS_NOM_PSD);          // Reset the indication


   //=======================================================================
   //Interop/debug variables
   //=======================================================================
   gul_dbgShowtimeControl = 0;

   gft_dbg_SkipTxSyncFrame = 0;
   gft_dbg_SkipRxSyncFrame = 0;

   gft_dbgSkipLastTwoOPSynchro = 0;
   gs_dbgDelayRPSynchro6 = 0;

   gs_RtvSelectLastFrame = RTV_NOTYPE;
   gs_RtvSelect = RTV_NOTYPE;
   gft_UpdateVRegShadowFifo = FALSE;

   for(i=0; i<2; i++)
   {
      gs_Tblcpy_Num0bit[i] = 0;
      gs_Tblcpy_NumGT1bit[i] = 0;
      gs_unpairedBatZeroTone[i] = 0;
   }


   gsa_SnrBuf = gsa_SnrBuf_OnePortMode;

//To load VR9 AFE functions in the RxLoadingFunctionFifo
   gft_LoadAfeFunctions = 0;

#ifdef VDSL_BONDING
   // clear bonding status before each link
   memset(&gt_Bonding_DiscAggr_Status, 0, sizeof(Bonding_DiscAggr_Status_t));
#endif

   gus_UseUS0OnlyCntrl = 0;
   // XDSLRTFW-1650 (Start_End)
   gs_ChangeTxBand = 0;

   guc_OffChipRequestHandle = CODESWAP_NO_ACTION;
   guc_RxUcodeHandle = CODESWAP_NO_ACTION;
   guc_TxUcodeHandle = CODESWAP_NO_ACTION;

   // Clear QLN buffer
   memset(guca_QLN, 0, sizeof(int8)*512);
   // Clear Hlog buffer
   memset(gsa_RxHlog, 0, sizeof(int16)*512);
   // Clear Noise margin separation (NMS) buffer
   memset(guca_NMS, 0, RX_MAX_NUM_TONES);


   //Initialize the variables used in erasure decoding
   gft_Calculate_EdMetric_PilotPwr_Threshold = 1; // XDSLRTFW-2481 (only variable name changed)
   guc_metric_discard_threshold = 0;
   gus_metric_eval_cnt = 0;
   gul_num_frame_lowmetric = 0;
   gus_lowmetric_detect_cnt = 0;
   gus_lowmetric_discard_cnt = 0;

   //The previous code has been disabled the RX IIR filter due to a bug in PGAHandler()
   //After we fixed that bug, the RX IIR filter is enabled.
   //However, the current RX IIR filter caused slight rate decrease at short loop (due to ISI),
   //but some improvement in long loop (since it filters out some echo)
   //We temporarily disable this filter until more tests are done
   //gs_STR_DbgCntl |= STR_DBG_CNTL_DISABLE_RXIIR;  //XDSLRTFW-3463 Enable Rx IIR in Handshake phase, after handshake enable it again

   //XDSLRTFW-373: BugFix_DS_VDSL2_ALL_ReTx_Vars_Not_Init_At_SoftReset (Start)
   gt_ReTXParams.uc_RMSG2_CpeRxHalfRoundTripDelays = 6;

   /* XDSLRTFW-2858 */
   gt_ReTXParams.uc_CpeRxHalfRoundTripDelays_UsedInFraming =  0xFF;
   gs_CpeRxHalfRoundTripDelays_ForcedInFraming  = 0;
   /* XDSLRTFW-2858 */

   //Enabling ReTx by default, as SW API for enabling it is not working.
   //XDSLRTFW-1555(START_END). Enable DS+US ReTx+ Amend2 by default
   // XDSLRTFW-1693 (Start_End) - G.998.4 Extensions
   gus_ReTxOptionsEnabled = 0;
   // XDSLRTFW-1028_SRAds_Support_with_DS_ReTx (START)
   gt_ReTXParams.t_ReTXConfigCMV.uc_G_Inp_Amend1_Support = CPE_DS_RETX_CAPABLE;
   // XDSLRTFW-1028_SRAds_Support_with_DS_ReTx (END)
   gt_ReTXParams.t_ReTXConfigCMV.uc_G_Inp_Amend1_Support |= (CPE_DS_RETX_CAPABLE << 4) ;
   gt_ReTXStats.ul_RetransmittedDtuCnt = -1;
   //XDSLRTFW-1607(START_END)
   gt_ReTXParams.Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q=0;
   gt_ReTXParams.Un_UcodeReTXParam1.t_Param1.uc_DtuPaddingSize_V=0;
   gt_ReTXParams.uc_RPMS_Qtx=0;
   gl_TxAbsoluteDTUCount = 0;

   // The MaxDelayOctets depends upon both the hardware and the band plan.
   // e.g. our HW supports 60Kbytes in each direction, while the
   // standard requires only 65536, 98304 and 131072 total for 8x, 17a and 30 band plans, respectively.
   // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start/End)
   //XDSLRTFW-1707_30a_RTX_DsUs (Start)
   //(ZEP_ILV_DILV_BLOCK_SIZE - MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX - DS_RETX_LP1_PROCESSING)
   gul_ItlvMemSizeReTxRMsg2 = (ILV_DILV_MEM_INDICATION_IN_R_MSG2<<1); // This Variable value transmitted in R-MSG2.G.INP.Field10.

   gs_HQV_MaxIdx = 0;
   gs_rxILVBaseAddrOffset = 0;
   //XDSLRTFW-1707_30a_RTX_DsUs (Start_End)

   //XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode (Start_End)
   gt_ReTXStats.ul_RetransmittedDtuCntFE = 0;

   gt_ReTXStats.ul_EFTR = 0;
   gt_ReTXStats.ul_ErrorFreeBits = 0;
   gt_ReTXStats.ul_EFTR_min = 0;

   //XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp (Start)
   // For the  observation  periods  in  which  EFTR  is  either  not  defined  or  always  less  than  ETR/2,  or  both,
   //over the complete observation period, the value of EFTR_min shall be set to a special 32-bit value of 0xFFFFFFFF 16 .
   gt_ReTXStats.ul_EFTR_min_Prev = 0xFFFFFFFF;
   guc_seftrPrecFollowing = 0;
   guc_EftrLtETRby2OverObsPeriod = FALSE;
   //XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp (End)

   gt_ReTXStats.ul_LEFTR_Cntr = 0;
   gt_ReTXStats.ul_ReTX_ReceiverETR = 0;
   gt_ReTXStats.us_ReTX_ReceiverActualDelay = 0;
   gt_ReTXStats.us_FE_InpActShine = 0;
   gt_ReTXStats.us_FE_InpActRine = 0;

   gt_ReTXStats.ul_CorrectedDtuCnt = 0;
   gt_ReTXStats.ul_UncorrectedDtuCnt = 0;
   //XDSLRTFW-373: BugFix_DS_VDSL2_ALL_ReTx_Vars_Not_Init_At_SoftReset (End)
   //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
   gt_ReTXStats.us_US_InpActShine = 0;
   gt_ReTXStats.us_US_InpActRein= 0;


   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
   gt_UsReTx_ConfigVar.s_UsReTx_FrameType_Support=0x0002; //framing type 3(bit 1 is set) supported
   //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

   gft_UsReTxSraStopRrcEval = FALSE;//XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start_end)
   //Initialize ReTx variables
   gt_ReTXParams.t_ReTXConfigCMV.us_US_DelayMax =RTX_US_DELAY_MAX_DEFAULT;
   gt_ReTXParams.us_US_SHINEratio = RTX_US_SHINERATIO_DEFAULT;

   //XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt(START_END)
   //Initialize FE management counters to zero
   memset(&gt_g997_ReTx_FE_MgmtCnt, 0, sizeof(G997_ReTx_MgmtCnt_t));
   //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)
   gs_DTUSizeDS = 0;
   gs_DTUPayloadSizeDS = 0;
   gus_DebugVar1 =0;
#ifdef ENABLE_RETX_US_DEBUG1
   gula_PalakDebug[0] = 0;
#endif

   // XDSLRTFW-1696 (start)
   // initialize US Frequency dependent Pilot Sequence (FDPS) Arrays and Pointers
   // FDPS pointers
   {
      gpuca_FDPSActive = (uint8 *)(void *)guca_FDPS1;
      gpuca_FDPSInActive = (uint8 *)(void *)guca_FDPS2;

      // initialize FDPS Arrays
      for (i = 0; i < 8; i++)
      {
         for (int16 j = 0; j<64; j++)
         {
            guca_FDPS1[i][j] = 0;
            guca_FDPS2[i][j] = 0;
         }

         // initialize independent pilot sequence, syclic shif and sign of sequence arrays and variables
         guca_IndexIndependentPSActive[i] = 0;
         guca_IndexIndependentPSInActive[i] = 0;

         guca_CyclicalShiftOfSeqActive[i] = 0;
         guca_CyclicalShiftOfSeqInActive[i] = 0;

      }

      guc_SignOfSeqActive = 0;
      guc_SignOfSeqInActive = 0;

      guc_NoOfAdditionalIPSActive = 0;
      guc_NoOfAdditionalIPSInActive = 0;

      gus_PSChangeReq = 0;
      gus_PSChangePerf = 0;
   }
   //XDSLRTFW-1696 (end)

   guc_InitSuccessFailCode = INIT_SUCCESS; // XDSLRTFW-1958(Start_End)


   TESTArray[TEST_ERB_ST_TX_CONTROL] = 0; // XDSLRTFW-2014 / XDSLRTFW-2250 (Start_End)

   memset(&gt_PrevErbParams, 0, sizeof(gt_PrevErbParams));   // XDSLRTFW-3507 (Start_End)

   //XDSLRTFW-2012 (START)
   //CMV to Reset PPE HW for PTM CW Alignment
   //Bit Mask 0; 1 ==> Reset; 0 ==> Don't Reset
   //Bit Mask 1; 1 ==> Enable  0 ==> Disable Noise Margin Equalization
   //Bit Mask 2; 1 ==> Enable; 0 ==> Disable flag to limit per tone margin at threshold
   //                  while performing DS Upshift SRA
   //XDSLRTFW-1784 (Showtime Margin Equalization - START)
   //XDSLRTFW-2168 (Start)
   //XDSLRTFW-3300 (Start)
   //XDSLRTFW-3493 (Start)
   //XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(Start)
   //!!Disable Showtime Margin Equalization algorithm by default due to some non initialized variables in some cases
   //Before enabling - this algorithm need to be reviewed!!
   //XDSLRTFW-4050: Autonomous State Event Messaging in VDSL mode is by default disabled
   TESTArray[TEST_Control4] = (TEST_Control4_Reset_PPE_BytePtr_Bit0_Mask |
                               TEST_Control4_Ena_StAdma_Queue_Bit3_Mask |
                               TEST_Control4_Ena_512TonesPerGroup_StDdSnrFdq_Bit4_Mask |
                               TEST_Control4_HRT_5_0_Scheduling_35b_Bit7_Mask |
                               TEST_Control4_HRT_5_0_CapMaxDsBits14_35b_Bit9_Mask |
                               TEST_Control4_Enhanced_ReTx_Framing_Bit10_Mask
                              );  //Initialization
   //XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(End)
   //XDSLRTFW-3493 (End)
   //XDSLRTFW-3300 (End)
   //XDSLRTFW-2168 (End)
   //XDSLRTFW-1784 (Showtime Margin Equalization - END)
   //XDSLRTFW-2012 (END)

   //Enable MIPS profiling by default //XDSLRTFW-3709 (Start_End)
   TESTArray[TEST_Control] = (TEST_TaskProfileControl);

   //XDSLRTFW-3036 Start
   //disable Tx PSD frequency dependent compensation function and test Tx PSD (by setting cmv cw test 52 0 1
   //based on measured Tx PSD results, we have to decide whether we need "Tx PSD frequency dependent compensation function" or not
   //XDSLRTFW-3596  Enable Rx gain correction for input RXA(RX absolute gain error and input impedance variation correction)
   TESTArray[TEST_TX_PSD_CONTROL] = TEST_TX_PSD_CONTROL_SEL_PSDCompensation | TEST_TX_PSD_CONTROL_US0_BAND | TEST_ENA_RXGAIN_IMPEDANCEVAR_CORRECTION;//XDSLRTFW-3613
   //XDSLRTFW-3036 End

   //XDSLRTFW-3596 Start
   gt_PgaGainCorrectionDslPath.ft_eFuseDataAvailOnChip = FALSE;//XDSLRTFW-3026
   gt_PgaGainCorrectionDslPath.s_RX_IN_IMP_in =0;
   gt_PgaGainCorrectionDslPath.s_RX_GAIN_ERR_in =0;
   gt_PgaGainCorrectionDslPath.s_RX_GAIN_ERR_dB_Out =0;
   gt_PgaGainCorrectionDslPath.s_imp_error_rx_dB_out =0;
   gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out =0;
   //XDSLRTFW-3596 End

   //XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (Start)
   gt_DbgImprovedATTNDR.us_ATTNDR_MISC_CONFIGURATION = ATTNDR_ALGO_2_METHOD_0_CHANNEL_CAPACITY_BASED;
   //XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (End)
} //InitGlobalVars_PreHandshake

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InitAlgConfigStructures(void)
*
*  This function initializes variables in training algorithms
*  (e.g. SNR, FDQ, etc.).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitAlgConfigStructures(void)
{
   gt_FrameAlignConfig.s_AlgHandlerState = (-1);
   gt_FrameAlignConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_FRAME_ALIGN_SYMBOLS;
   gt_FrameAlignConfig.s_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_512;
   gt_FrameAlignConfig.s_MinNumIterations = MIN_NUM_FRAME_ALIGN_ITERATIONS;
   gt_FrameAlignConfig.s_MaxNumIterations = MAX_NUM_FRAME_ALIGN_ITERATIONS;
   gt_FrameAlignConfig.s_MaxAlignmentOffset = 1024;

   gt_FdqConfig.s_AlgHandlerState = (-1);
   gt_FdqConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_FDQ_TRAINING_SYMBOLS;
   gt_FdqConfig.s_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_512;

   gt_SnrConfig.s_AlgHandlerState = (-1);
   gt_SnrConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_SNR_TRAINING_SYMBOLS;
   gt_SnrConfig.s_NumChannelsPerGroup = MAX_NUM_CHANNELS_PER_GROUP;

   gt_SnrFrameAlignConfig.s_AlgHandlerState = (-1);
   gt_SnrFrameAlignConfig.s_MedleyAlignOffsetStep = FRAME_REALIGNMENT_STEP;
   gt_SnrFrameAlignConfig.s_NumOfMedleyAlignPoints = NUM_FRAME_REALIGNMENT_POINTS;
   gs_MedleyFrameSynchEnableFlag = FALSE;

   gt_DDSnrFdqConfig.s_AlgHandlerState = (-1);
   gt_DDSnrFdqConfig.s_AlgLog2NumFramesToAccum = LOG2_DD_SNRFDQ_NUM_TRAINING_SYMBOLS;
   gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup =  DD_SNRFDQ_NUM_CHANNELS_PER_GROUP_256;

   gt_AFEConfig.us_AFERegAddr = 0;
   gt_AFEConfig.us_AFERegData = 0;
   gt_AFEConfig.us_AFERegOp   = AFE_REG_NO_OP; // 0 = ready (no op); 1 = read; 2 = write

   gt_PsdConfig.s_AlgHandlerState = (-1);
   gt_PsdConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_PSD_TRAINING_SYMBOLS;
   gt_PsdConfig.s_NumChannelsPerGroup = MAX_NUM_CHANNELS_PER_GROUP;
   gt_PsdConfig.s_AlgCalcType = (PSD_CALC_TYPE_INITMSRDBUFF_AND_INC);
   gt_PsdConfig.s_FirstChannel = 0;
   gt_PsdConfig.s_LastChannel = RX_MAX_NUM_TONES;

   //Set the number of symbols (in log2 format) to be used for PGA calculation
   gc_Log2NumFramesToAccumForPGA = 0;  //1 symbols

   gt_MfdqConfig.s_AlgHandlerState = (-1);
   gt_MfdqConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_MFDQ_TRAINING_SYMBOLS;
   gt_MfdqConfig.s_NumMfdqTones = MAX_MFDQ_TONES;
   gt_MfdqConfig.s_ErrorCode = 0;
   gt_MfdqConfig.s_MfdqMargin = 0;

#ifndef PILOT_TONE_LOS_DETECT
   // defines power decrease required to generate LOS defect (8.8 format)
   gt_DDRxPowerCalc.s_AvRxTimePwr_Threshold_Delta = (6 << 8);
#else
   // Reset LOS detection state
   {
      guc_LosDefect_state = 0;
   }
#endif //PILOT_TONE_LOS_DETECT

} //InitAlgConfigStructures()

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InitGlobalVarsAtLinkStart(void)
*
*  This function initializes all global variables which should be set after
*  ME finalizes its start-up settings. This function should also be called at
*  modem restart.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

//Test flag, if it is set to 1, we can test 2K FFT size in a single port mode
FlagT gft_Use2kFFT = 0;

//Mei test
//int16 gs_afe_fixed_gain_dbg = 0;

void InitGlobalVarsAtLinkStart(void)
{
   int16 i;

//XDSLRTFW-3596 Start

   if (gula_VRX518_EfuseTable[7] & 0x0001) //AFE_VEGA_EFUSE
   {
      gt_PgaGainCorrectionDslPath.ft_eFuseDataAvailOnChip = TRUE;
   }

   if (gt_PgaGainCorrectionDslPath.ft_eFuseDataAvailOnChip)
   {
     VRX518_RxPathDslGainCorrection();
   }
//XDSLRTFW-3596 End

   // Default to 0
   gs_HybridGain = 0;
   //==========================================================================
   // set variables related to IFFT/FFT size
   //==========================================================================

   //Default to use 4096 tones for both US and DS
   gs_TxLog2IfftLength = US_LOG2_FFT_LENGTH_8192;
   gs_RxLog2FftLength  = DS_LOG2_FFT_LENGTH_8192;
   gs_m = 5;                                                // The mandatory "m" value for VDSL2
   gs_FeModemLog2IfftSize = DS_LOG2_FFT_LENGTH_8192;

   //For two port mode, we change the IFFT/FFT size to process 2048 tones
   if((guc_PortMode == 1) || (gft_Use2kFFT))
   {
      gs_TxLog2IfftLength = US_LOG2_FFT_LENGTH_4096;
      gs_RxLog2FftLength  = DS_LOG2_FFT_LENGTH_4096;
   }
   //Compute various IFFT/FFT related parameters
   ConfigDfeParam();


   //For two-port mode
   if (guc_PortMode == 1)
   {
      gsa_SnrBuf = gsa_SnrBuf_TwoPortMode;                        // to sdram scratch for later showtime access.
   }
   //For one-port mode
   else //guc_PortMode == 0)
   {
      gsa_SnrBuf = gsa_SnrBuf_OnePortMode;
   }

   INFOMap[INFO_SnrBuf] = gsa_SnrBuf;
   INFOMap[INFO_HLOG_DS] = gsa_RxHlog;

   gs_LowestAllowedRxTone = 0;
   gs_HighestAllowedRxTone = gs_RxNumTones-1;
   gt_PsdConfig.s_LastChannel = gs_RxNumTones;

   if(gs_NumChannelsPerGroup > gs_RxNumTones)
   {
      gs_NumChannelsPerGroup = gs_RxNumTones;
   }

   if (TESTArray[TEST_Control4] & TEST_Control4_Ena_512TonesPerGroup_StDdSnrFdq_Bit4_Mask)
   {
      gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup =  DD_SNRFDQ_NUM_CHANNELS_PER_GROUP_512;
   }
   else
   {
      gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup =  DD_SNRFDQ_NUM_CHANNELS_PER_GROUP_256;
   }
   //XDSLRTFW-3441  Start_End
   {
      //XDSLRTFW-3569 start
      //VRX518 Normalised Rx path compensation table for 35b mode and legacy modes(17M/12M/8M)
      //Generated normalised Rx path tarnsfer function(unity gain)
      //Seperated Trafo Gain,AFe level shift gain,Hybrid Gain,PGA,PREFI into structure
      gt_DfeAfeGainSettings.s_AfeLevelShiftDfe_Gain_dB = 1131; // analog voltage at ADC input to digital signal in range (+/-1v)  4.4190 dB = 4.4190*256 = 1131 in 8.8
      gt_DfeAfeGainSettings.s_RxPathTrafo_Gain_dB = -56;        // RxPath Transformer gain=-0.2164dB  = -56 in 8.8
      gt_DfeAfeGainSettings.s_Rx_CIC_Gain_dB = 0;              // typically: 0dB
      gt_DfeAfeGainSettings.s_Rx_WDF_DEC2_Gain_dB = 0;         // typically: 0dB
      gt_DfeAfeGainSettings.s_ADC_Adjust_Gain_dB = -297;       // Digital clipping would occur when ADC out full scale would be available, i.e.
                                                               // full scale in range (+/-32768), but Digital (+/-28672)=20*log((32768-4096)/32768) =-1.16 db.
                                                               // Therefore this must only be considered during PgaHandler as analog margin!
      gt_DfeAfeGainSettings.s_Rx_WDF_DEC1_Gain_dB = 0;         // typically: 0dB,option to change with the WDF Scaling
      gt_DfeAfeGainSettings.s_Rx_FIR_Decim1_Gain_dB = 0;       // typically: 0 dB,option to change with the RXDECIMX Scaling/Coefficients
      gt_DfeAfeGainSettings.s_Rx_SRC_Gain_dB = 0;              // typically: 0dB,option to change with the RXDECIMX Scaling/Coefficients
      gt_DfeAfeGainSettings.s_Rx_IIR_Gain_dB = 0;              // typically: 0dB,option to change with the Output Scaling/Coefficients
      gt_DfeAfeGainSettings.s_Rx_TDQ_Gain_dB = 0;              // typically: 0dB,option to change with the Output Scaling/Coefficients
      gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = 0;            // 0dB during Gain training, after PGA2 train = Avg-Peak power
      gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB = 0;          // FFT Gain RMS[dB] = 20*log10(sqrt(FFTSize)/2^RSH), with FFTSize = 2*Nfft
      gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz = 0;         // FFT Gain dBm/Hz = 20*log(2^RSH / (2Nfft)) + 10*log(2), with FFTSize = 2*Nfft


      gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB =
            gt_DfeAfeGainSettings.s_Rx_CIC_Gain_dB + gt_DfeAfeGainSettings.s_Rx_WDF_DEC2_Gain_dB +
            gt_DfeAfeGainSettings.s_ADC_Adjust_Gain_dB + gt_DfeAfeGainSettings.s_Rx_WDF_DEC1_Gain_dB +
            gt_DfeAfeGainSettings.s_Rx_FIR_Decim1_Gain_dB + gt_DfeAfeGainSettings.s_Rx_SRC_Gain_dB +
            gt_DfeAfeGainSettings.s_Rx_IIR_Gain_dB + gt_DfeAfeGainSettings.s_Rx_TDQ_Gain_dB;
      //XDSLRTFW-3569 End
   }
   // Codeswap flag used in diag mode
   gft_CodeSwapDoneFlag = FALSE;

   //==============================================================================
   // Variables used to interop with certain non-compliant far end's
   //==============================================================================
   gul_dbgSocMsgControl2 = 0;

   if (gsa_Optn0_ModeControl[1] & OPTN_ConfigMode_CNXT)
   {
      // Handshake Hooks
      // Using DS Carrier Sets of AnnexB causes the CPE to timeout always.
      // TBD: Understand whether CO stops transmission or CPE has problems decoding these DS bands
      // TBD: Investigate infrequent CPE timeouts when multi-ghs carrier sets enabled, even though CPE selects V43P DS carrier set
      gs_GhsCarSetCfg = (CNFG_GHS_CAR_SET_A43 | CNFG_GHS_CAR_SET_A43C |
                         //CNFG_GHS_CAR_SET_B43 | CNFG_GHS_CAR_SET_B43C |
                         CNFG_GHS_CAR_SET_V43 | CNFG_GHS_CAR_SET_V43P | CNFG_GHS_CAR_SET_V43I);

      gul_dbgGHSControl = (DISABLE_T1_MCM_IN_SI_SPAR1 | SUPPORT_STM_IN_SI_NPAR2_VDSL1 | SUPPORT_INITCE_IN_SI_SPAR2_VDSL1);

      // Signal Detection Thresholds
      gs_DetectDelay = 3000;

      // Speed up state machine- Disable unncessary psd calculations, speed up Kl0 computation etc
      gus_VdslCntlFlag &= ~(BITMAP_ENABLE_MEASURE_ROTRAIN_ECHOOFF_PSD|BITMAP_ENABLE_PSD_TRAIN1_VDSL2);
      gus_VdslCntlFlag |= (BITMAP_ENABLE_KL0_COMPUTE_SPEEDUP);

      // State transition timing
      gs_DbgRPSynchro1TransitionDelay = 3;
      gs_DbgOPSynchro1TransitionDelay = 3;

      // SoC Messaging
      gul_dbgSocMsgControl |= (TX_FLIP_01_SENSE | TX_SKIP_HDLC_FCS_INVERSION | TX_SWITCH_HDLC_FCS_BYTEORDER | TX_BIT_REVERSE_HDLC_FCS |
                               RX_FLIP_01_SENSE | RX_INVERT_HDLC_FCS | RX_SWITCH_HDLC_FCS_BYTEORDER | RX_BIT_REVERSE_HDLC_FCS |
                               CONTROL_TX_TCM_ENABLE_USING_BAT);
      gul_dbgSocMsgControl |= (IGNORE_FAREND_CE | IGNORE_FAREND_TA | FORCE_M0_I0_EOC1_VOC1 | FORCE_R8_ADAPTIVE_RATE_BITLOAD | FORCE_N144_RCONTRACT1 | FORCE_NEW_BITLOAD_FOR_RMARGIN);

      // PRBS
      guc_dbgMedleyRxPrbsSkipBits = 2;

      // Bitloading and B/G/T Message Control
      gs_TxToneOrderType = NORMAL_TONE_ORDER;
      gs_RxToneOrderType = NORMAL_TONE_ORDER;
      gt_ModemConfig.s_DsMinConstSize = RX_MIN_BITS_PER_TONE_2;
      gs_dbgTxBgMsgInsertZeros = 32;
      gs_dbgRxBgMsgIgnoreZeros = 38;
      gul_dbgMiscControl = IGNORE_BI0_TONES_FOR_NOMATP_COMPUTATION;

      // Showtime Transition Timing
      gs_dbgAdvanceEnableXTC = 2;
      gs_dbgAdvanceTxSynchro2 = 2;
      gs_dbgDelayTxShowTransition = 104;
      gs_dbgDelayRxShowTransition = 121;

      // Showtime Data Pump
      guc_dbgIncreaseFifoLength = 1;
      guc_dbg_ZEP_MAX_RX_FC_RUN_CNT = 1;
      gul_dbgShowtimeControl = (TX_SET_FC_REGISTER_START | TX_ENABLE_MULTIPLE_AZ_RUNS  | TX_DISABLE_SCRAMBLE_BITREVERSE_CRC |
                                RX_SET_FC_REGISTER_START | RX_DISABLE_SCRAMBLE_BITREVERSE_CRC);
      gul_dbgShowtimeControl |= (   TX_SET_XTC_REGISTER_START |
                                    VDSL1_TX_EOC_SWAP_ADDRESS_CONTROL_FIELD | VDSL1_TX_EOC_SWAP_LSB_MSB_DATA_FIELD | VDSL1_TX_EOC_SEND_ECHO_FAR_END_FCS  |
                                    VDSL1_RX_EOC_IGNORE_FAR_END_FCS  | VDSL1_RX_EOC_SWAP_ADDRESS_CONTROL_FIELD | VDSL1_RX_EOC_SWAP_LSB_MSB_DATA_FIELD | VDSL1_RX_EOC_PROCESS_OPCODE_IN_READ_WRITE_STATE |
                                    VDSL1_RX_REFORMAT_LATTN_FOR_CNXT_FAREND   | VDSL1_RX_REFORMAT_SNRM_FOR_CNXT_FAREND);
      gs_dbgRogueHdlcOctetThreshold = 10;       //Send a UTC on recieving threshold many rogue octets, -1 implies Disabled
   }
   else if (gsa_Optn0_ModeControl[1] & OPTN_ConfigMode_IKAN)
   {
      // If VDSL2 is enabled
      // Handshake Hooks
      // Use only A43 to simplify the CTones threshold based loop length estimator
      // We use the estimate of the loop length to adapt the US and DS bands
      // transmitted by the CO- by channging the CLR message appropriately
      gs_GhsCarSetCfg = CNFG_GHS_CAR_SET_A43;
      //Mimic Ikanos Vendor ID
      gpt_TxInfo->ul_Provider = IKNS_VENDOR_ID;
      gpt_TxInfoSave->ul_Provider = IKNS_VENDOR_ID;
      //Mimic Ikanos CPEs non standard message
      gul_dbgGHSControl = FORCE_NON_STANDARD_INFO;
      //Enable Line Probe
      gul_OperationModeCapable_VDSL2 |= V2_LINEPROBE;
      //Clear PSD Masks
      gt_ProfileControl.ul_AnxAUS0PsdSupported = 0;
      gt_ProfileControl.us_AnxBUS0PsdSupported = 0;
      gt_ProfileControl.us_AnxCUS0PsdSupported = 0;

      // Speed up state machine- Disable unncessary psd calculations, shorten accumulations, disable hybrid training
      gus_VdslCntlFlag &= ~(BITMAP_ENABLE_MEASURE_ROTRAIN_ECHOOFF_PSD | BITMAP_ENABLE_PSD_TRAIN1_VDSL2);
      gt_PsdConfig.s_AlgLog2NumFramesToAccum = 6;
      gt_FdqConfig.s_AlgLog2NumFramesToAccum = 6;
      gft_HybridTrainingEnable = FALSE;

      // State transition timing
      guc_RtReq_EcLength = 0;
      guc_RtReq_TeqLength = 0;
      guc_RtReq_CoTeqLength = 0;
      guc_RtReq_PeriodicLength = 0;
      gs_dbgRPTrain1Delay = 9600;
      gs_dbgROPTrain1Delay = 1400;
      gs_VDSL2_MIN_R_IDLE_TX_TRAIN2 = 2700;
      gs_dbgDelayTxSynchro2 = 640;

      // SoC Messaging
      gul_dbgSocMsgControl = (FORCE_PSD_DESCRIPTOR_IN_0PT5_dB_FORMAT | FORCE_IDLE_IN_PERIODIC1 | FORCE_PERIODIC2_DISABLE | WORKAROUND_IKANOS_CO_INIT_TIMING_ADVANCE | DISABLE_PRBS_RESET_FOR_SYNCHRO6);
      gul_dbgSocMsgControl2 |= SWAP_TONE_INDEX_IN_TRT_MSG_EXCHANGE | DISABLE_APPLY_BAND_LIMIT;

      // PRBS
      guc_dbgMedleyTxPrbsSkipBits = 2;

      // Bitloading and B/G/T Message Control
      gul_dbg_DILV_MEM_SIZE = 16380;
      //guc_minR  = 16;
      //guc_maxM = 1;
      //guc_maxT = 1;
      //guc_maxG = 1;

      // Misc
      gul_dbgMiscControl = (DISABLE_TX_PERIODIC_TRANSITION | DISABLE_RX_PERIODIC_TRANSITION | ENABLE_SYNCHRO2_DETECTION | FORCE_MULTIPLE_OF_8_L_ADAPTIVE_RATE_BITLOAD);
      guc_dbgFeModemLog2IfftSize = 12;
      gs_ForceSpecialCeilValueDs_Cntl |= CNFG_V2_PROFILE_ALL_MASK;

      gft_FineGainOn = 0;
      gs_MarginReductionEnableFlag = 0;
   }

   if(gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING)
   {
      gusa_SwitchingThreshTxBands[SWITCH_TO_1BAND_IDX0]          = KL0_TRESH_SWITCH_TO_1BAND;
      gusa_SwitchingThreshTxBands[SWITCH_TO_2BAND_IDX1]          = KL0_TRESH_SWITCH_TO_2BAND;

      gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_X_HYB]         = KL0_TRESH_SWITCH_TO_PROFILE_X_HYB;
      gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_17_HYB]        = KL0_TRESH_SWITCH_TO_PROFILE_17_HYB;
      gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_8_HYB]         = KL0_TRESH_SWITCH_TO_PROFILE_8_HYB;
      gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_US0_HYB]       = KL0_TRESH_SWITCH_TO_PROFILE_US0_HYB;

      gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX0_15PF]     = KL0_TRESH_ACE_MODE_15PF;
      gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX1_30PF]     = KL0_TRESH_ACE_MODE_30PF;
      gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX2_52DOT5PF] = KL0_TRESH_ACE_MODE_52DOT5PF;
      gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX3_15PF_LR]  = KL0_TRESH_ACE_MODE_15PF_LR;
      gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX4_7DOT5PF]  = KL0_TRESH_ACE_MODE_7DOT5PF;
      gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX5_OFF]      = KL0_TRESH_ACE_MODE_OFF;
   }

   // Set the AFE LIF module type
   gus_HybridType = OPTNArray[OPTN_HWConfiguration];
   // Note: This code is for VRx518 not needed, because only one LIF module is available!
   if (!((gus_HybridType >= VRX_HYB_TYPE_A) && (gus_HybridType <= VRX_HYB_TYPE_ABJ)))
   {
      //No LIF module detected
      gus_HybridType = VRX_HYB_TYPE_NONE;
      //if there is not lif module, set the LD mode to be powered down.
      gus_CurrLDMode = LD_PDN;
   }

   gl_afe_fixed_gain = AFE_FIXED_GAIN_ABJ;
   
   //XDSLRTFW-3515 Start
   gs_GhsCarSetCfgInternal = gs_GhsCarSetCfg;
   //if any of A43,A43c,J43,V43p GHS carrier sets is enabled from API, then enable A43,A43c,J43,V43p GHS carrier sets as well
   //This is becoz A43,A43c,J43,V43p GHS carrier sets have same US Car set and different DS Car set and it is necessary to search all DS Car set
      //UpCarSet:9,  17, 25, DnCarSet:40, 56, 64,     //A43 VDSL2 w/US0
      //UpCarSet:9,  17, 25, DnCarSet:257,293, 337,   //A43C Cabinet-Case
      //UpCarSet:9,  17, 25, DnCarSet:72, 88, 96,     //J43 (J,M)
      //UpCarSet:9,  17, 25, DnCarSet:257,383, 511,   //V43P: VDSL1 o POTS
   //if any of B43,B43c,V43I GHS carrier sets is enabled from API, then enable B43,B43c,V43I GHS carrier sets as well
   //This is becoz B43,B43c,V43I GHS carrier sets have same US Car set and different DS Car set and it is necessary to search all DS Car set
      //UpCarSet:37, 45, 53, DnCarSet:72, 88, 96,        //B43 VDSL2 w/US0
      //UpCarSet:37, 45, 53, DnCarSet:257,293, 337,     //B43C: Annex B
      //UpCarSet:37, 45, 53, DnCarSet:257,383, 511      //V43I: VDSL1 o ISDN
   //UpCarSet:7,  9,  9,  DnCarSet:12, 14, 64,        //C43
   //UpCarSet:944,972,999,DnCarSet:257,383, 511,     //V43: VDSL2 wo/US0
   if (gs_GhsCarSetCfg & (CNFG_GHS_CAR_SET_A43 | CNFG_GHS_CAR_SET_A43C | CNFG_GHS_CAR_SET_J43 | CNFG_GHS_CAR_SET_V43P))
   {
      gs_GhsCarSetCfgInternal |= (CNFG_GHS_CAR_SET_A43 | CNFG_GHS_CAR_SET_A43C | CNFG_GHS_CAR_SET_J43 | CNFG_GHS_CAR_SET_V43P);
   }
   else if (gs_GhsCarSetCfg & (CNFG_GHS_CAR_SET_B43 | CNFG_GHS_CAR_SET_B43C | CNFG_GHS_CAR_SET_V43I))
   {
      gs_GhsCarSetCfgInternal |=(CNFG_GHS_CAR_SET_B43 | CNFG_GHS_CAR_SET_B43C | CNFG_GHS_CAR_SET_V43I);
   }
   //XDSLRTFW-3515 End
   
   // Map the GHS tone set bit field to the corresponding index
   for (i=0; i < NUM_CARRIER_SETS; i++)
   {
      // Check if bit position "i" is set
      if ((gs_GhsCarSetCfgInternal & (1 << i)) == (1<< i)) //XDSLRTFW-3515
      {
         gs_GhsCarSetActual = i;
         break;
      }
   }

   // Initialize GHS carrier sets
   // Set RX tone offset to the start tone from which the HW should do the processing, i.e. RTV buffer 0.
   // The highest DS GHS carriers are {257, 383, 511} implies 511 is
   // out of the RTV buffer range since DetectTone use upto 4 tones
   // on either side of the tone to be detected
   // The lowest DS GHS carriers are {12, 14, 64}
   // Hence we shift the tonegroup up by setting gs_RxToneOffset to 8 so
   // that we can decode all DS carrier sets with a single Rx Tone Offset
   // Note gs_NumChannelsPerGroup is 512 and 256 for 4KHz and 8KHz mode respectively.
   gs_RxToneOffset = 0; //XDSLRTFW-2288 (Start_End)
   //XDSLRTFW-4227 (START)  
   //The "gs_GhsCarSetActual" is the bit index. The format below should be 1 left shifted by "gs_GhsCarSetActual". 
   if ((uint16)(1 << gs_GhsCarSetActual) & (CNFG_GHS_CAR_SET_V43 | CNFG_GHS_CAR_SET_V43P | CNFG_GHS_CAR_SET_V43I) )
   //XDSLRTFW-4227 (END)
   {
      gs_RxToneOffset = FIRST_TONE_RTV_BUFF_FOR_V43_GHS_TONE_DET; //XDSLRTFW-2425 (Start_End)
   }

   for (i=0; i<NUM_CARRIER; i++)
   {
      gsa_DnCarSet[i] = gsa_DnCarSetTable[gs_GhsCarSetActual][i];
      gsa_UpCarSet[i] = gsa_UpCarSetTable[gs_GhsCarSetActual][i];
      gsa_DnCarSet[i] -= gs_RxToneOffset;
   }


   //==========================================================================
   // set internal band control variables
   //==========================================================================

   gs_NumOfRxBands = 1;
   gsa_RxBandLeftChannel[0] = 0;
   gsa_RxBandRightChannel[0] = gs_HighestAllowedRxTone;


   //==========================================================================
   // G997 initialization
   //==========================================================================
   gft_Compute_delta = 0;

// Silvano: full init counters are incremented at GHS --> FULL_INIT transition
   // increment total number of full initializations attempted on the line (successful and failed)
// gt_g997_LineInitPerf_Running.l_FullInitCount += 1;
// gt_g997_LineInitPerf_Current_Previous_TR1.t_Current.l_FullInitCount += 1;

   // Initialize G997 related variables
   G997_InitStructureHandler();

   // Set it to unavailable at Link start
   gt_G997_Cntrl.s_LinkState = G997_LINK_UNAVAIL;
   gt_g997_LinePerf_help.s_UAS_L_State = UAS_STATE_LINE_UNAVAIL;
   gt_g997_LinePerf_help.s_10secCnt = 0;

   // if s_Cntr_Reset_Control == 2, reset all counters at link start.
   switch (gt_G997_Cntrl.s_Cntr_Reset_Control)
   {

   case 2:
      G997_InitCounterHandler();
      break;
   }

   // Silvano: we need to clear these data structures here to avoid a burst of CRC/FEC
   // upon reaching showtime due to a previous link drop
   memset(&gt_CRC_Curr_Reading,0, sizeof(G997_NE_ChMonCRC_t));
   memset(gula_RrcCaptureBuffer, 0, sizeof(uint32)*(256));

   //XDSLRTFW-1622(Start_End)
   memset(gula_RrcCaptureBuffer, 0, sizeof(uint32)*(256));      // To reset the buffer

   for(i=0; i<NUM_DATA_PATHS; i++)
   {
      gusa_NonInhibit_CRC_Cntr_NE[i] = 0;
      gusa_NonInhibit_FEC_Cntr_NE[i] = 0;
      gul_FEC_Curr_Reading[i]=0;
   }

   /*  Mei??? the following initialization is done in 2379 right now.
       We need to investigate to see if we need this or not.


      // We need to clear also these data structures here to avoid that LOSS, ES, SES increment
      // upon reaching showtime due to a previous link drop.
      memset(&gt_g997_LinePerf_Sec_NE, 0, sizeof(G997_NE_LinePerf_t));
      memset(&gt_g997_LinePerf_Sec_FE, 0, sizeof(G997_FE_LinePerf_t));
      gt_g997_LinePerf_help.l_1Sec_CRC8_L_count = 0;
      gt_g997_LinePerf_help.s_1Sec_CRC8_FE_count = 0;
      // We need to clear also the ES/SES delay buffers to reset the past memory of the ES/SES,
      // otherwise these two counters will increment at showtime transition because of the previous
      // link drop. Actually the clean solution would be to keep updating the delay buffers during
      // training, but since the training lasts 30sec or more, the delay buffers will always be zero
      // at showtime transition. So we are better off by simply clearing them here.
      gs_SES_Delay_Buf=0;
      gs_ES_Delay_Buf=0;
   */

   gusa_DeltaCRCsecp_NormFactor[LP0] = (uint16)(1<<8);
   gusa_DeltaCRCsecp_NormFactor[LP1] = (uint16)(1<<8);

   //XDSLRTFW-3015 (Start)
   gs_Kp_Slow = 0x200;
   gs_Ki_Slow = 0x4;
   //XDSLRTFW-3015 (End)
   gs_Kp_Fast = 0x2000;
   gs_Ki_Fast = 0x40;

   if (gus_VdslCntlFlag & BITMAP_ENABLE_1BYTE_ANAEXC_SYMBOLS)
   {
      guc_ExchangePhaseRxNumBytesPerSymbol = 1;
   }
   else
   {
      guc_ExchangePhaseRxNumBytesPerSymbol = 2;
   }

   // Apply RX gain calibration to adjust reported LATN/SATN, Hlog, QLN
   gl_afe_fixed_gain = gl_afe_fixed_gain + (int32)((gt_GainCalibration.s_RxGain << 8)/10);


   //Set the data and message path variable
   guc_data_path_tx = (uint8)gt_tx_TPS_Map.s_BCtoLP[BC0];
   guc_ohmsg_path_tx = (uint8)gt_tx_TPS_Map.s_IBITSlp;
   guc_data_path_rx = (uint8)gt_rx_TPS_Map.s_BCtoLP[BC0];
   guc_ohmsg_path_rx = (uint8)gt_rx_TPS_Map.s_IBITSlp;


   gft_NTR_use_212_Clock_units = 0;

   //variables for NTR drift tracking.

   gl_stu_count_212clocks = 0;
   gl_ntr_drift_metric=0;
   gl_ntr_drift_metric_0 = 0x7FFFFFFF;
   gs_enable_ntr_drift_correction=1;
   gl_ntr_drift_correction_amount = -10;


#ifdef   BIT_PATTERN_TEST
   if (TESTArray[TEST_BIT_PATTERN] == TEST_BIT_PATTERN_ENABLE)
   {
      //set the strymon path in bapss
      gs_STR_DbgCntl = STR_DBG_CNTL_DISABLE_TXIIR|STR_DBG_CNTL_DISABLE_SRC|STR_DBG_CNTL_DISABLE_TXINP|STR_DBG_CNTL_DISABLE_TXHB|
                       STR_DBG_CNTL_DISABLE_RXIIR|STR_DBG_CNTL_DISABLE_RXDEC;
   }

#endif //BIT_PATTERN_TEST

   gft_NotFirstDTU = 0;
   gt_ReTXParams.uc_OMSG1_DsReTxEnabled = CO_RETX_INCAPABLE;

//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
   gus_DsUsReTxStatus = RETX_NOT_USED;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)

   gul_SocMsgNotCompliedAmends = 0;

   gs_AllowSaveDataToSram = TESTArray[TEST_StoreSramControl];

   guc_VectorPowerRightShifts = 0; //10;
   gft_ExecuteShadowing = TRUE;

   // XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
   guc_HybridAlgoCtrl = (HYB_ALGO_ECHO_BASED | HYB_ALGO_GAIN_BASED);

   gs_HighestAllowedTxTone = 0;

//    gl_TxTcCount = 0;


///    gul_retransmitted_delta = 0;

   // Init Retransmission related variables
   gft_InitialRRC = TRUE;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   guc_ReTx_DS_D = 1;
   guc_attndr_method = ATTNDR_METHOD_0;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)

   //gul_NackMask = 0;
   // gl_RrcValid = -1;

   //gs_ReTxTable_wr_pointer = -1;

//    memset(gusa_ReTxTable, 0,  sizeof(gusa_ReTxTable));
   //gs_RoundTrip_Estimate = 0;
   //gs_num_RndTrip_Errors = 0;
//    gft_ReTx_FT_CO_Noncompliant = FALSE;
//    gft_EnableReTxDtuBufferWorkaround = FALSE;
//    gul_NE_limit_orig = 0;


   //VNXCOFW-1070: This piece of code has been commented out because, according to new proposed G.Inp Amnd corrigendum,
   //the EFTR_min has to be initialized to 0xFFFFFFFF regardless of configured NetMax
   /*
       //initialize gt_RTX_PMwoThresh.ul_EFTR_min with gul_FE_EFTR_min.
       //The first link after hardreset, gul_FE_EFTR_min should be the theoretical maximum one or the
       //one configured by users through CMV.
       //While for the following links, gul_FE_EFTR_min is equal to the EFTR_min of the previous link,
       //which is always less than theoretical maximum one or the configured one.
       if((gt_RTX_config.us_net_max > 0) && (gul_FE_EFTR_min > (gt_RTX_config.us_net_max<<3)))
         gul_FE_EFTR_min = gt_RTX_config.us_net_max << 3;

       gt_RTX_PMwoThresh.ul_EFTR_min = gul_FE_EFTR_min;

       gt_RTX_PMwoThresh.ul_EFTR_min_prev = 0;
   */

   //gt_RTX_PMwoThresh.ul_cntErrorFreeBits= 0;
   //gt_RTX_PMwoThresh.ul_cntErrorFreeBits_prev = 0;

} //InitGlobalVarsAtLinkStart()


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InitSeltStateGlobals(void)
*
*  This function initializes the buffers and variables used during SELT
*
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------*/
