/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitGlobalVars_PowerUp.c
*
*   This file contains functions which initialize global variables at start-up.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// History
//
// 23/08/2012 VENKATESH: Workaround for XDSLRTFW-506 Lower DS Rates with INP > 2 cases & No Connect with INP = 16
//                       CMV INFO 232 Index 1 Bit 0x4 included, Default Enabled
//                    Grep for XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
//
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new function 'ConfigVdslFeatureMap()' that provides info on the feature subset
//                 supported by VDSL FW. This feature map can be read out by SW using CMV 'DSL 20'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new function 'ConfigAdslFeatureMap()' that provides info on the feature subset
//                 supported by ADSL FW. This feature map can be read out by SW using CMV 'DSL 19'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
// 28/05/2013 Varun:initialized structure delimiters Debug Buffer
//            Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 26/05/2014 Varun:initialized structure of Scalar read feature
//            Grep for XDSLRTFW-1777
// 11/08/2014 Fuss: calibration of BJ Hybrid and oPOTS config
//            Grep for XDSLRTFW-1898
//
// 20/12/2017 Stefan Krause:  XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
// - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
// - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
// - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
//     Grep for XDSLRTFW-3665
//
//14/12/2018 Sriram Shastry :XDSLRTFW-4052 : Low upstream data rates in 30a profile
//   Improvement for Kl0 alogorithm estimation for  30a profile
//   Control option to use AELEM for reporting KL0
//   Control option to set  Kl0 in RMSG1
//   Control option to set AELEM method instead of  KL0 method
//   Control option to Enable/disble psdpreprocessing (inter polation) 
//   Initialize AELEM structure (gt_AELEM_UPBOInfo) and rename the  variable
//  Grep for XDSLRTFW-4052
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"                     // contains: #include "socmessage.h"
#include "ghs.h"
#include "eoc.h"
#include "cmv.h"
#include "InitGlobalVars.h"
#include "vdsl_xception.h"
#include "vdsl_state.h"
#include "profile.h"
#include "BitSwapDecision_VDSL2.h"
#include "DetectSignalHandler.h"
#include "tdq_init.h"
#include "GenFramingParams_VDSL2.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "DshInterface.h"
#include "Ppe_memmap.h"
#include "LL_IOf.h"

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
#include "ADSLFeatureMap.h"
#include "VDSLFeatureMap.h"
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitGlobalVars_PowerUp(void)
*
*   This function initializes all global variables at start-up.
*   This function is executed only once at reset, not executed at modem restart.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void InitGlobalVars_PowerUp(void)
{
   int16 i;
   uint32 ul_addr, ul_data;
   uint32 ul_idx; // XDSLRTFW-4052(Start_End)
   // general modem configuration / VDSL-mode only configurations
   gus_ModemMode = CPE_MODE;

   //==============================================================================
   //GHS variables
   //==============================================================================
   gft_GotoFailStateOnTimeOut_FromHandshake = FALSE;

   // set default GHS carrier set configuration to B43, V43
   gs_GhsCarSetCfg = CNFG_GHS_CAR_SET_A43 | CNFG_GHS_CAR_SET_B43 | CNFG_GHS_CAR_SET_V43;
   gs_GhsCarSetCfgInternal = gs_GhsCarSetCfg;//XDSLRTFW-3515

   gs_TxPathAfeDfeCustomSettings = 0;

   /*  SNR's (in dB) required for QAM */
   gsa_ConstellationSNR[0] = 0x0B4F;  /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[1] = 0x0B4F;  /*  11.31 dB =  1 bit  */
   gsa_ConstellationSNR[2] = 0x0E51;  /*  14.32 dB =  2 bits */
   gsa_ConstellationSNR[3] = 0x131C;  /*  19.11 dB =  3 bits */
   gsa_ConstellationSNR[4] = 0x154F;  /*  21.31 dB =  4 bits */
   gsa_ConstellationSNR[5] = 0x1875;  /*  24.46 dB =  5 bits */
   gsa_ConstellationSNR[6] = 0x1B8A;  /*  27.54 dB =  6 bits */
   gsa_ConstellationSNR[7] = 0x1E97;  /*  30.59 dB =  7 bits */
   gsa_ConstellationSNR[8] = 0x219C;  /*  33.61 dB =  8 bits */
   gsa_ConstellationSNR[9] = 0x24A1;  /*  36.63 dB =  9 bits */
   gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
   gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
   gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
   gsa_ConstellationSNR[13] = 0x30AE; /*  48.68 dB = 13 bits */
   gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
   gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

   //=========================================================================
   // VDSL band plan
   //=========================================================================

   //Note: This set of initialization should only be done for CO build
   //and CPE will receive this information from the messages.
   //However, in order to support the test modes where the modems do not
   //go though the training phase (such as sleep state test, showtime test),
   //thus, we perform this initialization for both CO and CPE.

   // Initialize DS and US Max nominal PSD values
   gt_PwrConfigParamCMV.s_Dn_MaxNomPSD = 595; /*Initialize Digital Tx Gain scalar
                               is specified in tenth of dB */
   gt_PwrConfigParamCMV.s_Up_MaxNomPSD = 595; /*Initialize Digital Tx Gain scalar
                            is specified in tenth of dB */
   gt_PwrConfigParamCMV.s_Dn_InitialPsdCeiling = 520; /* specified in tenth of dB */
   gt_PwrConfigParamCMV.s_Up_ProposedPsdCeiling = 0x1000; /* special value indicates no limit ob US PSD ceiling level  */

   gt_PwrConfigParamCMV.s_Dn_MaxNomAggrPwr = 255;   //25.5 dBm - larger than max spec'd value so FW will limit based on bandplan
   gt_PwrConfigParamCMV.s_Up_MaxNomAggrPwr = 255;   //25.5 dBm - larger than max spec'd value so FW will limit based on bandplan

   //Note: This set of initialization should only be done for CPE build
   //and CO will receive this information from the messages.
   //However, in order to support the test modes where the modems do not
   //go though the training phase (such as sleep state test, showtime test),
   //thus, we perform this initialization for both CO and CPE.
   gt_PwrConfigParamCMV.s_Up_InitialPsdCeiling = INITIAL_UP_PSDCEIL; /* specified in tenth of dB */
   gt_PwrConfigParamCMV.s_Dn_ProposedPsdCeiling = 0x1000; /* special value indicates no limit ob DS PSD ceiling level */
   //XDSLRTFW-1777(START_END)
   //initialize the Rx EOC Scalar read structure,request for FE ACT INP if triggered
   gt_OlrPm_RxOvhdMsgInfoInput.uc_TestParameterId=FE_ACTUAL_INP_IFEC;


   if (guc_PortMode == 0)
   {
      gt_TxBandControl.us_NumberOfBands = 2 ;
      gt_TxBandControl.ut_BandRecord[0].us_FirstTone = VDSL_BAND1_LEFT_CHANNEL;
      gt_TxBandControl.ut_BandRecord[0].us_LastTone = VDSL_BAND1_RIGHT_CHANNEL;
      gt_TxBandControl.ut_BandRecord[1].us_FirstTone = VDSL_BAND3_LEFT_CHANNEL;
      gt_TxBandControl.ut_BandRecord[1].us_LastTone = VDSL_BAND3_RIGHT_CHANNEL;

      gt_RxBandControl.us_NumberOfBands = 3;
      gt_RxBandControl.ut_BandRecord[0].us_FirstTone = VDSL_BAND0_LEFT_CHANNEL;
      gt_RxBandControl.ut_BandRecord[0].us_LastTone = VDSL_BAND0_RIGHT_CHANNEL;
      gt_RxBandControl.ut_BandRecord[1].us_FirstTone = VDSL_BAND2_LEFT_CHANNEL;
      gt_RxBandControl.ut_BandRecord[1].us_LastTone = VDSL_BAND2_RIGHT_CHANNEL;
      gt_RxBandControl.ut_BandRecord[2].us_FirstTone = VDSL_BAND4_LEFT_CHANNEL;
      gt_RxBandControl.ut_BandRecord[2].us_LastTone = VDSL_BAND4_RIGHT_CHANNEL;
   }
   else
   {
      gt_TxBandControl.us_NumberOfBands = 1 ;
      gt_TxBandControl.ut_BandRecord[0].us_FirstTone = VDSL_BAND1_LEFT_CHANNEL;
      gt_TxBandControl.ut_BandRecord[0].us_LastTone = VDSL_BAND1_RIGHT_CHANNEL;

      gt_RxBandControl.us_NumberOfBands = 1;
      gt_RxBandControl.ut_BandRecord[0].us_FirstTone = VDSL_BAND0_LEFT_CHANNEL;
      gt_RxBandControl.ut_BandRecord[0].us_LastTone = VDSL_BAND0_RIGHT_CHANNEL;
   }

   // XDSLRTFW-3741 Start_End
   memset(&gt_DbgAllowedToneInfo, 0, sizeof(DbgAllowedToneInfo_t));


   gs_MIN_BAND_METRIC = MIN_BAND_METRIC;
   gs_MIN_BAND_METRIC_START = MIN_BAND_METRIC_BAND_START;

   gft_DisableSRCBugWorkAround = 1;
   gs_TiedClocks    = 0;

   gft_StrictSynchroDetect = 0;
   memset(&gla_RxMessageTimer, 0, sizeof(gla_RxMessageTimer));

   //=========================================================================
   // LineDriver and PowerDown variables
   //=========================================================================
   // XDSLRTFW-2067 / XDSLRTFW-3611
   gus_LD_Mode = LD_AUTOSEL;           // LD gets be selected by FW
   gus_CurrLDMode = LD_PDN;            // By default Line Driver is in Power down mode

   // Power Saving Flags
   gft_PowerDownON = 1;

   //=========================================================================
   // Hybrid training variables
   //=========================================================================
   gusa_SwitchingThreshTxBands[SWITCH_TO_1BAND_IDX0] = LATN_TRESH_SWITCH_TO_1BAND;
   gusa_SwitchingThreshTxBands[SWITCH_TO_2BAND_IDX1] = LATN_TRESH_SWITCH_TO_2BAND;

   gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_X_HYB]   = LATN_TRESH_SWITCH_TO_PROFILE_X_HYB;
   gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_17_HYB]  = LATN_TRESH_SWITCH_TO_PROFILE_17_HYB;
   gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_8_HYB]   = LATN_TRESH_SWITCH_TO_PROFILE_8_HYB;
   gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_US0_HYB] = LATN_TRESH_SWITCH_TO_PROFILE_US0_HYB;

   gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX0_15PF]     = LATN_TRESH_ACE_MODE_15PF;
   gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX1_30PF]     = LATN_TRESH_ACE_MODE_30PF;
   gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX2_52DOT5PF] = LATN_TRESH_ACE_MODE_52DOT5PF;
   gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX3_15PF_LR]  = LATN_TRESH_ACE_MODE_15PF_LR;
   gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX4_7DOT5PF]  = LATN_TRESH_ACE_MODE_7DOT5PF;
   gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX5_OFF]      = LATN_TRESH_ACE_MODE_OFF;

   gus_SwitchingCriterionVal = 0;
   guc_EnableHybCapacitorSearch = (ENABLE_CAP_SEARCH_CPC|ENABLE_CAP_SEARCH_CPB);

   guc_HybridEchoAccu = (4+1);
   gs_HybTrStepSize = 1;
   gs_HybTrIndexDbg = -1;
   guc_ForceNumHybrid = 0;
   gs_HybNumUsBand = 0;

   // !! Debug code to test maximum bits per tone per band, i.e. max constellation per band!!
   for(i=0; i<MAX_NUM_RX_BANDS; i++)
   {
      gsa_RxMaxConstSize[i] = (int16)0xffff;
   }

   gus_HybridType = VRX_HYB_TYPE_ABJ;  // Normally this should not be needed! Secure code only!
   // XDSLRTFW-3369 (Start_End)
   gl_HybTrSymcnt_start = 0;

   //=========================================================================
   // PGA configuration
   //=========================================================================
   //PD_DB is changed according to the Crest factor 6.8
   gs_PGA_margin_AGC1 = (int16)0xFF00;  //-1dB
   gs_PGA_margin_AGC2 = (int16)0x0200;  //+2dB

   // XDSLRTFW-3696 (Start_End)
   // This correction is reverting the "s_ADC_Adjust_Gain_dB"!
   gsa_PgaCorrection = +297;

   gs_Pga_XtakNoiseScale = 0;
   gs_Pga_XtakNoiseScaleCtrl = 0;

#if defined(VR9_BRINGUP_DBG)
   gft_BypassPGATrain = FALSE;
   gft_SkipInitAfeHSExit = FALSE;
#endif

   //=========================================================================
   // SNR margin configuration (DS/US target/min/max)
   //=========================================================================
   gt_SnrMgnConfig.s_TARSNRMds = DEFAULT_TAR_SNR_MARGIN*10; // in unit of 0.1 dB
   gt_SnrMgnConfig.s_TARSNRMus = DEFAULT_TAR_SNR_MARGIN*10; // in unit of 0.1 dB
   gt_SnrMgnConfig.s_MAXSNRMds = DEFAULT_MAX_SNR_MARGIN*10; // in unit of 0.1 dB
   gt_SnrMgnConfig.s_MAXSNRMus = DEFAULT_MAX_SNR_MARGIN*10; // in unit of 0.1 dB
   gt_SnrMgnConfig.s_MINSNRMds = DEFAULT_MIN_SNR_MARGIN*10; // in unit of 0.1 dB
   gt_SnrMgnConfig.s_MINSNRMus = DEFAULT_MIN_SNR_MARGIN*10; // in unit of 0.1 dB

   //=========================================================================
   // NM (noise margin) change
   //=========================================================================
   gt_NoiseMarginChange.s_NM_Delta = 0;
   gt_NoiseMarginChange.s_NM_Ctrl = Disable_All_NMS_Related_Features;                        // Disable NMS by default
   gt_NoiseMarginChange.s_max_NMS_Gain_ToBe_considered = NSM_ADD_AGC_GAIN;                   // Max limit of NMS gain
   gt_NoiseMarginChange.s_min_NMS_Gain_ToBe_considered = NMS_MINIMUM_GAIN_TOBE_CONSIDERED;   // XDSLRTFW-2393
   gt_NoiseMarginChange.s_max_Used_NMS_Gain = NSM_ADD_AGC_GAIN;                              // Default 3dB gain is used
   // By Default this is 0, for longer loops and noise dominated loops make this to 1dB, i.e.
   // if a criteria (XDSLRTFW-2393) holds true then s_min_Used_NMS_Gain = s_min_NMS_Gain_ToBe_considered!
   // Note: To debug with a different min NMS value then both variables s_min_Used_NMS_Gain and
   //       s_min_NMS_Gain_ToBe_considered must be set to the same value!
   gt_NoiseMarginChange.s_min_Used_NMS_Gain = 0;

   //==========================================================================
   // Flags and indicators
   //==========================================================================
#ifdef DEBUG_TRAIL
   // Init Debug Trail Control/Status
   memset(&gt_debugTrailControl, 0, sizeof(DebugTrailControl_t));
   memset(&gt_debugTrailStatus, 0, sizeof(DebugTrailStatus_t));
#endif // DEBUG_TRAIL

#ifdef DEBUG_TRACES
   //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //Init Debug buffer
   memset(&gt_debugBufStatus,0,sizeof(DebugBufStatus_t));

   memset(&gt_DebugBuffSymbol,0,sizeof(DebugShowTimeBuffSymbol_t));
   memset(&gt_DebugBuffSuperframe,0,sizeof(DebugShowTimeBuffSuperframe_t));

   memset(&gt_DebugBufferStatus,0,sizeof(DebugBufferStatus_t));

   // Init of gt_DebugBuffControl
   memset(&gt_DebugBuffControl,0,sizeof(DebugBufferControl_t));
   gt_DebugBuffControl.s_debugBuffer_STCaptureXSymbol = LOG_PER_X_SYMBOL_DEBUG_BUFFER;
   // Disable US ReTx log in showtime and Enable normal showtime+Training logging by default
   gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData = (US_RETX_ONLY_CAPTURE_DISABLE_MASK |
         SHOW_TIME_EVENT_DISABLE_MASK);
//   gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData = (SHOW_TIME_CAPTURE_DISABLE_MASK |
//                                                              GHS_TRAINING_CAPTURE_DISABLE_MASK);
   //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

   gt_DebugBuffSuperframe.l_sync_structure_start_delimiter=DEBUG_BUFFER_DELIMITER_SYC_SYM_START;

   //XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES

#ifdef DEBUG_TRAIL
   //gt_debugTrailControl.s_logType[0] = DEBUG_TRAIL_STATES_ENABLE; //=0x0001, enable state trail log
   gt_debugTrailControl.s_logType[0] = DEBUG_TRAIL_SHOWTIME_EVENTS_ENABLE;   //=0x800, enable showtime event log
// Debug code for DCT - start
//   gt_debugTrailControl.s_logType[0] = 0;   //disable log
// Debug code for DCT - end
   gt_debugTrailControl.s_logType[1] = 0;
   gt_debugTrailControl.s_toneIndex = 10;
   gt_debugTrailControl.s_numTones = 1;

   //Set the showtime events to log
   gt_debugTrailControl.s_ShowtimeEventControl = (DEBUG_TRAIL_SHOW_EVENTS_NE_CRC_ENABLE |
         DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_ENABLE |
         DEBUG_TRAIL_SHOW_EVENTS_NE_LOM_ENABLE |
         DEBUG_TRAIL_SHOW_EVENTS_FE_IB_CHANGE_ENABLE |
         DEBUG_TRAIL_SHOW_EVENTS_NE_SHOWFAIL_ENABLE |
//                                                  DEBUG_TRAIL_SHOW_EVENTS_FE_SHOWFAIL_ENABLE |
         DEBUG_TRAIL_SHOW_EVENTS_PILOT_CHANGE_ENABLE |
         DEBUG_TRAIL_SHOW_EVENTS_MICROINT_ENABLE);

   gt_debugTrailControl.s_ShowtimeCounterControl = 0;
   gt_debugTrailControl.s_ShowtimeCounterPeriod = 1;
   gt_debugTrailControl.s_CounterPeriod = -1;
   gt_debugTrailControl.s_cyclicTrailUpdate = 1;

   gt_debugTrailStatus.s_debugTrailSize = STATES_TRAIL_LENGTH;
//   memset(gsa_StatesTrail, 0, sizeof(int16)*STATES_TRAIL_LENGTH);
#endif // DEBUG_TRAIL
#ifdef DEBUG_TRACES
   //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //initialize the Debug buffer pointers

   //internal buffer pointer
// The pragma is ARC only!
#pragma Off(Behaved)
   gpusa_debugBuff = gt_DebugBuff.gusa_DebugBuf;
#pragma Pop(Behaved)
//   memset(gpusa_debugBuff, 0, sizeof(uint16)*(DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES/2));

   //XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   //SDRAM buffer pointer
   gpuca_offChipBuff = guca_offChipDebugBuff;
   //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif //#ifdef DEBUG_TRACES

   // Init Debug Trail Control/Status
   memset(&gt_debugStreamControl, 0, sizeof(DebugStreamControl_t));
   // Default is Streaming Disabled
   memset(&gt_debugStreamConfigure, 0, sizeof(DebugStreamConfigure_t));

   // Disable debug streams per default
   gt_debugStreamControl.Parameter0 = 0x0;

   // enabling all for debugging
   // the defaults are not that important because the Masks are written at connect from Tracee or DebugStreamDump anyways
   gt_debugStreamConfigure.Mask1 = 0xFFFFFFFF;
   gt_debugStreamConfigure.Mask2 = 0xFFFFFFFF;
   gt_debugStreamConfigure.Mask3 = 0xFFFFFFFF;
   gt_debugStreamConfigure.Mask4 = 0xFFFFFFFF;
   gt_debugStreamConfigure.Mask5 = 0xFFFFFFFF;
#ifdef ILV_DBG_BUFFER
   //********************** ILV DBG Buffer ***********************************
   gpsa_IlvDbgBuffer = &gsa_TrnVectoringBuffer[0];  //initialize the IlvDbgBuffer to TrnVectoringBuffer at the beginning. The buffer moves to interleaver at showtime entry
                                               // ATTENTION: The BUFFER gets corrupted during R-ERRROR-FEEDBACK
                                               //(int16 *)(void *)glp_IlvDbgBufferStart;
   gs_IlvDbgBufferStartTrigger = VDSL2_SHOWTIME_RX_WITH_TC_SYNC;
   gs_IlvDbgBufferStopTrigger = -1;
   gft_WriteToIlvDbgBuffer = FALSE;
   gs_IlvDgbBufferContentSelector = ILVDBG_PLL_ANYLYSIS; //(ILVDBG_OP_VECT1_DETECT_DBG | ILVDBG_OP_VECT1_ALIGNMENT_DBG)
   gft_IlvDbgBufferPingPong = PING;
   gft_IlvDbgBufferPingPong_Prev = PING;
   gs_IlvDbgBufferControl = 0x000F;
   gs_IlvDbgBufferBytesPerCycle = 36;
   // Calculate the modulo of BytesPerCycle for Ping/Pong buffer size
   gs_IlvDbgBytesPerCycleModSize = ((ILV_DBG_BUFFER_SIZE>>1) % gs_IlvDbgBufferBytesPerCycle);
   gs_IlvDbgBufferDecimatorCnt = 0;
   gs_IlvDbgBufferDecimator = 4;
#endif //ILV_DBG_BUFFER
   gs_IlvDbgBufferWriteIdx = 0;


   for (i=0; i < RX_MAX_NUM_TONES; i++)
   {
      gsa_PsdPerTone[i] = -1400;
   }

   //==========================================================================
   // initialize default modem configuration
   //==========================================================================
   gft_DisableAdcCalibration = TRUE;
   gft_ModeSelectAdcCalibration = 0;

   //==================================================================
   // Initialize TPS-TC Bearer Channel Control
   //==================================================================
   {
      int16 s_TpsTcType;
      TPS_TC_Type_t *pt_TpsTcType;
      signed int s_bc;

      for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
      {
         // Initialize supported Bearer Channel Control structures
         gta_DsBearerChannel[s_bc].s_Control = TPS_TC_DISABLED;
         gta_UsBearerChannel[s_bc].s_Control = TPS_TC_DISABLED;

         //Note: the order of type being stored is: PTM, ATM and STM
         for (s_TpsTcType=0; s_TpsTcType < MAX_TPS_TC_TYPE_API; s_TpsTcType++)
         {
            // DS configuration
            pt_TpsTcType = &gta_DsBearerChannel[s_bc].ta_TpsTcType[s_TpsTcType];
            pt_TpsTcType->ul_MinNetDataRate = DEFAULT_MIN_RATE;                   // in multiple of 4 kbps
            pt_TpsTcType->ul_MaxNetDataRate = DEFAULT_MAX_RATE;                   // in multiple of 4 kbps
            pt_TpsTcType->ul_MinResNetDataRate = DEFAULT_MIN_RATE;                // in multiple of 4 kbps
            pt_TpsTcType->s_MaxLatency = DEFAULT_MAX_INLV_DELAY;                  // in unit of ms
            pt_TpsTcType->uc_MaxBER = DEFAULT_MAX_BER;
            pt_TpsTcType->uc_TPSTCoptions = DEFAULT_TPSTC_OPTIONS;                // disable short packet and EFM preemption since
                                                                                  // no DSLAM support these feature
            pt_TpsTcType->s_IMAxINP = DEFAULT_INP;

            // US configuration
            pt_TpsTcType = &gta_UsBearerChannel[s_bc].ta_TpsTcType[s_TpsTcType];
            pt_TpsTcType->ul_MinNetDataRate = DEFAULT_MIN_RATE;                   // in multiple of 4 kbps
            pt_TpsTcType->ul_MaxNetDataRate = DEFAULT_MAX_RATE_US;                // in multiple of 4 kbps
            pt_TpsTcType->ul_MinResNetDataRate = DEFAULT_MIN_RATE;                // in multiple of 4 kbps
            pt_TpsTcType->s_MaxLatency = DEFAULT_MAX_INLV_DELAY;                  // in unit of ms
            pt_TpsTcType->uc_MaxBER = DEFAULT_MAX_BER;
            pt_TpsTcType->uc_TPSTCoptions = DEFAULT_TPSTC_OPTIONS;
            //pt_TpsTcType->uc_TPSTCoptions = 3; //use the short packet and EFM preemption
            pt_TpsTcType->s_IMAxINP = DEFAULT_INP;
         }


#ifdef PPE_ENGINE
         //these variables should be configured by ME
         gula_DREG_AT_CFG_Cnfg[s_bc] = 0;
         gula_DREG_AR_CFG_Cnfg[s_bc] = 0;
#endif //PPE_ENGINE
      }

   // Initialize supported and preferred TPS TC types
//XDSLRTFW_521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 (Start)
//Enabled ATM along with PTM
      gta_DsBearerChannel[BC0].s_Control = TPS_TC_TYPE_PTM | TPS_TC_TYPE_ATM; //snv
      gta_UsBearerChannel[BC0].s_Control = TPS_TC_TYPE_PTM | TPS_TC_TYPE_ATM; //snv

//XDSLRTFW_521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 (End)
   }

   //==================================================================
   // Initialize PMS-TC Latency Path Control
   //==================================================================
   {
      PMS_TC_LatencyPath_t *pt_PmsTcLp;
      signed int s_lp;

      for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
      {
         // DS configuration
         pt_PmsTcLp = &gta_DsLatencyPath[s_lp];
         pt_PmsTcLp->ul_MaxDataRate = DEFAULT_MAX_RATE;    // in multiple of 4 kbps
         pt_PmsTcLp->s_MaxR = DEFAULT_MAX_CHECKBYTE;
         if (s_lp == INLV)
         {
            pt_PmsTcLp->s_MaxD = DEFAULT_MAX_INLV_DEPTH;
         }
         else
         {
            pt_PmsTcLp->s_MaxD = 1;
         }

         // US configuration
         pt_PmsTcLp = &gta_UsLatencyPath[s_lp];
         pt_PmsTcLp->ul_MaxDataRate = DEFAULT_MAX_RATE;    // in multiple of 4 kbps
         pt_PmsTcLp->s_MaxR = DEFAULT_MAX_CHECKBYTE;
         if (s_lp == INLV)
         {
            pt_PmsTcLp->s_MaxD = DEFAULT_MAX_INLV_DEPTH;
         }
         else
         {
            pt_PmsTcLp->s_MaxD = 1;
         }
      }
   }

   //-----------------------------------------------------------------------
   // Min Overhead Rate is controllable via CMV.  The internal variable
   // guc_Ds(Us)MinMsgOHR is initialized here, but re-initialized at link
   // start based on gt_MinMsgOHRConfig structure, which in turn is
   // configurable via CMV
   //-----------------------------------------------------------------------
   guc_DsMinMsgOHR = DEFAULT_MIN_OHMSG_RATE-1;         //The value exchanged in message is always in the format of [n-1 kbps]
   gt_MinMsgOHRConfig.us_DsMinMsgOHR = DEFAULT_MIN_OHMSG_RATE;   // CMV API always takes the input as [n kbps] instead of [n-1 kbps]

   guc_UsMinMsgOHR = DEFAULT_MIN_OHMSG_RATE-1;         //The value exchanged in message is always in the format of [n-1 kbps]
   gt_MinMsgOHRConfig.us_UsMinMsgOHR = DEFAULT_MIN_OHMSG_RATE;   // CMV API always takes the input as [n kbps] instead of [n-1 kbps]


   //==================================================================
   // Map BC0 to LP0/INLV, and disable LP1/FAST by default
   //==================================================================
   gt_tx_TPS_Map.s_BCtoLP[BC0] = INLV;
   gt_tx_TPS_Map.s_BCtoLP[BC1] = DISABLED_LP;
   gt_tx_TPS_Map.s_IBITSlp = INLV;

   gt_rx_TPS_Map.s_BCtoLP[BC0] = INLV;
   gt_rx_TPS_Map.s_BCtoLP[BC1] = DISABLED_LP;
   gt_rx_TPS_Map.s_IBITSlp = INLV;

   //==================================================================
   //Clear the actual TPS/PMS strucutures
   //==================================================================
   memset(gta_DsBearerChanAct, 0, sizeof(TPS_TC_BearerChanAct_t)*NUM_BEARER_CHANNELS);
   memset(gta_UsBearerChanAct, 0, sizeof(TPS_TC_BearerChanAct_t)*NUM_BEARER_CHANNELS);
   memset(gta_DsLpAct, 0, sizeof(PMS_TC_LatencyPathAct_t)*NUM_DATA_PATHS);
   memset(gta_UsLpAct, 0, sizeof(PMS_TC_LatencyPathAct_t)*NUM_DATA_PATHS);

   //==================================================================
   // Initialize VDSL2 Profile Control Structure. Inturn used to initialize VDSL2 NE standard info CL structure
   //==================================================================
   // Standard info "Profile" NPar3 octets 1 and 2 for VDSL2
   gt_ProfileControl.us_ProfileSupported = CNFG_V2_PROFILE_ALL_MASK;

   // Used to select profile in MS message
   gt_ProfileControl.us_ProfilePreferred = CNFG_V2_PROFILE_17A_MASK;

   gt_ProfileControl.ul_AnxAUS0PsdSupported = (CNFG_V2_ANXA_US0_EU_ALL_MASK | CNFG_V2_ANXA_US0_IN_12B_MASK | CNFG_V2_ANXA_US0_IN_17A_MASK);   // Standard info "Annex A US0" Npar3 octets 1-5 for VDSL2
   gt_ProfileControl.ul_AnxAUS0PsdPreferred = CNFG_V2_ANXA_US0_NONE_MASK;   // Used to select Annex A US0 Psd Mask in MS message

   gt_ProfileControl.us_AnxBUS0PsdSupported = CNFG_V2_ANXB_US0_ALL_MASK;   // Standard info "Annex B US0" Npar3 octets 1-2 for VDSL2
   gt_ProfileControl.us_AnxBUS0PsdPreferred = CNFG_V2_ANXB_US0_NONE_MASK;   // Used to select Annex B US0 Psd Mask in MS message

   gt_ProfileControl.us_AnxCUS0PsdSupported = CNFG_V2_ANXC_US0_ALL_MASK;   // Standard info "Annex C US0" Npar3 octets 1 for VDSL2
   gt_ProfileControl.us_AnxCUS0PsdPreferred = CNFG_V2_ANXC_US0_NONE_MASK;   // Used to select Annex C US0 Psd Mask in MS message

   // XDSLRTFW-2151 (Start)
   //==================================================================
   // Initialize VDSL2 ReTx support
   //==================================================================
   // XDSLRTFW-1693 (Start_End) - G.998.4 Extensions
#ifdef VECTORING_BUILD
   // Enable Amd3, Force Extended memory and DS ReTX capablity by default
   gt_ReTXParams.t_ReTXConfigCMV.us_DsUsReTxCapable = (uint16)(CNFG_RETX_EXTENDED_MEMORY_AMD3 | CNFG_RETX_EXTENDED_MEMORY_FORCE_SOC |
                                                               CNFG_CPE_DS_US_RETX_CAPABLE |
                                                               CNFG_DS_INTRA_DTU_ILV_CAPABLE | CNFG_US_INTRA_DTU_ILV_CAPABLE);
#else
   // Enable Force Extended memory and DS ReTX capablity by default
   gt_ReTXParams.t_ReTXConfigCMV.us_DsUsReTxCapable = (uint16)(CNFG_RETX_EXTENDED_MEMORY_FORCE_SOC |
                                                               CNFG_CPE_DS_US_RETX_CAPABLE |
                                                               CNFG_DS_INTRA_DTU_ILV_CAPABLE | CNFG_US_INTRA_DTU_ILV_CAPABLE);
#endif // VECTORING_BUILD
   // XDSLRTFW-2151 (End)

   gt_UPBOControl.s_control = 2;   // UPBO Boost Mode = ENABLED

   //========================================================================
   //Init the VDSL2 training state lengths
   //========================================================================

   //CO requested training lengths
   //CPE requested training length
   guc_RtReq_EcLength = VTU_R_EC_TRAIN_LENGTH;         //VTU-R EC training length in multiple of 64
   guc_RtReq_TeqLength = VTU_R_TEQ_TRAIN_LENGTH;      //VTU-R TEQ training length in multiple of 64
   guc_RtReq_CoTeqLength = VTU_R_O_TEQ_TRAIN_LENGTH;   //VTU-O TEQ training length in multiple of 64
   guc_RtReq_PeriodicLength = VTU_R_PERIODIC_LENGTH;   //Periodic signal length in multiple of 64
   guc_RtReq_RPTrainLength = VTU_R_P_TRAIN_LENGTH;      //duration of R-P-Training in multple of 64

   //Disable the limit on the maximum Lp
   gl_MaxLpLimit = -1;

   //Mei: for VR9, we need to use 70, otherwise we see CRCs at about 2300m for 17b profile
   //gs_PilotSelectOffset = 70;
   //Note: using of 70 caused the BT/ECI link drop issue (around 500m)
   //we need to retest this change to see if it is ok or not at 2300m for 17b profile
   gs_PilotSelectOffset = 50;
   gs_Kl0_thresh_pilot_select = 0*10; // 0 dB

   //Disable PLL during the transition to or from periodic state
   gs_PeriodicPllDisable = 1;

   //Enable the frame realignment during the transition to/from periodic states
   gs_EnablePeriodicFrameRealign = 1;

   //=========================================================================
   // Clear Electrical Length Estimate (kl0)
   //=========================================================================
   //XDSLRTFW-1388 (Start_End)
   gs_GuardBinKl0 = KL0_START_BIN;  // KL0 Start bin = 50

   gs_kl0_BoostAmount = 10;         // 1 dB in 0.1 dB step

   gft_DisableKl0PreProc = 0;
   gft_EnableKl0Boost = 0;          //snv
   gs_Kl0PreProcDone = 0;

   gsa_IOP_LATN_Kl0[0] = 0; //Initialize to 0 for CMV Control

   // Value to offset the computed Electrical length (in 0.1 dB format)
   gs_kl0_offset = -15; //Temporary: Until we figure out why kl0 estimation is off 1.5 dB over all loop lengths

   // XDSLRTFW-3344 (Start)
   // Initializng the structures with 0x3FF (for Hlog)  and 0xFF (for QLN).
   for (i = 0; i < RX_MAX_NUM_TONES; i++)
   {
      gsa_RxHLog_PerTone_Internal[i] = 0x03FF;
      guca_QLN_PerTone_Internal[i] = 0xFF;
   }
   // XDSLRTFW-3344 (End)

   // XDSLRTFW-3707 (Start_End)
   // Low US DR with AELEM mode 3 / ELE_DS1 is low compared to DS2 and DS3 (start)
   // We have reduced the RxPathGain by 1.16 dB which directly impacts Rx QLN, Rx HLOG LATN and SATN.
   // This reduces the Rx QLN and HLOG by 1.16 dB and increases SATN and LATN value by 1.16 dB.
   // Since DS band 1 LATN value is used for loop length estimation, +1.16dB correction is needed wherever
   // LATN is used to maintain the consistency of the FW behavior.
   gs_QlnHlogCorrection = +297;

   //=======================================================================
   //Inventory variables
   //=======================================================================

   // GHS Vendor ID
   memset(&gt_ne_VendorInformation, 0, sizeof(gt_ne_VendorInformation));
   memset(&gt_fe_VendorInformation, 0, sizeof(gt_fe_VendorInformation));

   // Aux Info - mapped to CMV
   for (i=0; i<sizeof(guca_ne_AuxInvInfo); i++)
   {
      guca_ne_AuxInvInfo[i]=0;
   }
   for (i=0; i<sizeof(guca_fe_AuxInvInfo); i++)
   {
      guca_fe_AuxInvInfo[i]=0;
   }

   // Overhead Messaging Inventory
   memset(guca_ne_SystemVendorID, 0, sizeof(guca_ne_SystemVendorID));
   memset(guca_ne_SystemVersionNum, 0, sizeof(guca_ne_SystemVersionNum));
   memset(guca_ne_SystemSerialNum, 0, sizeof(guca_ne_SystemSerialNum));

   memset(guca_fe_SystemVendorID, 0, sizeof(guca_fe_SystemVendorID));
   memset(guca_fe_SystemVersionNum, 0, sizeof(guca_fe_SystemVersionNum));
   memset(guca_fe_SystemSerialNum, 0, sizeof(guca_fe_SystemSerialNum));

   //=======================================================================
   //Interop/debug variables
   //=======================================================================
   gs_dbgLogSocMsg = 0x7FFF;      //default not to log SOC message
   gs_dbgLogSocMsgPause = 0;      //used to pause logging during AutoRepeat messages

   gft_ReduceChDiscoveryRxWindowLength = FALSE;
   gs_DbgRecnfgCpCsBeta = (TX_TIMING_ADVANCE_DELAY_EN|TX_TIMING_ADVANCE_DELAY_2STEP_EN);

   gs_DbgRxWindowLength = 0;
   gs_DbgTxBetaLength = -1;
   gs_DbgTxCPLength = -1;
   gs_DbgTxCSLength = -1;
   gs_DbgRxBetaLength = -1;
   gs_DbgRxCPLength = -1;
   gs_DbgRxCSLength = -1;

   // XDSLRTFW-3737 (Start_End)
   // Note: gs_TimingAdvanceFixedDelay are defined based on 4096 tone IFDT size
   gs_TimingAdvanceFixedDelay = 37;      // TIMING_ADVANCE_TX_RX_PATH_DELAY_4KHZ
   gs_TimingAdvanceTxIirDelay = 0;       // Bypass
   gs_TimingAdvanceRxIirDelay = 0;       // Bypass

   // Timing advanced debug variables initialisation
   {
      gs_DbgTimingAdvanceTx = 0;
      // Adjustment to Timing Advance calculation
      gs_DbgTimingAdvanceOffset = 0;
      // Modification of initial target timing advance, i.e. active for values unequal to -1.
      gs_DbgTargetTimingAdvance = -1;
   }

   #ifdef VRX518_EMULATION
   gs_DetectDelay = 30; // decrease delay for non-HW platforms to speed up simulation
   #else
   gs_DetectDelay = 3000;
   #endif

   guc_minR = MIN_R;
   guc_maxM = MAX_M;
   guc_maxT = MAX_T;
   guc_maxG = MAX_G;
   gus_DSearchRange = D_SEARCH_RANGE;

   gus_PctMaxDelayOctetsForUS = 0; // auto-config by default

#ifdef ILV_DBG_BUFFER
   guc_VecDebugSwitchEnable = VEC_DEBUG_TRACE_OPVEC_TRANSIT;
#else
   guc_VecDebugSwitchEnable = 0;
#endif

   // DS ceiling control variables
   {
      gs_Force_Dn_ProposedPsdCeiling = 0;
      //XDSLRTFW-1836 : Identify the wrong MaxNomPSD Values Calulated
      gs_ForceSpecialCeilValueDs_Cntl = 0;
      gft_EnableProposedCeilingOpt = 0;
      //XDSLRTFW-475
      // Ceiling Optimization is performed for 8B & 17A profiles only by default.
      // XDSLRTFW-1898 (Start_End)
      //   gs_CeilingOptBandPlanEnable = (CNFG_V2_PROFILE_8B_MASK | CNFG_V2_PROFILE_17A_MASK);
      // Note: For Telefonica tests "Section: 0006_b_17MHz and Section: 0029_a_17MHz" this is
      //       is needed against Broadcom. It was made common for better code maintenance!
      //       (Previous bit "TELEFONICA_17A_DS_CEIL_OPT" and "gul_fe_G994VendorID != IFX_VENDOR_ID")
      //       Therefore it is not possible to set
      gs_CeilingOptBandPlanEnable = (CNFG_V2_PROFILE_8xALL_MASK |
                                     CNFG_V2_PROFILE_12A_MASK |
                                     CNFG_V2_PROFILE_17A_MASK |
                                     CNFG_V2_PROFILE_35B_MASK);
//      gs_CeilingOptBandPlanEnable = 0;
   }


   gus_UseUS0OnlyCntrl = 0;
   // XDSLRTFW-1650 (Start_End)
   gs_ChangeTxBand = 0;
   gs_TxIIRFilterSelect = OPTN_BYPASS_Filter_Select;
   gs_RxIIRFilterSelect = OPTN_BYPASS_Filter_Select;

   gs_DbgFramingDisableFlag = 0;

   gft_SaveMarginPerTone = 0;      // debug flag to overwrite SNR in gsa_SnrBuf with margin/tone

   // Post GHS SRC coeffs download debug control.
   gft_dbgDisableLoadSrcCoefPostGhs = FALSE;

   // Check if -threshold < recieved pilot tone < threshold
   // Note: The default value of threshold is 0. Hence, we
   // never pass this check until we make the threshold non-zero
   gs_dbgRxPilotThreshold = 0;

   gul_dbgMiscControl = 0;

   guc_dbgFeModemLog2IfftSize = 0;

   //GHS message debug features
   gul_dbgGHSControl = 0;

   // Signal Detection debug features
   gs_dbg_NUM_NONSILENCE_SYMBOLS_THRESH = NUM_NONSILENCE_SYMBOLS_THRESH;
   gs_SigPowerScale = SIG_POW_THRESH_SCALE;

   // State transition timing debug features
   gs_DbgRPSynchro1TransitionDelay = 0;
   gs_DbgOPSynchro1TransitionDelay = 0;
   gs_dbgDelayTxSynchro2 = 0;
   gs_dbgDelayRMsg2 = 0;
   gs_dbgRPTrain1Delay = 0;
   // CNXT CO sends ~ 100 symbols of quiet. Of late, the BRCM CO also sends ~256 symbols
   // of quiet before transitioning to OPTRAIN1. It isn't clear if sending Quiet is standard
   // compliant. However, it should be safe to delay RT's processing by 512 symbols

   // We are  right on the edge in exceeding training phase (RPQuiet2).To reduce the risk of running the into problem (i.e. CO dropping the
   // link-Pilot tone power) we don't want change in PLL training time ( too long).
   // As per standard: R-P-QUIET 2 shall provide a zero output voltage at the U reference point. All subcarriers shall be
   // transmitted at zero power. The duration of R-P-QUIET 2 is left to the discretion of the VTU-R, but
   // shall not exceed 4096 DMT symbols with CE.

   gs_dbgROPTrain1Delay = 312;   // XDSLRTFW-3978(Start_End)

   //SOC message debug features
   gul_dbgSocMsgControl = 0;
   gs_dbgLimitUsMaxNomPsd = 0;

   // PRBS
   guc_dbgMedleyTxPrbsSkipBits = 4;
   guc_dbgMedleyRxPrbsSkipBits = 4;

   // Bitloading and B/G/T Message Control
   guc_dbgForceEvenNcLoaded = 0;
   gul_dbg_DILV_MEM_SIZE = 0;
   gs_dbgTxBgMsgInsertZeros = gs_dbgRxBgMsgIgnoreZeros = gus_dbgTxBgMsgAppendBi0Gi1 = 0;

   // Showtime Transition Timing
   gs_dbgAdvanceTxSynchro2 = gs_dbgAdvanceEnableXTC = gs_dbgDelayTxShowTransition = gs_dbgDelayRxShowTransition = 0;

   // Showtime Data Pump
   gul_dbgShowtimeControl = 0;
   guc_dbgIncreaseFifoLength = 0;
   guc_dbg_ZEP_MAX_RX_FC_RUN_CNT = ZEP_MAX_RX_FC_RUN_CNT;
   gs_dbgRogueHdlcOctets = 0;         //Keeps a count of the # of rogue HDLC octets
   gs_dbgRogueHdlcOctetThreshold = -1;   //Send a UTC on recieving threshold many rogue octets, -1 implies Disabled

   //Impose the MAXNOMATP limit
   gft_MAXNOMATP_Flag = TRUE;

   //=======================================================================
   //Sniffer variables
   //=======================================================================
   gul_dbgSnifferControl = 0;
   gs_dbgSnifferMedleyTransitionControl = 0;


   //=======================================================================
   //Override variables to create artificial defects for debug purposes
   //=======================================================================
   /*   for(i = 0; i < NUM_BEARER_CHANNELS; i++)
      {
         gs_ncd_override_cnt[i] = 0;      // used to override the no. of NCD anomalies
      }
   */
   gs_LOS_override_cnt = 0;
   //gs_lom_override_cnt = 0;         // used to override the no. of LOM defect
   //gs_sef_override_cnt = 0;         // used to override the no. of SEF defect
   //gs_expected_sync_byte1 = SYNC_BYTE;
   //gs_expected_sync_byte2 = SYNC_BYTE_SFRAME;
   // The following are global variables too although they do not follow the correct nomenclature
   IB_override_count = 0;
   IB_readout_count = 0;
   for (i = 0; i < MAX_IB_BYTES_PER_SFRAME; i++)
   {
      IB_override_content[i] = 0;
      IB_readout_content[i] = 0;
   }

   gt_GainCalibration.s_TxGain = 0;
   gt_GainCalibration.s_RxGain = 0;

   // XDSLRTFW-2819 (Start End)
   // Vectoring mode:
   // For vectoring mode assume noise free scenario. In noise free case we want in CD and TRTR US0 not to be higher than US1.
   // This is for better US performance due to better adjusted CO receiver (more bitloading in US1 and US2 if present).
   // Non-vectoring mode:
   // For non-vectoring we might lose US performance, if CO is limited by external noise. Therefore leave ceiling control on CO side.
   // Default value is as for vectoring, but later in fct. "RPDiscovery2TxF_VDSL2(void)" the variable "gs_DeltaUsPsdCeilValue_TrTrain"
   // is set to -32768dB, i.e. disable = 'DISABLE_US0_CEILING'.
   //
   // Behaviour of fix:
   // Note:      0dB - US0 ceiled to max PSD of USx bands (with x = 1 to (x = 1 to NumTxBands-1))
   //       -32768dB - US0 disabled (DISABLE_US0_CEILING)
   // |----------------------------------------------------------------------------|
   // |          |   Init           |      ChDis         |    TrTrain              |
   // |----------------------------------------------------------------------------|
   // |  Vec     |  x_ChDis    0dB  |    x_ChDis  0dB    |     x_TrTrain      0dB  |
   // |          |  x_TrTrain  0dB  |                    |old: x_TrTrain -32768dB  |
   // |----------------------------------------------------------------------------|
   // | Non-Vec  |  x_ChDis    0dB  |    x_ChDis  0dB    |     x_TrTrain -32768dB  |
   // |          |  x_TrTrain  0dB  |                    |                         |
   // |----------------------------------------------------------------------------|
   // !!!!! Note: Difference to old implementation is only for TrTrain: x_TrTrain = -32768dB !!!!!
   gs_DeltaUsPsdCeilValue = (int16)DISABLE_US0_CEILING;
   // Note: For debugging any value "!= 0" will directly be taken and the FW logic gets overruled.
   gs_DeltaUsPsdCeilValue_ChDis = 0;              // US0 should never be higher than max USx PSD in ChannelDiscovery, format 0.1 dB
   gs_DeltaUsPsdCeilValue_TrTrain = 0;            // US0 should never be higher than max USx PSD in TransceiverTraining, format 0.1 dB

   // Initialized structure gt_TxPsdControls
   for (i = 0; i < 5; i++)
   {
      gt_TxPsdControl.s_US_PSD_Boost_0dB1[     i] = 0;   // US PSD boost for US0 [0.1dB] => 8 means 0.8dB
      gt_TxPsdControl.s_US_PSD_Boost_CD_0dB1[  i] = 0;   // US PSD boost for US0 [0.1dB] => 8 means 0.8dB
      gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[i] = 0;   // US PSD boost for US0 [0.1dB] => 8 means 0.8dB
   }
   gt_TxPsdControl.s_Force_kl0_estimate = 0; // Special value 0 means: disable Forcing
   gt_TxPsdControl.s_Force_kl0_final    = 0; // Special value 0 means: disable Forcing
   gt_TxPsdControl.s_Force_US_PSD_Ceiling_CD_0dB1    = 0; // not used by default
   gt_TxPsdControl.s_Force_US_PSD_Ceiling_TRTR_0dB1  = 0; // Special value 0 means: disable Forcing
   gt_TxPsdControl.s_Force_TxIfftGain_dB             = 0; // not used by default
   gt_TxPsdControl.s_US_PSD_Boost_TimeDomain         = 0; // XDSLRTFW-3990: Frequency independent US PSD boost in time domain, 8.8 dB format (+ve value --> increase PSD )

   // For FE data retrieval
   memset(&gt_MONI_FEReadTrigger,0,sizeof(gt_MONI_FEReadTrigger));

   // For Clear Eoc Autonomous Msgs
   memset(&gt_MONI_CEocTrigger,0,sizeof(gt_MONI_CEocTrigger));
   memset(&gt_MONI_CEocAutoMsgCtrl,0,sizeof(gt_MONI_CEocAutoMsgCtrl));
   memset(&gt_MONI_CEocStat,0,sizeof(gt_MONI_CEocStat));

   //L2_Back_Channel
   memset(&gt_MONI_ErbMsg,0,sizeof(gt_MONI_ErbMsg));

   // Control and Status for Eoc Get/Set Time Commands
   memset(&gt_MONI_TimeSyncCtrl,0,sizeof(gt_MONI_TimeSyncCtrl));
   memset(&gt_TimeStat,0,sizeof(gt_TimeStat));
   // XDSLRTFW-3898(Start)
   memset(&gt_Reconf_Hybrid_Coeff,0,sizeof(Reconfig_Hyb_Coeff_t));
   // XDSLRTFW-3898(End)

   //=========================================
   //Bit-Swap variables
   //=========================================
   gs_REDUCE_LP_DELTA_BITSWAP = REDUCE_LP_DELTA_BITSWAP;
   gs_BITSWAP_TRIGGER_DELTA = BITSWAP_TRIGGER_DELTA_DB;
   gs_BITWAP_MIN_SNR_MARGIN = BITSWAP_MIN_SNR_MARGIN;

   //=========================================
   //Auto-SRA related variables
   //=========================================

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   gl_SRATotalLpDeltaMax = MAX_LP_CHANGED_PER_SNRUPDATE;
   gs_delta_Lp = LP_CHANGE_PER_BKGD_TASK;
   gs_MaxTones_SRAIteration = MAX_TONES_CHANGED_PER_SRA;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

   //=========================================
   //VDSL2 Diagnostic Mode variables
   //=========================================
   gs_NumOfSymbolsForBitSearchAccum = NUM_SYMBOLS_FOR_BIT_SEARCH_ACCUM;
   gs_Log2NumOfSymbolsForBitSearchAccum = LOG2_NUM_SYMBOLS_FOR_BIT_SEARCH_ACCUM;

   gus_NumSymbolsPerBit = NUM_SYMBOLS_PER_BIT_DIAG;
   gus_NumSymbolsPerBitThresh = (gus_NumSymbolsPerBit+1)>>1;

   gl_MedleyStateLength_Diag = MEDLEY_DIAG_TX_LENGTH;
   gft_DisableHlinCalc = FALSE;

   //==================================================
   //Misc. flags and variables
   //==================================================

   // XDSLRTFW-3837 (Start_End)
   // Initialize to control flags to enable/disable different operation
   // - enable "PSD_TRAIN1_VDSL2" to see/compare the RxEchoPsd between ChDis and TransceiverTraing.
   //   This is needed because FA, TA and PSD is changing!
   // - enable "ONEPASS_MEDLEY_FDQ" to recompute FDQ from scratch during Medley phase
   //   no need to set # of RX bytes per symbol during exchange phase to 1 anymore
   gus_VdslCntlFlag = (BITMAP_ENABLE_ONEPASS_MEDLEY_FDQ | BITMAP_ENABLE_2ND_FA_TRAIN1_VDSL2 | BITMAP_ENABLE_PSD_TRAIN1_VDSL2);


#ifdef DISTRIBUTE_TX_RX_PROCESS
   gft_DistributeTxRxProcess = 0;
   gl_RxBSCount = 0;
   gul_RxTCStartTime = 10; // 11000 to delay RX process after TX process
   gul_CCR1_Reg_BS = 0;
   gul_CCR1_Reg_QtDone = (uint32)0xFFFFFFFF;
#endif // DISTRIBUTE_TX_RX_PROCESS

#ifdef USE_MFDQ_HW_WORK_AROUND
   // MFDQ HW workaround.
   // Default settings (if no CMV write of CNFG_MfdqHwWkArnd) to establish MFDQ FF anchors.
   // Only first three may be written via CMV
   gt_MfdqHwWkArndConfig.s_first_cand_anchor_offset=1;
   gt_MfdqHwWkArndConfig.s_anchor_spacing=5;
   gt_MfdqHwWkArndConfig.s_max_num_anchors=16;

   gt_MfdqHwWkArndConfig.s_num_anchors=0;
#endif //#ifdef USE_MFDQ_HW_WORK_AROUND

   //Use HW based method to compute FDQ, SNR and Vector Power
   guc_SNRFDQControl = (SNRFDQCTRL_SYNCHFDQ_HW|SNRFDQCTRL_SYNCHSNR_HW|SNRFDQCTRL_VECPOW_HW);


   // Parameter for interleaved tone-reordering
   gs_ilv_tone_order_parm_L = 16;


   // When the last few FA offsets are below gs_MaxFAOffset_at_convergence,
   // convergence is assumed.
   gs_MaxFAOffset_at_convergence = 128; // based on 8192+ samples


   // Extra SNR margin for lower bandedge tones having correlated noise.
   gs_extra_snrmargin_for_low_tones = 0<<8;   //0 dB
   // Upper tone of these bandedge tones.
   gs_high_tone_for_extra_snrmargin = 0;

   // These are determined from GHS message.  Initialize them here.
   gs_NumOfEstRxBands = 1;
   gsa_EstRxBandLeftChannel[0] = 30;
   gsa_EstRxBandRightChannel[0] = 1800;

   //NTR update slope correction term
   gs_correct = 184;

   //Set the flag to 1 to disable the PLL update during reception of O-P-ECT
   // turn this off by default because it caused link failures in some RT brand
   // this feature should be removed once we implement standard compliant DEC training
   gft_EctPllDisable = 0;

   gs_interp_psd_with_tssi = 0;


#define    DS_SRA_DOWNSHIFT_THRM    (10)       // 1 dB in 0.1 dB granularity
#define    DS_SRA_DOWNSHIFT_TIME    (1)        //Time 1sec
#define    DS_SRA_UPSHIFT_THRM      (110)      // 11 dB in 0.1 dB granularity
#define    DS_SRA_UPSHIFT_TIME      (1)        //Time 1sec

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   gt_RxAutoSRA_Ctrl.us_RA_DSNRM = DS_SRA_DOWNSHIFT_THRM;       // 1 dB in 0.1 dB granularity
   gt_RxAutoSRA_Ctrl.us_RA_DTIME = DS_SRA_DOWNSHIFT_TIME;
   gt_RxAutoSRA_Ctrl.us_RA_USNRM = DS_SRA_UPSHIFT_THRM;  // 11 dB in 0.1 dB granularity
   gt_RxAutoSRA_Ctrl.us_RA_UTIME = DS_SRA_UPSHIFT_TIME;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]


   //XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
   //gt_CustomerIopBits.us_TELEFONICA_DS_US_RATES = (TELEFONICA_MAX_RATE_CONFIG);
   //XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES

   //L2_Back_Channel
   //Actual VTU-R MAC address will be configured by DSL API with CMV: CNFG 83
   gt_MacFrameConfigure.SrcMacAdrsB0_1 = 0xA0A1; //Init with dummy value
   gt_MacFrameConfigure.SrcMacAdrsB2_3 = 0xA2A3; //Init with dummy value
   gt_MacFrameConfigure.SrcMacAdrsB4_5 = 0xA4A5; //Init with dummy value

   // XDSLRTFW-650 / XDSLRTFW-1384 (Start_End)
   /*ENABLE_L3_CODE*/
   guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
   guc_PM_L3_Response = 0;      //Reset the variable

   //Initialization
   guc_CasMode_enable = 0;
   guc_Start_CasMode_Int = 0;
   gul_35bLiteConfig = 0;
#ifdef VRX518_SINGAPORE_BRINGUP
   gul_35bLiteConfig |= (EN_RESTRICT_MAX_DTU_PER_SYM_TO_3);
   //gul_35bLiteConfig |= (EN_RESTRICT_MAX_DTU_PER_SYM_TO_3|EN_RESTRICT_MAX_IDX_HQV_TO_54);
   //gul_35bLiteConfig |= (EN_RESTRICT_MAX_IDX_HQV_TO_54);
#endif // VRX518_SINGAPORE_BRINGUP



   gc_VecDeltaRxTxSyncSym = 0;

   // Initializing the variables related to CNTR 55 (ERB over L2 back-channel)
   // XDSLRTFW-3492 (Start)
   memset(&gt_DsmStats, 0, sizeof(gt_DsmStats));
   gus_NumofSymbols_ERB_Computation= 0;
   gus_TotalNumofSymbols_ERB = 0;
   // XDSLRTFW-3492 (End)

   // XDSLRTFW-1553 (Start_End) Enable by default
   gft_IOP_UPBO_FEXT = 1;

   guc_InitSuccessFailCode = INIT_SUCCESS; // XDSLRTFW-1958(Start_End)
   //Enable Block read for Far-end by default
   gft_TestParam_Req = BLOCK_READ_CMD;

   //XDSLRTFW-2373
   guc_T1413DetectCnt = 0;

   gsa_RxHlog = (int16*)(void *)&gsa_RxHlog_DS;    //place this after gpsa_RxToneBuf

   // XDSLRTFW-3359 (Start_End)
   memset(&gt_US_SRA_Stats, 0, sizeof(gt_US_SRA_Stats));

   // XDSLRTFW-3662(Start)
   // Please refer the register DREG3 (PPE shared buffer address 0x7DC3) in document "PPE DSL Notifications", Sec 2.2.1 and point-b
   // The value "0x3" in the first value is a fixed value and please refer the mail from Chin Fong (attached in JIRA) for more information.
   // Bit defintion of DREG registers:
   // 0x7DC3 (DREG_MISCRAM3_ADDR):
   //  Bit 15 - Bit 0      --> PPE FW version
   //  Bit 31 - Bit 16     --> Fixed reference (0xA5A5)
   ul_addr = DREG_MISCRAM3_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (((ul_data & PPE_FW_VERSION_MASK) >> PPE_FW_VERSION_SHIFT) == PPE_FW_VERSION_REFERENCE)
   {
      gusa_PPE_FW[0] = 0x3;
      gusa_PPE_FW[1] = (ul_data & 0xFFFF);
   }
   // XDSLRTFW-3662(End)

   // XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
   // 1. copy gt_FailStateInfo of previous link (which is mapped to persistent memory)
   //    to gt_FailStateInfo_Prev
   // 2. reset structure gt_FailStateInfo to "0"
   // 3. update Failstate History
   //    (latest exceptions is always idx 0 of array gula_FailStateHistory

   // copy fail state info of previous link before clearing it in this link
   memcpy(&gt_FailStateInfo_Prev, &gt_FailStateInfo, sizeof(FailStateInfo_t));
   memset(&gt_FailStateInfo, 0, sizeof(FailStateInfo_t));
   gt_FailStateInfo.ul_ExceptionCode = E_CODE_NO_ERROR;
   // XDSLRTFW-3665 - Exception History
   for (i=5-1; i>0; i--)
   {
      gula_FailStateHistory[i] = gula_FailStateHistory[i-1];
   }
   gula_FailStateHistory[0] = gt_FailStateInfo_Prev.ul_ExceptionCode;


   // gsa_CapCpb_delta, gsa_CapCpc_delta have been moved to LDST memory
   // So we need to initilize the variables here.
   // int16 gsa_CapCpb_delta[VRX_NUM_CAP_CPB_SEARCH] = {-4, -2, +2, +4, +5, -5};
   gsa_CapCpb_delta[0] = -4;
   gsa_CapCpb_delta[1] = -2;
   gsa_CapCpb_delta[2] = +2;
   gsa_CapCpb_delta[3] = +4;
   gsa_CapCpb_delta[4] = +5;
   gsa_CapCpb_delta[5] = -5;
   gsa_CapCpb_delta_size = VRX_NUM_CAP_CPB_SEARCH;
   // int16 gsa_CapCpc_delta[VRX_NUM_CAP_CPC_SEARCH] = {-4, -2, +2, +4, +5, -5};
   gsa_CapCpc_delta[0] = -4;
   gsa_CapCpc_delta[1] = -2;
   gsa_CapCpc_delta[2] = +2;
   gsa_CapCpc_delta[3] = +4;
   gsa_CapCpc_delta[4] = +5;
   gsa_CapCpc_delta[5] = -5;
   gsa_CapCpc_delta_size = VRX_NUM_CAP_CPC_SEARCH;


   // XDSLRTFW-4052(Start)
   // AELE-MODE = 0 kl0[band] = ELE-M0 VTU-O kl0 estimate
   // AELE-MODE = 1 kl0[band] = ELEDS [dB], band ? {upbo_bands}
   // AELE-MODE = 2 kl0[band] = ELE[band] [dB], band ? {upbo_bands}
   // AELE-MODE = 3 kl0[band] = MIN(ELEUS, ELEDS) [dB], band ? {upbo_bands}
   // Info:
   //    If AELE-MODE = 1, 2, or 3, UPBO shall be performed according to
   //    AELE-MODE=1 until final kl0 values are provided in the O-UPDATE message.
   gt_AELEM_UPBOInfo.us_AeleMode =  0;       // we do what we did so far
   for (ul_idx = 0 ; ul_idx <= 4; ul_idx++ )
   {
      gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[ul_idx] =  0;       // initialize to "0.0dB" in 0.1dB steps
      gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[ul_idx] =  0;       // initialize to "0.0dB" in 0.1dB steps
   }
   // UPBOELEMT values expressed as 4-bits unsigned integer in percent
   //  The only valid value of UPBOELEMT is 10. Other values are reserved for future use.
   gt_AELEM_UPBOInfo.us_UpboElmt    = 10;       // set to 10%, format uint16 [16.0]
   // If the minimum received signal plus noise power during loss estimation is less
   // than rx_threshold (dBm/Hz) for the particular band the LOSS shall be set to
   // a special value 307.1dB
   // RXTHRSHDS parameter coded as an eight bit signed integer n, with valid values being all
   // integers in the range from -64 to 0, representing an offset from -100 dBm/Hz as
   // RXTHRSHDS = (-100 + n) dBm/Hz
   // The maximum values for rx_threshold(band) are -130 dBm/Hz in the downstream bands,
   // and -115 dBm/Hz in the upstream bands. 
   gt_AELEM_UPBOInfo.s_RxThreshDs   =  0;       // threshold is initialized to -100dBm/Hz
   gus_kl0_estimation_method = ELE_M0_METHOD_SLOPE_ALGO; // XDSLRTFW-4052(Start_End)
   // XDSLRTFW-4052(End)

   // XDSLRTFW-4051: Fast downstream up shift SRA (Start)
   gt_FastDsSraConfig.us_FastDsSraConfig = CNFG_DISABLE_FAST_DS_UPSHIFT_SRA;
   gt_FastDsSraConfig.us_TimeAfterShowtimeToDisableFastSra = 255;  //time in sec
   gt_FastDsSraConfig.us_TimeAfterShowtimeToCheckForRejection_3 = 255; // time in sec
   // XDSLRTFW-4051: Fast downstream up shift SRA (End)


} //InitGlobalVars_PowerUp

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigVdslFeatureMap (void)
*
*   Description:
*     Configures a 'Feature Map' (as required by CMV DSL 20) based on the
*     features supported by VDSL FW.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigVdslFeatureMap(void)
{
   // Refer to DSL 20 of MCAT 3.1
   // Initializing the variable with Zero
   memset(&gt_VdslFeatureMap, 0, sizeof(gt_VdslFeatureMap));

   // Parameter 2: Length of the VDSL Feature map
   gt_VdslFeatureMap.us_Length = 4; // Length of the DSL 20 payload data (inclding the length)

   // Parameter 3
   gt_VdslFeatureMap.Param[0] = ((VDSL_FEATURE_MICROFILTER_DETECTION_HYBRID_DATA << 2) |
                                  (VDSL_FEATURE_PTM_OFFCHIP_BONDING_BACP << 3) |
                                  (VDSL_FEATURE_US_DS_RETX_PAF << 4) |
                                  (VDSL_FEATURE_INTRA_DTU_INTERLEAVING_DS << 5) |
                                  (VDSL_FEATURE_INTRA_DTU_INTERLEAVING_US << 6) |
                                  (VDSL_FEATURE_ERASURE_DECODING << 8) |
                                  (VDSL_FEATURE_PRE_EMPTION_AND_SHORT_PACKETS << 9) |
                                  (VDSL_FEATURE_NTR << 11) |
                                  (VDSL_FEATURE_AFE_POWER_DOWN << 12)   // XDSLRTFW-3647 (Start_End)
                                 );

}
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)
