/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitModemTasks_PowerUp.c
*
*   This file contains modem initialization for initial power up.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// InitModemTasks_PowerUp.c
// History
//
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new function 'ConfigVdslFeatureMap()' that provides info on the feature subset
//                 supported by FW. This feature map can be read out by SW using CMV 'DSL 20'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new function 'ConfigAdslFeatureMap()' that provides info on the feature subset
//                 supported by FW. This feature map can be read out by SW using CMV 'DSL 19'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// ************************************************************************************************************

#include "common.h"
#include "stateini.h"
#include "cmv.h"
#include "InitGlobalVars.h"
#include "g997.h"
#include "AllocateDataBuffers.h"



/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitModemTasks_PowerUp(void)
*
*   This function initializes the modem variables after power up.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      SUCCEED/FAIL
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitModemTasks_PowerUp(void)
{
   // Allocate data buffers within shared memory
   AllocateDataBuffers();

   // Init. state machine
   InitStateMachine();

   //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
   //Configure the ADSL, VDSL Feature Map (List of features supported by FW)
   //Func to be called before CMV Init and GlobalVars Init
   ConfigVdslFeatureMap();
   //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

   // Initialize CMV
   CmvInit_PowerUp();

   // Initialize power up global variables
   InitGlobalVars_PowerUp();

   // Initialize LEDs

   // Initialize LEDs

   // Initialize G997 variables/counters
   G997_InitHandler_PowerUp();
}
