/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   InitStateMachine.c
*
*   Functions for initializing the state machine.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "vdsl_state.h"


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitStateMachine(void)
*
*   This function initializes state variables.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      SUCCEED/FAIL
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitStateMachine(void)
{
   /* =========================================================================================*/
   /* Initialize to SLEEP states */
   /* =========================================================================================*/

   gs_TxState = 0;
   gs_RxState = 0;
   gs_RxState_prev = 0;

   gpF_TxStateFunc = (PtrToFunc)EmptyState;
   gpF_RxStateFunc = (PtrToFunc)EmptyState;

   /* =========================================================================================*/
   /* Initialize State Control variables   */
   /* =========================================================================================*/

   gs_TxStopState = STOP_TX;
   gs_RxStopState = STOP_RX;
   gs_TxSubState = 0;
   gs_RxSubState = 0;
   gs_TxDoneState = DONE_TX;
   gs_RxDoneState = DONE_RX;

   gs_TxStateJumpFrom = -1;
   gs_RxStateJumpFrom = -1;
   gs_RxSubStateJumpFrom = -1;

   // Tx/Rx JumpTo states are initialized to be Done State.
   // The only way to change them is by a "memory write" command in WinHost.
   gs_TxStateJumpTo = DONE_TX;
   gs_RxStateJumpTo = DONE_RX;
   gpF_TxStateJumpTo = (PtrToFunc)EmptyState;
   gpF_RxStateJumpTo = (PtrToFunc)EmptyState;

   gl_TxSymbolCount = -1;
   gl_RxSymbolCount = -1;
   gl_TxTcCount = -1;
   gl_RxTcCount = -1;

}
