/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ModemMonitor.c
*
*   Functions for running modem monitoring at the end of Rx foreground.
*
*-------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// ModemMonitor.c
//
// History
//
// 12/12/2012 Ram: Indicating correct "System error code" & "System sub error code" when failed in showtime
//                 Grep for: "XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail"
//
// 21/01/2013 Ram: Prioritized reporting of line failures (NE and FE) in showtime.
//                 Grep for: "XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail"
// 08/11/2013 Venkatesh : The new Flag ReInitTrigger will be set only if the
//                 Re-Init duration is exceeded. The Flag is used as Re-Init and Failure
//                 Indication period is different now
//                 Grep : XDSLRTFW-955
// 29/11/2018 Abu Rahman
//            XDSLRTFW-4050: Disable Autonomous State Event Messaging in VDSL mode
//            Autonomous State Event messaging was introduced with XDSLRTFW-3513. This functionality required special
//            message handling capability in SW which was introduced in UGW 8.1.1. It looks like concept were not adequate
//            to meet all the corner cases. This new feature often leads instabilities ( ie No TC Sync reporting in VDSL
//            mode, link drop in ADSL mode etc.) Due to these consequences the feature is decided to be disabled in FW
//            by default. If API tries to enable this feature then FW reports an exception (i.e E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION)
//
//            To enable or disable Autonomous state events handling in FW "test 46 0"  bit mask 0x0800 cmv is used
//            Enable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 1 (dmms 2E44 0 1 0800 0800)
//            Disable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 0 (dmms 2E44 0 1 0800 0000) default configuration.
//            Grep pattern:  XDSLRTFW-4050
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "cmv.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "PrintTrail.h"
#include "nmp.h"
#include "g997.h"
#include "vdsl_state.h"
#include "ModemMonitor.h"
#include "vdsl_xception.h"
#include "eoc.h"
#include "profile.h"
#include "string.h"


void SavePMSErrCntr(void);

extern FlagT  gft_ReInitTrigger; //XDSLRTFW-2094/2050
// for testing only
uint16 gus_FEData_AutoMsgSent = 0;
uint16 gus_CEocStat_AutoMsgSent = 0;
uint16 gus_CEocMsg_AutoMsgSent = 0;
uint16 gus_LineFailureNE_AutoMsgSent = 0;
uint16 gus_LineFailureFE_AutoMsgSent = 0;
uint16 gus_LineFailureNE = 0;
uint16 gus_LineFailureFE = 0;

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : AutoMsgHandler
 *
 *  Prototype:  void AutoMsgHandler(void)
 *
 *     The AutoMsgHandler function is called as part of the ModemMonitor processing.
 *  This function
 *      (1) checks for conditions that trigger autonomous messages, and
 *      (2) checks for conditions that cause a transition to fail state (e.g. LOS)
 *
 *  The autonomous messages and failure controls for each condition are under
 *  enable/disable CMV control.
 *
 *  Conditions that may be programmed to trigger an autonomous message, along
 *  with the auto message contents, are shown below.
 *
 *      Condition               Autonomous Message Contents
 *      ---------               ----------------------------
 *
 *      Macro State Transition      STAT 0 0 (and STAT 5 0 if transition is to fail state)
 *      NE Line Failures         PLAM 0 0
 *      FE Line Failures         PLAM 1 0
 *
 *
 *  Conditions that may be programmed to trigger a transition to fail state
 *  are shown below.
 *
 *      Condition               Autonomous Message Contents
 *      ---------               ----------------------------
 *
 *      NE Line Failures         PLAM 0 0
 *      FE Line Failures         PLAM 1 0
 *
 *
 *
 *
 *  Input Arguments:   none
 *
 *  Output Arguments:   none
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void AutoMsgHandler(void)
{
   uint32 ul_ExpCode;
   //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   int16 s_g997_fail_flag_latched0;
   int16 s_g997_fail_flag_latched1;

   static AutoMsgPayLoadEntry_t *pt_PayLoadToSend;
   static int16 s_AutoMsgNextSubState;
   static uint16 s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4;

   switch(gs_AutoMsgHandlerState)
   {
      //---------------------------------------------------
      // The modem may be configured to sent autonomous messages
      // on Macro State transitions.
      // This AutoMsgHandlerState checks here for an enabled
      // state transition.
      //---------------------------------------------------
   case CHECK_MODEM_MACRO_STATE:
      // For debug streams we want to report every modem macro state change if debug streams are enabled
      if((gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK) != 0)
      {
         if(gs_DSH_PrevFsmState != gusa_MONI_ModemStat_Status[0])
         {
            gs_DSH_PrevFsmState = gusa_MONI_ModemStat_Status[0];
            gpt_DSH_ModemFsmState->ul_FsmState = gusa_MONI_ModemStat_Status[0];
            gpt_DSH_ModemFsmState->gsa_IndirectStat0 =  gsa_IndirectStat0[0];
            DSH_SendStream(DSH_FSM_STATE, sizeof(DSH_ModemFsmState), (void *)gpt_DSH_ModemFsmState);
         }
      }

      // XDSLRTFW-3647 (Start)
      // Here we need to check for bits set in the MODEM_MONITOR 0 (Parameter 2 and Parameter 3) to transmit
      // autonomous message for the change in modem state.
      // Please check XDSLRTFW-4050: Disable Autonomous State Event Messaging in VDSL mode
      if ((gt_ModemStatPayLoad.uc_PayLoadSent)  &&                      // Ok to update gs_Pre_MONI_ModemStat_Status
         (gul_Pre_MONI_ModemStat_Status != (((gusa_MONI_ModemStat_Status[1] & gusa_MONI_ModemStat[1]) << 16) | (gusa_MONI_ModemStat_Status[0] & gusa_MONI_ModemStat[0]))))  // If there is a change in modem state
      {
         //XDSLRTFW-4120 (Start)
         // We store the modem state and compare it next time to see if there is any change in modem state.
         gul_Pre_MONI_ModemStat_Status = (((gusa_MONI_ModemStat_Status[1] & gusa_MONI_ModemStat[1]) << 16) | (gusa_MONI_ModemStat_Status[0] & gusa_MONI_ModemStat[0]));
         gs_AutoMsgHandlerState = SUBMIT_MODEM_STAT_FAILURE_INFO;
         //XDSLRTFW-4120 (End)

         //Is the autonomous notification for the specific state enabled?
         if ((gusa_MONI_ModemStat_Status[0] & gusa_MONI_ModemStat[0]) ||
             (gusa_MONI_ModemStat_Status[1] & gusa_MONI_ModemStat[1]))
         {
            memcpy(&gsa_PrevStat, &gsa_IndirectStat0, sizeof(int16)*STAT_0_SIZE);   // XDSLRTFW-3513 (Start_End)

            s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
            s_Word0 = AUTO_MSG_CR_HEADER_0;
            s_Word1 = AUTO_MSG_STAT0_HEADER_1;
            s_Word2 = AUTO_MSG_STAT0_HEADER_2;
            s_Word3 = AUTO_MSG_CR_HEADER_3;
            s_Word4 = AUTO_MSG_STAT0_HEADER_4;
            pt_PayLoadToSend = &gt_ModemStatPayLoad;
            s_AutoMsgNextSubState = SUBMIT_MODEM_STAT_FAILURE_INFO;
            gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
         }
      }
      // XDSLRTFW-3647 (End)
      else
      {
         gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE;
      }
      break;

      //---------------------------------------------------
      // On a Macro State transition to fail, the
      // fail state information in STAT 5 0 is
      // sent following the macro state STAT 1 0 message.
      //---------------------------------------------------
   case SUBMIT_MODEM_STAT_FAILURE_INFO:
      if (gusa_MONI_ModemStat_Status[0] & MONI_STAT_FAIL)
      {
         if (gt_ModemStatFailPayLoad.uc_PayLoadSent)  // ok to send failure info
         {
            s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
            s_Word0 = AUTO_MSG_CR_HEADER_0;
            s_Word1 = AUTO_MSG_STAT5_HEADER_1;
            s_Word2 = AUTO_MSG_STAT5_HEADER_2;
            s_Word3 = AUTO_MSG_CR_HEADER_3;
            s_Word4 = AUTO_MSG_STAT5_HEADER_4;
            pt_PayLoadToSend = &gt_ModemStatFailPayLoad;
            s_AutoMsgNextSubState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE;
            gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
         }
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE;
      }
      break;


      //---------------------------------------------------
      // The modem may be configured to send Autonomous
      // messages based on Line Failures.
      // Check here for enabled NE Line Failures.
      //---------------------------------------------------
   case  CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE:

      // latch NE and FE Failure flags so that the same information
      // is used for automessaging check and autorestart check.
      // if the failure flags are used "live", then a failure
      // could occure between the check for automessage and the
      // check for autorestart, preventing the automessage from being sent.
#ifdef DEBUG_TRAIL
      // Log the NE showtime failure flag if it is different from the previous one
      if ((gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_NE_SHOWFAIL_ENABLE) &&
            (gsa_g997_Failure_Flag_NE[0] != gsa_g997_Failure_Flag_NE_latched[0]))
      {
         DebugTrail1(4,DEBUG_TRAIL_SHOWTIME_EVENTS_ENABLE,0,
                     (int16)DEBUG_TRAIL_SHOW_EVENTS_NE_SHOWFAIL,
                     (int16)gl_RxSymbolCount,
                     (int16)(gl_RxSymbolCount>>16),
                     (int16)gsa_g997_Failure_Flag_NE[0]);
      }
#endif // DEBUG_TRAIL

      //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx

      gsa_g997_Failure_Flag_NE_latched[0] = gsa_g997_Failure_Flag_NE[0];
      gsa_g997_Failure_Flag_NE_latched[1] = gsa_g997_Failure_Flag_NE[1];


      // Check to send message for NE failure
      if ((gt_LineFailureNEPayLoad.uc_PayLoadSent) &&

            // steady state
            (gus_ShowtimeControl & MASK_TX_RX_SHOWTIME) &&

            // Check that an NE line failure has been set or cleared and that config is requesting an auto-msg
            ((gs_MONI_LineFailure_NE & (gsa_g997_Failure_Flag_NE_latched[0] ^ gsa_prev_g997_Failure_Flag_NE[0])) ||
             // Check that first 10 seconds in showtime are free of LOS /LOF
             ((gft_ErrorFree_10sInShowtime == TRUE) && (gs_MONI_LineFailure_NE & 0x3))))
      {
         // Clear the flag to not send the message twice
         gft_ErrorFree_10sInShowtime = 0;

         gsa_prev_g997_Failure_Flag_NE[0] = gsa_g997_Failure_Flag_NE_latched[0];
         gsa_prev_g997_Failure_Flag_NE[1] = gsa_g997_Failure_Flag_NE_latched[1];
         s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
         s_Word0 = AUTO_MSG_CR_HEADER_0;
         s_Word1 = AUTO_MSG_PLAM0_HEADER_1;
         s_Word2 = AUTO_MSG_PLAM0_HEADER_2;
         s_Word3 = AUTO_MSG_CR_HEADER_3;
         s_Word4 = AUTO_MSG_PLAM0_HEADER_4;
         pt_PayLoadToSend = &gt_LineFailureNEPayLoad;
         s_AutoMsgNextSubState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_FE;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
         gus_LineFailureNE_AutoMsgSent++; // for testing
         gus_LineFailureNE |= gsa_g997_Failure_Flag_NE[0]; // for testing
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_FE;
      }
      break;

      //---------------------------------------------------
      // The modem may be configured to send Autonomous
      // messages based on Line Failures.
      // Check here for enabled FE Line Failures.
      //---------------------------------------------------
   case  CHECK_AUTOMESSAGE_ON_LINE_FAILURES_FE:
#ifdef DEBUG_TRAIL
      // Log the FE showtime failure flag if it is different from the previous one
      if ((gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_FE_SHOWFAIL_ENABLE) &&
            (gs_g997_Failure_Flag_FE != gs_g997_Failure_Flag_FE_latched))
      {
         DebugTrail1(4,DEBUG_TRAIL_SHOWTIME_EVENTS_ENABLE,0,
                     (int16)DEBUG_TRAIL_SHOW_EVENTS_FE_SHOWFAIL,
                     (int16)gl_RxSymbolCount,
                     (int16)(gl_RxSymbolCount>>16),
                     (int16)gs_g997_Failure_Flag_FE);
      }
#endif // DEBUG_TRAIL
      gs_g997_Failure_Flag_FE_latched = gs_g997_Failure_Flag_FE;

      // Check to send message for FE failure
      if ((gt_LineFailureFEPayLoad.uc_PayLoadSent) &&
            // Check that an FE line failure has been set or cleared and that config is requesting an auto-msg
            (gs_MONI_LineFailure_FE & (gs_g997_Failure_Flag_FE_latched ^ gs_prev_g997_Failure_Flag_FE)) &&
            // steady state
            (gus_ShowtimeControl & MASK_TX_RX_SHOWTIME))
      {
         gs_prev_g997_Failure_Flag_FE = gs_g997_Failure_Flag_FE_latched;
         s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
         s_Word0 = AUTO_MSG_CR_HEADER_0;
         s_Word1 = AUTO_MSG_PLAM1_HEADER_1;
         s_Word2 = AUTO_MSG_PLAM1_HEADER_2;
         s_Word3 = AUTO_MSG_CR_HEADER_3;
         s_Word4 = AUTO_MSG_PLAM1_HEADER_4;
         pt_PayLoadToSend = &gt_LineFailureFEPayLoad;
         s_AutoMsgNextSubState = CHECK_FAILSTATE_ON_LINE_FAILURES_NE;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
         gus_LineFailureFE_AutoMsgSent++; // for testing
         gus_LineFailureFE |= gs_g997_Failure_Flag_FE_latched; // for testing
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_FAILSTATE_ON_LINE_FAILURES_NE;
      }
      break;
      //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx (Start)
      //---------------------------------------------------
      // The modem may also be configured to
      // go to FAIL STATE in response to Line Failures.
      // Check here for enabled NE Line Failures.
      //---------------------------------------------------
   case  CHECK_FAILSTATE_ON_LINE_FAILURES_NE:
      // Check to trigger Showtime failure based on NE failure
      //XDSLRTFW-955 : The new Flag ReInitTrigger will be set only if the
      //Re-Init duration is exceeded. The Flag is used as Re-Init and Failure
      //Indication period is different now
      s_g997_fail_flag_latched0 = gsa_g997_Failure_Flag_NE_latched[0] & gsa_MONI_ShowFailure_NE[0];
      s_g997_fail_flag_latched1 = gsa_g997_Failure_Flag_NE_latched[1] & gsa_MONI_ShowFailure_NE[1];
      if ((gus_ShowtimeControl & MASK_TX_RX_SHOWTIME) &&
            (gt_LineFailureNEPayLoad.uc_PayLoadSent) &&
            ( s_g997_fail_flag_latched0  || s_g997_fail_flag_latched1 ) &&
            (gft_ReInitTrigger == 1) )
      {
         // Save the PMS error counters
         SavePMSErrCntr();

         // XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail (Start)
         //Returing appropriate Exception Code.
         if (s_g997_fail_flag_latched0  & LOS_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_LOS;
         }
         else if (s_g997_fail_flag_latched0  & LPR_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_LPR;
         }
         else if (s_g997_fail_flag_latched0  & LOF_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_LOF;
         }
// XDSLRTFW-1479 (Start)
         else if (s_g997_fail_flag_latched0  & LCD_BC0_FAILURE_BIT)
         {
            if(gft_TcTypeSelected == TPS_TC_TYPE_ATM)
            {
               ul_ExpCode = E_CODE_SHOWTIME_NE_LCD_BC0;
               gt_DataPathFailures.s_LCD_NCD_Failure |= DATAPATH_LCD_NE_BC0;
            }
            else
            {
               ul_ExpCode = E_CODE_SHOWTIME_NE_OOS0; //XDSLRTFW-2050
            }

         }
         else if (s_g997_fail_flag_latched0  & NCD_BC0_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_NCD_BC0;
            gt_DataPathFailures.s_LCD_NCD_Failure |= DATAPATH_NCD_NE_BC0;
         }
// XDSLRTFW-1479 (End)
         else if (s_g997_fail_flag_latched0  & LOM_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_LOM;
         }
         //Check ESx if Set and then SESx If Set, Next ESE Failure
         else if (s_g997_fail_flag_latched1  & ESX_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_ESX;
         }
         else if (s_g997_fail_flag_latched1  & SESX_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_SESX;
         }
         else if (s_g997_fail_flag_latched0  & ESE_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_ESE;
         }
         else
         {
            ul_ExpCode = E_CODE_SHOWTIME_NE_Retrain;
         }

         // XDSLRTFW-650 / XDSLRTFW-1384 (Start)
         // For Vector mode start L3 orderly shutdown procedure
         if (TESTArray[TEST_Control3] & TEST_DisableL3Mode)
         {
            EnterFailStates(ul_ExpCode);
         }
         else
         {
            if (gft_DSVectoringEnabled && (!gft_EnterL3State) )
            {
               CNTLArray[CNTL_ShutDownRequest] |= CNTL_L3OrderlyShutDown;   // set the bit
            }
            else
            {
               EnterFailStates(ul_ExpCode);
            }

         }
         // XDSLRTFW-650 / XDSLRTFW-1384 (End)

         // XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail (End)

         // Return to CHECK_MODEM_MACRO_STATE in case we need to generate a stat failure message
         gs_AutoMsgHandlerState = CHECK_MODEM_MACRO_STATE;
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_FAILSTATE_ON_LINE_FAILURES_FE;
      }

      break;

      //---------------------------------------------------
      // The modem may also be configured to
      // go to FAIL STATE in response to Line Failures.
      // Check here for enabled FE Line Failures.
      //---------------------------------------------------
   case  CHECK_FAILSTATE_ON_LINE_FAILURES_FE:
      // Check to trigger Showtime failure based on FE failure
      s_g997_fail_flag_latched0 = (gs_g997_Failure_Flag_FE_latched & gs_MONI_ShowFailure_FE);
      if ((gus_ShowtimeControl & MASK_TX_RX_SHOWTIME) &&
            (gt_LineFailureFEPayLoad.uc_PayLoadSent) &&
            (s_g997_fail_flag_latched0))
      {

         // XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail (Start)
         //Returing appropriate Exception Code.
         if (s_g997_fail_flag_latched0 & LOS_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_LOS;
         }
         else if (s_g997_fail_flag_latched0 & ESE_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_ESE;
         }
         else if (s_g997_fail_flag_latched0 & LPR_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_LPR;
         }
         else if (s_g997_fail_flag_latched0 & LOF_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_LOF;
         }
// XDSLRTFW-1479 (Start)
         else if (s_g997_fail_flag_latched0 & LCD_BC0_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_LCD_BC0;
            gt_DataPathFailures.s_LCD_NCD_Failure |= DATAPATH_LCD_FE_BC0;

         }
         else if (s_g997_fail_flag_latched0 & NCD_BC0_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_NCD_BC0;
            gt_DataPathFailures.s_LCD_NCD_Failure |= DATAPATH_NCD_FE_BC0;
         }
// XDSLRTFW-1479 (End)
         else if (s_g997_fail_flag_latched0 & LOM_FAILURE_BIT)
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_LOM;
         }

         else
         {
            ul_ExpCode = E_CODE_SHOWTIME_FE_Retrain;
         }

         EnterFailStates(ul_ExpCode);
         // XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail (End)

         // Return to CHECK_MODEM_MACRO_STATE in case we need to generate a stat failure message
         gs_AutoMsgHandlerState = CHECK_TR1_ROLLOVER;
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_TR1_ROLLOVER;
      }
      break;

      //---------------------------------------------------
      // The modem may be configured to send an Autonomous
      // message on a TR1 Interval Rollover.
      // Check here for the TR1 Rollover condition.
      //---------------------------------------------------
   case  CHECK_TR1_ROLLOVER:
      // Check conditions to send TR1 ROLLOVER message
      // update these conditions
      if ((gt_Tr1RolloverPayLoad.uc_PayLoadSent) &&
            (gft_Tr1RolloverFlag) &&
            (gt_G997_Cntrl.s_TR1_enabled & CNTR_TR1_AutoMsg_Enable))
      {
         gft_Tr1RolloverFlag   = 0;
         s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
         s_Word0 = AUTO_MSG_TR1_ROLLOVER_HEADER_0;
         s_Word1 = AUTO_MSG_TR1_ROLLOVER_HEADER_1;
         s_Word2 = AUTO_MSG_TR1_ROLLOVER_HEADER_2;
         s_Word3 = AUTO_MSG_TR1_ROLLOVER_HEADER_3;
         s_Word4 = AUTO_MSG_TR1_ROLLOVER_HEADER_4;
         pt_PayLoadToSend = &gt_Tr1RolloverPayLoad;
         s_AutoMsgNextSubState = CHECK_TR1_ALARM;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_TR1_ALARM;
      }
      break;


      //---------------------------------------------------
      // The modem may be configured to send an Autonomous
      // message when a TR1 Threshold is exceeded.
      // Check here for the TR1 Threshold exceed.
      //---------------------------------------------------
   case  CHECK_TR1_ALARM:

      // Check if TR1 Alarm needs to be set
      if ((gt_Tr1AlarmPayLoad.uc_PayLoadSent) &&
            (gft_SendTr1AlarmFlag))
      {
         gft_SendTr1AlarmFlag = 0;

         s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
         s_Word0 = AUTO_MSG_CR_HEADER_0;
         s_Word1 = AUTO_MSG_PLAM2_HEADER_1;
         s_Word2 = AUTO_MSG_PLAM2_HEADER_2;
         s_Word3 = AUTO_MSG_CR_HEADER_3;
         s_Word4 = AUTO_MSG_PLAM2_HEADER_4;
         pt_PayLoadToSend = &gt_Tr1AlarmPayLoad;
         s_AutoMsgNextSubState = CHECK_FEDATASEND;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_FEDATASEND;
      }
      break;

      //---------------------------------------------------
      // An Autonomous msg is sent to the host when the retrieval
      // of FE data is complete - see gt_MONI_FEReadTrigger
      //---------------------------------------------------
   case CHECK_FEDATASEND:
      if (gt_FEDataPayload.uc_PayLoadSent && gft_SendFEDataFlag)
      {
         s_MailboxCode = AUTONOMOUS_MSG_EVENT;
         s_Word0 = AUTO_MSG_CR_HEADER_0;
         // Size - if gt_FEData is modified then this calculation must change!!
         s_Word1 = 6 + (((gt_FEData.us_EndIndex - gt_FEData.us_StartIndex) + 1) * 2);
         s_Word2 = AUTO_MSG_INFO88_HEADER_2;
         // Index
         s_Word3 = gus_EocFEData_AutoMsgIx;
         // Increment for the next send - this is set to 0 for the 1st msg
         gus_EocFEData_AutoMsgIx += s_Word1;
         // Len equals Size
         s_Word4 = s_Word1;

         // Len
         gt_FEDataPayload.uc_PayLoadLength = s_Word1;

         pt_PayLoadToSend = &gt_FEDataPayload;

         gft_SendFEDataFlag = 0;
         gus_FEData_AutoMsgSent++; // for testing

         s_AutoMsgNextSubState = CHECK_CLEAREOCSTAT;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
      } // if (gt_FEDataPayload.uc_PayLoadSent && gft_SendFEDataFlag)
      else
      {
         gs_AutoMsgHandlerState = CHECK_CLEAREOCSTAT;
      }
      break;

   //---------------------------------------------------
   // CMD_ClearEOCStatusGet   0x0B09
   // EVT_ClearEOCStatusGet   MODEM_MONITOR 11
   //                         MONI 11       MONI_11
   //---------------------------------------------------
   // An Autonomous msg is sent to the host to indicate
   // status of the Clear Eoc msg
   //---------------------------------------------------
   case CHECK_CLEAREOCSTAT:
      if (gt_CEocStatPayload.uc_PayLoadSent && gft_SendCEocStatFlag)
      {
         s_MailboxCode = AUTONOMOUS_MSG_EVENT;
         s_Word0 = AUTO_MSG_CR_HEADER_0;
         s_Word1 = AUTO_MSG_MONI11_HEADER_1;
         s_Word2 = AUTO_MSG_MONI11_HEADER_2;
         s_Word3 = AUTO_MSG_CR_HEADER_3;
         s_Word4 = AUTO_MSG_MONI11_HEADER_4;
         pt_PayLoadToSend = &gt_CEocStatPayload;

         gft_SendCEocStatFlag = 0;
         gus_CEocStat_AutoMsgSent++;

         s_AutoMsgNextSubState = CHECK_TC_TYPE;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_TC_TYPE;
      }
      break;

      // XDSLRTFW-3008 - EVT_TC_StatusGet
      //
      // Reports the used TC-Mode.
      // Supported settings:
      //    0x1 EFM_TC EFM TC
      //    0x2 ATM_TC ATM TC
      //---------------------------------------------------
      // TC information
      //---------------------------------------------------
      // EVT_TC_StatusGet                 0x0E22
      // DSL_TC_STATUS                    DSL 14      DSL_14
      //---------------------------------------------------
   case CHECK_TC_TYPE:
      if ((gft_autonomous_msg_flag == TRUE) && gt_Bonding_TC.uc_PayLoadSent )
      {
         // XDSLRTFW-3105 Add possiblity to disable autonomous reporting of used TC-Mode
         if((TESTArray[TEST_Control3] & TEST_DisableAutoMsgTcMode))
         {
            gft_autonomous_msg_flag = FALSE;
            gs_AutoMsgHandlerState = CHECK_CLEAREOCMSG;
         }
         else
         {
            s_MailboxCode = AUTONOMOUS_MSG_EVENT;
            s_Word0 = AUTO_MSG_CR_HEADER_0;
            s_Word1 = AUTO_MSG_DSL14_HEADER_1;
            s_Word2 = AUTO_MSG_DSL14_HEADER_2;
            s_Word3 = AUTO_MSG_CR_HEADER_3;
            s_Word4 = AUTO_MSG_DSL14_HEADER_4;
            s_AutoMsgNextSubState = CHECK_CLEAREOCMSG;
            gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
            pt_PayLoadToSend = &gt_Bonding_TC;

            gft_autonomous_msg_flag = FALSE;
            gft_bonding_TC_autonomous_sent = TRUE;
            s_AutoMsgNextSubState = CHECK_CLEAREOCMSG;
            gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
         }
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_CLEAREOCMSG;
      }

      break;

      //---------------------------------------------------
      // An Autonomous msg is sent to send the Eoc msg payload
      //---------------------------------------------------
   case CHECK_CLEAREOCMSG:

      if (gt_CEocMsgPayload.uc_PayLoadSent && gft_SendCEocMsgFlag)
      {
#ifdef CLEAR_EOC
         uint8 * puc_buf;

         s_MailboxCode = AUTONOMOUS_MSG_EVENT;
         s_Word0 = AUTO_MSG_CR_HEADER_0;
         // Size
         s_Word1 = MIN(gs_EocCEocMsgLen,HMP_MBOX_PAYLOAD_SIZE);
         s_Word2 = AUTO_MSG_INFO82_HEADER_2;
         // Index
         s_Word3 = gus_EocCEocMsg_AutoMsgIx;
         // Len equals Size
         s_Word4 = s_Word1;

         // Len
         gt_CEocMsgPayload.uc_PayLoadLength = s_Word1;

         // point to next set of data to send (gt_INFO_CEocRxBuf is INFO 82)
         puc_buf = (uint8 *)&gt_INFO_CEocRxBuf;
         gt_CEocMsgPayload.pus_PayLoad = (uint16 *)(void *)&puc_buf[gus_EocCEocMsg_AutoMsgIx<<1]; // offset in bytes
         pt_PayLoadToSend = &gt_CEocMsgPayload;

         // Increment for the next send - this is set to 0 for the 1st msg
         gus_EocCEocMsg_AutoMsgIx += s_Word1; // offset in words

         // adjust msg len for next send
         if (gs_EocCEocMsgLen > HMP_MBOX_PAYLOAD_SIZE)
         {
            gs_EocCEocMsgLen -= HMP_MBOX_PAYLOAD_SIZE;
         }
         else
         {
            // if sending Clear EOC message to ME is completed
            gs_EocCEocMsgLen = 0;
            gft_SendCEocMsgFlag = 0;

            if (gt_MONI_CEocAutoMsgCtrl.b_AutoDataMsgEn)
            {
               gt_MONI_CEocStat.us_RxStatus = EOC_CEOC_RXSTAT_RXIDLE; // goes back to idle

               if (gt_MONI_CEocAutoMsgCtrl.b_RxAutoStatusMsgEn)
               {
                  gft_SendCEocStatFlag = 1; // schedule the auto msg for RX status change
               }
            }
         }

         if (!gs_EocCEocMsgLen)
         {
            gft_SendCEocMsgFlag = 0;
         }

         gus_CEocMsg_AutoMsgSent++;

         s_AutoMsgNextSubState = CHECK_MODEM_MACRO_STATE;
         gs_AutoMsgHandlerState = SUBMIT_AUTO_MSG;
#endif //CLEAR_EOC
      }
      else
      {
         gs_AutoMsgHandlerState = CHECK_MODEM_MACRO_STATE;
      }
      break;

      //---------------------------------------------------
      // common substate to submit message
      //---------------------------------------------------
   case SUBMIT_AUTO_MSG:
      {
         if (AUTO_MSG_QUEUE_OPERATION_SUCCESS == SubmitAutoMsg(pt_PayLoadToSend, s_MailboxCode, s_Word0, s_Word1,
               s_Word2, s_Word3, s_Word4))
         {
            gs_AutoMsgHandlerState = s_AutoMsgNextSubState;
         }
      }
      break;
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Tr1ResetHandler
 *
 *  Prototype:  void Tr1ResetHandler(void)
 *
 *      This function provides CMV (variable gt_G997_Cntrl.s_Cntr_Reset_Control) control
 *   of the TR1 counters and interval.
 *   A write to the CMV may use the following codes:
 *
 *   TR1 Counter Control:
 *      0: Do Nothing.
 *      1: Reset Current Counters now.
 *      2. Re-inialize all counters at Link Start (test mode).
 *      3. Reset Current Counters and TR1 clock
 *      4: Shorten TR1 time interva
 *      5. Copy Current Counters to Previous and Reset TR1 clock.
 *
 *   The control code is automatically cleared, either here, or wherever the command is completed.
 *
 *
 *  Input Arguments:   none
 *
 *  Output Arguments:   none
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Tr1ResetHandler(void)
{

   switch(gt_G997_Cntrl.s_Cntr_Reset_Control)
   {
      //--------------------------------------
      // Reset TR1 Current Counters to 0
      // Leave TR1 Prev Counters unchanged
      // Leave TR1 Interval Clock unchanged
      //--------------------------------------
   case 1:
      G997_Clear_TR1_Counters();
      gt_G997_Cntrl.s_Cntr_Reset_Control = 0;
      break;

      //--------------------------------------
      // Reinialize all Counters at Link Start: implemented at Link Start
      //--------------------------------------
   case 2:
      break;

      //--------------------------------------
      // Reset TR1 Current Counters
      // Leave TR1 Prev Counters unchanged
      // Reset TR1 Interval Clock
      //--------------------------------------
   case 3:
      G997_Clear_TR1_Counters();
      gt_G997_Cntrl.s_Interval_Count = 0;
      gft_Tr1RolloverFlag = 1;            // Set flag to generate Auto Msg
      gt_G997_Cntrl.s_Cntr_Reset_Control = 0;
      break;

      //--------------------------------------
      // Shorten TR1 Interval: implemented in TR1 processing code
      //--------------------------------------
   case 4:
      break;

      //--------------------------------------
      // Copy Current Counters to Previous Counters
      // Reset TR1 Current Counters
      // Reset TR1 Interval Clock
      //--------------------------------------
   case 5:
      G997_Copy_TR1_Counters();
      G997_Clear_TR1_Counters();
      gt_G997_Cntrl.s_Interval_Count = 0;
      gft_Tr1RolloverFlag = 1;            // Set flag to generate Auto Msg
      gt_G997_Cntrl.s_Cntr_Reset_Control = 0;
      break;

   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ModemMonitor
 *
 *  Prototype:  void ModemMonitor(void)
 *
 *      ModemMonitor montitors:
 *
 *            Line Conditions and System Status for Autonomous Messaging
 *            Line Conditions and System Status for Failures/Auto-Restart
 *            CNTR Control for TR1 counter/interval clear/reset.
 *
 *  Input Arguments:   none
 *
 *  Output Arguments:   none
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ModemMonitor(void)
{

   switch(gs_ModemMonitorState)
   {
      //-----------------------------
      //   Autonomous Message Handling:
      //-----------------------------
   case MODEM_MONITOR_AUTO_MSG_HANDLER:
      AutoMsgHandler();
      break;

      //-----------------------------
      //   TR1 RESET HANDLER:
      //-----------------------------
   case MODEM_MONITOR_TR1_RESET_HANDLER:
      Tr1ResetHandler();
      break;

   default:
      gs_ModemMonitorState = MODEM_MONITOR_IDLE;
      break;
   }

   gs_ModemMonitorState++;
}


void SavePMSErrCntr(void)
{
   gus_BitloadErrorCode = gus_ZEP_RxPMSNotDone;
   gs_RxMsgErrorCode = gus_ZEP_TxPMSNotDone;
}
