/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ModemMonitor_Init.c
*
*   Function to init the global variables used by modem monitoring
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "ModemMonitor.h"
#include "eoc.h" // for gt_FEData

void AutoMsgHandlerInit(void)
{
   gs_AutoMsgHandlerState = CHECK_MODEM_MACRO_STATE;
   gt_ModemStatPayLoad.pus_PayLoad =(uint16 *)(void *) &gsa_PrevStat[0];
   gt_ModemStatPayLoad.uc_PayLoadLength = STAT_0_SIZE;   // XDSLRTFW-3513 (Start_End)
   gt_ModemStatPayLoad.uc_PayLoadSent = 1;

   gt_ModemStatFailPayLoad.pus_PayLoad = (uint16*)(void *)&gt_FailStateInfo;

   // limit Autonomous message length to the published fail state info.
   gt_ModemStatFailPayLoad.uc_PayLoadLength = 10;
   gt_ModemStatFailPayLoad.uc_PayLoadSent = 1;
   //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   gt_LineFailureNEPayLoad.pus_PayLoad = &gsa_g997_Failure_Flag_NE[0];
   gt_LineFailureNEPayLoad.uc_PayLoadLength = 1;
   gt_LineFailureNEPayLoad.uc_PayLoadSent = 1;
   gsa_prev_g997_Failure_Flag_NE[0] = 0;   // previous copy of gsa_g997_Failure_Flag_NE
   gsa_prev_g997_Failure_Flag_NE[1] = 0;   // previous copy of gsa_g997_Failure_Flag_NE
   //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   gt_LineFailureFEPayLoad.pus_PayLoad = &gs_g997_Failure_Flag_FE;
   gt_LineFailureFEPayLoad.uc_PayLoadLength = 1;
   gt_LineFailureFEPayLoad.uc_PayLoadSent = 1;
   gs_prev_g997_Failure_Flag_FE = 0;   // previous copy of gs_g997_Failure_Flag_FE

   gt_Tr1RolloverPayLoad.pus_PayLoad = (uint16 *)(void *)&gs_Tr1RolloverPayload;

   gt_Tr1RolloverPayLoad.uc_PayLoadLength = 1;
   gt_Tr1RolloverPayLoad.uc_PayLoadSent = 1;

   gs_Tr1RolloverPayload = 0;
   gft_Tr1RolloverFlag = 0;

   gt_Tr1AlarmPayLoad.pus_PayLoad = (uint16*)(void *)&gt_G997_TR1AlarmIndicators;
   gt_Tr1AlarmPayLoad.uc_PayLoadLength = 2;
   gt_Tr1AlarmPayLoad.uc_PayLoadSent = 1;
   gft_SendTr1AlarmFlag = 0;

   gt_FEDataPayload.pus_PayLoad = (uint16*)(void *)&gt_FEData;
   gt_FEDataPayload.uc_PayLoadLength =  sizeof(gt_FEData) / sizeof(uint16); // overwritten in ModemMonitor.c
   gt_FEDataPayload.uc_PayLoadSent = 1;
   gft_SendFEDataFlag = 0; // flag to indicate that data should be sent now

   gt_CEocStatPayload.pus_PayLoad = (uint16 *)(void *)&gt_MONI_CEocStat;

   gt_CEocStatPayload.uc_PayLoadLength = (sizeof(gt_MONI_CEocStat) / sizeof(uint16));
   gt_CEocStatPayload.uc_PayLoadSent = 1;
   gft_SendCEocStatFlag = 0;
#ifdef CLEAR_EOC
   gt_CEocMsgPayload.pus_PayLoad = (uint16 *)(void *)&(gt_INFO_CEocRxBuf.uca_MEMsg[0]); // overridden in ModemMonitor.c
#endif
   gt_CEocMsgPayload.uc_PayLoadLength = 0; // overridden in ModemMonitor.c
   gt_CEocMsgPayload.uc_PayLoadSent = 1;
   gft_SendCEocMsgFlag = 0;

   // L2_Back_Channel
   // EVT_DSM_ErrorVectorReady         0x1109
   // MONI_EVT_DSM_ERRORVECTORREADY    MONI 17     MONI_17     MONITOR 17
   gt_ErbEvtPayload.pus_PayLoad = (uint16 *)(void *)&gt_MONI_ErbMsg;
   gt_ErbEvtPayload.uc_PayLoadLength = sizeof(gt_MONI_ErbMsg)/sizeof(uint16);
   gt_ErbEvtPayload.uc_PayLoadSent = 1;
   gft_SendErbEventFlag = 0;

   // TC EVT_TC_StatusGet
   // EVT_TC_StatusGet                 0x0E22
   // DSL_TC_STATUS                    DSL 14      DSL_14
   //
   // Reports the used TC-Mode.
   // Supported settings:
   //    0x1 EFM_TC EFM TC
   //    0x2 ATM_TC ATM TC
   gt_Bonding_TC.pus_PayLoad = (uint16 *)(void *)&gt_Bonding_TC_Info.s_TC_Type;
   gt_Bonding_TC.uc_PayLoadLength = sizeof(gt_Bonding_TC_Info)/sizeof(int16);
   gt_Bonding_TC.uc_PayLoadSent = 1;
   gft_autonomous_msg_flag = FALSE;
   gft_bonding_TC_autonomous_sent = FALSE;
}

void ModemMonitorInit(void)
{
   gs_ModemMonitorState = MODEM_MONITOR_AUTO_MSG_HANDLER;

   AutoMsgHandlerInit();
}

