/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   File Name: RunCores.c
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "cmv.h"
#include "afeif_iof.h"
#include "corexec.h"
#include "gdata.h"

#include "aux_regs.h"
#include "ll_iof.h"

/*****************************************************************************
;   Prototype:  int16 RunCores(void)
;
;      Clock cores until an interrupt occurs.
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;   Global Variables:
;****************************************************************************/

#ifdef POLLING_CORE_INTERRUPTS
int16 RunCores(void)
{
   static FlagT ft_ExitRequest=0;
   uint32 ula_int0[2], ula_int1[2];
   int16 s_ReturnVal;

   int16 s_Interrupt_Detected;

   s_Interrupt_Detected = 0;

   while(!s_Interrupt_Detected && !ft_ExitRequest)
   {

      //For sample based connectivity test using strymon
      if((TESTArray[TEST_Mode] == STANDARD_STRYMON_CONNECT) && (TESTArray[TEST_LoopbackMode] == TEST_LpbkDisabled))
      {
         ClockCores(1, ula_int0, ula_int1);
      }
      else
      {
         //Used for FDCONN or loopback test
         ClockCores_NoStrymon(1, ula_int0, ula_int1);
      }



      // For connectivity tests, poll for exit request from other modem
      // Even though same check is done in the main_hw.c:while() loop,
      // it needs to be here since DLI termination on the remote modem
      // could cause a dead lock in this loop.
      if (TESTArray[TEST_Control] & TEST_ConnControl)
      {
         ft_ExitRequest = PollForExitRequest();
      }
   }

   if(ft_ExitRequest)
   {
      s_ReturnVal = 0;
   }
   else
   {
      s_ReturnVal = 1;
   }

   return (s_ReturnVal);
} //RunCores()

#endif //#ifdef POLLING_CORE_INTERRUPTS
