/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: cmv_init.c
*
*   This file contains CMV processing routines.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// cmv_int.c
//
// History
//
// 16/05/2012 Vinjam: Enabling/Disabling Downstream Virtual Noise feature control is moved from CMV MONI 4 to
//            CMV DSL 0, as per VR9 Message Specifications (1.6.1)
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 05/12/2012 Ram: Aligning to Msg Spec 1.8:- DSL 13, NTR is to be disabled by default
//                 and Value '1' in 'bit 0' indicates NTR is enabled and Value '0'
//                 indicates NTR is disabled.
//                 Grep for 'XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68'
//
// 29/01/2013 Sooraj: Added CMV "DSL 0 0x0008" for enabling/disabling AELEM feature
//                Grep for: XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
//
// 18/2/2013 Vinjam: Corrected enabling of upstream & downstream bitswaps as per VRx Msg Spec using "CMV OPTN 15"
//               Grep for XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl
//
// 24/04/2013 Vinjam: Added a new "IOP generic bits" to Customer IOP bits (CMV INFO 232 3) to enable/disable conveying AELEM capability in G.Hs CLR Message.
//                 It is controlled by Operator bits (CMV DSL 21). Based on the operator bits (DSL 21), Customer IOP bit (CMV INFO 232 3) will be enabled/disabled.
//                 Conveying AELEM capability in G.Hs CLR Message is enabled by default for "BT" and disabled by default for all operators.
//                 Grep for XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg
//
// 29/5/2013 Vinjam: Removed global variable gt_Bonding_DiscAggr_ControlCMV as it is redundant
//           Code changes are done for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (valid for VDSL2 & ADSL2)
//
// 11/07/2013 Vinjam: Added new IOP bit to toggle the Firmware version (first digit, chip ID) string sent in G.Hs
//            CMV allotted: CMV INFO 232 3 Bit#1, default set to "0" (i.e. sends FW version as 7.x.x.x).
//            Reason for this: (i) Old deployed Avinax Firmware supports VDSL2 ReTx for VR9 FW (5.x.x.x.x.x) only. So
//            to bring up VDSL2 ReTx with old Avinax DSLAM, send VRx318 FW version as 5.x.x.x (instead of 7.x.x.x) in G.Hs.
//            (ii) VRx318 FW sends FW version as 7.x.x.x with new Avinax firmware for VDSL2 ReTx.
//            Grep for XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString
//
// 15/7/2013 Vinjam: Reset "CMV STAT 1" (i.e. selected mode) to "0" at link start. This removes the ambiguity
//           in selected mode at link fail state
//           Grep for XDSLRTFW-960 Fix_All_All_All_ResetSelectedMode
// //18/09/2013 Varun : commented some of the code part to avoid of mips profiling before training if TEST 0 0 is 0x1000
//                     Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
//
// 05/03/2014 Prashant: Controlling the line driver mode using a CMV. Set line driver (DSL 10) after CNTL 0 0 2.
//            Reprogram line driver only if it is different from initialized one.
//            Grep for XDSLRTFW-1630
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//    The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//    The internal split is not well-balanced for the wished service rates.
//    According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//    According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//    framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//    D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//    1-symbol reduction in Qtx,min calculation:
//    It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//    the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//    occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it's not needed to take into account the
//    +1 symbol in the Qtx,min calculation.
//    If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//    For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//    the left triangle part.
//    If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//    is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//    shown in the drawings before the triangle.
//    So from the figures it could be derived:
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//    But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//    Grep for : XDSLRTFW-2858
//
// 12/09/2017 Hanyu Liu: Added Operator select AT_T for CMV DSL 21 0 0xE and CTL for CMV DSL 21 0 0x11 to disable conveying AELEM capability in G.Hs CLR messages.
//                  Grep: XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS
//
// 15/03/2018 Sriram Shastry: Do changes for KPN operator also for OTE_GREECE and MT_HUNGARY
// - Used TEST_TX_PSD_CONTROL_BRCM_MODE instead of TEST_TX_PSD_CONTROL_KPN_MODE.
// - Changed BRCM PSD boost for US1 and US2, i.e. from 0.5dB (US1) and 1.5dB (US2) to 1.0dB (US1) and 1.0dB
// - No KL0 reduction, i.e. bit "TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_10_PERC" should not be set
// Seearch  for XDSLRTFW-3740
//
// 08/06/2018 Hanyu Liu: XDSLRTFW-3833 Reuse XDSLRTFW-3212 code structure of TEST_TX_PSD_CONTROL to fine tune PSD boost for the following:
//             1. Applied TEST_TX_PSD_CONTROL_CTL_MODE (1dBm/Hz boost US1/US2) on all loops against all DSLAMs/COs in all VDSL2 profiles for CTL or AT_T CMV.
//             2. US1 PSD boost additional 0.5dBm/Hz on 3kft and longer loops to improved US data rates against all DSLAMs/COs in all VDSL2 profiles for CTL or AT_T CMV.
//                Seearch for XDSLRTFW-3833
//
// ************************************************************************************************************
#include "string.h"

#include "common.h"
#include "cmv.h"
#include "cmv_data.h"
#include "gdata.h"
#include "afe.h"
#include "timestmp.h"
#include "ghs.h"
#include "TxPSDCOntrol.h"
#include "eoc.h"
#include "xTC_VersionInfo_Init.h"
#include "ghs.h"

#include "cri_ini.h"


/*******************************************************************************
*
*   Prototype: void CMVLatchAtLinkStart(void)
*
*   This function latches certain CMV settings at Link Start by
*   copying the CMV settings to internal variables.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/


void CMVLatchAtLinkStart(void)
{
   int16 i;

   //=========================================================================
   // Set internal algorithm control variables
   //=========================================================================

   if(gsa_Optn0_ModeControl[0] != 0)
   {
      guc_ClrControl &= ~CLR_SEND_NOT_ADSL_MODES;

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_1_A)
      {
         guc_SI_SPar1_Optn0 |= G992_1_A;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_1_B)
      {
         guc_SI_SPar1_Optn0 |= G992_1_B;
      }

      //XDSLRTFW-2137 (Start)
      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_2_AB)
      {
         guc_SI_SPar1_Optn0 |= G992_2_AB;
      }
      //XDSLRTFW-2137 (End)

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_A)
      {
         guc_SI_SPar3_Optn0 |= G992_3_A;
      }
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG (START)
      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_L_Mask1)
      {
         guc_SI_SPar3_Optn0 |= G992_3_A;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_L_Mask2)
      {
         guc_SI_SPar3_Optn0 |= G992_3_A;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_B)
      {
         guc_SI_SPar3_Optn0 |= G992_3_B;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_I)
      {
         guc_SI_SPar3_Optn0 |= G992_3_I;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_J)
      {
         guc_SI_SPar3_Optn0 |= G992_3_J;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_5_A)
      {
         guc_SI_SPar4_Optn0 |= G992_5_A;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_5_B)
      {
         guc_SI_SPar4_Optn0 |= G992_5_B;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_5_I)
      {
         guc_SI_SPar4_Optn0 |= G992_5_I;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_3_M)
      {
         guc_SI_SPar4_Optn0 |= G992_3_M;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_5_J)
      {
         guc_SI_SPar4_Optn0 |= G992_5_J;
      }

      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_G992_5_M)
      {
         guc_SI_SPar5_Optn0 |= G992_5_M;
      }

//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG (END)
   }
   else
   {
      guc_SI_SPar1_Optn0 = 0;
      guc_SI_SPar3_Optn0 = 0;
      guc_SI_SPar4_Optn0 = 0;
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG
      guc_SI_SPar5_Optn0 = 0;
      guc_ClrControl |= CLR_SEND_NOT_ADSL_MODES;
   }

   // OPTN_2_0 CMV
   //--------------
   gft_EnableDecUpdate = 1;
   if (gsa_Optn2_AlgControl[0] & OPTN_DecUpdateDisable)
   {
      gft_EnableDecUpdate = 0;
   }

   // OPTN_2_1 CMV
   //--------------
   gft_HybridTrainingEnable       = (gsa_Optn2_AlgControl[1] & OPTN_HybridDnldDisable) ? 0 : 1;
   gt_TxParrConfig.s_TxParrEnable = (gsa_Optn2_AlgControl[1] & OPTN_PARRDisable) ? 0 : 1;
   gft_PGADnldEnable              = (gsa_Optn2_AlgControl[1] & OPTN_PGADnldDisable) ? 0 : 1;

   gft_EnableMfdq = 1;
   if (gsa_Optn2_AlgControl[1] & OPTN_MFDQInitDisable)
   {
      gft_EnableMfdq = 0;
   }

   if (!(gsa_Optn2_AlgControl[1] & OPTN_MedleyMultiSynchDisable))
   {
      gs_MedleyFrameSynchEnableFlag |= (EN_MEDLEY_SKIP_FINAL_FDQSNR|EN_MEDLEY_SNR_FRAMEALIGNMENT);
   }

   gs_bypass_tdq = 0;
   if (gsa_Optn2_AlgControl[1] & OPTN_TdqDisable)
   {
      gs_bypass_tdq = 1;
   }

   gft_EnableDEC = 1;
   if (gsa_Optn2_AlgControl[1] & OPTN_DecDisable)
   {
      gft_EnableDEC = 0;
      // disable DEC update if DEC training is disabled
      gft_EnableDecUpdate = 0;
   }

   // XDSLRTFW-3738 (Start End)
   if (gsa_Optn2_AlgControl[1] & OPTN_AdjustUsCeilingDisable)
   {
      // Disable CPE US0 ceiling based on the US PSD Mask and UPBO info.

      // ChDis US0 ceiling is chosen by CO
      gs_DeltaUsPsdCeilValue_ChDis = (int16)DISABLE_US0_CEILING;
      // TrTrain US0 ceiling is chosen by CO
      gs_DeltaUsPsdCeilValue_TrTrain = (int16)DISABLE_US0_CEILING;
   }

   // OPTN_2_2 CMV
   //--------------
   gft_TxTcmFlag = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_TxTcmDisable)
   {
      gft_TxTcmFlag = 0;
   }

   gft_RxTcmFlag = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_RxTcmDisable)
   {
      gft_RxTcmFlag = 0;
   }

   gft_EnableFdqUpdate = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_SFDQUpdatesDisable)
   {
      gft_EnableFdqUpdate = 0;
   }

   gft_EnableSnrUpdate = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_SNRUpdatesDisable)
   {
      gft_EnableSnrUpdate = 0;
   }

   gft_FineGainOn = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_RxFineGainDisable)
   {
      gft_FineGainOn = 0;
   }

   gft_EnableRxIlvTrt = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_RxIlvTrtDisable)
   {
      gft_EnableRxIlvTrt = 0;
   }

   gft_EnableTxPSDCtrl = 1;
   if (gsa_Optn2_AlgControl[2] & OPTN_TxPSDCtrlDisable)
   {
      gft_EnableTxPSDCtrl = 0;
   }

   //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (Start)
   gft_EnableNTR = 0;
   if (gus_ApiOptions & OPTION_NTR_ENABLE)
   {
      gft_EnableNTR = 1;
   }
   //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (End)
   // OPTN_2_3 CMV
   // Selecting the HW mode:
   // VDSL_MODE == 0, double train disabled
   // ADSL_PLUS_MODE == 1  double train disabled
   // ADSL_PLUS_PLUS_MODE == 2  double train disabled
   // OPTN_DoubleTrainEnable == 0xE  double train enabled, starting with VDSL mode
   if( (gsa_Optn2_AlgControl[3] & 0xF) == OPTN_DoubleTrainEnable)
   {
      gs_bypass_doubletrain = 0;
      gs_ModemHwMode = VDSL_MODE;
   }
   // For the time being, disable double train when VDSL 35C is configured
   else if((gsa_Optn2_AlgControl[3] & 0xF) == OPTN_Config_8192DSUS_TONES)
   {
        gs_bypass_doubletrain = 1;
        gs_ModemHwMode = VDSL_MODE_35C;
   }
   // For the time being, disable double train when VDSL 35B is configured
    else if((gsa_Optn2_AlgControl[3] & 0xF) == OPTN_Config_8192DS_TONES)
    {
        gs_bypass_doubletrain = 1;
        gs_ModemHwMode = VDSL_MODE_35B;
    }
   else
   {
      gs_bypass_doubletrain = 1;
      gs_ModemHwMode = gsa_Optn2_AlgControl[3] & 0x3;
   }

   //XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl (Start)
   if(OPTNArray[OPTN_OLRControl] & OPTN_TxBitSwapEnable)
   {
      gft_EnableTxBitSwap = 1;
   }
   else
   {
      gft_EnableTxBitSwap = 0;
   }

   if(OPTNArray[OPTN_OLRControl] & OPTN_RxBitSwapEnable)
   {
      gft_EnableRxBitSwap = 1;
   }
   else
   {
      gft_EnableRxBitSwap = 0;
   }
   //XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl (End)

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   // OPTN_OLRControl

   if (OPTNArray[OPTN_OLRControl] & OPTN_DS_SRAEnable)
   {
      gft_CapableRxAutoSRA = 1;
   }
   else
   {
      gft_CapableRxAutoSRA = 0;
   }


   if (OPTNArray[OPTN_OLRControl] & OPTN_US_SRAEnable)
   {
      gft_CapableTxSRA = 1;
   }
   else
   {
      gft_CapableTxSRA = 0;
   }
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
   //=========================================================================
   // Set internal algorithm control variables
   //=========================================================================

#ifdef DISTRIBUTE_TX_RX_PROCESS
   if (gsa_Cnfg_Misc[0] & CNFG_Misc_DistributeTxRxProcessing)
   {
      gft_DistributeTxRxProcess = 1;
   }
   else
   {
      gft_DistributeTxRxProcess = 0;
   }
#endif // DISTRIBUTE_TX_RX_PROCESS

   if (gsa_Cnfg_Misc[0] & CNFG_Misc_LOSDetectionWorkaround)
   {
      guc_LOSDefectType = 1;   // LOS defect detection based on power level
   }
   else
   {
      guc_LOSDefectType = 2;   // LOS defect detection based on (power level || sef_defect)
   }

   if (gsa_Cnfg_Misc[0] & CNFG_Misc_INPFix)
   {
      gft_EnableINPFix = TRUE;
   }
   else
   {
      gft_EnableINPFix = FALSE;
   }

   //XDSLRTFW-503 (Start)
   if((TESTArray[TEST_Control3] & TEST_ForceDownStreamFineGainsToUnity))
   {
      gft_FineGainOn = 0;
   }
   //XDSLRTFW-503 (End)

   //Reconfig the SNR margin reduction flag based on the fine gain flag
   if (gs_DisableFGMarginReductionFlag == 0)
   {
      gs_MarginReductionEnableFlag = gft_FineGainOn;
   }


   // copy the power config CMV to the internal variable.
   gt_PwrConfigParam = gt_PwrConfigParamCMV;

   // copy the PSD descriptor CMV to the internal variable
   gt_MaxDsPSDDescriptorTable = gt_MaxDsPSDDescriptorTableCMV;
   gt_MaxUsPSDDescriptorTable = gt_MaxUsPSDDescriptorTableCMV;
   gt_RefUsPSDDescriptorTable = gt_RefUsPSDDescriptorTableCMV;

   ///////////////////////////////////////////////////////////////////////////////////
   // Map the CMV controllable Min Msg-Based Overhead Rate (gt_MinMsgOHRConfig)
   // to internal variables (guc_DsMinMsgOHR & guc_UsMinMsgOHR) that are
   // exchanged in the O-MSG1 or R-MSG2
   // NOTE: CMV API always takes the input as [n kbps] instead of [n-1 kbps]
   //       The value exchanged in message is always in the format of [n-1 kbps]
   ///////////////////////////////////////////////////////////////////////////////////
   guc_DsMinMsgOHR = (uint8)(gt_MinMsgOHRConfig.us_DsMinMsgOHR-1);
   guc_UsMinMsgOHR = (uint8)(gt_MinMsgOHRConfig.us_UsMinMsgOHR-1);


   //////////////////////////////////////////////////
   // Convert PSD breakpoints to 0.1 dB format,
   // since API spec lists them as in 0.5 dB format
   //////////////////////////////////////////////////
   //CNFGMap[CNFG_DS_MAX_PSD_Brkpt_Ctrl] = (int16*)(DsPSDDescriptorTable_t*)&gt_MaxDsPSDDescriptorTable;
   for (i = 0; i < gt_MaxDsPSDDescriptorTable.us_NumberOfTones; i++)
   {
      gt_MaxDsPSDDescriptorTable.ut_PSDRecord[i].s_PSDLevelOfTone *= 5;
   }
   //CNFGMap[CNFG_US_REF_PSD_Brkpt_Ctrl] = (int16*)(UsPSDDescriptorTable_t*)&gt_RefUsPSDDescriptorTable;
   for (i = 0; i < gt_RefUsPSDDescriptorTable.us_NumberOfTones; i++)
   {
      gt_RefUsPSDDescriptorTable.ut_PSDRecord[i].s_PSDLevelOfTone *= 5;
   }
   //CNFGMap[CNFG_US_MAX_PSD_Brkpt_Ctrl] = (int16*)(UsPSDDescriptorTable_t*)&gt_MaxUsPSDDescriptorTable;
   for (i = 0; i < gt_MaxUsPSDDescriptorTable.us_NumberOfTones; i++)
   {
      gt_MaxUsPSDDescriptorTable.ut_PSDRecord[i].s_PSDLevelOfTone *= 5;
   }

   // Sort the Max Ds PSD Descriptor table so that the Masks are in ascending order
   quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_MaxDsPSDDescriptorTable, 0, (int16)(gt_MaxDsPSDDescriptorTable.us_NumberOfTones-1));
   // Sort the Max Us PSD Descriptor table so that the Masks are in ascending order
   quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_MaxUsPSDDescriptorTable, 0, (int16)(gt_MaxUsPSDDescriptorTable.us_NumberOfTones-1));
   // Sort the Ref Us PSD Descriptor table so that the Masks are in ascending order
   quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_RefUsPSDDescriptorTable, 0, (int16)(gt_RefUsPSDDescriptorTable.us_NumberOfTones-1));

   // Latch cyclic extension and windowing parameter
   gs_DbgTxBetaLength = TESTArray[TEST_TxBetaLength];
   gs_DbgTxCPLength   = TESTArray[TEST_TxCPLength];
   gs_DbgTxCSLength   = TESTArray[TEST_TxCSLength];
   gs_DbgRxBetaLength = TESTArray[TEST_RxBetaLength];
   gs_DbgRxCPLength   = TESTArray[TEST_RxCPLength];
   gs_DbgRxCSLength   = TESTArray[TEST_RxCSLength];

   // Latch Rx HP1/HP2 configuration
   gs_PgaTrainingDbg = TESTArray[TEST_HP2_CONFIG];

   //Change the vendor ID for testing
   if(TESTArray[TEST_ChangeVendorID] != 0)
   {
      if(TESTArray[TEST_ChangeVendorID] == 1)
      {
         gul_ne_G994VendorID = BRCM_VENDOR_ID;
         gus_ne_G994VendorSpecific = 0;
      }
      else if(TESTArray[TEST_ChangeVendorID] == 2)
      {
         gul_ne_G994VendorID = IKNS_VENDOR_ID;
         gus_ne_G994VendorSpecific = 0;
      }
      else if(TESTArray[TEST_ChangeVendorID] == 3)
      {
         gul_ne_G994VendorID = 0;
         gus_ne_G994VendorSpecific = 0;
      }
      else if(TESTArray[TEST_ChangeVendorID] == 4)
      {
         gul_ne_G994VendorID = AWRE_VENDOR_ID;
         gus_ne_G994VendorSpecific = 0;
      }
      else if(TESTArray[TEST_ChangeVendorID] == 5)
      {
         gul_ne_G994VendorID = TI_VENDOR_ID;
         gus_ne_G994VendorSpecific = 0;
      }
      // XDSLRTFW-3573 (Start)
      else if (TESTArray[TEST_ChangeVendorID] == 6)
      {
         gul_ne_G994VendorID = REALTEK_VENDOR_ID;
         gus_ne_G994VendorSpecific = 0;
      }
      // XDSLRTFW-3573 (End)

      //---------------------------------------------------------
      // Set G994.1 vendor information
      //---------------------------------------------------------
      /* CountryCode */
      //gt_ne_VendorInformation.uca_CountryCode[1] = (uint8)gus_ne_CountryCode;
      //gt_ne_VendorInformation.uca_CountryCode[0] = (uint8)(gus_ne_CountryCode >> 8);
      /* VendorID */
      gt_ne_VendorInformation.uca_VendorId[3] = (uint8)gul_ne_G994VendorID;
      gt_ne_VendorInformation.uca_VendorId[2] = (uint8)(gul_ne_G994VendorID >> 8);
      gt_ne_VendorInformation.uca_VendorId[1] = (uint8)(gul_ne_G994VendorID >> 16);
      gt_ne_VendorInformation.uca_VendorId[0] = (uint8)(gul_ne_G994VendorID >> 24);
      /* Vendor Specific Information */
      gt_ne_VendorInformation.uca_VendorSpecific[1] = (uint8)gus_ne_G994VendorSpecific;
      gt_ne_VendorInformation.uca_VendorSpecific[0] = (uint8)(gus_ne_G994VendorSpecific >> 8);
   } //if(TESTArray[TEST_ChangeVendorID] != 0)

   InitializeParameterInfoField( gpt_TxInfo );
   InitializeParameterInfoField( gpt_TxInfoSave );

   //---------------------------------------------------------
   // Set G.997.1 XTU R serial number (see clause 7.4.8/G.997.1)
   //---------------------------------------------------------
   // xTU-R serial number  :    "<equipment serial number> <equipment model> <equipment firmware version>".
   //                            <        12 byte        > <     9 byte    > <           9 byte         >
   //                            <       MAC_ADDR        > <   CPE MODEL   > <         UGW-Version      >
   // Example:                  "001122334455 VRX288___ UGW-6.1__"  (Note: The two spaces are required per G.997.1)
   //
   // Note: The old default setting of the DSL-API was
   //       SerialNumber=01234567890123456789012345678901
   //
   // Check wrong old default setting and replace it with new FW internal setting!
   {
      int16 us_ValidNum;

      {
         unsigned int i;
         //                                       (0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1)
         uint8 uca_CmpString[SERIAL_NUM_LENGTH] = {0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
                                                   0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
                                                   0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
                                                   0x30, 0x31};
         uint8 *puc_Data;

         us_ValidNum = 0;
         puc_Data = &guca_ne_SystemSerialNum[0];
         for(i = 0; i < SERIAL_NUM_LENGTH; i++)
         {
            if(*puc_Data++ == uca_CmpString[i])
            {
               us_ValidNum++;
            }
         }
      }

      if(us_ValidNum == SERIAL_NUM_LENGTH)
      {
         uint8 *puc_SerialNumber;
         //                                (_)   (_)   (_)   (_)   (_)   (_)  (SP)  (V)   (R)   (X)   (2)    (8)   (8)
         //                                (_)   (_)   (_)  (SP)   (U)   (G)   (W)  (-)   (X)   (.)    (Y)   (_)   (_)
         uint8 uca_SerialNumString[26] = {0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x20, 0x56, 0x52, 0x58, 0x02, 0x08, 0x08,
                                          0x5F, 0x5F, 0x5F, 0x20, 0x55, 0x47, 0x57, 0x2D, 0x58, 0x2E, 0x59, 0x5F, 0x5F};

         puc_SerialNumber = &guca_ne_SystemSerialNum[0];
         // CMD_MAC_FrameConfigure, Message Identifier: 0x5348
         //                         CMV CNFG 83
         // -> CNFGMap[CNFG_CMD_MAC_FRAMECONFIGURE], with CNFG_CMD_MAC_FRAMECONFIGURE = 83
         *puc_SerialNumber++ = (gt_MacFrameConfigure.SrcMacAdrsB0_1 >>8);
         *puc_SerialNumber++ = (gt_MacFrameConfigure.SrcMacAdrsB0_1 & 0xFF);
         *puc_SerialNumber++ = (gt_MacFrameConfigure.SrcMacAdrsB2_3 >>8);
         *puc_SerialNumber++ = (gt_MacFrameConfigure.SrcMacAdrsB2_3 & 0xFF);
         *puc_SerialNumber++ = (gt_MacFrameConfigure.SrcMacAdrsB4_5 >>8);
         *puc_SerialNumber++ = (gt_MacFrameConfigure.SrcMacAdrsB4_5 & 0xFF);
         memcpy(puc_SerialNumber, &uca_SerialNumString[0], 26);
      }
   }

   //------------------------------------------------------------
   //State machine variable
   //------------------------------------------------------------
   if (gs_MONI_AutoRestart & MONI_EnableDiagMode)
   {
      gul_OperationModeCapable_VDSL2 |= V2_LOOP_DIAG;
   }
   else
   {
      gul_OperationModeCapable_VDSL2 &= ~V2_LOOP_DIAG;
   }

   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
   //Enabling/Disabling Downstream Virtual Noise feature control is moved from MONI 4 to DSL 0

   // set DS virtual noise enable/disable in gul_OperationModeCapable_VDSL2 for handshaking
   if(gus_FeaturesControl & DSL_EnableDSVirtualNoise)
   {
      gul_OperationModeCapable_VDSL2 |= V2_VIRTUAL_NOISE_DS;
   }
   else
   {
      gul_OperationModeCapable_VDSL2 &= ~V2_VIRTUAL_NOISE_DS;
   }

   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

   // enable/disable Equalized FEXT UPBO for handshaking
   if (gt_UPBOControl.s_control & 0x2)
   {
      gul_OperationModeCapable_VDSL2 |= V2_EQ_FEXT_UPBO;
   }
   else
   {
      gul_OperationModeCapable_VDSL2 &= ~V2_EQ_FEXT_UPBO;
   }



   if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_Skip_RLineProbe)
   {
      gul_OperationModeCapable_VDSL2 &= ~V2_LINEPROBE;
   }
   else
   {
      gul_OperationModeCapable_VDSL2 |= V2_LINEPROBE;
   }

   // Enable support of full-vectoring-friendly operation
   if (gus_DsmCtrlCmv & G9932_FULL_VECTORING_FRIENDLY_SUPPORT)
   {
      gul_OperationModeCapable_VDSL2 |= (V2_VECTOR_FULL_FRIENDLY << 24);
   }

#ifdef VDSL_BONDING
#endif
   //----------- Performance Counter Inhibition -------------

   if(gt_G997_Cntrl.s_TR1_enabled & CNTR_TR1_CntrInhibit_Enable)
   {
      guc_EnableInhibition=1;
   }
   else
   {
      guc_EnableInhibition=0;
   }

   //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START)
   //commented to avoid mips calculation till training
   //if (TESTArray[TEST_Control] & TEST_TaskProfileControl)
   //   gft_EnableTaskProfile = TRUE;
   // XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(STOP)
   //disable mips profiling always.
   gft_EnableTaskProfile = FALSE;

   //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)
   // This bits below are not operator specific
   gt_CustomerIopBits.us_ECI = ECI_DPBO_LONGREACH_PILOT;
   gt_CustomerIopBits.us_ECI |= (ECI_TXECHO_PILOT_FIXES | ECI_PILOT1_TONEIDX_BIAS);
   //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)

   // XDSLRTFW-3740  (Start)
   // Operator specific CO independent feature/bit initialization (Start)

   if (gt_Dsl_Operator_Select.us_Operator_Select == DTAG) //CMV DSL 21 0 1
   {
      // XDSLRTFW-4051: Fast downstream up shift SRA
      gt_FastDsSraConfig.us_FastDsSraConfig &= (~CNFG_DISABLE_FAST_DS_UPSHIFT_SRA) ; // Enable Fast DS up shift SRA feature if DTAG bit is set
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == BT) //CMV DSL 21 0 2
   {
      // XDSlRTFW-4012: Enable BRCM like US PSD also for operator BT. This replaces also the
      //                old boost like done on VR9.
      TESTArray[TEST_TX_PSD_CONTROL] = ((TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_BRCM_MODE<<8));

      //XDSLRTFW-1325
      //KL0 : Derive from AELEM data
      gt_CustomerIopBits.us_ECI |= (ECI_DPBO_TACORRECTION | ECI_KL0_WORKAROUND);

      // XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg (Start_End)
      //Enable conveying AELEM capability in G.Hs messages by default for "BT"
      gus_FeaturesControl |= DSL_EnableAELEM;
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == TELEFONICA) //CMV DSL 21 0 3
   {
      //XDSLRTFW-475 PERF_DS_ALL_ALL_CEILING_OPT_17A
      //XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH
      gt_CustomerIopBits.us_TELEFONICA_DS_US_RATES |= (TELEFONICA_CHANGE_TXBAND | TELEFONICA_17A_DS_CEIL_OPT);
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == KPN) //CMV DSL 21 0 5
   {
      TESTArray[TEST_TX_PSD_CONTROL] = (TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_KPN_MODE<<8) | (TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_10_PERC);
   }
   else if(gt_Dsl_Operator_Select.us_Operator_Select == TELIASONERA) //CMV DSL 21 0 6
   {
      //XDSLRTFW-610 IOP_US_ALL_VDMF_NoConnectUPBO
      gt_CustomerIopBits.us_TELIASONERA_UPBO |= TELIASONERA_UPBO_NOCONNECT;
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == FIBER_HOME) //CMV DSL 21 0 7
   {
      //XDSLRTFW-1836 : Fiber Home Workaround CMV. Tiny correction XDSLRTFW-4126.
      gt_CustomerIopBits.us_Generic_IOP_Fixes |= GENERIC_HANDLE_WRONG_PROFILE;
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == OTE_GREECE) //CMV DSL 21 0 12
   {
      TESTArray[TEST_TX_PSD_CONTROL] = ((TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_BRCM_MODE<<8));
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == AT_T) //CMV DSL 21 0 14
   {
      //XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS
      //XDSLRTFW-3833 Enable TEST_TX_PSD_CONTROL_CTL_MODE against all DSLAMs/COs in all VDSL2 profiles at CTL (CenturyLink)and AT&T
      TESTArray[TEST_TX_PSD_CONTROL] = ((TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_CTL_MODE<<8));

      // XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg (Start_End)
      // XDSLRTFW-3470 Disable conveying AELEM capability in G.Hs messages by default for AT&T/CenturyLink
      gus_FeaturesControl &= ~DSL_EnableAELEM;
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == CTL) //CMV DSL 21 0 17
   {
      // XDSLRTFW-4216 :CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (NMS) (Start)
      // Configure NMS related variables
      // 1. Enable NMS
      gt_NoiseMarginChange.s_NM_Ctrl = (OPTN_NoiseMarginChange_NM_Ctrl_NMS_HW_EN | OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN);
      // 2. Disable the fix XDSLRTFW-2393 to maximize the bit loading, i.e. data rate.
      gt_NoiseMarginChange.s_min_NMS_Gain_ToBe_considered = 0; // 0 dB gain
      // XDSLRTFW-4216 :CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (NMS) (End)

      //XDSLRTFW-3833 Enable TEST_TX_PSD_CONTROL_CTL_MODE against all DSLAMs/COs in all VDSL2 profiles at CTL (CenturyLink)and AT&T
      TESTArray[TEST_TX_PSD_CONTROL] = ((TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_CTL_MODE<<8));

      // XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg (Start_End)
      // XDSLRTFW-3470 Disable conveying AELEM capability in G.Hs messages by default for AT&T/CenturyLink
      gus_FeaturesControl &= ~DSL_EnableAELEM;

   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == TELECOM_ITALIA) //CMV DSL 21 0 18
   {
      TESTArray[TEST_TX_PSD_CONTROL] = (TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_KPN_MODE<<8) | (TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_10_PERC);
   }
   else if (gt_Dsl_Operator_Select.us_Operator_Select == MT_HUNGARY) //CMV DSL 21 0 19
   {
      TESTArray[TEST_TX_PSD_CONTROL] = ((TESTArray[TEST_TX_PSD_CONTROL] & 0xF0FF) | (TEST_TX_PSD_CONTROL_BRCM_MODE<<8));
   }
   // Operator specific CO independent feature/bit initialization (End)

   //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
   if (TESTArray[TEST_GHS_LOG] & TEST_GHS_GOTO_FAIL)
   {
      gft_GotoFailStateOnTimeOut_FromHandshake = TRUE;
   }
#endif
   //XDSLRTFW-2288 (End)

   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
   //XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg (Start_End)
   if(gus_FeaturesControl & DSL_EnableAELEM)
   {
      gul_OperationModeCapable_VDSL2 |= (V2_ELE_METHOD1 << 24);
   }
   else
   {
      gul_OperationModeCapable_VDSL2 &= ~(V2_ELE_METHOD1 << 24);
   }
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)


   //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (Start)
   // if(gt_CustomerIopBits.us_Generic_IOP_Fixes & GENERIC_TOGGLE_CHIP_ID_IN_GHS_VERSION)
   // {
      // // Init_SystemVendor_VersionInfo(); // XDSLRTFW-3914 FW use routine twice here,so comment out
      // /* Vendor Specific Information */
      // gt_ne_VendorInformation.uca_VendorSpecific[1] = (uint8)gus_ne_G994VendorSpecific;
      // gt_ne_VendorInformation.uca_VendorSpecific[0] = (uint8)(gus_ne_G994VendorSpecific >> 8);
   // }
   //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (End)

   //XDSLRTFW-960 Fix_All_All_All_ResetSelectedMode (Start)
   //Reset "CMV STAT 1" to remove the ambiguity on selected mode at link fail state
   gsa_Stat1_Mode[0] = 0;
   gsa_Stat1_Mode[1] = 0;
   //XDSLRTFW-960 Fix_All_All_All_ResetSelectedMode (End)


   //XDSLRTFW-2364 (Start)
#ifdef GHS_TN_DBG
   if(TESTArray[TEST_GHS_LOG] & TEST_GHS_LOG_ENABLE)
   {
      TESTArray[TEST_GHS_LOG] |= HALT_AFTER_TONE_DETECTION;
   }
#endif
   //XDSLRTFW-2364 (End)

   /* XDSLRTFW-2858 */
   gs_CpeRxHalfRoundTripDelays_ForcedInFraming = TESTArray[TEST_DS_RETX_HRT];
   /* XDSLRTFW-2858 */

   // XDSLRTFW-3898 (Start)
   if(TESTArray[TEST_SetHybrid_Index]>=0)
   {
      gs_HybTrIndexDbg = TESTArray[TEST_SetHybrid_Index];
   }
   // XDSLRTFW-3898(End)
} //void CMVLatchAtLinkStart(void)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UpdateINFOMapHWBufPtrs(void)
*
*   This function updates CMVs mapped to HW buffer pointers.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void UpdateINFOMapHWBufPtrs(void)
{
   // Needs to update the INFOMap since the HW buffer pointers keep changing.
   INFOMap[INFO_ActiveBat] = (int16*)(void *)ghpuca_TxBat_Active;
   INFOMap[INFO_ActiveFineGains] = ghpsa_TxFineGains_Active;
   INFOMap[INFO_ActiveExtendedGains] = (int16*)(void *)ghpuca_TxExtGains_Active;
   INFOMap[INFO_InactiveBat] = (int16*)(void *)ghpuca_TxBat_Inactive;
   INFOMap[INFO_InactiveFineGains] = ghpsa_TxFineGains_Inactive;
   INFOMap[INFO_InactiveExtendedGains] = (int16*)(void *)ghpuca_TxExtGains_Inactive;
}


#ifdef TARGET_HW_TEST
void ConfigCMV(void)
{
#ifdef VR9_SHOW_LPBK1_TEST

//vdsl2_lpbk1_cpeshow_cpe.sc
//cw TEST 0 0 0x0100       // SFControl: on
   TESTArray[TEST_Control] = 0x100;

//cw TEST 2 0 2          // init state: showtime
   TESTArray[TEST_InitState] = 2;

//cw TEST 5 0 200       // SFCnt: 200
   TESTArray[TEST_TestSFCnt] = 200;

//cw TEST 6 0 1          // Loopback Mode: DTB
   TESTArray[TEST_LoopbackMode] = 1;

//cw optn 0 1 4         // 1: for VDSL1, 4 for VDSL2
   gsa_Optn0_ModeControl[1] = 4;

//cw OPTN 2 1 0x000C       // PARR: off, MFDQ train: off
//This is the default setting

   /*
   // OPTN_AlgControl[2]
   #define OPTN_TxTcmDisable            0x0001
   #define OPTN_RxTcmDisable            0x0002

   #define OPTN_SFDQUpdatesDisable         0x0010
   #define OPTN_MFDQUpdatesDisable         0x0020
   #define OPTN_SNRUpdatesDisable         0x0040
   #define OPTN_RxFineGainDisable         0x0080
   #define OPTN_TxPSDCtrlDisable           0x0100
   #define OPTN_NTRDisable               0x0200
   #define OPTN_RxIlvTrtDisable         0x0400
   #define OPTN_TxSRADisable             0x0800
   #define OPTN_RxSRADisable            0x1000
   // RESERVED                            0x2000
   #define OPTN_USExtSMaxDisable             0x4000  // disables US optional extended Smax
   #define OPTN_DSExtSMaxDisable             0x8000  // disables DS optional extended Smax

   */
//cw OPTN 2 2 0x003F       // tcm: off, bit-swap: off, FDQ update: off, MFDQ update: off, SNR update: on
   gsa_Optn2_AlgControl[2] = 0x003F;

//cw CNFG 10 0 0         // Tx BC to Lp mapping
//cw CNFG 10 1 0xF
//cw CNFG 10 2 0         // Tx MSGlp
//These are the default settings

//cw CNFG 20 0 0         // Rx BC to Lp mapping
//cw CNFG 20 1 0xF
//cw CNFG 20 2 0         // Rx MSGlp
//These are the default settings

//cw info 34 0 11         // Bpn
//cw info 34 4 4         // Tp = k * Mp
//cw info 34 6 8         // Gp
//cw info 34 8 12         // Fp
//cw info 34 10 2         // Mp
//cw info 34 12 224         // Lp
//cw info 34 14 2         // Rp
//cw info 34 16 7         // Ip : D and I are co-prime
//cw info 34 18 57         // Dp
   {
      int16 *ps_config;
      ps_config = (int16*)INFOMap[INFO_DsConfigVDSL2];
      ps_config[0] = 11;
      ps_config[4] = 4;
      ps_config[6] = 8;
      ps_config[8] = 12;
      ps_config[10] = 2;
      ps_config[12] = 224;
      ps_config[14] = 2;
      ps_config[16] = 7;
      ps_config[18] = 57;
   }

//cw info 35 0 11         // Bpn
//cw info 35 4 4         // Tp = k * Mp
//cw info 35 6 8         // Gp
//cw info 35 8 12         // Fp
//cw info 35 10 2         // Mp
//cw info 35 12 224         // Lp
//cw info 35 14 2         // Rp
//cw info 35 16 7         // Ip : D and I are co-prime
//cw info 35 18 57         // Dp
   {
      int16 *ps_config;
      ps_config = (int16*)INFOMap[INFO_UsConfigVDSL2];
      ps_config[0] = 11;
      ps_config[4] = 4;
      ps_config[6] = 8;
      ps_config[8] = 12;
      ps_config[10] = 2;
      ps_config[12] = 224;
      ps_config[14] = 2;
      ps_config[16] = 7;
      ps_config[18] = 57;
   }

//cw CNTL 0 0 0x32          // loopback: on, explicit rate: on, start modem
   CNTLArray[CNTL_ModemControl] = 0x32;

#endif
} //ConfigCMV()

#endif //#ifdef TARGET_HW_TEST
