/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   mtkernel.c
*
*   Routines to implement multi-tasking kernel.
*-------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// mtkernel.c
//
// History
//
// 19/09/2013 Varun/Palaksha : Added code to enable mips profiling if test 0 0 is 0x1000
//                    Note that in VDSL Rx enters showtime first(look timing diagram of VDSL2 for more details). since we want showtime mips when both tx
//                    and rx in showtime we enable the profile tasking when tx enters showtime. foreground mips peaking occurs at tx in RPSynchro6 state.
//                    Hence condition is checked in foreground in showtime.
//                  Added FG Task Averege MIPS profiling.
//                     Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
//
// 12/06/2015 Kannan: Implemented Cascaded FW scheduling for 35b lite project to modify FFT output
//                    Grep for "XDSLRTFW-2392 Cascaded scheduling"
// ************************************************************************************************************

#include "common.h"
#include "vdsl_xception.h"
#include "gdata.h"
#include "DetectInterrupts.h"
#include "fifo.h"
#include "cri_iof.h"
#include "vdsl_state.h"
#include "profile.h"

#include "DshInterface.h"

#if defined(VR9_SHOW_LPBK_TEST)
#include "hercules_memrymap.h"
#endif

#include "aux_regs.h"

#include "nmp.h" //fix warning

#include "LL_IOf.h"
#include "cri_memmap.h"


#include "cmv_Data.h"
#include "cmv.h"
#include "vdsl_state.h"
#include "IRI_IOf.h"     //XDSLRTFW-2392 (Cascaded scheduling - Start - End)
#include "ftb_memmap.h"

//XDSLRTFW-2392 (Cascaded scheduling - Start)
typedef struct {
   PtrToFunc pf_TCTask;
   PtrToFunc pf_NTCTask;
   PtrToFunc pf_BgTask;
} FuncPtr_t;
//XDSLRTFW-2392 (Cascaded scheduling - End)

//XDSLRTFW-2392 (Cascaded scheduling - Start)
int16 Thread = 0;
Queue_t TaskQueue[NUM_THREADS];
FuncPtr_t gt_TaskFuncPtr;  // Task function pointer structure
//XDSLRTFW-2392 (Cascaded scheduling - End)

//XDSLRTFW-2392 (Cascaded scheduling - Start - End)
#define WhichThreadIsTask(task) ((((task)->TaskID)>>12)&0x7)

/* external functions */
void KernelException(uint32 i);
extern uint16 CheckAdmaCompletion(void); //XDSLRTFW-3446 (Start_End)

int16 gs_FGActive=0;
int16 gs_BgDbgCnt1;
int16 gs_BgDbgCnt2;
int16 gs_FGTaskPending;   //this variable is used in interrupt.s
uint8 guc_PortActive;


extern uint16 gus_FgNestedCount;


/*****************************************************************************
;   Prototype: void NtrInterruptHandler(void);
;
;   This routine used to be called on ARC interrupt line2 which was
;   configured to give interrupts on a wrap of the NTR counter.

;   For VR9 the counter latches on the wrap and the FW only has to call this function
;   in the showtime time critical task.
;
;   Since the reference is at 8 KHz there are two sampling points possible.
;   From t samples from symbol boundary and t+halfFrame from symbol boundary.
;   If we get a sample from the second half we convert to the equivalent delay
;   in the first half.
;   We also need to scale it to units of 212 MHz to keep the rest of the processing
;   the same.  ( 35MHz *6 , or 70 MHz * 3 )
;
;   The NTR drift metric gl_ntr_drift_metric calculation remains the same -
;   is updated based on reading the CRI_RX_TIMER value into gs_RxTimerVal, and on
;   the current value of gl_stu_count_212clocks.  If the servicing of the ntr interrupt
;   has been delayed, the metric is set to 0.
;
;   Inputs:Arguments: none.
;   Inputs:Globals: gs_frame_rate_is_8khz
;   Inputs:Globals: gl_stu_count_212clocks
;   Inputs:Globals: gl_RxSymbolCount
;   Inputs:HW regs: CRI_NTR_PHASE register.

;   Output:Arguments: none.
;   Output:Globals:   gl_ntr_drift_metric

;   Return: none.
;
;   Locally used Global Variables:   gl_ntr_drift_metric0 , gl_rx_timer_val
;
;****************************************************************************/

int32 gl_rx_timer_val; //gdata

void NtrInterruptHandler(void)
{
   int32 l_RxTimerVal;
   int16 s_half_frame = 4416; //make const? Check dualport requirement.

   {
      // GetRxCounter functionality - using the new HW counter.

      //Read NTR counter timer and deal with first/secind half.
      ReadCoreReg(CRI_NTR_PHASE_ADDR, &l_RxTimerVal);
      if (l_RxTimerVal > s_half_frame)
      {
         l_RxTimerVal = l_RxTimerVal - s_half_frame;
      }

      // scale to 212MHz unit for use with processing code.
      if (gs_frame_rate_is_8khz==0)
      {
         gl_rx_timer_val = l_RxTimerVal * 6 ;   // mul by 6 for 4 kHz frame rate.
      }
      else
      {
         gl_rx_timer_val = l_RxTimerVal * 3;
      }
   }

   // The metric is effectively X-Y.  Y is the number of 212 MHz clock cycles remaining in the
   // symbol following an NTR edge (ntr counter wrap).  X is the number of cycles that should remain,
   // based on gl_stu_count_212clocks, which is a function of the guc_rxntrbyte NTR ibits messages.
   gl_ntr_drift_metric = gl_stu_count_212clocks + gl_rx_timer_val;
   // Center the drift metric at 0.
   //if ((gl_ntr_drift_metric_0 == 0x7FFFFFFF) && (gl_RxSymbolCount>1000) && (gs_ntr_intterrupt_was_delayed==0) )
   if ((gl_ntr_drift_metric_0 == 0x7FFFFFFF) && (gl_RxSymbolCount>1000))
   {
      gl_ntr_drift_metric_0 = gl_ntr_drift_metric;
   }
   gl_ntr_drift_metric += (4416*12 + 4416*3-gl_ntr_drift_metric_0);
   gl_ntr_drift_metric = gl_ntr_drift_metric % (4416*6);
   gl_ntr_drift_metric -= (4416*3);

}


extern void CheckStrymonOverFlow(void);
extern void CheckFTOverFlow(void);
extern void CheckQTError(void);

/*****************************************************************************
;   Prototype: void CheckCoreErrorRegs(void);
;
;   This function calls the subroutines to check the error bits of Strymon,
;   FT and QT registers to update the error counts of various core errors.
;
;   Input Arguments: none.
;
;   Output Arguments: none.
;
;   Return: none.
;
;   Global Variables:
;
;
;****************************************************************************/

#ifdef ENABLE_VR9_HW_ERR_CNT

void CheckCoreErrorRegs(void)
{
   //Check strymon overflows
   CheckStrymonOverFlow();

   //Check FT error
   CheckFTOverFlow();

   //Check QT errors
   CheckQTError();

} //void CheckCoreErrorRegs(void)

#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

//#define TEST_CRI_ONLY

#ifdef TEST_CRI_ONLY
#include <stdio.h>
extern FILE *gfp_fout_TestCRI;
extern FlagT gft_PrintTx, gft_PrintRx;
#endif

/*****************************************************************************
;   Prototype: void ForegroundHandler(void);
;
;   This function runs the calls to all foreground DSP tasks (including both time
;   critical (TC) and non-time critical (NTC), and both TX and RX. Based on the multiport HW
;   task scheduling method. The RX TC tasks are called first, followed by the TX TC task,
;   TX NTC task and then RX NTC tasks.
;
;   Input Arguments: none.
;
;   Output Arguments: none.
;
;   Return: none.
;
;   Global Variables:
;      gs_InterruptSource - (I) containing the interrupt sources
;      gt_TaskArray[] -- (I) the array of task function pointers
;      gs_RxNextState -- (I) the next RX state
;      gs_RxState -- (I) the current RX state
;
;****************************************************************************/

uint32 gl_NumTxRuns, gl_NumTxStalls;
uint32 gl_NumRxRuns, gl_NumRxStalls;
int16 gs_TxQtStallRate, gs_RxQtStallRate;
FlagT gft_GetStallStat = 0;

void ForegroundHandler(void)
{
   FlagT ft_TxQtRun, ft_RxQtRun, ft_RxPmsRun;
   static int16 gs_RxPmsDelayCnt = 1;

#ifdef PROFILE_TASKS_VR9


   //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START)
   //Enable mips profiling at the beginning of showtime if test 0 0 is 0x1000. Note that in VDSL Rx enters showtime first.
   //since we want showtime mips when both tx and rx in showtime we enable the profile tasking when tx enters showtime
   if ((TESTArray[TEST_Control] & TEST_TaskProfileControl) && (gs_TxNextState==R_SHOWTIME_TX)&& (gs_RxState == R_O_SHOWTIME_RX))
   {
      gft_EnableTaskProfile = TRUE;
   }
   //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(END)

   //Start FG task profile
   LogTaskProfile(FG_TASK_ID, -1);

   //Start TC task profile
   LogTaskProfile(FG_TC_TASK_ID, -1);

   //Start TX TC task profile
   LogTaskProfile(FG_RX_TC_TASK_ID, -1);
#endif //#ifdef PROFILE_TASKS_VR9

   //If this is not expected interrupt, return
   if(gs_InterruptSource != (1<<RX_QT_DONE))
   {
      return;
   }


   //Check if RX QT is stalled or not
   ft_RxQtRun = !CheckQtStall(RX);

//DSM_Vectoring_Check:
   if(ft_RxQtRun)
   {
      gl_NumRxRuns++;
      if(gl_NumRxRuns == 0)
      {
         gl_NumRxStalls = 0;
      }
      gs_RxQTRunAfterStall++;
   }
   else
   {
      gl_NumRxStalls++;
      gs_RxQTRunAfterStall = 0; // zero indicates stall
   }

//DSM_Vectoring_Debug:
//      if(gft_GetStallStat)
//      {
//         if(gl_NumRxStalls != 0)
//            gs_RxQtStallRate = gl_NumRxRuns/gl_NumRxStalls;
//      }

   if(gft_SkipRxQtStallCheck)
   {
      ft_RxQtRun = 1;
   }

#ifdef POLLING_CORE_INTERRUPTS

   // used for FD conn test
   gs_FDInterruptSource = 0;

#endif //POLLING_CORE_INTERRUPTS


   //This flag synchronizes the RX FC NTC run with RX FC TC run
   ft_RxPmsRun = 0;

   //Run DSP tasks in the following order as required in the time-slotted scheduling method
   //1. RX time critical, 2. TX time critical, 3. TX non-time critical, 4. RX non-time critical
   if(ft_RxQtRun)   //If QT is not stalled
   {

#ifdef POLLING_CORE_INTERRUPTS
      gs_FDInterruptSource |= (1 << RX_QT_DONE);
#endif

      //RX time critical test
      if(gs_InterruptSource & (1<<RX_QT_DONE))
      {

#ifdef TEST_CRI_ONLY
         if(gft_PrintRx)
         {
            fprintf(gfp_fout_TestCRI, "\t\t\t\t\t\tRX_QT_DONE.TC: gs_RxState = %d gl_TotalTxSymbolCount = %d\n",gs_RxState, gl_TotalTxSymbolCount);
         }
#endif //TEST_CRI_ONLY

         if((gs_RxNextState == R_O_SHOWTIME_RX) || (gs_RxState == R_O_SHOWTIME_RX))
         {
            if(gs_RxPmsDelayCnt > 0)
            {
               gs_RxPmsDelayCnt--;
            }
            else
            {

#ifdef TEST_CRI_ONLY
               if(gft_PrintRx)
               {
                  fprintf(gfp_fout_TestCRI, "\t\t\t\t\t\t ------ gs_RxPMDFrameCount = %d\n", gs_RxPMDFrameCount);
                  fprintf(gfp_fout_TestCRI, "\t\t\t\t\t\tRX_FC_DONE.TC: gs_RxNextState = %d gs_RxState = %d\n",gs_RxNextState, gs_RxState);
               }
#endif //TEST_CRI_ONLY
               ft_RxPmsRun = 1;
               gt_TaskArray[RX_FC_DONE].TimeCriticalTask();
            }
         }

         //In 5.0 Implementation, RX_QT_TC task is run before RX_FC_TC task
         //Due to the order of PMS and QT is switched in 6.2 implementation
         //so we need to do this after FC TC
         gt_TaskArray[RX_QT_DONE].TimeCriticalTask();

      }
      else if(gs_InterruptSource & (1<<RX_FRAME_START))
      {
         gt_TaskArray[RX_FRAME_START].TimeCriticalTask();
      }

   }
   else
   {

#ifdef TEST_CRI_ONLY
      if(gft_PrintRx)
      {
         fprintf(gfp_fout_TestCRI, "\t\t\t\t\t\tRX_QT_STALL: gs_RxState = %d gl_TotalTxSymbolCount = %d\n",gs_RxState, gl_TotalTxSymbolCount);
      }
#endif //TEST_CRI_ONLY

      //Disable QTP for this frame
      DisableRxQtp();

      //Enable QTP in the next frame
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxQtp);

      if((gs_RxNextState == R_O_SHOWTIME_RX) || (gs_RxState == R_O_SHOWTIME_RX))
      {
         //Disable PMS for this frame
         DisableRxPms();

         //Enable PMS in the next frame
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxPms);
      }

      ClearRxStall();
   }

#ifdef PROFILE_TASKS_VR9
   //End RX TC task profile
   LogTaskProfile(FG_RX_TC_TASK_ID, gla_MipsCnt[FG_RX_TC_TASK_ID]);

   //Start TX TC task profile
   LogTaskProfile(FG_TX_TC_TASK_ID, -1);
#endif //#ifdef PROFILE_TASKS_VR9


   //Check if TX QT is stalled or not
   ft_TxQtRun = !CheckQtStall(TX);

//DSM_Vectoring_Check:
   if(ft_TxQtRun)
   {
      gl_NumTxRuns++;
      if(gl_NumTxRuns == 0)
      {
         gl_NumTxStalls = 0;
      }
      gs_TxQTRunAfterStall++;
   }
   else
   {
      gl_NumTxStalls++;
      gs_TxQTRunAfterStall = 0;   // zero indicates stall
   }

//DSM_Vectoring_Debug:
//      if(gft_GetStallStat)
//      {
//         if(gl_NumTxStalls != 0)
//            gs_TxQtStallRate = gl_NumTxRuns/gl_NumTxStalls;
//      }

   if(gft_SkipTxQtStallCheck)
   {
      ft_TxQtRun = 1;
   }

   //TX time critical task
   if(ft_TxQtRun)   //If QT is not stalled
   {

#ifdef POLLING_CORE_INTERRUPTS
      gs_FDInterruptSource |= (1 << TX_QT_DONE);
#endif

      if(gs_InterruptSource & (1<<RX_QT_DONE))
      {
#ifdef TEST_CRI_ONLY
         if(gft_PrintTx)
         {
            fprintf(gfp_fout_TestCRI, "TX_QT_DONE.TC: gs_TxState = %d gl_TotalTxSymbolCount = %d\n",gs_TxState, gl_TotalTxSymbolCount);
         }
#endif //TEST_CRI_ONLY

         gt_TaskArray[TX_QT_DONE].TimeCriticalTask();
      }

      else if(gs_InterruptSource & (1<<TX_FRAME_START))
      {
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask();
      }
   }
   else
   {

#ifdef TEST_CRI_ONLY
      if(gft_PrintTx)
      {
         fprintf(gfp_fout_TestCRI, "TX_QT_STALL: gs_TxState = %d gl_TotalTxSymbolCount = %d\n",gs_TxState, gl_TotalTxSymbolCount);
      }
#endif //TEST_CRI_ONLY

      //Disable QTP for this frame
      DisableTxQtp();

      //Enable QTP in the next frame
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxQtp);

      if((gs_TxNextState == R_SHOWTIME_TX) || (gs_TxState == R_SHOWTIME_TX))
      {
         //Disable PMS for this frame
         DisableTxPms();

         //Enable PMS in the next frame
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxPms);
      }

      ClearTxStall();
   }

   //XDSLRTFW-3446 (Start)
   if (guc_CasMode_enable == 0)
   {
      //Wait until all ADMA tasks have completed
      if (CheckAdmaCompletion())
      {
         EnterFailStates(E_CODE_ADMA_NOT_FINISHED_TS_MODE);
      }
   }
   //XDSLRTFW-3446 (End)

   // only execute when debug streams are enabled
   if(gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK)
   {
      DSH_FgService();
   }
   else
   {
      //Set VersionInfoStreamed to FALSE, so Version Info gets streamed again next time streams get enabled again
      guc_DSH_VersionInfoStreamed = FALSE;
   }

#ifdef PROFILE_TASKS_VR9
   //End RX TC task profile
   LogTaskProfile(FG_TX_TC_TASK_ID, gla_MipsCnt[FG_TX_TC_TASK_ID]);

   //End TC task profile
   LogTaskProfile(FG_TC_TASK_ID, gla_MipsCnt[FG_TC_TASK_ID]);

   //Start TX NTC task profile
   LogTaskProfile(FG_TX_NTC_TASK_ID, -1);
#endif //#ifdef PROFILE_TASKS_VR9

   //TX non-time critical task
   if(ft_TxQtRun)   //If QT is not stalled
   {
      if(gs_InterruptSource & (1<<RX_QT_DONE))
      {
#ifdef TEST_CRI_ONLY
         if(gft_PrintTx)
         {
            fprintf(gfp_fout_TestCRI, "TX_QT_DONE.NTC: gs_TxState = %d gl_TotalTxSymbolCount = %d\n",gs_TxState, gl_TotalTxSymbolCount);
         }
#endif //TEST_CRI_ONLY

         gt_TaskArray[TX_QT_DONE].NonTimeCriticalTask();
      }

      else if(gs_InterruptSource & (1<<TX_FRAME_START))
      {
         gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask();
      }
   }

#ifdef PROFILE_TASKS_VR9
   //End TX NTC task profile
   LogTaskProfile(FG_TX_NTC_TASK_ID, gla_MipsCnt[FG_TX_NTC_TASK_ID]);

   //Start RX NTC task profile
   LogTaskProfile(FG_RX_NTC_TASK_ID, -1);
#endif //#ifdef PROFILE_TASKS_VR9

   //RX non-time critical task
   if(ft_RxQtRun)   //If QT is not stalled
   {
      if(gs_InterruptSource & (1<<RX_QT_DONE))
      {

#ifdef TEST_CRI_ONLY
         if(gft_PrintRx)
         {
            fprintf(gfp_fout_TestCRI, "\t\t\t\t\t\tRX_QT_DONE.NTC: gs_RxState = %d gl_TotalTxSymbolCount = %d\n",gs_RxState, gl_TotalTxSymbolCount);
         }
#endif //TEST_CRI_ONLY

         gt_TaskArray[RX_QT_DONE].NonTimeCriticalTask();

         if(ft_RxPmsRun)
         {
#ifdef TEST_CRI_ONLY
            if(gft_PrintRx)
            {
               fprintf(gfp_fout_TestCRI, "\t\t\t\t\t\tRX_FC_DONE.NTC: gs_RxNextState = %d gs_RxState = %d\n",gs_RxNextState, gs_RxState);
            }
#endif //TEST_CRI_ONLY
            gt_TaskArray[RX_FC_DONE].NonTimeCriticalTask();
         }
      }
      else if(gs_InterruptSource & (1<<RX_FRAME_START))
      {
         gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask();
      }
   }

#ifdef TEST_CRI_ONLY
   fflush(gfp_fout_TestCRI);
#endif //TEST_CRI_ONLY


#ifdef PROFILE_TASKS_VR9
   //End TX NTC task profile
   LogTaskProfile(FG_RX_NTC_TASK_ID, gla_MipsCnt[FG_RX_NTC_TASK_ID]);

   //End FG task profile
   LogTaskProfile(FG_TASK_ID, gla_MipsCnt[FG_TASK_ID]);

   if(gft_EnableTaskProfile == FALSE)
   {
      return;
   }
   //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START)
#if 1 //Avg of FG MIPS
   gl_FGMipsCnt[gs_MipsCntRun]= gla_MipsCnt[FG_TASK_ID];
   if ( (gft_MipsAvgStart1 == TRUE) && (gs_MipsCntRun < MAX_MIPS_LOGGING_COUNT) )
   {
      gl_MaxMIPSCntSumN +=gla_MipsCnt[FG_TASK_ID];
      if (gs_MipsCntRun == (MAX_MIPS_LOGGING_COUNT-1))
      {
         gl_MaxMIPSCntAvg = (gl_MaxMIPSCntSumN >> LOG2_MAX_MIPS_LOGGING_COUNT);
         gft_MipsAvgStart1=FALSE;
      }

   }
   else
   {
      gl_MaxMIPSCntSumN -= gl_MaxMIPSCntAvg;
      gl_MaxMIPSCntSumN +=gla_MipsCnt[FG_TASK_ID];

      //gl_MaxMIPSCntAvg = ((gl_MaxMIPSCntAvg << 8) + gla_MipsCnt[FG_TASK_ID] - gl_MaxMIPSCntAvg);
      gl_MaxMIPSCntAvg = (gl_MaxMIPSCntSumN >> LOG2_MAX_MIPS_LOGGING_COUNT) ;
   }

   gs_MipsCntRun++;
   if (gs_MipsCntRun == MAX_MIPS_LOGGING_COUNT)
   {
      gs_MipsCntRun=0;
   }

#endif //FG Mips Avg
   //XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(END)

#endif //#ifdef PROFILE_TASKS_VR9

} //ForegroundHandler()


/*****************************************************************************
;   Prototype: void MasterIntHandler(void);
;
;   This interrupt service routine mainly identifies the interrupt source
;   and checks if the previous foreground process is finished or not.
;   If not, it will generate the kernel exception.
;
;   Input Arguments: none.
;
;   Output Arguments: none.
;
;   Return: none.
;
;   Global Variables:
;      gs_FDInterruptSource - (I/O) containing the interrupt sources to be used
;                               by the frequency connectivity test.
;      gs_FGActive            - (I) Flag indicating whether there is a
;                                  foreground process currently running.
;
;****************************************************************************/
extern volatile int32 gl_IntrDetected;

//Mei debug

void EnableCores_ForLinkStart(void);

volatile int32 gl_IntrCnt;

//XDSLRTFW-2392 (Cascaded scheduling - Start)
/*****************************************************************************
;   Prototype: void AddTaskToQueue(TCB_t *NewTask,Queue_t *Q);
;              void DeleteTaskFromQueue(Queue_t *Q);
;
;   These subroutines add or delete tasks to or from task queue Q.
;
;   Input Arguments:
;       TCB_t *NewTask          - pointer to TCB to be added to queue.
;       Queue_t *Q              - pointer to queue to or from which a task
;                                 is to be added or deleted.
;   Output Arguments: none.
;
;   Return: none.
;
;   Comments:
;   An empty queue is characterized by having both the Front and the
;   Rear pointers pointing to NULL:
;
;                 Front -> NULL
;                  Rear -> NULL
;
;   An one-element queue has both the Front and Rear point to the SAME TCB,
;   and that TCB in turns point to NULL:
;
;                 Front -> [1] -> NULL
;                           ^
;                           |
;                         Rear
;
;   An M-element queue has both the Front pointing to the 1st element and the
;   Rear pointing to the M-th element:
;
;                   [1] -> .... -> [M] -> NULL
;                    ^              ^
;                    |              |
;                  Front          Rear
;
;   Each time an element is added to the rear of the queue, the Rear marker
;   moves. Each time an element is deleted from the front of the queue, the
;   Front marker moves.
;   Special care needs to be taken when going from empty queue to 1 element
;   queue and vice versa.
;
;****************************************************************************/
static void AddTaskToQueue(
   TCB_t * NewTask,
   Queue_t * Q)
{

   /* See if new task is already in queue. */
   if (NewTask->TaskID & 0x8000)
   {
      KernelException(E_CODE_QUEUE_ADD_EXCEPTION);
      return;
   }

   /* Add new task to rear of queue: */
   if (Q->Front == NULL)
   {  /* empty queue */
      Q->Front = NewTask;
      Q->Rear = NewTask;
      NewTask->Next = NULL;
   }
   else
   {  /* non-empty queue */
      Q->Rear->Next = NewTask;
      NewTask->Next = NULL;
      Q->Rear = NewTask;
   }

   /* Set MSB TaskID bit to indicate TCB is now added to the queue. */
   NewTask->TaskID |= 0x8000;
}
static void DeleteTaskFromQueue(
   Queue_t * Q)
{
   /* See if queue is empty. */
   if (Q->Front == NULL)
   {
      KernelException(E_CODE_QUEUE_DELETE_EXCEPTION);
      return;
   }

   /* Clear MSB TaskID bit to indicate TCB is now deleted from the queue. */
   Q->Front->TaskID &= ~0x8000;

   /* Delete old task from front of queue: */
   Q->Front = Q->Front->Next;

   /* If there are none left, then set Rear to NULL */
   if (Q->Front == NULL)
      Q->Rear = NULL;
}
//XDSLRTFW-2392 (Cascaded scheduling - End)

void MasterIntHandler(void)
{
   //XDSLRTFW-2392 (Cascaded scheduling - Start)
   gl_IntrCnt++;
   if (guc_Start_CasMode_Int)
   {
      TCB_t *NewTask;
      Queue_t *Q;
      int16 s_interrupt;
      //int16 s_error;

      gft_Interrupt_Mailbox = FALSE; //XDSLRTFW-3699 (Start_End)
      while ((s_interrupt = DetectInterrupts()) != -1)
      {
         // We shall process the Mailbox only once per symbol. Earlier we were togglong
         // between the interrupt. It can arise ambiguity as which interrupt is used to
         // handle the mailbox query. So now, we are always handling the mailbox during
         // the Tx QT interrupt in cascaded mode of operation.
         // XDSLRTFw-3377 (Start)
         if (s_interrupt == TX_QT_DONE)
         {
            gft_Interrupt_Mailbox = TRUE;
         }
         // XDSLRTFw-3377 (End)

         NewTask = &gt_TaskArray[s_interrupt];
         if (NewTask->TimeCriticalTask != NULL)
         {
            gt_TaskFuncPtr.pf_TCTask = (*(NewTask->TimeCriticalTask));


            /*
                        if (FGActive)
                           s_error = E_CODE_STACK_OVERFLOW_IN_NTC;
                        else if (gt_TaskFuncPtr.pf_BgTask)
                           s_error = E_CODE_STACK_OVERFLOW_IN_BG;
                        else
                           s_error = 0;

                        CheckStackOverflow(s_error);
            */
            //run time critical task here
//            PROFDBG_DO_TIME_CRITICAL_BEGIN
            // (*(NewTask->TimeCriticalTask)) ();
            gt_TaskFuncPtr.pf_TCTask();
//            PROFDBG_DO_TIME_CRITICAL_END
//            CheckStackOverflow(E_CODE_STACK_OVERFLOW_IN_TC);
         }

         /* If there is a non time critical task, run it here */
         if (NewTask->NonTimeCriticalTask != NULL)
         {
            AddTaskToQueue(NewTask, &TaskQueue[WhichThreadIsTask(NewTask)]);
         }
      }

      //If we are in the background when interrupted, exectute the foreground,
      //otherwise ireturn will return to current foreground */
      if (gs_FGActive == 0)
      {
         gs_FGActive = 1;
         for (Q = &TaskQueue[Thread]; Q->Front; DeleteTaskFromQueue(Q))
         {
            gt_TaskFuncPtr.pf_NTCTask = (*(Q->Front->NonTimeCriticalTask));

            //_enable1();   // allow foreground tasks to be interrupted
            gt_TaskFuncPtr.pf_NTCTask();
            //_disable1();

//            CheckStackOverflow(E_CODE_STACK_OVERFLOW_IN_NTC);
         }
         gs_FGActive = 0;
      }
      else
      {
         gus_FgNestedCount++;
      }
   }    //XDSLRTFW-2392 (Cascaded scheduling - End)
   else
   {
      DetectInterrupts();

      //XDSLRTFW-2392 (Cascaded scheduling - Start)
      //Clearing is required to switch from TS mode to Cascade mode and clearing is not required
      //to monitor the QT & PMS done status in Time slotted mode.
      if (!(gul_35bLiteConfig & EN_ST_QT_PMS_DONE_STATUS_TIME_SLOT))
      {
         WriteCoreReg(CRI_EVENT_ADDR, 0xFFFFFFFF);
         WriteCoreReg(CRI_STATUS0_ADDR, 0xFFFFFFFF);
      }
      //XDSLRTFW-2392 (Cascaded scheduling - End)

      if (guc_PortActive == 2)    // the very first frame after LinkStart; cores not enabled yet
      {
         // this function has to be called here; otherwise it will never
         // be called due to TC task only called during QT-run frame.
         // the system starts with QT-stall frames.
         EnableCores_ForLinkStart();

         #ifdef DEBUG_VRX518_AFE  //0x5101
            if(gs_PauseControl == 0x5101)
               Pause(gs_PauseControl);
         #endif

         guc_PortActive = 1;
      }

      if (guc_PortActive)
      {
         //If the previous foreground task has not finished, issue the real-time exception
         if(gs_FGActive == 1)
         {
            KernelException(E_CODE_REAL_TIME_EXCEPTION);
         }
         else
         {
            gs_FGActive = 1;
            ForegroundHandler();
            gs_FGActive = 0;
         }
      }
   }

   // We are processing the mailbox request only once in cascaded mode or everytime during Time slotted approach
   if (((gft_Interrupt_Mailbox) && (guc_Start_CasMode_Int)) || (!(guc_Start_CasMode_Int)))
   {
      //XDSLRTFW-3699 (Start)
      //Call these functions once per DMT symbol,
      //In Cascaded mode seeing additionally 2 unknown interrupts
      //apart from Rx Timer & Tx Timer Interrupts.
      //To avoid serving these functions for unknown interrupts, called here to call once per DMT symbol.

      //Cores overflow check for both Time Slotted and Cascaded approach
#ifdef ENABLE_VR9_HW_ERR_CNT
      //Check the core error registers
      if(gft_EnableCoreErrorCheck)
      {
         CheckCoreErrorRegs();
      }
#endif //#ifdef ENABLE_VR9_HW_ERR_CNT
      NewMPCheckMessage();
      // run codeswap engine every frame
      RunCodeSwapEngine();
      //XDSLRTFW-3699 (End)
   }



#if defined(VR9_SHOW_LPBK_TEST)
   //*((int32 *)SIMEXT_CLOCK_CORE_MODE)=  gus_ClockCoreMode;
   *((int32 *)SIMEXT_CLOCK_CORE_MODE)=  CLOCK_CORES_OVERRIDE;
#endif

} //void MasterIntHandler(void)

