/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   stateini.c
*
*   Functions for initializing the state machine.
*
*-------------------------------------------------------------------------
*/
//***************************************************************************************/
// stateini.c
//
// history
//
// 10/07/2013 Sriram Shastry : Bug in check condition for setting up error code to indicate CO perfers ADSL mode
//
// Grep for XDSLRTFW-1005 : BugFix_ALL_ALL_ALL_Hsk_LookforADSLAnnexbits
//***************************************************************************************/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "cmv.h"
#include "PrintTrail.h"
#include "vdsl_state.h"
#include "initfifo.h"
#include "OTrainingTxF.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ORTrainingRxF.h"
#include "ghs.h"
#include "g997.h"
#include "InitGlobalVars.h"
#include "initfifo.h"
#include "AllocateDataBuffers.h"

//Initialize GHS variables
void InitGHSVariables(void)
{
   // initialize the pointers used by GHS code
   InitGhsPointers((uint8 *)(void *)gsa_CommonMemoryBlock0);

   gs_HandShake_Cnt = 0;

   // Initialize the Tx/Rx handshake msg counter
   guc_TxHSMsg_SegmentCnt   = 0;
   guc_RxHSMsg_SegmentCnt   = 0;
   guc_TxHSReqRtx_cnt      = 0;
   guc_RxHSReqRtx_cnt      = 0;
   gs_DecodeBufCnt         = 0;
   gs_LastTxMsgBufCnt      = 0;

   guc_last_rx_msg_type   = 0xFF;
   guc_last_tx_msg_type   = 0xFF;

   //Modem does not initiate REQ-RTX message
   gft_RTXCtrlFlag         = 0;

   gpsa_TxCarSetTable = &gsa_UpCarSetTable[0][0];
   gpsa_RxCarSet = gsa_DnCarSet;

   InitializeParameterInfoField( gpt_TxInfo );
   InitializeParameterInfoField( gpt_TxInfoSave );
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitModemTasks
 *
 *  Prototype:  void InitModemTasks(void)
 *
 *      Initializes variables in Modem tasks
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void InitModemTasks_PreHandshake(void)
{
   // Initialize task control blocks
   tcb_init();

   // Initialize background queue
   InitBackground();

   // Initialize pointers for dynamic data memory allocation
   AllocateDataBuffers();

   // Initialize global variables at each reset
   InitGlobalVars_PreHandshake();

   // Initialize Ghs variables
   InitGHSVariables();

   // Initialize Tx/Rx loading function fifos
   InitTxLoadingFunctionFifo();
   InitRxLoadingFunctionFifo();
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitModemTasks_PostHandshake
 *
 *  Prototype:  void InitModemTasks_PostHandshake(void)
 *
 *      Initializes variables in Modem tasks
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void InitModemTasks_PostHandshake(void)
{

   // Allocate data buffers and define buffer pointers. Results depend on whether
   // we're running G.992_1 or G.992_2.
   // AllocateDataBuffers_PostHndshk();


   // Add INFOMap entries for just-defined buffer pointers.
   // CMVInit_PostHandshake();


}
