/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   states.c
 *
 *   Functions for running the state machine.
 *
 *-------------------------------------------------------------------------
 */

// ***********************************************************************************************************
// states.c
//
// History
//
// 01/02/2012 Kannan: DSL FW run's the Zephyr Tx in "STAT_PreFailState (STAT_LinkDownState)"
//                    to pull data from the TX_CB before entering fail state
//            Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
// 19/12/2012 Abu: FAST Loss detection in training (vectoring mode)
//            Grep XDSLRTFW-645 / XDSLRTFW-674
// 06/05/2013 Varun : Added code(Debug option) to initiate DMA of Debug Buffer to SDRAM
//
//            Grep for XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer and
//                           "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 10/10/2013 Fuss: Use "Pre-failstate" to pause FW for data-collection
//            Grep for XDSLRTFW-1218 Bugfix_ALL_VDSL2_ALL_DataCollect
//
// 29/01/2014 Abu: XDSLRTFW-1535 CMV Controlled Link Drop
//                 Grep : XDSLRTFW-1535 CMV_Controlled_Link_Drop
// 02/04/2014 Kannan: Fast LOS detection logic in showtime is disabled when vectoring is enabled
//                    enabling of this logic causing link drop in the presence of long SHINE noise.
//                    Grep for XDSLRTFW-1666
// 09/07/2014 Varun : Time out is disabled in diagnostic mode. If CO drops the link at training then CPE
//                    keeps waiting at some particular state and goes to failure state after a long time.
//                    Standard does not specify any timeout period for Delt mode.Enabling current timeout
//                    settings for delt did not help as link fails at many stages and needs tweeking at every
//                    stage.We can still drop the link based on the pilot tone power. This fast los detection
//                    logic is already implemented for Vectoring . This is enabled for Delt mode now and found
//                    to be working in the all loops with CPE faster reboot if CO drops the link.
//                    Grep for XDSLRTFW-1507
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//                Grep for XDSLRTFW-1901
//
// 16/04/2015 Kannan/Anantha Ramu: Before this modification link was not going to showtime in Intra DTU interleaving(US & DS ), when traffic  data
//                                 is connected. This issue is resolved by making modifications such that full data(of traffic)
//                                 is emptied from PPE before resetting PPE.
//                                 Grep for XDSLRTFW-2180.
// 13/08/2015 Stefan: set hardcoded EFM/PTM mode if VDSL is started in G.Vectoring mode
//            Grep for XDSLRTFW-2456 Long_train_time_in_VDSL_when_switching_from_ADSL_to_VDSL_Vectoring
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//      The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//      The internal split is not well-balanced for the wished service rates.
//      According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//      According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//      framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//      D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//      1-symbol reduction in Qtx,min calculation:
//      It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//      the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//      occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it's not needed to take into account the
//      +1 symbol in the Qtx,min calculation.
//      If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//      For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//      the left triangle part.
//      If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//      is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//      shown in the drawings before the triangle.
//      So from the figures it could be derived:
//      No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//      But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//      No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//      Grep for : XDSLRTFW-2858
//
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "mtkernel.h"
#include "cmv.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "DshInterface.h"
#include "PrintTrail.h"
#include "nmp.h"
#include "profile.h"
#include "g997.h"
#include "codeswap.h"
#include "vdsl_state.h"
#include "LL_IOf.h"
#include "profile.h"
#include "CustomerTasks.h"
#include "V_STR_IOf.h"
#include "vdsl_xception.h"
#include "cri_iof.h"
#include "vdsl_state.h"
#include "socmessage.h"
#include "DSLEngin.h"
#include "ghs.h"
#include "ModulateSocMessages.h"
#include "dsp_op.h"
#include "SelectPilot.h"
#include "PGAHandler.h"


#include "IRI_Iof.h"
//XDSLRTFW-2180 (Start-End)
#include "ppe_memmap.h"

/* =============================================== */
/* defintions */
/* =============================================== */
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
#define PPE_ACK_WAIT_TIMEOUT (10*4000)  //10secs timeout
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

/* XDSLRTFW-2858 */
#define REIN_TEST_RX_ENABLED  0x0001
#define REIN_TEST_TX_ENABLED  0x0002
#define REIN_TEST_RX_PULSE_ON 0x0100
#define REIN_TEST_TX_PULSE_ON 0x0200
/* XDSLRTFW-2858 */

/* =============================================== */
/* Global variable declarations */
/* =============================================== */

/* =============================================== */
/* Local function prototypes */
/* =============================================== */
void EmptyState(void);
void Pause(int16 s_Marker);
void TxStateFunc(void);
void RxStateFunc(void);
void Update_GLP_OverFlowCounters(uint8 ch_no);
// External functions
void ModemMonitor(void);

//XDSLRTFW-3756 (START_END)
#define DEBUG_DATA_COLLECTION_TIMEOUT   (12 * 4000) //12 secs at 4Khz frame rate, taken rate for 8Khz 30a profile as well

// debug variables to provide symbol count control of jumpfrom
int32 gl_TxSymbolCountJumpFrom = -1;
int32 gl_RxSymbolCountJumpFrom = -1;
//XDSLRTFW-2180 (Start)
uint32 gul_dbg_PPE_count = 0;
//XDSLRTFW-2180 (End)
//XDSLRTFW-3756 (START_END)
uint32 gul_DebugDataCollect_Timeout = 0;

extern int16 gs_ExitMainLoop;
uint16 gus_Zep_Tx_DelayCnt; //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)


#ifdef VRX518_BRINGUP_DEBUG
extern uint8 *gpuca_StVectoringBuffer;
#endif

extern int16 gs_RxStateTrigger;
extern int16 gs_DbgDtbCnt;

//extern int16 gs_Prev_RxState;
//extern int16 gs_RxState_dbg;
//extern int16 gs_RxSubState_dbg;
//extern FlagT gft_start_capture_tone;
//extern int16 gs_dbg_ToneTrack_Idx;
//
//uint32 *ptr_pilot1 = (uint32 *) 0x3864B0;
//uint32 *ptr_pilot1_Idx = (uint32 *) 0x3864AC;

extern int32 gl_RxSymbolCount_dbg;

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void FailTxF(void)
 *
 *   This function implements FAIL_TX foreground.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */

void FailTxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_FAIL_STATE_TX;
   switch (gs_TxSubState)
   {
   case 0:
      // proceed if the system is ready to perform tear-down process
      if ((gs_RxState == FAIL_RX) && (gs_RxSubState > 0))
      {
         gs_TxSubState = 1;
      }
      break;

   case 1:
      {
         // silence the transmitter.
//XDSLRTFW-2180 (Start)
         //gs_TxVarGain = 0;
         //AddFunctionToFifo(gp_TxLoadingFunctionFifo, ClearTxVarGain);
//XDSLRTFW-2180 (End)
         gs_TxSubState = 2;
      }
      break;
      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
      //Wait till Zephyr Tx pull the TX_CB data, i.e Tx cell buffer data which is available
      //in PPE
   case 2:
      if (gs_RxSubState > 1)
      {
//XDSLRTFW-2180 (Start)
         uint32 ul_data = 0;
         // XDSLRTFW-2778 (Start): Teardown procedure in VRX518
         uint32 ul_addr;
         ul_addr = DREG_MISCRAM2_ADDR;
         ReadPpeReg(ul_addr,&ul_data);
         // XDSLRTFW-2778 (Start): Teardown procedure in VRX518

         // In earlier platforms, 44K memory is shared between PPE FW and DSL FW.
         // But in VRx518, there is no sharing of memory. The same register is used to store "Vpage".
         // During a linkdrop, DSL FW needs to pull out data from codeword buffer until "Vpage"
         // is set to Zero by PPE FW.
         // Once the "Vpage" (i.e, BIt 0) of DREG2 register is ZERO, the DSL FW can stop the Tx Datapath.
         // Please refer the document "PPE DSL Notifications" for more information.
         if ((ul_data & MASK_BIT0) == 0)     // Vpage is Bit0 of DREG2
         {
            // switch TC task to TxProcessTones
            gt_TaskArray[TX_QT_DONE].TimeCriticalTask = TxProcessTones;
            // disable TX data path
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, StopTxDataPath);
            gs_TxSubState = 3;
         }
         else
         {
            gul_dbg_PPE_count++;
         }
//XDSLRTFW-2180 (End)
      }
      break;

   case 3:
      gs_TxSubState = -1;
      break;
      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
   }
}

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void FailRxF(void)
 *
 *   This function implements FAIL_RX foreground.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */
#define FINAL_TERMINATE         (15)

void FailRxF(void)
{
   uint8 uc_SwapStatus;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_FAIL_STATE_RX;
   uint32 ul_data = 0; //XDSLRTFW-2469 (Start_End)

   switch (gs_RxSubState)
   {
   case 0:
      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
      if (gt_FailStateInfo.ul_ExceptionCode != E_CODE_MODEM_RESET)
      {
         // Silvano: increment failed full init counter only at FULL_INIT/DIAG_MODE --> FAIL transition
         if ((gsa_IndirectStat0[0] == STAT_FullInitState) ||
               (gsa_IndirectStat0[0] == STAT_LoopDiagMode))
         {
            // increment total number of failed full initializations during the accumulation period
            // failed full initialization is when showtime is not reached at the end of the full initialization procedure
            gt_g997_LineInitPerf_Running.l_FailedFullInitCount += 1;
            gt_g997_LineInitPerf_Current_Previous_TR1.t_Current.l_FailedFullInitCount += 1;
         }

         //What would be the status of MONI "gs_MONI_ModemStat_Status" ?, checked with stefan,
         //don't need to change the MONI status. Since "STAT_PreFailState" is an intermediate
         //state to clear that TX_CB and to collect the debug data.
         //Change STAT 0 0 Macro state to "STAT_PreFailState" (STAT_LinkDownState),
         //DCT Tool may need to read some debug
         //information before reboot.
         gsa_IndirectStat0[0] = STAT_PreFailState;  //STAT_LinkDownState;
         gusa_MONI_ModemStat_Status[0] = MONI_STAT_PRE_FAIL;    // XDSLRTFW-3513 (Start_End)
      }

      //Clear Link status(Bit 0)& Rx data status (Bit 1) in "DREG_MISCRAM0_ADDR"to
      //inform the PPE that the Link is down
      //So that PPE FW can ack S_44K mem by clearing the Bit 0 in (DREG_MISCRAM2_ADDR)
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, DFE_PPE_LinkStatus_TxRxLeaveShow);
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, DFE_PPE_RxDataStatus_LeaveShow);
//XDSLRTFW-2180 (Start)
      // silence the transmitter.
      //Shutdown the Transmit signal in Rx fail state, since we want to continue the showtime
      //Tx state machine till PPE code word buffer has been cleared. Till clearing of PPE buffer
      //we don't need to continue showtime transmit the signal.
      gs_TxVarGain = 0;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, ClearTxVarGain);
//XDSLRTFW-2180 (End)
      gus_LinkDownState_SymCount = 0;
      guc_8khz_count = 0;
      gs_RxSubState = 1; // proceed to next sub-state immediately

      break;

   case 1:
      //we will let zephyr tx run until an additional 120k bits have been read from PPE
      //For 30Mhz profile, increment gus_LinkDownState_SymCount for every 2 frames
      //to have common timeout across all the profiles.
      if (gs_frame_rate_is_8khz)
      {
         guc_8khz_count++;
         if ((guc_8khz_count % 2) == 0)
         {
            guc_8khz_count = 0;
            gus_LinkDownState_SymCount++;
         }
      }
      else
      {
         gus_LinkDownState_SymCount++;
      }

      // The DSL FW waits for 2048 symbols (could be configured by CMV CNTR 56) until it
      // enters the failstate.
      if (gus_LinkDownState_SymCount >= gus_Zep_Tx_DelayCnt)   // XDSLRTFW-3591 (Start_End)
      {
         // XDSLRTFW-1218 Bugfix_ALL_VDSL2_ALL_DataCollect (Start / End)
         //XDSLRTFW-2180 (Start-End)
         //if (gft_LinkDownState_Cntrl == 0)
         {
            gs_RxSubState = 10; // proceed to next sub-state immediately
         }

      }
      break;

   case 10:
//XDSLRTFW-2180 (Start)
      //Tx Fail state can't be changed along with Rx Fail state in same DMT symbol, since Tx state machine need to
      //clear the PPE code word buffer in Fail state, it take some time for the PPE to stop the incoming ethernet
      //data and Zephyr need to clear the PPE buffer.
      gs_TxNextState = FAIL_TX;
      gpF_TxStateFunc = (PtrToFunc)FailTxF;

      // Update Macro State to FAIL unless initiated via Soft Reset
      if ((gt_FailStateInfo.ul_ExceptionCode != E_CODE_MODEM_RESET) && (gft_LinkDownState_Cntrl == 0))
//XDSLRTFW-2180 (End)
      {
         gsa_IndirectStat0[0] = STAT_FailState;
         gusa_MONI_ModemStat_Status[0] = MONI_STAT_FAIL;
      }
      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
      // We need to force UAS state to UNAVAIL in order for UAS to increment during FAIL state,
      // otherwise UAS does not count if we enter FAIL state before accumulating 10 SES or LOSS
      // (G997_1sec_Task is only executed in showtime)
      // Include the last SES-L/LOSS-L in the UAS time
      gt_g997_LinePerf_Current_Previous_TR1_NE.t_Current.l_UAS_L_count += gt_g997_LinePerf_help.s_UAS_L_TriggerCnt;
      gt_g997_LinePerf_Running_NE.l_UAS_L_count += gt_g997_LinePerf_help.s_UAS_L_TriggerCnt;

      gt_g997_LinePerf_help.s_UAS_L_TriggerCnt = 0;
      gt_g997_LinePerf_help.s_UAS_L_State = UAS_STATE_LINE_UNAVAIL;

      // switch TC task to RxProcessTones
      gt_TaskArray[RX_QT_DONE].TimeCriticalTask = RxProcessTones;


      // disable RX data path
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, StopRxDataPath);

      // stop updating the CPE SRC
      gft_UpdateTimingRecoveryHWEnable = 0;

      gs_RxSubState = 11;

      break;

   case 11:
      // if codeswap is in the process, wait until it's done
      if (guc_OffChipRequestHandle < INVALID_CODESWAP_HANDLE)
      {
         uc_SwapStatus = GetRequestStatus(guc_OffChipRequestHandle);
         if ((uc_SwapStatus == SWAP_DONE) || (uc_SwapStatus == SWAP_ERROR) || (uc_SwapStatus == SWAP_TIMEOUT))
         {
            // free swap handle whether codeswap is done or failed
            FreeSwapHandle(&guc_OffChipRequestHandle);
            gs_RxSubState = 12;
         }
      }
      else
      {
         FreeSwapHandle(&guc_OffChipRequestHandle);
         gs_RxSubState = 12;
      }

      break;

   case 12:
      // if codeswap is in the process, wait until it's done
      if (guc_RxUcodeHandle < INVALID_CODESWAP_HANDLE)
      {
         uc_SwapStatus = GetRequestStatus(guc_RxUcodeHandle);
         if ((uc_SwapStatus == SWAP_DONE) || (uc_SwapStatus == SWAP_ERROR) || (uc_SwapStatus == SWAP_TIMEOUT))
         {
            // free swap handle whether codeswap is done or failed
            FreeSwapHandle(&guc_RxUcodeHandle);
            gs_RxSubState = 13;
         }
      }
      else
      {
         FreeSwapHandle(&guc_RxUcodeHandle);
         gs_RxSubState = 13;
      }

      break;

   case 13:
      // if codeswap is in the process, wait until it's done
      if (guc_TxUcodeHandle < INVALID_CODESWAP_HANDLE)
      {
         uc_SwapStatus = GetRequestStatus(guc_TxUcodeHandle);
         if ((uc_SwapStatus == SWAP_DONE) || (uc_SwapStatus == SWAP_ERROR) || (uc_SwapStatus == SWAP_TIMEOUT))
         {
            // free swap handle whether codeswap is done or failed
            FreeSwapHandle(&guc_TxUcodeHandle);
            gs_RxSubState = 2;
         }
      }
      else
      {
         FreeSwapHandle(&guc_TxUcodeHandle);
         gs_RxSubState = 2;
      }

      break;

   case 2:
      // if codeswap is in the process, wait until it's done
      if (guc_PrimPageHandle < INVALID_CODESWAP_HANDLE)
      {
         uc_SwapStatus = GetRequestStatus(guc_PrimPageHandle);
         if ((uc_SwapStatus == SWAP_DONE) || (uc_SwapStatus == SWAP_ERROR) || (uc_SwapStatus == SWAP_TIMEOUT))
         {
            // free swap handle whether codeswap is done or failed
            FreeSwapHandle(&guc_PrimPageHandle);
            gs_RxSubState = 3;
         }
      }
      else
      {
         FreeSwapHandle(&guc_PrimPageHandle);
         gs_RxSubState = 3;
      }

      break;

   case 3:
      // wait until TX tear-down process is complete, and all BG tasks are done,
      // note that no more BG task should be loaded in the queue at this sage
      if ((gs_TxSubState == -1) &&
            (gp_BGTaskFifo->FunctionBuffer[gp_BGTaskFifo->IndexOfOldest] == 0) &&
            (gs_BGStateID == BG_TASK_END))
      {
      //XDSLRTFW-3756 (START)
         gul_DebugDataCollect_Timeout = 0;
         guc_8khz_count = 0;
      //XDSLRTFW-3756 (END)
         gs_RxSubState = 4;
      }

      break;

   case 4:
      // ensure that state machine is in fail state long enough
      // to send all the autonomous messages (state transition, LOS notifications, etc)
      if (gl_RxSymbolCount > (int32)FAIL_STATE_LEN)
      {
         // Silvano: Failed full init counter must be incremented only at FULL_INIT/DIAG_MODE --> FAIL transition
         /*         if (gt_G997_Cntrl.s_LinkState != G997_LINK_AVAIL)
                  {
         // increment total number of failed full initializations during the accumulation period
         // failed full initialization is when showtime is not reached at the end of the full initialization procedure
         gt_g997_LineInitPerf_Running.l_FailedFullInitCount += 1;
         gt_g997_LineInitPerf_Current_Previous_TR1.t_Current.l_FailedFullInitCount += 1;
         }
         */
         //XDSLRTFW-2202 (start_end)
         // FSM can wait here till DCT completes it's debug data collection, debug data collection
         // can be terminated by DCT by clearing flag "gft_LinkDownState_Cntrl" to "0"
         //XDSLRTFW-3756 (START)
         if (gs_frame_rate_is_8khz)
         {
            guc_8khz_count++;
            if ((guc_8khz_count % 2) == 0)
            {
               guc_8khz_count = 0;
               gul_DebugDataCollect_Timeout++;
            }
         }
         else
         {
            gul_DebugDataCollect_Timeout++;
         }
         //XDSLRTFW-3756 (END)

      //XDSLRTFW-3756 (START_END)
         if ((gt_FailStateInfo.ul_ExceptionCode != E_CODE_MODEM_RESET) &&
             ((gft_LinkDownState_Cntrl == 0) || (gul_DebugDataCollect_Timeout > DEBUG_DATA_COLLECTION_TIMEOUT)))
         {
            gs_RxSubState = 5;
            gsa_IndirectStat0[0] = STAT_FailState;
            gusa_MONI_ModemStat_Status[0] = MONI_STAT_FAIL;
         }
         //XDSLRTFW-2202 (end)
      }
      break;

   case 5:

      gft_AllowSoftReset = 1;

      // Stay in this substate unless gs_MONI_AutoRestart is set
      // or soft reset issued

      // XDSLRTFW-2186(Start)
      // The modem should enter the TERMINATE state only when CNTL 0 0 4 is issued. But we were doing
      // an "AND" operation with "0x4" and we used to enter the TERMINATE state when Bit 2 is set in CNTL 0
      if(CNTLArray[CNTL_ModemControl] == CNTL_FinalFailState)
      {
         gs_RxSubState = FINAL_TERMINATE;
      }
      // XDSLRTFW-2186(End)

      if ((gs_MONI_AutoRestart & MONI_RESTART_AT_FAIL) || (gft_IssueSoftReset == 1))
      {
         guc_PortActive = 0;             // prevent the system from executing TC and NTC
         // Force exit from RunModem main loop
         gs_ExitMainLoop = 1;
         gs_RxSubState = -1;
      }
      break;
      // XDSLRTFW-2254 FINAL_FAILSTATE (END)
   case FINAL_TERMINATE:
      if(guc_MPMsgRespReq== 0)
      {
         guc_PortActive = 0;
         gft_PauseOff=FALSE;
         Pause(1);
      }
      // XDSLRTFW-2254 FINAL_FAILSTATE (END)
      break;
   }
}

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void EnterFailStates(uint32 ul_ExceptionCode)
 *
 *   This function sets the fail state debug info, and drives state machine
 *   into fail state.
 *
 *   Input Arguments:
 *      ul_ExceptionCode: exception code
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */


void EnterFailStates(uint32 ul_ExceptionCode)
{
   uint32 ul_int_status;

   if(gft_DisableFailState)
   {
      return;
   }

#ifdef CUSTOMER_TASKS
   if (gt_WatchdogTimerEnable)
   {
      WatchdogTimerStop();
   }
#endif //CUSTOMER_TASKS

   // if already in FAIL state, do not change exception code, etc.
   if ((gs_TxState == FAIL_TX) || (gs_RxState == FAIL_RX))
   {
      return;
   }

   gft_AllowSoftReset = 0;

   // For Vectoring all training fails are counted as intentional fails!
   // XDSLRTFW-2456 Long_train_time_in_VDSL_when_switching_from_ADSL_to_VDSL_Vectoring
   // Sub-Error-code Esub_S_PP_DRIVER must NOT be overwritten !!!
   if((gft_DSVectoringEnabled) && (ul_ExceptionCode != E_CODE_CODESWAP_ERR) && (ul_ExceptionCode != E_CODE_PPE_MISS_MATCH) &&
         (!((gsa_IndirectStat0[0] == STAT_ShowTimeState) || (gsa_IndirectStat0[0] == STAT_ShowTimeTCSyncState))))
   {
      ul_ExceptionCode &= (0xffff00ff);                  // mask Esub info
      ul_ExceptionCode |= (Esub_FWInitiatedRetrain<<8);  // set all exceptions to intentional
   }

   // XDSLRTFW-1535 CMV_Controlled_Link_Drop (start)
   if((gft_DSVectoringEnabled) && (ul_ExceptionCode != E_CODE_CODESWAP_ERR) &&
         ((gsa_IndirectStat0[0] == STAT_ShowTimeState) || (gsa_IndirectStat0[0] == STAT_ShowTimeTCSyncState)) &&
         ((TESTArray[TEST_CMVCTRL_LINKDROP] & 0x7FFF) == 1))
   {
      if(TESTArray[TEST_CMVCTRL_LINKDROP] & 0x8000)
      {
         ul_ExceptionCode = E_CODE_CMV_CONTROLLED_LINK_DROP_TX_GAIN_ZERO;
      }
      else
      {
         ul_ExceptionCode = E_CODE_CMV_CONTROLLED_LINK_DROP_RX_GAIN_ZERO;
      }
   }
   // XDSLRTFW-1535 CMV_Controlled_Link_Drop(end)



   gt_FailStateInfo.s_TxState_AtFail = gs_TxState;
   gt_FailStateInfo.s_RxState_AtFail = gs_RxState;
   gt_FailStateInfo.s_TxSubState_AtFail = gs_TxSubState;
   gt_FailStateInfo.s_RxSubState_AtFail = gs_RxSubState;
   gt_FailStateInfo.l_TxSymbolCount_AtFail = gl_TxSymbolCount;
   gt_FailStateInfo.l_RxSymbolCount_AtFail = gl_RxSymbolCount;
   gt_FailStateInfo.ul_ExceptionCode = ul_ExceptionCode;
   gt_FailStateInfo.us_BitloadErrorCode = gus_BitloadErrorCode;
   gt_FailStateInfo.s_ToneReorderErrorCode = gs_ToneReorderErrorCode;
   gt_FailStateInfo.s_RxMsgErrorCode = gs_RxMsgErrorCode;

   // immediately indicate TX & RX states are not in showtime
   // to prevent showtime overhead processing code from running in BG
   gus_ShowtimeControl = 0;
   gus_ShowtimeControlDDSave = 0;
   // XDSLRTFW-650 / XDSLRTFW-1384 (Start)
   gft_EnterL3State = FALSE;
   guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
   // XDSLRTFW-650 / XDSLRTFW-1384 (End)
#ifdef DEBUG_TRACES
   if(guc_ShowtimeEnter != 1)
   {
      if(((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData) & GHS_TRAINING_CAPTURE_DISABLE_MASK) == 0)
      {
         if((PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE))
         {
            gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_SOURCE_INDEX] = (int32)(gpusa_debugBuff); //guca_DebugBuf   // update source address
            gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_DEST_INDEX] = (int32)gpuca_offChipBuff; //guc_offChipDebugBuff;    // destination;
            gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_LENGTH_INDEX] = (gt_debugBufStatus.s_debugBufIndex<<1);    // size in bytes; make sure length is multiple of 4-bytes

            // Free handle for PSD offchip request
            FreeSwapHandle(&guc_OffChipRequestHandle);
            guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DEBUG_BUF);

            gpuca_offChipBuff=guca_offChipDebugBuff+(gt_debugBufStatus.s_debugBufIndex<<1); // increment the pointer of guc_offChipDebugBuff to suitable value
            gul_DMA_Busy_Error=0;

            gt_DebugBufferStatus.s_debugBuffer_GHS_TO_EXCHANGE_length+=gt_debugBufStatus.s_debugBufIndex;
         }
         else
         {
            gul_DMA_Busy_Error++;
         }
      }
   } //XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
   else //XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   {
//      if((((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData) & SHOW_TIME_CAPTURE_DISABLE_MASK) == 0)
//                                                                        ||
//                (((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData & SHOW_TIME_US_RETX_CAPTURE_ENABLE_CHECK)!=STOP_USRETX_SHOW_TIME_CAPTURE)
//                     && (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)))
      if(((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData) & SHOW_TIME_CAPTURE_DISABLE_MASK) == 0)
      {
         // Capture the data into the debug traces only if XDMA is free or not being requested from Mailbox or ERB
         if((PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE) && (guc_EVB_DebugBuff_flag == 0))
         {
            int16 s_size_bytes;

            // update the superframe data once before the last copy
            ShowtimeDebugBuffSuperframeUpdate();

            s_size_bytes = gus_LenDebugBuff;
            //if gu_LenDebugBuff more than DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES then it is pointing the pong buffer => subtract DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES to get the actual size
            if(gus_LenDebugBuff>=DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES)
            {
               s_size_bytes=(gus_LenDebugBuff-DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES);
            }

            gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_SOURCE_INDEX] = (int32)&gpuca_DebugBuff_PingPong[gus_LenDebugBuff-s_size_bytes]; // update source address
            gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_DEST_INDEX] = (int32)&gpuca_offChipBuffShowtime[gul_LenoffChipBuffShowtime]; // destination;

            gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_LENGTH_INDEX] = ((s_size_bytes+3)/4)*4;    // size in bytes; make sure length is multiple of 4-bytes

            gus_LenDebugBuff=0; //reset the internal buffer pointer
            gul_LenoffChipBuffShowtime+=s_size_bytes; //incremnet the showtime buffer pointer

            //if no wrap around
            if(guc_StLengthFlag==0)
            {
               gt_DebugBufferStatus.s_debugBuffer_Showtime_length+=(s_size_bytes>>1);
            }
            else
            {
               gt_DebugBufferStatus.s_debugBuffer_Showtime_Oldested_data_Start+=(s_size_bytes>>1);
            }

            // Free handle for PSD offchip request
            FreeSwapHandle(&guc_OffChipRequestHandle);
            guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DEBUG_BUF);
         }
         else
         {
            gul_DMA_Busy_Error++;
         }
      }//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(STOP)
   }
#endif // #ifdef DEBUG_TRACES

   DSH_SendEvent(DSH_EVT_EXCEPTION, sizeof(ul_ExceptionCode), &ul_ExceptionCode);

   // since this EnterFailStates could be called from FG or BG,
   // we want to disable the interrupts while resetting gt_TaskArray
   // save previous level_1 interrupt status to avoid enabling interrupt unintentionally
   disable1_save(&ul_int_status);

   gs_RxNextState = FAIL_RX;
//XDSLRTFW-2180 (Start)
   //gs_TxNextState = FAIL_TX;
   gpF_RxStateFunc = (PtrToFunc)FailRxF;
   //gpF_TxStateFunc = (PtrToFunc)FailTxF;
//XDSLRTFW-2180 (End)

   // restore previous level_1 interrupt status
   restore1_save(ul_int_status);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *   Prototype: void TxForeGround(void);
 *
 *   Description:
 *      This function executes the TX foreground processing.
 *
 *   Arguments:
 *      none
 *
 *   Global Variables:
 *      gs_TxStopState      -- (I) TX stop state
 *      gs_TxStateJumpFrom   -- (I) TX jump from state
 *      gs_TxStateJumpTo   -- (I) TX jump to state
 *      gs_TxState         -- (I/O) TX current state
 *      gs_TxSymbolCount   -- (I/O) TX symbol count
 *      gs_TxNextState      -- (I/O) TX next state
 *      gs_TxSubState      -- (O) TX substate
 *      gft_ShowTimeFirstPassTx -- (O) TX showtime first-pass indicator
 *      gs_Tx_OutBuf_Size   -- (I/O) TX output buffer size
 *      gft_HpfFlag         -- (I) flag = 1: HPF is on, else off
 *      gt_HPFInput         -- (I/O) FIR filter structure containing the HPF parameters
 *      gsa_TxDtoABuf[]      -- (O) buffer for D to A samples
 *      sa_EchoBuf[]      -- (O) buffer for simulated echo samples
 *-------------------------------------------------------------------
 *^^^
 */

void GetSymCountForEachPhase(void);
void TxForeGround(void)
{
   uint8 *puca_temp;


#ifdef PROFILE_TASKS_35B
   int32 l_StTxTimer;
   //Record the TX NTC task start time based on the TX timer
   ReadTxTimer((uint32 *)(void *)&l_StTxTimer);
#endif //PROFILE_TASKS_35B

   gs_FGStateID = TX_FOREGROUND_STATE;


   if(gs_TxState != gs_TxNextState)   /*  if there is a state change */
   {
#ifdef DEBUG_TRAIL
      if(gs_TxState == SAME_STATE)
      {
         LeaveStatesTrail(gl_TxSymbolCount, gs_TxNextState, gs_TxNextState, (int16)0xAAA0);
      }
      else
      {
         LeaveStatesTrail(gl_TxSymbolCount, gs_TxState, gs_TxNextState, (int16)0xAAA0);
      }
#endif //DEBUG_TRAIL

      /* if (gs_TxNextState == R_SHOWTIME_TX)
         gft_ShowtimeStateReached = 1;
         */

      /* Reset symbol count and substate at the beginning of a new state */
      gl_TxSymbolCount = 0;
      gs_TxSubState = 0;
      gs_TxSubStateCnt = 0;

      gs_TxState = gs_TxNextState;

      /* Reset hardware overflow counter to be 0 */
      // MemSetBuffer((int16*)gusa_TxOverflowCnts, 0, 0, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));

      //Keep the symbol count for each training phase
      GetSymCountForEachPhase();
   }
   else
   {
      /* Increase symbol count */
      gl_TxSymbolCount++;
   }

   /* Check to see if we have reached jump state */
   if ((gs_TxState == gs_TxStateJumpFrom) &&
         ((gl_TxSymbolCount == gl_TxSymbolCountJumpFrom) || (gl_TxSymbolCountJumpFrom == -1)))
   {
#ifdef DEBUG_TRAIL
      /*  change to next state */
      LeaveStatesTrail(gl_TxSymbolCount, gs_TxState, gs_TxStateJumpTo, (int16)0xAAA0);
#endif //DEBUG_TRAIL

      //if (gs_TxState == R_SHOWTIME_TX)
      //   gft_ShowtimeStateReached = 1;


      gl_TxSymbolCount = 0;
      gs_TxSubState = 0;
      gs_TxSubStateCnt = 0;
      gs_TxState = gs_TxStateJumpTo;
      gs_TxNextState = gs_TxState;

      gpF_TxStateFunc = gpF_TxStateJumpTo;

      /* Reset hardware overflow counter to be 0 */
      //MemSetBuffer((int16*)gusa_TxOverflowCnts, 0, 0, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
   }


   // Log Debug information
   TxProfileHandler();

   /* ======================================================================== */
   /* Execute state function */
   /* ======================================================================== */
   TxStateFunc();


   gl_TotalTxSymbolCount++;

   /* =========================================================================== */
   // Check the Tx, Rx overflow info in hardware (Iridia, Strymon)
   /* =========================================================================== */
   //UpdateOverFlowCounters();

   // reset the overflow indicator in case the value being double counted.
   //gus_IRI_Tx_Ovflw = 0;
   //gus_IRI_Rx_Ovflw = 0;
   //gus_STR_Ovflw = 0;
   /* =========================================================================== */
   // Modem Monitor handles auto-restart, autonomous messaging,
   /* =========================================================================== */
   ModemMonitor();

#ifdef CUSTOMER_TASKS

   if (gt_WatchdogTimerEnable)
   {
      /* Watchdog timer is reset everytime we enter into this function */
      WatchdogTimerReset();
   }
   // provide customer access to Tx Foreground processing
   CustomerTxForeground();
#endif //CUSTOMER_TASKS

   //==========================================================================
   // check TX state timeout
   //==========================================================================
   // go to fail state if stayed in the same state too long
   // but don't apply global timeout to SHOWTIME, SLEEP or FAIL states.
   if ((gsa_IndirectStat0[0] == STAT_FullInitState) || (gsa_IndirectStat0[0] == STAT_GhsState))
   {
      CheckTimeout(gl_TxSymbolCount, gl_TxStateTimeOutCount, E_CODE_TX_STATE_TIMEOUT);
   }

   // check for GHS timeout
   if ((gsa_IndirectStat0[0] == STAT_GhsState) && (gl_GHSTimeOutCount != -1))
   {
      CheckTimeout((gl_TotalTxSymbolCount-gl_HandshakePhaseSymCnt_start), gl_GHSTimeOutCount, E_CODE_GHS_TIME_OUT);
   }

   if (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   {
      if (gsa_IndirectStat0[0] != STAT_DiagModeComplete)
      {
         if (gl_TxSymbolCount >= (gl_TxStateTimeOutCountLoopDiagMode << gs_frame_rate_is_8khz))
         {
            EnterFailStates(E_CODE_TX_STATE_TIMEOUT);
         }
      }
   } //if (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)

   //#ifdef MTK_VECTORING_SUPPORT
   if (gft_DSVectoringEnabled == TRUE)
   {
      gs_TxFrmCnt++;

      if (gs_TxFrmCnt > TX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         gs_TxFrmCnt = 0;

         gs_TxSuperFrmCnt++;
         gs_TxSuperFrmCnt &= 0x3FF; // MODULO 1024

         // A counter for Us pilot sequence described in Section 10.3.3.5/G993.5. This counter will get updated
         // after decode of 10n+9 in O-P-ChannelDiscovery_V1 signal
         gs_VecIndx_PilotSeq++;    // G993.5 Section 10.3.3.5

         if (gs_VecIndx_PilotSeq >= gs_VecNPilotLength_US) // Modulo by  gs_VecNPilotLength_US Table 10-2/G993.5 field#3
         {
            gs_VecIndx_PilotSeq=0;

            // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start)
            //XDSLRTFW-1696 (Start)
            if(gft_PilotseqInterruptionNotAllowed == 1)
            {
               // Swap USPS(FDPS) active and inactive pointers
               puca_temp = gpuca_FDPSActive;
               gpuca_FDPSActive = gpuca_FDPSInActive;
               gpuca_FDPSInActive = puca_temp;

               // Swap FDPS related variables from inactive to active
               for (int16 i = 0; i < 8; i++)
               {
                  guca_IndexIndependentPSActive[i] = guca_IndexIndependentPSInActive[i];
                  guca_CyclicalShiftOfSeqActive[i] = guca_CyclicalShiftOfSeqInActive[i];
               }
               guc_SignOfSeqActive = guc_SignOfSeqInActive;
               guc_NoOfAdditionalIPSActive = guc_NoOfAdditionalIPSInActive;

               gft_PilotseqInterruptionNotAllowed = 0;
            }
            //XDSLRTFW-1696 (end)
            // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (end)
         }
      }
   }
   //#endif // #ifdef MTK_VECTORING_SUPPORT

   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   //Orderly shutdown request from SW/API
   if (CNTLArray[CNTL_ShutDownRequest] & CNTL_OrderlyShutDown)
   {
      EnterFailStates(E_CODE_ORDERLY_SHUTDOWN);
   }
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

#ifdef PROFILE_TASKS_35B
   //Record the TX NTC time based on the TX timer
   LogTaskProfile(TX_QT_DONE_NTC,l_StTxTimer);
#endif //PROFILE_TASKS_35B


   gs_FGStateID = FOREGROUND_STATE_END;
}



/*^^^
 *-------------------------------------------------------------------
 *
 *   Prototype: void RxForeGround(void);
 *
 *   Description:
 *      This function executes the RX foreground processing.
 *
 *   Arguments:
 *      none
 *
 *   Global Variables:
 *      gs_RxStopState      -- (I) RX stop state
 *      gs_RxStateJumpFrom   -- (I) RX jump from state
 *      gs_RxStateJumpTo   -- (I) RX jump to state
 *      gs_RxState         -- (I/O) RX current state
 *      gs_RxSymbolCount   -- (I/O) RX symbol count
 *      gs_RxNextState      -- (I/O) RX next state
 *      gs_RxSubState      -- (O) RX substate
 *      gft_ShowTimeFirstPassRx -- (O) RX showtime first-pass indicator
 *-------------------------------------------------------------------
 *^^^
 */

void RxForeGround(void)
{
#ifdef PROFILE_TASKS_35B
   int32 l_StRxTimer;
   ReadRxTimer((uint32 *)(void *)&l_StRxTimer);
#endif //PROFILE_TASKS_35B

   gs_FGStateID = RX_FOREGROUND_STATE;

   // XDSLRTFW-962:Enh_ALL_ALL_ALL_ExceptionHandling(Start)
   if(((gul_ExceptionCode & 0xFFFF) != E_CODE_NO_ERROR)&&
         ((gs_RxNextState != FAIL_RX)&&(gs_TxNextState != FAIL_TX))
     )
   {
      EnterFailStates(gul_ExceptionCode );
   }
   // XDSLRTFW-962:Enh_ALL_ALL_ALL_ExceptionHandling(End)

   if (gs_RxState != gs_RxNextState)
   {
#ifdef DEBUG_TRAIL
      /*  Record state change for debug purpose */
      LeaveStatesTrail(gl_RxSymbolCount, gs_RxState, gs_RxNextState, (int16)0xBBB0);
#endif //DEBUG_TRAIL

      /* Reset symbol count and substate at the beginning of a new state */
      gl_RxSymbolCount = 0;
      gs_RxSubState = 0;
      gs_RxSubStateCnt = 0;

      gs_RxState = gs_RxNextState;

      /* Reset hardware overflow counter to be 0 */
      // MemSetBuffer((int16*)gusa_RxOverflowCnts, 0, 0, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
   }
   else
   {
      gl_RxSymbolCount++;
      gl_RxSymbolCount_dbg++;
   }

   /* Check to see if we have reached jump state */
//if ((gs_RxState == gs_RxStateJumpFrom) && ((gl_RxSymbolCount == gl_RxSymbolCountJumpFrom) || (gl_RxSymbolCountJumpFrom == -1)))
   if (gs_RxState == gs_RxStateJumpFrom && (gs_RxSubStateJumpFrom == -1 || gs_RxSubState == gs_RxSubStateJumpFrom))
   {
#ifdef DEBUG_TRAIL
      LeaveStatesTrail(gl_RxSymbolCount, gs_RxState, gs_RxStateJumpTo, (int16)0xBBB0);
#endif //DEBUG_TRAIL

      //if (gs_RxState == R_C_SHOWTIME_RX)
      //   gft_ShowtimeStateReached = 1;
      gl_RxSymbolCount = 0;
      gs_RxSubState = 0;
      gs_RxSubStateCnt = 0;
      gs_RxState = gs_RxStateJumpTo;
      gs_RxNextState = gs_RxState;
      gpF_RxStateFunc = gpF_RxStateJumpTo;

      /* Reset hardware overflow counter to be 0 */
      //MemSetBuffer((int16*)gusa_RxOverflowCnts, 0, 0, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
   }


   // Log Debug information
   RxProfileHandler();

   /* =========================================================================== */
   /*  Execute state function that processes the RX signal */
   /* =========================================================================== */
   RxStateFunc();

   //DSM_Vectoring_Debug:
   //   if ( gs_PauseControl == 0x57)
   //      Pause(gs_PauseControl);

   // generate G.997 timebase
   G997_SymbolBased_Task();

   IridiaControlCommon();




#ifdef CUSTOMER_TASKS
   // provide customer access to Rx Foreground processing
   CustomerRxForeground();
#endif //CUSTOMER_TASKS

   //==========================================================================
   // check RX state timeout
   //==========================================================================
   // go to fail state if stayed in the same state too long
   // but don't apply global timeout to SHOWTIME, SLEEP or FAIL states.
   if ((gsa_IndirectStat0[0] == STAT_FullInitState) || (gsa_IndirectStat0[0] == STAT_GhsState))
   {
      CheckTimeout(gl_RxSymbolCount, gl_RxStateTimeOutCount, E_CODE_RX_STATE_TIMEOUT);
   }

   if (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   {
      if (gsa_IndirectStat0[0] != STAT_DiagModeComplete)
      {
         if (gl_RxSymbolCount >= (gl_RxStateTimeOutCountLoopDiagMode << gs_frame_rate_is_8khz))
         {
            EnterFailStates(E_CODE_RX_STATE_TIMEOUT);
         }
      }
   } //if (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)


   //Load VR9 AFE Read/write functions
   if(gft_LoadAfeFunctions)
   {
      (*gpF_AfeLoadFunc)();
      gft_LoadAfeFunctions = 0;
   }

   // XDSLRTFW-3280 PLL improvement / pilot tone selection improvement
   if((gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME) && gft_EnableShowPllToneSwitch)
   {
      // XDSLRTFW-3695 (Start) Make it possible to switch to a pilot tone which is in fluctuating SNR tone range
      // Make sure to only calculate a new pilot reference and attempt the switching when no severe noise is on the line (no micro interruption, REIN, PEIN etc)
      // noise detected does not work during the first 12000 symbols. But we need to avoid PT switching if the CO has dropped within the first 3sec after showtime entry.
      // this is the case when CO drops the line for bonding training
      if((gus_NoiseDetected==FALSE) &&
         (gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].ul_PilotTonePwr > gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].ul_PilotThresholdPwr))
      {
         MultiPilotUpdate();
      }
      else
      {
         // XDSLRTFW-3641 Pilot tone switching can prevent correct LOS detection, NE_ESE or LOF declared instead
         // check if low erasure metric event is present during calculation of phase error. Cancel the attempt to switch the pilot tone
         // in case of a low Erasure metric event (e.g. due to high external noise or mirco interruption or NE_LOS)
         gt_PilotConfig.te_BestPTArrayIdx = gt_PilotConfig.te_UsedPTArrayIdx;
         gs_PLLAvgHandlerState = PLL_AVG_IDLE;
      }
      // XDSLRTFW-3695 (End) Make it possible to switch to a pilot tone which is in fluctuating SNR tone range
   }

   // XDSLRTFW-1111
   // Note: Variable "gs_RxFrmCnt" is only used for vectoring and has no influence for Non-Vectoring!
   //       To have a more common code and MIPS consumtion between vectoring and Non-vectoring the
   //       code is running always.
   //       Further it is needed to avoid FW stucks for Non-vectoring in case of flag "EN_CHDIS_SKIP_TONE9_MARKER_SYM_FDQ/SNR"
   //       gets be set unintentionally.
   gs_RxFrmCnt++;
   if (gs_RxFrmCnt > RX_DATA_SYMBOLS_PER_SUPERFRAME)
   {
      gs_RxSuperFrmCnt++;
      gs_RxSuperFrmCnt &= 0x3FF; // MODULO 1024 (//gs_DSVec_N_SSC)
      gs_RxFrmCnt = 0;
   }

   //XDSLRTFW-1507(START_END)
   if((gft_DSVectoringEnabled == TRUE)||(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG))
   {
      // XDSLRTFW-645 / XDSLRTFW-674 (start)
      // This portion of the code makes a fast reboot of the CPE when it sees the pilot tone got corrupted
      // several (currently 10) symbol during certain states
      if (gft_EnablePLL)   // if PLL is enabled and Vectoring enabled
      {
         //XDSLRTFW-1666 (start_end)
         if ((gs_RxState==R_O_TRAIN_RX)||(gs_RxState==R_O_SIGNATURE_RX) ||
               ((gs_RxState>=VDSL2_R_O_P_SYNCHRO1_RX)&&(gs_RxState<= 200)))
         {
            // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
            if( gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].ul_PilotTonePwr < gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].ul_PilotThresholdPwr)
            {
               gs_FrameWithLowPilotPwrCnt++;

               //XDSLRTFW-1507(START_END)
               // at present gs_MaxNumofCorruptedPilot = 10)
               if (((gs_FrameWithLowPilotPwrCnt > gs_MaxNumofCorruptedPilot)) && (gft_FastLosEnabled || (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)))
               {
                  uint32 ul_ExceptionCode;
                  ul_ExceptionCode = (E_CODE_RX_LOW_PILOT_TONE_POWER);                          // (551)
                  if (gs_RxState==R_O_TRAIN_RX)
                  {
                     ul_ExceptionCode = (E_CODE_RX_LOW_PILOT_TONE_POWER_R_O_TRAIN_RX);          // (589)
                  }
                  else if (gs_RxState==R_O_SIGNATURE_RX)
                  {
                     ul_ExceptionCode = (E_CODE_RX_LOW_PILOT_TONE_POWERR_O_SIGNATURE_RX);       // (590)
                  }
                  EnterFailStates(ul_ExceptionCode);
               }
            }
            else
            {
               if(gs_FrameWithLowPilotPwrCnt > 0)
               {
                  gs_FrameWithLowPilotPwrCnt--;
               }
            }
         }
      }
      // XDSLRTFW-645 / XDSLRTFW-674 (end)
   }


   /* XDSLRTFW-2858 */
   /* FW-INTERNAL REIN LIKE DISTURBER DEBUG CODE  */
   // Initialize FW internal REIN test if user has enabled bit RX_REIN_TEST
   if (gt_REIN_Test_Config.us_REIN_TEST_CONFIG & REIN_TEST_RX_ENABLED)
   {
     // start REIN test not before finishing ongoing test
     if ((gt_REIN_Test_Status.us_REIN_TEST_STATUS & REIN_TEST_RX_ENABLED) == 0)
     {
       // store current RxVarGain in backup variable
       gs_RxVarGain_Showtime = gs_RxVarGain;
       gt_REIN_Test_Status.us_REIN_TEST_STATUS |= REIN_TEST_RX_ENABLED;
       gt_REIN_Test_Status.us_Rx_Symbols_Since_Start_of_REIN_pulse = 0;
       gt_REIN_Test_Status.us_Number_of_Remaining_Rx_REIN_pulses    = gt_REIN_Test_Config.us_Number_of_Rx_REIN_pulses;
     }
   }

   if (gt_REIN_Test_Status.us_REIN_TEST_STATUS & REIN_TEST_RX_ENABLED)
   {
        // START of REIN pulse
        // - symbol counter is 0
        if (gt_REIN_Test_Status.us_Rx_Symbols_Since_Start_of_REIN_pulse == 0)
        {
          // change Rx-gain to destroy Rx-Symbols
          // initial workaround: reduce Rx-Signal by 12dB
          gs_RxVarGain = gs_RxVarGain_Showtime >> 2;
          AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetRxVarGain);
          // set Status BIT: RX_REIN_PULSE_CURRENTLY_IN_USE
          gt_REIN_Test_Status.us_REIN_TEST_STATUS |= REIN_TEST_RX_PULSE_ON;
          gt_REIN_Test_Status.us_Number_of_Triggered_Rx_REIN_pulses++;
        }

      // END of REIN pulse
      // - symbol counter is 0
      if (gt_REIN_Test_Status.us_Rx_Symbols_Since_Start_of_REIN_pulse == gt_REIN_Test_Config.us_Length_Rx_REIN_in_DMT_symbols)
      {
       // reset Rx-gain back to default
       gs_RxVarGain = gs_RxVarGain_Showtime;
       AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetRxVarGain);
       // reset Status BIT: RX_REIN_PULSE_CURRENTLY_NOT_IN_USE
       gt_REIN_Test_Status.us_REIN_TEST_STATUS &= 0xFEFF;  // reset REIN_TEST_RX_PULSE_ON
       // decrease Rx-REIN-pulse counter
       gt_REIN_Test_Status.us_Number_of_Remaining_Rx_REIN_pulses--;
      }

      // TRIGGER NEXT REIN PULSE
      // - symbol counter is 0
      if (gt_REIN_Test_Status.us_Rx_Symbols_Since_Start_of_REIN_pulse == gt_REIN_Test_Config.us_Distance_between_two_Rx_REIN_pulses_in_DMT_symbols-1)
      {
       // reset REIN symbol counter to 0
       gt_REIN_Test_Status.us_Rx_Symbols_Since_Start_of_REIN_pulse = 0;
       if (gt_REIN_Test_Status.us_Number_of_Remaining_Rx_REIN_pulses == 0)
       {
         gt_REIN_Test_Status.us_REIN_TEST_STATUS &= 0xFFFE; // reset REIN_TEST_RX_ENABLED
         gt_REIN_Test_Config.us_REIN_TEST_CONFIG &= 0xFFFE; // reset REIN_TEST_RX_ENABLED
       }
      }
      else
       // increase symbol counter
       gt_REIN_Test_Status.us_Rx_Symbols_Since_Start_of_REIN_pulse++;
   }
   /* XDSLRTFW-2858 */

#ifdef PROFILE_TASKS_35B
   LogTaskProfile(RX_QT_DONE_NTC,l_StRxTimer);
#endif //PROFILE_TASKS_35B



   gs_FGStateID = FOREGROUND_STATE_END;
}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void EmptyState(void);
 *
 *  Description:
 *      Empty dummy function that does nothing.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void EmptyState(void)
{
   /*  Empty function. */
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void CheckTimeout(void);
 *
 *  Description:
 *      function to check the timeout and takes proper action if timeout happen.
 *
 *  Input Arguments:
 *      l_CurrentTimer     -- current timer count
 *      l_TimeoutThreshold -- timeout threshould
 *      us_ErrorCode       -- error code to use if timeout occurs
 *
 *  return: None
 *
 *  Global Variables:
 *      gs_EnableTimeoutCheck -- TRUE: enable timeout check, FALSE: disable timeout check
 *
 *-------------------------------------------------------------------
 *^^^
 */
void CheckTimeout(uint32 l_CurrentTimer, uint32 l_TimeoutThreshold, uint32 ul_ErrorCode)
{
   if(gs_EnableTimeoutCheckFlag == TRUE)
   {
      if (l_CurrentTimer >= (l_TimeoutThreshold << gs_frame_rate_is_8khz))
      {
         EnterFailStates(ul_ErrorCode);
      }
   }
}


void GetSymCountForEachPhase(void)
{
   // In all phases, the time-out counter shall be started as the VTU enters the phase and shall be reset
   // upon completion of the phase. The following values for the time-outs shall be used:
   //    * G.994.1 handshake phase:  As defined in ITU-T Rec. G.994.1 [2];
   //    * Channel discovery phase:            10 s;
   //    * Training phase:                     10 s; and
   //    * Channel analysis & exchange phase:  10 s.
   //
   // For normal VDSL the value is set to 13sec. 3 addition seconds is used for interop
   // with some "slower" CO devices.
   // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start)
   {
      int32 l_TotalTxSymbolCount;

      l_TotalTxSymbolCount = gl_TotalTxSymbolCount;

      if(gs_TxState == R_P_QUITE1_TX)
      {
         // End of handshake phase
         gl_HandshakePhaseSymCnt = l_TotalTxSymbolCount - gl_HandshakePhaseSymCnt_start;

         // Start of discovery phase
         // Note: This variable is set new at the end of RP-Vector1 phase (VDSL2_R_P_VECTOR1_TX)!
         gl_DiscoveryPhaseSymCnt_start = l_TotalTxSymbolCount;
      }
      else if(gs_TxState == VDSL2_R_P_QUIET2_TX)
      {
         // End of discovery phase
         gl_DiscoveryPhaseSymCnt = l_TotalTxSymbolCount - gl_DiscoveryPhaseSymCnt_start;

         // Start of training phase
         // Note: This variable is set new at the end of RP-Vector11 phase (VDSL2_R_P_VECTOR1_1_TX)!
         gl_TrainPhaseSymCnt_start = l_TotalTxSymbolCount;
      }
      else if(gs_TxState == VDSL2_R_P_MEDLEY_TX)
      {
         // End of training phase
         gl_TrainPhaseSymCnt = l_TotalTxSymbolCount - gl_TrainPhaseSymCnt_start;

         // Start of analysis phase
         gl_AnalysisPhaseSymCnt_start = l_TotalTxSymbolCount;
      }
      else if((gs_TxState == R_SHOWTIME_TX) || (gs_TxState == VDSL2_R_DIAG_DONE_TX))
      {
         // End of analysis phase
         gl_AnalysisPhaseSymCnt = l_TotalTxSymbolCount - gl_AnalysisPhaseSymCnt_start;
      }
      else if((gs_TxState == FAIL_TX))
      {
         if(gl_AnalysisPhaseSymCnt_start != 0)
         {
            gl_AnalysisPhaseSymCnt = l_TotalTxSymbolCount - gl_AnalysisPhaseSymCnt_start;
         }
         else if(gl_TrainPhaseSymCnt_start != 0)
         {
            gl_TrainPhaseSymCnt = l_TotalTxSymbolCount - gl_TrainPhaseSymCnt_start;
         }
         else if(gl_DiscoveryPhaseSymCnt_start != 0)
         {
            gl_DiscoveryPhaseSymCnt = l_TotalTxSymbolCount - gl_DiscoveryPhaseSymCnt_start;
         }
         else if(gl_HandshakePhaseSymCnt_start != 0)
         {
            gl_HandshakePhaseSymCnt = l_TotalTxSymbolCount - gl_HandshakePhaseSymCnt_start;
         }
      }
   }
   // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (End)

}

void TxStateFunc(void)
{
   //Call the state function when either of the two condition is true
   if((gs_NumOfTxSocBits == 0) || (gft_RunTxStateFuncFlag == TRUE))
   {
      (*gpF_TxStateFunc)();

      //Overwrite the TX message by ACK-SEG message
      if(gs_SendAckSegFlag == TRUE)
      {
         TxSocAckSeg();
      }
   }

   //In diagnostic mode, each SOC message byte is sent in 5*8 symbols
   //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   if(gft_TxSocMsgModFlag == TRUE)
   {
      //Modulate the soc message for Loop Diagnostic Mode
      ModulateSocMsgForDiagMode();
   }
}

void RxStateFunc(void)
{
   //Decode the SOC message byte
   //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   if(gft_RxSocMsgDemodFlag != DISABLE_LD_DEMOD_SOC_MSG)
   {
      //Demodulate the soc message for the diag mode
      DemodSocMsgForDiagMode();
   }

//debug code to log the Freq domain output from the Pilot Tone 1
//{
//
//   if ((gs_RxState == gs_RxState_dbg) && (gs_RxSubState == gs_RxSubState_dbg) && (gft_start_capture_tone == 0))
//   {
//      gft_start_capture_tone = 1;
//      gs_DbgDtbCnt = 0;
//      *ptr_pilot1_Idx = ((1 << 13) | gs_dbg_ToneTrack_Idx);
//   }
//   if ((gft_start_capture_tone) && (gs_DbgDtbCnt < (6000)))
//   {
//      uint32 ul_data;
//      ul_data = *ptr_pilot1;
//      gsa_dbg_ToneDebug[gs_DbgDtbCnt++] = (ul_data & 0xFFFF);
//      gsa_dbg_ToneDebug[gs_DbgDtbCnt++] = ((ul_data >> 16) & 0xFFFF);
//   }
// }


//#ifdef VRX518_BRINGUP_DEBUG
//   //--------------------------------------------
//   // Trail collections may be triggered based on
//   // rxstate/rxsubstate/rxsymbolcount.
//   // The following variables are used to set
//   // the trigger point.
//   // The variable
//   //--------------------------------------------
//   if ((gs_RxState == gs_RxStateTrigger) &&
//         ((gs_RxSubState == gs_RxSubStateTrigger) ||
//          (gl_RxSymbolCount == gl_SymbolCountTrigger)))
//   {
//      (*gps_StatesTrailIndex) = 0;
//      gs_RxStateTrigger = (0x7FFF);
//      gs_RxSubStateTrigger = (0x7FFF);
//
//   }
//
//   if ((gft_start_capture_tone) && (gs_DbgDtbCnt < (6000)))
//   {
//      //Enable this code log idle message flag 0x7E in the buffer __gla_OnePortShowDataStart
//      uint8 uca_byte[2];
//      //FILE *fptr;
//      //uint16 snr;
//      int16 i, j, i2;
//      int32 l_X, l_Y, l_DecodedBits;
//      FlagT ft_DbgFlipRx01Sense;
//
//      int16 *psa_RxToneBuf = gpsa_RxToneBuf;
//      int16 s_NumClusters = gs_NumOfToneClustersForMsgDecode;
//      int16 s_NumBytesInMsg = gs_RxNumBytesPerSymbol;
//      uint8 *puca_DecodedBytes = uca_byte;
//
//
//      //Store all cluster starting tone index relative to gs_RxToneOffset.
//      for (i=0; i < gs_NumOfToneClustersForMsgDecode; i++)
//         gsa_SOCMsgRxToneClusterStarts[i] = i*NUM_CHANNELS_PER_CLUSTER;
//
//      ft_DbgFlipRx01Sense = (gul_dbgSocMsgControl & RX_FLIP_01_SENSE)? TRUE: FALSE;
//
//      //Decode each tone to the corresponding bits (do from tone 9 to 0)
//      l_DecodedBits = 0;
//      for(i=NUM_CHANNELS_PER_CLUSTER-1; i>=0; i--)
//      {
//         //Average over s_NumClusters clusters to reduce noise effect
//         l_X = 0;
//         l_Y = 0;
//         for(j=0; j<s_NumClusters; j++)
//         {
//            i2 = (gsa_SOCMsgRxToneClusterStarts[j] + i)*2;
//
//            l_X += psa_RxToneBuf[i2];
//            l_Y += psa_RxToneBuf[i2+1];
//         }
//
//         //Decide the bit map
//         l_DecodedBits <<= 2;
//         if(l_X < 0)
//            l_DecodedBits |= (1<<(1-ft_DbgFlipRx01Sense));
//
//         if(l_Y < 0)
//            l_DecodedBits |= (1<<ft_DbgFlipRx01Sense);
//      }
//
//      //Pack one byte by extracting bits (b15, b14, b11,b10, b7,b6, b3,b2), where b0 is LSB
//      if(s_NumBytesInMsg == 1)
//      {
//         puca_DecodedBytes[0] = (l_DecodedBits>>2) & 3;
//         puca_DecodedBytes[0] |=(l_DecodedBits>>(6-2)) & (3<<2);
//         puca_DecodedBytes[0] |=(l_DecodedBits>>(10-4)) & (3<<4);
//         puca_DecodedBytes[0] |=(l_DecodedBits>>(14-6)) & (3<<6);
//      }
//
//      if (gs_RxState != gs_Prev_RxState)
//      {
//            gsa_dbg_ToneDebug[gs_DbgDtbCnt++] = 0xAA; //Marker
//            gsa_dbg_ToneDebug[gs_DbgDtbCnt++] = 0xAA; //Marker
//            gsa_dbg_ToneDebug[gs_DbgDtbCnt++] = (uint8)gs_RxState; //RxState
//            gs_Prev_RxState = gs_RxState;
//      }
//      gsa_dbg_ToneDebug[gs_DbgDtbCnt++] = uca_byte[0];
//
//      //fptr = fopen("RxMessages.txt", "a");
//      //Decode the tones to get the message byte(s)
//      //DecodeSOCMessage(gpsa_RxToneBuf, gs_NumOfToneClustersForMsgDecode, gs_RxNumBytesPerSymbol, uca_byte);
//      //fprintf(fptr, "%x\n", uca_byte[0]);
//      //fclose(fptr);
//
//      //if (gs_DbgDtbCnt < 2000)
//      //{
//      //   __gla_OnePortShowDataStart[gs_DbgDtbCnt++] = ((gl_RxSymbolCount << 16 ) | (uca_byte[0]));  //0x6aa00, 0x46800
//      //   __gla_OnePortShowDataStart[gs_DbgDtbCnt++] = ((gs_RxSubState << 16 ) | (gs_RxState));  //0x6aa00, 0x46800
//      //}
//      //fptr = fopen("RxToneDump.txt", "a");
//      //for (i = 0; i < 1024; i++)
//      //{
//      //   fprintf(fptr, "%d\n", gpsa_RxToneBuf[i]);
//      //}
//      //fclose(fptr);
//
//   }
//#endif



   //Call the RX state function
   (*gpF_RxStateFunc)();
}
