/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   statestc.c
*
*   Functions for Time-critical tasks from state.c
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "mtkernel.h"
#include "cmv.h"
#include "IRI_Iof.h"
#include "IRI_Ini.h"
#include "profile.h"
#include "cri_iof.h"
#include "ghs.h"
#include "pll.h"
#include "TimingRecov.h"
#include "LL_IOf.h"
#include "interrupt_control.h"
#include "V_STR_IOf.h"
#include "string.h"

#include "DSLEngin.h"

#include "DshInterface.h"


/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void TxProcessTones(void);
*
*   Description:
*
*   Time-critical task associated with Tx Frame Start.
*
*   Arguments:
*      none
*
*   Global Variables:
*      gp_TxLoadingFunction   -- (I) point to a function Fifo to implement
*                        frame specific processing (e.g. InsertTxCP)
*      gft_TxDataPump_On   -- (I) flag set to TRUE once Fast/Inlv data
*                        processing is enabled (which may be prior
*                        to Showime due to MFC requirements)
*      gft_IFFT_On         -- (I) flag set to enable IFFT
*
*-------------------------------------------------------------------
*^^^
*/

void TxProcessTones(void)
{
#ifdef PROFILE_TASKS_35B
   int32 l_StTxTimer;
#endif //PROFILE_TASKS_35B

   gs_TCStateID = PROCTONE_TX_TC_START;

#ifdef PROFILE_TASKS_35B
   //Record the TX TC task start time based on the TX timer
   ReadTxTimer((uint32 *)(void *)&l_StTxTimer);
#endif //PROFILE_TASKS_35B

   //This operation must be done before ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo)
   if(gft_StartTxWin == TRUE)
   {
      StartTxWin();
      gft_StartTxWin = FALSE; //StartTwWin needs to be done only once
   }

   /* ======================================================================== */
   /* TxLoading functions perform a frame specific function.  They are used to   */
   /* insert the Tx Cyclic Prefix (CP), for example.  gTxLoadingFunction is   */
   /* set by the state machine and is automatically cleared - i.e. the loading   */
   /* function is called only once.                                 */
   /*                                                         */
   /* ======================================================================== */

   /* If there are pending loading functions, then run them   */
   ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);


   if(gft_IFFT_On == TRUE)
   {
      //register start IFFT during G.hs or sleep
      if(gs_LoadGhsToneFlag & BITMAP_REGSTART_IFFT)
      {
         //Load GHS tones
         if(gs_LoadGhsToneFlag & BITMAP_LOAD_GHS_TONES)
         {
            LoadGhsTonesToIfftBuf();
         }

         else if(gs_LoadGhsToneFlag & BITMAP_LOAD_T1413_TONE)
         {
            LoadT1413ToneToIfftBuf();
         }

         else if(gs_LoadGhsToneFlag & BITMAP_LOAD_SINGLE_TONE)
         {
            LoadSingleToneToIfftBuf();
         }
         else if ((gs_LoadGhsToneFlag & BITMAP_LOAD_BIT_PATTERN) ==0)
         {
            DisableDCI();   //If no tone needs to be loaded, disable QT DCI.
         }

         //Note, the following call is not needed for the 6.2 build, since there loading tones
         //to the IFFT input buffer is done by QT which will trigger IFFT by its done signal

      }
      else
      {

         /* ======================================================================== */
         /* LoadTxPRBSMsgBytes loads the HDLC msg bytes into    */
         /* HW TX PRBS generator                           */
         /* ======================================================================== */
         LoadTxPRBSMsgBytes();
      }
   }


#ifdef PROFILE_TASKS_35B
   //Record the TX TC task time based on the TX timer
   LogTaskProfile(TX_QT_DONE_TC,l_StTxTimer);
#endif //PROFILE_TASKS_35B

   gs_TCStateID = PROCTONE_TX_TC_END;
}


/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void TxParrReshuffle(void);
*
*   Description:
*
*   Time-critical task associated with Tx Parr Done Interrupt
*
*   Arguments:
*      none
*
*-------------------------------------------------------------------
*^^^
*/

void TxParrReshuffle(void)
{
}


/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void RxProcessTones(void);
*
*   Description:
*
*   Time-critical task associated with Rx Frame.  This task is assigned
*   to the Rx Frame interrupt when frequency domain data is to be processed
*   (e.g. SNR calculation)
*
*   Arguments:
*      none
*
*   Global Variables:
*      gp_RxLoadingFunction   -- (I) point to a function Fifo to implement
*                        frame specific processing (e.g. InsertRxCP,
*                        LoadTDQ)
*      gft_EnablePLL         -- (I) set to TRUE to enable PLL
*                        It is set in the state
*                        machine.
*
*-------------------------------------------------------------------
*^^^
*/

/* RxProcessTones is the time critical task to be run at R3 */
/* The state transition part of this code will be moved into non-time critical task
when the loop attenuation code is removed from the GetRxTones function */


void RxProcessTones(void)
{
#ifdef PROFILE_TASKS_35B
   int32 l_StRxTimer;
#endif //PROFILE_TASKS_35B

   gs_TCStateID = PROCTONE_RX_TC_START;

#ifdef PROFILE_TASKS_35B
   //Record the RX TC task start time based on the RX timer
   ReadRxTimer((uint32 *)(void *)&l_StRxTimer);
#endif //PROFILE_TASKS_35B

#ifdef DISTRIBUTE_TX_RX_PROCESS
   // overwrite clock gating setting
   if (gft_DistributeTxRxProcess)
   {
      WriteCCR1RegAtQtDone();
   }
#endif // DISTRIBUTE_TX_RX_PROCESS


   /* ===========================================================================   */
   /* The RxLoading functions are used to modify the engine. It can be used for   */
   /* cyclic prefix insertion, loading equalizer taps, etc                     */
   /* ===========================================================================   */

   // If there are pending loading functions, then run them
   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

#if defined  (VR9_BRINGUP_DBG) || defined (BIT_PATTERN_TEST)
   if(gft_EnableGetRxTime)
   {
      if(gft_TriggerGetRxTime)
      {
#ifndef BIT_PATTERN_TEST
         AccessFftBuffer(gpsa_RxTimeBuffer, 0, (int16)(gs_RxFftLength>>1),
                         FFT_DSP_REORD_ENA, FFT_BUF_READ, RX_FDF_BUF_PRE);
#else //ifndef BIT_PATTERN_TEST
         if(TESTArray[TEST_BIT_PATTERN] & (TEST_BIT_PATTERN_ENABLE | TEST_ECHO_PATH_DELAY_MEASURE))
         {
            AccessFftBuffer(gpsa_RxTimeBuffer, 0, (int16)(gs_RxFftLength>>1),
                            FFT_DSP_REORD_DIS, FFT_BUF_READ, RX_QT_BUF);
         }
         else
         {
            AccessFftBuffer(gpsa_RxTimeBuffer, 0, (int16)(gs_RxFftLength>>1),
                            FFT_DSP_REORD_ENA, FFT_BUF_READ, RX_FDF_BUF_PRE);
         }
#endif //BIT_PATTERN_TEST
         if (gft_TriggerGetRxTime>0)
         {
            gft_TriggerGetRxTime--;
         }
      }
   } //if (gft_EnableGetRxTime)

   if(gft_EnableGetIfftBuf)
   {
      if(gft_TriggerGetIfft)
      {
#ifndef BIT_PATTERN_TEST
         AccessIfftBuffer(gpsa_IfftBuffer, 0, (int16)(gs_TxIfftLength>>1),
                          IFFT_DSP_REORD_ENA, IFFT_BUF_READ, TX_FDF_BUF_PRE);
#else //ifndef BIT_PATTERN_TEST
         if(TESTArray[TEST_BIT_PATTERN] & (TEST_BIT_PATTERN_ENABLE | TEST_ECHO_PATH_DELAY_MEASURE))
         {
            AccessIfftBuffer(gpsa_IfftBuffer, 0, (int16)(gs_TxIfftLength>>1),
                             IFFT_DSP_REORD_DIS, IFFT_BUF_READ, TX_QT_BUF);
         }
         else
         {
            AccessIfftBuffer(gpsa_IfftBuffer, 0, (int16)(gs_TxIfftLength>>1),
                             IFFT_DSP_REORD_ENA, IFFT_BUF_READ, TX_FDF_BUF_PRE);
         }
#endif //BIT_PATTERN_TEST

         if (gft_TriggerGetIfft>0)
         {
            gft_TriggerGetIfft--;
         }
      }
   } //if (gft_EnableGetRxTime)


#endif //#ifdef VR9_BRINGUP_DBG

   /* ===========================================================================   */
   /* The following function GetRxTones is called after the tranceiver training   */
   /* is completed or during the showtime.                                         */
   /* ===========================================================================   */
   if (gft_EnableGetRxTones)
   {
      GetRxTones();           // Capture FFT Buffer

//Debug code

   } //if (gft_EnableGetRxTones)

#ifdef VR9_BRINGUP_DBG
   if(gft_EnableGetGhsRxTones)
   {
      if(gft_TriggerGetGhsRxTones)
      {
         memcpy(gpsa_RxTimeBuffer, gpsa_RxToneBuf, sizeof(int32)*gs_NumChannelsPerGroup);

         if(gft_TriggerGetGhsRxTones > 0)
         {
            gft_TriggerGetGhsRxTones--;
         }
      }
   }
#endif //#ifdef VR9_BRINGUP_DBG


#ifdef USE_ENGINE_FOR_BG_FFTS
   if(gft_GetEngineFFTOutput == TRUE)
   {
      GetEngineFFTResult();
      gft_GetEngineFFTOutput = FALSE;
      gft_GetEngineFFTOutputDone = TRUE;
   }
#endif

   RunPLL();

   // XDSLRTFW-3004 : Debug stream symbol counter is a factor 2 to high for cascaded mode (start_end)
   // only execute when debug streams are enabled
   if(gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK)
   {
      if(guc_CasMode_enable)
      {
         DSH_FgService();
      }
   }
   else
   {
      //Set VersionInfoStreamed to FALSE, so Version Info gets streamed again next time streams get enabled again
      guc_DSH_VersionInfoStreamed = FALSE;
   }
#ifdef PROFILE_TASKS_35B
   //Record the RX TC task time based on the RX timer
   LogTaskProfile(RX_QT_DONE_TC,l_StRxTimer);
#endif //PROFILE_TASKS_35B

   gs_TCStateID = PROCTONE_RX_TC_END;
}

/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void RxProcessTime(void);
*
*   Description:
*
*   Time-critical task associated with Rx Frame.  This task is assigned
*   to the Rx Frame interrupt when time domain data is to be processed
*   (e.g. TDQ training).
*
*
*   Arguments:
*      none
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void RxProcessTime(void)
{
   gs_TCStateID = PROCTIME_RX_TC_START;

#ifdef DISTRIBUTE_TX_RX_PROCESS
   if (gft_DistributeTxRxProcess)
   {
      // register start FFT
      RegStartRxFFT();

      // overwrite clock gating setting
      WriteCCR1RegAtBS();

      gl_RxBSCount++;
   }
   else
#endif // DISTRIBUTE_TX_RX_PROCESS
   {
      // If there are pending loading functions, then run them
      ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

      if(gft_EnableRxTimeDomainRead == TRUE)
      {
         // Read the FFT buffer

         {
            ReadFftBuffer((int16 *)(void*)gla_SharedBuffer_X, 0, (uint16)(gs_RxFftLength>>2));
            ReadFftBuffer((int16 *)(void*)gla_SharedBuffer_Y, (int16)(gs_RxFftLength>>2), (uint16)(gs_RxFftLength>>2));
         }
      } // if(gft_EnableRxTimeDomainRead == TRUE)

   } // if (gft_DistributeTxRxProcess)

   gs_TCStateID = PROCTIME_RX_TC_END;
}
