/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#include <stdio.h>
#include "common.h"
#include "cmv_data.h"
#include "nmp.h"
#include "codeswap.h"

void swap(void);

int32 gl_ImageSize;                // this variable must exist for the
// binary image generation purpose

//==============================================================================
// modem State Machine Variables
//==============================================================================

typedef void  (*PtrToFunc)(void);

uint16 gus_ExceptionCode;         /*  exception code indicating the cause of exception */
uint16 gus_ExceptionState;         /*  state where exception occurs */

int16 gs_TxState;               /* current Tx state */
int16 gs_RxState;               /* current Rx states */
int16 gs_TxSubState;                /* current Tx substate */
int16 gs_RxSubState;             /* current Rx substate */
int16 gs_TxSubStateCnt;             /* TX substate symbol counts */
int16 gs_RxSubStateCnt;               /* RX substate symbol counts */
int32 gl_TxSymbolCount;            /* Tx state symbol counts */
int32 gl_RxSymbolCount;            /* Rx state symbol counts */

int16 gs_TxNextState, gs_RxNextState;               /*  next states */
int16 gs_TxStopState,  gs_RxStopState;               /*  stop states */
int16 gs_TxDoneState, gs_RxDoneState;               /*  done states */

PtrToFunc gpF_TxStateFunc;      // Global function pointer of TX state function
PtrToFunc gpF_RxStateFunc;      // Global function pointer of RX state function
PtrToFunc gpF_TxStateJumpTo;   // Global function pointer of TX jump state
PtrToFunc gpF_RxStateJumpTo;   // Global function pointer of RX jump state

//==============================================================================
// Fast Read Variables
//==============================================================================

int16 gs_FastReadlength;
int16 gs_FastReadDestOffset;
int32 gl_FastReadAddress;
int16 gs_FastReadTimeOutCnt;
int16 gs_RxState_prev;               /* current Rx states */

//==============================================================================
/* The following variables are used to coordinate access to the ARC-to-ME Mailbox.      */
/* The flags guc_MPMsgResp/AutoReq, CodeSwapMsgReq, and FastReadMsgReq are set by the   */
/* messaging, Code Swap, and Fast Read, respectively.  The ProcessTxMailbox            */
/* function monitors these flags and coordinates the access to the ARC-to-ME Mailbox.   */
//==============================================================================

uint8   guc_MPMsgRespReq;
uint8   guc_MPMsgAutoReq;
uint8   guc_CodeSwapMsgReq;
uint8   guc_FastReadMsgReq;

//==============================================================================
// Code Swap Variables
//==============================================================================

int32 gl_ImageSize;
SwapRequest_t gt_SwapRequestQueue[MAX_SWAP_REQUESTS];
SwapControl_t gt_SwapControl;

uint8 guc_RequestedPage = 0;
uint8 guc_PrimPageHandle = INVALID_CODESWAP_HANDLE;
int16 gs_CodeSwapSection;
uint8 guc_InitialPage;
uint8 guc_RxSwapActivity = CODESWAP_DO_NOTHING;
uint8 guc_TxSwapActivity = CODESWAP_DO_NOTHING;


enum {MODEM_OP_IDLE = 0,
      MODEM_OP_LINK_START,            // 1
      MODEM_OP_SLEEP_MODE,            // 2
      MODEM_OP_REQUEST_PAGE,          // 3
      MODEM_OP_WAIT_FOR_SWAP_DONE,    // 4
      MODEM_OP_SWAP_FAILED
     };          // 5

int16 gs_CodeSwapState = MODEM_OP_IDLE;

int16 cnt=0;


void ExceptionHandler(void) {};
int16 CheckForCodeSwapDone(void) {};

FILE *ptr;
void main(void)
{

   int16 s_CodeSwapSection;

   InitCodeSwap();

   ptr = fopen("test.out","w");

   // initialize to trigger swap of page 0
   s_CodeSwapSection = 0;
   CNTLArray[0]= s_CodeSwapSection;
   gs_CodeSwapState = MODEM_OP_REQUEST_PAGE;

   // initialize to send Modem Ready Message
   NewMPSetupReadyMessage();

   while(1)
   {
      ptr = fopen("test.out","a");
      fprintf(ptr,"hello\n");
      fprintf(ptr,"%d \tCSReq:%d \tMPAutoReq: %d \tMPRespReq: %d\n", cnt, guc_CodeSwapMsgReq, guc_MPMsgAutoReq, guc_MPMsgRespReq );
      fclose(ptr);

      // -----------------------------------------------
      // handle CMV read/write
      // -----------------------------------------------
      NewMPCheckMessage();

      // -----------------------------------------------
      // Allow the ME to trigger codeswap requests using OPTN CMV
      // -----------------------------------------------
      if ((CNTLArray[0] != s_CodeSwapSection) && (gs_CodeSwapState == 0))
      {
         s_CodeSwapSection = CNTLArray[0];
         gs_CodeSwapState = MODEM_OP_REQUEST_PAGE;
         printf("code swap (page %d) request from main\n",s_CodeSwapSection);

      }

      // -----------------------------------------------
      // Call the test code corresponding to the current swap page.
      // -----------------------------------------------
      if (gs_CodeSwapState == MODEM_OP_IDLE)
      {
         if (s_CodeSwapSection == 0)
         {
            swap1();
         }
         if (s_CodeSwapSection == 1)
         {
            swap2();
         }
      }

      // -----------------------------------------------
      // Run the Code Swap Engine
      // -----------------------------------------------

      switch(gs_CodeSwapState)
      {
      case MODEM_OP_REQUEST_PAGE:
         if ((guc_PrimPageHandle = RequestSwap(s_CodeSwapSection)) == INVALID_CODESWAP_HANDLE)
         {
            gs_CodeSwapState = MODEM_OP_SWAP_FAILED;
            printf("code swap error - INVALID_CODESWAP_HANDLE) \n");
         }
         else
         {
            gs_CodeSwapState = MODEM_OP_WAIT_FOR_SWAP_DONE;
         }
         break;

      case MODEM_OP_WAIT_FOR_SWAP_DONE:
         if (GetRequestStatus(guc_PrimPageHandle) == SWAP_DONE)
         {
            gs_CodeSwapState = MODEM_OP_IDLE;
            FreeSwapHandle(&guc_PrimPageHandle);
            printf("code swap (page %d) done (checked in main) \n",s_CodeSwapSection);
         }
         else if (GetRequestStatus(guc_PrimPageHandle) == SWAP_ERROR)
         {
            gs_CodeSwapState = MODEM_OP_SWAP_FAILED;
            FreeSwapHandle(&guc_PrimPageHandle);
            printf("code swap error - SWAP_ERROR) \n");
         }
         break;

      }

      RunCodeSwapEngine(SWAP_TIMING_OFF);


   } /* end while(1) */


}
