# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
$infile = "../../source/Vdsl_Task/include/cmv.h";
$outfile = "GenCmvDefines.c";

open(INFILE, "<$infile") or die "Can't open input file: $!\n";
open(OUTFILE, ">$outfile") or die "Can't open output file: $!\n";

printf OUTFILE "#include <stdio.h>\n";
printf OUTFILE "#include \"common.h\"\n";
printf OUTFILE "#include \"cmv.h\"\n";
printf OUTFILE "#include \"gdata.h\"\n";
printf OUTFILE "#include \"g997.h\"\n";
printf OUTFILE "\n";

printf OUTFILE "void main(void)\n";
printf OUTFILE "{\n";
printf OUTFILE "\tFILE *fptr, *fptr_co, *fptr_rt;\n\n";
printf OUTFILE "\tfptr = fopen(\"cmv_defines.sc\",\"w\");\n";
printf OUTFILE "\tfptr_co = fopen(\"CO_hercules_cmv_defines.sc\",\"w\");\n";
printf OUTFILE "\tfptr_rt = fopen(\"RT_hercules_cmv_defines.sc\",\"w\");\n";
printf OUTFILE "\n";

prn_cmv(MONI);
printf OUTFILE "\n";

prn_cmv(INFO);
printf OUTFILE "\n";

prn_cmv(INFO2);
printf OUTFILE "\n";

prn_cmv(RATE);
printf OUTFILE "\n";

prn_cmv(PLAM);
printf OUTFILE "\n";

prn_cmv(CNTL);
printf OUTFILE "\n";

prn_cmv(STAT);
printf OUTFILE "\n";

prn_cmv(TEST);
printf OUTFILE "\n";

prn_cmv(OPTN);
printf OUTFILE "\n";

prn_cmv(CNFG);
printf OUTFILE "\n";

prn_cmv(CNTR);
printf OUTFILE "\n";

printf OUTFILE "\tfclose(fptr);\n";
printf OUTFILE "\tfclose(fptr_co);\n";
printf OUTFILE "\tfclose(fptr_rt);\n";

printf OUTFILE "}\n";

close(OUTFILE);

sub prn_cmv
{
    my ($name) = @_;

    open(INFILE, "<$infile") or die "Can't open input file: $!\n";
    while (<INFILE>)
    {
        if (/(^#define|\s#define)\s+(\w+)/)
        {
            $cmv_def = $2;
            $cmv_val = $cmv_def;
            $cmv_val = "$cmv_val + 200" if ($name eq "INFO2");
            printf OUTFILE "\tfprintf(fptr, \"init $cmv_def %s\\n\", $cmv_val);\n", '%d' if /\b$name+_\w+/;
            printf OUTFILE "\tfprintf(fptr_co, \"init CO_HERC_$cmv_def %s\\n\", $cmv_val);\n", '%d' if /\b$name+_\w+/;
            printf OUTFILE "\tfprintf(fptr_rt, \"init RT_HERC_$cmv_def %s\\n\", $cmv_val);\n", '%d' if /\b$name+_\w+/;
        }
    }
    printf OUTFILE "\tfprintf(fptr, \"\\n\");\n";
    printf OUTFILE "\tfprintf(fptr_co, \"\\n\");\n";
    printf OUTFILE "\tfprintf(fptr_rt, \"\\n\");\n";
    close(INFILE);
}
