/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename : GenMemoryMap.c
*
*   This file contains the main program to generate all core memory map.
*
*-------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "afeif_memmap.h"
#include "alp_memmap.h"
#include "bcr_memmap.h"
#include "cri_memmap.h"
#include "ft_memmap.h"
#include "qt_memmap.h"
#include "v_str_memmap.h"
#include "strymon_cpe_memmap.h"
#include "zep_ilv_memmap.h"
#include "zep_memmap.h"

void main(void)
{
   FILE *fptr;

   fptr = fopen("Hercules Memory Map.txt","w");

   fprintf(fptr, "====================================================\n");
   fprintf(fptr, "                     MEMORY MAP                     \n");
   fprintf(fptr, "====================================================\n");
   fprintf(fptr, "\n");

   fprintf(fptr, "**** AFE MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "AI_DATA_MEM_ADDR                        : 0x%08lx\n", 4*AI_DATA_MEM_ADDR);
   fprintf(fptr, "AI_SERIAL_MEM_ADDR                      : 0x%08lx\n", 4*AI_SERIAL_MEM_ADDR);
   fprintf(fptr, "AI_MAX_MEM_ADDR                         : 0x%08lx\n", 4*AI_MAX_MEM_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** ALPHAEUS MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_RX_CELLBUFFER_ADDR                  : 0x%08lx\n", 4*ALP_RX_CELLBUFFER_ADDR);
   fprintf(fptr, "ALP_TX_CELLBUFFER_ADDR                  : 0x%08lx\n", 4*ALP_TX_CELLBUFFER_ADDR);
   fprintf(fptr, "ALP_DCP_RX_CELLBUFFER_ADDR              : 0x%08lx\n", 4*ALP_DCP_RX_CELLBUFFER_ADDR);
   fprintf(fptr, "ALP_DCP_TX_CELLBUFFER_ADDR              : 0x%08lx\n", 4*ALP_DCP_TX_CELLBUFFER_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** BCR MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "BCR_RAM_TX_FRAMEBUF_ADDR                : 0x%08lx\n", 4*BCR_RAM_TX_FRAMEBUF_ADDR);
   fprintf(fptr, "BCR_RAM_RX_FRAMEBUF_ADDR                : 0x%08lx\n", 4*BCR_RAM_RX_FRAMEBUF_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** IRIDIA-FT MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "IRI_FT_RAM_TX_IFFT_A_ADDR               : 0x%08lx\n", 4*IRI_FT_RAM_TX_IFFT_A_ADDR);
   fprintf(fptr, "IRI_FT_RAM_TX_IFFT_B_ADDR               : 0x%08lx\n", 4*IRI_FT_RAM_TX_IFFT_B_ADDR);
   fprintf(fptr, "IRI_FT_RAM_TX_IFFT_C_ADDR               : 0x%08lx\n", 4*IRI_FT_RAM_TX_IFFT_C_ADDR);
   fprintf(fptr, "IRI_FT_RAM_RX_FFT_A_ADDR                : 0x%08lx\n", 4*IRI_FT_RAM_RX_FFT_A_ADDR);
   fprintf(fptr, "IRI_FT_RAM_RX_FFT_B_ADDR                : 0x%08lx\n", 4*IRI_FT_RAM_RX_FFT_B_ADDR);
   fprintf(fptr, "IRI_FT_RAM_RX_FFT_C_ADDR                : 0x%08lx\n", 4*IRI_FT_RAM_RX_FFT_C_ADDR);
   fprintf(fptr, "IRI_FT_RAM_TX_PAR_PVEC_ADDR             : 0x%08lx\n", 4*IRI_FT_RAM_TX_PAR_PVEC_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** IRIDIA-QT MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "IRI_QT_RAM_TONE_REORDER_ADDR            : 0x%08lx\n", 4*IRI_QT_RAM_TONE_REORDER_ADDR);
   fprintf(fptr, "IRI_QT_RAM_GAIN_SCALE_ADDR              : 0x%08lx\n", 4*IRI_QT_RAM_GAIN_SCALE_ADDR);
   fprintf(fptr, "IRI_QT_RAM_BIT_ALLOCATION_ADDR          : 0x%08lx\n", 4*IRI_QT_RAM_BIT_ALLOCATION_ADDR);
   fprintf(fptr, "IRI_QT_RAM_EXT_GAIN_ADDR                : 0x%08lx\n", 4*IRI_QT_RAM_EXT_GAIN_ADDR);
   fprintf(fptr, "IRI_QT_RAM_SFDQ_COEF_MANT_ADDR          : 0x%08lx\n", 4*IRI_QT_RAM_SFDQ_COEF_MANT_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_XY_DECISION_ADDR          : 0x%08lx\n", 4*IRI_QT_RAM_RX_XY_DECISION_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_SURVIVOR_PATH_ADDR        : 0x%08lx\n", 4*IRI_QT_RAM_RX_SURVIVOR_PATH_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_VITERBI_DECISION_ADDR     : 0x%08lx\n", 4*IRI_QT_RAM_RX_VITERBI_DECISION_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_NOISY_POINT_SPAD_ADDR     : 0x%08lx\n", 4*IRI_QT_RAM_RX_NOISY_POINT_SPAD_ADDR);
   fprintf(fptr, "IRI_QT_RAM_TX_CONSTELLATION_GAINS_ADDR  : 0x%08lx\n", 4*IRI_QT_RAM_TX_CONSTELLATION_GAINS_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_CONSTELLATION_GAINS_ADDR  : 0x%08lx\n", 4*IRI_QT_RAM_RX_CONSTELLATION_GAINS_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_ADDR   : 0x%08lx\n", 4*IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_ADDR  : 0x%08lx\n", 4*IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR    : 0x%08lx\n", 4*IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR    : 0x%08lx\n", 4*IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR     : 0x%08lx\n", 4*IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_TONE_VALUE0_ADDR          : 0x%08lx\n", 4*IRI_QT_RAM_RX_TONE_VALUE0_ADDR);
   fprintf(fptr, "IRI_QT_RAM_RX_TONE_VALUE1_ADDR          : 0x%08lx\n", 4*IRI_QT_RAM_RX_TONE_VALUE1_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** STRYMON CPE 3.1 MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "S_DT_RAM_LOW_ADDR                       : 0x%08lx\n", 4*S_DT_RAM_LOW_ADDR);
   fprintf(fptr, "S_DT_RAM_HIGH_ADDR                      : 0x%08lx\n", 4*S_DT_RAM_HIGH_ADDR);
   fprintf(fptr, "S_CO_RAM_2_LOW_ADDR                     : 0x%08lx\n", 4*S_CO_RAM_2_LOW_ADDR);
   fprintf(fptr, "S_CO_RAM_2_HIGH_ADDR                    : 0x%08lx\n", 4*S_CO_RAM_2_HIGH_ADDR);
   fprintf(fptr, "S_CO_RAM_5_LOW_ADDR                     : 0x%08lx\n", 4*S_CO_RAM_5_LOW_ADDR);
   fprintf(fptr, "S_CO_RAM_5_HIGH_ADDR                    : 0x%08lx\n", 4*S_CO_RAM_5_HIGH_ADDR);
   fprintf(fptr, "S_CO_RAM_3_LOW_ADDR                     : 0x%08lx\n", 4*S_CO_RAM_3_LOW_ADDR);
   fprintf(fptr, "S_CO_RAM_3_HIGH_ADDR                    : 0x%08lx\n", 4*S_CO_RAM_3_HIGH_ADDR);
   fprintf(fptr, "S_CO_RAM_1_LOW_ADDR                     : 0x%08lx\n", 4*S_CO_RAM_1_LOW_ADDR);
   fprintf(fptr, "S_CO_RAM_1_HIGH_ADDR                    : 0x%08lx\n", 4*S_CO_RAM_1_HIGH_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** V-STRYMON MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "V_DEC_TDQ_CO_ADDR                       : 0x%08lx\n", 4*V_DEC_TDQ_CO_ADDR);
   fprintf(fptr, "V_DEC_TDQ_PS_ADDR                       : 0x%08lx\n", 4*V_DEC_TDQ_PS_ADDR);
   fprintf(fptr, "V_DECIM_PS_ADDR                         : 0x%08lx\n", 4*V_DECIM_PS_ADDR);
   fprintf(fptr, "V_DECIM_CO_ADDR                         : 0x%08lx\n", 4*V_DECIM_CO_ADDR);
   fprintf(fptr, "V_TXWIN_COPS_ADDR                       : 0x%08lx\n", 4*V_TXWIN_COPS_ADDR);
   fprintf(fptr, "V_RXWIN_COPS_ADDR                       : 0x%08lx\n", 4*V_RXWIN_COPS_ADDR);
   fprintf(fptr, "V_TXIIR_CO_ADDR                         : 0x%08lx\n", 4*V_TXIIR_CO_ADDR);
   fprintf(fptr, "V_INTERP_PS_ADDR                        : 0x%08lx\n", 4*V_INTERP_PS_ADDR);
   fprintf(fptr, "V_INTERP_CO_ADDR                        : 0x%08lx\n", 4*V_INTERP_CO_ADDR);
   fprintf(fptr, "V_DEC_CAPTURE_ADDR                      : 0x%08lx\n", 4*V_DEC_CAPTURE_ADDR);
   fprintf(fptr, "V_RXIIR_CO_ADDR                         : 0x%08lx\n", 4*V_RXIIR_CO_ADDR);
   fprintf(fptr, "V_AFEDECIM_CO_ADDR                      : 0x%08lx\n", 4*V_AFEDECIM_CO_ADDR);
   fprintf(fptr, "V_SRCCO0_ADDR                           : 0x%08lx\n", 4*V_SRCCO0_ADDR);
   fprintf(fptr, "V_SRCCO1_ADDR                           : 0x%08lx\n", 4*V_SRCCO1_ADDR);
   fprintf(fptr, "V_MAX_RAM_ADDR                          : 0x%08lx\n", 4*V_MAX_RAM_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** ZEPHYR-ILV MEMORY ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "ZEP_ILV_RAM_ILVB_ADDR                   : 0x%08lx\n", 4*ZEP_ILV_RAM_ILVB_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_DILVB_ADDR                  : 0x%08lx\n", 4*ZEP_ILV_RAM_DILVB_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_TXDTB_ADDR                  : 0x%08lx\n", 4*ZEP_ILV_RAM_TXDTB_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_RXDTB_ADDR                  : 0x%08lx\n", 4*ZEP_ILV_RAM_RXDTB_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_IFB_ADDR                    : 0x%08lx\n", 4*ZEP_ILV_RAM_IFB_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_IFWP_ADDR                   : 0x%08lx\n", 4*ZEP_ILV_RAM_IFWP_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_IFRP_ADDR                   : 0x%08lx\n", 4*ZEP_ILV_RAM_IFRP_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_DFB_ADDR                    : 0x%08lx\n", 4*ZEP_ILV_RAM_DFB_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_DFWP_ADDR                   : 0x%08lx\n", 4*ZEP_ILV_RAM_DFWP_ADDR);
   fprintf(fptr, "ZEP_ILV_RAM_DFRP_ADDR                   : 0x%08lx\n", 4*ZEP_ILV_RAM_DFRP_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "====================================================\n");
   fprintf(fptr, "                    REGISTER MAP                    \n");
   fprintf(fptr, "====================================================\n");
   fprintf(fptr, "\n");

   fprintf(fptr, "**** AFEIF REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "AI_CONFIG_ADDR                          : 0x%08lx\n", 4*AI_CONFIG_ADDR);
   fprintf(fptr, "AI_SERIAL_SEQUENCE_0_ADDR               : 0x%08lx\n", 4*AI_SERIAL_SEQUENCE_0_ADDR);
   fprintf(fptr, "AI_SERIAL_SEQUENCE_1_ADDR               : 0x%08lx\n", 4*AI_SERIAL_SEQUENCE_1_ADDR);
   fprintf(fptr, "AI_SERIAL_TRIGGER_ADDR                  : 0x%08lx\n", 4*AI_SERIAL_TRIGGER_ADDR);
   fprintf(fptr, "AI_SERIAL_DATA_ADDR                     : 0x%08lx\n", 4*AI_SERIAL_DATA_ADDR);
   fprintf(fptr, "AI_MEM_CONFIG_ADDR                      : 0x%08lx\n", 4*AI_MEM_CONFIG_ADDR);
   fprintf(fptr, "AI_TXROUTE_0_ADDR                       : 0x%08lx\n", 4*AI_TXROUTE_0_ADDR);
   fprintf(fptr, "AI_TXROUTE_1_ADDR                       : 0x%08lx\n", 4*AI_TXROUTE_1_ADDR);
   fprintf(fptr, "AI_ECROUTE_0_ADDR                       : 0x%08lx\n", 4*AI_ECROUTE_0_ADDR);
   fprintf(fptr, "AI_ECROUTE_1_ADDR                       : 0x%08lx\n", 4*AI_ECROUTE_1_ADDR);
   fprintf(fptr, "AI_RXROUTE_0_ADDR                       : 0x%08lx\n", 4*AI_RXROUTE_0_ADDR);
   fprintf(fptr, "AI_RXROUTE_1_ADDR                       : 0x%08lx\n", 4*AI_RXROUTE_1_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** ALPHAEUS REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_CVER_ADDR                           : 0x%08lx\n", 4*ALP_CVER_ADDR);
   fprintf(fptr, "ALP_UTP_CFG_ADDR                        : 0x%08lx\n", 4*ALP_UTP_CFG_ADDR);
   fprintf(fptr, "ALP_UTP_STAT_ADDR                       : 0x%08lx\n", 4*ALP_UTP_STAT_ADDR);
   fprintf(fptr, "ALP_INT_STAT_ADDR                       : 0x%08lx\n", 4*ALP_INT_STAT_ADDR);
   fprintf(fptr, "ALP_INT_MASK_ADDR                       : 0x%08lx\n", 4*ALP_INT_MASK_ADDR);
   fprintf(fptr, "ALP_DEBUG1_ADDR                         : 0x%08lx\n", 4*ALP_DEBUG1_ADDR);
   fprintf(fptr, "ALP_DEBUG2_ADDR                         : 0x%08lx\n", 4*ALP_DEBUG2_ADDR);
   fprintf(fptr, "ALP_DCP_CONFIG_ADDR                     : 0x%08lx\n", 4*ALP_DCP_CONFIG_ADDR);
   fprintf(fptr, "ALP_DCP_STAT_ADDR                       : 0x%08lx\n", 4*ALP_DCP_STAT_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_T_CONFIG_ADDR                       : 0x%08lx\n", 4*ALP_T_CONFIG_ADDR);
   fprintf(fptr, "ALP_T_CB_STAT_ADDR                      : 0x%08lx\n", 4*ALP_T_CB_STAT_ADDR);
   fprintf(fptr, "ALP_T_CB_CFG_BC0_ADDR                   : 0x%08lx\n", 4*ALP_T_CB_CFG_BC0_ADDR);
   fprintf(fptr, "ALP_T_CB_CFG_BC1_ADDR                   : 0x%08lx\n", 4*ALP_T_CB_CFG_BC1_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_T_PCNTL_BC0_ADDR                    : 0x%08lx\n", 4*ALP_T_PCNTL_BC0_ADDR);
   fprintf(fptr, "ALP_T_IDLE_BC0_ADDR                     : 0x%08lx\n", 4*ALP_T_IDLE_BC0_ADDR);
   fprintf(fptr, "ALP_T_CELL_CNT_BC0_ADDR                 : 0x%08lx\n", 4*ALP_T_CELL_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_T_IDLE_CNT_BC0_ADDR                 : 0x%08lx\n", 4*ALP_T_IDLE_CNT_BC0_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_T_PCNTL_BC1_ADDR                    : 0x%08lx\n", 4*ALP_T_PCNTL_BC1_ADDR);
   fprintf(fptr, "ALP_T_IDLE_BC1_ADDR                     : 0x%08lx\n", 4*ALP_T_IDLE_BC1_ADDR);
   fprintf(fptr, "ALP_T_CELL_CNT_BC1_ADDR                 : 0x%08lx\n", 4*ALP_T_CELL_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_T_IDLE_CNT_BC1_ADDR                 : 0x%08lx\n", 4*ALP_T_IDLE_CNT_BC1_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_R_CONFIG_ADDR                       : 0x%08lx\n", 4*ALP_R_CONFIG_ADDR);
   fprintf(fptr, "ALP_R_CB_STAT_ADDR                      : 0x%08lx\n", 4*ALP_R_CB_STAT_ADDR);
   fprintf(fptr, "ALP_R_CB_CFG_BC0_ADDR                   : 0x%08lx\n", 4*ALP_R_CB_CFG_BC0_ADDR);
   fprintf(fptr, "ALP_R_CB_CFG_BC1_ADDR                   : 0x%08lx\n", 4*ALP_R_CB_CFG_BC1_ADDR);
   fprintf(fptr, "ALP_R_IMAHEC_ADDR                       : 0x%08lx\n", 4*ALP_R_IMAHEC_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_R_PCNTL_BC0_ADDR                    : 0x%08lx\n", 4*ALP_R_PCNTL_BC0_ADDR);
   fprintf(fptr, "ALP_R_ATM_STAT_BC0_ADDR                 : 0x%08lx\n", 4*ALP_R_ATM_STAT_BC0_ADDR);
   fprintf(fptr, "ALP_R_CELL_CNT_BC0_ADDR                 : 0x%08lx\n", 4*ALP_R_CELL_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_R_IDLE_CNT_BC0_ADDR                 : 0x%08lx\n", 4*ALP_R_IDLE_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_R_AIDLE_CNT_BC0_ADDR                : 0x%08lx\n", 4*ALP_R_AIDLE_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_R_BE_CNT_BC0_ADDR                   : 0x%08lx\n", 4*ALP_R_BE_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_R_HEC_CNT_BC0_ADDR                  : 0x%08lx\n", 4*ALP_R_HEC_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_R_CD_CNT_BC0_ADDR                   : 0x%08lx\n", 4*ALP_R_CD_CNT_BC0_ADDR);
   fprintf(fptr, "ALP_R_IDLE_BC0_ADDR                     : 0x%08lx\n", 4*ALP_R_IDLE_BC0_ADDR);
   fprintf(fptr, "ALP_R_DELIN_BC0_ADDR                    : 0x%08lx\n", 4*ALP_R_DELIN_BC0_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_R_PCNTL_BC1_ADDR                    : 0x%08lx\n", 4*ALP_R_PCNTL_BC1_ADDR);
   fprintf(fptr, "ALP_R_ATM_STAT_BC1_ADDR                 : 0x%08lx\n", 4*ALP_R_ATM_STAT_BC1_ADDR);
   fprintf(fptr, "ALP_R_CELL_CNT_BC1_ADDR                 : 0x%08lx\n", 4*ALP_R_CELL_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_R_IDLE_CNT_BC1_ADDR                 : 0x%08lx\n", 4*ALP_R_IDLE_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_R_AIDLE_CNT_BC1_ADDR                : 0x%08lx\n", 4*ALP_R_AIDLE_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_R_BE_CNT_BC1_ADDR                   : 0x%08lx\n", 4*ALP_R_BE_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_R_HEC_CNT_BC1_ADDR                  : 0x%08lx\n", 4*ALP_R_HEC_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_R_CD_CNT_BC1_ADDR                   : 0x%08lx\n", 4*ALP_R_CD_CNT_BC1_ADDR);
   fprintf(fptr, "ALP_R_IDLE_BC1_ADDR                     : 0x%08lx\n", 4*ALP_R_IDLE_BC1_ADDR);
   fprintf(fptr, "ALP_R_DELIN_BC1_ADDR                    : 0x%08lx\n", 4*ALP_R_DELIN_BC1_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_T_XTC_CONFIG_ADDR                   : 0x%08lx\n", 4*ALP_T_XTC_CONFIG_ADDR);
   fprintf(fptr, "ALP_T_XTC_CB_CFG_ADDR                   : 0x%08lx\n", 4*ALP_T_XTC_CB_CFG_ADDR);
   fprintf(fptr, "ALP_T_XTC_STAT_ADDR                     : 0x%08lx\n", 4*ALP_T_XTC_STAT_ADDR);
   fprintf(fptr, "ALP_T_XTC_DMT_DLY_ADDR                  : 0x%08lx\n", 4*ALP_T_XTC_DMT_DLY_ADDR);
   fprintf(fptr, "ALP_T_XTC_DMT_DLY_A_ADDR                : 0x%08lx\n", 4*ALP_T_XTC_DMT_DLY_A_ADDR);
   fprintf(fptr, "ALP_T_XTC_SIZE0_ADDR                    : 0x%08lx\n", 4*ALP_T_XTC_SIZE0_ADDR);
   fprintf(fptr, "ALP_T_XTC_SIZE0_A_ADDR                  : 0x%08lx\n", 4*ALP_T_XTC_SIZE0_A_ADDR);
   fprintf(fptr, "ALP_T_XTC_SIZE1_ADDR                    : 0x%08lx\n", 4*ALP_T_XTC_SIZE1_ADDR);
   fprintf(fptr, "ALP_T_XTC_SIZE1_A_ADDR                  : 0x%08lx\n", 4*ALP_T_XTC_SIZE1_A_ADDR);
   fprintf(fptr, "ALP_T_XTC_BYTE_DLY0_ADDR                : 0x%08lx\n", 4*ALP_T_XTC_BYTE_DLY0_ADDR);
   fprintf(fptr, "ALP_T_XTC_BYTE_DLY0_A_ADDR              : 0x%08lx\n", 4*ALP_T_XTC_BYTE_DLY0_A_ADDR);
   fprintf(fptr, "ALP_T_XTC_BYTE_DLY1_ADDR                : 0x%08lx\n", 4*ALP_T_XTC_BYTE_DLY1_ADDR);
   fprintf(fptr, "ALP_T_XTC_BYTE_DLY1_A_ADDR              : 0x%08lx\n", 4*ALP_T_XTC_BYTE_DLY1_A_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ALP_R_XTC_CONFIG_ADDR                   : 0x%08lx\n", 4*ALP_R_XTC_CONFIG_ADDR);
   fprintf(fptr, "ALP_R_XTC_CB_CFG_ADDR                   : 0x%08lx\n", 4*ALP_R_XTC_CB_CFG_ADDR);
   fprintf(fptr, "ALP_R_XTC_STAT_ADDR                     : 0x%08lx\n", 4*ALP_R_XTC_STAT_ADDR);
   fprintf(fptr, "ALP_R_XTC_DMT_DLY_ADDR                  : 0x%08lx\n", 4*ALP_R_XTC_DMT_DLY_ADDR);
   fprintf(fptr, "ALP_R_XTC_DMT_DLY_A_ADDR                : 0x%08lx\n", 4*ALP_R_XTC_DMT_DLY_A_ADDR);
   fprintf(fptr, "ALP_R_XTC_SIZE0_ADDR                    : 0x%08lx\n", 4*ALP_R_XTC_SIZE0_ADDR);
   fprintf(fptr, "ALP_R_XTC_SIZE0_A_ADDR                  : 0x%08lx\n", 4*ALP_R_XTC_SIZE0_A_ADDR);
   fprintf(fptr, "ALP_R_XTC_SIZE1_ADDR                    : 0x%08lx\n", 4*ALP_R_XTC_SIZE1_ADDR);
   fprintf(fptr, "ALP_R_XTC_SIZE1_A_ADDR                  : 0x%08lx\n", 4*ALP_R_XTC_SIZE1_A_ADDR);
   fprintf(fptr, "ALP_R_XTC_BYTE_DLY0_ADDR                : 0x%08lx\n", 4*ALP_R_XTC_BYTE_DLY0_ADDR);
   fprintf(fptr, "ALP_R_XTC_BYTE_DLY0_A_ADDR              : 0x%08lx\n", 4*ALP_R_XTC_BYTE_DLY0_A_ADDR);
   fprintf(fptr, "ALP_R_XTC_BYTE_DLY1_ADDR                : 0x%08lx\n", 4*ALP_R_XTC_BYTE_DLY1_ADDR);
   fprintf(fptr, "ALP_R_XTC_BYTE_DLY1_A_ADDR              : 0x%08lx\n", 4*ALP_R_XTC_BYTE_DLY1_A_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** BCR REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "BCR_BT_CFG_ADDR                         : 0x%08lx\n", 4*BCR_BT_CFG_ADDR);
   fprintf(fptr, "BCR_BT_VBC_MAP_ADDR                     : 0x%08lx\n", 4*BCR_BT_VBC_MAP_ADDR);
   fprintf(fptr, "BCR_BT_ABC0_WR_ADDR                     : 0x%08lx\n", 4*BCR_BT_ABC0_WR_ADDR);
   fprintf(fptr, "BCR_BT_ABC1_WR_ADDR                     : 0x%08lx\n", 4*BCR_BT_ABC1_WR_ADDR);
   fprintf(fptr, "BCR_BT_VBC_RD_ADDR                      : 0x%08lx\n", 4*BCR_BT_VBC_RD_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "BCR_BR_CFG_ADDR                         : 0x%08lx\n", 4*BCR_BR_CFG_ADDR);
   fprintf(fptr, "BCR_BR_VBC_MAP_ADDR                     : 0x%08lx\n", 4*BCR_BR_VBC_MAP_ADDR);
   fprintf(fptr, "BCR_BR_ABC0_RD_ADDR                     : 0x%08lx\n", 4*BCR_BR_ABC0_RD_ADDR);
   fprintf(fptr, "BCR_BR_ABC1_RD_ADDR                     : 0x%08lx\n", 4*BCR_BR_ABC1_RD_ADDR);
   fprintf(fptr, "BCR_BR_VBC_WR_ADDR                      : 0x%08lx\n", 4*BCR_BR_VBC_WR_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** CRI REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "CRI_CCR0_ADDR                           : 0x%08lx\n", 4*CRI_CCR0_ADDR);
   fprintf(fptr, "CRI_CCR1_ADDR                           : 0x%08lx\n", 4*CRI_CCR1_ADDR);
   fprintf(fptr, "CRI_RST_ADDR                            : 0x%08lx\n", 4*CRI_RST_ADDR);
   fprintf(fptr, "CRI_MASK0_TX_ADDR                       : 0x%08lx\n", 4*CRI_MASK0_TX_ADDR);
   fprintf(fptr, "CRI_MASK0_RX_ADDR                       : 0x%08lx\n", 4*CRI_MASK0_RX_ADDR);
   fprintf(fptr, "CRI_MASK1_TX_ADDR                       : 0x%08lx\n", 4*CRI_MASK1_TX_ADDR);
   fprintf(fptr, "CRI_MASK1_RX_ADDR                       : 0x%08lx\n", 4*CRI_MASK1_RX_ADDR);
   fprintf(fptr, "CRI_STATUS0_ADDR                        : 0x%08lx\n", 4*CRI_STATUS0_ADDR);
   fprintf(fptr, "CRI_STATUS1_ADDR                        : 0x%08lx\n", 4*CRI_STATUS1_ADDR);
   fprintf(fptr, "CRI_AMASK0_TX_ADDR                      : 0x%08lx\n", 4*CRI_AMASK0_TX_ADDR);
   fprintf(fptr, "CRI_AMASK0_RX_ADDR                      : 0x%08lx\n", 4*CRI_AMASK0_RX_ADDR);
   fprintf(fptr, "CRI_AMASK1_TX_ADDR                      : 0x%08lx\n", 4*CRI_AMASK1_TX_ADDR);
   fprintf(fptr, "CRI_AMASK1_RX_ADDR                      : 0x%08lx\n", 4*CRI_AMASK1_RX_ADDR);
   fprintf(fptr, "CRI_UPDCTL_ADDR                         : 0x%08lx\n", 4*CRI_UPDCTL_ADDR);
   fprintf(fptr, "CRI_EVENT_ADDR                          : 0x%08lx\n", 4*CRI_EVENT_ADDR);
   fprintf(fptr, "CRI_TX_TIMER_ADDR                       : 0x%08lx\n", 4*CRI_TX_TIMER_ADDR);
   fprintf(fptr, "CRI_TX_TIMER_CTL_ADDR                   : 0x%08lx\n", 4*CRI_TX_TIMER_CTL_ADDR);
   fprintf(fptr, "CRI_RX_TIMER_ADDR                       : 0x%08lx\n", 4*CRI_RX_TIMER_ADDR);
   fprintf(fptr, "CRI_RX_TIMER_CTL_ADDR                   : 0x%08lx\n", 4*CRI_RX_TIMER_CTL_ADDR);
   fprintf(fptr, "CRI_TX_AXTC_CTL_ADDR                    : 0x%08lx\n", 4*CRI_TX_AXTC_CTL_ADDR);
   fprintf(fptr, "CRI_TX_BCR_CTL_ADDR                     : 0x%08lx\n", 4*CRI_TX_BCR_CTL_ADDR);
   fprintf(fptr, "CRI_TX_FC_CTL_ADDR                      : 0x%08lx\n", 4*CRI_TX_FC_CTL_ADDR);
   fprintf(fptr, "CRI_TX_QT_CTL_ADDR                      : 0x%08lx\n", 4*CRI_TX_QT_CTL_ADDR);
   fprintf(fptr, "CRI_TX_IFFT_CTL_ADDR                    : 0x%08lx\n", 4*CRI_TX_IFFT_CTL_ADDR);
   fprintf(fptr, "CRI_TX_PARR_CTL_ADDR                    : 0x%08lx\n", 4*CRI_TX_PARR_CTL_ADDR);
   fprintf(fptr, "CRI_RX_FFT_CTL_ADDR                     : 0x%08lx\n", 4*CRI_RX_FFT_CTL_ADDR);
   fprintf(fptr, "CRI_RX_QT_CTL_ADDR                      : 0x%08lx\n", 4*CRI_RX_QT_CTL_ADDR);
   fprintf(fptr, "CRI_RX_FC_CTL_ADDR                      : 0x%08lx\n", 4*CRI_RX_FC_CTL_ADDR);
   fprintf(fptr, "CRI_RX_BCR_CTL_ADDR                     : 0x%08lx\n", 4*CRI_RX_BCR_CTL_ADDR);
   fprintf(fptr, "CRI_RX_AXTC_CTL_ADDR                    : 0x%08lx\n", 4*CRI_RX_AXTC_CTL_ADDR);
   fprintf(fptr, "CRI_DBGVIS_CFG_ADDR                     : 0x%08lx\n", 4*CRI_DBGVIS_CFG_ADDR);
   fprintf(fptr, "CRI_DBGVIS_DCTL_ADDR                    : 0x%08lx\n", 4*CRI_DBGVIS_DCTL_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** IRIDIA-FT REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "IRI_FT_REG_TX_CTRL_ADDR                 : 0x%08lx\n", 4*IRI_FT_REG_TX_CTRL_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_STATUS_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_TX_STATUS_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_SCALE_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_TX_SCALE_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_EXTEN_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_TX_EXTEN_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_AEXTEN_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_TX_AEXTEN_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_BETA_ADDR                 : 0x%08lx\n", 4*IRI_FT_REG_TX_BETA_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_ABETA_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_TX_ABETA_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_FSIZE_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_TX_FSIZE_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_AFSIZE_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_TX_AFSIZE_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_FSOFFSET_IN_ADDR          : 0x%08lx\n", 4*IRI_FT_REG_TX_FSOFFSET_IN_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_FSOFFSET_ER_ADDR          : 0x%08lx\n", 4*IRI_FT_REG_TX_FSOFFSET_ER_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_PARR_PARAM_ADDR           : 0x%08lx\n", 4*IRI_FT_REG_TX_PARR_PARAM_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_PARR_MAX0_ADDR            : 0x%08lx\n", 4*IRI_FT_REG_TX_PARR_MAX0_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_PARR_MAX1_ADDR            : 0x%08lx\n", 4*IRI_FT_REG_TX_PARR_MAX1_ADDR);
   fprintf(fptr, "IRI_FT_REG_TX_PARR_MAX2_ADDR            : 0x%08lx\n", 4*IRI_FT_REG_TX_PARR_MAX2_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_CTRL_ADDR                 : 0x%08lx\n", 4*IRI_FT_REG_RX_CTRL_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_STATUS_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_RX_STATUS_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_SCALE_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_RX_SCALE_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_EXTEN_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_RX_EXTEN_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_AEXTEN_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_RX_AEXTEN_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_WSIZE_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_RX_WSIZE_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_AWSIZE_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_RX_AWSIZE_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_FSIZE_ADDR                : 0x%08lx\n", 4*IRI_FT_REG_RX_FSIZE_ADDR);
   fprintf(fptr, "IRI_FT_REG_RX_AFSIZE_ADDR               : 0x%08lx\n", 4*IRI_FT_REG_RX_AFSIZE_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** IRIDIA-QT REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "IRI_QT_REG_TX_CNFG_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_TX_CNFG_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_TCM_CTRL_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_TX_TCM_CTRL_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_MISC_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_TX_MISC_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_LP0_BITS_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_TX_LP0_BITS_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_LP1_BITS_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_TX_LP1_BITS_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_DUMMY_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_TX_DUMMY_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR         : 0x%08lx\n", 4*IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR         : 0x%08lx\n", 4*IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_PILOT_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_TX_PILOT_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_PTINDEX_ADDR              : 0x%08lx\n", 4*IRI_QT_REG_TX_PTINDEX_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_PRBS_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_TX_PRBS_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_PRBS_MISC_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_TX_PRBS_MISC_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_PRBS_POLY_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_TX_PRBS_POLY_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_PRBS_DATA_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_TX_PRBS_DATA_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_REF_GAIN_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_TX_REF_GAIN_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_OS_NYQ_GAIN_ADDR          : 0x%08lx\n", 4*IRI_QT_REG_TX_OS_NYQ_GAIN_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_TBLCP_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_TX_TBLCP_ADDR);
   fprintf(fptr, "IRI_QT_REG_TX_TRTCP_RNG_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_TX_TRTCP_RNG_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "IRI_QT_REG_RX_CNFG_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_RX_CNFG_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_TCM_CTRL_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_RX_TCM_CTRL_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_MISC_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_RX_MISC_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_TONES_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_RX_TONES_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_LP0_BITS_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_RX_LP0_BITS_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_LP1_BITS_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_RX_LP1_BITS_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_DUMMY_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_RX_DUMMY_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR         : 0x%08lx\n", 4*IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR         : 0x%08lx\n", 4*IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_PRBS_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_RX_PRBS_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_PRBS_MISC_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_RX_PRBS_MISC_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_PRBS_POLY_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_RX_PRBS_POLY_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_PRBS_OFFSET_ADDR          : 0x%08lx\n", 4*IRI_QT_REG_RX_PRBS_OFFSET_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_RTV0_PRBS_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_RX_RTV0_PRBS_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_RTV1_PRBS_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_RX_RTV1_PRBS_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_DPRBS_MISC_ADDR           : 0x%08lx\n", 4*IRI_QT_REG_RX_DPRBS_MISC_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_DPRBS_POLY_ADDR           : 0x%08lx\n", 4*IRI_QT_REG_RX_DPRBS_POLY_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_RTV0_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_RX_RTV0_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_RTV1_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_RX_RTV1_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_QUAD_ADDR                 : 0x%08lx\n", 4*IRI_QT_REG_RX_QUAD_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_SLOWDOWN_ADDR             : 0x%08lx\n", 4*IRI_QT_REG_RX_SLOWDOWN_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_PTINDEX_ADDR              : 0x%08lx\n", 4*IRI_QT_REG_RX_PTINDEX_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_PILOT_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_RX_PILOT_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_TBLCP_ADDR                : 0x%08lx\n", 4*IRI_QT_REG_RX_TBLCP_ADDR);
   fprintf(fptr, "IRI_QT_REG_RX_TRTCP_RNG_ADDR            : 0x%08lx\n", 4*IRI_QT_REG_RX_TRTCP_RNG_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** STRYMON CPE 3.1 REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "SVERSION_ADDR                           : 0x%08lx\n", 4*SVERSION_ADDR);
   fprintf(fptr, "SMODE_ADDR                              : 0x%08lx\n", 4*SMODE_ADDR);
   fprintf(fptr, "SCONTROL_ADDR                           : 0x%08lx\n", 4*SCONTROL_ADDR);
   fprintf(fptr, "SCOUNTER_ADDR                           : 0x%08lx\n", 4*SCOUNTER_ADDR);
   fprintf(fptr, "ST_POTSHPF_ADDR                         : 0x%08lx\n", 4*ST_POTSHPF_ADDR);
   fprintf(fptr, "ST_INTERP1_ADDR                         : 0x%08lx\n", 4*ST_INTERP1_ADDR);
   fprintf(fptr, "ST_INTERP3_ADDR                         : 0x%08lx\n", 4*ST_INTERP3_ADDR);
   fprintf(fptr, "ST_INTERP4_ADDR                         : 0x%08lx\n", 4*ST_INTERP4_ADDR);
   fprintf(fptr, "SE_AEC_ADDR                             : 0x%08lx\n", 4*SE_AEC_ADDR);
   fprintf(fptr, "SE_AECDELAY_ADDR                        : 0x%08lx\n", 4*SE_AECDELAY_ADDR);
   fprintf(fptr, "SE_DEC_ADDR                             : 0x%08lx\n", 4*SE_DEC_ADDR);
   fprintf(fptr, "SE_DECDELAY_ADDR                        : 0x%08lx\n", 4*SE_DECDELAY_ADDR);
   fprintf(fptr, "ST_GAINCTL_ADDR                         : 0x%08lx\n", 4*ST_GAINCTL_ADDR);
   fprintf(fptr, "ST_GAINVAL_ADDR                         : 0x%08lx\n", 4*ST_GAINVAL_ADDR);
   fprintf(fptr, "SR_DECIM2_HPF_ADDR                      : 0x%08lx\n", 4*SR_DECIM2_HPF_ADDR);
   fprintf(fptr, "SE_TDQ_ADDR                             : 0x%08lx\n", 4*SE_TDQ_ADDR);
   fprintf(fptr, "SB_SRCFR_ADDR                           : 0x%08lx\n", 4*SB_SRCFR_ADDR);
   fprintf(fptr, "SB_SRCCTL_ADDR                          : 0x%08lx\n", 4*SB_SRCCTL_ADDR);
   fprintf(fptr, "ST_SRCTX_ADDR                           : 0x%08lx\n", 4*ST_SRCTX_ADDR);
   fprintf(fptr, "SR_SRCRX_ADDR                           : 0x%08lx\n", 4*SR_SRCRX_ADDR);
   fprintf(fptr, "SE_DECTRAIN_ADDR                        : 0x%08lx\n", 4*SE_DECTRAIN_ADDR);
   fprintf(fptr, "SE_DECADDR_ADDR                         : 0x%08lx\n", 4*SE_DECADDR_ADDR);
   fprintf(fptr, "SE_DECCOEFF1_ADDR                       : 0x%08lx\n", 4*SE_DECCOEFF1_ADDR);
   fprintf(fptr, "SE_DECCOEFF2_ADDR                       : 0x%08lx\n", 4*SE_DECCOEFF2_ADDR);
   fprintf(fptr, "SR_WINDOW_ADDR                          : 0x%08lx\n", 4*SR_WINDOW_ADDR);
   fprintf(fptr, "SOVERFLOW_ADDR                          : 0x%08lx\n", 4*SOVERFLOW_ADDR);
   fprintf(fptr, "SR_VARGAIN_ADDR                         : 0x%08lx\n", 4*SR_VARGAIN_ADDR);
   fprintf(fptr, "SR_AVARGAIN_ADDR                        : 0x%08lx\n", 4*SR_AVARGAIN_ADDR);
   fprintf(fptr, "SR_DECIM0_ADDR                          : 0x%08lx\n", 4*SR_DECIM0_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** V-STRYMON REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "V_CONTROL_ADDR                          : 0x%08lx\n", 4*V_CONTROL_ADDR);
   fprintf(fptr, "V_OVERFLOW_ADDR                         : 0x%08lx\n", 4*V_OVERFLOW_ADDR);
   fprintf(fptr, "V_TXIIR1_CFG_ADDR                       : 0x%08lx\n", 4*V_TXIIR1_CFG_ADDR);
   fprintf(fptr, "V_TXIIR2_CFG_ADDR                       : 0x%08lx\n", 4*V_TXIIR2_CFG_ADDR);
   fprintf(fptr, "V_RXIIR_CFG_ADDR                        : 0x%08lx\n", 4*V_RXIIR_CFG_ADDR);
   fprintf(fptr, "V_AFE_DECIM_CFG_ADDR                    : 0x%08lx\n", 4*V_AFE_DECIM_CFG_ADDR);
   fprintf(fptr, "V_SRCFR_ADDR                            : 0x%08lx\n", 4*V_SRCFR_ADDR);
   fprintf(fptr, "V_SRCCTL_ADDR                           : 0x%08lx\n", 4*V_SRCCTL_ADDR);
   fprintf(fptr, "V_RESAMP_CFG_ADDR                       : 0x%08lx\n", 4*V_RESAMP_CFG_ADDR);
   fprintf(fptr, "V_DEC_TDQ_CFG_ADDR                      : 0x%08lx\n", 4*V_DEC_TDQ_CFG_ADDR);
   fprintf(fptr, "V_DEC_TRAIN_ADDR                        : 0x%08lx\n", 4*V_DEC_TRAIN_ADDR);
   fprintf(fptr, "V_TX_VARGAIN_ADDR                       : 0x%08lx\n", 4*V_TX_VARGAIN_ADDR);
   fprintf(fptr, "V_TX_AVARGAIN_ADDR                      : 0x%08lx\n", 4*V_TX_AVARGAIN_ADDR);
   fprintf(fptr, "V_RX_VARGAIN_ADDR                       : 0x%08lx\n", 4*V_RX_VARGAIN_ADDR);
   fprintf(fptr, "V_RX_AVARGAIN_ADDR                      : 0x%08lx\n", 4*V_RX_AVARGAIN_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "V_AFE_DECIM_IN_DBG_ADDR                 : 0x%08lx\n", 4*V_AFE_DECIM_IN_DBG_ADDR);
   fprintf(fptr, "V_DECIM_IN_DBG_ADDR                     : 0x%08lx\n", 4*V_DECIM_IN_DBG_ADDR);
   fprintf(fptr, "V_RXIIR_IN_DBG_ADDR                     : 0x%08lx\n", 4*V_RXIIR_IN_DBG_ADDR);
   fprintf(fptr, "V_TDQ_LSB_IN_DBG_ADDR                   : 0x%08lx\n", 4*V_TDQ_LSB_IN_DBG_ADDR);
   fprintf(fptr, "V_DEC_IN_DBG_ADDR                       : 0x%08lx\n", 4*V_DEC_IN_DBG_ADDR);
   fprintf(fptr, "V_TXIIR_IN_DBG_ADDR                     : 0x%08lx\n", 4*V_TXIIR_IN_DBG_ADDR);
   fprintf(fptr, "V_INTERP_IN_DBG_ADDR                    : 0x%08lx\n", 4*V_INTERP_IN_DBG_ADDR);
   fprintf(fptr, "V_INTERP_OUT_DBG_ADDR                   : 0x%08lx\n", 4*V_INTERP_OUT_DBG_ADDR);
   fprintf(fptr, "V_WINDOW_DBG_ADDR                       : 0x%08lx\n", 4*V_WINDOW_DBG_ADDR);
   fprintf(fptr, "V_RXSRC_PHASE_IN_DBG_ADDR               : 0x%08lx\n", 4*V_RXSRC_PHASE_IN_DBG_ADDR);
   fprintf(fptr, "V_TDQ_MSB_IN_DBG_ADDR                   : 0x%08lx\n", 4*V_TDQ_MSB_IN_DBG_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** ZEPHYR-FC REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "ZEP_REG_VERSION_ADDR                    : 0x%08lx\n", 4*ZEP_REG_VERSION_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LINE_ADDR                    : 0x%08lx\n", 4*ZEP_REG_ZT_LINE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP0_CFG_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZT_LP0_CFG_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP1_CFG_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZT_LP1_CFG_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_VBC0_SIZE_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZT_VBC0_SIZE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_VBC1_SIZE_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZT_VBC1_SIZE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_VBC0_IDX_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_VBC0_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_VBC1_IDX_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_VBC1_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FRAME_IDX0_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FRAME_IDX0_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FRAME_IDX1_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FRAME_IDX1_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FRM_BYTE_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_FRM_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CODEWORD_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CODEWORD_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CW_IDX_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_CW_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP0_MP_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_LP0_MP_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP1_MP_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_LP1_MP_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_TP0_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZT_TP0_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_TP1_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZT_TP1_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_SHALF_ADDR                   : 0x%08lx\n", 4*ZEP_REG_ZT_SHALF_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_DZ_MAX_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_DZ_MAX_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_DZ_VAL_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_DZ_VAL_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_DZ_IDX_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_DZ_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_DRS_VAL_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZT_DRS_VAL_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_DRS_IDX_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZT_DRS_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP0_P_ADDR                   : 0x%08lx\n", 4*ZEP_REG_ZT_LP0_P_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP1_P_ADDR                   : 0x%08lx\n", 4*ZEP_REG_ZT_LP1_P_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP0_OHRATE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_LP0_OHRATE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_LP1_OHRATE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_LP1_OHRATE_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ZEP_REG_ZT_EOC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZT_EOC_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_VOC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZT_VOC_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_AOC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZT_AOC_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_SYNC_CTRL_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZT_SYNC_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FIFO0_CTRL_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FIFO0_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FIFO0_BYTE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FIFO0_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FIFO1_CTRL_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FIFO1_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FIFO1_BYTE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FIFO1_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FIFO2_CTRL_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FIFO2_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_FIFO2_BYTE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZT_FIFO2_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_NTR_IBITS_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZT_NTR_IBITS_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_SCR_LO0_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZT_SCR_LO0_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_SCR_LO1_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZT_SCR_LO1_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_SCR_HI_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZT_SCR_HI_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CRC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZT_CRC_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CHECKBYTE_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZT_CHECKBYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_0_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_0_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_1_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_1_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_2_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_2_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_3_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_3_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_4_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_4_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_5_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_5_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_6_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_6_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE0_7_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE0_7_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_0_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_0_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_1_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_1_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_2_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_2_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_3_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_3_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_4_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_4_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_5_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_5_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_6_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_6_ADDR);
   fprintf(fptr, "ZEP_REG_ZT_CBYTE1_7_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZT_CBYTE1_7_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ZEP_REG_ZR_LINE_ADDR                    : 0x%08lx\n", 4*ZEP_REG_ZR_LINE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_LP0_CFG_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZR_LP0_CFG_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_LP1_CFG_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZR_LP1_CFG_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_VBC0_SIZE_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZR_VBC0_SIZE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_VBC1_SIZE_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZR_VBC1_SIZE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_VBC0_IDX_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_VBC0_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_VBC1_IDX_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_VBC1_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FRAME_IDX0_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FRAME_IDX0_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FRAME_IDX1_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FRAME_IDX1_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FRM_BYTE_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_FRM_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_CODEWORD_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_CODEWORD_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ZEP_REG_ZR_LP0_MP_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_LP0_MP_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_LP1_MP_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_LP1_MP_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_MDF_CNT_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZR_MDF_CNT_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_TP0_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZR_TP0_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_TP1_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZR_TP1_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DZ_MAX_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_DZ_MAX_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DZ_VAL_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_DZ_VAL_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DZ_IDX_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_DZ_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DR_VAL_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_DR_VAL_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DR_IDX_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_DR_IDX_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_LP0_OHRATE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_LP0_OHRATE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_LP1_OHRATE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_LP1_OHRATE_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ZEP_REG_ZR_EOC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZR_EOC_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_VOC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZR_VOC_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_AOC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZR_AOC_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FIFO0_CTRL_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FIFO0_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FIFO0_BYTE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FIFO0_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FIFO1_CTRL_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FIFO1_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FIFO1_BYTE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FIFO1_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FIFO2_CTRL_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FIFO2_CTRL_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FIFO2_BYTE_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_FIFO2_BYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DSCR_LO1_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_DSCR_LO1_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DSCR_LO0_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_DSCR_LO0_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DSCR_HI_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZR_DSCR_HI_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_CRC_ADDR                     : 0x%08lx\n", 4*ZEP_REG_ZR_CRC_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_CRC_CNT_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZR_CRC_CNT_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_CHECKBYTE_ADDR               : 0x%08lx\n", 4*ZEP_REG_ZR_CHECKBYTE_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_CW_COUNT_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_CW_COUNT_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FEC1_CNT_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_FEC1_CNT_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_FEC0_CNT_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_FEC0_CNT_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DCUR_CWADR_ADDR              : 0x%08lx\n", 4*ZEP_REG_ZR_DCUR_CWADR_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_RXIB_ADDR                    : 0x%08lx\n", 4*ZEP_REG_ZR_RXIB_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DECSTAT0_LP1_ADDR            : 0x%08lx\n", 4*ZEP_REG_ZR_DECSTAT0_LP1_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DECSTAT1_LP1_ADDR            : 0x%08lx\n", 4*ZEP_REG_ZR_DECSTAT1_LP1_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DECSTAT0_LP0_ADDR            : 0x%08lx\n", 4*ZEP_REG_ZR_DECSTAT0_LP0_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_DECSTAT1_LP0_ADDR            : 0x%08lx\n", 4*ZEP_REG_ZR_DECSTAT1_LP0_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_CW_ERR_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_CW_ERR_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_NTRSRCFR_ADDR                : 0x%08lx\n", 4*ZEP_REG_ZR_NTRSRCFR_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_NTRCNT_ADDR                  : 0x%08lx\n", 4*ZEP_REG_ZR_NTRCNT_ADDR);
   fprintf(fptr, "ZEP_REG_ZR_NTRSTEP_ADDR                 : 0x%08lx\n", 4*ZEP_REG_ZR_NTRSTEP_ADDR);
   fprintf(fptr, "\n");

   fprintf(fptr, "**** ZEPHYR-ILV REGISTER ****\n");
   fprintf(fptr, "\n");
   fprintf(fptr, "ZIT_CONFIG_ADDR                         : 0x%08lx\n", 4*ZIT_CONFIG_ADDR);
   fprintf(fptr, "ZIT_CW_SIZE_ADDR                        : 0x%08lx\n", 4*ZIT_CW_SIZE_ADDR);
   fprintf(fptr, "ZIT_RD_STEP_ADDR                        : 0x%08lx\n", 4*ZIT_RD_STEP_ADDR);
   fprintf(fptr, "ZIT_ILVB_LEVEL_ADDR                     : 0x%08lx\n", 4*ZIT_ILVB_LEVEL_ADDR);
   fprintf(fptr, "ZIT_LEVEL_OFFSET_ADDR                   : 0x%08lx\n", 4*ZIT_LEVEL_OFFSET_ADDR);
   fprintf(fptr, "ZIT_CUR_WADR_ADDR                       : 0x%08lx\n", 4*ZIT_CUR_WADR_ADDR);
   fprintf(fptr, "ZIT_CUR_RADR_ADDR                       : 0x%08lx\n", 4*ZIT_CUR_RADR_ADDR);
   fprintf(fptr, "ZIT_CUR_FWR_IDX_ADDR                    : 0x%08lx\n", 4*ZIT_CUR_FWR_IDX_ADDR);
   fprintf(fptr, "ZIT_CUR_FRD_IDX_ADDR                    : 0x%08lx\n", 4*ZIT_CUR_FRD_IDX_ADDR);
   fprintf(fptr, "ZIT_ILV_WR_BYTES_ADDR                   : 0x%08lx\n", 4*ZIT_ILV_WR_BYTES_ADDR);
   fprintf(fptr, "ZIT_DT_BYTES_ADDR                       : 0x%08lx\n", 4*ZIT_DT_BYTES_ADDR);
   fprintf(fptr, "ZIT_DT_SIZE_ADDR                        : 0x%08lx\n", 4*ZIT_DT_SIZE_ADDR);
   fprintf(fptr, "ZIT_DTB_WR_START_ADDR                   : 0x%08lx\n", 4*ZIT_DTB_WR_START_ADDR);
   fprintf(fptr, "ZIT_DTB_RD_START_ADDR                   : 0x%08lx\n", 4*ZIT_DTB_RD_START_ADDR);
   fprintf(fptr, "ZIT_DTB_RD_LWORDS_ADDR                  : 0x%08lx\n", 4*ZIT_DTB_RD_LWORDS_ADDR);
   fprintf(fptr, "\n");
   fprintf(fptr, "ZIR_CONFIG_ADDR                         : 0x%08lx\n", 4*ZIR_CONFIG_ADDR);
   fprintf(fptr, "ZIR_CW_SIZE_ADDR                        : 0x%08lx\n", 4*ZIR_CW_SIZE_ADDR);
   fprintf(fptr, "ZIR_WR_STEP_ADDR                        : 0x%08lx\n", 4*ZIR_WR_STEP_ADDR);
   fprintf(fptr, "ZIR_DILVB_LEVEL_ADDR                    : 0x%08lx\n", 4*ZIR_DILVB_LEVEL_ADDR);
   fprintf(fptr, "ZIR_LEVEL_OFFSET_ADDR                   : 0x%08lx\n", 4*ZIR_LEVEL_OFFSET_ADDR);
   fprintf(fptr, "ZIR_DILVB_AVAIL_ADDR                    : 0x%08lx\n", 4*ZIR_DILVB_AVAIL_ADDR);
   fprintf(fptr, "ZIR_CUR_WADR_ADDR                       : 0x%08lx\n", 4*ZIR_CUR_WADR_ADDR);
   fprintf(fptr, "ZIR_CUR_RADR_ADDR                       : 0x%08lx\n", 4*ZIR_CUR_RADR_ADDR);
   fprintf(fptr, "ZIR_CUR_FWR_IDX_ADDR                    : 0x%08lx\n", 4*ZIR_CUR_FWR_IDX_ADDR);
   fprintf(fptr, "ZIR_CUR_FRD_IDX_ADDR                    : 0x%08lx\n", 4*ZIR_CUR_FRD_IDX_ADDR);
   fprintf(fptr, "ZIR_DILV_RD_BYTES_ADDR                  : 0x%08lx\n", 4*ZIR_DILV_RD_BYTES_ADDR);
   fprintf(fptr, "ZIR_DT_BYTES_ADDR                       : 0x%08lx\n", 4*ZIR_DT_BYTES_ADDR);
   fprintf(fptr, "ZIR_DT_SIZE_ADDR                        : 0x%08lx\n", 4*ZIR_DT_SIZE_ADDR);
   fprintf(fptr, "ZIR_DTB_WR_START_ADDR                   : 0x%08lx\n", 4*ZIR_DTB_WR_START_ADDR);
   fprintf(fptr, "ZIR_DTB_RD_START_ADDR                   : 0x%08lx\n", 4*ZIR_DTB_RD_START_ADDR);
   fprintf(fptr, "ZIR_DTB_WR_LWORDS_ADDR                  : 0x%08lx\n", 4*ZIR_DTB_WR_LWORDS_ADDR);

   fclose(fptr);

   exit(0);
}
